﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data;
using System.Web.UI.HtmlControls;

public partial class A_Detail_Detail : PageBase
{
    private static int currentPageNum = 1;//当前页数
    private static int pageCount = 1;//总页数
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!this.Page.IsPostBack)
        {
            //OfficeManage.BindDdlProject(ddlProject);//绑定项目
            BindRptDetail();
            BindCount();
        }
    }
    #region 功能栏事件（全部、支出、收入、转账、借贷按钮）
    protected void btnAllDetail_Click(object sender, EventArgs e)//全部明细
    {
        Response.Redirect("Detail.aspx");
    }
    protected void btnExpenditure_Click(object sender, EventArgs e)//支出明细
    {
        Response.Redirect("Detail_Expenditure.aspx");
    }
    protected void btnIncome_Click(object sender, EventArgs e)//收入明细
    {
        Response.Redirect("Detail_Income.aspx");
    }
    protected void btnTransfer_Click(object sender, EventArgs e)//转账明细
    {
        Response.Redirect("Detail_Transfer.aspx");
    }
    protected void btnLoan_Click(object sender, EventArgs e)//借贷明细
    {
        Response.Redirect("Detail_Loan.aspx");
    }
    #endregion
    #region 绑定支出、收入总额
    /// <summary>
    /// 绑定支出、收入总额
    /// </summary>
    public void BindCount()
    {
        #region 支出总额
        double expenditureCount = 0.00;//查询的支出总额
        DataSet dsExpenditure = SqlHelper.GetDataSet(StrWhere + " AND RecordType=1", "constring");
        if (dsExpenditure.Tables[0].Rows.Count > 0)
        {
            for (int i = 0; i < dsExpenditure.Tables[0].Rows.Count; i++)
            {
                expenditureCount += ConvertHelper.GetDouble(dsExpenditure.Tables[0].Rows[i]["RecordMoney"]);
            }
        }
        spanExpenditureCount.InnerHtml ="￥"+ConvertHelper.GetString(expenditureCount);//支出总额
        #endregion
        #region 收入总额
        double incomeCount = 0.00;//查询的收入总额
        DataSet dsIncome = SqlHelper.GetDataSet(StrWhere + " AND RecordType=2", "constring");
        if (dsIncome.Tables[0].Rows.Count > 0)
        {
            for (int i = 0; i < dsIncome.Tables[0].Rows.Count; i++)
            {
                incomeCount += ConvertHelper.GetDouble(dsIncome.Tables[0].Rows[i]["RecordMoney"]);
            }
        }
        spanIncomeCount.InnerHtml ="￥"+ConvertHelper.GetString(incomeCount);//收入总额
        #endregion
    }
    #endregion 
    #region  获取类型名（1-支出，2-收入，3-转账，4-借贷）
    /// <summary>
    /// 获取类型名（1-支出，2-收入，3-转账，4-借贷）
    /// </summary>
    /// <param name="RecordId"></param>
    /// <returns></returns>
    public string GetRecordTypeName(object RecordId)
    {
        string recordTypeName = "";
        switch (ConvertHelper.GetInteger(RecordId))
        {
            case 1:
                recordTypeName= "支出";
                break;
            case 2:
                recordTypeName = "收入";
                break;
            case 3:
                recordTypeName = "转账";
                break;
            case 4:
                recordTypeName = "借贷";
                break;
            default:
                recordTypeName = "";
                break;
        }
        return recordTypeName;
    }
    #endregion
    #region 绑定全部明细
    /// <summary>
    /// 绑定全部明细
    /// </summary>
    public void BindRptDetail()
    {
        pageCount = GetPageCount();//总页数
        spanPageCount.InnerHtml = ConvertHelper.GetString(pageCount);//总页数
        //SetStrWhere();
        ControlHelper.BindRepeater(this.rptDetail, "constring", StrWhere + "AND Row BETWEEN (" + currentPageNum + "-1)*15+1 AND " + currentPageNum + "*15 ");
    }
    #endregion
    protected void rptDetail_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        int recordType = ConvertHelper.GetInteger((e.Item.FindControl("hfRecordType") as HiddenField).Value);//记账类型（1-支出，2-收入，3-转账，4-借贷）
        int recordId = ConvertHelper.GetInteger((e.Item.FindControl("hfRecordId") as HiddenField).Value);//明细id
        if (e.CommandName == "edit")//编辑
        {
            if(recordType==1)//支出
            {
                Response.Redirect("ExpenditureInfo.aspx?deiid=" + recordId + "");
            }
            else if(recordType==2)//收入
            {
                Response.Redirect("IncomeInfo.aspx?riid=" + recordId + "");
            }
            else if(recordType==3)//转账
            {
                Response.Redirect("TransferInfo.aspx?tiid=" + recordId + "");
            }
            else if(recordType==4)//借贷
            {
                Response.Redirect("LoanInfo.aspx?liid=" + recordId + "");
            }
        }
        else if (e.CommandName == "delete")//删除
        {
            int flag = SqlHelper.Operation("UPDATE V_Detail SET State=0 WHERE RecordType=" + recordType + " AND RecordId="+recordId+"", "constring");
            if (flag > 0)
            {
                BindRptDetail();
            }
            else
            {
                ScriptHelper.AlertMessage(this.Page,"删除失败，请联系管理员！");
            }
        }
    }
    protected void rptDetail_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        #region 绑定支出、收入、转账、借贷金额颜色
        int RecordType = ConvertHelper.GetInteger((e.Item.FindControl("hfRecordType") as HiddenField).Value);//明细类型（1-支出，2-收入，3-转账，4-借贷）
        if (RecordType == 1)//支出
        {
            (e.Item.FindControl("spanMoney") as HtmlGenericControl).Style["color"] = "red";//红色
        }
        else if (RecordType == 2)//收入
        {
            (e.Item.FindControl("spanMoney") as HtmlGenericControl).Style["color"] = "green";//绿色
        }
        else if (RecordType == 3)//转账
        {
            (e.Item.FindControl("spanMoney") as HtmlGenericControl).Style["color"] = "blue";//蓝色
        }
        else if (RecordType == 4)//借贷
        {
            (e.Item.FindControl("spanMoney") as HtmlGenericControl).Style["color"] = "orange";//橙色
        }
        #endregion
    }
    #region 分页
    #region 获取分页总页数
    /// <summary>
    /// 获取分页总页数
    /// </summary>
    /// <returns></returns>
    public int GetPageCount()
    {
        int pagecount = 0;//总页数
        SetStrWhere();
        DataSet ds = SqlHelper.GetDataSet(StrWhere, "constring");
        if (ds.Tables[0].Rows.Count > 0)
        {
            int loanAccountCount = ConvertHelper.GetInteger(ds.Tables[0].Rows.Count);//借贷用户总个数
            if (loanAccountCount % 15 == 0)
            {
                pagecount = loanAccountCount / 15;
            }
            else
            {
                pagecount = loanAccountCount / 15 + 1;
            }
        }
        else
        {
            pagecount = 1;
        }
        return pagecount;
    }
    #endregion
    #region 首页
    protected void lbtnPageFirst_Click(object sender, EventArgs e)//首页
    {
        currentPageNum = 1;
        BindRptDetail();
        spanPageCurrent.InnerHtml = "1";//当前页为1
    }
    #endregion
    #region 上页
    protected void lbtnPageUp_Click(object sender, EventArgs e)//上页
    {
        if (spanPageCurrent.InnerHtml != "1")//不是首页时
        {
            currentPageNum = ConvertHelper.GetInteger(spanPageCurrent.InnerHtml) - 1;
            BindRptDetail();
            spanPageCurrent.InnerHtml = ConvertHelper.GetString(currentPageNum);//当前页spanPageCurrent赋值
        }
    }
    #endregion
    #region 下页
    protected void lbtnPageDown_Click(object sender, EventArgs e)//下页
    {
        if (spanPageCurrent.InnerHtml != ConvertHelper.GetString(pageCount))//不是尾页时
        {
            currentPageNum = ConvertHelper.GetInteger(spanPageCurrent.InnerHtml) + 1;
            BindRptDetail();
            spanPageCurrent.InnerHtml = ConvertHelper.GetString(currentPageNum);//当前页spanPageCurrent赋值
        }
    }
    #endregion
    #region 末页
    protected void lbtnPageLast_Click(object sender, EventArgs e)//末页
    {
        currentPageNum = GetPageCount();
        BindRptDetail();
        spanPageCurrent.InnerHtml = ConvertHelper.GetString(pageCount);//当前页等于总页数
    }
    #endregion
    #endregion
    #region 查询sql语句属性
    /// <summary>
    /// 查询sql语句属性
    /// </summary>
    public string StrWhere
    {
        get { return Convert.ToString(ViewState["StrWhere"]); }
        set { ViewState["StrWhere"] = value; }
    }
    /// <summary>
    /// 修改sql语句属性的方法
    /// </summary>
    public void SetStrWhere()
    {
        StringBuilder strb = new StringBuilder();
        //V_Detail视图：全部明细视图
        strb.Append("SELECT * FROM (SELECT ROW_NUMBER() OVER(ORDER BY RecordTime DESC) AS Row,RecordType,RecordId,RecordTime,RecordMoney,AccountTypeId,AccountId,RConcreteTypeName,RecordSellerName,AccountName,RecordRemarks FROM dbo.V_Detail) AS temptable  WHERE 1=1 ");
        if (ConvertHelper.GetDateTime(txtStateTime) < ConvertHelper.GetDateTime(txtEndTime.Text.Trim()))//如果开始时间小于最后时间(即正常情况)
        {
            strb.Append(" AND (RecordTime>='" + ConvertHelper.GetDateTime(txtStateTime.Text.Trim()) + "' AND RecordTime<='" + ConvertHelper.GetDateTime(txtEndTime.Text.Trim()) + "') ");
        }
        else//非正常情况（则执行查询本月支出明细）
        {
            txtStateTime.Text = ConvertHelper.GetString(System.DateTime.Now.ToString("yyyy-MM") + "-01");//开始查询时间赋为本月1号
            txtEndTime.Text = ConvertHelper.GetString(System.DateTime.Now.ToString("yyyy-MM-dd"));//结束查询时间赋为查询那天
            strb.Append(" AND RecordTime BETWEEN '" + ConvertHelper.GetDateTime(txtStateTime.Text.Trim()) + "' AND '" + ConvertHelper.GetDateTime(txtEndTime.Text.Trim()) + "' ");
        }
        if (uclAccount.AccountTypeID != 0)//账户类型不为空
        {
            if (uclAccount.CashAccountID != 0)//现金账户不为空
            {
                strb.Append(" AND AccountTypeId=" + uclAccount.AccountTypeID + " AND AccountId=" + uclAccount.CashAccountID + " ");
            }
            else if (uclAccount.CreditCardID != 0)//信用卡不为空
            {
                strb.Append(" AND AccountTypeId=" + uclAccount.AccountTypeID + " AND AccountId=" + uclAccount.CreditCardID + " ");
            }
            else if (uclAccount.SavingsCardID != 0)//储蓄卡不为空
            {
                strb.Append(" AND AccountTypeId=" + uclAccount.AccountTypeID + " AND AccountId=" + uclAccount.CreditCardID + " ");
            }
            else if (uclAccount.OnlinePayID != 0)//网上支付不为空
            {
                strb.Append(" AND AccountTypeId=" + uclAccount.AccountTypeID + " AND AccountId=" + uclAccount.CreditCardID + " ");
            }
        }
        StrWhere = strb.ToString();
    }
    #endregion
    protected void btnSelect_Click(object sender, EventArgs e)//查询时间
    {
        BindRptDetail();
        BindCount();
    }
}