package app.api

import app.models.document.DocumentEntity
import app.models.document.TaskEntity
import app.models.document.DocumentPermissionAndPlacement
import app.models.user.User
import boopickle.Default._
import hydro.api.StandardPicklers
import hydro.models.Entity
import hydro.models.UpdatableEntity.LastUpdateTime

object Picklers extends StandardPicklers {

  // Pickler that does the same as an autogenerated User pickler, except that it redacts the user's password
  implicit object UserPickler extends Pickler[User] {
    override def pickle(user: User)(implicit state: PickleState): Unit = logExceptions {
      state.pickle(user.loginName)
      // Password redacted
      state.pickle(user.name)
      state.pickle(user.isAdmin)
      state.pickle(user.idOption)
      state.pickle(user.lastUpdateTime)
    }
    override def unpickle(implicit state: UnpickleState): User = logExceptions {
      User(
        loginName = state.unpickle[String],
        passwordHash = "<redacted>",
        name = state.unpickle[String],
        isAdmin = state.unpickle[Boolean],
        idOption = state.unpickle[Option[Long]],
        lastUpdateTime = state.unpickle[LastUpdateTime],
      )
    }
  }

  override implicit val entityPickler: Pickler[Entity] = compositePickler[Entity]
    .addConcreteType[User]
    .addConcreteType[DocumentEntity]
    .addConcreteType[TaskEntity]
    .addConcreteType[DocumentPermissionAndPlacement]
}
