import { Tree, readJson, updateJson } from '@nx/devkit';
import * as devkit from '@nx/devkit';
import { createTreeWithEmptyWorkspace } from '@nx/devkit/testing';
import replacePackage from './update-16-0-0-add-nx-packages';

describe('update-16-0-0-add-nx-packages', () => {
  let tree: Tree;
  beforeEach(() => {
    tree = createTreeWithEmptyWorkspace();
    jest
      .spyOn(devkit, 'formatFiles')
      .mockImplementation(() => Promise.resolve());

    updateJson(tree, 'package.json', (json) => {
      json.devDependencies['@nrwl/angular'] = '16.0.0';
      return json;
    });
  });

  it('should remove the dependency on @nrwl/angular', async () => {
    await replacePackage(tree);

    expect(
      readJson(tree, 'package.json').dependencies['@nrwl/angular']
    ).not.toBeDefined();
    expect(
      readJson(tree, 'package.json').devDependencies['@nrwl/angular']
    ).not.toBeDefined();
  });

  it('should add a dependency on @nx/angular', async () => {
    await replacePackage(tree);

    const packageJson = readJson(tree, 'package.json');
    const newDependencyVersion =
      packageJson.devDependencies['@nx/angular'] ??
      packageJson.dependencies['@nx/angular'];

    expect(newDependencyVersion).toBeDefined();
  });
});
