import {
  CloudArrowDownIcon,
  DocumentMagnifyingGlassIcon,
  DocumentPlusIcon,
  ShareIcon,
  Squares2X2Icon,
} from '@heroicons/react/24/outline';
import Link from 'next/link';
import { ReactNode } from 'react';

export function Personas({ children }: { children: ReactNode }): JSX.Element {
  return (
    <div className="my-8 grid grid-cols-1 gap-4 md:grid-cols-2">{children}</div>
  );
}

type PersonaType =
  | 'create'
  | 'share'
  | 'extend'
  | 'browse'
  | 'cache'
  | 'distribute'
  | 'javascript'
  | 'lerna'
  | 'node'
  | 'react'
  | 'angular'
  | 'integrated';
const typeMap: Record<
  PersonaType,
  {
    image: JSX.Element;
  }
> = {
  cache: {
    image: <CloudArrowDownIcon role="img" className="h-6 w-6" />,
  },
  distribute: {
    image: <Squares2X2Icon role="img" className="h-6 w-6" />,
  },
  javascript: {
    image: (
      <svg
        role="img"
        viewBox="0 0 24 24"
        xmlns="http://www.w3.org/2000/svg"
        fill="currentColor"
        className="h-6 w-6"
      >
        {/*JAVASCRIPT*/}
        <path d="M0 0h24v24H0V0zm22.034 18.276c-.175-1.095-.888-2.015-3.003-2.873-.736-.345-1.554-.585-1.797-1.14-.091-.33-.105-.51-.046-.705.15-.646.915-.84 1.515-.66.39.12.75.42.976.9 1.034-.676 1.034-.676 1.755-1.125-.27-.42-.404-.601-.586-.78-.63-.705-1.469-1.065-2.834-1.034l-.705.089c-.676.165-1.32.525-1.71 1.005-1.14 1.291-.811 3.541.569 4.471 1.365 1.02 3.361 1.244 3.616 2.205.24 1.17-.87 1.545-1.966 1.41-.811-.18-1.26-.586-1.755-1.336l-1.83 1.051c.21.48.45.689.81 1.109 1.74 1.756 6.09 1.666 6.871-1.004.029-.09.24-.705.074-1.65l.046.067zm-8.983-7.245h-2.248c0 1.938-.009 3.864-.009 5.805 0 1.232.063 2.363-.138 2.711-.33.689-1.18.601-1.566.48-.396-.196-.597-.466-.83-.855-.063-.105-.11-.196-.127-.196l-1.825 1.125c.305.63.75 1.172 1.324 1.517.855.51 2.004.675 3.207.405.783-.226 1.458-.691 1.811-1.411.51-.93.402-2.07.397-3.346.012-2.054 0-4.109 0-6.179l.004-.056z" />
      </svg>
    ),
  },
  integrated: {
    image: (
      <div className="space-y-4">
        <svg
          role="img"
          viewBox="0 0 24 24"
          xmlns="http://www.w3.org/2000/svg"
          fill="currentColor"
          className="h-6 w-6"
        >
          {/*NODEJS*/}
          <path d="M11.998,24c-0.321,0-0.641-0.084-0.922-0.247l-2.936-1.737c-0.438-0.245-0.224-0.332-0.08-0.383 c0.585-0.203,0.703-0.25,1.328-0.604c0.065-0.037,0.151-0.023,0.218,0.017l2.256,1.339c0.082,0.045,0.197,0.045,0.272,0l8.795-5.076 c0.082-0.047,0.134-0.141,0.134-0.238V6.921c0-0.099-0.053-0.192-0.137-0.242l-8.791-5.072c-0.081-0.047-0.189-0.047-0.271,0 L3.075,6.68C2.99,6.729,2.936,6.825,2.936,6.921v10.15c0,0.097,0.054,0.189,0.139,0.235l2.409,1.392 c1.307,0.654,2.108-0.116,2.108-0.89V7.787c0-0.142,0.114-0.253,0.256-0.253h1.115c0.139,0,0.255,0.112,0.255,0.253v10.021 c0,1.745-0.95,2.745-2.604,2.745c-0.508,0-0.909,0-2.026-0.551L2.28,18.675c-0.57-0.329-0.922-0.945-0.922-1.604V6.921 c0-0.659,0.353-1.275,0.922-1.603l8.795-5.082c0.557-0.315,1.296-0.315,1.848,0l8.794,5.082c0.57,0.329,0.924,0.944,0.924,1.603 v10.15c0,0.659-0.354,1.273-0.924,1.604l-8.794,5.078C12.643,23.916,12.324,24,11.998,24z M19.099,13.993 c0-1.9-1.284-2.406-3.987-2.763c-2.731-0.361-3.009-0.548-3.009-1.187c0-0.528,0.235-1.233,2.258-1.233 c1.807,0,2.473,0.389,2.747,1.607c0.024,0.115,0.129,0.199,0.247,0.199h1.141c0.071,0,0.138-0.031,0.186-0.081 c0.048-0.054,0.074-0.123,0.067-0.196c-0.177-2.098-1.571-3.076-4.388-3.076c-2.508,0-4.004,1.058-4.004,2.833 c0,1.925,1.488,2.457,3.895,2.695c2.88,0.282,3.103,0.703,3.103,1.269c0,0.983-0.789,1.402-2.642,1.402 c-2.327,0-2.839-0.584-3.011-1.742c-0.02-0.124-0.126-0.215-0.253-0.215h-1.137c-0.141,0-0.254,0.112-0.254,0.253 c0,1.482,0.806,3.248,4.655,3.248C17.501,17.007,19.099,15.91,19.099,13.993z" />
        </svg>
        <svg
          role="img"
          viewBox="0 0 24 24"
          xmlns="http://www.w3.org/2000/svg"
          fill="currentColor"
          className="h-6 w-6"
        >
          <title>React</title>
          <path d="M14.23 12.004a2.236 2.236 0 0 1-2.235 2.236 2.236 2.236 0 0 1-2.236-2.236 2.236 2.236 0 0 1 2.235-2.236 2.236 2.236 0 0 1 2.236 2.236zm2.648-10.69c-1.346 0-3.107.96-4.888 2.622-1.78-1.653-3.542-2.602-4.887-2.602-.41 0-.783.093-1.106.278-1.375.793-1.683 3.264-.973 6.365C1.98 8.917 0 10.42 0 12.004c0 1.59 1.99 3.097 5.043 4.03-.704 3.113-.39 5.588.988 6.38.32.187.69.275 1.102.275 1.345 0 3.107-.96 4.888-2.624 1.78 1.654 3.542 2.603 4.887 2.603.41 0 .783-.09 1.106-.275 1.374-.792 1.683-3.263.973-6.365C22.02 15.096 24 13.59 24 12.004c0-1.59-1.99-3.097-5.043-4.032.704-3.11.39-5.587-.988-6.38-.318-.184-.688-.277-1.092-.278zm-.005 1.09v.006c.225 0 .406.044.558.127.666.382.955 1.835.73 3.704-.054.46-.142.945-.25 1.44-.96-.236-2.006-.417-3.107-.534-.66-.905-1.345-1.727-2.035-2.447 1.592-1.48 3.087-2.292 4.105-2.295zm-9.77.02c1.012 0 2.514.808 4.11 2.28-.686.72-1.37 1.537-2.02 2.442-1.107.117-2.154.298-3.113.538-.112-.49-.195-.964-.254-1.42-.23-1.868.054-3.32.714-3.707.19-.09.4-.127.563-.132zm4.882 3.05c.455.468.91.992 1.36 1.564-.44-.02-.89-.034-1.345-.034-.46 0-.915.01-1.36.034.44-.572.895-1.096 1.345-1.565zM12 8.1c.74 0 1.477.034 2.202.093.406.582.802 1.203 1.183 1.86.372.64.71 1.29 1.018 1.946-.308.655-.646 1.31-1.013 1.95-.38.66-.773 1.288-1.18 1.87-.728.063-1.466.098-2.21.098-.74 0-1.477-.035-2.202-.093-.406-.582-.802-1.204-1.183-1.86-.372-.64-.71-1.29-1.018-1.946.303-.657.646-1.313 1.013-1.954.38-.66.773-1.286 1.18-1.868.728-.064 1.466-.098 2.21-.098zm-3.635.254c-.24.377-.48.763-.704 1.16-.225.39-.435.782-.635 1.174-.265-.656-.49-1.31-.676-1.947.64-.15 1.315-.283 2.015-.386zm7.26 0c.695.103 1.365.23 2.006.387-.18.632-.405 1.282-.66 1.933-.2-.39-.41-.783-.64-1.174-.225-.392-.465-.774-.705-1.146zm3.063.675c.484.15.944.317 1.375.498 1.732.74 2.852 1.708 2.852 2.476-.005.768-1.125 1.74-2.857 2.475-.42.18-.88.342-1.355.493-.28-.958-.646-1.956-1.1-2.98.45-1.017.81-2.01 1.085-2.964zm-13.395.004c.278.96.645 1.957 1.1 2.98-.45 1.017-.812 2.01-1.086 2.964-.484-.15-.944-.318-1.37-.5-1.732-.737-2.852-1.706-2.852-2.474 0-.768 1.12-1.742 2.852-2.476.42-.18.88-.342 1.356-.494zm11.678 4.28c.265.657.49 1.312.676 1.948-.64.157-1.316.29-2.016.39.24-.375.48-.762.705-1.158.225-.39.435-.788.636-1.18zm-9.945.02c.2.392.41.783.64 1.175.23.39.465.772.705 1.143-.695-.102-1.365-.23-2.006-.386.18-.63.406-1.282.66-1.933zM17.92 16.32c.112.493.2.968.254 1.423.23 1.868-.054 3.32-.714 3.708-.147.09-.338.128-.563.128-1.012 0-2.514-.807-4.11-2.28.686-.72 1.37-1.536 2.02-2.44 1.107-.118 2.154-.3 3.113-.54zm-11.83.01c.96.234 2.006.415 3.107.532.66.905 1.345 1.727 2.035 2.446-1.595 1.483-3.092 2.295-4.11 2.295-.22-.005-.406-.05-.553-.132-.666-.38-.955-1.834-.73-3.703.054-.46.142-.944.25-1.438zm4.56.64c.44.02.89.034 1.345.034.46 0 .915-.01 1.36-.034-.44.572-.895 1.095-1.345 1.565-.455-.47-.91-.993-1.36-1.565z" />
        </svg>
      </div>
    ),
  },
  lerna: {
    image: (
      <div className="space-y-4">
        <svg
          role="img"
          viewBox="0 0 24 24"
          xmlns="http://www.w3.org/2000/svg"
          fill="currentColor"
          className="h-6 w-6"
        >
          {/*YARN*/}
          <path d="M12 0C5.375 0 0 5.375 0 12s5.375 12 12 12 12-5.375 12-12S18.625 0 12 0zm.768 4.105c.183 0 .363.053.525.157.125.083.287.185.755 1.154.31-.088.468-.042.551-.019.204.056.366.19.463.375.477.917.542 2.553.334 3.605-.241 1.232-.755 2.029-1.131 2.576.324.329.778.899 1.117 1.825.278.774.31 1.478.273 2.015a5.51 5.51 0 0 0 .602-.329c.593-.366 1.487-.917 2.553-.931.714-.009 1.269.445 1.353 1.103a1.23 1.23 0 0 1-.945 1.362c-.649.158-.95.278-1.821.843-1.232.797-2.539 1.242-3.012 1.39a1.686 1.686 0 0 1-.704.343c-.737.181-3.266.315-3.466.315h-.046c-.783 0-1.214-.241-1.45-.491-.658.329-1.51.19-2.122-.134a1.078 1.078 0 0 1-.58-1.153 1.243 1.243 0 0 1-.153-.195c-.162-.25-.528-.936-.454-1.946.056-.723.556-1.367.88-1.71a5.522 5.522 0 0 1 .408-2.256c.306-.727.885-1.348 1.32-1.737-.32-.537-.644-1.367-.329-2.21.227-.602.412-.936.82-1.08h-.005c.199-.074.389-.153.486-.259a3.418 3.418 0 0 1 2.298-1.103c.037-.093.079-.185.125-.283.31-.658.639-1.029 1.024-1.168a.94.94 0 0 1 .328-.06zm.006.7c-.507.016-1.001 1.519-1.001 1.519s-1.27-.204-2.266.871c-.199.218-.468.334-.746.44-.079.028-.176.023-.417.672-.371.991.625 2.094.625 2.094s-1.186.839-1.626 1.881c-.486 1.144-.338 2.261-.338 2.261s-.843.732-.899 1.487c-.051.663.139 1.2.343 1.515.227.343.51.176.51.176s-.561.653-.037.931c.477.25 1.283.394 1.71-.037.31-.31.371-1.001.486-1.283.028-.065.12.111.209.199.097.093.264.195.264.195s-.755.324-.445 1.066c.102.246.468.403 1.066.398.222-.005 2.664-.139 3.313-.296.375-.088.505-.283.505-.283s1.566-.431 2.998-1.357c.917-.598 1.293-.76 2.034-.936.612-.148.57-1.098-.241-1.084-.839.009-1.575.44-2.196.825-1.163.718-1.742.672-1.742.672l-.018-.032c-.079-.13.371-1.293-.134-2.678-.547-1.515-1.413-1.881-1.344-1.997.297-.5 1.038-1.297 1.334-2.78.176-.899.13-2.377-.269-3.151-.074-.144-.732.241-.732.241s-.616-1.371-.788-1.483a.271.271 0 0 0-.157-.046z" />
        </svg>
        <svg
          role="img"
          viewBox="0 0 24 24"
          xmlns="http://www.w3.org/2000/svg"
          fill="currentColor"
          className="h-6 w-6"
        >
          {/*LERNA*/}
          <path d="M18.218 20.493c-.056 0-.061-.026-.015-.128.04-.088.04-.15.005-.18-.036-.036-.103-.026-.2.026a.707.707 0 01-.231.077c-.047 0-.14-.067-.211-.144a2.643 2.643 0 00-.365-.313 1.749 1.749 0 01-.374-.38 1.636 1.636 0 00-.247-.298c-.061-.057-.195-.087-.334-.087-.143 0-.267-.036-.328-.093-.098-.087-.103-.087-.072.144l.03.231-.148-.17a.48.48 0 01-.15-.364c0-.144.037-.226.124-.313.072-.067.16-.103.205-.088.057.021.083-.005.083-.097 0-.077-.031-.129-.077-.129-.052 0-.077-.05-.077-.174 0-.093-.026-.247-.057-.334-.03-.087-.077-.159-.097-.159-.026 0-.057.026-.077.051-.016.031-.057.041-.083.02-.03-.02-.036-.153-.015-.333.026-.205.015-.329-.026-.38-.036-.041-.097-.062-.143-.041-.067.026-.072 0-.047-.144.02-.097.047-.262.062-.364.026-.17.015-.195-.092-.216a4.475 4.475 0 00-.324-.056 2.61 2.61 0 01-.436-.113 3.828 3.828 0 01-.647-.36c-.226-.154-.447-.308-.483-.349-.036-.041-.082-.077-.108-.077-.026 0-.123.072-.22.16-.093.086-.19.22-.206.297-.02.077-.051.241-.072.37-.026.154-.062.23-.113.23-.041 0-.103-.081-.139-.179a1.773 1.773 0 01-.066-.436c0-.14-.052-.355-.103-.478a2.501 2.501 0 00-.21-.375.738.738 0 00-.242-.205c-.072-.026-.318-.052-.544-.057a3.849 3.849 0 00-.724.062c-.17.036-.385.118-.478.18l-.17.113.165.03c.087.02.22.031.288.031.082 0 .205.077.344.226.118.123.267.241.328.262.062.02.144.118.19.22.041.104.067.222.052.263-.026.061-.041.061-.124-.01a.318.318 0 00-.174-.083c-.062 0-.093.098-.139.406-.046.334-.046.442.016.616a1.8 1.8 0 00.246.437c.098.128.308.308.488.405.174.098.375.195.452.216.108.026.205-.005.431-.149.267-.164.313-.18.524-.139.138.026.267.088.318.154a.411.411 0 01.093.16c0 .025-.041.025-.098-.006a.458.458 0 00-.185-.05c-.046 0-.067.02-.051.05.015.031.072.052.123.052.051 0 .164.036.252.082.087.046.205.139.267.21.056.072.102.2.102.278 0 .077-.02.149-.046.149s-.056-.031-.072-.072c-.015-.041-.077-.098-.133-.129-.088-.046-.113-.036-.185.103-.062.118-.067.175-.026.226.031.036.052.18.041.313-.01.139-.046.252-.082.267-.036.01-.067-.02-.067-.072a.38.38 0 00-.046-.17c-.04-.066-.061-.06-.144.011a.367.367 0 01-.195.087.5.5 0 01-.226-.087 3.195 3.195 0 00-.451-.23 4.115 4.115 0 01-.596-.324c-.149-.103-.36-.2-.467-.21-.16-.021-.221-.006-.298.081a.408.408 0 01-.257.113c-.087 0-.128.016-.092.031.036.015.061.046.061.072 0 .026-.03.046-.072.046-.04 0-.128-.046-.205-.108-.108-.087-.134-.149-.134-.328 0-.134.031-.247.077-.288.057-.046.062-.082.026-.128-.03-.036-.051-.082-.046-.108a.415.415 0 000-.113c-.005-.046-.062-.062-.175-.051-.138.015-.17 0-.185-.093a.35.35 0 00-.077-.164.47.47 0 00-.19-.077 1.657 1.657 0 01-.24-.062c-.062-.02-.13-.082-.145-.133-.015-.057-.005-.134.031-.175.036-.04.093-.072.134-.072.04 0 .072-.04.072-.097 0-.052-.077-.154-.165-.221a.947.947 0 00-.467-.16 1.8 1.8 0 01-.39-.081c-.052-.026-.103-.036-.124-.016a.239.239 0 00-.03.123.64.64 0 01-.057.216.558.558 0 01-.23.216c-.093.051-.186.077-.206.061-.016-.015-.005-.077.025-.133a.473.473 0 00.057-.185c0-.046-.03-.082-.062-.082a.787.787 0 00-.215.077 1.042 1.042 0 01-.385.082 9.4 9.4 0 01-.53-.005c-.164-.005-.318.005-.349.02-.03.016-.05.108-.05.206 0 .103-.088.339-.211.58-.144.277-.283.462-.437.58-.123.098-.226.19-.226.206 0 .015.046.046.103.061.056.016.103.005.103-.02 0-.026.025-.046.056-.046.03 0 .139-.057.241-.129a.746.746 0 01.375-.128c.113 0 .242.04.324.108.082.061.133.159.133.23 0 .124 0 .124-.138.037l-.139-.093.036.129c.02.071.046.149.051.18.01.03.052.128.093.225.04.098.066.216.051.267a.367.367 0 01-.092.15c-.052.04-.077.015-.124-.109-.051-.154-.061-.159-.123-.072-.046.067-.108.088-.205.067-.118-.02-.139-.01-.129.082.005.062.005.15 0 .2-.005.052-.046.093-.107.093-.077 0-.103-.036-.103-.128 0-.072-.02-.129-.041-.129-.02 0-.067.026-.103.062-.046.046-.108.046-.267 0-.113-.036-.236-.103-.272-.149a1.749 1.749 0 00-.272-.247c-.175-.133-.226-.148-.334-.107a6.272 6.272 0 01-.74.123c-.58.056-.631.056-1.011-.046a8.018 8.018 0 01-.652-.2 2.732 2.732 0 01-.483-.257 1.525 1.525 0 01-.334-.303 7.145 7.145 0 01-.2-.319 2.198 2.198 0 01-.159-.36c-.041-.117-.046-.323-.015-.62.025-.298.087-.54.174-.735.072-.164.242-.416.37-.565.128-.148.231-.292.231-.318 0-.026.072-.072.154-.108.082-.036.154-.092.154-.133 0-.041.093-.103.205-.134.113-.036.232-.108.257-.164.036-.067.108-.103.206-.103.082 0 .2-.046.256-.102a.366.366 0 01.221-.103c.062 0 .15-.02.19-.046.051-.031-.067-.113-.431-.283a4.716 4.716 0 01-.868-.539 6.65 6.65 0 01-.555-.508l-.19-.21v.19a1.2 1.2 0 01-.061.359c-.036.092-.072.17-.093.17-.02 0-.128-.309-.246-.684-.17-.534-.216-.76-.216-1.037 0-.195.036-.534.077-.745.041-.21.108-.518.139-.677.036-.165.077-.298.098-.298.02 0 .056.03.077.061.02.036.056.329.077.658.02.344.066.667.113.775.046.103.164.257.261.35.103.086.344.24.54.338.195.098.4.241.457.324.056.082.123.21.138.292l.036.15-.144-.114c-.077-.061-.174-.113-.215-.113a.926.926 0 01-.272-.102.948.948 0 00-.293-.103c-.072 0-.046.04.087.154.098.082.421.277.719.431a10.7 10.7 0 001.155.493 9.3 9.3 0 01.796.308c.129.067.247.082.426.062.134-.016.257-.046.273-.072.015-.026.097-.046.18-.046.081 0 .148-.02.148-.052 0-.025.072-.05.16-.05.087 0 .195-.037.236-.083.056-.057.133-.072.251-.051.118.02.18.01.21-.042.021-.04.134-.087.247-.102.113-.016.221-.067.247-.113.025-.046.113-.077.22-.077.119 0 .18-.026.18-.072 0-.041.072-.087.165-.108.092-.02.205-.046.256-.056.052-.016.088-.057.088-.093s.036-.082.082-.097a.746.746 0 01.2-.031c.067 0 .18-.057.252-.129a.693.693 0 01.318-.159c.098-.02.18-.051.18-.072 0-.02-.124-.118-.272-.215a5.724 5.724 0 00-.617-.34c-.19-.087-.41-.164-.487-.164-.077 0-.226.021-.334.047a1.25 1.25 0 00-.324.133c-.118.077-.128.077-.159 0a.2.2 0 01.02-.17c.031-.045.144-.153.263-.235a.754.754 0 00.272-.34c.051-.159.046-.21-.057-.405a2.51 2.51 0 00-.339-.462 1.197 1.197 0 00-.523-.344 10.259 10.259 0 00-.54-.17.917.917 0 00-.513-.005c-.149.031-.334.093-.41.134-.13.066-.15.066-.175-.01-.021-.057.061-.17.256-.36.267-.257.293-.293.293-.508 0-.154-.03-.262-.092-.324-.067-.067-.252-.113-.673-.159a6.17 6.17 0 00-1.099-.036c-.288.02-.632.067-.765.108-.21.062-.241.062-.241 0 0-.041.046-.103.102-.139.057-.036.103-.082.103-.102 0-.021-.134-.042-.298-.042-.164 0-.55.026-.857.057-.314.03-.611.072-.668.098-.056.025-.21.066-.339.097-.128.03-.277.072-.328.093-.067.025-.083.015-.052-.026 0-.031.067-.082.129-.108.061-.026.215-.123.349-.22.19-.14.395-.211 1.027-.365a26.85 26.85 0 001.109-.293c.195-.062.339-.139.375-.2.046-.082.036-.108-.062-.144-.067-.026-.293-.026-.503-.01-.21.02-.416.025-.452.015-.036-.01-.062-.041-.062-.067 0-.025.052-.077.113-.123a.489.489 0 01.252-.082c.077 0 .195-.02.262-.046s.462-.062.873-.077c.416-.016.811-.057.883-.093.072-.03.123-.082.113-.113-.01-.03-.087-.092-.17-.143-.082-.052-.323-.119-.534-.15a8.003 8.003 0 01-.462-.082c-.051-.015-.015-.056.108-.118.103-.051.288-.097.41-.097.124 0 .345-.005.484-.005.143 0 .528.077.873.18.338.097.81.246 1.057.328.257.087.498.139.575.123.088-.015.134-.061.134-.123 0-.051-.072-.18-.164-.277a1.485 1.485 0 00-.411-.308c-.134-.067-.293-.124-.35-.124-.056 0-.102-.02-.102-.046s.026-.067.062-.087a.502.502 0 01.225-.03c.093.004.196-.027.226-.068.047-.056.041-.108-.02-.22-.041-.083-.185-.226-.318-.314-.134-.087-.309-.159-.386-.159-.082 0-.143-.02-.143-.046s.082-.077.18-.113c.097-.036.18-.087.18-.118s-.124-.17-.273-.308a4.473 4.473 0 00-.73-.519c-.25-.144-.461-.293-.477-.329-.01-.04.036-.061.139-.061.087 0 .467.139.837.303.37.164.862.405 1.088.529.226.123.77.441 1.207.703.437.262 1.238.78 1.772 1.145s1.14.801 1.34.966c.2.164.508.457.688.647.174.19.375.462.441.606.088.19.108.297.083.405-.02.082-.077.175-.124.2-.066.041-.113.026-.215-.066-.098-.093-.129-.103-.129-.047 0 .042.124.144.267.226.15.083.39.221.534.319l.267.17.083-.114a.41.41 0 00.082-.18c0-.035.03-.066.072-.066.04 0 .087.036.102.082.016.046.031.154.031.241 0 .088-.02.195-.051.242-.031.05-.026.113.02.18.036.056.088.184.108.282.02.097.139.328.262.513s.344.457.488.601c.149.149.395.334.554.406.16.077.437.19.622.251.272.093.349.103.41.052a.77.77 0 01.165-.098c.061-.02.092 0 .103.082.01.072.056.118.133.129.072.01.113-.01.113-.052 0-.036.067-.108.149-.154.082-.046.16-.072.174-.056.016.015.016.061.006.097a.088.088 0 00.03.103c.031.02.103-.005.16-.057.066-.061.082-.107.046-.143-.031-.031-.052-.067-.052-.088 0-.02.047-.046.103-.061a.137.137 0 00.103-.134c0-.072-.031-.108-.103-.108-.056 0-.103-.02-.103-.05 0-.032.021-.052.047-.052.025 0 .061-.036.077-.077.015-.046-.02-.129-.083-.19a.53.53 0 00-.24-.129 4.403 4.403 0 01-.309-.036 9.864 9.864 0 01-.76-.123.97.97 0 01-.251-.077c-.016-.015-.067-.01-.113.016-.057.03-.119.02-.185-.026a.383.383 0 00-.185-.072.227.227 0 01-.15-.072c-.035-.041-.092-.062-.122-.051-.031.01-.108-.02-.16-.082-.05-.057-.123-.103-.154-.103-.03 0-.118-.062-.184-.144a2.62 2.62 0 01-.242-.339 1.144 1.144 0 01-.133-.513c-.016-.257.005-.365.118-.59.072-.155.164-.288.2-.304.036-.015.067-.066.067-.113 0-.051.062-.118.144-.159.123-.061.128-.072.04-.087a2.153 2.153 0 01-.328-.129c-.123-.061-.236-.138-.251-.174-.016-.036-.057-.067-.093-.067s-.092-.072-.128-.154c-.036-.087-.082-.154-.108-.154-.026 0-.057.02-.072.051-.015.026-.067.052-.113.052-.062 0-.067-.016-.02-.072.035-.041.046-.129.025-.206-.02-.071-.056-.133-.082-.133-.026 0-.046.026-.046.056 0 .031-.02.042-.052.021-.03-.015-.04-.164-.025-.329l.025-.297-.164-.026a.448.448 0 00-.257.026.156.156 0 01-.174-.016.494.494 0 00-.236-.072c-.088 0-.165-.03-.175-.061-.01-.031.051-.072.134-.088.082-.015.328-.118.549-.22.308-.15.375-.2.298-.226a.264.264 0 00-.165-.01c-.035.015-.061 0-.061-.026s.036-.077.077-.113c.04-.036.097-.052.123-.031.026.015.036-.03.02-.098-.015-.072 0-.128.031-.128s.067.02.088.051c.015.031.087.052.149.052.066 0 .205-.057.308-.129.102-.072.22-.128.262-.128.04 0 .077.041.077.087 0 .072.015.072.113-.02.061-.057.19-.144.277-.19a.756.756 0 01.236-.082c.041 0 .103-.036.139-.078a.56.56 0 01.236-.123.677.677 0 01.277-.02c.057.015.103.046.103.072 0 .025-.062.071-.139.107-.123.057-.138.098-.144.34-.005.174-.04.302-.092.359-.056.056-.087.067-.087.02 0-.036-.02-.051-.052-.036-.025.016-.05.098-.05.18 0 .118.03.16.127.185a.506.506 0 00.216 0c.077-.03.077-.041-.01-.103-.093-.067-.093-.072-.005-.108a.71.71 0 01.282-.005c.108.016.303.046.437.062.236.03.241.036.159.128a.57.57 0 01-.262.129.642.642 0 00-.277.138c-.088.093-.098.093-.098.02 0-.045-.015-.086-.041-.086a.431.431 0 00-.139.077.293.293 0 01-.215.046c-.093-.02-.118-.01-.118.056 0 .046.02.072.05.057.027-.016.068.01.093.061.026.052.041.19.036.308-.005.119-.036.252-.072.298-.036.041-.092.077-.123.077-.03 0-.092-.046-.133-.102-.041-.057-.108-.103-.154-.103a.403.403 0 01-.18-.077c-.077-.062-.108-.062-.139-.01a.301.301 0 00-.04.102c0 .02.071.118.158.221.088.103.231.22.314.262.082.041.184.067.226.051.05-.02.066-.066.04-.138-.025-.088-.015-.103.062-.088.052.01.093.047.082.077-.005.031.02.052.062.047a.467.467 0 00.19-.124c.067-.061.19-.18.277-.267.088-.087.185-.154.216-.154.03 0 .077-.046.108-.102a.216.216 0 01.17-.103c.066 0 .158-.036.215-.077a.406.406 0 01.2-.077.389.389 0 00.2-.077c.098-.072.098-.077 0-.103a1.012 1.012 0 01-.19-.082c-.05-.026-.118-.036-.154-.02-.036.015-.015-.006.036-.052.057-.046.129-.082.165-.082a.13.13 0 00.097-.057c.02-.03-.01-.102-.061-.159-.093-.102-.093-.108.061-.072.087.02.216.01.288-.015.097-.036.154-.118.215-.308.047-.144.108-.272.139-.293.03-.015.077-.005.108.026.03.03.072.056.092.056.02 0 .19-.149.38-.328.19-.18.406-.355.483-.38.077-.026.17-.031.205-.005.052.03.031.072-.077.164-.102.087-.133.144-.097.195.025.041.072.149.108.241a.526.526 0 01.01.344c-.026.098-.072.19-.098.206-.025.015-.051-.016-.051-.072 0-.057-.02-.118-.046-.134-.026-.015-.036.01-.026.062a.269.269 0 01-.056.195c-.072.093-.077.093-.083.01 0-.05-.025-.087-.05-.087-.032 0-.052.057-.052.123 0 .067.036.14.082.154.046.016.195.031.329.031.133 0 .261-.02.277-.046.015-.026 0-.062-.036-.072-.046-.02-.041-.04.02-.082.047-.03.18-.149.298-.262.15-.144.257-.205.365-.205.082 0 .149.015.149.03 0 .016-.057.078-.129.134-.097.077-.128.149-.128.308a.874.874 0 01-.051.303c-.031.057-.077.098-.103.098-.026 0-.051-.036-.051-.077s-.021-.077-.042-.077c-.02 0-.097.056-.164.128-.067.072-.17.128-.226.128-.082 0-.092.016-.04.062.035.036.06.123.06.195 0 .072.037.18.078.236a.397.397 0 01.077.17c0 .051-.036.061-.139.036a1.94 1.94 0 01-.195-.052l-.154-.056c-.056-.02-.205-.082-.329-.134-.138-.056-.277-.082-.359-.061a.928.928 0 00-.293.149c-.087.061-.344.164-.57.226-.226.061-.477.154-.565.21l-.148.098h.205a.871.871 0 00.375-.103.858.858 0 01.447-.103c.154 0 .287.02.302.046.016.026-.03.072-.102.103-.108.046-.123.087-.103.2.015.077.041.237.062.355a.927.927 0 010 .318c-.02.057-.057.103-.082.103-.026 0-.067-.052-.093-.113-.041-.108-.041-.108-.067.026-.015.092 0 .154.052.184.046.026.138.01.236-.036.087-.04.236-.138.334-.205.154-.118.164-.133.082-.195-.046-.036-.072-.087-.052-.123.021-.031 0-.108-.04-.17a.611.611 0 01-.062-.308c.005-.108.025-.21.046-.226.02-.02.092.041.17.129.071.087.153.164.174.164.02 0 .051-.062.072-.139l.036-.138.097.159a.79.79 0 00.154.195c.031.02.134-.015.221-.082.088-.067.2-.118.247-.113.046.005.149-.062.23-.144.078-.082.196-.149.263-.149a.698.698 0 00.287-.103.826.826 0 01.36-.102c.108 0 .195.02.195.051 0 .03-.036.051-.077.051s-.144.062-.231.144c-.154.139-.154.144-.082.344.04.113.077.257.077.319 0 .061-.01.148-.031.19-.016.046-.062.082-.103.082a.078.078 0 01-.077-.062c0-.036-.026-.015-.046.041a.746.746 0 00-.046.164c0 .036.046.062.113.062.061 0 .256.01.42.02l.309.021-.195-.077c-.108-.04-.19-.097-.19-.123 0-.026.03-.046.066-.051.036-.006.103 0 .144 0a.584.584 0 00.22-.047l.14-.051-.196-.175c-.107-.097-.174-.195-.154-.21.02-.02.129 0 .247.046.113.046.226.082.251.082.026 0 .134-.072.242-.159.108-.087.246-.246.303-.35a2.28 2.28 0 01.339-.43c.128-.134.272-.242.318-.242.046 0 .082.016.082.031a.646.646 0 01-.103.16.487.487 0 00-.102.2c0 .035.02.071.051.071.026 0 .118.098.206.21.087.119.154.268.154.335 0 .066-.021.118-.047.118-.025 0-.056-.02-.061-.046-.01-.026-.093-.062-.185-.083-.144-.03-.17-.02-.17.062 0 .077.057.113.237.154a.89.89 0 00.4.01.65.65 0 00.262-.149c.092-.102.092-.102-.015-.133-.062-.015-.113-.062-.113-.098 0-.036.04-.082.097-.097.052-.016.19-.123.303-.236.113-.113.247-.206.288-.206.046 0 .082.005.082.016 0 .01-.046.107-.103.215a1.027 1.027 0 00-.103.396c0 .159-.02.195-.102.195-.057 0-.118.03-.144.072-.02.04-.123.118-.22.18a.704.704 0 01-.299.107c-.071 0-.113.026-.097.067a.334.334 0 01-.02.18c-.037.097-.026.113.071.113.082 0 .134.046.175.143.051.134.056.134.061.021.006-.067-.05-.175-.128-.246-.092-.088-.113-.129-.056-.129.04 0 .102.03.133.067.03.036.092.164.134.282.071.206.071.216-.026.216a.55.55 0 01-.241-.092c-.113-.072-.247-.088-.704-.088-.442 0-.606.02-.744.098a1.582 1.582 0 01-.478.118c-.277.026-.298.036-.22.108.06.061.092.066.122.02.031-.051.083-.051.242.01.113.042.267.088.344.103.077.016.138.052.138.077 0 .026-.133.082-.297.129-.165.04-.36.097-.437.123-.077.026-.149.03-.164.01-.01-.02-.005-.067.02-.108.031-.051-.005-.108-.118-.19a8.266 8.266 0 00-.354-.246c-.108-.072-.216-.129-.246-.129-.031 0-.052.031-.052.067a.44.44 0 00.077.175c.052.072.113.103.18.082.087-.02.113.01.164.205.057.2.087.242.257.298.108.036.195.082.195.098 0 .02.118.061.262.092.144.031.339.062.431.062.098 0 .185-.02.2-.046.016-.026 0-.057-.03-.067-.031-.01-.041-.046-.02-.082.02-.036.133-.057.25-.057.119.005.304-.03.412-.082.154-.067.23-.072.354-.03.087.03.21.056.272.056.067 0 .149.046.19.102.062.088.103.098.324.057.138-.026.277-.051.302-.062.031-.01.144 0 .257.02l.35.068c.076.015.138.046.138.066 0 .02-.092.067-.205.103-.15.046-.206.087-.206.16 0 .056-.072.179-.159.282-.087.097-.185.18-.21.18-.026 0-.042-.047-.026-.103.026-.103.026-.103-.129-.01l-.154.092.17.144c.097.082.23.143.313.143a.56.56 0 00.241-.051c.067-.036.088-.087.067-.195-.025-.129-.02-.134.057-.072.046.041.22.087.38.103.195.02.292.056.292.102 0 .036-.092.103-.2.139a1.53 1.53 0 00-.354.18c-.123.092-.16.097-.195.04-.036-.056-.062-.056-.15-.004a.575.575 0 01-.256.066c-.103 0-.22-.056-.354-.18-.108-.097-.247-.179-.308-.179-.077 0-.098.026-.077.077.015.046.092.077.174.077.113 0 .154.026.17.113.015.062.036.195.051.298.015.097.005.21-.02.251-.037.057-.098.036-.309-.128-.143-.108-.262-.216-.262-.236 0-.02-.082-.051-.18-.072a.69.69 0 01-.297-.154c-.067-.067-.154-.164-.2-.216-.062-.072-.18-.102-.488-.128a3.359 3.359 0 01-.704-.134 6.591 6.591 0 01-.77-.354c-.257-.139-.57-.267-.693-.287a1.181 1.181 0 00-.426.02c-.118.03-.195.082-.185.113.01.03.18.098.375.144.195.046.493.123.662.174.17.052.334.118.37.144.036.026.087.031.113.016.03-.016.103-.006.17.03a.498.498 0 00.158.067c.026 0 .072.041.108.093.036.05.103.092.15.092.045 0 .097.056.112.128.016.072.067.129.103.129.04 0 .072.046.072.097 0 .052.036.113.082.129.056.02.077.072.056.164-.015.087 0 .144.052.16.051.02.061.071.046.148-.015.067-.01.123.02.123.031 0 .052.057.052.129 0 .072.02.128.046.128s.03.057.02.128c-.015.077 0 .129.031.129s.057.072.057.154c0 .108.026.154.082.154.046 0 .092.046.108.103a.142.142 0 00.128.102.492.492 0 00.2-.056c.098-.052.098-.057-.005-.185-.056-.072-.097-.144-.082-.154.01-.01.067.005.123.03.057.032.17.057.247.057.082 0 .22-.046.313-.103a.698.698 0 01.288-.102c.066 0 .19-.036.277-.077a.81.81 0 00.216-.15.622.622 0 01.236-.128c.128-.04.2-.04.277 0 .057.031.093.078.077.108-.015.026-.072.052-.123.052a.228.228 0 00-.154.072c-.046.05-.041.087.015.133a.621.621 0 01.134.236c.04.123.04.2.005.267-.03.052-.057.072-.057.041 0-.025-.036-.005-.077.052-.077.097-.077.097-.133.005-.046-.077-.067-.082-.103-.026a.335.335 0 00-.046.149c0 .057.092.098.308.144.231.046.334.051.416.005.056-.03.118-.046.133-.03.016.015-.025.05-.087.086a.594.594 0 01-.313.036c-.17-.02-.19-.015-.139.047.031.04.139.071.231.071.119 0 .221-.046.34-.154.092-.082.133-.143.087-.123a.14.14 0 01-.139-.04c-.046-.057-.005-.109.2-.263.144-.102.293-.205.334-.22.041-.016.077-.016.077-.006 0 .016-.036.093-.077.175a.752.752 0 00-.077.282c0 .072-.03.165-.072.195-.056.047-.077.047-.097-.005-.016-.046-.057-.036-.15.047a1.032 1.032 0 01-.277.169c-.154.051-.154.056-.154.431 0 .21-.015.4-.04.421-.026.026-.093-.015-.155-.087a.914.914 0 00-.313-.2 3.411 3.411 0 01-.437-.216 1.633 1.633 0 00-.441-.18c-.195-.03-.21-.025-.241.098-.021.087-.057.123-.108.103-.041-.016-.165.04-.267.123a1.22 1.22 0 01-.329.185c-.072.015-.149.015-.164 0-.02-.02.061-.113.174-.21.113-.098.206-.196.206-.222 0-.025-.036-.046-.077-.046s-.077-.025-.077-.056c0-.036-.057-.041-.165-.02a2.27 2.27 0 01-.446.025c-.154-.005-.303-.03-.324-.051-.02-.021.077-.052.22-.067.145-.016.273-.036.288-.052.016-.015-.05-.159-.148-.318a4.086 4.086 0 01-.314-.673c-.077-.21-.154-.37-.174-.359-.02.01-.052.092-.067.175-.02.092-.17.303-.375.518-.19.2-.405.396-.477.437a1.17 1.17 0 00-.252.185c-.108.102-.118.143-.087.37.02.153.01.328-.026.44a2.233 2.233 0 01-.21.412 1.4 1.4 0 00-.206.544c-.051.313-.046.334.123.703.098.21.231.545.298.74.067.195.16.416.206.488.046.071.128.21.174.308.052.113.206.262.411.4.2.134.385.221.483.226a.622.622 0 00.287-.082.57.57 0 01.252-.087c.077 0 .236.102.436.287.257.236.313.319.313.452 0 .087-.02.195-.046.236-.025.041-.056.067-.066.052a1.827 1.827 0 01-.083-.18l-.061-.154-.103.139c-.056.077-.149.138-.205.138-.088 0-.098.02-.072.144.02.077.046.205.061.282.016.077 0 .175-.036.216-.035.041-.092.077-.128.077-.036 0-.077-.051-.087-.113-.01-.072-.046-.108-.093-.092-.04.01-.149.03-.236.04-.144.021-.22-.025-.631-.374-.257-.22-.483-.431-.499-.467-.015-.036-.05-.072-.087-.072-.036 0-.149-.062-.257-.134-.154-.102-.21-.118-.267-.072-.04.036-.118.052-.174.036-.057-.015-.103-.01-.103.01 0 .021.026.062.062.098.046.046.036.062-.046.062a.442.442 0 01-.226-.093c-.093-.072-.108-.123-.083-.23a.694.694 0 01.134-.242.41.41 0 01.257-.103c.097 0 .144-.02.123-.056-.02-.031-.067-.041-.103-.031-.036.015-.097-.005-.128-.046a.207.207 0 00-.149-.072c-.051 0-.103-.067-.134-.165-.04-.128-.077-.164-.18-.164-.117 0-.128-.02-.128-.23 0-.196-.015-.232-.102-.232-.077 0-.103-.036-.103-.154 0-.103-.03-.16-.087-.17-.067-.01-.093.042-.118.221-.02.129-.01.488.025.796.031.308.103.663.154.78.057.134.19.293.34.412.148.118.302.19.39.19.076 0 .22-.036.318-.083.164-.077.195-.077.441.005.175.062.283.129.309.2a.207.207 0 00.164.124.407.407 0 01.236.144.48.48 0 01.113.246.45.45 0 01-.082.226c-.046.062-.103.113-.129.113-.025 0-.046-.056-.046-.123s-.04-.139-.087-.16c-.051-.02-.098-.01-.108.021a.58.58 0 01-.097.139c-.057.056-.134.072-.252.051-.154-.025-.164-.02-.118.067.03.051.051.154.051.22a.51.51 0 01-.108.263c-.056.072-.138.133-.18.133zm-.257-.36c.016 0 .026-.01.026-.025 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.026.025.026zm.422-.118c.015-.05-.01-.133-.057-.184-.046-.052-.067-.103-.051-.118.015-.016-.02-.057-.082-.088-.088-.046-.134-.04-.237.02-.066.047-.123.103-.123.124 0 .02.057.067.123.098.108.05.129.04.16-.047.03-.097.035-.097.133.026.056.067.103.154.103.195.005.036.015.026.03-.026zm-.345.016c.036 0 .052-.016.036-.036-.02-.02-.05-.02-.066 0-.02.02-.005.036.03.036zm-.77-.257c.036 0 .052-.015.036-.036-.02-.02-.051-.02-.067 0-.02.02-.005.036.031.036zm.462 0c.016 0 .067-.046.118-.103a.49.49 0 00.088-.128c0-.015-.057-.026-.123-.026a.271.271 0 00-.19.083c-.057.066-.057.087.005.128.046.02.087.046.102.046zm-.693-.154c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm.416 0a.568.568 0 00.123-.051c.052-.026.098-.077.098-.103 0-.026-.057-.051-.123-.051-.067 0-.139.02-.16.051a.12.12 0 000 .103c.021.025.047.051.062.051zm1.802-.103c.016-.087-.01-.154-.092-.22-.062-.052-.139-.088-.164-.077a.093.093 0 00-.057.066c-.005.026.041.057.108.067.062.01.118.036.123.067.005.026.01.072.02.097.006.026.021.067.026.088.01.02.026-.016.036-.088zm-.528.047c.056 0 .082-.01.066-.026-.015-.015-.061-.02-.097-.005-.041.015-.026.03.03.03zm-.432-.047c.036 0 .052-.015.036-.036-.02-.02-.051-.02-.067 0-.02.021-.005.036.031.036zm-1.006-.05c.036 0 .092-.032.123-.068.03-.036.041-.082.026-.102-.02-.02-.077-.036-.124-.036-.046 0-.107.02-.123.051a.12.12 0 000 .103.131.131 0 00.098.051zm1.468 0c.088 0 .108-.027.093-.145-.01-.082-.046-.138-.093-.138-.046 0-.082.056-.092.143-.015.113.005.14.092.14zm-.508-.052c.02 0 .051-.036.067-.082a.802.802 0 00.03-.103c0-.01-.046-.02-.102-.02-.057 0-.103.03-.103.066 0 .036.016.082.036.103.016.02.046.036.072.036zm.22 0c.098 0 .134-.026.134-.103 0-.067-.036-.103-.102-.103-.057 0-.103.01-.103.02 0 .011-.015.057-.03.104-.027.061 0 .082.102.082zm-1.586-.052c.01 0 .005-.036-.01-.077-.016-.04-.041-.066-.057-.056-.015.015-.01.051.01.077.021.03.047.056.057.056zm1.155 0c.026 0 .047-.046.047-.102 0-.057-.02-.103-.047-.103-.025 0-.061.02-.082.051a.12.12 0 000 .103c.02.026.057.051.082.051zm2.321-.005c.02 0 .041-.046.041-.102a.747.747 0 00-.077-.257c-.04-.082-.112-.154-.154-.154a.13.13 0 00-.107.077c-.016.04-.016.092 0 .108.015.015.066 0 .107-.036.052-.041.077-.047.077-.01 0 .03-.02.066-.05.087-.032.02-.016.082.04.154.046.077.103.133.123.133zm-3.204-.102c.098-.062.098-.077.031-.211-.072-.133-.067-.144.026-.144.056 0 .113-.02.128-.046.016-.026 0-.067-.03-.087-.037-.02-.073-.01-.083.02-.01.031-.056.062-.097.062-.052 0-.067-.03-.047-.103.016-.056.01-.144-.02-.19-.031-.046-.057-.067-.062-.04-.005.025-.01.112-.02.194-.005.077.01.144.04.144.032 0 .032.02-.01.041-.05.036-.05.057.01.108.052.041.068.108.047.195-.015.113-.01.118.087.057zm-.118-.509c-.015 0-.025-.01-.025-.025 0-.016.01-.026.025-.026.016 0 .026.01.026.026 0 .015-.01.025-.026.025zm-11.08.493c.015-.015.01-.087-.006-.159-.02-.072-.051-.134-.077-.134-.026 0-.056.036-.077.083-.015.04-.01.066.015.051.026-.015.062.02.083.077.02.062.046.098.061.082zm11.845.005a.133.133 0 00.072-.077c.01-.036-.026-.061-.087-.061-.057 0-.108.02-.108.04a.12.12 0 00.036.078c.015.02.056.03.087.02zm-.873-.036c.01 0 .047-.036.083-.077.035-.046.04-.077.01-.077-.031 0-.067.036-.082.077-.016.041-.02.077-.01.077zm.611-.046c.062-.02.118-.067.129-.103.015-.04-.02-.056-.098-.046-.061.01-.123.057-.128.103-.01.067.01.077.097.046zm-4.133-.03c.01-.011.01-.078-.005-.14-.016-.066-.108-.205-.206-.307-.097-.103-.19-.175-.205-.16-.02.02-.03.077-.03.134 0 .067.025.092.076.072.046-.02.093.005.113.056.02.052.077.154.134.231.056.077.107.129.123.113zm-7.903-.052c.072 0 .129-.026.118-.051-.005-.026-.066-.052-.133-.052s-.118.02-.118.052c0 .03.061.056.133.05zm.057-.026c-.036 0-.052-.015-.036-.036.02-.02.051-.02.067 0 .02.02.005.036-.031.036zm7.348.041a.276.276 0 00.164-.102c.036-.057.036-.108.005-.139a.473.473 0 00-.19-.082c-.108-.026-.144-.016-.144.04 0 .057.042.068.134.052.092-.02.123-.01.097.031-.02.03-.005.062.031.062.047 0 .047.015-.01.051-.056.036-.087.026-.113-.041-.02-.051-.036-.062-.041-.02 0 .035-.026.05-.051.035-.026-.015-.067 0-.088.031-.025.036-.015.046.02.026.032-.02.063-.01.063.02.015.026.061.047.123.036zm3.98.01c.01 0 .02-.01.02-.02a.352.352 0 00-.093-.092c-.082-.062-.082-.062-.02.02a.352.352 0 00.092.093zm1.458-.02c.082-.005.154-.015.154-.03a.31.31 0 00-.072-.114c-.041-.046-.082-.087-.103-.087-.02 0-.03.041-.036.092 0 .067-.01.072-.041.026-.02-.036-.082-.051-.128-.03-.047.02-.088.056-.088.081 0 .031.036.036.077.021.041-.015.077-.01.077.01s.072.036.16.031zm-13.069-.03c.016 0 .026-.011.026-.026 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm10.419 0c.01 0 .03-.057.041-.124a.301.301 0 00-.02-.195c-.026-.041-.042 0-.042.123 0 .108.01.195.021.195zm1.68-.011c.035-.01.076-.062.086-.113.01-.056-.005-.082-.051-.067-.036.01-.077.062-.087.113-.01.057.01.082.051.067zm.559.01c.036 0 .051-.015.036-.036-.02-.02-.052-.02-.067 0-.02.02-.005.036.03.036zm-11.338-.051c.02 0 .041-.02.041-.046a.84.84 0 00-.056-.19c-.047-.129-.062-.134-.103-.057-.036.062-.03.123.015.195.036.052.083.098.103.098zm-.087-.154c-.016 0-.026-.01-.026-.026 0-.015.01-.025.026-.025.015 0 .025.01.025.025 0 .016-.01.026-.025.026zm12.123.154c.041 0 .062-.02.046-.051-.015-.031-.066-.052-.108-.052-.04 0-.061.02-.046.052.016.025.067.05.108.05zm-13.35-.051c.01 0 .02-.01.02-.021a.352.352 0 00-.092-.092c-.082-.062-.082-.062-.02.02a.352.352 0 00.092.093zm.564-.067c.088-.041.108-.072.067-.118-.03-.036-.097-.052-.154-.036-.056.015-.118.051-.133.077-.016.03 0 .072.036.092.035.026.118.016.184-.015zm.329.067c.036 0 .051-.016.036-.036-.02-.02-.051-.02-.067 0-.02.02-.01.036.031.036zm6.496 0c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.026.026.026zm7.163-.036c.056-.016.097-.057.097-.098a.07.07 0 00-.072-.072.197.197 0 00-.128.067c-.03.036-.046.082-.03.097.02.016.081.021.133.006zm-14.3-.036c0-.005.03-.047.071-.098.062-.082.057-.092-.067-.092-.082 0-.133.03-.133.072 0 .04.03.082.061.097.036.016.067.026.067.02zm6.983.02c.01 0 .02-.01.02-.02s-.026-.041-.062-.062c-.035-.02-.046-.015-.02.02.026.037.051.062.062.062zm.169-.077c.01-.01.005-.04-.015-.072-.021-.03-.083-.051-.15-.051-.107 0-.107.005.016.072.072.036.139.061.149.051zm-9.54-.025c.056 0 .097-.021.097-.042 0-.025-.062-.071-.133-.102-.093-.041-.129-.088-.108-.16.015-.066-.005-.102-.082-.123-.057-.015-.124-.015-.15 0-.025.016-.04.057-.04.098s.071.128.159.2c.087.072.205.129.256.129zm.41 0a.117.117 0 00.062-.031c.02-.02-.016-.067-.072-.108-.057-.041-.098-.103-.087-.134.01-.03-.016-.082-.057-.113-.04-.03-.128-.046-.195-.03-.082.015-.118.056-.118.133.005.108.005.108.046.005.041-.097.046-.097.046.016 0 .082.057.138.17.19.103.036.19.072.205.072zm1.417 0c.01 0 .026-.021.042-.047.015-.025.01-.061-.016-.077-.026-.015-.04.005-.04.047 0 .046.004.077.014.077zm1.253-.01c.098 0 .139-.011.088-.026a.528.528 0 00-.18 0c-.046.015-.01.025.092.025zm6.136.01c.016 0 .026-.01.026-.026s-.01-.026-.026-.026c-.015 0-.025.01-.025.026 0 .015.01.026.025.026zm3.6-.016c.02-.02.02-.051 0-.067-.02-.015-.036-.005-.036.036.005.031.02.047.036.031zm3.625.016c.077 0 .139-.021.139-.047 0-.025-.026-.061-.057-.082-.03-.02-.092 0-.138.046-.072.077-.072.083.056.083zm-14.285-.052c.026 0 .062-.025.077-.056.02-.031.02-.067.005-.082-.015-.016-.067-.016-.113.005-.046.015-.066.056-.051.082.02.03.056.051.082.051zm6.906 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm8.416-.072a.44.44 0 00.083-.241c0-.082-.026-.144-.067-.144a.213.213 0 00-.129.062.24.24 0 00-.061.149c0 .046.036.102.082.118.046.015.067.061.046.097-.02.031 0 .01.046-.04zm-17.91.02c.051 0 .046-.03-.03-.112a.444.444 0 01-.103-.154c0-.02.025-.041.056-.041.03 0 .041-.02.02-.052-.015-.03.016-.051.078-.051.061 0 .092-.02.077-.051-.02-.036-.067-.036-.134 0a.393.393 0 01-.215.036.98.98 0 01-.226-.077.457.457 0 00-.16-.062c-.025 0-.046.036-.046.077s.026.072.057.072a.582.582 0 01.133 0c.041.005.103.067.139.139.056.128.056.133-.062.102-.072-.015-.128-.02-.128-.01s.072.046.154.077c.092.03.144.036.123.005-.015-.026-.01-.051.016-.051.025 0 .077.036.112.077.036.04.098.077.14.077zm1.258-.004c.103 0 .231-.01.277-.031.083-.03.083-.036-.01-.072-.067-.026-.005-.041.175-.041.149 0 .262-.026.246-.051-.015-.026.052-.062.15-.077.097-.021.19-.057.21-.083.015-.025-.026-.05-.098-.05-.087 0-.16-.047-.22-.155-.052-.082-.109-.154-.134-.154-.026 0-.031.062-.016.139.016.077.01.159-.005.184-.015.026-.051.021-.072-.02-.036-.057-.046-.051-.046.015 0 .047.026.098.062.113.036.016.02.026-.031.016-.051-.005-.118-.067-.139-.129-.036-.097-.02-.128.072-.17.098-.045.093-.045-.04-.02-.114.02-.134.016-.078-.02.041-.026.062-.067.041-.082-.02-.02-.056-.02-.087 0a.152.152 0 00-.057.113c0 .066-.015.066-.077.02-.061-.051-.097-.046-.195.026-.113.082-.113.087-.005.051a.635.635 0 01.241 0c.072.02.134.057.134.082 0 .026-.051.036-.118.016-.082-.026-.098-.02-.046.015.04.026.056.087.04.134-.015.046-.06.087-.102.087-.041 0-.077-.02-.077-.051 0-.026.036-.036.077-.02.041.014.077.004.077-.027 0-.03-.087-.056-.195-.056a.53.53 0 00-.282.072c-.052.036-.093.082-.093.102 0 .021.051.057.113.083.067.02.205.046.308.04zm.663-.509c-.036 0-.052-.015-.036-.036.02-.02.051-.02.066 0 .02.021.006.036-.03.036zm1.463.514a.07.07 0 00.072-.072c0-.041.026-.092.056-.108.036-.026.047 0 .02.072-.02.072-.01.108.027.108.036 0 .092-.041.128-.093a.584.584 0 00.072-.123c0-.02-.093-.03-.206-.02-.113.005-.23.036-.261.066-.031.031-.042.083-.021.113a.16.16 0 00.113.057zm6.264 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm.422-.005c.087.005.113-.02.113-.108 0-.062-.016-.087-.031-.051-.02.046-.047.04-.108-.021-.077-.077-.087-.077-.123.015-.036.093-.036.093-.041.006 0-.062-.036-.088-.093-.077-.051.01-.087.05-.087.092 0 .041.056.092.128.108.067.015.175.036.242.036zm3.635.005c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .016.01.026.026.026zm3.045-.01c.036-.005.062-.036.062-.062-.006-.03-.072-.092-.154-.144-.098-.061-.16-.072-.18-.036-.02.031.02.077.087.103.067.026.087.051.041.051-.067.005-.067.01 0 .057.041.02.103.036.144.03zm-14.68-.042c.025 0 .061-.02.082-.05.015-.032-.005-.037-.047-.021-.046.015-.082.04-.082.05 0 .011.02.021.046.021zm.97 0a.247.247 0 00.16-.077c.035-.04.05-.092.04-.102-.015-.016-.087 0-.159.025-.077.031-.133.077-.133.103 0 .03.04.051.092.051zm6.439-.01c.092.005.098 0 .036-.04a.492.492 0 00-.113-.052.04.04 0 00-.041.04c0 .027.056.047.118.052zm4.344-.03c.03-.047.057-.052.077-.01.02.03.057.056.087.056.026 0 .036-.026.016-.062-.026-.041-.01-.051.04-.03.042.015.078.004.078-.032 0-.03-.062-.061-.134-.061-.071 0-.148.02-.169.051a.225.225 0 00-.036.103c0 .03.02.02.041-.016zm4.416-.031a.226.226 0 00-.046-.165c-.041-.051-.082-.061-.118-.025-.036.036-.02.087.046.164.087.097.103.097.118.026zm-15.825.005c.02-.02.02-.052 0-.067-.021-.02-.036-.005-.036.036.005.036.02.051.036.03zm.42.015c.021 0 .067-.026.098-.062.03-.035.062-.082.062-.107 0-.026-.052-.031-.118-.01a.716.716 0 00-.134.05c-.01.011-.005.042.016.073.025.03.056.056.077.056zm7.816-.077a.528.528 0 00.046-.17c0-.035-.02-.05-.046-.035-.031.015-.052.092-.046.17 0 .122.005.128.046.035zm-8.139.026c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.026.026.026zm6.778 0c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.026.026.026zm.298-.016a.133.133 0 00.072-.077c.01-.036-.026-.061-.082-.061-.057 0-.119-.02-.134-.052-.015-.025-.067-.051-.108-.051-.04 0-.072.036-.072.077s.02.082.052.082c.025.005.072.01.097.01a.206.206 0 01.088.047c.02.025.061.036.087.025zm4.647-.113c.01-.071 0-.149-.016-.17-.02-.014-.05 0-.077.042-.025.041-.02.113.016.17.056.087.061.082.077-.042zm3.199.129c.092 0 .19-.036.23-.088a.585.585 0 00.073-.128c0-.02-.031-.041-.077-.041-.041 0-.108.046-.139.103-.036.056-.087.102-.113.102-.025 0-.02-.025.01-.061.036-.036.062-.082.062-.103 0-.02-.046-.041-.097-.041-.057 0-.113.026-.134.051-.02.031-.02.088-.005.129.015.046.092.077.19.077zm-18.09-.057c.01 0 0-.02-.016-.051a.435.435 0 00-.169-.108c-.098-.036-.118-.061-.067-.092.046-.031.052-.052.01-.077-.03-.02-.056-.01-.056.02 0 .041-.03.041-.113 0-.087-.04-.077-.02.041.077.082.072.2.154.257.18.051.03.108.051.113.051zm3.373-.046c.042-.036.067-.077.057-.087-.015-.016-.046-.01-.077.01-.03.02-.057.057-.057.087 0 .036.031.031.077-.01zm6.44.026c.01-.01 0-.041-.016-.072-.02-.03-.056-.057-.082-.057-.026 0-.02.031.015.072.031.041.072.067.083.057zm4.513.025c.03 0 .062-.01.062-.02s-.026-.093-.057-.18c-.03-.087-.077-.164-.103-.164-.025 0-.03.04-.01.087a.475.475 0 00.077.144c.026.03.026.072.01.092-.02.026-.01.041.021.041zm3.512-.092a.843.843 0 00.041-.123c0-.02-.066-.052-.154-.072-.092-.02-.18-.01-.215.02-.041.042-.041.072.005.119.046.046.077.04.138-.036.072-.093.077-.093.047-.006-.02.057-.006.113.036.14.04.035.077.02.102-.042zm-17.725.041c.026 0 .03-.036.015-.077s-.051-.062-.077-.046c-.025.015-.036.051-.015.077.02.026.051.046.077.046zm9.474 0c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm2.125-.072c.01-.025-.03-.087-.097-.138a.409.409 0 00-.185-.093c-.041 0-.072.03-.072.067 0 .036.077.103.164.144.098.036.18.046.19.02zm-10.197-.005a.54.54 0 00.164-.082c.03-.026.005-.046-.067-.046-.061 0-.113.025-.113.056s-.025.041-.051.02c-.03-.015-.051-.004-.051.026 0 .036.04.047.118.026zm9.51-.005c.04-.015.076-.082.076-.154s-.015-.123-.04-.123c-.021 0-.067.046-.103.102-.036.057-.052.129-.036.154.015.026.061.036.102.021zm3.61.03c.015 0 .015-.015-.006-.03-.015-.015.015-.077.067-.139a.358.358 0 00.097-.21c0-.077-.01-.087-.046-.036-.026.036-.061.072-.087.077-.026.005-.041.026-.031.046.005.02-.051.051-.123.072l-.139.036.118.092a.566.566 0 00.15.093zm-.114-.102c-.03 0-.005-.036.062-.082.061-.046.097-.108.082-.139-.02-.036-.01-.04.03-.015.047.03.042.062-.025.139-.051.056-.118.097-.149.097zm2.506.098c.046-.01.082-.041.082-.067 0-.026-.03-.051-.061-.051s-.072.03-.083.071c-.015.036.01.057.062.047zm-16.067-.057c.057 0 .16-.015.231-.036.093-.025.108-.046.062-.077a.118.118 0 00-.129.01.487.487 0 01-.164.077c-.103.021-.103.021 0 .026zm.822.01c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.025.026.025zm1.91-.02c.02-.02.02-.051 0-.067-.02-.02-.036-.005-.036.036 0 .036.015.051.036.03zm.174.02c.026 0 .052-.051.057-.118.005-.092.01-.097.03-.02.016.051.047.087.078.077.025-.01.051-.036.046-.057-.005-.02-.005-.072-.005-.113 0-.051-.031-.066-.087-.04a.41.41 0 00-.15.112c-.03.041-.05.098-.035.118.005.02.04.041.066.041zm.278 0c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.015.025.026.025zm4.626-.015c.016-.015.02-.062.005-.098-.015-.04-.03-.03-.03.031 0 .052.01.082.025.067zm.714.015c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.016.025.026.025zm.118-.04c.015-.047.046-.052.123-.01.072.035.123.04.154.004a.094.094 0 00.016-.113c-.02-.03-.072-.046-.113-.03-.067.025-.067.01.005-.098.046-.072.061-.129.03-.129-.03 0-.05.021-.05.052 0 .025-.047.051-.098.051-.077 0-.098.036-.093.164 0 .098.016.144.026.108zm1.001.035a.04.04 0 00.041-.04c0-.026.01-.083.026-.119.02-.056-.026-.077-.175-.082-.112-.005-.22.015-.24.046-.021.03-.006.077.035.103.046.03.093.015.128-.031.031-.041.077-.077.098-.077.02 0 .01.03-.02.072-.047.056-.047.077.005.097.036.016.082.026.102.031zm.16.005c.035 0 .097-.056.128-.128.03-.072.04-.128.026-.128-.021 0-.077.036-.129.087-.051.046-.092.103-.092.128 0 .026.025.041.066.041zm.467-.036c.04-.015.077-.087.077-.154 0-.077-.031-.123-.077-.123-.052 0-.077.051-.077.154 0 .118.02.15.077.123zm5.396.036c.01 0 .021-.01.021-.02s-.026-.041-.062-.062c-.036-.02-.046-.015-.02.02.02.037.046.062.061.062zm-12.364-.071c.04-.026.04-.067 0-.165-.031-.072-.077-.128-.103-.128-.026 0-.041.046-.041.103 0 .056.036.102.082.102.046 0 .067.026.041.062-.02.036-.01.046.02.026zm4.416.02c.01 0 0-.02-.016-.051-.015-.031-.061-.052-.092-.052-.036 0-.03.02.015.052.047.025.088.046.093.051zm8.775-.056c.052-.042.057-.077.02-.113-.035-.036-.071-.036-.112.005-.031.03-.041.082-.02.113.025.04.056.036.112-.005zm-16.529.005a.409.409 0 00.195-.077c.093-.067.093-.077.01-.077-.05 0-.092.02-.092.046s-.046.036-.103.02c-.056-.015-.102 0-.102.031s.046.052.092.057zm.488 0c.02 0 .026-.031 0-.067a.305.305 0 01-.041-.113c0-.03.02-.067.051-.087.031-.02.041-.047.026-.057a.927.927 0 00-.18-.056c-.123-.026-.133-.02-.061.02.05.031.077.077.061.103-.015.026 0 .092.036.149.041.056.087.103.108.108zm1.597-.02a.679.679 0 00.308-.134c.062-.062.164-.154.236-.206l.129-.102h-.2c-.15 0-.19-.021-.17-.077.015-.042.005-.083-.02-.093-.026-.01-.006-.041.046-.077.087-.051.092-.046.071.077-.02.118-.015.128.057.067a.412.412 0 00.113-.216c.02-.082.051-.164.077-.174.026-.016.056-.005.077.025.015.031.01.052-.02.052-.031 0-.052.04-.052.087 0 .077.015.072.082-.026.046-.061.113-.113.15-.113.035 0 .092-.046.122-.097a.41.41 0 00.052-.134c0-.015-.026-.015-.057.005-.04.026-.046-.005-.02-.087.02-.067.025-.113.01-.098-.015.016-.051.083-.087.15-.041.076-.041.107-.006.087.031-.02.057-.01.057.015 0 .026-.02.062-.046.082-.026.016-.057 0-.072-.036-.016-.04-.041-.046-.067-.015-.02.03-.108.056-.185.062-.097.005-.133-.01-.108-.052.021-.036-.05.026-.154.129-.18.184-.184.2-.113.333.042.077.062.17.052.206-.01.036-.046.051-.077.03-.031-.02-.041.01-.016.078.02.066.01.107-.02.107-.031 0-.057-.02-.057-.051 0-.03-.025-.051-.056-.051a.416.416 0 00-.18.097c-.067.052-.103.113-.087.134.02.025.128.03.23.015zm.42-.822c-.04 0-.06-.021-.045-.047.015-.025.046-.03.077-.015.025.015.046.036.046.041-.005.015-.036.02-.077.02zm.355-.083c-.015 0-.025-.01-.025-.025 0-.016.01-.026.025-.026.016 0 .026.01.026.026 0 .015-.01.02-.026.025zm5.32.91c.056.004.097 0 .097-.011 0-.01-.035-.03-.077-.046-.04-.016-.087-.01-.097.01-.01.02.026.041.077.046zm7.866-.026c.021-.01.042-.057.042-.103 0-.072.01-.072.102.01.082.077.118.082.18.026.041-.036.077-.087.077-.113 0-.026-.056-.067-.123-.093-.093-.036-.17-.02-.303.047-.165.082-.175.097-.093.17.041.04.098.066.118.056zm.175-.185c-.02.02-.036.005-.036-.036 0-.041.016-.052.036-.036a.05.05 0 010 .072zm-16.775.174c.036 0 .05-.015.036-.036-.021-.02-.052-.02-.067 0-.02.021-.005.036.03.036zm.215 0c.026 0 .041-.036.041-.077 0-.04-.02-.077-.046-.077a.104.104 0 00-.077.047c-.015.025-.01.061.005.077.02.015.052.03.077.03zm.986-.005c.057 0 .082-.01.067-.025-.016-.016-.062-.021-.098-.006-.036.016-.025.026.031.031zm2.912.005c.061 0 .087-.02.066-.056-.02-.03-.066-.041-.107-.026-.042.016-.072 0-.072-.03 0-.031-.016-.047-.031-.026-.016.02-.016.056.005.087.02.03.082.051.139.051zm4.924-.015c.056.005.103-.015.103-.041 0-.026-.047-.046-.103-.046-.057 0-.103.02-.103.04 0 .021.046.042.103.047zm.714 0a.157.157 0 00.097-.082c.016-.052-.005-.062-.092-.031-.077.026-.103.02-.082-.02.02-.031 0-.057-.047-.057-.066 0-.072.015-.015.103.041.056.103.097.139.087zm5.94.015c.01 0 .021-.01.021-.02s-.026-.041-.061-.062c-.036-.02-.047-.015-.021.02.02.032.046.062.062.062zm.406 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm1.643 0c.098 0 .18-.015.18-.04 0-.021-.02-.073-.046-.109-.036-.056-.067-.056-.18.021a.507.507 0 00-.133.108c0 .01.082.02.18.02zm.344 0c.026 0 .047-.03.047-.072 0-.04-.036-.087-.082-.102-.047-.016-.098-.02-.108-.005-.016.015.005.061.04.102.026.041.078.077.103.077zM2.81 18.11c.03-.01.05-.05.04-.087-.01-.036.01-.082.047-.103.03-.02.046-.061.026-.092-.021-.03-.067-.041-.108-.026-.041.016-.062.047-.052.072.016.02.005.057-.025.072-.031.016-.036.067-.02.108.02.046.06.067.092.056zm1.078-.02c.036-.02.03-.041-.01-.051-.036-.01-.062-.042-.062-.067 0-.026.041-.046.087-.046.046 0 .072-.016.057-.031-.016-.016-.123 0-.242.036-.118.036-.21.082-.21.108 0 .025.036.04.077.04s.077-.025.077-.061c0-.041.03-.03.087.026.046.04.108.066.139.046zm6.747.02c.19-.015.385-.035.437-.04.082-.01.082-.021.01-.093-.067-.067-.088-.067-.123-.01-.026.04-.103.077-.18.087-.072.01-.15-.005-.164-.03-.016-.027-.062-.047-.108-.047-.041 0-.062.02-.047.046.016.026-.015.036-.071.02-.062-.015-.103 0-.103.037 0 .04.097.051.349.03zm.657.021c.01 0 .02-.026.02-.051 0-.031-.025-.052-.056-.052-.03 0-.04.02-.02.052.015.025.04.051.056.051zm5.156 0c.036 0 .051-.015.036-.036-.02-.02-.052-.02-.067 0-.02.02-.005.036.03.036zm-14.845-.077c.015-.015 0-.056-.036-.087-.036-.036-.062-.041-.062-.01 0 .03.016.066.036.087.016.02.046.02.062.01zm.287.026c.026 0 .01-.036-.036-.088-.046-.046-.102-.072-.123-.046-.02.02-.005.062.036.087.036.021.093.042.123.047zm1.104 0c.026 0 .057-.02.077-.047.016-.025.006-.061-.02-.082a.12.12 0 00-.103 0c-.03.016-.04.052-.02.082.01.021.04.047.066.047zm13.238 0c.02 0 .041-.047.041-.098 0-.056-.02-.087-.041-.072-.02.016-.041.057-.041.098 0 .04.02.072.041.072zm-14.799-.052c.01 0 .006-.066-.01-.154-.026-.128-.01-.159.093-.2.107-.046.102-.051-.077-.051-.19-.005-.196 0-.165.138a.79.79 0 00.088.206c.03.03.061.061.071.061zm.611 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm.262 0c.01 0 .02-.01.02-.02s-.025-.041-.06-.062c-.037-.02-.047-.015-.021.02.02.037.046.062.061.062zm.154 0c.047 0 .072-.025.062-.061a.144.144 0 00-.082-.082c-.03-.01-.062.015-.062.061s.036.082.082.082zm.74 0c.03 0 .051-.025.051-.051 0-.03-.02-.051-.051-.051a.051.051 0 00-.052.051c0 .026.026.051.052.051zm.796-.01c.025.005.149-.036.267-.082.118-.051.22-.123.22-.164 0-.057-.02-.057-.092.015a.34.34 0 01-.185.087c-.051 0-.077-.02-.056-.051.02-.03-.005-.036-.052-.02-.061.02-.066.046-.025.097.04.051.03.072-.036.092-.052.01-.072.026-.041.026zm.431.01c.026 0 .062-.025.082-.056.02-.031.067-.041.103-.026.041.016.082.005.103-.02.015-.026.077-.052.133-.052.067 0 .087-.02.067-.061-.02-.036-.016-.047.02-.026.031.02.047.072.026.113-.02.051-.005.067.051.046.047-.015.083-.046.083-.067 0-.02-.026-.061-.057-.092-.041-.041-.041-.067 0-.092.03-.021.051-.006.041.03-.01.036.026.072.077.083.057.01.093-.01.093-.062 0-.046-.026-.082-.057-.082-.03 0-.041-.02-.02-.052.015-.025.005-.051-.026-.051-.03 0-.041-.03-.02-.062.02-.036-.047.021-.144.124-.129.133-.2.174-.252.143a.289.289 0 00-.108-.046c-.02 0-.04.036-.04.082 0 .047-.047.093-.104.108-.056.016-.102.046-.102.072.005.026.025.046.051.046zm.236-.154c-.015 0-.025-.01-.025-.025 0-.016.01-.026.025-.026.016 0 .026.01.026.026 0 .015-.01.025-.026.025zm.154.118c.041-.015.077-.04.077-.051 0-.01-.036-.02-.077-.02-.04 0-.077.02-.077.05 0 .032.036.037.077.021zm6.68.036c.011 0 .078-.036.15-.082.071-.046.113-.103.097-.128-.015-.026-.082-.046-.149-.046-.066 0-.133.02-.149.046-.015.025-.015.082 0 .128.016.046.041.082.052.082zm6.476-.02c.02-.02.02-.052 0-.067-.02-.02-.036-.005-.036.036 0 .036.015.051.036.03zm.452.02c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.025.026.025zm-5.828-.051c.035 0 .05-.015.035-.036-.02-.02-.05-.02-.066 0-.02.02-.005.036.03.036zm.174 0c.01 0 .016-.051 0-.108a.338.338 0 00-.051-.139c-.016-.015-.02.026-.005.098.01.067.025.134.025.139.01.005.02.01.031.01zm3.138 0c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm.718-.036a.281.281 0 00.139-.087.653.653 0 00.041-.226c0-.093-.01-.165-.026-.165-.015 0-.102.047-.195.103-.092.057-.143.103-.108.103.036 0 .072.03.088.072.02.051-.005.067-.082.046-.103-.02-.103-.015.015.056l.128.083-.154-.026c-.123-.02-.133-.015-.051.02.056.026.149.031.205.021zm1.438.036c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .01.01.026.026.026zm.103 0c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025s-.026.01-.026.025c0 .01.01.026.026.026zm.755 0c.02 0 .061-.041.087-.092.036-.067.03-.113-.005-.15-.041-.04-.082-.025-.15.057-.066.082-.071.123-.03.149.036.015.077.03.098.036zm-17.284-.051c.01 0 .02-.026.02-.052 0-.03-.025-.051-.056-.051-.03 0-.041.02-.02.051.015.026.04.052.056.052zm.55-.031a.618.618 0 00.128-.052c.01-.01 0-.04-.02-.077-.027-.046-.052-.04-.083.021a.108.108 0 01-.128.051c-.057-.02-.072-.01-.047.031.026.036.088.046.15.026zm.43.03c.052 0 .067-.03.052-.082-.015-.046-.01-.066.015-.05.026.015.062.01.077-.016.016-.026-.01-.062-.056-.077-.051-.02-.108.005-.149.056-.036.052-.057.108-.041.129.01.02.056.04.103.04zm1.017 0c.01 0 .036-.025.052-.05.015-.032-.006-.052-.052-.052s-.066.02-.051.051c.02.026.041.052.051.052zm7.713-.02c.02-.02.02-.051 0-.067-.02-.02-.036-.005-.036.036 0 .041.015.052.036.031zm1.12.02c.015 0 .025-.01.025-.025 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.02.025.026zm6.115 0c.01 0 .02-.01.02-.02s-.025-.041-.061-.062c-.036-.02-.047-.015-.02.021.02.03.045.062.06.062zm.097 0c.016 0 .026-.01.026-.025 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.015.02.025.026zm-16.79-.05c.015 0 .025-.011.025-.026 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.015.025.025.025zm1.18 0c.042 0 .077-.011.077-.021 0-.01-.035-.036-.077-.052-.04-.015-.077-.005-.077.02 0 .027.036.052.077.052zm7.549 0c.015 0 .025-.011.025-.026 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.015.025.026.025zm2.002 0c.016 0 .026-.011.026-.026 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.015.025.025.025zm.4 0c.026 0-.004-.052-.06-.114-.057-.061-.124-.092-.145-.072-.02.02.005.072.062.113a.407.407 0 00.144.072zm3.154-.021c.02-.02.02-.052 0-.067-.021-.02-.036-.005-.036.036 0 .036.015.051.036.03zm2.249.02c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.015.025.026.025zm-7.05-.113c.148-.051.148-.056.046-.128-.062-.041-.144-.062-.185-.046-.041.015-.077.061-.077.097 0 .036.015.082.03.103.016.015.098.005.185-.026zm7.42-.025c.03-.047.045-.113.03-.154-.015-.041-.041-.072-.062-.072a.425.425 0 00-.133.077c-.098.077-.098.077 0 .149.092.072.113.072.164 0zm-16.36.036c.025 0 .046-.021.046-.047 0-.025-.026-.061-.057-.082-.03-.02-.066-.02-.082-.005-.015.015-.01.051.005.082.026.026.062.052.088.052zm1.15-.01a.325.325 0 00.164-.032c.036-.02.077-.138.098-.256.03-.185.02-.21-.046-.19-.041.015-.093.005-.113-.026-.02-.03.015-.133.072-.226.092-.149.097-.18.03-.236-.04-.036-.123-.046-.18-.03-.066.02-.102.01-.102-.032 0-.036.082-.154.185-.256.17-.175.185-.216.19-.504.005-.195-.016-.313-.052-.313-.03 0-.133.026-.23.057a3.51 3.51 0 00-.417.174c-.133.067-.37.216-.523.329a2.93 2.93 0 00-.493.483c-.113.148-.206.323-.206.385 0 .077.072.159.242.267.133.082.292.154.354.154s.128.02.149.051c.015.026.097.051.185.051.087 0 .149.02.149.047 0 .025.097.056.215.066.129.016.272.031.329.036zm6.778.01c.015 0 .026-.01.026-.026s-.01-.026-.026-.026-.026.01-.026.026c0 .015.016.026.026.026zm.103 0c.015 0 .025-.01.025-.026s-.01-.026-.025-.026c-.016 0-.026.01-.026.026 0 .015.015.026.026.026zm2.582 0c.021 0 .072-.021.108-.047.052-.03.041-.051-.036-.072-.072-.02-.108-.005-.108.047-.005.036.016.072.036.072zm2.963 0c.016 0 .026-.01.026-.026s-.01-.026-.026-.026c-.015 0-.025.01-.025.026 0 .015.01.026.025.026zM1.74 17.7c.042 0 .078-.005.078-.016 0-.01-.021-.025-.047-.04-.025-.016-.061-.011-.077.015-.02.025.005.04.047.04zm.206.02c.01 0 .02-.01.02-.02s-.025-.041-.061-.062c-.036-.02-.046-.015-.02.02.02.037.046.062.06.062zm.164 0c.02 0 .067-.02.108-.046.041-.026.057-.067.041-.098-.015-.025-.082-.061-.138-.077-.103-.025-.103-.025-.016.072.087.098.087.098-.005.067-.067-.026-.082-.02-.057.026.016.025.047.056.067.056zm1.808 0c.025 0 .051-.01.051-.02s-.026-.036-.051-.057c-.031-.015-.052-.005-.052.02 0 .026.026.057.052.057zm.852 0c.046 0 .067-.025.046-.051a.098.098 0 00-.082-.051c-.026 0-.046.02-.046.05 0 .027.036.052.082.052zm.863 0c.046 0 .128-.046.19-.108.056-.056.092-.118.077-.133-.016-.016-.098.03-.19.108-.103.087-.129.133-.077.133zm12.796 0c.01 0 .02-.01.02-.02s-.025-.041-.061-.062c-.036-.02-.047-.015-.02.02.02.037.045.062.06.062zm-17.243-.077c.015-.015 0-.056-.036-.092-.051-.052-.056-.046-.03.03.025.052.05.078.066.062zm2.86.026c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .01.01.026.026.026zm7.035 0c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .01.01.026.026.026zm5.032 0c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .01.01.026.026.026zm.164-.02c.02-.021.02-.052 0-.067-.02-.021-.036-.006-.036.036 0 .035.016.05.036.03zm-11.83-.031c.01 0 .01-.062-.006-.14-.015-.076-.035-.112-.05-.076-.016.036-.011.097.004.144.02.036.041.072.052.072zm.42 0c.016 0 .026-.01.026-.026s-.01-.026-.025-.026c-.016 0-.026.01-.026.026 0 .015.01.026.026.026zm5.803 0c.015 0 .026-.01.026-.026s-.01-.026-.026-.026c-.015 0-.026.01-.026.026 0 .015.01.026.026.026zm.41-.067c.073-.031.124-.082.114-.113-.01-.026-.088-.052-.18-.057-.087-.005-.154.01-.144.026.01.015.031.072.046.118.026.072.052.077.165.026zm4.879.067c.015 0 .026-.01.026-.026s-.01-.026-.026-.026-.026.01-.026.026c0 .015.01.026.026.026zm-14.044-.052c.026 0 .051-.02.051-.051a.055.055 0 00-.05-.052.051.051 0 00-.052.052c0 .025.025.051.051.051zm8.452 0c.01 0 .02-.01.02-.02s-.025-.041-.061-.062c-.036-.02-.046-.015-.02.02.02.036.046.062.061.062zm-8.73-.051c.011 0 .021-.01.021-.02 0-.011-.025-.042-.061-.062-.036-.02-.046-.016-.02.02.02.036.045.062.06.062zm.17-.026c.016-.015 0-.051-.036-.087s-.061-.041-.061-.005c0 .03.015.067.036.087.015.015.046.015.061.005zm2.958.026c.041 0 .077-.02.077-.052 0-.025-.036-.035-.077-.02-.041.015-.077.041-.077.051 0 .01.036.02.077.02zm5.802 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026s.01.026.025.026zm8.031-.016c.057-.01.077-.056.067-.143a.763.763 0 00-.067-.216c-.046-.082-.056-.082-.205.026l-.154.113.138.118c.072.072.175.113.221.102zm-8.513-.05c.087.004.097-.006.046-.068-.036-.04-.082-.061-.108-.046-.026.016-.046.046-.046.067 0 .02.046.04.108.046zm5.925-.006c.041 0 .077-.02.077-.041 0-.02-.036-.041-.077-.041-.04 0-.077.02-.077.04 0 .027.036.047.077.042zm.324-.02c.077-.031.077-.037-.005-.052-.052-.01-.093-.041-.093-.072 0-.03-.01-.046-.025-.03-.016.015-.016.061.005.107.02.052.066.067.118.046zm1.73.04c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.026.026.026zm-15.97-.05c.016 0 .027-.011.027-.027 0-.015-.01-.025-.026-.025s-.026.01-.026.025c0 .016.01.026.026.026zm2.917 0c.041 0 .129-.047.2-.104a.696.696 0 00.19-.251c.037-.082.057-.18.047-.21-.01-.032-.087.01-.175.092-.082.082-.195.22-.246.308-.072.133-.072.164-.016.164zm11.651-.016c.041-.01.067-.134.077-.298.005-.154.026-.344.047-.426.03-.139.025-.144-.083-.082-.061.035-.128.102-.138.154-.016.051-.062.107-.103.123-.041.015-.103.015-.133-.005-.031-.02-.042-.01-.021.025.026.041-.01.062-.108.067-.133.005-.133.01-.02.031.082.015.102.036.061.062-.046.025-.03.046.041.066.057.016.098.01.083-.015-.016-.026.01-.057.056-.072.046-.015.067-.051.051-.077-.015-.026.031-.041.098-.041.072.005.128.026.128.051 0 .026-.046.057-.102.072-.057.016-.103.062-.103.103 0 .041.02.062.051.041.031-.015.052-.01.052.02 0 .031-.042.078-.093.108-.087.057-.087.057 0 .031.051-.015.087-.005.087.026 0 .03.036.051.072.036zM16.395 17c-.036 0-.051-.015-.036-.036.02-.02.052-.02.067 0 .02.02.005.036-.03.036zm-14.506.36c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026s.01.026.025.026zm2.958-.005c.015.005.057-.052.087-.124.031-.071.036-.128.01-.128-.025 0-.082.036-.123.077a.321.321 0 01-.195.082c-.102.005-.097.01.036.046.082.021.17.042.185.047zm-3.522-.047c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.025.026.025zm.102 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm.206 0c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.025.026.025zm8.94 0c.01 0 .02-.01.02-.02s-.026-.041-.062-.062c-.036-.02-.046-.015-.02.02.02.037.046.062.061.062zm.287 0c.108 0 .195-.025.195-.05 0-.032-.062-.078-.133-.104a.848.848 0 00-.196-.051c-.035 0-.061.046-.061.103 0 .082.036.102.195.102zm4.842 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.025.026.025zm.154 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.025.026.025zm.164-.056c.006 0 .01-.03.01-.067 0-.051-.035-.061-.112-.04-.108.03-.108.03-.016.066.062.02.113.041.118.041zm2.1.005c.016 0 0-.046-.03-.103-.031-.056-.067-.102-.082-.102-.016 0 0 .046.03.102.031.057.067.103.083.103zm-16.713-.082c.025-.015.046-.046.046-.067 0-.02-.036-.04-.077-.04s-.077.014-.077.035c0 .02.015.051.03.067.021.02.052.02.078.005zm.277.03c.015 0 .026-.01.026-.025 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.026.026.026zm16.231 0c.01 0 .02-.01.02-.02s-.025-.04-.06-.061c-.037-.021-.047-.016-.021.02.02.036.046.062.061.062zm-12.185-.05c.041 0 .108-.037.144-.083.062-.072.051-.082-.051-.061-.067.01-.134.046-.144.082-.015.03.01.061.051.061zm.062-.052c-.016 0-.026-.01-.026-.026 0-.015.01-.025.026-.025.015 0 .026.01.026.025 0 .016-.01.026-.026.026zm4.036.051c.026 0 .046-.01.046-.02s-.036-.046-.077-.082c-.067-.057-.072-.052-.046.02.015.046.051.082.077.082zm.38 0c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026s-.026.01-.026.026c0 .015.01.025.026.025zm7.394 0c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.025.026.025zm.775-.056c.041-.03.072-.149.072-.257 0-.108-.015-.205-.04-.22-.021-.016-.119.046-.216.133l-.175.16.144.122c.113.098.159.108.215.062zm-17.15-.01c.02-.02.02-.052 0-.067-.02-.02-.036-.005-.036.036.005.03.02.046.036.03zm.36 0c.02-.02.02-.052 0-.067-.021-.02-.036-.005-.036.036.005.03.02.046.035.03zm8.975 0a.669.669 0 01.21-.036c.088 0 .114-.02.093-.077-.015-.041-.092-.077-.164-.077-.108 0-.123.01-.057.056.062.041.041.046-.077.026-.087-.016-.123-.016-.087 0 .036.015.051.051.03.082-.025.041-.01.046.052.026zm7.143.015c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm-15.846-.051c.03 0 .056-.02.056-.052 0-.03-.01-.051-.02-.051s-.036.02-.057.051c-.02.026-.01.052.02.052zm3.142 0c.03 0 .087-.041.129-.093a.585.585 0 00.071-.128c0-.02-.03-.041-.071-.041-.042 0-.098.046-.129.097a.446.446 0 00-.051.129c0 .015.02.036.051.036zm4.442-.005c.005 0 .02-.026.03-.062.016-.041-.015-.072-.071-.072-.052-.005-.098.01-.098.036 0 .026.03.057.062.072.04.01.072.026.077.026zm.2.005c.01 0 .026-.031.041-.067.016-.036-.005-.067-.041-.067-.036 0-.056.031-.041.067.015.036.03.067.041.067zm6.285 0c.026 0 .036-.036.02-.077-.015-.041-.04-.077-.05-.077-.011 0-.021.036-.021.077.005.04.025.077.051.077zM1.12 17c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm3.076 0c.015 0 .041-.02.056-.051.016-.03.021-.051.006-.051-.016 0-.041.02-.057.051-.015.03-.02.051-.005.051zm13.304 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm.262 0c.01 0 .02-.02.02-.051 0-.03-.025-.051-.056-.051-.03 0-.04.02-.02.051.015.026.04.051.056.051zm.206 0c.01 0 .02-.01.02-.02s-.026-.041-.061-.062c-.036-.02-.047-.015-.021.02.02.037.046.062.062.062zM1.602 16.95c.01 0-.01-.036-.046-.077s-.077-.067-.093-.046c-.015.015.005.051.046.077a.49.49 0 00.093.046zm2.803 0c.01 0 .016-.062.016-.134 0-.077-.02-.112-.046-.087-.026.026-.031.087-.016.134.016.046.036.087.046.087zm.36 0c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .016.01.026.026.026zm1.397-.02c.015-.016 0-.067-.031-.119-.031-.051-.057-.077-.057-.061 0 .02.01.072.031.118.02.046.041.077.057.061zm-4.786-.031c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.026.026.026zm.524-.005c.036 0 .077-.021.097-.052.02-.03.026-.061.016-.072a.798.798 0 00-.195-.046c-.175-.036-.175-.03-.077.067.05.056.123.103.159.103zm8.56 0c.056 0 .082-.01.066-.026-.015-.016-.061-.02-.097-.005-.041.015-.026.03.03.03zm5.37-.047a.355.355 0 00.047-.154c0-.051-.016-.04-.047.026a.493.493 0 00-.046.154c0 .026.02.015.046-.026zm-6.29 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm.632-.02c.015-.016 0-.057-.03-.098-.032-.04-.047-.082-.027-.102.016-.016.01-.062-.01-.098a.507.507 0 01-.061-.144 1.014 1.014 0 01-.016-.19c0-.061-.015-.123-.036-.138-.02-.016-.036.04-.03.123.004.082.025.17.04.2.016.03.01.067-.015.082-.026.016-.062-.005-.077-.051s-.051-.067-.082-.046c-.03.015-.051.061-.051.092 0 .041.015.036.046-.01.036-.057.051-.052.077.036.02.056.082.164.138.241.057.067.118.118.134.103zm-.118-.185c-.01 0-.036-.026-.057-.057-.02-.03-.02-.066-.01-.077.015-.015.036.01.057.057.02.041.025.077.01.077zm.734.2c.051.005.051-.02.01-.097a.301.301 0 00-.18-.134.513.513 0 00-.215-.005c-.062.015-.046.026.046.03.077.006.139.032.139.057 0 .026-.031.052-.067.057-.036.005-.005.025.062.046.082.02.17.041.205.046zm6.809.005c.01 0 .036-.02.056-.051.016-.03.005-.051-.02-.051-.031 0-.057.02-.057.051 0 .026.01.051.02.051zm-13.335-.066c.02-.021.02-.052 0-.067-.02-.02-.036-.005-.036.036 0 .03.015.046.036.03zm1.109-.047a.804.804 0 00.17-.118c.046-.046.025-.061-.088-.056-.082.005-.149.02-.149.046 0 .02-.036.041-.082.041-.067 0-.072.015-.02.077.05.051.087.057.169.01zm.575.062c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .016.01.026.026.026zm10.424 0c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm.975 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm.75-.005c.02 0 .072-.057.118-.123a.6.6 0 00.082-.278.797.797 0 00-.036-.241c-.025-.072-.051-.056-.113.087a.542.542 0 01-.195.226c-.061.026-.113.077-.113.108 0 .03.052.092.113.139a.492.492 0 00.144.082zm-16.498-.098c.01-.03-.005-.082-.036-.118-.041-.04-.057-.036-.057.02 0 .042.016.098.036.119.02.02.046.01.057-.02zm8.714.052c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.026.026.026zm-8.288-.062c.067-.01.128-.046.139-.087.015-.047-.016-.062-.093-.052-.067.01-.128.047-.138.088-.021.046.01.066.092.051zm1.818.01c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.025.026.025zm.113-.015c.02-.02.02-.052 0-.067-.02-.02-.036-.005-.036.036 0 .03.015.046.036.03zm.55.015c.01 0 .035-.036.05-.077.016-.04.006-.077-.02-.077-.026 0-.051.036-.051.077s.01.077.02.077zm.26 0c.016 0 .027-.01.027-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.016.025.026.025zm1.362 0c.036 0 .051-.015.036-.036-.02-.02-.052-.02-.067 0-.02.02-.005.036.03.036zm1.915-.051a.57.57 0 00.113-.216c.015-.077.01-.149-.015-.164-.026-.015-.057.036-.072.113a2 2 0 01-.067.241c-.036.093-.03.093.041.026zm1.602.051c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.016.025.026.025zm.257 0c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.016.025.026.025zm5.648 0c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.016.025.026.025zm.59-.01c.072 0 .098-.01.062-.026a.184.184 0 00-.128 0c-.031.016 0 .026.067.026zm-11.116-.041c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.015.026.026.026zm11.322-.005c.015 0-.02-.031-.072-.072a.409.409 0 00-.195-.077c-.051 0-.092.01-.092.026 0 .015.077.046.164.071.097.026.185.047.195.052zm.087.005a.793.793 0 00.21-.103c.098-.061.18-.159.196-.241.015-.077.041-.175.051-.206.016-.05-.01-.046-.118.006a2.544 2.544 0 01-.344.133 3.551 3.551 0 00-.323.118c-.093.046-.129.041-.165-.015-.03-.046-.046-.052-.046-.016s.016.072.036.083c.02.01.134.035.247.05.18.027.19.027.077-.025l-.129-.056.129-.036c.097-.026.138-.01.164.056.02.052.026.129.005.17-.02.046-.015.082.01.082zm1.156-.015c.092.005.102 0 .04-.042a.349.349 0 00-.143-.05c-.036 0-.057.014-.041.04.015.026.077.046.144.052zM1.684 16.59c.015 0 .026-.01.026-.026s-.01-.026-.026-.026c-.015 0-.026.01-.026.026 0 .015.016.026.026.026zm2.578-.016c.02-.02.02-.051 0-.067-.02-.02-.036-.005-.036.036 0 .031.015.047.036.031zm.154 0c.02-.02.02-.051 0-.067-.02-.02-.036-.005-.036.036 0 .031.015.047.036.031zm1.412.016c.03 0 .036-.021.02-.052a.105.105 0 00-.082-.051c-.025 0-.036.02-.02.051.015.026.051.052.082.052zm4.02 0c.016 0 .026-.01.026-.026s-.01-.026-.026-.026c-.015 0-.025.01-.025.026 0 .015.015.026.025.026zm.889-.006c.005.006.01-.05.01-.118 0-.066-.036-.138-.082-.154-.046-.015-.118-.005-.154.031-.062.051-.062.067-.005.103.051.03.051.04-.01.051-.042.005-.01.026.076.046a.97.97 0 01.165.041zm5.078-.015c.02-.02.02-.051 0-.067-.02-.02-.036-.005-.036.036.005.036.02.052.036.031zm-13.92-.03c.01 0 .02-.011.02-.021 0-.01-.026-.041-.062-.062-.035-.02-.046-.015-.02.02.026.037.051.062.062.062zm3.132 0c.015 0 .025-.011.025-.026 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.025.026.025zm.205 0c.016 0 .026-.011.026-.026 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm.221 0c.01 0 0-.021-.015-.052-.016-.03-.062-.051-.093-.051-.036 0-.03.02.016.05.04.027.082.052.092.052zm.585-.006c.047-.005.047-.01-.005-.03-.061-.026-.061-.037 0-.073.057-.036.057-.046.005-.046-.036 0-.056-.02-.04-.04.015-.021-.032-.042-.098-.037a.318.318 0 00-.165.041c-.025.02 0 .026.057.005.067-.025.087-.02.062.02-.026.042-.01.047.046.027.046-.016.077-.01.072.015a.22.22 0 000 .082c0 .02.03.036.066.036zm.278-.036c.164-.02.18-.03.102-.082-.046-.036-.072-.077-.051-.098.02-.02 0-.02-.041-.005-.041.016-.123-.005-.18-.046-.097-.077-.097-.077.01-.056.083.015.103 0 .083-.057-.02-.056-.041-.061-.067-.015-.026.04-.062.025-.113-.052-.067-.092-.082-.097-.108-.03-.015.046-.067.077-.108.066-.04-.01-.077.01-.077.036 0 .031.02.057.046.057.031.005.062.01.077.02.016.005.042.02.067.026.02.005.093.03.154.051.062.02.118.057.118.083 0 .025-.02.046-.051.046-.03 0-.051.02-.051.04 0 .021.087.026.19.016zm-.519-.318c-.015 0-.026-.01-.026-.026 0-.015.01-.026.026-.026.015 0 .026.01.026.026s-.016.026-.026.026zm.205-.02c-.04 0-.061-.021-.046-.042.016-.026.046-.03.077-.015.026.015.046.036.046.046 0 .005-.035.015-.077.01zm-4.287.328c.03 0 .051-.026.051-.051 0-.031-.02-.052-.051-.052a.051.051 0 000 .103zm.41 0a.6.6 0 00.124-.03c.046-.016.082-.052.082-.073 0-.02-.051-.051-.113-.067-.062-.015-.128-.02-.154-.005-.02.016-.026.057-.01.103.015.036.046.072.072.072zm-.025-.103c-.015 0-.026-.01-.026-.026 0-.015.01-.025.026-.025.015 0 .026.01.026.025 0 .016-.016.026-.026.026zm1.848.103c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm.591 0c.03 0 .051-.026.051-.051 0-.031-.02-.052-.051-.052-.03 0-.051.02-.051.052 0 .025.02.05.051.05zm2.588 0c.144 0 .298-.02.339-.046.061-.041.061-.052-.026-.083-.056-.02-.17-.056-.251-.087a1.185 1.185 0 01-.293-.18c-.082-.066-.149-.154-.149-.195 0-.04-.01-.072-.02-.072a.788.788 0 00-.155.062c-.071.03-.128.077-.128.098 0 .02.02.051.046.066.026.016.057.072.072.129.02.087.01.092-.067.04-.051-.03-.082-.086-.066-.117.015-.036 0-.077-.026-.093-.03-.015-.067-.005-.087.026-.02.03.02.113.082.18.067.066.149.113.18.102.035-.015.112.02.174.077.077.062.19.093.375.093zm-.098-.051c-.015 0-.025-.01-.025-.026s.01-.026.025-.026c.016 0 .026.01.026.026 0 .015-.015.026-.026.026zm-.102-.052c-.016 0-.026-.01-.026-.026 0-.015.01-.025.026-.025.015 0 .025.01.025.025 0 .016-.015.026-.025.026zm-.103-.051c-.015 0-.026-.01-.026-.026 0-.015.01-.026.026-.026.015 0 .026.01.026.026s-.016.026-.026.026zm-.098-.052c-.01 0-.05-.04-.087-.092-.061-.082-.061-.082.02-.02.052.04.093.077.093.092s-.015.02-.026.02zm-.364-.205c-.016 0-.026-.01-.026-.026 0-.015.01-.025.026-.025.015 0 .026.01.026.025 0 .016-.016.026-.026.026zm.257-.103c-.016 0-.026-.01-.026-.025 0-.016.01-.026.026-.026.015 0 .025.01.025.026 0 .015-.015.025-.025.025zm1.34.498c.015-.015.02-.061.005-.097-.015-.041-.03-.03-.03.03-.006.057.004.083.025.067zm7.646.016c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm1.976 0c.031 0 .052-.01.052-.02 0-.011-.02-.037-.052-.057-.03-.016-.05-.005-.05.02 0 .031.02.057.05.057zm-12.606-.051c.016 0 .026-.01.026-.026s-.01-.026-.026-.026c-.015 0-.025.01-.025.026 0 .015.01.026.025.026zm.591 0c.026 0 .046-.01.046-.021 0-.01-.036-.036-.082-.051-.046-.016-.067-.01-.046.02.02.026.056.052.082.052zm1.001 0c.016 0 .026-.01.026-.026s-.01-.026-.026-.026c-.015 0-.025.01-.025.026 0 .015.01.026.025.026zm3.749 0c.015 0 .025-.01.025-.026s-.01-.026-.025-.026c-.016 0-.026.01-.026.026 0 .015.01.026.026.026zm5.448-.016c.02-.02.02-.051 0-.067-.02-.02-.036-.005-.036.036.005.031.02.047.036.031zm2.105.016c.02 0 .077-.036.128-.088.062-.056.093-.154.093-.292a.705.705 0 00-.046-.283c-.036-.056-.052-.046-.083.041a.312.312 0 01-.184.165c-.083.03-.15.071-.15.097 0 .026.047.093.103.149.057.056.103.128.103.154.005.03.02.057.036.057zm-13.458-.052c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm.77 0c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025s-.026.01-.026.025c0 .016.01.026.026.026zm12.272 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .016.01.026.026.026zm-15.677-.072c.083-.005.119-.04.124-.133a.296.296 0 00-.062-.195c-.041-.041-.072-.052-.077-.031-.005.026 0 .061 0 .087.005.026-.026.03-.067.016-.056-.021-.072.005-.056.107l.02.144c0 .01.052.01.118.005zm.047-.061c-.031.02-.067.01-.088-.02-.02-.032-.025-.068-.015-.078.01-.01.051 0 .087.02.046.031.052.057.016.078zm2.721.04c.046-.045.046-.076 0-.122-.046-.047-.061-.036-.061.061 0 .098.015.108.061.062zm.144.016a.098.098 0 00.051-.082c0-.03-.02-.046-.051-.046-.026 0-.051.036-.051.082 0 .046.025.062.05.046zm.334.026c.015 0 .005-.046-.026-.103-.041-.082-.036-.113.046-.154.057-.03.221-.072.375-.097.262-.047.267-.047.067-.052a.687.687 0 01-.319-.087c-.061-.046-.113-.062-.113-.046 0 .02.042.066.093.102.067.052.072.067.015.072-.04 0-.113-.036-.164-.082-.051-.046-.113-.067-.144-.046-.03.02-.056.056-.056.082 0 .026.051.046.113.046.061 0 .092.016.072.036-.02.02-.077.036-.124.041-.046 0-.102-.02-.123-.051-.02-.03-.01-.077.02-.113.042-.051.031-.067-.035-.067-.062 0-.082.031-.062.103.016.056.005.103-.02.103-.026 0-.047.02-.047.05 0 .027.072.042.154.032.083-.01.154 0 .154.015 0 .016-.03.067-.061.108-.057.062-.052.062.02.01.067-.051.088-.046.113.016.01.046.036.082.052.082zm.375 0c.015 0 0-.036-.036-.077s-.047-.103-.026-.144c.03-.051.026-.051-.03-.005-.057.051-.057.077 0 .144.035.046.076.082.092.082zm2.423 0c.031 0 .057-.02.057-.052 0-.03-.01-.05-.02-.05-.011 0-.037.02-.057.05-.02.026-.01.052.02.052zm9.217 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026s.015.026.025.026zM2.28 16.282c.03 0 .097-.025.154-.05.056-.032.097-.073.097-.098 0-.026-.056-.057-.128-.067-.072-.016-.113-.005-.103.015.016.02 0 .057-.025.072-.026.015-.052.057-.052.082 0 .026.026.046.057.046zm5.376-.005c.005 0 .087-.04.18-.097a.727.727 0 01.308-.103c.077 0 .143-.02.143-.051 0-.026-.107-.052-.246-.052a1.69 1.69 0 01-.442-.071 1.006 1.006 0 01-.297-.16c-.077-.072-.103-.072-.108-.015a.409.409 0 000 .113c.005.026-.016.026-.047.01-.03-.02-.035-.056-.02-.087.02-.036.01-.041-.03-.016a.084.084 0 00-.037.103c.016.036-.005.062-.04.062-.037 0-.057-.036-.042-.082.015-.057.005-.052-.036.01-.051.077-.036.118.087.241.083.082.18.15.216.15.062 0 .062-.011 0-.088-.062-.082-.062-.082.015-.02a.969.969 0 00.232.112c.087.02.154.041.164.041zm-.58-.251c-.016 0-.026-.01-.026-.026 0-.015.01-.026.026-.026.015 0 .025.01.025.026 0 .015-.01.026-.025.026zm3.26.256c.036 0 .052-.015.036-.035-.02-.021-.051-.021-.067 0-.02.02-.005.035.031.035zm.385 0c.047 0 .088-.077.108-.225a.895.895 0 000-.334c-.02-.062-.077-.108-.138-.108-.057 0-.088.026-.072.051.02.031-.031.057-.113.057-.108.005-.118.01-.041.03.056.016.159.072.23.129l.129.103-.149-.036c-.123-.031-.144-.026-.118.046.026.067-.01.087-.185.103l-.215.02.246.01c.133.006.241.026.236.047a.196.196 0 000 .077c.005.015.041.03.082.03zm6.794-.046c.01-.036.01-.077-.01-.097a.047.047 0 00-.062 0c-.016.015-.01.061.01.097.036.052.046.052.062 0zm-9.454-.051c.108-.02.119-.036.052-.051-.052-.01-.118 0-.144.03-.036.036 0 .041.092.02zm7.59.046c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm1.694 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm-15.25-.051c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026s-.026.01-.026.026.01.026.026.026zm3.44 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026s.01.026.026.026zm4.57 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026s.01.026.026.026zm5.982 0c.036 0 .052-.016.036-.036-.02-.02-.051-.02-.067 0-.02.02-.005.036.031.036zm1.104 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026s.01.026.025.026zm-15.815-.052c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.025.026.025zm4.056 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm10.963-.005c.016 0-.02-.03-.072-.072a.454.454 0 00-.23-.071c-.108.005-.098.015.071.071l.231.072zm-14.357-.051c.057 0 .083-.01.067-.026-.015-.015-.062-.02-.097-.005-.042.016-.026.026.03.031zm1.967-.015c.02-.021.02-.052 0-.067-.02-.02-.036-.005-.036.036 0 .036.015.051.036.03zm11.697.02c.01 0 .036-.026.057-.051.015-.031.005-.052-.02-.052-.027 0-.057.02-.057.052-.006.025.005.051.02.051zm.873-.005c.03 0 .103-.041.16-.092a.742.742 0 00.164-.2.557.557 0 00.061-.165c0-.03-.077-.01-.164.046-.123.077-.267.103-.55.108-.21.005-.344.015-.292.03.051.016.077.047.061.073-.015.025.005.046.047.046.04 0 .092-.02.107-.051.016-.026.067-.052.108-.052.041 0 .072.026.072.057 0 .03-.036.04-.077.025s-.077-.015-.077-.005c0 .016.077.062.164.098.093.051.19.082.216.082zM1.54 15.985a.184.184 0 000-.129c-.015-.036-.025-.005-.025.062 0 .072.01.103.025.067zm1.089.04c.056 0 .118-.02.133-.045.016-.026-.015-.072-.072-.103-.056-.031-.102-.046-.102-.031a.5.5 0 01-.031.103c-.026.051-.005.077.072.077zm1.828 0c.015 0 .026-.01.026-.025 0-.015-.01-.026-.026-.026s-.026.01-.026.026c0 .015.016.026.026.026zm1.438 0c.015 0 .025-.01.025-.025 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.015.026.026.026zm.215-.02c.02-.02.02-.051 0-.067-.02-.02-.036-.005-.036.036 0 .036.016.052.036.031zm4.303.016c.057 0 .077-.016.041-.031-.036-.016-.051-.046-.036-.072.016-.026-.02-.046-.077-.046-.056 0-.107.02-.107.04a.12.12 0 00.035.078c.021.02.083.03.144.03zm-.102-.047c-.016 0-.026-.01-.026-.025 0-.016.01-.026.026-.026.015 0 .025.01.025.026 0 .015-.01.025-.025.025zm2.351-.128c.026-.113.031-.231.016-.267-.016-.036-.052-.067-.077-.067-.026 0-.052.077-.052.175 0 .097.016.215.036.267.026.077.041.051.077-.108zm4.791.18c.01 0 .02-.01.02-.02 0-.011-.025-.042-.061-.062-.036-.021-.046-.016-.02.02.02.036.05.062.061.062zm-15.507-.052c.01 0 .02-.02.02-.051 0-.03-.025-.051-.056-.051-.03 0-.041.02-.02.051.02.026.046.051.056.051zm.149 0c.04 0 .077-.025.077-.056 0-.03.02-.041.046-.026.026.016.062.005.082-.02.016-.031.016-.052-.01-.052-.02 0-.092.016-.16.031-.06.016-.112.051-.112.077 0 .026.036.046.077.046zm2.26 0c.015 0 .025-.01.025-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.016.025.026.025zm1.899 0c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.016.025.026.025zm.575-.015c.02-.02.02-.051 0-.067-.02-.02-.036-.005-.036.036.005.031.02.046.036.031zm8.185.015c.036 0 .051-.015.036-.036-.02-.02-.051-.02-.067 0-.025.021-.01.036.031.036zm-9.068-.056c.056 0 .082-.01.067-.026-.016-.015-.062-.02-.098-.005-.04.016-.03.03.03.03zm2.198 0c.174.005.287-.026.4-.108.082-.062.154-.133.154-.154 0-.02-.056-.03-.123-.01a1.439 1.439 0 01-.421-.026c-.164-.03-.324-.082-.354-.113-.041-.041-.02-.051.072-.026.071.021.313.047.539.062.405.03.416.026.575-.128.092-.088.17-.165.17-.17 0-.005-.15-.005-.335.005-.21.01-.42-.01-.564-.061-.129-.041-.216-.057-.2-.031.015.026.01.051-.021.051s-.062.052-.077.108c-.02.072-.057.098-.108.077-.046-.015-.082-.01-.082.02 0 .031-.041.052-.093.052-.056.005-.066.015-.025.03.051.021.051.042.005.098-.031.041-.082.072-.108.072-.026 0-.036-.02-.02-.04.015-.026-.006-.042-.047-.042-.04 0-.066.041-.061.087.005.057.036.077.082.062.046-.02.061-.005.04.03-.02.037.016.073.109.093.077.016.164.041.195.052.03.01.164.01.298.01zm6.562.005c.036 0 .051-.015.036-.036-.02-.02-.051-.02-.067 0-.026.02-.01.036.031.036zm2.798 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm-14.526-.072a.507.507 0 01.128-.03c.026 0 .047-.021.047-.047s-.052-.077-.113-.123c-.113-.072-.118-.067-.129.077-.01.118.005.149.067.123zm1.535.02c.016 0 .026-.01.026-.025 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.026.025.026zm1.053 0c.036 0 .051-.015.036-.035-.02-.02-.051-.02-.067 0-.026.02-.01.036.031.036zm.59 0c.016 0 .026-.01.026-.025 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.026.025.026zm8.386-.004c.01 0 0-.021-.016-.047a.74.74 0 00-.22-.138c-.103-.046-.211-.098-.237-.108-.025-.01-.025.005-.005.041.02.036.134.103.252.16.113.045.215.092.226.092zm1.114.005c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.026.026.026zm.16-.016c.014-.015.02-.061.004-.097-.015-.041-.03-.031-.03.03-.006.057.004.088.025.067zm2.053-.061a.427.427 0 00.067-.252v-.16l-.129.145c-.107.123-.118.164-.066.251.056.108.061.108.128.016zm-16.026.025c.01 0 .02-.01.02-.02s-.025-.041-.06-.062c-.037-.02-.047-.015-.021.02.025.037.051.062.061.062zm.231 0c.031 0 .052-.02.052-.051 0-.03-.02-.051-.052-.051-.03 0-.051.02-.051.051 0 .03.02.051.051.051zm3.23 0c.03 0 .057-.02.057-.051 0-.03-.01-.051-.021-.051-.01 0-.036.02-.056.051-.021.03-.01.051.02.051zm.431-.015a.124.124 0 00.072-.072c.01-.03-.015-.051-.051-.051a.07.07 0 00-.072.072c0 .04.026.061.051.05zm.21 0c.042 0 .063-.02.047-.041a.09.09 0 00-.077-.041c-.03 0-.046.02-.046.04.005.021.036.042.077.042zm9.608.015c.01 0 .02-.02.02-.051 0-.026-.025-.051-.056-.051-.03 0-.04.025-.02.051.02.03.046.051.056.051zm2.105 0c.01 0 .021-.01.021-.02s-.026-.041-.062-.062c-.036-.02-.046-.015-.02.02.026.037.051.062.061.062zm-15.44-.051c.03 0 .087-.015.134-.03.046-.016.082-.047.082-.073 0-.025-.052-.036-.113-.03-.062.005-.123.035-.134.071-.01.031 0 .062.031.062zm1.787-.015c.02-.021.02-.052 0-.067-.02-.02-.036-.005-.036.036 0 .03.015.046.036.03zm.678.015c.025 0 .061-.036.077-.082a.803.803 0 00.03-.103c0-.01-.025-.02-.056-.02-.03 0-.041.025-.02.05.015.032.005.052-.02.052-.032 0-.057.026-.057.052 0 .03.02.051.046.051zm.185 0c.04 0 .077-.02.077-.051 0-.026-.036-.036-.077-.02-.041.014-.077.04-.077.05 0 .01.036.021.077.021zm1.412 0c.036 0 .051-.015.036-.036-.02-.02-.052-.02-.067 0-.02.02-.005.036.03.036zm.41 0c.036 0 .052-.015.036-.036-.02-.02-.05-.02-.066 0-.02.02-.005.036.03.036zm3.107 0c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .016.016.026.026.026zm-7.24-.082c.046-.016.082-.052.082-.082 0-.026-.026-.041-.061-.031a.13.13 0 00-.083.082c-.015.036.01.051.062.03zm1.91.015c.02-.02.02-.051 0-.067-.02-.02-.036-.005-.036.036 0 .031.016.047.036.031zm.611.016c.072 0 .077-.016.02-.077a.258.258 0 00-.174-.072c-.103.005-.103.01.005.03.062.01.103.047.088.072-.01.026.015.047.061.047zm.478 0c.01 0 0-.02-.016-.052a.13.13 0 00-.092-.051c-.036 0-.03.02.015.051.041.026.082.052.093.052zm1.289 0c.035 0 .05-.016.035-.036-.02-.02-.05-.02-.066 0-.02.02-.005.036.03.036zm3.209 0c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.016.026.026.026zm1.206 0c.01 0-.03-.057-.097-.129-.067-.072-.139-.128-.164-.128-.026 0 .02.056.097.128.077.067.15.123.164.129zm3.261 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.016.026.026.026zm-12.58-.052c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.016.025.026.025zm.138-.02l.165-.067c.072-.026.087-.067.061-.16-.02-.092-.01-.117.036-.102.036.01.062.062.052.108-.01.046.02.082.061.082.041 0 .082-.041.082-.087 0-.077.01-.077.047-.016.025.042.066.057.087.031.02-.025.01-.056-.02-.067-.037-.01-.062-.05-.062-.087 0-.04.046-.056.133-.04.088.015.124.004.103-.032-.02-.03-.082-.051-.144-.046a.162.162 0 00-.133.098c-.016.051-.041.092-.062.092-.02 0-.051-.036-.072-.077-.025-.062-.046-.067-.133-.015-.057.036-.098.107-.093.164.005.062-.02.103-.061.103a.11.11 0 00-.098.072c-.01.056.005.066.051.046zm1.356.02c.041 0 .072-.02.072-.051 0-.026-.046-.051-.108-.051-.056 0-.092.025-.072.05.02.027.067.052.108.052zm.724-.015c.015-.016.02-.062.005-.098-.015-.04-.03-.03-.03.031-.006.057.004.087.025.067zm.406.015c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.025.026.025zm1.324 0c.01 0 .031-.046.047-.102.02-.088.01-.093-.072-.052-.052.031-.098.067-.098.077 0 .016.02.01.052-.005.03-.015.05-.005.05.02 0 .026.011.062.021.062zm.237 0c.03 0 .056-.02.056-.051 0-.026-.01-.051-.02-.051s-.036.025-.057.05c-.02.032-.01.052.02.052zm.236 0c.01 0 .02-.01.02-.02s-.025-.041-.061-.062c-.036-.02-.046-.015-.02.02.025.037.05.062.06.062zm.23-.005c.073 0 .098-.01.063-.025a.184.184 0 00-.129 0c-.036.01-.005.025.067.025zm.386.005c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.025.026.025zm8.627 0c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.025.026.025zm.128 0c.03 0 .051-.03.051-.061 0-.041.016-.036.052.015.04.067.051.062.051-.01 0-.057-.036-.087-.103-.087-.056 0-.102.035-.102.077 0 .03.02.066.05.066zm.734-.005c.077 0 .206-.03.288-.072.077-.04.226-.17.328-.282.103-.113.19-.22.19-.241 0-.016-.04 0-.092.04a.598.598 0 00-.113.103.912.912 0 01-.18.108 1.643 1.643 0 01-.36.113c-.179.03-.19.041-.102.093.098.056.098.056 0 .092-.087.041-.082.046.041.046zm1.032-.01c.041 0 .062-.02.047-.041a.09.09 0 00-.077-.041c-.031 0-.047.02-.047.04 0 .021.036.042.077.042zm-13.14-.036c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm.873 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm.103 0c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025s-.026.01-.026.025c0 .016.01.026.026.026zm.334 0c.025 0 .046-.02.046-.041 0-.02-.036-.041-.077-.041s-.062.02-.046.04c.015.021.051.042.077.042zm10.5-.01c.083 0 .124-.01.093-.026a.261.261 0 00-.154 0c-.052.015-.026.026.061.026zm1.13.01c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .016.01.026.026.026zm-14.537-.051c.01 0 .036-.02.057-.052.015-.025.005-.051-.02-.051-.032 0-.057.026-.057.051-.005.026.005.052.02.052zm.822 0c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.016.026.026.026zm.308 0c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.016.026.026.026zm.58 0c.02 0 .067-.02.103-.047.051-.03.03-.046-.062-.046-.072 0-.118.02-.102.046.015.026.046.047.061.047zm1.007 0c.01 0 .015-.036.015-.077 0-.042-.02-.062-.041-.047-.026.016-.03.047-.015.077.015.026.036.047.04.047zm1.283 0c.041 0 .088-.036.103-.077.015-.042.015-.077 0-.077s-.062.035-.103.077c-.066.066-.066.077 0 .077zm3.882 0c.036 0 .052-.016.036-.036-.015-.02-.051-.02-.066 0-.016.02-.006.036.03.036zm4.083 0c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026.005.015.015.026.026.026zm.77 0c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026.005.015.015.026.026.026zm-13.495-.072c.02-.02.02-.052 0-.067-.02-.02-.036-.005-.036.036 0 .036.016.051.036.03zm1.48.02c.015 0 .025-.01.025-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm3.07-.036c.02-.01.026-.046.01-.072-.015-.025-.061-.046-.103-.046-.04 0-.071.02-.071.046s.03.057.061.072c.036.01.082.01.103 0zm9.032.036c.01 0 .02-.061.026-.138.005-.103-.005-.118-.041-.062-.036.051-.041.015-.02-.108.02-.133.014-.154-.021-.077-.047.103-.047.103-.057 0-.005-.056-.02-.077-.03-.04-.016.03.01.143.05.24.047.103.088.185.093.185zm1.941 0c.036 0 .051-.015.036-.036-.015-.02-.051-.02-.067 0-.015.02-.005.036.031.036zm-13.222-.051c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.016.026.026.026zm1.52 0c.025 0 .036-.036.015-.077-.015-.041-.051-.062-.077-.046-.026.015-.03.051-.015.077a.104.104 0 00.077.046zm.431 0c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .016.016.026.026.026zm.95 0c.03 0 .056-.02.056-.051 0-.026-.01-.052-.02-.052s-.036.026-.057.052c-.02.025-.01.05.021.05zm3.338-.016c.097 0 .138-.01.092-.025a.355.355 0 00-.18 0c-.051.015-.01.025.088.025zm2.156-.061a.493.493 0 00.046-.154c0-.026-.02-.016-.046.026a.355.355 0 00-.046.154c.005.05.02.04.046-.026zm1.181.077c.036 0 .052-.016.036-.036-.02-.02-.051-.02-.067 0-.015.02-.005.036.031.036zm.848 0c.056 0 .077-.057.066-.216l-.01-.22-.026.205-.025.205-.036-.23-.036-.232-.01.247c.005.18.02.24.077.24zm.251 0c.01 0 .03-.067.041-.154.01-.082.005-.154-.02-.154-.02 0-.041.072-.041.154s.01.154.02.154zm.832-.036c.041-.015.077-.051.077-.077a.477.477 0 00-.057-.154 2.245 2.245 0 01-.123-.447c-.04-.21-.072-.282-.072-.19-.005.082-.015.21-.03.283-.021.107-.021.113.02.025.036-.077.046-.03.041.18 0 .154.01.313.031.344.02.036.072.051.113.036zm-.046-.087c-.01.01-.036-.041-.057-.113-.02-.077-.025-.15-.01-.16.01-.01.036.042.056.113.016.078.021.15.01.16zm.477.123c.031 0 .052-.026.052-.051 0-.031-.02-.052-.052-.052-.03 0-.051.02-.051.052 0 .025.026.05.051.05zM2.814 15.41c.046 0 .082-.01.082-.021 0-.01-.02-.036-.046-.051-.026-.016-.062-.005-.083.02-.02.026 0 .052.047.052zm.23 0c.032 0 .052-.026.052-.052 0-.03-.02-.051-.051-.051-.031 0-.052.02-.052.051 0 .026.026.052.052.052zm.18 0c.016 0 .026-.01.026-.026s-.01-.026-.026-.026c-.015 0-.025.01-.025.026.005.015.015.026.025.026zm1.212 0c.036 0 .052-.016.036-.036-.02-.02-.051-.02-.067 0-.025.02-.01.036.031.036zm1.623 0c.01 0 .02-.01.02-.021 0-.01-.04-.051-.092-.087-.082-.062-.082-.062-.02.02a.392.392 0 00.092.088zm4.21-.077a1.09 1.09 0 01.262-.077c.041 0 .108.035.154.077.041.04.098.077.129.077.03 0 .03-.042-.005-.098a.64.64 0 00-.16-.175c-.061-.04-.154-.061-.215-.04-.103.025-.098.035.04.066.124.026.134.036.037.041a.873.873 0 00-.267.082c-.082.041-.154.088-.154.103-.005.01.077-.015.18-.056zm2.321.077c.01 0 .01-.062-.005-.134-.015-.072.016-.267.062-.426a2.34 2.34 0 01.154-.396c.062-.092.062-.092.026.006-.02.056-.041.148-.052.205-.01.056-.04.17-.072.246a.785.785 0 00-.056.206c0 .036.036-.02.082-.118a1.54 1.54 0 00.103-.334c.015-.082.03-.21.04-.282a1.72 1.72 0 01.18-.422c.103-.184.144-.302.114-.323-.031-.02-.057-.015-.057.01 0 .02-.051.098-.108.17l-.108.128.108-.18c.057-.097.134-.18.175-.18.04 0 .067-.05.072-.112.005-.062-.016-.103-.041-.088-.026.016-.036.047-.02.067.01.02-.021.036-.073.036-.082 0-.087-.01-.025-.097.05-.072.056-.134.015-.257a1.403 1.403 0 00-.154-.303c-.051-.077-.134-.144-.18-.144-.046 0-.108-.041-.144-.087-.056-.077-.087-.077-.2-.026-.077.036-.123.041-.103.01.016-.03.01-.051-.02-.051a.682.682 0 00-.185.051c-.087.036-.123.036-.103 0 .016-.03.005-.051-.03-.051-.036 0-.237.098-.447.21-.21.114-.663.396-1.001.617-.34.22-.647.405-.683.405-.036 0-.083-.02-.093-.046-.015-.026.082-.133.216-.246a5.48 5.48 0 01.385-.298c.077-.051.133-.103.118-.118-.015-.016-.18.087-.375.22-.19.134-.303.196-.251.134.071-.082.077-.108.025-.108-.04 0 .02-.082.134-.18.113-.097.524-.364.909-.6.39-.231.708-.432.708-.442 0-.01-.051-.005-.113.01-.066.021-.04-.01.062-.071.097-.057.144-.103.103-.103-.057 0-.062-.016-.016-.041.036-.026-.015-.041-.128-.041-.185 0-.185 0-.052.051l.14.051-.211.093c-.119.051-.221.087-.231.077-.01-.01.05-.052.138-.087.113-.047.139-.077.093-.108a.29.29 0 00-.144-.041c-.062 0-.062.01-.01.04.056.037.05.052-.021.078-.051.02-.113.01-.144-.02-.04-.042-.025-.047.041-.021.067.025.088.02.062-.02-.02-.037.015-.083.103-.114.077-.03.174-.04.22-.02.047.015.062.01.036-.01-.02-.021.047-.067.154-.098l.196-.057-.226-.04c-.124-.021-.2-.057-.165-.078.031-.02-.108-.03-.313-.025a2.266 2.266 0 00-.596.092c-.123.041-.205.056-.19.036a.475.475 0 01.196-.082c.092-.02.138-.046.107-.057-.03-.01-.195.026-.36.082a2.432 2.432 0 01-.353.103c-.031 0 .015-.03.102-.067l.154-.066-.23-.041c-.206-.036-.216-.047-.103-.083.071-.02.174-.04.23-.04.103 0 .103 0 0 .04-.066.026-.071.047-.025.047.041 0 .123-.02.18-.047.087-.036.087-.046.01-.046-.051 0-.092-.025-.092-.046 0-.02-.155 0-.35.056-.19.057-.508.108-.708.119-.226.01-.324 0-.257-.026.056-.026.087-.046.067-.046-.02 0-.21.03-.421.072-.21.04-.437.097-.493.128-.077.041-.129.041-.195 0-.083-.057-.083-.057 0-.03.051.015.087.004.087-.021 0-.026.139-.077.308-.108.17-.036.298-.072.288-.082-.01-.01-.237.015-.504.061s-.498.103-.523.123c-.026.021.04.057.149.077.102.021.23.062.277.093.061.041.128.03.236-.026a2.28 2.28 0 01.365-.133c.123-.031.261-.041.328-.016.098.036.057.062-.251.165-.2.066-.365.143-.365.164 0 .02.015.041.041.041.026 0 .2-.067.4-.149.196-.082.427-.16.514-.174.087-.016.123-.01.082 0-.061.02-.061.03 0 .066.046.031.01.036-.108.02-.107-.015-.143-.01-.092.016.067.031.02.067-.216.16-.17.066-.308.143-.308.169 0 .03.036.036.093.015l.529-.21c.24-.093.503-.17.59-.17.103 0 .005.052-.298.154a5.864 5.864 0 00-.631.247l-.18.092.262.2c.144.108.349.33.452.488.102.16.226.38.272.498.056.15.067.237.03.303-.03.062-.03.103 0 .124.031.02.016.082-.05.159-.057.072-.119.118-.13.102-.014-.015-.045.031-.071.103l-.046.129.144-.134c.077-.077.24-.185.359-.246l.216-.113.55.092c.436.072.615.128.852.267.169.098.39.257.498.354.123.108.256.319.359.56.108.185.195.36.205.365zm-.01-.74c-.02.02-.036.005-.036-.036 0-.04.016-.051.036-.036.02.026.02.057 0 .072zm.041-.133c-.015 0-.025-.01-.025-.026 0-.015.01-.026.025-.026.016 0 .026.01.026.026 0 .01-.01.026-.026.026zm.046-.108c-.01.01-.02.005-.02-.016 0-.02.036-.102.077-.19a.51.51 0 01.103-.154c.015 0-.01.077-.062.17-.041.092-.087.18-.098.19zm-.534-.098c-.025.041-.05.057-.05.026 0-.026.02-.087.05-.128.026-.042.052-.052.052-.026s-.02.087-.052.128zm.077-.205c-.015 0-.025-.01-.025-.026 0-.015.01-.026.025-.026.016 0 .026.01.026.026s-.01.026-.026.026zm.047-.103c-.016 0-.01-.02.005-.051.015-.026.04-.052.056-.052s.01.026-.005.052c-.015.025-.041.051-.056.051zm.621 0c-.015 0-.026-.01-.026-.026 0-.015.01-.025.026-.025.015 0 .026.01.026.025 0 .016-.01.026-.026.026zm-1.094-.051c-.015 0 .031-.057.093-.129a.683.683 0 01.143-.128c.016 0-.03.057-.092.128a.57.57 0 01-.144.129zm.575-.103c-.01 0-.02-.01-.02-.02s.04-.052.092-.088c.082-.061.082-.061.02.02a.392.392 0 01-.092.088zm-1.304-.354c-.18.123-.195.128-.077.025.082-.071.257-.205.385-.292.18-.123.195-.129.077-.026a4.946 4.946 0 01-.385.293zm1.874.149c-.015 0-.025-.01-.025-.026 0-.015.01-.026.025-.026.016 0 .026.01.026.026 0 .015-.01.026-.026.026zm-1.489-.052c-.015 0-.025-.01-.025-.025 0-.016.01-.026.025-.026.016 0 .026.01.026.026 0 .015-.01.025-.026.025zm1.125 0c-.016 0-.01-.02.005-.051.015-.026.04-.051.056-.051s.01.025-.005.051c-.015.026-.04.051-.056.051zm-.91-.159l-.158.123.138-.148c.077-.083.15-.14.16-.124.01.016-.052.082-.14.15zm.55.108c-.015 0-.01-.02.005-.051.016-.026.041-.052.057-.052.015 0 .01.026-.005.052-.016.025-.041.051-.057.051zm.57-.205c-.015 0-.025-.01-.025-.026 0-.015.01-.026.025-.026.016 0 .026.01.026.026.005.015-.01.026-.026.026zm-.36-.052c-.015 0-.025-.01-.025-.025 0-.016.01-.026.026-.026.015 0 .025.01.025.026.006.015-.01.025-.025.025zm-1.437-.051c-.015 0-.026-.01-.026-.026 0-.015.01-.025.026-.025.015 0 .026.01.026.025.005.016-.01.026-.026.026zm.924 0c-.015 0-.025-.01-.025-.026 0-.015.01-.025.025-.025.016 0 .026.01.026.025.005.016-.01.026-.026.026zm-.821-.051c-.016 0-.026-.01-.026-.026s.01-.026.026-.026c.015 0 .025.01.025.026.006.015-.01.026-.025.026zm1.417 0c-.015 0 .041-.057.123-.129.082-.072.175-.128.2-.128.026 0-.03.056-.123.128a1.162 1.162 0 01-.2.129zm-.858-.103c-.015 0-.01-.02.006-.051.015-.026.04-.052.056-.052.015 0 .01.026-.005.052-.015.025-.041.05-.057.05zm-.22-.16l-.18.119.154-.134c.082-.072.175-.133.2-.133.026 0 .036.005.026.015-.015.01-.103.072-.2.134zm.744.109c-.015 0-.025-.01-.025-.026s.01-.026.025-.026c.016 0 .026.01.026.026 0 .015-.016.026-.026.026zm-.308-.108c-.03 0-.005-.036.051-.077.057-.041.15-.103.206-.134.056-.03.03.005-.051.077-.088.077-.18.134-.206.134zm.462-.047c-.025 0-.005-.03.052-.071a.406.406 0 01.149-.077c.025 0 .005.03-.052.071a.406.406 0 01-.149.077zm-.58-.133c-.072.026-.077.02-.03-.03.035-.037.076-.052.092-.037.02.02-.01.052-.062.067zm-2.357-.072c-.015 0 0-.036.036-.082.036-.046.298-.195.585-.334.283-.138.555-.251.596-.251.041 0-.108.082-.334.18a4.336 4.336 0 00-.631.333 1.408 1.408 0 01-.252.154zm2.526 0c-.015 0-.025-.01-.025-.026 0-.015.01-.025.025-.025.016 0 .026.01.026.025 0 .016-.015.026-.026.026zm-1.263-.103c-.056.031-.097.047-.097.031 0-.015.061-.061.133-.108.072-.046.118-.061.098-.03a.37.37 0 01-.134.107zm.237-.154c-.016 0-.026-.01-.026-.025 0-.016.01-.026.026-.026.015 0 .025.01.025.026 0 .015-.015.025-.025.025zm.282-.154c-.113.057-.205.093-.205.077 0-.015.092-.072.205-.128.113-.057.205-.092.205-.077a.82.82 0 01-.205.128zm-.18-.051c-.015 0-.025-.01-.025-.026 0-.015.01-.025.025-.025.016 0 .026.01.026.025 0 .016-.01.026-.026.026zm.103-.051c-.015 0-.026-.01-.026-.026 0-.015.01-.026.026-.026.015 0 .026.01.026.026 0 .015-.01.026-.026.026zm-.077-.103c-.036 0-.051-.015-.036-.036.02-.02.051-.02.067 0 .02.02.005.036-.031.036zm-.026-.205c-.015 0-.025-.01-.025-.026s.01-.026.025-.026c.016 0 .026.01.026.026 0 .015-.01.026-.026.026zm.103-.052c-.015 0-.026-.01-.026-.026 0-.015.01-.025.026-.025.015 0 .026.01.026.025 0 .016-.01.026-.026.026zm-.154-.051c-.016 0-.026-.01-.026-.026 0-.015.01-.026.026-.026.015 0 .026.01.026.026s-.01.026-.026.026zm.36-.031c-.119.026-.14.02-.078-.02.062-.047.046-.052-.077-.031l-.154.025.17-.077a.572.572 0 01.36-.04c.174.035.179.04.06.071-.071.02-.2.051-.282.072zm.046-.077c.056 0 .082-.01.066-.026-.015-.015-.061-.02-.097-.005-.041.016-.031.031.03.031zm-.663.056c-.015 0-.026-.01-.026-.025 0-.016.01-.026.026-.026s.026.01.026.026c0 .015-.01.025-.026.025zm-1.155-.056c-.052 0-.041-.015.025-.046.103-.046.103-.046 0-.052-.102-.005-.102-.005 0-.05a.546.546 0 01.18-.047c.046 0 .041.015-.025.046-.067.03-.078.046-.026.046.067.005.067.01 0 .057a.355.355 0 01-.154.046zm1.283.005c-.035 0-.05-.015-.035-.036.02-.02.05-.02.066 0 .02.02.005.036-.03.036zm.155-.056c-.047 0-.042-.016.025-.047a.546.546 0 01.18-.046c.046 0 .041.016-.026.046a.546.546 0 01-.18.047zm-1.828-.052c-.062 0-.072-.015-.031-.03.036-.016.082-.01.097.005.016.015-.015.03-.066.025zm3.789 3.723c.092-.082.277-.226.406-.318.133-.093.385-.237.56-.319.174-.082.42-.164.539-.185.154-.02.225-.061.24-.128.016-.051.006-.108-.015-.123-.025-.016-.05.015-.066.061-.016.052-.026-.128-.031-.395-.005-.267-.02-.467-.036-.452-.015.02-.036.175-.036.344-.005.17-.026.308-.046.308s-.036-.107-.031-.246a1.413 1.413 0 00-.03-.365c-.026-.082-.021-.113.02-.087.03.02.056.01.056-.015a.113.113 0 00-.046-.083c-.026-.015-.062.016-.082.072-.02.057-.057.103-.082.103-.026 0-.036-.062-.02-.144.015-.077.015-.113-.006-.077a.107.107 0 01-.092.062c-.036 0-.129.067-.206.149-.087.092-.128.174-.102.215.025.042.02.052-.026.026-.041-.026-.057-.005-.046.057.01.056-.01.087-.047.082-.035-.005-.143.108-.236.256-.092.15-.292.493-.436.76a6.42 6.42 0 00-.267.534c0 .021.072-.005.164-.092zm.786-.893c-.016 0-.026-.01-.026-.026s.01-.026.026-.026c.015 0 .025.01.025.026 0 .015-.015.026-.025.026zm-.257-.052c-.015 0-.026-.01-.026-.025 0-.016.01-.026.026-.026.015 0 .026.01.026.026 0 .015-.016.025-.026.025zm.519-.067c-.021.021-.036.006-.036-.035 0-.036.015-.052.036-.036a.05.05 0 010 .071zm-.211-.035c-.015 0-.026-.01-.026-.026s.01-.026.026-.026c.015 0 .026.01.026.026 0 .015-.01.026-.026.026zm-.205-.052c-.016 0-.026-.01-.026-.026 0-.015.01-.025.026-.025.015 0 .025.01.025.025 0 .016-.01.026-.025.026zm.924 0c-.016 0-.026-.01-.026-.026 0-.015.01-.025.026-.025.015 0 .026.01.026.025 0 .016-.01.026-.026.026zm-.642-.103c-.026.042-.051.052-.051.026s.02-.087.051-.128c.026-.041.051-.052.051-.026a.35.35 0 01-.051.128zm-.231 0c-.015 0-.026-.01-.026-.025 0-.016.01-.026.026-.026.015 0 .026.01.026.026 0 .015-.01.025-.026.025zm.416-.015c-.02.02-.036.005-.036-.036 0-.036.015-.051.036-.036a.05.05 0 010 .072zm.046-.139c-.015 0-.026-.01-.026-.025 0-.016.01-.026.026-.026s.026.01.026.026c0 .015-.016.025-.026.025zm.051-.205c-.015 0-.025-.01-.025-.026 0-.015.01-.025.025-.025.016 0 .026.01.026.025 0 .016-.015.026-.026.026zm.057-.118c-.02.02-.036.005-.036-.036 0-.036.015-.051.036-.036a.05.05 0 010 .072zm-.416 1.813c.015 0 .026-.01.026-.026s-.01-.026-.026-.026c-.015 0-.026.01-.026.026 0 .015.01.026.026.026zm.519-.016c.02-.02.02-.051 0-.067-.02-.02-.036-.005-.036.036.005.031.02.047.036.031zm1.694 0c.02-.02.02-.051 0-.067-.02-.02-.036-.005-.036.036.005.031.02.047.036.031zm-11.82-.036c.01 0 .056-.015.097-.03.047-.016.082-.057.082-.083 0-.03-.03-.025-.077.01-.04.036-.102.047-.138.026-.041-.026-.046-.015-.026.02.03.032.051.057.062.057zm2.11 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.025.026.025zm.668 0c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.025.026.025zm.539-.051a.388.388 0 00.128-.103c.016-.026-.015-.051-.072-.051-.056 0-.107.025-.107.056s-.021.041-.052.02c-.03-.02-.036 0-.02.047.02.062.051.067.123.03zm.436.051c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm2.645 0c.036 0 .051-.015.036-.036-.02-.02-.052-.02-.067 0-.026.02-.01.036.03.036zm3.106 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm.935-.195c.015-.149-.005-.241-.062-.298-.072-.072-.082-.061-.077.118 0 .144.016.175.052.118.036-.056.05-.035.061.103.005.164.005.164.026-.04zm.811.195c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.025.026.025zm1.017 0c.061 0 .195-.02.293-.051.097-.026.308-.139.462-.247.19-.133.277-.226.267-.287-.01-.072.01-.082.092-.057.067.02.16 0 .236-.046l.257-.164c.072-.046.128-.062.128-.041 0 .025-.123.113-.272.195-.149.082-.287.174-.303.205-.02.031-.025.072-.01.093.015.02.051.04.087.04s.129-.06.216-.133c.082-.072.149-.154.144-.18-.005-.025.02-.03.061-.015.052.02.093-.02.134-.118.03-.082.087-.18.123-.226a.662.662 0 00.103-.226c.03-.133.026-.144-.046-.082-.072.057-.077.057-.047-.03.031-.088.026-.093-.061-.021-.077.056-.087.061-.036 0 .036-.041.061-.088.061-.113 0-.02-.046-.062-.102-.093-.082-.04-.103-.04-.093.01.005.036-.02.067-.061.067a.854.854 0 00-.247.072c-.092.041-.246.057-.344.041-.097-.015-.19-.005-.21.026-.02.03-.15.108-.298.175-.144.066-.324.123-.39.123-.103 0-.113.01-.052.051.057.036.057.051.01.051a.4.4 0 01-.153-.046c-.057-.03-.108-.02-.15.02-.05.057-.04.078.047.103.103.031.103.042.02.088-.072.04-.077.061-.02.097a.48.48 0 00.215.047c.093 0 .134.02.108.061-.025.041.005.046.113.02.082-.02.247-.092.365-.164.118-.072.216-.154.216-.18 0-.03.035-.04.082-.025.046.02.066.01.046-.02-.02-.036.015-.042.097-.021.093.02.206-.005.37-.103.134-.072.252-.123.262-.113.01.01-.077.077-.2.15a1.545 1.545 0 01-.442.163c-.128.021-.241.072-.267.124-.026.046-.164.149-.303.226-.138.077-.292.138-.334.138a.157.157 0 01-.123-.072c-.02-.036-.108-.082-.195-.097-.133-.026-.139-.02-.067.036.047.036.072.082.052.108-.02.02 0 .025.051.01.046-.016.103-.01.118.015.016.026 0 .052-.036.052-.051 0-.051.01.005.046.057.036.052.051-.025.072-.067.015-.047.03.056.036l.154.01-.17.046c-.092.026-.153.072-.138.098.015.036.077.056.144.056zm.087-.056c-.072 0-.097-.01-.061-.026a.184.184 0 01.128 0c.03.01 0 .026-.067.026zm.206-.046c-.036 0-.052-.016-.036-.036.02-.021.051-.021.066 0 .02.02.005.036-.03.036zm.184-.088c-.036.016-.066-.005-.066-.046s.03-.072.066-.072c.036 0 .067.02.067.046.005.026-.026.057-.067.072zm-.215-.02c-.062 0-.072-.016-.031-.031.036-.016.082-.016.097.005.016.015-.015.03-.066.026zm-.052-.103c-.061 0-.072-.015-.03-.03.036-.016.082-.016.097.004.016.016-.015.031-.067.026zm.185-.046c-.036 0-.051-.016-.036-.036.02-.02.052-.02.067 0 .02.02.005.036-.03.036zm-.087-.324c-.077.01-.077.005.005-.02.082-.02.082-.036.026-.077-.057-.036-.057-.046-.005-.031.036.01.066.041.066.067 0 .03-.04.056-.092.061zm-.272-.046c-.098 0-.139-.01-.093-.026a.528.528 0 01.18 0c.051.016.01.026-.087.026zm.996.005c-.062 0-.072-.015-.03-.03.035-.016.081-.016.097.004.015.016-.016.031-.067.026zm-.899-.149a.46.46 0 01-.2-.051c-.056-.036-.026-.041.103-.015.097.02.19.04.2.05.01.011-.036.016-.103.016zm.083-.102c-.016 0-.026-.01-.026-.026s.01-.026.026-.026c.015 0 .025.01.025.026 0 .015-.015.026-.025.026zm.128-.052c-.036 0-.051-.015-.036-.036.02-.02.051-.02.067 0 .02.02.005.036-.031.036zm.719-.205c-.036 0-.052-.016-.036-.036.02-.02.051-.02.067 0 .02.02.005.036-.031.036zm.744-.257c-.015 0-.025-.01-.025-.026 0-.015.01-.025.025-.025.016 0 .026.01.026.025 0 .016-.015.026-.026.026zm-.77 1.49c.016 0 .026-.011.026-.026 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.025.026.025zm.38-.134c.093-.088.16-.185.149-.216-.01-.03-.087.041-.17.16l-.148.215zm-14.737.061c.113.005.206-.015.206-.046 0-.026-.031-.036-.072-.02-.041.015-.088-.01-.108-.057-.031-.082-.036-.082-.098 0-.036.051-.082.072-.097.057-.02-.021-.036-.01-.036.015 0 .026.097.051.205.051zm.93-.04c.03-.052.087-.078.138-.062.077.025.077.02.01-.026a.304.304 0 00-.138-.057c-.036 0-.062.052-.062.113 0 .103.005.108.052.031zm1.638.06c.035 0 .05-.015.035-.035-.02-.02-.05-.02-.066 0-.02.02-.005.036.03.036zm1.52 0c.01 0 .035-.02.05-.05.016-.031-.004-.052-.05-.052-.047 0-.067.02-.052.052.015.025.036.05.051.05zm-3.749-.086c.041-.016.072-.047.072-.072 0-.026-.03-.047-.072-.047-.041 0-.087.021-.103.047-.015.025-.015.056 0 .072.02.015.067.015.103 0zm2.721.036c.016 0 .026-.01.026-.026s-.01-.026-.026-.026c-.015 0-.025.01-.025.026 0 .015.01.026.025.026zm.196 0c.015 0 .04-.026.056-.052.015-.03.02-.051.005-.051s-.04.02-.056.051c-.016.026-.016.052-.005.052zm.575 0c.015 0 .025-.01.025-.026s-.01-.026-.025-.026c-.016 0-.026.01-.026.026 0 .015.01.026.026.026zm.975 0c.016 0 .026-.01.026-.026s-.01-.026-.026-.026c-.015 0-.025.01-.025.026 0 .015.01.026.025.026zm6.44-.103c.02-.072.04-.165.046-.21a.073.073 0 00-.072-.083c-.046 0-.067.03-.052.067.016.036.005.067-.025.067-.026 0-.052-.041-.052-.088 0-.077-.01-.077-.051-.015-.041.062-.051.062-.056-.026-.006-.102-.006-.102-.047 0-.04.098-.04.098-.077-.015-.02-.062-.056-.103-.082-.087-.026.015-.046.082-.046.143.005.108.005.108.046.01.041-.092.046-.092.046-.01 0 .052.036.129.082.17.062.061.078.061.083.01 0-.036.025-.02.046.036.026.056.046.072.046.041 0-.036.026-.062.057-.062.03 0 .05.042.056.093.01.056.026.041.051-.041zm.554-.046a.746.746 0 00-.005-.247c-.016-.041-.051-.072-.082-.072-.036 0-.041.031 0 .098.03.056.056.164.061.246.005.134.005.134.026-.025zm-12.416.071a.105.105 0 00.051-.082c0-.025-.02-.036-.051-.02-.026.015-.051.056-.051.082 0 .026.025.036.05.02zm3.41.026c.015 0 .04-.02.056-.051.015-.026.02-.052.005-.052s-.041.026-.056.052c-.016.025-.016.051-.006.051zm2.967-.02c.334-.02.427-.047.586-.17l.19-.149-.432-.03c-.267-.021-.503-.067-.61-.124-.16-.082-.17-.082-.108-.005.04.046.056.103.04.118-.02.02-.087.041-.148.046-.062.006-.129.016-.15.016-.02 0-.03.036-.02.082.005.041.031.092.057.113.025.02.025.01.005-.026s-.01-.061.02-.061c.031 0 .042-.026.021-.062-.02-.036-.015-.046.026-.02.03.02.046.056.03.087-.015.03 0 .051.036.051.052.005.052.01-.005.03-.061.027-.061.037 0 .078.036.03.247.041.462.026zm6.332.02c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.015.026.026.026zm.8 0c.031 0 .042-.02.026-.046-.015-.026-.015-.082 0-.128.016-.047.057-.067.083-.052.025.016.01-.036-.042-.118a1.567 1.567 0 00-.159-.216c-.051-.056-.067-.056-.072 0-.005.036-.025.01-.046-.061-.03-.093-.04-.103-.046-.036-.005.051.036.164.082.257a1.1 1.1 0 01.098.251.96.96 0 00.015.118c.005.02.03.031.062.031zm-.02-.308a.392.392 0 01-.092-.087c-.062-.082-.062-.082.02-.02.052.04.088.076.088.092 0 .005-.006.015-.016.015zm-13.073.257c.056 0 .092-.02.072-.052-.016-.025-.067-.05-.108-.05-.041 0-.072.025-.072.05 0 .026.051.052.108.052zm.272 0c.01 0 .092-.036.185-.082.123-.062.154-.098.108-.139-.047-.041-.077-.036-.118.026-.031.046-.088.072-.124.061-.036-.01-.061.016-.061.062s0 .072.01.072zm.498 0c.026 0 .046-.02.046-.052 0-.025-.036-.05-.082-.05-.046 0-.067.025-.046.05.02.026.056.052.082.052zm2.383 0c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026s.015.026.026.026zm1.278 0c.016 0 .041-.02.057-.052.015-.025.02-.05.005-.05-.016 0-.041.025-.057.05-.015.026-.02.052-.005.052zm.467 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026s.015.026.025.026zm1.849 0c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026s.016.026.026.026zm3.132 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026s.015.026.025.026zM2.66 15.096c.056 0 .082-.01.066-.025-.015-.016-.061-.02-.097-.005-.041.015-.031.03.03.03zm3.892-.03c.02-.01.04-.047.04-.078 0-.03-.025-.035-.05-.02-.031.015-.072-.02-.098-.087-.036-.093-.046-.098-.051-.026 0 .051.025.123.061.16.031.045.077.066.098.05zm.524.035c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026.005.015.015.025.026.025zm.544-.025c.056-.02.18-.098.267-.18.092-.082.149-.164.128-.18-.02-.02-.092-.015-.17 0-.102.026-.128.057-.107.134.015.056.005.103-.02.103-.026 0-.047-.026-.047-.052 0-.03-.03-.051-.072-.051a.154.154 0 00-.107.051c-.021.031-.021.087-.006.134.016.046.062.061.134.04zm6.234.025c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026.005.015.015.025.026.025zm1.232 0c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026.005.015.016.025.026.025zm.257 0c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026.005.015.015.025.026.025zm-12.324-.05c.046 0 .077-.027.067-.057-.01-.031-.041-.057-.067-.057-.026 0-.056.026-.067.057-.01.03.02.056.067.056zm2.218-.016c.02-.02.02-.052 0-.067-.02-.02-.036-.005-.036.036 0 .03.016.046.036.03zm.586.015c.025 0 .046-.01.046-.02s-.036-.047-.077-.083c-.067-.056-.072-.05-.046.021.02.041.056.082.077.082zm.431 0c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025.005.016.016.026.026.026zm3.78 0c.035 0 .05-.015.035-.036-.02-.02-.051-.02-.067 0-.025.02-.01.036.031.036zm2.798 0c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm.93-.015c.015-.016.02-.062.004-.098-.015-.04-.03-.03-.03.031-.006.056.005.087.025.067zm-11.097-.036c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026s.01.026.026.026zm.149 0c.046 0 .082-.02.082-.052 0-.025-.02-.05-.046-.05s-.062.025-.083.05c-.02.026 0 .052.047.052zm.77 0c.015 0 .046-.046.077-.103.046-.082.041-.097-.026-.072-.051.02-.077 0-.077-.056 0-.047-.025-.077-.061-.067a.144.144 0 00-.083.082c-.01.036.016.062.062.062s.082.036.082.077c.005.04.016.077.026.077zm.231 0c.026 0 .062-.02.082-.052.02-.03 0-.036-.046-.02-.041.015-.082.041-.082.051 0 .01.02.02.046.02zm.339 0c.041 0 .072-.01.072-.02 0-.011-.046-.032-.103-.047-.056-.015-.087-.005-.072.02.016.026.062.047.103.047zm2.927 0c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026s.01.026.026.026zm.277 0c.03 0 .057-.02.057-.052 0-.025-.01-.05-.021-.05-.01 0-.036.025-.057.05-.02.026-.01.052.021.052zm6.244 0c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026s.01.026.026.026zm3.851 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026s.01.026.026.026zm-14.26-.052c.021 0 .067-.025.098-.061.036-.036.062-.082.062-.103 0-.02-.026-.041-.057-.041-.03 0-.036.026-.015.062.02.036.015.046-.02.02a.125.125 0 00-.114-.005c-.03.015-.04.051-.02.082.015.026.046.046.067.046zm9.921-.441c.144-.252.39-.627.544-.837.155-.206.314-.39.355-.406.04-.015.072-.051.072-.072 0-.025-.031-.046-.072-.046-.041 0-.139.057-.221.123-.082.067-.282.355-.452.637-.2.329-.323.493-.35.457-.025-.036-.03-.015-.01.046a.6.6 0 01-.046.293 1.412 1.412 0 00-.077.226c-.005.026.113-.164.257-.421zm2.075.441c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.015.025.026.025zm.318-.066a.355.355 0 000-.18c-.015-.051-.026-.01-.026.092 0 .103.016.139.026.088zm-10.383.015c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.015.026.025.026zm1.772 0c.03 0 .051-.036.051-.082 0-.046-.02-.067-.051-.046a.098.098 0 00-.051.082c0 .026.025.046.05.046zm.277 0c.016 0 .041-.026.057-.051.015-.031.02-.052.005-.052-.016 0-.041.02-.057.052-.015.025-.015.051-.005.051zm-4.385-.051c.03 0 .057-.026.057-.052 0-.03-.01-.051-.021-.051-.01 0-.036.02-.057.051-.02.026-.01.052.021.052zm.205 0c.036 0 .052-.016.036-.036-.02-.02-.051-.02-.066 0-.02.02-.006.036.03.036zm.899 0c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026.005.015.016.026.026.026zm1.13 0c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026.005.015.015.026.026.026zm2.418 0c.036 0 .093-.036.129-.077.035-.041.056-.082.046-.082a.915.915 0 00-.16-.021c-.087-.01-.143.005-.143.046 0 .036.015.082.036.098.015.02.056.036.092.036zm7.548 0c.01 0 .005-.103-.01-.226-.026-.19-.01-.267.103-.462.077-.129.174-.257.226-.283.051-.025.092-.097.097-.154.005-.061-.015-.092-.046-.077-.036.02-.041-.005-.015-.082.025-.082.02-.103-.02-.077-.042.026-.052 0-.027-.087.021-.082.01-.124-.035-.129-.036 0-.103-.02-.155-.036-.066-.03-.097.016-.148.237a3.762 3.762 0 00-.072.641c0 .2-.016.355-.031.334a.158.158 0 00-.093-.046c-.035-.005-.061.01-.061.036 0 .026.04.072.092.103.052.03.072.051.052.051-.02 0 0 .062.046.128a.981.981 0 00.097.129zm.262-1.197c-.01.01-.036-.015-.051-.061a.606.606 0 01-.03-.144c0-.03.025-.005.05.062.031.066.042.133.031.143zm-.056 1.197c.01 0 .02-.01.02-.02 0-.011-.025-.042-.061-.062-.036-.021-.047-.016-.02.02.025.036.05.062.06.062zm-12.586-.052c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026.005.015.015.025.025.025zm2.167-.015c.02-.02.02-.051 0-.067-.02-.02-.036-.005-.036.036.005.031.02.046.036.031zm.15-.02c.04-.016.076-.042.076-.052 0-.01-.036-.02-.077-.02s-.077.02-.077.05c0 .032.03.042.077.021zm.261.02c.02-.02.02-.051 0-.067-.02-.02-.036-.005-.036.036.005.031.02.046.036.031zm1.381.015c.01 0 .005-.036-.01-.077-.015-.04-.041-.066-.056-.056-.016.015-.01.051.01.077.02.03.046.056.056.056zm.206 0c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.025.026.025zm2.644-.005c.195-.005.416-.051.524-.108a1.2 1.2 0 00.195-.107c0-.01-.144-.005-.318.005-.288.015-.36 0-.673-.165-.195-.097-.375-.17-.395-.154a.41.41 0 00-.098.129c-.046.082-.03.108.077.159.072.03.113.082.098.113-.016.03-.016.04.01.02.026-.02.087 0 .149.041.061.052.195.072.431.067zm-.488-.205a.503.503 0 01-.18-.082c-.076-.047-.092-.067-.03-.047.082.026.087.016.036-.04-.036-.047-.041-.088-.01-.103a.064.064 0 01.082.02c.015.026.05.041.071.031.021-.015.042.01.042.051 0 .041-.026.077-.057.077-.03 0-.02.021.02.052.042.02.052.04.026.04zm-.154-.2c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.026.025.026zm-5.617.359c.025 0 .04-.02.04-.046a.115.115 0 00-.04-.077c-.026-.016-.041.005-.041.046s.02.077.04.077zm4.072 0c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.015.026.026.026zm1.13 0c.015 0 .025-.01.025-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.015.026.025.026zm6.058 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.015.026.025.026zm.103 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .016.016.026.026.026zm.206 0c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.015.026.026.026zm-7.78-.077A.105.105 0 007 14.583c0-.031-.021-.036-.052-.02-.025.015-.051.056-.051.081 0 .026.026.036.051.021zm.858-.01c.03-.01.072-.067.087-.124.015-.056.01-.097-.01-.097s-.088.015-.15.03c-.06.016-.112.062-.112.098a.1.1 0 00.067.088c.03.015.087.015.118.005zm.282.036c.02 0 .036-.047.031-.103-.005-.057-.036-.103-.072-.103a.068.068 0 00-.067.067c0 .036.016.082.036.103.016.02.046.036.072.036zm7.055 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026-.005.01.01.026.025.026zm.257 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026-.005.01.01.026.026.026zm-12.426-.052c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026s-.026.01-.026.026c-.005.01.01.025.026.025zm.41 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026-.005.01.01.025.026.025zm1.402 0c.057 0 .052-.02-.02-.077a.387.387 0 00-.175-.077c-.056 0-.051.02.02.077a.387.387 0 00.175.077zm.237 0c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .01.015.025.026.025zm.113-.02c.02-.02.02-.052 0-.067-.02-.02-.036-.005-.036.036 0 .036.015.051.036.03zm1.581.02c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.016.025.026.025zm.54 0a.055.055 0 00.05-.051.051.051 0 00-.05-.051c-.031 0-.052.02-.052.051 0 .026.026.051.051.051zm7.214 0c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.015.025.026.025zm.205 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.016.025.026.025zm1.366 0c.03 0 .041-.072.03-.164-.01-.103-.05-.164-.107-.175-.046-.005-.087.006-.087.031 0 .026.025.057.051.077.03.02.041.052.02.082a.109.109 0 000 .098.14.14 0 00.093.051zm-.03-.256c-.016 0-.026-.01-.026-.026 0-.015.01-.026.025-.026.016 0 .026.01.026.026 0 .015-.01.026-.026.026zm-11.523.128c.025-.077.01-.118-.072-.164-.062-.031-.134-.047-.16-.026-.03.02-.015.041.037.051.046.01.102.067.123.129.03.108.036.108.072.01zm.518.02c.052-.025.093-.077.093-.112 0-.042-.016-.042-.041-.01-.02.03-.067.05-.103.056l-.128.015c-.047.005-.042.02.01.057a.18.18 0 00.17-.005zm2.465.057c.026 0 .062-.036.082-.082a.105.105 0 00-.04-.129.289.289 0 00-.109-.046c-.02 0-.036.026-.036.052 0 .03.026.036.062.015.041-.026.051 0 .03.072-.025.067-.015.118.011.118zm7.78-.02c.02-.021.02-.052 0-.067-.021-.02-.037-.005-.037.036.005.036.016.051.036.03zm-9.613-.031c.04 0 .082-.02.097-.047.016-.025-.025-.04-.092-.04-.067.004-.113.025-.098.046a.13.13 0 00.093.04zm.56 0c.035 0 .03-.02-.016-.047-.067-.04-.061-.05.01-.082.052-.02.072-.066.057-.108-.02-.056-.041-.046-.093.042-.035.066-.05.133-.04.159.01.015.046.036.082.036zm.929 0c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.016.026.026.026zm2.901-.031c.241-.02.467-.052.508-.072.042-.02-.061-.051-.236-.072a1.896 1.896 0 01-.441-.092c-.072-.031-.118-.083-.103-.103.015-.026-.005-.03-.051-.015a.193.193 0 00-.103.107c-.02.057-.005.067.072.047.056-.016.103-.021.103 0 0 .015-.072.056-.16.087-.118.04-.143.067-.092.103.036.02.267.03.503.01zm-.36-.031c-.071 0-.097-.01-.06-.026a.184.184 0 01.127 0c.036.016.006.026-.066.026zm5.418.062c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.016.026.026.026zm1.078 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.015.026.025.026zm-9.807-.052c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.015.025.026.025zm.616 0c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.016.025.026.025zm-2.285-.102a.384.384 0 00.051-.165c0-.046-.046-.113-.102-.144-.093-.05-.103-.04-.098.113.005.16.005.16.046.042.036-.119.041-.113.046.05.01.134.021.16.057.104zm.103.05c.03 0 .051-.05.051-.112 0-.092-.01-.103-.051-.036a.315.315 0 00-.052.118c.005.016.026.03.052.03zm1.13 0c.02 0 .081-.045.133-.102.051-.056.082-.113.072-.123-.01-.01-.072.036-.134.103-.061.066-.097.123-.072.123zm1.848-.025c.03-.015.051-.061.051-.097 0-.036-.056-.067-.128-.067-.072 0-.129.02-.129.046s.021.036.047.02c.025-.015.061.011.077.052.02.041.056.062.082.046zm-2.824-.025c.03 0 .051-.01.051-.021 0-.01-.02-.036-.051-.056-.031-.016-.052-.006-.052.02 0 .026.026.057.052.057zm.77 0c.036 0 .051-.016.036-.036-.02-.02-.052-.02-.067 0-.02.02-.005.036.03.036zm.75 0c.01 0 .02-.01.02-.021 0-.01-.026-.041-.062-.062-.035-.02-.046-.015-.02.021.02.036.051.062.062.062zm.724-.021c.02-.02.02-.051 0-.067-.021-.02-.036-.005-.036.036 0 .036.015.052.036.031zm.821 0c.046-.005.103-.056.134-.113.046-.097.046-.097-.031 0-.046.057-.082.072-.082.036s-.02-.051-.052-.03a.097.097 0 00-.051.076c0 .026.036.036.082.031zm3.096.01l.334-.005-.257-.072a5.236 5.236 0 01-.395-.128c-.077-.03-.128-.072-.113-.092.016-.021-.02-.031-.077-.016-.056.016-.103.041-.103.062 0 .02.016.056.041.087.021.03.083.082.14.113.056.03.25.056.43.051zm4.134.01c.015 0 .026-.01.026-.025 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026.005.015.016.026.026.026zm-6.83-.05c.016 0 .026-.011.026-.026 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026.005.015.015.025.026.025zm1.978 0c.036 0 .05-.016.036-.037-.021-.02-.052-.02-.067 0-.02.02-.005.036.03.036zm4.4-.18a6.69 6.69 0 01.144-.822c.03-.092.02-.087-.072.02-.092.103-.108.18-.098.565.006.242.016.35.026.237zm-10.685.128c.01 0 .02-.02.02-.051 0-.031-.026-.052-.056-.052-.031 0-.041.02-.02.052.02.025.045.05.056.05zm.102 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm.252 0c.01 0 .02-.067.02-.149 0-.092-.036-.16-.087-.175a3.639 3.639 0 01-.174-.061c-.072-.031-.088-.01-.078.097.006.072.031.134.057.134.026 0 .03-.036.015-.082-.025-.067-.015-.072.036-.026.041.03.088.041.103.026.02-.02.036-.01.036.02 0 .031-.015.067-.036.077-.02.01-.01.016.026.005.036-.01.066.02.066.062 0 .041.006.072.016.072zm1.032 0c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .016.01.026.026.026zm.365-.016c.02-.02.02-.05 0-.066-.021-.02-.036-.005-.036.036.005.03.02.046.036.03zm1.581.016c.01 0 .036-.02.057-.051.015-.031.005-.052-.021-.052-.026 0-.056.02-.056.052 0 .03.01.05.02.05zm.822 0c.01 0 .036-.02.056-.051.016-.031.005-.052-.02-.052-.026 0-.057.02-.057.052 0 .03.01.05.02.05zm.878 0c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025-.005.016.01.026.026.026zm-5.181-.067c.02-.02.02-.051 0-.067-.02-.02-.036-.005-.036.036 0 .031.015.047.036.031zm2.48.016c.025 0 .051-.021.051-.052a.051.051 0 00-.051-.051c-.031 0-.052.02-.052.051 0 .031.026.052.052.052zm2.08-.036c.04-.016.076-.036.076-.047 0-.01-.036-.025-.077-.046-.046-.015-.077 0-.077.046 0 .047.031.067.077.047zm7.984.036c.036 0 .051-.016.036-.036-.02-.02-.051-.02-.067 0-.02.02-.005.036.031.036zm-11.245-.052c.036 0 .051-.015.036-.036-.02-.02-.052-.02-.067 0-.02.02-.005.036.03.036zm1.304 0c.015 0 .041-.02.056-.051.016-.031.021-.052.006-.052-.016 0-.041.021-.057.052-.015.026-.02.051-.005.051zm1.422-.03a.104.104 0 00.047-.078c0-.025-.036-.03-.077-.015-.042.015-.062.051-.047.077.016.026.052.036.077.015zm1.202-.021c.051-.041.072-.041.087.01.016.041.041.026.082-.046.031-.062.047-.149.026-.195a.101.101 0 00-.113-.067c-.046.01-.108.072-.144.139-.036.066-.051.143-.036.17.02.025.062.02.098-.011zm-.051 0c-.016 0-.026-.01-.026-.026 0-.015.01-.026.026-.026.015 0 .025.01.025.026 0 .01-.01.026-.025.026zm.821.051c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .01.01.025.026.025zm.17-.025c.046-.026.05-.057.015-.103-.03-.036-.036-.082-.015-.103.02-.02-.006-.02-.062 0-.087.036-.087.041-.01.098.046.036.066.082.046.102-.026.026-.01.031.026.005zm2.967.025c.01 0 .021-.01.021-.02s-.026-.041-.062-.062c-.036-.02-.046-.015-.02.02.02.037.046.062.061.062zm2.717 0c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .01.01.025.026.025zm1.058-.061a.984.984 0 00.287-.196c.123-.133.144-.138.247-.071a.37.37 0 00.272.04.627.627 0 00.262-.128c.056-.051.138-.097.184-.097.047 0 .093-.031.108-.072.016-.041.129-.139.252-.216.123-.077.216-.154.195-.174a.1.1 0 00-.062-.031.284.284 0 01-.097-.041c-.041-.026-.082 0-.113.077-.026.066-.051.097-.051.072 0-.026-.052 0-.108.061-.057.062-.103.15-.103.195 0 .082-.005.082-.092 0-.052-.046-.113-.087-.134-.087-.02 0-.026.02-.01.041.015.026-.087.103-.226.175l-.257.133v-.123c0-.067.031-.123.062-.128.036 0 .01-.026-.052-.052-.077-.03-.113-.087-.113-.18 0-.071-.035-.143-.077-.159-.04-.015-.066-.046-.05-.072.014-.02-.027-.025-.088-.01-.082.02-.093.036-.041.057a.489.489 0 01.143.092c.057.057.057.067-.01.067-.046 0-.082-.02-.082-.051 0-.031-.03-.052-.072-.052-.04 0-.082-.046-.097-.103-.02-.071 0-.102.061-.102.052 0 .154-.057.226-.129a.717.717 0 00.134-.149c0-.01-.057-.035-.129-.056a.287.287 0 01-.18-.134c-.03-.056-.076-.092-.102-.071-.026.015-.051.051-.051.082 0 .03.02.036.046.02.025-.015.036.02.015.082-.02.072.005.134.067.18.051.036.072.072.046.072-.026 0-.077-.026-.113-.062a.259.259 0 01-.061-.164c0-.092-.01-.092-.144.036a.592.592 0 01-.185.139c-.02 0 .026-.062.103-.139.092-.087.123-.144.082-.16-.036-.01-.062-.045-.062-.071 0-.036.026-.036.067.005.036.03.082.041.103.026a.12.12 0 00.036-.077c0-.026-.042-.041-.098-.041a.236.236 0 00-.16.077c-.035.04-.045.097-.025.128.02.036-.01.046-.097.02-.072-.02-.134-.01-.134.016 0 .026.03.077.062.118.051.057.051.062-.01.041l-.18-.067c-.098-.035-.098-.035-.016.047.046.046.108.087.134.087.025 0 .067.041.087.087.02.052.041.113.046.134 0 .025.052.061.108.087.067.026.077.041.026.041a.355.355 0 01-.154-.046.182.182 0 01-.077-.139c0-.072-.041-.092-.206-.092-.159 0-.241-.036-.364-.154-.118-.113-.262-.18-.55-.247-.215-.051-.446-.138-.518-.195-.072-.056-.272-.123-.452-.154a2.455 2.455 0 01-.678-.241 3.25 3.25 0 01-.616-.442c-.16-.154-.318-.257-.406-.262-.118-.01-.144.005-.144.113 0 .088.021.118.072.103.047-.015.082.015.103.098.02.087.067.123.149.123.087 0 .118.025.113.113-.005.087.03.118.149.144.082.015.149.046.144.066-.006.02-.016.062-.016.088 0 .025.046.061.103.082.056.02.139.005.18-.031.061-.051.077-.041.077.072 0 .077.03.133.066.133.036 0 .098-.03.134-.061.051-.052.056-.046.03.02-.015.046-.004.103.026.118.031.02.113-.005.185-.051.123-.082.129-.077.113.01-.015.082.016.093.252.077.22-.015.282 0 .36.093.05.056.122.108.164.108.04 0 .061.015.04.03-.02.016-.071.016-.123-.005a1.17 1.17 0 00-.23-.056c-.078-.01-.144 0-.144.02s.035.088.077.139c.077.098.077.098.154 0 .066-.087.077-.087.107-.01.021.046.062.087.098.087.036 0 .082-.03.098-.062.015-.036.015 0 0 .077-.021.093-.01.144.03.144.036 0 .072-.046.088-.097.015-.057.061-.113.102-.129.057-.02.067-.005.041.072-.025.082-.01.103.077.103.062 0 .098.02.083.046-.016.026.005.072.046.108.04.036.103.046.133.026.041-.026.041-.006-.005.077-.046.087-.046.107 0 .077.041-.026.057-.006.046.056-.01.051.01.144.047.205.03.062.056.119.051.129-.005.01.01.005.03-.016.026-.02.021-.113-.01-.205a1.487 1.487 0 01-.05-.385c0-.18.015-.205.071-.144a.24.24 0 01.072.144c0 .041.03.103.072.133.046.036.082.041.103.01.015-.025.01-.066-.021-.081-.03-.016-.051-.072-.046-.119.005-.071.01-.077.04-.01.021.041.073.129.114.19.04.062.159.144.257.185.138.056.159.082.092.113-.051.02-.133-.01-.226-.098-.077-.071-.16-.133-.185-.133-.025 0-.046.02-.046.051 0 .031-.03.052-.067.052-.04 0-.072.066-.077.184a.77.77 0 01-.04.247c-.021.036-.016.046.004.02.026-.02.088 0 .139.047.051.046.092.061.092.036a.43.43 0 00-.082-.165c-.046-.061-.067-.149-.051-.19.015-.04.051-.077.082-.077.03 0 .051.031.051.062 0 .036.02.097.047.139.04.061.066.061.164-.026.092-.077.103-.082.046-.01-.062.082-.051.092.18.097.138.005.308.005.38 0 .123-.005.123-.005.025.052-.056.03-.236.061-.395.061-.164 0-.298.02-.298.041 0 .02.103.036.226.036.15 0 .247.031.298.087.062.077.056.083-.056.052-.119-.031-.124-.026-.036.036.071.051.133.056.246.015zm.046-.093c-.036 0-.052-.015-.036-.036.02-.02.051-.02.067 0 .015.02.005.036-.031.036zm-.026-.103c-.015 0-.026-.01-.026-.025 0-.016.01-.026.026-.026s.026.01.026.026c0 .015-.01.025-.026.025zm.462-.256c-.015 0-.025-.01-.025-.026 0-.015.01-.026.025-.026.016 0 .026.01.026.026 0 .015-.01.026-.026.026zm-1.694-.206c-.016 0-.026-.01-.026-.025 0-.016.01-.026.026-.026.015 0 .025.01.025.026 0 .015-.01.025-.025.025zm1.422 0c-.026 0-.062-.046-.072-.102-.015-.057-.02-.103-.01-.103s.046.046.072.103c.03.056.03.102.01.102zm-.293-.102c-.015 0-.025-.01-.025-.026 0-.015.01-.026.025-.026.016 0 .026.01.026.026 0 .015-.01.026-.026.026zm-.364-.103a.36.36 0 01-.149-.067c-.051-.04-.077-.097-.057-.128.021-.031.057-.046.088-.031a.058.058 0 01.02.077c-.015.026.016.067.062.098.051.025.067.046.036.05zm-.149-.154c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .016.01.026.026.026zm.565.154c-.016 0-.026-.01-.026-.026 0-.015.01-.025.026-.025.015 0 .025.01.025.025 0 .016-.01.026-.025.026zm1.643 0c-.015 0-.026-.01-.026-.026 0-.015.01-.025.026-.025.015 0 .026.01.026.025 0 .016-.01.026-.026.026zm-2.876-.205c-.01 0-.04-.026-.061-.062-.02-.036-.016-.046.02-.02.031.02.062.046.062.061s-.005.02-.02.02zm.514 0c-.015 0-.026-.01-.026-.026s.01-.026.026-.026c.015 0 .026.01.026.026 0 .015-.01.026-.026.026zm.616 0c-.01 0-.036-.026-.056-.057-.02-.03-.02-.067-.01-.077.015-.015.035.01.056.057.015.04.02.077.01.077zm-1.284-.155c-.04 0-.077-.01-.077-.02s.036-.036.077-.051c.041-.016.077-.006.077.02 0 .03-.036.051-.077.051zm1.33 0c-.015 0-.01-.025.005-.05.016-.032.041-.052.057-.052.015 0 .01.02-.005.051-.02.026-.046.051-.057.051zm-2.408-.564c-.015 0-.026-.01-.026-.026 0-.015.01-.026.026-.026.015 0 .026.01.026.026 0 .015-.01.026-.026.026zm8.714 1.663c.02-.102.03-.2.015-.21-.015-.016-.097 0-.185.03-.133.047-.184.042-.282-.03a.689.689 0 01-.175-.216c-.036-.082-.04-.241-.01-.452.031-.215.026-.308-.01-.272-.03.03-.062.21-.072.41-.015.34-.01.37.144.545.108.123.19.175.251.154.057-.015.124.02.185.103l.098.128zm-19.24.134c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026s.01.026.026.026zm2.305 0c.016 0 .041-.026.057-.052.015-.03.02-.05.005-.05-.016 0-.041.02-.057.05-.02.026-.02.052-.005.052zm.673 0c.01 0 .02-.01.02-.02 0-.011-.025-.042-.061-.062-.036-.02-.046-.016-.02.02.025.036.05.062.06.062zm.462 0c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026s.01.026.026.026zm.354 0c.01 0 .016-.036.016-.077s-.02-.062-.041-.046c-.026.015-.031.046-.016.077.01.025.031.046.041.046zm.699-.103c.097-.113.102-.128.025-.144a.208.208 0 00-.159.047c-.04.036-.077.087-.077.113 0 .03.036.02.077-.016.067-.056.072-.051.046.031-.02.077 0 .067.088-.03zm-4.842.051c.005 0 .01-.01.01-.02a.382.382 0 00-.082-.103c-.047-.046-.108-.082-.144-.077-.031 0-.005.046.067.103l.149.097zm.56 0c.004 0 .004-.056.004-.123 0-.092-.046-.144-.185-.2l-.754-.308c-.314-.128-.663-.283-.77-.35a3.915 3.915 0 01-.483-.348 4.797 4.797 0 01-.4-.36.813.813 0 01-.16-.23c-.02-.063-.056-.165-.077-.237l-.036-.129.077.134a.55.55 0 00.21.195c.073.036.124.082.103.108-.015.026.016.072.072.103.072.036.103.036.103 0 0-.031-.041-.057-.092-.057-.052 0-.067-.015-.042-.025.026-.01.21.056.411.154.195.097.37.164.375.159.005-.005.005-.041-.015-.072-.02-.031-.2-.134-.406-.226a2.52 2.52 0 01-.585-.39c-.118-.118-.216-.247-.216-.288 0-.036-.041-.149-.087-.252-.047-.097-.108-.18-.129-.18-.02 0-.04.021-.04.042 0 .026.045.22.102.441.056.221.092.416.077.442-.015.02.015.082.062.128.046.047.092.129.092.175a.598.598 0 00.092.21c.047.067.088.103.088.078 0-.026.082.03.18.123.097.092.164.195.143.22-.015.031-.01.037.02.021.026-.015.103.005.165.046.062.041.098.103.077.134-.02.036-.01.04.026.015.036-.02.102-.005.149.036.046.041.185.123.308.185s.246.092.277.077c.036-.02.041-.01.026.02-.02.031.015.072.072.088.061.02.123.02.138.005.016-.015.067 0 .113.041a.656.656 0 00.195.108c.072.02.113.015.113-.02 0-.031-.036-.057-.082-.057-.046 0-.067-.026-.041-.057.026-.036.098.01.216.139.149.164.174.18.149.082-.02-.097-.016-.108.046-.056.04.03.072.092.072.133 0 .041.025.072.056.072s.041-.046.02-.113c-.025-.097-.02-.092.062.026.057.072.103.138.108.138zm-.817-.43c-.02.02-.036.004-.036-.037 0-.036.015-.051.036-.036.02.026.02.057 0 .072zm-.267-.083c-.016 0-.026-.01-.026-.026 0-.015.01-.025.026-.025.015 0 .025.01.025.025 0 .016-.01.026-.025.026zm-.308-.154c-.016 0-.026-.01-.026-.026 0-.015.01-.025.026-.025.015 0 .025.01.025.025 0 .016-.01.026-.025.026zm-.154-.051c-.016 0-.026-.01-.026-.026 0-.015.01-.026.026-.026.015 0 .025.01.025.026 0 .015-.01.026-.025.026zm-.411-.257c-.016 0-.026-.01-.026-.026 0-.015.01-.025.026-.025.015 0 .026.01.026.025 0 .016-.01.026-.026.026zm-.616-.514c-.016 0-.026-.01-.026-.025 0-.016.01-.026.026-.026.015 0 .025.01.025.026 0 .015-.01.025-.025.025zm-.088-.128c-.015.015-.046-.01-.061-.062-.026-.071-.02-.077.03-.03.031.036.047.077.031.092zm7.22 1.587a.875.875 0 00.22-.124c.114-.087.114-.087.006-.118-.072-.02-.093-.051-.067-.097.03-.057.026-.057-.03 0-.062.056-.062.072.004.113.041.025.062.061.041.077-.02.015-.082.005-.138-.026-.087-.046-.113-.036-.154.041-.031.052-.036.113-.02.129.02.02.081.02.138.005zm1.289.03c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.025.026.025zm4.734-.04a.261.261 0 000-.155c-.015-.051-.026-.02-.026.062 0 .087.01.128.026.092zm6.234.04c.036 0 .149-.092.256-.205.124-.133.221-.195.273-.174.061.025.082-.006.082-.134 0-.087.025-.21.056-.267.031-.056.046-.113.036-.123-.01-.01-.118.061-.236.164-.118.103-.2.205-.185.231.016.026-.051.154-.159.277-.103.129-.16.231-.123.231zm-14.511-.05c.015 0 .025-.011.025-.027 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm9.756 0c.015 0 .026-.011.026-.027 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .016.01.026.026.026zm.334 0c.036 0 .051-.016.036-.037-.02-.02-.052-.02-.067 0-.02.02-.005.036.03.036zm-9.012-.052c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026s.01.026.026.026zm2.824 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026s.01.026.025.026zM3.183 13.9c.02-.02.02-.051 0-.067-.02-.02-.036-.005-.036.036 0 .036.016.051.036.03zm4.427.02c.025 0 .061-.035.077-.082.025-.072.02-.072-.047-.02-.04.036-.077.072-.077.082 0 .01.021.02.047.02zm.313 0c.03 0 .056-.025.056-.05 0-.032-.01-.052-.02-.052s-.036.02-.057.051c-.02.026-.01.051.02.051zm10.475-.025c.026-.016.051-.057.051-.082 0-.026-.025-.036-.051-.02a.105.105 0 00-.051.081c0 .026.025.036.05.02zm-11.836-.026c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .016.01.026.026.026zm2.876 0c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm-6.419-.051c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.026.026.026zm5.15-.016c.052-.005.098-.036.098-.066 0-.031-.062-.062-.134-.062-.072 0-.102.01-.066.026.036.01.051.04.036.066-.016.026.015.041.066.036zm.283.016c.04 0 .108-.041.154-.093.067-.072.072-.108.025-.154-.035-.03-.087-.061-.123-.061-.03 0-.087.036-.123.077-.036.04-.051.113-.03.154.015.04.06.077.097.077zm5.248 0c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.026.026.026zm2.798-.01c.098 0 .139-.01.087-.026a.528.528 0 00-.18 0c-.046.015-.005.025.093.025zm-7.471-.042c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026s-.026.01-.026.026c0 .015.01.025.026.025zm6.444 0c.03 0 .057-.02.057-.051 0-.03-.01-.051-.021-.051-.01 0-.036.02-.056.051-.021.026-.01.051.02.051zm-12.806-.05c.01 0 .02-.011.02-.021 0-.01-.025-.042-.061-.062-.036-.02-.046-.016-.02.02.02.036.045.062.06.062zm.097 0c.016 0 .026-.011.026-.027 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm6.46-.078c.077-.051.123-.113.103-.133-.026-.026-.113-.021-.195.005-.134.04-.14.046-.031.051.108.005.113.015.051.092-.062.067-.051.067.072-.015zm.036-.077c-.036 0-.051-.015-.036-.036.02-.02.051-.02.067 0 .025.02.01.036-.031.036zm.293.139c.02-.02.02-.052 0-.067-.02-.02-.036-.005-.036.036 0 .03.015.046.036.03zm8.826.015c.01 0 .02-.02.02-.051 0-.031-.025-.052-.056-.052-.03 0-.04.02-.02.052.02.025.041.051.056.051zm4.54 0c.03 0 .056-.02.056-.051 0-.031-.01-.052-.02-.052s-.036.02-.057.052c-.02.025-.01.051.02.051zM7.64 13.664c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.015.026.025.026zm.216-.057c.02-.04.041-.036.077.01.041.057.046.057.03 0-.01-.035-.04-.066-.066-.066-.025 0-.051.025-.061.056 0 .041.005.036.02 0zm2.039.057c.015 0 .313-.19.662-.421.35-.231.847-.534 1.12-.668.266-.133.518-.246.554-.246.036 0 .067-.026.067-.052 0-.03-.036-.066-.082-.082a.325.325 0 00-.211.031c-.072.03-.472.277-.883.544-.41.267-.863.575-1.001.693-.14.119-.242.2-.226.2zm4.729 0c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.016.026.026.026zm2.901 0c.036 0 .051-.016.036-.036-.02-.02-.051-.02-.067 0-.02.02-.005.036.031.036zm5.284-.052a.227.227 0 00-.01-.128c-.016-.041-.052-.077-.083-.077-.03 0-.051.03-.051.067 0 .036.03.097.062.128.04.046.066.046.082.01zm-16.196-.051c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.015.026.025.026zm1.644 0c.046 0 .082-.01.082-.02s-.02-.036-.046-.052c-.026-.015-.062-.005-.083.02-.02.026 0 .052.047.052zm.539 0c.061 0 .097-.02.082-.046s-.005-.062.026-.082c.036-.026.036-.052 0-.098-.031-.036-.036-.082-.016-.103.02-.02-.01-.02-.061 0-.057.02-.072.047-.036.057.036.01.061.04.061.067 0 .025-.03.04-.061.03-.036-.01-.047-.005-.026.006.02.01.015.056-.02.092-.052.062-.042.077.05.077zm.724 0c.025 0 .046-.01.046-.02s-.036-.036-.082-.052c-.046-.015-.067-.01-.046.02.02.031.056.052.082.052zm8.21-.01c.072 0 .098-.01.062-.026a.184.184 0 00-.128 0c-.031.015 0 .026.066.026zm5.16.01c.016 0 .027-.01.027-.026 0-.015-.01-.025-.026-.025s-.026.01-.026.025c.005.016.016.026.026.026zm-14.387-.103c.041 0 .087-.015.103-.03.015-.016-.026-.067-.098-.103a.806.806 0 00-.164-.067c-.02 0 .01.026.056.057.052.03.077.077.062.102-.015.02.005.041.041.041zm9.16-.01c.14-.015.314-.067.39-.118.114-.072.13-.108.083-.164-.046-.057-.041-.067.026-.041.046.02.118.005.164-.031.062-.052.067-.072.01-.108-.056-.036-.056-.041 0-.041.036 0 .124-.062.195-.139.072-.077.129-.164.129-.205 0-.057-.031-.057-.144-.01-.077.03-.19.082-.252.107-.061.031-.143.041-.18.026-.046-.015-.066.02-.066.123 0 .123.02.15.128.154.103.005.108.01.026.031a.803.803 0 00-.216.082c-.061.031-.113.077-.113.108 0 .026.062.036.144.016.103-.026.123-.021.067.02-.041.03-.16.051-.257.051a.609.609 0 01-.251-.046c-.042-.025-.057-.067-.047-.087.016-.026-.01-.077-.056-.118-.072-.067-.077-.067-.052.01.016.046.006.092-.02.103-.036.01-.026.046.02.092.042.041.067.108.052.144-.026.051.026.062.22.041zm-9.714-.041c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025.005.016.015.026.026.026zm14.223 0c.015 0 .062-.123.103-.277.046-.154.128-.34.19-.416.061-.077.123-.113.138-.088.02.031.067.026.129-.02.082-.057.087-.082.03-.149a.236.236 0 00-.174-.072c-.103.005-.103.01.005.03.062.011.118.047.118.073 0 .026-.061.036-.133.015-.098-.025-.124-.015-.098.026.02.036 0 .062-.062.062a.256.256 0 00-.159.061.256.256 0 00-.061.16.518.518 0 01-.098.225c-.056.072-.087.165-.067.21.026.073.036.073.072-.015.031-.082.041-.077.041.041 0 .072.016.134.026.134zm-1.232-.051c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026.005.015.015.026.026.026zm1.006 0c.03 0 .051-.02.051-.052 0-.03-.02-.051-.05-.051-.032 0-.052.02-.052.051 0 .031.02.052.051.052zm.668 0c.056 0 .102-.02.102-.041a.129.129 0 00-.03-.072c-.016-.016-.062-.02-.103-.005-.041.015-.072.046-.072.071 0 .026.046.047.103.047zm-13.947-.052c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026.005.015.015.025.025.025zm.463 0c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026.005.015.015.025.026.025zm.852-.036c.041-.02.154-.092.252-.159.097-.067.21-.108.246-.092.041.015.175-.041.298-.129.123-.087.22-.185.215-.215-.005-.036.026-.057.078-.057.05.005.077-.01.061-.03-.015-.021.077-.103.206-.175.128-.072.23-.15.23-.16 0-.015-.05 0-.112.037-.062.036-.36.205-.658.385-.297.18-.621.395-.719.482-.097.083-.143.139-.097.113zm.59-.318c-.056.026-.03-.01.052-.082.082-.072.174-.129.205-.129s.005.036-.051.083a1.125 1.125 0 01-.206.128zm.36-.21c-.016 0-.026-.01-.026-.026s.01-.026.026-.026c.015 0 .026.01.026.026 0 .015-.016.025-.026.025zm2.352.564c.015 0 .04-.02.056-.051.015-.03.02-.051.005-.051s-.04.02-.056.05c-.016.027-.016.052-.005.052zm7.25 0c.01 0 .02-.01.02-.02s-.025-.041-.061-.062c-.036-.02-.046-.015-.02.02.025.037.05.062.061.062zm-7.312-.082c.03-.015.026-.056-.01-.097-.031-.042-.041-.098-.02-.14.025-.045.02-.05-.021-.014-.031.03-.041.102-.026.164.015.067.051.103.077.087zm1.458.03c.016 0 .026-.01.026-.025 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm6.45-.004c.046.005.138-.036.205-.093.067-.056.103-.102.077-.102-.026 0-.015-.036.015-.077.047-.052-.015-.047-.225.03l-.288.103-.18-.103c-.097-.056-.18-.087-.18-.066 0 .02.052.087.119.149a.52.52 0 00.246.128c.072.01.164.026.21.03zm-3.538-.098c.072-.056.077-.082.025-.113a.234.234 0 00-.113-.04c-.025 0-.02.03.01.066.032.036.042.087.021.113-.015.026.005.015.057-.026zm.113.052c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.015.026.026.026zm-9.243-.052c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.016.025.026.025zm6.039 0c.056 0 .097-.036.097-.077 0-.04-.02-.077-.046-.077a.562.562 0 00-.128.031c-.047.015-.067.051-.052.077.016.026.072.046.129.046zm.318-.01c.077-.005.144-.036.144-.062 0-.025-.016-.056-.041-.066-.026-.01-.093.02-.144.061-.098.077-.098.077.04.067zm.339.01c.056 0 .118-.025.138-.056.021-.031.006-.077-.035-.103a.2.2 0 00-.124-.03c-.03.01-.056.056-.066.102-.01.056.02.087.087.087zm3.62 0a.327.327 0 00.164-.082c.072-.056.082-.087.036-.108-.036-.015-.046-.051-.03-.087.02-.03-.006-.026-.052.01a.392.392 0 00-.087.093c0 .01.025.005.061-.016.041-.025.047-.015.016.031-.031.051-.057.046-.108-.02-.062-.083-.072-.083-.128.03-.062.113-.057.113.03.041.088-.071.093-.066.062.016-.015.056-.005.092.036.092zm2.988-.154c.047-.097.103-.23.129-.298.025-.066.066-.102.097-.087.026.016.052.005.052-.02 0-.031.046-.057.107-.057.057 0 .093-.026.072-.051-.015-.031-.082-.052-.149-.052-.061 0-.169.057-.236.124-.077.082-.123.205-.138.37l-.02.246zM1.16 13.1c.005 0 .01-.123.005-.267a1.05 1.05 0 00-.087-.421c-.046-.082-.082-.134-.087-.103 0 .03-.026.016-.052-.026-.046-.066-.05-.066-.046 0 0 .042.02.124.046.18.042.098.047.098.047.005 0-.056.015-.082.036-.066.015.015.04.164.051.323.01.16.03.313.051.339.016.015.031.036.036.036zm-.03-.324c-.021.02-.036.005-.036-.036 0-.035.015-.05.035-.035a.05.05 0 010 .071zm7.537.324c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm5.52 0c.057 0 .108-.02.108-.046s-.03-.072-.072-.108c-.04-.036-.061-.093-.046-.129.015-.035.005-.082-.026-.097-.03-.015-.066-.01-.082.02a.123.123 0 00.01.119c.021.035.036.102.026.154-.02.056.01.087.082.087zm7.78 0c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.015.026.026.026zM8.38 12.99c.01-.03.005-.067-.01-.082-.016-.016-.057-.01-.088.01-.046.026-.04.046.01.082.042.026.078.02.088-.01zm5.011.057c.016 0 .026-.01.026-.026s-.01-.026-.026-.026c-.015 0-.025.01-.025.026 0 .015.015.026.025.026zm.514 0c.041 0 .077-.026.077-.052 0-.03-.036-.051-.077-.051s-.077.02-.077.051c0 .026.036.052.077.052zm9.838-.083c.052-.051.098-.107.098-.133 0-.026-.057-.005-.129.04-.071.047-.113.109-.097.134.02.026.077.01.128-.04zm-10.085.031c.036 0 .067-.036.067-.077 0-.04-.03-.077-.072-.077-.04 0-.087.02-.102.046a.07.07 0 00.005.077c.015.02.066.031.102.031zm.755-.015c.031-.01.067-.057.077-.108.01-.051-.015-.087-.061-.087-.041 0-.093.02-.108.051a.12.12 0 000 .103c.015.036.056.051.092.04zm.344.015c.057 0 .098-.02.098-.046s-.03-.057-.062-.072a.271.271 0 00-.128 0c-.036.01-.051.046-.036.072.015.026.072.046.128.046zm2.953 0c.04 0 .072-.015.072-.04a.33.33 0 00-.057-.119c-.046-.067-.051-.062-.025.01.015.052.01.088-.016.088-.026 0-.072-.036-.108-.077-.036-.042-.046-.103-.025-.14.025-.04.015-.045-.02-.025-.032.02-.062.057-.062.082 0 .026.035.083.082.124.051.061.118.097.159.097zm-16.077-.051c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .01.01.026.026.026zm6.341 0c.036 0 .052-.016.036-.036-.02-.02-.051-.02-.067 0-.02.02-.005.036.031.036zm13.176 0a.317.317 0 00.2-.103c.052-.056.077-.103.062-.103a1.01 1.01 0 00-.2.103c-.139.082-.15.103-.062.103zm-8.118-.052c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .01.01.025.026.025zm.308 0c.077 0 .128-.03.128-.071 0-.041-.02-.088-.05-.108-.032-.02-.052-.088-.052-.154 0-.067-.031-.134-.072-.15-.041-.015-.087.011-.108.057-.02.052 0 .108.051.144.052.041.062.072.031.092a.141.141 0 00-.056.108c0 .052.051.082.128.082zm.514 0c.046 0 .077-.025.066-.056-.01-.03-.04-.056-.066-.056-.026 0-.057.025-.067.056-.01.03.02.056.067.056zm5.258 0c.03 0 .159-.128.287-.287.129-.16.236-.318.236-.36 0-.04-.02-.071-.04-.071a.145.145 0 00-.083.036.206.206 0 01-.087.046.636.636 0 01-.103.01c-.03.005-.046.026-.03.046.01.02-.006.067-.042.098-.036.036-.082.046-.108.025-.02-.02-.02-.005 0 .031.021.036.057.052.083.041.025-.015.056.01.072.052.02.046 0 .077-.052.077-.046 0-.061.025-.04.056.025.041-.006.052-.114.026-.118-.026-.133-.026-.056.02.051.031.077.077.061.103-.02.026-.01.046.016.051zm-2.948-.05c.041 0 .077-.011.077-.021 0-.01-.036-.036-.077-.052-.04-.015-.077-.005-.077.02 0 .026.036.052.077.052zm1.67 0c.035 0 .05-.016.035-.037-.02-.02-.051-.02-.067 0-.02.02-.005.036.031.036zm4.96-.016c.015-.016.02-.062.004-.098-.015-.04-.03-.03-.03.031 0 .056.01.082.025.067zm-9.171-.036c.056 0 .112-.02.128-.046.015-.026-.005-.072-.046-.108-.041-.036-.098-.046-.129-.031-.03.02-.051.067-.051.108 0 .04.041.077.098.077zm.734-.052c.025-.025.036-.082.015-.128-.015-.046-.067-.082-.108-.082-.04 0-.077.03-.077.067 0 .036.026.092.062.128.036.041.082.046.108.015zm7.26.031c.021-.02.021-.051 0-.066-.02-.021-.035-.006-.035.035 0 .036.015.052.035.031zm-8.554-.03c.056 0 .097-.026.097-.052 0-.03-.036-.051-.082-.051-.056 0-.072-.026-.051-.093.03-.082.026-.082-.051-.005-.047.046-.072.108-.052.139.02.03.082.061.139.061zm4.6-.006c.037 0 .078-.02.093-.046s.062-.036.108-.02c.041.015.077.005.077-.026 0-.03-.03-.057-.067-.057a.397.397 0 00-.17.077c-.056.042-.076.072-.04.072zm1.094-.046a.35.35 0 00.052-.128c0-.026-.02-.016-.052.025a.319.319 0 00-.051.129c0 .03.026.015.051-.026zm1.72.051c.016 0 .026-.01.026-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .01.01.025.026.025zm.17 0c.01 0-.005-.03-.036-.071a1.972 1.972 0 01-.16-.375 1.901 1.901 0 01-.102-.432c0-.071-.046-.22-.097-.333-.062-.144-.129-.21-.206-.216-.092-.005-.108.01-.082.139.015.082.051.21.077.282.026.072.051.2.051.288 0 .082.02.149.041.149s.067.05.098.112c.03.062.057.088.062.052 0-.036.02-.062.046-.062s.046.046.046.098c.005.051.062.159.123.23a.625.625 0 00.139.14zm-.329-.513c-.051 0-.072-.026-.056-.077.015-.041.005-.087-.02-.108-.026-.015-.052-.051-.052-.077 0-.026.02-.046.051-.046.026 0 .047.015.041.036-.005.02.016.092.052.154.061.097.056.118-.016.118zm-.092-.41c-.01 0-.036-.026-.057-.052-.015-.031-.005-.051.021-.051.026 0 .056.02.056.05 0 .027-.01.052-.02.052zm-.057-.155c-.015 0-.025-.01-.025-.026 0-.015.01-.025.025-.025.016 0 .026.01.026.025 0 .01-.01.026-.026.026zm0-.103c-.015 0-.025-.01-.025-.025 0-.016.01-.026.025-.026.016 0 .026.01.026.026 0 .01-.01.025-.026.025zm-.05-.102c-.016 0-.027-.01-.027-.026 0-.015.01-.026.026-.026.015 0 .026.01.026.026 0 .01-.01.026-.026.026zm-11.58 1.232c.036 0 .051-.015.036-.036-.02-.02-.051-.02-.067 0-.02.02-.005.036.031.036zm5.422 0c.067 0 .134-.026.154-.056.021-.031 0-.093-.04-.134-.062-.062-.103-.067-.185-.02-.062.036-.093.087-.077.133.015.041.082.077.148.077zm3.477-.005c.02 0 .036-.036.036-.087 0-.052-.072-.129-.16-.18-.087-.051-.18-.077-.205-.062-.026.016-.026.072.01.134.031.056.108.123.17.149.056.02.128.046.149.046zm1.556-.046c.01 0 .02-.026.02-.052 0-.03-.026-.05-.056-.05-.031 0-.041.02-.02.05.02.026.04.052.056.052zm1.38 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .01.01.026.026.026zm-9.14-.052c.016 0 .026-.01.026-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .01.01.025.026.025zm1.49 0c.041 0 .077-.025.077-.05 0-.032-.02-.052-.051-.052-.026 0-.036-.041-.016-.088.02-.056.016-.071-.025-.046-.031.02-.062.082-.062.139 0 .051.036.097.077.097zm1.94-.005c.021.005.027-.02.011-.046-.015-.03-.092-.051-.17-.046l-.138.005.128.041.17.046zm3.036.005c.015 0 .04-.025.056-.05.015-.032.02-.052.005-.052s-.04.02-.056.051c-.016.026-.02.051-.005.051zm.677 0c.077 0 .195-.061.278-.148.082-.083.149-.2.149-.262 0-.072-.021-.098-.062-.072-.046.025-.041.01.005-.046a.265.265 0 00.036-.221c-.03-.118-.046-.123-.118-.067-.077.062-.077.056-.005-.062.056-.087.067-.164.036-.23a1.165 1.165 0 00-.144-.227c-.092-.118-.103-.118-.185-.04-.046.046-.113.087-.149.087-.036 0-.067.036-.067.077 0 .04.067.087.144.107.077.016.17.016.206-.005.036-.025.046-.015.025.02-.02.032-.087.062-.144.062-.107 0-.107 0-.01.078.057.04.077.077.052.077-.026 0-.006.035.05.077.098.071.098.077-.004.082a.66.66 0 01-.144 0c-.02-.005-.041.051-.041.118s.036.138.082.154c.046.015.134.02.195.005.062-.015.031.01-.061.051-.093.041-.19.067-.21.052-.027-.016-.057.036-.073.113a.427.427 0 00-.005.18c.026.02.098.035.164.04zm-6.151-.071c.159-.006.185-.016.133-.072-.046-.047-.102-.052-.195-.016-.072.026-.133.062-.133.072 0 .01.087.02.195.016zm1.314.02a.585.585 0 00.154-.03c.047-.016.083-.052.083-.078 0-.025-.072-.046-.154-.046-.103 0-.155.026-.155.077 0 .041.031.072.072.077zm2.316 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .01.01.02.026.026zm.59 0c.037 0 .052-.015.037-.036-.02-.02-.052-.02-.067 0-.016.02-.005.036.03.036zm1.485 0c.025 0 .061-.02.082-.051.015-.031-.005-.052-.046-.052-.047 0-.083.02-.083.052 0 .03.021.051.047.051zm-1.87-.051c.016 0 .026-.01.026-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .01.01.02.026.026zm4.067-.02c.02-.021.02-.052 0-.068-.02-.02-.036-.005-.036.036 0 .036.016.052.036.031zm.195.02c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .01.01.02.025.026zm2.573 0c.01 0 .02-.01.02-.02 0-.011-.025-.042-.061-.062-.036-.021-.046-.016-.02.02.02.03.046.057.061.062zm-9.915-.067c.087.005.128-.015.128-.072 0-.051-.03-.072-.077-.051-.041.015-.077.005-.077-.026 0-.03-.02-.041-.051-.02-.031.015-.052.061-.052.092 0 .03.062.072.129.077zm2.464.01c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.015.025.025.025zm1.988 0c.02 0 .04-.036.04-.082 0-.046.026-.067.052-.046.026.02.036.056.02.087-.02.03-.01.041.026.02.031-.02.062-.066.062-.102 0-.036-.082-.103-.175-.149-.17-.082-.18-.082-.21.026-.026.077-.005.128.056.18a.338.338 0 00.129.066zm.374 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.015.025.025.025zm1.022 0c.016 0 .041-.025.057-.051.015-.031.02-.051.005-.051-.016 0-.041.02-.057.05-.015.032-.02.052-.005.052zm3.548-.03c.041-.016.077-.042.077-.052 0-.01-.036-.02-.077-.02-.04 0-.077.02-.077.05 0 .027.036.037.077.021zm-9.9-.037c.01-.01.031-.071.042-.133.02-.092.01-.103-.052-.057-.04.031-.061.093-.04.134.014.046.04.067.05.056zm-.01-.087c-.015 0-.025-.01-.025-.026 0-.015.01-.025.025-.025.016 0 .026.01.026.025 0 .016-.01.026-.026.026zm5.49.103c.015 0 .04-.026.056-.051.015-.031.02-.052.005-.052-.016 0-.041.02-.057.052-.015.03-.02.05-.005.05zm-4.668-.046c.067 0 .138-.026.159-.052.015-.03.01-.051-.01-.051s-.093-.015-.16-.03c-.087-.021-.112-.011-.112.05-.006.052.04.078.123.083zm3.44 0c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .01.01.02.026.026zm.195 0a.13.13 0 00.108-.077c.015-.041.01-.077-.015-.077-.026 0-.072.036-.108.077-.052.061-.052.072.015.077zm2.11 0c.016 0 .042-.026.057-.052.016-.03.02-.051.005-.051s-.04.02-.056.051c-.016.026-.02.052-.005.052zm3.6 0c.041 0 .108-.052.154-.113.046-.062.057-.124.031-.134-.026-.01-.108.02-.18.072-.072.046-.118.108-.102.134.015.02.061.04.097.04zm-3.748-.052c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .01.01.02.026.025zm-7.24-.051c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .01.01.02.026.026zm1.088 0c.036 0 .067-.03.067-.067a.068.068 0 00-.067-.067.068.068 0 00-.067.067c0 .036.026.062.067.067zm4.093 0c.015 0 .04-.026.056-.051.016-.031.02-.052.005-.052s-.04.02-.056.052c-.016.025-.02.051-.005.051zm1.057 0c.026 0 .052-.02.052-.051 0-.026.03-.036.072-.02.04.014.087 0 .113-.037.025-.046.015-.056-.041-.03-.047.015-.093 0-.108-.037-.016-.036 0-.092.03-.123.042-.04.042-.056 0-.056-.03 0-.071.036-.087.082-.015.046-.02.103 0 .128.016.026.005.046-.025.046-.031 0-.057.02-.057.052 0 .02.026.04.051.046zm-4.903-.051c.066 0 .138-.02.149-.041.015-.021.01-.067-.01-.093a.248.248 0 00-.124-.082c-.051-.02-.097 0-.118.046a.476.476 0 00-.03.123c.004.02.06.041.133.047zm6.007 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .01.01.02.025.026zm.18-.026a.292.292 0 00.067-.128c.015-.057.01-.093-.016-.077a.292.292 0 00-.066.128c-.016.051-.01.087.015.077zm-18.26-.026c.011 0 .031-.036.052-.077.015-.04.005-.077-.02-.077-.026 0-.052.036-.052.077s.01.072.02.077zm11.344-.02a.07.07 0 00.071-.072c0-.041-.025-.062-.05-.052a.124.124 0 00-.073.072c-.01.031.016.052.052.052zm4.775.015c.041 0 .087-.036.108-.082.02-.057.005-.077-.057-.062-.046.01-.097.047-.108.082-.01.036.016.062.057.062zm.447 0c.025 0 .051-.03.051-.072 0-.04-.036-.087-.082-.102-.046-.016-.098-.021-.113-.006-.016.016 0 .026.03.026.031 0 .057.016.052.036a.196.196 0 000 .077c.005.026.036.041.062.041zm.744 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm1.078 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.025.026zm.257-.01c.072-.01.129-.082.18-.231.041-.118.056-.236.036-.257-.02-.02-.057-.005-.082.03-.026.042-.098.062-.175.047-.118-.02-.128-.01-.103.108.016.072.031.174.031.226.005.067.041.087.113.077zm-.102-.298c-.016 0-.026-.01-.026-.026 0-.015.01-.025.026-.025.015 0 .025.01.025.025 0 .016-.01.026-.025.026zm-2.645.257c.036 0 .051-.016.036-.036-.02-.02-.051-.02-.067 0-.02.025-.005.036.031.036zm2.131 0c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026s.01.026.026.026zm-17.87-.052c.016 0 .027-.01.027-.025 0-.016-.01-.026-.026-.026s-.026.01-.026.026c0 .015.01.025.026.025zm7.6-.113c.129-.061.221-.118.21-.128-.01-.01-.112.02-.23.067-.118.046-.21.103-.21.128 0 .026.102-.005.23-.067zm5.751.113c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm2.825 0c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.025.026.025zm.852 0c.02 0 .036-.071.03-.154 0-.087-.02-.138-.035-.123-.016.016-.031.087-.031.154 0 .072.015.123.036.123zm-5.88-.082c.072-.025.072-.036-.005-.082-.046-.026-.097-.036-.112-.02-.016.015-.01.05.005.082.015.03.071.036.113.02zm.252.036c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .01.01.02.025.025zm.288 0c.02 0 .056-.02.072-.046.015-.026.015-.082 0-.128-.016-.047-.062-.083-.098-.083a.153.153 0 00-.103.052c-.02.03-.005.087.031.128a.185.185 0 00.098.077zm4.154 0c.036 0 .051-.015.036-.036-.02-.02-.052-.02-.067 0-.02.02-.005.036.03.036zm.693 0c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .01.01.02.026.025zm2.31 0c.011 0 .006-.036-.01-.077-.015-.04-.04-.067-.056-.056-.015.015-.01.051.01.077.02.03.046.051.057.056zM.915 11.918c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .01.01.026.026.026zm13.17 0c.037 0 .052-.016.037-.036-.021-.02-.052-.02-.067 0-.02.02-.005.036.03.036zm2.979 0c.026 0 .051-.02.051-.051a.055.055 0 00-.051-.052.051.051 0 00-.051.052c0 .025.025.05.05.05zm-16.2-.087c.04-.016.061-.052.046-.077a.104.104 0 00-.077-.047c-.026 0-.047.036-.047.077 0 .047.031.067.077.047zm.164.015c.02-.02.02-.051 0-.067-.02-.02-.036-.005-.036.036 0 .036.015.052.036.031zm11.44.02c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.026.025.026zm4.776 0c.01 0 .036-.02.05-.046.016-.025.006-.061-.02-.082-.03-.015-.051.005-.051.046s.005.083.02.083zm1.848 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.026.026.026zm.18-.05a.35.35 0 00.051-.13c0-.025-.02-.015-.051.026a.35.35 0 00-.052.129c0 .026.026.015.052-.026zm-11.04-.011c.041-.016.2-.067.35-.113.148-.051.261-.103.246-.113-.016-.015-.15.015-.298.062a1.305 1.305 0 00-.324.138c-.036.031-.025.041.026.026zm3.615.005c.056 0 .082-.01.067-.026-.016-.015-.062-.02-.098-.005-.041.016-.026.031.03.031zm2.008.005c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm3.08 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm.668 0c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .016.01.026.026.026zm.334 0c.036 0 .051-.015.036-.036-.02-.02-.052-.02-.067 0-.02.02-.005.036.03.036zm.282 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm-9.217-.051c.036 0 .052-.016.036-.036-.02-.02-.051-.02-.067 0-.02.02-.005.036.031.036zm8.093-.016c.015-.015.02-.061.005-.097-.016-.041-.031-.03-.031.03-.005.057.01.083.026.067zm.713.016c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026s.01.026.025.026zm1.094 0c.01 0 .01-.062-.01-.144a2.97 2.97 0 00-.087-.282c-.031-.077-.077-.139-.103-.139-.026 0-.01.067.03.154a.735.735 0 01.078.247c0 .05.015.112.036.133.015.015.04.03.056.03zm.252-.02c.02-.021.02-.052 0-.067-.02-.021-.036-.006-.036.035 0 .036.015.052.036.031zm-12.118-.14c.118-.061.215-.117.215-.128 0-.01-.03-.02-.067-.02-.036 0-.133.056-.22.128l-.154.128zm5.021.108c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm.103 0c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.025.026.025zm.123 0c.031 0 .057-.02.057-.05 0-.032-.01-.052-.02-.052-.011 0-.037.02-.057.051-.02.026-.01.051.02.051zm.293-.005s.005-.03.005-.072c0-.04-.02-.077-.041-.077-.02 0-.051.021-.067.047-.015.025 0 .056.036.072.031.015.062.025.067.03zm5.448-.015c.02-.02.02-.051 0-.067-.02-.02-.036-.005-.036.036 0 .036.016.052.036.031zm1.017.02c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.02.026.026zm-11.887-.05c.036 0 .051-.016.036-.037-.016-.02-.052-.02-.067 0-.02.016-.005.031.03.036zm6.71-.006c.006 0 .011-.01.011-.02 0-.016-.123-.15-.277-.303-.154-.155-.36-.401-.462-.555-.103-.154-.185-.329-.185-.395a.632.632 0 00-.051-.221c-.031-.057-.088-.098-.134-.098-.046 0-.123.052-.175.118-.066.082-.148.118-.287.118-.108 0-.2.026-.21.057-.01.03.02.056.071.056.052 0 .118-.02.154-.051.046-.036.062-.03.062.015 0 .042.051.021.128-.05.123-.114.134-.114.226-.032.052.046.113.185.134.298.02.123.077.241.133.283.057.04.087.092.072.118-.015.025-.005.046.026.046.03 0 .056.025.056.056s-.025.036-.061.016c-.036-.02-.047-.016-.02.025.02.031.056.047.081.031.026-.015.123.052.216.144.092.098.236.21.323.257.088.046.165.087.17.087zm4.304.005c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025s-.026.01-.026.025c0 .01.01.026.026.026zm1.432-.02c.026-.01.067-.077.093-.15a.431.431 0 00-.016-.277c-.05-.143-.061-.143-.112-.046a.69.69 0 01-.098.134c-.02.02-.015.102.02.195.036.087.088.154.113.144zm-.513-.031c.01 0 .036-.026.056-.052.016-.03.006-.05-.02-.05-.026 0-.057.02-.057.05 0 .026.01.052.021.052zm-7.291-.057c.05 0 .082-.01.066-.025-.015-.016-.061-.02-.097-.005-.041.015-.031.025.03.03zm5.294.005c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .01.01.025.026.025zm.729 0c.015 0 0-.03-.036-.071-.041-.052-.041-.083-.005-.108a.067.067 0 00.02-.093c-.02-.036-.046-.02-.072.041-.02.057-.015.129.016.165a.33.33 0 00.077.066zm.128 0c.026 0 .041-.02.041-.046a.115.115 0 00-.041-.077c-.026-.015-.041.005-.041.046-.005.041.015.072.041.077zm.17 0c.015 0 .025-.01.025-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .01.01.025.025.025zM.872 11.41c.01-.067-.005-.15-.041-.18-.052-.046-.057-.036-.031.036.02.051.036.133.04.18.006.046.021.03.032-.036zm9.463.097c.036 0 .052-.015.036-.036-.02-.02-.051-.02-.067 0-.02.02-.005.036.031.036zm1.782-.02c.02-.021.02-.052 0-.067-.02-.02-.036-.005-.036.036 0 .036.015.051.036.03zm10.12-.01c.016-.016 0-.052-.035-.088-.036-.036-.062-.041-.062-.005 0 .03.016.067.036.087.02.02.051.02.062.005zM7.41 11.444c.041 0 .237-.03.437-.077.195-.04.672-.133 1.052-.205.38-.067.755-.123.832-.123.077 0 .154-.026.175-.062.026-.046-.057-.051-.313-.025-.19.02-.58.082-.868.143a35.27 35.27 0 00-.724.15 6.275 6.275 0 00-.437.117c-.128.047-.195.082-.154.082zm1.9.01c.036 0 .052-.015.036-.035-.02-.02-.051-.02-.067 0-.02.015-.005.036.031.036zm1.181 0c.036 0 .052-.015.036-.035-.02-.02-.051-.02-.067 0-.02.015-.005.036.031.036zm.36-.004c.051 0 .04-.02-.026-.047a.493.493 0 00-.154-.046c-.03 0-.015.02.026.046a.355.355 0 00.154.047zm1.56 0c.032 0 .016-.026-.035-.057-.072-.04-.082-.072-.031-.128.046-.057.041-.077-.02-.103-.047-.015-.093-.077-.114-.128-.015-.052-.056-.098-.087-.098-.03 0-.04.016-.02.036.02.02.01.067-.026.103-.041.051-.041.067 0 .067.03 0 .056-.031.056-.062 0-.03.036-.01.083.056.046.067.066.134.05.15-.014.015-.004.06.027.097.03.036.087.067.118.067zm-4.97-.119c.108-.035.483-.133.832-.215.467-.108.6-.16.514-.185a.829.829 0 00-.2-.036c-.062-.005-.062.005-.011.041.051.03.03.051-.062.067-.072.015-.133.005-.133-.02 0-.026-.026-.047-.057-.047-.03 0-.04.02-.025.046s-.072.072-.2.103c-.124.03-.247.057-.268.057-.02 0-.005-.021.036-.052.067-.046.067-.051 0-.046a.546.546 0 00-.18.046c-.102.046-.102.046 0 .052.057.005.078.02.047.03-.03.01-.113 0-.18-.025-.087-.036-.097-.052-.036-.052.052 0 .093-.025.093-.056s.02-.041.051-.02c.026.015.051.01.051-.016 0-.026.283-.082.627-.128.344-.047.847-.103 1.12-.119.271-.015.497-.046.513-.061.015-.016-.308-.005-.72.015a32.3 32.3 0 01-1.052.041c-.2 0-.262.01-.18.031.113.03.103.041-.092.072-.123.02-.246.02-.272.005-.026-.015-.103-.02-.17 0-.087.02-.128.077-.149.195a2.394 2.394 0 01-.061.257c-.03.082-.016.087.164.02zm.093-.087c-.062 0-.072-.015-.031-.03.036-.016.082-.016.097.004.016.016-.01.026-.066.026zm11.455.154c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.03.025.025zm.129 0c.036 0 .051-.015.036-.036-.02-.02-.052-.02-.067 0-.02.02-.005.036.03.036zm.277-.097c.077-.067.134-.175.134-.237a.422.422 0 00-.077-.21c-.057-.077-.077-.082-.077-.02 0 .04-.047 0-.103-.093-.057-.092-.123-.164-.154-.164-.026 0-.041.03-.026.072.016.04-.01.107-.062.159-.082.082-.082.092 0 .174.072.072.098.077.2.016.103-.067.109-.062.047.01-.036.046-.051.113-.03.144.025.04.015.051-.037.025-.04-.02-.04-.01.01.031.047.036.072.103.057.144-.01.046.036.026.118-.051zm-.303-.314c-.015 0-.026-.01-.026-.025 0-.016.01-.026.026-.026s.026.01.026.026c0 .015-.01.025-.026.025zm-10.424.36c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm1.875 0c.051 0 .04-.016-.026-.046a.493.493 0 00-.154-.047c-.03 0-.015.021.026.047a.355.355 0 00.154.046zm.328 0c.057 0 .082-.01.067-.026-.015-.015-.062-.02-.098-.005-.04.016-.03.026.031.03zm.622 0c.077 0 .066-.016-.052-.067-.082-.036-.164-.056-.18-.046-.015.01.01.041.052.067a.405.405 0 00.18.046zm.2 0c.015 0 .04-.02.056-.051.016-.031.02-.052.005-.052s-.04.02-.056.052c-.015.03-.02.05-.005.05zm.282 0c.057 0 .108-.01.108-.02s-.036-.031-.077-.052c-.041-.015-.087-.005-.108.02-.015.031.02.052.077.052zm1.104 0c.016 0 .041-.02.057-.051.015-.031.02-.052.005-.052-.016 0-.041.02-.057.052-.015.03-.02.05-.005.05zm-3.44-.051c.056 0 .082-.01.067-.026-.016-.016-.062-.02-.098-.005-.041.015-.03.025.03.03zm1.083 0c.031 0 .016-.021-.025-.052a.35.35 0 00-.129-.051c-.03 0-.015.02.026.051.041.031.098.052.128.052zm6.419 0c.015 0 .026-.01.026-.026s-.01-.026-.026-.026-.026.01-.026.026c0 .015.01.026.026.026zm.99-.031a.672.672 0 00.201-.082.158.158 0 00.062-.113c0-.036-.046-.103-.103-.154-.056-.052-.103-.077-.103-.052 0 .02-.056-.02-.128-.092-.072-.077-.149-.134-.175-.134-.025 0-.061.046-.077.108a.215.215 0 01-.133.134c-.077.02-.093.046-.057.092.031.036.119.067.196.067.077 0 .184-.02.24-.046.098-.047.098-.047.006.03a.726.726 0 01-.154.098c-.041.015-.036.046.015.103.057.046.118.061.21.04zm-7.05-.02c.047 0 .062-.032.047-.078-.015-.04-.051-.061-.077-.046a.104.104 0 00-.046.077c0 .026.03.046.077.046zm5.803 0c.016 0 .026-.011.026-.026 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.025.026.025zm.663-.011c.071-.005.133-.026.133-.046s-.026-.052-.051-.067c-.031-.015-.088.005-.134.046-.072.072-.067.077.052.067zm1.494.01c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.025.026.025zm.873 0c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.025.026.025zm.174-.025c.016-.016-.005-.052-.046-.077-.041-.026-.056-.047-.036-.047.02 0 .026-.025.01-.051-.015-.03-.056-.036-.082-.02-.03.02-.015.071.036.128.046.051.103.082.118.067zm2.09.025c.01 0 .016-.056.016-.123 0-.098-.021-.118-.103-.098-.098.026-.098.031-.016.124a.368.368 0 00.103.097zm-10.598-.092c.077-.062.092-.062.092 0 0 .04.031.02.057-.046.04-.088.082-.108.174-.083.072.02.124.005.124-.025 0-.031-.057-.057-.129-.057-.072 0-.144.036-.159.077-.015.041-.046.067-.072.052-.02-.016-.072.015-.108.066-.061.077-.056.077.02.016zm1.12.04c.03 0 .05-.02.05-.05 0-.031-.02-.052-.05-.052-.032 0-.052.02-.052.051 0 .031.02.052.051.052zm4.559-.025c.015-.015 0-.051-.036-.087s-.062-.041-.062-.01c0 .03.016.066.036.087.02.026.052.026.062.01zm1.68.026c.014 0 .025-.01.025-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .016.01.026.026.026zm-6.009-.052c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm4.416 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm.124-.061c.01-.03-.01-.072-.052-.093-.036-.025-.077-.035-.087-.025-.01.01.01.051.051.092.036.046.077.057.088.026zm2.341.061c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.025.026.025zM.97 11.096c.041 0 .072-.036.072-.077 0-.04-.025-.077-.051-.077-.031 0-.052-.036-.052-.077 0-.04.021-.077.047-.077.025 0 .061-.092.082-.21.02-.118.015-.231-.016-.262-.03-.031-.077.067-.133.282-.046.185-.072.37-.051.416.015.041.061.082.102.082zm10.321-.02c.036 0 .052-.031.036-.067-.015-.036-.04-.067-.061-.067-.02 0-.036.031-.036.067 0 .036.025.067.061.067zm.15.02c.015 0 .025-.01.025-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .01.01.025.025.025zm5.57 0c.026 0 .062-.025.083-.061.02-.036.015-.047-.02-.02-.032.02-.062.01-.062-.027 0-.035-.016-.05-.031-.03-.016.02-.088.01-.154-.016-.098-.036-.113-.03-.093.031.016.041.062.067.098.051.036-.015.082-.005.097.021.026.026.057.051.082.051zm4.889 0c.03 0 .015-.036-.041-.077a.422.422 0 00-.21-.077.24.24 0 01-.17-.077c-.046-.056-.046-.102.005-.2.036-.067.18-.22.318-.339.19-.164.283-.21.38-.19a.41.41 0 00.195 0 .123.123 0 00.067-.108c0-.046-.015-.061-.041-.03-.02.03-.103.056-.18.061-.123.01-.133 0-.092-.087a.342.342 0 01.118-.123c.036-.016.02-.026-.03-.031-.052 0-.19.025-.299.056-.17.052-.21.046-.251-.01-.041-.057-.046-.051-.036.026.01.066-.026.113-.113.138-.103.031-.093.036.051.02.165-.02.17-.015.062.037-.093.046-.144.04-.221-.005-.082-.052-.098-.047-.098.036 0 .056.047.113.103.133a.35.35 0 00.206 0c.056-.015.113-.077.133-.133.015-.057.103-.14.185-.18.087-.046.164-.067.18-.057.015.016-.02.067-.077.118a2.729 2.729 0 01-.288.221 1.348 1.348 0 00-.313.344c-.103.175-.118.237-.077.319.04.072.108.102.23.102.098 0 .19.02.206.052.031.04.067.061.098.061zm-13.823-.051c.036 0 .051-.015.036-.036-.02-.02-.052-.02-.067 0-.02.02-.005.036.03.036zm4.575 0c.02 0 .051-.036.067-.082a.966.966 0 00.03-.247.526.526 0 00-.05-.241c-.042-.062-.052-.057-.052.041 0 .062-.02.118-.046.118s-.062.036-.077.082c-.026.072-.02.072.046.02.067-.056.072-.035.061.124-.01.103 0 .185.021.185zm6.234 0c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .01.01.026.026.026zm-8.221-.051c.015 0 .04-.02.056-.052.016-.025.02-.051.005-.051s-.04.026-.056.051c-.015.026-.02.052-.005.052zm.339-.016c.056.005.108-.01.123-.025.01-.021-.03-.072-.092-.119-.108-.082-.113-.077-.124.026-.005.077.026.113.093.118zm.03-.036c-.01 0-.04-.025-.061-.061-.02-.036-.015-.047.02-.02.031.02.062.045.062.06 0 .016-.01.021-.02.021zm.524.005c.01-.036.01-.077-.01-.097a.047.047 0 00-.062 0c-.015.015-.01.061.01.097.032.052.047.052.062 0zm5.058.01c.02-.01.041-.046.041-.076 0-.026-.02-.036-.051-.02-.031.014-.057.004-.057-.021a.845.845 0 01-.01-.113.112.112 0 00-.077-.083c-.051-.02-.056 0-.015.077.051.093.04.103-.139.088-.154-.01-.17-.005-.098.036.052.03.129.04.165.025.04-.015.102.005.138.041.031.041.077.062.103.047zm.6.037c.037 0 .052-.016.037-.036-.02-.02-.052-.02-.067 0-.02.02-.005.036.03.036zm5.47-.006c.082 0 .21-.03.282-.071a.709.709 0 01.195-.077c.036 0 .051.025.03.056-.02.036-.015.046.027.02.03-.02.046-.061.025-.092-.02-.03-.01-.04.02-.02.032.02.14 0 .242-.047.103-.046.185-.087.185-.102 0-.01-.103-.02-.231-.02-.129 0-.221.02-.206.045.016.02-.071.077-.195.118-.118.042-.287.103-.375.129l-.154.051zm-13.644-.046c.036 0 .052-.02.036-.051-.015-.03-.082-.051-.144-.051-.092 0-.097.01-.036.05a.443.443 0 00.144.052zm2.65 0c.015 0 .04-.025.056-.051.016-.03.02-.051.005-.051s-.04.02-.056.05c-.015.027-.02.052-.005.052zm5.397 0c.01 0 .035-.025.056-.051.015-.03.005-.051-.02-.051-.026 0-.057.02-.057.05-.005.027.005.052.02.052zm-7.651-.051c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .01.015.026.026.026zm1.13 0c.015 0 .025-.01.025-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .01.015.026.025.026zm.728-.02c.021-.021.021-.052 0-.067-.02-.02-.036-.005-.036.036 0 .035.016.05.036.03zm.642-.078c.02-.061.057-.113.077-.113.02 0 .02.047.005.103-.02.072 0 .103.062.103.051 0 .139-.057.205-.123.098-.103.103-.129.036-.155a.56.56 0 00-.246 0c-.113.021-.144.016-.098-.02.052-.036.036-.057-.077-.087a2.732 2.732 0 01-.323-.113 9.48 9.48 0 01-.503-.242 2.761 2.761 0 01-.534-.36c-.119-.107-.231-.184-.262-.179-.026.01-.01.052.03.098.047.046.072.092.057.108-.015.015.02.04.077.061.056.02.108.067.108.113 0 .057-.031.067-.113.041-.103-.03-.108-.03-.041.052.051.061.118.082.21.061.103-.02.134-.005.139.062 0 .046-.02.103-.051.118-.026.02 0 .046.056.067.062.02.154.01.21-.02.093-.052.103-.042.103.081 0 .129.01.134.2.108.15-.02.196-.01.18.036-.015.036.016.098.062.134.072.061.108.056.241-.021.139-.077.15-.082.123-.005-.015.046-.015.108.006.139.005.046.036.025.061-.047zm-.385-.128c-.02.02-.036.005-.036-.036 0-.036.016-.051.036-.036.02.026.02.057 0 .072zm-.755-.288c-.036 0-.051-.015-.036-.036.021-.02.052-.02.067 0 .026.021.01.036-.03.036zm1.566.514c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025.005.01.015.026.025.026zm3.508-.02c.138.004.164-.006.087-.031a2.166 2.166 0 00-.36-.067c-.24-.031-.246-.026-.087.03.093.031.257.062.36.067zm.99.02c.026 0 .052-.036.052-.077s-.01-.077-.02-.077-.031.036-.052.077c-.015.041-.01.077.02.077zm.134-.016c.016-.015.02-.061.005-.097-.015-.041-.03-.03-.03.03-.006.052.004.083.025.067zm2.763.016c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025.005.01.015.026.026.026zm1.812-.046c.01-.036.01-.077-.01-.098a.047.047 0 00-.062 0c-.015.016-.01.062.01.098.037.051.047.051.062 0zm1.007.04c.107 0 .107-.004.01-.056a1.434 1.434 0 01-.231-.174.896.896 0 00-.267-.17c-.087-.036-.15-.036-.17-.005-.015.026.005.052.047.052.04 0 .174.082.292.18.113.097.257.174.319.174zM7.384 10.82c.056-.015.215-.056.354-.087.139-.031.36-.046.488-.031.164.015.19.015.082-.01-.123-.031-.062-.052.334-.103.267-.036.606-.082.744-.108l.257-.041-.21-.005a6.016 6.016 0 00-.745.067c-.298.04-.709.113-.92.154-.21.046-.405.108-.436.133-.036.046-.02.052.052.031zm.385.01c.072 0 .097-.01.061-.025a.184.184 0 00-.128 0c-.03.015 0 .025.067.025zm2.08.005c.056 0 .082-.01.066-.025-.015-.016-.061-.02-.097-.005-.041.015-.031.025.03.03zm5.442 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.015.025.025.025zm1.433 0c.015 0 .041-.02.056-.051.016-.03.021-.051.006-.051-.016 0-.042.02-.057.051-.015.03-.015.051-.005.051zm.827-.01c.133-.01.21-.041.215-.092a.258.258 0 00-.025-.139c-.02-.03-.103-.077-.175-.092-.118-.031-.139-.016-.154.087-.01.072-.056.123-.108.128-.072.005-.072 0-.01-.015.051-.016.077-.067.067-.134-.01-.066-.057-.118-.118-.123-.067-.01-.124.03-.16.113-.051.113-.04.134.103.205.087.036.252.067.365.062zm1.401-.03c.077-.042.103-.088.083-.15a.599.599 0 00-.088-.159c-.04-.056-.061-.046-.092.041a.152.152 0 01-.134.103c-.087-.005-.087-.005 0-.03.052-.011.088-.042.088-.057 0-.02-.02-.067-.047-.103-.035-.056-.066-.051-.148.036l-.103.103.2.097c.113.057.185.118.164.139-.02.02.016.01.077-.02zm-2.326-.011c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025.005.016.015.026.025.026zm-6.341-.051c.036 0 .051-.016.036-.036-.02-.02-.052-.02-.067 0-.02.02-.005.036.03.036zm.95-.016c.04 0 .077-.02.077-.04 0-.021-.036-.042-.077-.042s-.077.02-.077.041c0 .02.036.041.077.041zm3.728.01c.015.006-.02-.03-.072-.071a.431.431 0 00-.139-.077c-.02 0-.04.02-.04.046s.05.056.117.072c.057.015.118.025.134.03zm1.201.006c.01 0 .036-.02.052-.047.015-.025.005-.061-.02-.082-.032-.015-.052.005-.052.046 0 .047.01.083.02.083zm.165-.016c.02-.02.02-.051 0-.066-.021-.021-.036-.006-.036.035.005.036.02.052.036.031zm2.1.016c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.026.026.026zM7.415 10.68c.025 0 .046-.01.046-.02s-.036-.036-.082-.052c-.047-.015-.067-.01-.047.021.02.03.057.051.083.051zm1.36-.01c.144 0 .206-.01.144-.02s-.18-.01-.257 0c-.082.01-.03.02.113.02zM11 10.655c.015-.016 0-.057-.036-.088-.036-.036-.062-.04-.062-.01 0 .031.015.067.036.087.02.021.046.026.062.01zm4.77-.016c.01-.036.01-.077-.01-.097a.047.047 0 00-.062 0c-.015.015-.01.061.01.097.036.052.046.052.062 0zm.118.041c.03 0 .051-.02.051-.051 0-.03-.02-.051-.051-.051-.03 0-.051.02-.051.051 0 .03.02.051.051.051zm.154 0c.036 0 .051-.015.036-.036-.02-.02-.051-.02-.067 0-.025.021-.01.036.031.036zm-8.37-.072c.072-.015.38-.071.693-.128.314-.056.683-.123.822-.154l.257-.051-.308.015c-.17.01-.35.03-.4.051a.817.817 0 01-.309.01c-.16-.02-.19-.015-.113.021.077.036.046.046-.128.026-.144-.015-.19-.01-.129.015.083.031.062.047-.113.077a.89.89 0 01-.308.005c-.082-.025-.082-.02-.015.031.062.047.046.057-.077.031-.118-.026-.134-.02-.077.02.04.031.133.047.205.031zm1.746.006c.21 0 .298-.01.195-.02a2.41 2.41 0 00-.385 0c-.108.01-.026.02.19.02zm1.207.015c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm.154 0c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm3.743 0c.026 0 .036-.005.026-.015a1.364 1.364 0 00-.19-.098c-.093-.046-.165-.062-.165-.036 0 .026.062.067.14.093.076.025.163.05.19.056zm.57-.03c.041-.016.072-.057.062-.088-.01-.03-.082-.067-.154-.072-.098-.01-.139.005-.139.062 0 .046.026.082.056.082.031 0 .042-.026.021-.057-.02-.036-.01-.046.036-.03.041.015.067.05.062.082-.016.025.015.036.056.02zm.22-.011c.011-.03.057-.036.098-.02.057.02.072.01.047-.031-.02-.031-.083-.062-.139-.062-.056 0-.098.02-.098.041 0 .02.016.062.036.082.02.02.047.016.057-.01zm.294.041c.01 0 .02-.02.02-.051 0-.031-.026-.052-.056-.052-.031 0-.041.02-.02.052.02.03.045.051.056.051zm1.247 0a.213.213 0 00.21-.19c0-.041-.06-.067-.148-.067-.087 0-.16.031-.18.082-.015.047-.02.103 0 .129.016.025.072.046.118.046zm-.385-.051a.28.28 0 00.18-.062.213.213 0 00.062-.128c0-.036-.057-.067-.129-.067-.072 0-.149.041-.18.097a.446.446 0 00-.05.129c0 .02.05.03.117.03zm-9.263-.052c.026 0 .062-.02.077-.046s.113-.062.22-.082c.109-.02.237-.057.288-.087.052-.026.088-.062.072-.072-.01-.01-.133.01-.272.056a3.707 3.707 0 01-.277.077c-.016 0 .015-.025.067-.056.05-.031.077-.077.061-.103-.015-.026 0-.051.036-.051s.02-.026-.036-.046c-.056-.021-.123-.047-.154-.047-.026 0-.015.02.026.047.061.04.051.05-.052.056l-.128.005.128.046c.103.036.093.041-.077.026-.113-.01-.174-.01-.138.005.036.015.051.046.036.072-.016.026.025.051.087.051.067 0 .087.016.057.031-.036.016-.062.046-.062.072-.005.026.015.046.041.046zm2.778-.005c.072 0 .097-.01.062-.025a.184.184 0 00-.129 0c-.036.015-.005.025.067.025zm.39.005c.046 0 .036-.036-.036-.108-.056-.056-.118-.092-.133-.077-.016.016 0 .062.036.108.036.047.092.077.133.077zm.431 0c.036 0 .052-.015.036-.036-.02-.02-.05-.02-.066 0-.026.02-.01.036.03.036zm1.67 0c.015 0 .025-.01.025-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm2.156 0c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.025.026.025zm.144 0c.025 0 .03-.025.02-.061-.01-.036-.061-.072-.113-.082-.082-.016-.082-.006-.02.061.04.046.087.082.113.082zm1.304 0c.02 0 .092-.015.154-.03.062-.016.118-.062.118-.098 0-.041-.092-.072-.246-.087-.18-.016-.262 0-.308.056-.057.072-.062.072-.062-.005 0-.046-.041-.082-.093-.077-.05.005-.21-.01-.359-.036-.17-.026-.267-.02-.267.01 0 .026.036.062.077.083a.26.26 0 00.164-.006c.057-.02.072-.015.047.026-.02.03-.01.062.02.062s.108-.026.164-.057c.088-.046.103-.04.083.01-.02.052.03.072.18.083.123.005.225-.016.25-.052.032-.046.042-.036.042.026 0 .051.015.092.036.092zm2.424-.036c.056-.015.107-.061.107-.097 0-.036-.036-.072-.077-.072-.04 0-.077.01-.077.02s-.015.057-.03.098c-.021.062-.006.077.077.051zm-10.727-.015c.036 0 .051-.015.036-.036-.02-.02-.051-.02-.067 0-.02.02-.005.036.03.036zm2.798 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm3.8 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm.129 0c.025 0 .05-.02.05-.051 0-.031-.045-.072-.102-.103-.072-.036-.133-.041-.19-.005-.077.046-.067.051.052.051.077 0 .143.026.143.052-.005.035.016.056.047.056zm3.594 0c.036 0 .051-.015.036-.036-.02-.02-.051-.02-.067 0-.026.02-.01.036.031.036zm-4.03-.051c.015 0 .025-.01.025-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.026.026.026zm4.21-.005c.051-.01.102-.052.113-.088.015-.046-.01-.061-.067-.051-.051.01-.103.046-.113.087-.015.041.01.062.067.052zm1.643.005c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.03.026.026zm1.232 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.03.025.026zm.154 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.03.025.026zm.92-.016c.03-.01.061-.056.071-.097.01-.062-.01-.072-.092-.052-.057.016-.108.047-.108.067 0 .02.015.051.036.072.02.015.062.02.092.01zm-14.322-.036c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.03.025.025zm4.072-.046c.067-.036.108-.077.088-.092-.016-.016-.072.01-.119.061-.082.088-.082.088.031.031zm2.896.01c.052-.01.093-.056.093-.092 0-.046-.057-.072-.154-.072-.088 0-.154-.02-.154-.051 0-.031-.047-.052-.098-.052-.051 0-.113.031-.128.062-.016.036-.026.02-.016-.036.005-.062-.025-.108-.082-.118-.051-.01-.139.02-.19.067-.051.046-.082.118-.067.159.016.04.052.056.077.04.031-.02.026-.05-.02-.076-.051-.03-.041-.046.04-.046.063 0 .14.036.176.082.04.051.123.072.21.061.077-.01.134-.005.118.016-.01.02.005.046.041.061.036.01.108.006.154-.005zm2.84.041c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026s-.026.01-.026.026c0 .01.01.025.026.025zm.344-.01c.061-.01.113-.04.103-.067-.006-.025-.042-.056-.083-.066-.04-.01-.087.02-.102.066-.026.062-.005.077.082.067zm2.865.01c.036 0 .051-.015.036-.036-.02-.02-.051-.02-.067 0-.02.021-.01.036.031.036zm-3.44-.05c.036 0 .051-.016.036-.037-.02-.02-.052-.02-.067 0-.02.02-.01.036.03.036zm.38-.016a.14.14 0 00.072-.088c.015-.046-.01-.061-.077-.04a.188.188 0 01-.165-.042c-.051-.056-.077-.056-.133-.005-.057.051-.052.067.04.082.062.01.134.041.16.067.03.02.072.03.103.026zm2.47.015c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .01.01.026.026.026zm2.074 0c.03 0 .067-.02.082-.051.016-.031.01-.052-.02-.052-.031 0-.067.02-.082.052-.021.025-.01.051.02.051zM9.746 10.27c.056 0 .082-.01.066-.026-.015-.015-.061-.02-.097-.005-.041.015-.03.025.03.03zm.205 0c.057 0 .082-.01.067-.026-.016-.015-.062-.02-.098-.005-.04.015-.03.025.031.03zm3.805.005c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .01.01.026.026.026zm.257 0c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .01.01.026.026.026zm5.545 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .01.01.026.025.026zm1.202 0c.026 0 .062-.02.082-.052.02-.03-.005-.036-.046-.02-.046.015-.082.04-.082.051 0 .01.02.02.046.02zm-13.746-.093c.108-.03.108-.03.015-.072-.082-.036-.077-.04.036-.025.077.01.19-.02.257-.072.118-.087.108-.087-.18-.02a1.55 1.55 0 00-.328.097c-.016.015.01.03.061.03.052 0 .077.021.062.047-.026.026.015.03.077.015zm2.044.041c.036 0 .051-.015.036-.036-.02-.02-.052-.02-.067 0-.026.021-.01.036.03.036zm.18 0c.015 0 .025-.01.025-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026-.005.01.01.025.025.025zm1.021-.005c.052 0 .082-.01.067-.025-.015-.016-.062-.02-.098-.005-.04.015-.03.025.031.03zm1.53-.04c.031-.032.041-.068.026-.088-.015-.015-.056-.015-.087.005-.031.02-.041.056-.026.087.026.031.051.031.087-.005zm-.04-.006c-.016 0-.026-.01-.026-.026 0-.015.01-.025.025-.025.016 0 .026.01.026.025 0 .01-.01.026-.026.026zm.63.046c.021 0 .083-.036.134-.072.093-.066.088-.071-.02-.133-.093-.051-.129-.046-.195.026-.077.082-.077.082.046.025.108-.051.118-.051.062.005-.036.036-.062.088-.062.108-.005.026.015.046.036.041zm4.607.005c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .01.016.025.026.025zm.154 0c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026s-.026.01-.026.026c0 .01.016.025.026.025zm3.106 0c.031 0 .052-.02.052-.046 0-.025-.02-.061-.052-.082-.03-.015-.05.005-.05.046s.025.082.05.082zm.154 0c.036 0 .052-.015.036-.036-.02-.02-.05-.02-.066 0-.02.021-.005.036.03.036zm2.337-.102c.082-.082.092-.118.036-.17-.036-.036-.062-.04-.057-.015a.66.66 0 01.005.097c-.005.026-.04.006-.082-.05-.072-.098-.077-.093-.077.03 0 .072.016.149.036.17.016.025.077-.006.139-.062zm.097.102c.01 0 .036-.036.052-.082.015-.046.01-.067-.02-.046-.026.015-.052.051-.052.082 0 .02.01.046.02.046zM8.38 10.085a.637.637 0 01.133-.242c.067-.071.108-.143.093-.159a.129.129 0 00-.072-.03c-.026 0-.03.025-.016.05.016.032.01.052-.02.052s-.087.072-.128.16c-.047.087-.062.184-.041.215.02.041.04.02.05-.046zm1.34.087c.036 0 .051-.015.036-.036-.02-.02-.051-.02-.067 0-.02.02-.005.036.031.036zm1.72 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .01.015.026.025.026zm.611 0c.016 0 .041-.02.057-.051.015-.031.02-.052.005-.052-.016 0-.041.02-.057.052-.015.025-.02.051-.005.051zm7.307 0c.01 0 .016-.01.016-.015a.521.521 0 00-.113-.113l-.113-.098.097.113a.521.521 0 00.113.113zm.745 0c.03 0 .036-.02.02-.051a.105.105 0 00-.082-.052c-.026 0-.036.02-.02.052.015.025.05.051.082.051zm-8.791-.051c.036 0 .051-.016.036-.036-.02-.02-.052-.02-.067 0-.02.02-.005.036.03.036zm2.336 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .01.015.026.025.026zm1.669-.005c.056 0 .051-.01-.02-.052a1.995 1.995 0 01-.293-.257c-.108-.112-.2-.236-.2-.277a.079.079 0 00-.077-.077c-.047 0-.078-.046-.078-.128 0-.072-.01-.129-.025-.129a.816.816 0 00-.18.113c-.082.062-.164.098-.18.088-.015-.016 0-.103.031-.19.031-.088.041-.18.02-.2-.02-.021-.102.04-.184.133-.082.092-.149.21-.149.262a.48.48 0 00.108.23c.056.073.215.186.349.242.133.057.37.139.524.175.154.03.313.061.354.067zm1.643-.01a.326.326 0 00.139-.052c.02-.02-.026-.03-.103-.026-.077.005-.139.031-.139.052 0 .02.047.03.103.025zm.462 0c.057-.006.103-.026.103-.047 0-.02-.026-.041-.062-.041-.03 0-.123-.072-.205-.164a.612.612 0 01-.154-.267c-.005-.057 0-.15.005-.2.01-.078-.01-.088-.108-.057a.78.78 0 00-.185.087.168.168 0 00-.056.134c.005.066.01.066.03-.01.021-.072.052-.036.134.128.062.123.139.216.175.205.036-.005.056.016.051.052-.005.036.026.056.077.05.051-.01.087.016.087.063.01.04.052.071.108.066zm-.38-.345c-.015 0-.025-.01-.025-.025 0-.016.01-.026.025-.026.016 0 .026.01.026.026-.005.015-.015.025-.026.025zm-.051-.308c-.015 0-.026-.01-.026-.026 0-.015.01-.025.026-.025.015 0 .026.01.026.025-.005.016-.016.026-.026.026zm2.901.668c.03 0 .041-.02.026-.047-.016-.025 0-.056.036-.071.036-.01.046-.042.02-.067-.02-.026-.061-.01-.087.03a.492.492 0 00-.051.114c0 .02.025.04.056.04zm-12.426-.052c.036 0 .051-.015.036-.036-.02-.02-.052-.02-.067 0-.026.02-.01.036.03.036zm2.434-.005c.056 0 .082-.01.067-.025-.016-.016-.062-.021-.098-.006-.041.016-.03.031.03.031zm1.571.005c.036 0 .051-.015.036-.036-.02-.02-.051-.02-.067 0-.025.02-.01.036.031.036zm.508 0c.026 0 .062-.02.083-.051.02-.03 0-.036-.047-.02-.046.015-.082.04-.082.05 0 .011.02.021.046.021zm7.682 0c.041 0 .077-.01.077-.02s-.036-.031-.077-.052c-.041-.015-.077-.005-.077.021-.005.026.03.051.077.051zm-7.959-.051c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025-.005.01.01.026.026.026zm.97 0c.037 0 .103-.108.144-.246.041-.134.067-.268.047-.298-.016-.026-.057.036-.083.138a.797.797 0 01-.097.231c-.026.026-.031.016-.01-.015.02-.03.015-.072-.01-.092-.026-.016-.042 0-.037.036.005.035.031.097.057.138.036.057.026.067-.041.041-.052-.02-.077-.015-.057.016.005.025.052.051.088.051zm1.485-.051c.046-.047.035-.083-.052-.15a.52.52 0 01-.144-.2c-.02-.061-.056-.113-.077-.113-.025 0-.051.031-.066.062a.387.387 0 000 .154c.01.052.051.093.082.093.03 0 .087.05.128.107.052.083.082.093.129.047zm1.797.051c.097 0 .092-.015-.041-.154-.098-.103-.165-.139-.2-.103-.031.031-.021.088.04.154a.33.33 0 00.2.103zm.518-.015c.031-.01.062-.083.072-.154.016-.113-.005-.14-.092-.14-.062 0-.123.037-.139.078-.015.041 0 .113.036.154.036.046.087.072.123.062zm.262-.026c.016-.036.052-.051.077-.036.026.015.046.005.046-.02a.105.105 0 00-.05-.083c-.027-.015-.037-.072-.016-.118.03-.082.025-.082-.052 0a.358.358 0 00-.087.118c0 .016.026.016.057-.005.035-.026.046.005.025.087-.015.067-.015.093 0 .057zm2.362.041c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm.411 0c.01 0 .02-.01.02-.02s-.025-.042-.061-.062c-.036-.02-.046-.016-.02.02.02.036.05.062.061.062zm.637 0c.036 0 .051-.015.036-.036-.02-.02-.052-.02-.067 0-.02.02-.005.036.03.036zM6.87 9.936c.144-.016.298-.041.355-.057.077-.02.082-.036.025-.072a.521.521 0 00-.226-.04l-.154.005.154.04c.113.031.077.037-.154.026-.17-.01-.251-.005-.18.01.124.026.124.031.026.072-.067.031-.015.036.154.016zm4.693.03c.026 0 .077-.035.113-.087.062-.077.062-.082-.046-.025-.061.036-.113.072-.113.087s.02.026.046.026zm.714-.02c.01-.01.01-.046-.01-.077-.02-.03-.057-.056-.087-.056-.036 0-.031.03.01.077.03.04.072.066.087.056zm1.268.02c.016 0 .026-.01.026-.025 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.015.026.025.026zm6.188 0c.026 0 .051-.02.051-.05a.051.051 0 00-.051-.052c-.03 0-.051.02-.051.051 0 .031.025.052.051.052zm-8.765-.082c.051-.02.077-.046.061-.061-.015-.016-.056 0-.092.036-.046.046-.041.056.03.025zm.847.026c.02 0 .077-.03.128-.072.083-.061.083-.066-.04-.066-.078 0-.129.03-.129.071 0 .041.02.072.041.067zm.036-.046c-.015 0-.026-.01-.026-.026 0-.015.01-.025.026-.025.015 0 .026.01.026.025 0 .016-.01.026-.026.026zm7.086.051c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.016.025.026.025zm.16 0c.01 0 .02-.01.02-.02s-.026-.041-.062-.062c-.036-.02-.046-.015-.02.02.02.037.051.062.061.062zm.312-.036c.036-.015.067-.046.067-.072 0-.025-.025-.046-.051-.046-.03 0-.051.02-.051.052 0 .025-.042.036-.093.02-.072-.02-.077-.02-.015.02.04.026.102.042.143.026zm.17.036a.055.055 0 00.051-.051.051.051 0 00-.051-.051c-.03 0-.051.02-.051.05 0 .027.025.052.05.052zm3.27-.02c.021-.02.021-.052 0-.067-.02-.02-.035-.005-.035.036 0 .036.015.051.036.03zm.145.02c.01 0 .036-.02.05-.051.016-.03-.004-.051-.05-.051-.047 0-.067.02-.052.05.02.027.041.052.052.052zM11.45 9.843c.021-.02.021-.051 0-.066-.02-.02-.035-.005-.035.036 0 .036.015.05.035.03zm11.179.02c.01 0 .046-.035.082-.076.052-.062.052-.077-.02-.077-.047 0-.083.036-.083.077s.01.077.021.077zm-12.472-.05c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.026.026.026zm5.263 0c.03 0 .051-.01.051-.021 0-.01-.02-.036-.051-.056-.031-.016-.052-.006-.052.02 0 .03.026.057.052.057zm.59 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.026.025.026zm1.376 0c.036 0 .15-.016.252-.031.103-.016.18-.052.164-.072-.015-.02.026-.026.088-.01.082.02.102.01.071-.036-.03-.047-.01-.057.067-.031.072.02.108.01.108-.026 0-.046-.072-.051-.246-.03-.134.02-.267.061-.298.097-.031.036-.113.062-.19.056-.077-.005-.129.016-.113.036a.157.157 0 00.097.047zm3.713-.006a.88.88 0 00.251-.046c.077-.03.047-.04-.113-.03-.118.005-.23.025-.251.046-.02.02.03.03.113.03zm.714.006c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.026.026.026zM6.357 9.75c.082 0 .123-.01.092-.026a.261.261 0 00-.154 0c-.051.01-.02.026.062.026zm1.027.01c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.025.026.025zm.128 0c.036 0 .051-.015.036-.036-.02-.02-.051-.02-.067 0-.02.02-.005.036.031.036zm3.26 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.025.026.025zm1.413 0c.03 0 .056-.03.056-.072 0-.04.026-.082.062-.092.036-.01-.118-.118-.334-.236-.216-.118-.431-.267-.472-.329a.435.435 0 01-.077-.19c0-.041.036-.144.072-.22.066-.13.066-.144-.021-.196-.056-.03-.108-.03-.123-.005-.016.026-.016.082 0 .123.015.041-.02.129-.082.19-.103.103-.108.124-.036.175.072.051.072.067-.005.113-.067.046-.072.072-.026.123.036.036.133.062.216.062.087 0 .169.015.184.04.016.026 0 .062-.03.083-.036.02-.047.015-.026-.02.02-.031.01-.062-.02-.062-.031 0-.052.051-.042.113.016.097.047.113.185.102.093-.005.165.01.165.042 0 .03 0 .066.005.092 0 .02.036.056.077.082a.28.28 0 00.184.005c.072-.02.098-.015.072.02-.025.032-.015.057.016.057zm-.904-.616c-.015 0-.01-.026.005-.051.016-.031.041-.052.057-.052.015 0 .01.02-.005.052-.016.025-.042.051-.057.051zm4.627.616c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.015.025.026.025zm3.399-.015c.02-.02.02-.052 0-.067-.02-.02-.036-.005-.036.036 0 .03.015.046.036.03zm1.556.015c.036 0 .051-.015.036-.036-.021-.02-.052-.02-.067 0-.02.02-.005.036.03.036zM6.074 9.71c.036 0 .052-.016.036-.036-.02-.02-.051-.02-.066 0-.016.02-.006.036.03.036zm.59-.01c.083 0 .124-.01.093-.026a.261.261 0 00-.154 0c-.051.015-.02.026.062.026zm2.05.01c.01 0 .061-.016.107-.03.067-.027.072-.042.016-.078-.051-.03-.036-.041.046-.03.062.01.108 0 .103-.016-.005-.016.077-.129.18-.247.107-.118.19-.23.19-.251 0-.02-.062-.041-.144-.046-.077-.006-.17.015-.206.046-.04.036-.046.072-.015.113.026.03.03.087.005.128a.103.103 0 01-.128.036c-.047-.02-.093-.005-.103.03-.01.037-.03.13-.051.206-.01.072-.01.139 0 .139zm.261-.154c-.015 0-.025-.01-.025-.026 0-.015.01-.026.025-.026.016 0 .026.01.026.026s-.01.026-.026.026zm2.368.154c.01 0 .02-.01.02-.02s-.025-.042-.061-.062c-.036-.02-.047-.016-.021.02.02.036.046.062.062.062zm.303 0c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.015.026.026.026zm3.85 0c.006 0 .011-.03.011-.072 0-.041-.046-.087-.098-.098-.092-.025-.092-.02-.01.072.052.052.093.098.098.098zm.663 0c.016 0 .041-.02.057-.051.015-.031.02-.052.005-.052-.016 0-.041.02-.057.052-.015.03-.02.05-.005.05zm2.732 0c.01 0 .02-.01.02-.02s-.025-.042-.061-.062c-.036-.02-.046-.016-.02.02.02.036.045.062.06.062zm2.706-.01c.051.005.087-.016.087-.041 0-.026-.036-.062-.082-.077a.787.787 0 00-.205-.031c-.067 0-.124.02-.124.046s.052.056.113.072c.067.015.16.03.21.03zM6.28 9.648c.072 0 .097-.01.061-.025a.184.184 0 00-.128 0c-.03.015-.005.025.067.025zm.719 0c.097 0 .138-.01.087-.025a.355.355 0 00-.18 0c-.046.01-.005.025.093.025zm4.133.01c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.026.026.026zm5.248-.092a.181.181 0 00-.072-.19.341.341 0 00-.133-.072c-.021 0-.036.052-.036.113 0 .093.01.103.05.036.047-.067.057-.067.104 0a.468.468 0 01.056.154c.005.041.02.02.03-.04zm.308.077c.02-.02.02-.051 0-.067-.02-.02-.036-.005-.036.036 0 .031.015.047.036.031zm2.372.016c.031 0 .067-.047.088-.103.02-.057.01-.134-.021-.17-.03-.036-.041-.082-.02-.102.02-.02.005-.036-.031-.036s-.052.03-.036.077c.015.04.01.087-.02.102-.026.016-.093 0-.15-.035a.564.564 0 01-.164-.196 8.687 8.687 0 01-.16-.43 2.153 2.153 0 01-.097-.422c0-.067.02-.175.046-.246.036-.098.031-.134-.03-.16-.041-.015-.062-.01-.047.016.016.025.016.087-.005.133-.025.062-.04.072-.072.02-.03-.05-.061-.045-.123.021-.046.047-.108.088-.133.088-.026 0-.046.025-.046.056 0 .03.046.046.102.03.057-.014.103-.01.103.016 0 .026-.062.057-.139.083-.108.03-.118.046-.046.061.051.01.082.051.072.082-.01.031-.051.062-.092.067-.042.005-.098.01-.129.01-.03.005-.067.047-.082.098-.02.077.01.087.175.082.107-.005.22-.01.246-.01.026-.005.041-.052.03-.108a.57.57 0 00-.045-.149c-.016-.026 0-.103.04-.175.067-.128.073-.118.134.2.036.186.129.453.2.601.103.2.175.283.293.319.087.03.15.077.139.113-.026.036-.01.067.02.067zM5.094 9.607c.03 0 .066-.02.082-.051.015-.031.01-.052-.02-.052-.032 0-.068.021-.083.052-.015.026-.005.051.02.051zm.826-.01c.098 0 .139-.01.093-.026a.355.355 0 00-.18 0c-.051.016-.01.026.087.026zm.74.005c.056 0 .082-.01.066-.026-.015-.015-.061-.02-.097-.005-.041.016-.026.031.03.031zm.826.005c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.015.025.025.025zm.673 0c.01 0 .02-.01.02-.02s-.025-.041-.061-.062c-.036-.02-.046-.015-.02.02.02.037.05.062.061.062zm5.633-.092c.077-.077.092-.139.072-.236-.02-.088-.057-.124-.093-.098-.046.026-.046.041 0 .056.036.01.062.042.062.072 0 .026-.02.036-.051.02-.031-.015-.072.021-.098.088-.026.067-.03.139-.02.165.015.015.071-.01.128-.067zm-.092.04c-.016 0-.026-.01-.026-.025 0-.015.01-.026.026-.026.015 0 .025.01.025.026s-.01.026-.025.026zm.102-.102c-.015 0-.025-.01-.025-.026 0-.015.01-.025.025-.025.016 0 .026.01.026.025 0 .016-.01.026-.026.026zm4.596.154c.056 0 .103-.01.103-.02s-.047-.031-.103-.047c-.057-.015-.103-.005-.103.021 0 .026.046.046.103.046zM6.15 9.556c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026s.015.026.025.026zm2.167-.016c.02-.02.02-.05 0-.066-.02-.02-.036-.005-.036.036 0 .03.016.046.036.03zm.283.016c.025 0 .04-.026.03-.062a.13.13 0 00-.082-.082c-.036-.01-.051.01-.03.062.02.046.056.082.082.082zm1.725-.02c.01-.011-.005-.062-.03-.119-.047-.077-.057-.077-.057-.01 0 .046.015.097.03.113.021.02.047.026.057.015zm7.225.02c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026s.015.026.026.026zm-6.573-.052c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.016.025.026.025zm4.683-.015c.02-.02.02-.051 0-.067-.02-.02-.036-.005-.036.036 0 .031.016.046.036.031zm2.3.01c.057 0 .083-.01.067-.025-.015-.016-.061-.02-.097-.005-.041.015-.031.03.03.03zm.54.005c.025 0 .061-.02.082-.05.02-.032-.005-.037-.046-.021-.042.015-.083.04-.083.051-.005.01.02.02.047.02zM5.638 9.448c.056 0 .082-.01.067-.026-.016-.015-.062-.02-.098-.005-.041.016-.03.026.03.031zm2.778.005c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm4.98 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm4.262 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm.642 0c.031 0 .052-.01.052-.02s-.02-.036-.052-.057c-.025-.015-.051-.005-.051.02 0 .026.02.057.051.057zM5.31 9.381c.04-.01.21-.051.369-.082.164-.036.293-.072.293-.087 0-.016-.108-.01-.242.01-.133.02-.303.072-.37.113-.071.036-.092.062-.05.046zm.667.01c.097 0 .298-.015.436-.04l.257-.042h-.282c-.155 0-.35.016-.437.036l-.154.041zm9.474.01c.01 0 .02-.056.02-.128 0-.082-.051-.159-.128-.21-.072-.046-.144-.072-.16-.057-.015.016.031.113.108.21.077.104.15.186.16.186zm1.792 0c.01 0 .036-.02.056-.05.015-.031.005-.052-.02-.052-.026 0-.057.02-.057.051 0 .031.01.052.02.052zm.616-.004c.056 0 .082-.01.066-.026-.015-.015-.061-.02-.097-.005-.041.015-.03.026.03.03zm.236.005c.036 0 .051-.016.036-.036-.02-.02-.051-.02-.067 0-.026.02-.01.036.031.036zm.365 0c.03 0 .035-.02.02-.052a.105.105 0 00-.082-.05c-.026 0-.036.02-.02.05.015.026.05.052.082.052zM7.933 9.35c.03 0 .036-.02.02-.05a.105.105 0 00-.081-.052c-.031 0-.036.02-.021.051.015.026.051.051.082.051zm.339-.061c.036-.026.051-.113.046-.19a2.378 2.378 0 01-.02-.18c-.005-.02-.026-.03-.052-.01-.025.015-.04.097-.03.18.015.123.005.143-.067.118-.077-.031-.077-.026-.01.051.046.051.092.062.133.03zm.298.061c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026s-.026.01-.026.026c0 .01.01.025.026.025zm2.613 0c.016 0 .042-.02.057-.05.015-.032.02-.052.005-.052s-.041.02-.056.051c-.021.026-.021.051-.006.051zm2.265 0c.01 0 .02-.01.02-.02s-.025-.041-.061-.062c-.036-.02-.046-.015-.02.02.025.032.05.062.06.062zm3.045-.005c.062 0 .056-.015-.026-.056a.655.655 0 01-.215-.247 1.098 1.098 0 00-.19-.256c-.042-.036-.093-.052-.108-.036-.016.015.077.159.21.313.139.16.283.282.329.282zM5.283 9.3c.016 0 .026-.01.026-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .01.01.026.026.026zm5.803 0c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .01.01.026.026.026zm3.646 0c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .01.01.026.026.026zm2.757-.02c.062-.016.226-.057.365-.088.138-.03.241-.061.23-.066-.01-.01-.153-.031-.323-.047-.17-.015-.339-.01-.38.016-.04.025-.056.082-.036.133.02.057.062.072.144.052zm.478.02c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .01.01.026.026.026zm.251-.005c.057 0 .082-.01.067-.026-.015-.015-.062-.02-.098-.005-.04.016-.03.026.031.031zM5.386 9.248c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .01.01.026.025.026zm2.347-.005c.02 0 .04-.01.04-.026 0-.015-.06-.051-.133-.077-.077-.03-.123-.062-.107-.077.015-.015.123.02.24.082.119.062.232.092.247.077.021-.02-.015-.062-.066-.092a5.641 5.641 0 00-.308-.154c-.15-.067-.165-.083-.067-.062.077.015.144.02.144.005s-.108-.056-.247-.103c-.226-.071-.236-.071-.139 0 .057.047.067.072.026.052a33.597 33.597 0 00-.719-.236 13.272 13.272 0 00-1.15-.314 5.168 5.168 0 00-.744-.102c-.155 0-.216-.016-.17-.047.046-.025-.02-.036-.18-.025-.205.015-.22.01-.097-.026l.154-.041-.185-.005c-.103-.005-.2.015-.216.041-.015.026-.123.026-.246 0-.118-.026-.555-.03-.965-.02-.411.01-.863.035-1.002.056a1.285 1.285 0 00-.277.051c-.01.01.262.02.606.02.58 0 .631.011.657.098.02.077.062.093.19.077.087-.01.257-.03.37-.046.113-.015.308-.026.436-.03.216-.006.221-.01.077-.047-.082-.02.103-.026.411-.01.308.015.678.061.822.097.23.062.236.067.051.042-.113-.016-.318-.036-.462-.052-.22-.02-.206-.01.103.052.195.04.487.097.641.128.154.03.35.062.432.077.082.01.174.041.205.067.03.025.093.046.134.046.04 0 .297.087.564.19.267.103.534.195.596.205.057.01.149.041.205.072.047.031.113.062.129.057zm-.293-.206a.374.374 0 01-.133-.046 6.926 6.926 0 00-.627-.231 9.26 9.26 0 00-.893-.257c-.35-.072-.35-.072-.067-.046.154.015.503.098.77.18.267.082.606.21.745.277.138.062.23.118.205.123zm1.114.21c.021 0 .042-.03.042-.071 0-.041-.021-.087-.042-.098-.02-.015-.071-.005-.113.02-.066.042-.066.057 0 .098a.337.337 0 00.113.052zm.242 0c.067 0 .102-.035.102-.102 0-.067-.035-.103-.102-.103-.067 0-.103.036-.103.103s.036.103.103.103zm4.703 0c.01 0 .02-.025.02-.05 0-.031-.025-.052-.056-.052-.03 0-.04.02-.02.051.02.026.046.052.056.052zm3.194 0c.072 0 .123-.01.108-.02a1.022 1.022 0 00-.195-.077c-.15-.051-.164-.046-.108.02a.294.294 0 00.195.078zm3.066 0c.015 0 .025-.01.025-.025 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.015.026.026.026zm.303 0c.097 0 .138-.02.107-.045a.559.559 0 00-.19-.083c-.118-.03-.138-.02-.107.047.015.05.087.082.19.082zm-8.981-.05c.015 0 .025-.01.025-.026s-.01-.026-.025-.026c-.016 0-.026.01-.026.026 0 .015.016.025.026.025zm2.83 0c.01 0 .045-.052.081-.119.052-.102.052-.108-.015-.051-.041.036-.093.046-.113.026-.02-.02-.02.005 0 .051.015.051.036.092.046.092zm.574-.047c.046-.025.139-.097.206-.159.061-.062.138-.098.164-.082.026.015.097.005.164-.02.098-.042.082-.047-.087-.037a.967.967 0 00-.344.103.493.493 0 00-.164.164c-.021.062-.006.067.061.031zm3.856.046c.077 0 .077-.01.01-.05a.353.353 0 00-.117-.052c-.02 0-.026.02-.01.051.015.026.066.051.117.051zM5.33 9.146c.015 0 .025-.011.025-.027 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .01.015.026.026.026zm2.773 0c.015 0 .025-.011.025-.027 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .01.015.026.026.026zm11.502 0c.015 0 .025-.011.025-.027 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .01.015.026.026.026zm-6.039-.052c.026 0 .057-.031.072-.072.015-.041.015-.087-.005-.103a.148.148 0 00-.087-.03c-.031 0-.021.025.02.05.051.031.057.052.01.052-.036 0-.066.026-.066.051.01.026.03.052.056.052zm.185 0c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026s-.026.01-.026.026c0 .01.016.026.026.026zm5.766 0c.02 0-.102-.139-.267-.308-.164-.17-.375-.34-.457-.38-.087-.041-.174-.067-.195-.052-.02.016-.026.057-.01.098.015.04.092.077.185.077.118 0 .215.067.431.282.149.154.293.283.313.283zm-3.764-.385c.036-.196.103-.432.14-.519.035-.087.081-.16.102-.154.02.005.046-.01.061-.03.016-.021.016-.027-.005-.016-.02.015-.061-.016-.097-.062-.062-.082-.082-.072-.257.103-.108.108-.241.195-.303.195a.31.31 0 01-.175-.062c-.056-.051-.061-.04-.03.052.025.082.015.113-.031.102-.041-.01-.072.047-.087.16-.016.138 0 .169.061.143.046-.02.087.005.098.057.015.072.03.061.072-.041l.051-.129.062.113c.036.062.082.103.107.088.026-.016.052-.098.052-.175 0-.077.03-.17.067-.2.056-.046.066.02.05.339l-.015.395zm-.616-.18c-.015 0-.025-.01-.025-.026 0-.015.01-.025.025-.025.016 0 .026.01.026.025 0 .016-.01.026-.026.026zm.154-.051c-.015 0-.025-.01-.025-.026s.01-.026.025-.026c.016 0 .026.01.026.026 0 .015-.01.026-.026.026zm-.154-.052c-.015 0-.025-.01-.025-.025 0-.016.01-.026.025-.026.016 0 .026.01.026.026 0 .015-.01.025-.026.025zm.206-.103c-.016 0-.026-.01-.026-.025 0-.016.01-.026.026-.026.015 0 .025.01.025.026 0 .015-.01.025-.025.025zm1.258.694a.3.3 0 00.066-.124.24.24 0 00-.02-.169c-.03-.051-.046-.041-.046.041 0 .062-.026.128-.052.144-.03.015-.04.056-.02.082.015.03.046.041.072.026zm.18.025c.015 0 .025-.01.025-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.015.025.025.025zm.354 0a.41.41 0 00.185-.051c.046-.03.05-.051.015-.051a.477.477 0 01-.149-.036c-.062-.026-.077-.016-.051.025.02.031.02.062 0 .062s-.067-.041-.103-.092c-.062-.083-.067-.077-.036.025.02.077.067.118.139.118zM8.077 8.97c.041-.005.082-.03.092-.066.01-.031-.174-.129-.405-.216a34.629 34.629 0 00-.889-.313c-.256-.082-.75-.21-1.104-.288a7.477 7.477 0 00-1.324-.164c-.452-.02-.683-.01-.683.026 0 .03.149.051.374.051.216 0 .791.077 1.366.19.611.118 1.202.267 1.54.385.304.108.643.241.756.298.113.056.23.103.277.097zm.436.021c.036 0 .083-.046.093-.103.02-.077 0-.102-.067-.102-.051 0-.108.02-.128.051a.12.12 0 000 .103c.02.025.061.051.102.051zm.38-.005c.041 0 .057-.03.036-.082a.562.562 0 01-.03-.129c0-.025-.031-.046-.072-.046-.041 0-.098.031-.134.072-.046.057-.041.082.03.128.057.031.13.057.17.057zm.658-.082c.128-.088.133-.088.025-.134-.056-.025-.144-.036-.19-.015-.066.025-.072.051-.025.133.051.098.061.098.19.016zm.98.087c.01 0-.02-.056-.066-.123a.4.4 0 00-.18-.15c-.057-.015-.103-.01-.098.006 0 .02.02.067.052.113.03.046.051.056.051.036 0-.02.051-.005.113.041a.76.76 0 00.128.077zm.601 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .016.01.026.026.026zm5.304-.005c.01 0 0-.02-.015-.051-.015-.031.005-.052.046-.052.046 0 .082-.04.082-.097 0-.062-.066-.134-.164-.18a1.154 1.154 0 00-.18-.082c-.01 0-.015.056-.015.128 0 .072.026.128.056.128.031 0 .041.021.026.047-.015.025.01.072.062.102.046.031.092.057.102.057zm-.092-.098c-.026 0-.036-.036-.02-.077.015-.04.04-.077.05-.077.011 0 .021.036.021.077s-.02.077-.051.077zm-7.168.052c.036 0 .067-.041.061-.093a.23.23 0 00-.051-.123c-.026-.02-.077-.02-.113-.01-.051.02-.056.051-.015.123.025.056.082.103.118.103zm4.857 0c.026 0 .036-.036.02-.077-.015-.041-.04-.077-.05-.077-.01 0-.021.036-.021.077 0 .04.02.077.051.077zm.509 0c.025 0 .077-.041.113-.088.061-.077.061-.082-.047-.025-.061.036-.113.072-.113.087s.021.026.047.026zm-3.564-.052c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.025.026.025zm2.737 0c.03 0 .067-.025.087-.051.016-.03-.005-.087-.046-.128-.046-.047-.087-.057-.108-.026-.015.03-.01.051.02.051.032 0 .042.036.021.077-.015.041-.005.077.026.077zm1.607 0c.026 0 .046-.01.046-.02s-.036-.036-.082-.052c-.046-.015-.067-.01-.046.021.015.026.051.051.082.051zm-7.004-.056c.005 0-.005-.036-.02-.082-.016-.047-.17-.175-.34-.283-.169-.108-.328-.2-.354-.2-.025 0-.256-.092-.518-.2a11.843 11.843 0 00-1.166-.39c-.38-.103-.95-.242-1.258-.303-.385-.077-.524-.124-.436-.144.072-.016-.005-.026-.165-.02-.159.004-.282-.006-.272-.026.01-.021-.102-.031-.246-.026-.15.005-.4-.026-.565-.067-.262-.067-.323-.061-.54.01l-.24.083.215.005c.118 0 .231-.02.247-.047.015-.03.077-.05.133-.05.057 0 .098.02.098.04 0 .026.061.072.133.113a.55.55 0 01.18.154c.03.052.02.118-.02.175-.037.046-.144.097-.242.108-.097.01-.282.046-.41.082a1.286 1.286 0 00-.278.102c-.026.026.087.031.257.01.17-.02.765-.035 1.33-.035.837 0 1.134.02 1.617.113.324.061.786.164 1.027.236.241.067.668.21.95.313.282.108.596.221.693.262.098.03.185.067.19.067zm1.53.005c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm3.708-.02c.02-.021.02-.052 0-.067-.02-.02-.036-.005-.036.036 0 .036.015.051.036.03zm3.61.02c.035 0 .05-.015.035-.036-.02-.02-.05-.02-.066 0-.02.02-.005.036.03.036zm.143 0c.031 0 .072-.026.088-.057.02-.03.02-.066.01-.077-.016-.015-.051.01-.087.057-.041.046-.041.077-.01.077zm2.373-.02c.113.005.19-.016.174-.042a.105.105 0 00-.082-.046c-.03 0-.087-.03-.123-.072-.041-.04-.072-.102-.072-.138 0-.047-.015-.052-.057-.01-.03.03-.087.046-.128.03-.041-.015-.072.005-.072.062 0 .051.036.118.077.149.041.03.175.061.283.066zm.36-.031c.035 0 .05-.016.035-.036-.02-.02-.051-.02-.067 0-.02.02-.005.03.031.036zm-11.4-.052c.025 0 .066-.036.092-.082.031-.056.057-.067.082-.026.02.031.077.057.134.057.056 0 .128-.067.17-.149.04-.082.06-.164.045-.18a.129.129 0 00-.071-.03c-.026 0-.031.02-.016.05.016.032.005.052-.025.052-.031 0-.052.041-.042.093.01.051-.01.087-.036.082-.025-.005-.112-.026-.184-.041-.108-.026-.139-.01-.16.072-.02.05-.01.097.01.102zm.98-.005c.021 0 .047-.046.062-.103.02-.077 0-.102-.067-.102-.051 0-.113.025-.128.056-.02.031-.005.077.036.103a.303.303 0 00.097.046zm2.296-.061c.01-.052-.02-.15-.062-.221-.046-.072-.128-.129-.185-.129-.056 0-.102.026-.102.052 0 .03.061.077.133.102.072.026.149.103.164.165.026.102.036.108.052.03zm5.17.061c.016 0 .026-.01.026-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.031.026.026zm2.825 0c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.031.026.026zM9.32 8.683c.077 0 .097-.026.077-.103-.021-.082 0-.102.097-.102.067 0 .123-.021.123-.047 0-.025-.036-.061-.077-.077-.04-.015-.123.016-.18.072-.056.057-.123.103-.153.103-.031 0-.036.036-.021.077.015.041.077.072.134.077zm.62-.015c.109 0 .206-.021.222-.047.015-.025-.01-.03-.052-.01-.051.02-.082 0-.082-.046 0-.041-.036-.093-.082-.108-.062-.026-.072-.005-.051.067.02.066.005.102-.062.123-.046.01 0 .02.108.02zm4.422.01c.015 0 .041-.02.056-.052.016-.03.021-.05.006-.05-.016 0-.042.02-.057.05-.015.031-.02.052-.005.052zm.303-.072a.573.573 0 00.18-.205c.03-.072.046-.16.03-.196-.015-.036.01-.102.062-.143.046-.041.098-.067.103-.062.01.005.036.01.061.01.026 0 .098-.051.16-.113.092-.087.138-.097.205-.056.067.04.087.036.092-.041.005-.052-.02-.103-.056-.118-.036-.016-.144.01-.241.056a.725.725 0 01-.226.067 4.223 4.223 0 00-.298-.03c-.134-.011-.247-.011-.247 0 0 .01.062.05.139.091l.139.072-.113.062c-.062.03-.103.082-.083.108.021.025-.03.061-.102.082-.088.02-.118.051-.082.082.025.026.097.036.159.016.061-.021.097-.057.077-.083-.016-.025 0-.046.036-.046.046 0 .046-.015-.01-.051-.067-.046-.067-.052 0-.052a.471.471 0 00.205-.102.646.646 0 01.16-.103c.014 0 .03.03.03.077 0 .041-.01.067-.026.051-.015-.015-.067.01-.118.062-.051.046-.092.113-.092.149 0 .036-.057.149-.129.252-.072.102-.128.2-.128.215-.005.016.046-.01.113-.051zm2.629.02c.041-.036.067-.077.056-.087-.015-.01-.046-.01-.077.01-.03.021-.056.057-.056.088 0 .036.03.03.077-.01zm2.475.036c.02-.02.02-.051 0-.066-.02-.02-.036-.005-.036.036 0 .036.015.05.036.03zm-11.42-.036c.026 0 .026-.025.01-.05a.904.904 0 00-.236-.155c-.113-.056-.2-.092-.2-.077s.087.082.19.154c.108.072.21.128.236.128zm9.458-.015c.031-.01.041-.072.036-.139a.494.494 0 00-.056-.174.682.682 0 01-.072-.195.747.747 0 00-.2-.293c-.093-.082-.175-.139-.185-.128-.01.01.026.082.082.164.056.077.139.231.19.339.051.108.082.22.072.257-.01.03.005.087.036.123.03.036.067.051.097.046zm.92.015c.056 0 .082-.01.066-.025-.015-.016-.061-.02-.097-.005-.041.015-.031.025.03.03zm1.288 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm-11.553-.05c.015 0 .026-.011.026-.027 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .016.01.026.026.026zm1.35-.073c.01-.051-.015-.113-.05-.133-.042-.026-.078-.02-.088.01-.01.03.015.087.051.133.067.072.072.072.087-.01zm1.259.072a.165.165 0 00.102-.036c.02-.02.01-.067-.02-.103-.031-.035-.077-.056-.103-.04-.026.015-.046.061-.046.102 0 .046.03.077.067.077zm2.68 0c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025s-.026.01-.026.025c0 .016.01.026.026.026zm2.31 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm3.158 0c.036 0 .052-.015.036-.036-.02-.02-.05-.02-.066 0-.026.02-.005.036.03.036zM8.452 8.462a.124.124 0 00.072-.072c.01-.03-.175-.138-.406-.246a12.831 12.831 0 00-.94-.37 21.659 21.659 0 00-1.18-.35c-.37-.097-.807-.2-.976-.23-.17-.031-.35-.072-.4-.087-.052-.016-.093-.006-.093.025 0 .026.077.067.164.082.092.02.555.124 1.022.237.472.113 1.006.256 1.196.328.185.072.488.185.673.257.185.072.426.175.534.231a.938.938 0 01.236.16c.026.03.067.045.098.035zm.19.01c.03 0 .056-.025.056-.051 0-.03-.01-.051-.02-.051s-.036.02-.057.051c-.02.03-.01.051.02.051zm7.635-.015c.02-.02.02-.051 0-.067-.02-.02-.036-.005-.036.036 0 .036.016.052.036.031zm1.633.02c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.02.026.026zm3.446 0c.01 0 .02-.01.02-.02s-.026-.041-.062-.062c-.035-.02-.046-.015-.02.02.02.032.046.057.062.063zm-12.514-.05c.026 0 .072-.037.108-.078.036-.04.051-.092.036-.108-.016-.015-.067-.015-.108 0a.13.13 0 00-.077.108c-.005.041.015.077.041.077zm5.304-.011c.02.005.052-.015.067-.046.02-.031-.051-.052-.19-.047-.205.006-.21.01-.067.047.088.025.17.046.19.046zm.35.01c.035 0 .05-.015.035-.036-.02-.02-.051-.02-.066 0-.02.02-.005.036.03.036zM.656 8.34c.082-.016.19-.051.231-.072.067-.036.067-.041 0-.041a.866.866 0 00-.23.072l-.155.072zm3.748.036c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026s.01.026.025.026zm4.981-.072c.093-.041.108-.077.067-.123-.03-.036-.082-.067-.113-.062a.32.32 0 00-.133.046c-.057.036-.062.062-.01.124.05.056.092.061.19.015zm7-.062c.01-.077-.011-.164-.037-.19-.03-.03-.067-.04-.087-.02-.016.015 0 .102.036.19l.072.159zm1.575.134c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .01.01.026.025.026zm3.03 0c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .01.01.026.026.026zM4.097 8.323c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .01.01.025.025.025zm3.749 0c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026s-.026.01-.026.026c0 .01.01.025.026.025zm.79-.035c.01-.01.01-.031 0-.042a6.076 6.076 0 00-.313-.2c-.159-.097-.277-.195-.256-.215.02-.021.01-.026-.02-.006-.032.02-.155-.02-.273-.087-.118-.067-.195-.139-.175-.164.02-.026.01-.026-.02-.01-.031.02-.098.02-.139.005-.04-.016-.067-.057-.046-.088.02-.03.01-.04-.026-.015-.03.02-.123 0-.2-.041-.077-.041-.118-.077-.092-.082.025 0-.02-.046-.108-.098a1.669 1.669 0 00-.278-.133c-.087-.026-.107-.02-.077.025.026.041.016.057-.03.036-.041-.015-.067-.051-.057-.087.01-.036-.01-.046-.04-.03-.032.02-.273-.052-.54-.155a8.953 8.953 0 01-.678-.287.83.83 0 00-.282-.098c-.052 0-.21-.03-.36-.072A2.638 2.638 0 014.2 6.29a1.021 1.021 0 00-.41-.082c-.17 0-.232.015-.18.046.04.026.17.062.282.077.113.02.298.087.41.15.13.071.211.158.222.23.015.093-.02.129-.144.175-.087.03-.16.072-.16.092 0 .02.15.046.334.062.185.015.673.113 1.089.215.416.103 1.068.288 1.453.416.38.129.878.324 1.104.427.226.102.426.2.437.19zm-1.663-.945a.527.527 0 01-.18-.072c-.072-.041-.108-.072-.077-.072a.57.57 0 01.18.072c.072.04.103.072.077.072zm4.54.945c.01-.01 0-.042-.032-.072-.03-.031-.097-.036-.149-.016-.087.036-.087.041.031.072.072.02.139.026.15.016zm5.119.035c.01 0 .02-.056.02-.123s-.03-.133-.072-.149c-.061-.025-.061 0-.02.124.025.077.061.148.072.148zm4.724 0c.04 0 .071-.046.071-.102 0-.057-.03-.103-.071-.103-.042 0-.088.02-.108.051a.12.12 0 000 .103c.015.026.066.051.108.051zm-2.547-.05c.025 0 .03-.047.015-.109-.02-.077-.041-.087-.067-.04-.02.035-.03.081-.015.107.01.02.041.041.067.041zm1.432-.016a.326.326 0 00.139-.052c.02-.02-.015-.036-.072-.036-.062 0-.123.026-.139.052-.02.025.01.04.072.036zm.334.015c.01 0 .036-.036.051-.082.016-.046.01-.067-.02-.046-.026.015-.051.051-.051.082 0 .02.01.046.02.046zm.57 0c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .01.01.026.026.026zm-20.03-.056c.056 0 .081-.01.066-.026-.016-.015-.062-.02-.098-.005-.04.015-.03.026.031.03zm6.5-.005c.04 0-.005-.036-.103-.088a6.322 6.322 0 00-.375-.159c-.108-.041-.205-.056-.22-.046-.01.01.123.082.297.154.18.077.36.139.4.139zm1.427.01c.02 0 .067-.026.098-.062.036-.036.061-.082.061-.103 0-.02-.046-.04-.097-.04-.057 0-.113.02-.134.05a.12.12 0 000 .103c.02.026.052.052.072.052zm2.583 0c.03 0 .036-.026.02-.052a.105.105 0 00-.082-.05c-.03 0-.035.02-.02.05.015.026.056.052.082.052zm5.72 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026s.01.026.025.026zm.616 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026s.01.026.025.026zm-16.59-.057c.056 0 .082-.01.067-.025-.016-.016-.062-.02-.098-.005-.041.015-.03.025.03.03zm7.373.005c.026 0 .047-.01.047-.02s-.036-.036-.083-.051c-.046-.016-.066-.01-.046.02.02.026.057.051.082.051zm1.792-.005c.016 0-.05-.072-.148-.154a14.146 14.146 0 00-1.582-1.037c-.205-.113-.385-.19-.4-.175-.016.016.025.057.092.093s.39.241.724.457c.329.216.59.375.575.349-.015-.026-.015-.046.005-.046.016 0 .185.113.37.257.18.143.349.261.364.256zm-.79-.508c-.016 0-.026-.01-.026-.026 0-.015.01-.025.026-.025.015 0 .025.01.025.025 0 .016-.01.026-.025.026zm1.412.513c.025 0 .051-.01.051-.02s-.026-.036-.051-.057c-.031-.015-.052-.005-.052.021 0 .026.021.056.052.056zm9.74 0c.006 0 .016-.02.016-.05 0-.032-.041-.052-.092-.052-.077 0-.077.01-.01.051.04.026.081.051.087.051zm.247 0c.015 0 .01-.138-.005-.308-.03-.251-.02-.328.051-.405.046-.052.067-.108.041-.124-.025-.015-.102-.01-.17.01-.097.032-.127.073-.133.216-.005.098.021.196.052.216.046.03.046.041 0 .041s-.046.03 0 .123c.04.083.072.103.097.062.026-.036.041-.015.041.056 0 .062.01.113.026.113zm-.103-.667c-.015 0-.025-.01-.025-.026 0-.015.01-.025.025-.025.016 0 .026.01.026.025 0 .016-.01.026-.026.026zm-19.41.616c.016 0 .026-.01.026-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm18.48 0c.011 0 .052-.041.088-.092.062-.082.062-.082-.02-.02-.052.04-.093.076-.093.092.005.01.016.02.026.02zm-17.94-.051c.036 0 .051-.016.036-.036-.02-.02-.052-.02-.067 0-.02.02-.005.036.03.036zm6.403-.005c.005 0 .01-.006.01-.016a.664.664 0 00-.174-.128 1.124 1.124 0 00-.21-.108c-.021 0 .015.041.081.098.067.05.16.107.2.123.047.015.088.03.093.03zm.298 0l.01-.093c.005-.077-.123-.159-.616-.38a72.947 72.947 0 00-1.114-.488 10.829 10.829 0 00-.848-.313l-.683-.215a16.162 16.162 0 00-.713-.206 3.754 3.754 0 00-.473-.103c-.04 0-.066.016-.046.031.015.016.175.062.354.103.18.041.478.123.663.18.185.056.493.164.683.236.246.092.328.149.282.18-.046.03-.036.036.03.015a.642.642 0 01.283.026c.103.03.36.123.57.21.21.082.663.298 1.002.478.339.185.616.339.616.339zm2.51.005c.037 0 .083-.016.098-.031.016-.02-.015-.098-.072-.18-.056-.082-.149-.149-.205-.149-.056 0-.098.016-.098.036 0 .02.021.072.047.108.03.051.056.051.077.015.02-.03.061-.056.092-.056.036 0 .03.026-.005.077-.036.041-.046.098-.03.128a.131.131 0 00.097.052zm2.727 0c.01 0 .031-.02.047-.041.015-.026-.006-.041-.047-.041-.04 0-.061.02-.046.04.016.021.036.042.046.042zm4.801 0c.031 0 .052-.01.052-.02 0-.011-.02-.037-.052-.057-.025-.016-.051-.005-.051.02 0 .026.02.057.051.057zm2.475 0h.118l-.118-.082c-.066-.047-.133-.067-.149-.052-.015.016 0 .031.031.031s.052.02.031.051c-.02.031.02.052.087.052zM1.874 8.015c.046 0 .103-.02.118-.051.016-.03.016-.051-.01-.051a.27.27 0 00-.118.051c-.067.041-.062.051.01.051zm.842-.005c.252 0 .503-.025.56-.046.061-.026-.118-.03-.437-.015-.297.015-.549.036-.56.046-.01.01.186.015.437.015zm11.245.005c.01 0 .021-.025.021-.051 0-.03-.026-.051-.057-.051-.03 0-.04.02-.02.051.02.026.041.051.056.051zm.303 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm3.697 0c.016 0 .067-.082.108-.18.041-.097.098-.179.129-.179.03 0 .04.02.03.041-.015.02-.005.072.021.113.036.062.051.056.077-.015.02-.052.062-.088.098-.088.036 0 .077-.046.092-.102.015-.057.01-.103-.015-.103-.02 0-.072.036-.108.077-.036.041-.098.067-.134.051-.036-.015-.149.02-.246.082-.098.057-.18.129-.18.154 0 .026.036.047.082.047.046 0 .067.02.046.051-.02.026-.02.051 0 .051zm2.44 0c.035 0 .05-.015.035-.036-.02-.02-.05-.02-.066 0-.02.021-.005.036.03.036zm.539 0c.015 0 .025-.01.025-.025 0-.016-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.025.026.025zm.796-.02c.128-.01.272-.036.318-.057a.477.477 0 00.164-.159.451.451 0 00.082-.185c0-.036-.061.01-.143.108a.768.768 0 01-.4.242l-.258.071zM2.095 7.964c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025s-.026.01-.026.025c0 .016.01.026.026.026zm1.489 0c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.026.01-.026.025 0 .016.01.026.026.026zm7.445 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm2.778 0c.01 0 .02-.026.02-.051 0-.031-.025-.052-.056-.052-.03 0-.04.02-.02.052.02.025.041.051.056.051zm2.46-.02c.118.005.128-.01.123-.18-.005-.103-.015-.15-.03-.098-.016.052-.042.088-.062.088-.02 0-.062-.026-.093-.057-.04-.041-.066-.036-.097.01-.02.036-.016.072.015.088.031.01.046.046.036.082-.01.036.03.061.108.067zm.344-.01c.026-.016.02-.073-.01-.13-.031-.056-.077-.097-.103-.097-.026 0-.051.031-.051.067 0 .036.025.092.061.128.031.031.077.047.103.031zm-6.018-.026c.015 0-.057-.072-.154-.165a24.187 24.187 0 00-.54-.477c-.2-.17-.585-.457-.857-.637s-.488-.334-.477-.344c.01-.01.102.03.205.092s.185.098.185.088c0-.016-.092-.082-.2-.16-.129-.087-.21-.112-.221-.071-.01.036-.231-.067-.555-.257-.292-.175-.544-.308-.56-.293-.015.016-.015.031 0 .041.01.01.309.195.658.411.35.216.667.39.703.39.036 0 .088.031.113.072.02.041.283.247.58.457.298.21.668.488.822.616.15.129.288.237.298.237zm.133.005c.01 0 .021-.01.021-.02 0-.011-.026-.042-.062-.062-.036-.021-.046-.016-.02.02.02.036.046.062.061.062zm3.461 0a.055.055 0 00.052-.052.051.051 0 00-.052-.051c-.03 0-.051.02-.051.051 0 .026.026.052.051.052zm.154 0c.036 0 .052-.016.036-.036-.02-.02-.051-.02-.066 0-.021.02-.006.036.03.036zm4.432-.02c.108-.011.185-.057.226-.134.04-.077.066-.093.082-.047.015.036.04.052.061.031.021-.02-.025-.092-.102-.164-.077-.072-.16-.134-.185-.134-.026 0-.026.036-.01.083.025.071.015.071-.077.025-.062-.03-.113-.082-.113-.108 0-.025.036-.05.077-.05.04 0 .077-.021.077-.052 0-.031-.036-.052-.077-.052s-.093.062-.108.139a.347.347 0 00.03.241c.047.077.052.113.006.124-.031.01-.057.04-.057.066 0 .031.077.041.17.031zm1.597.02c.015 0 .04-.02.056-.052.016-.03.02-.051.005-.051s-.04.02-.056.051c-.016.031-.02.052-.005.052zm.313 0c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026s-.026.01-.026.026c0 .015.01.026.026.026zM6.716 7.86c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.025.026.025zm6.907 0c.035 0 .05-.015.035-.036-.02-.02-.05-.02-.066 0-.02.02-.005.036.03.036zm2.095 0c.025 0 .061-.046.077-.107.015-.067.005-.098-.031-.088-.031.01-.067.057-.077.108-.01.046.005.087.03.087zm-6.48-.051c.01 0 .02-.01.02-.02s-.026-.042-.062-.062c-.036-.02-.046-.016-.02.02.02.036.046.062.061.062zm1.54 0a.518.518 0 00-.02-.128c-.016-.072-.052-.124-.083-.113-.03.01-.21-.082-.39-.21-.185-.13-.313-.206-.283-.175.026.03.211.184.411.344.195.154.36.282.365.282zm.149 0c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm3.075 0c.01 0 .036-.02.057-.051.015-.031.005-.052-.02-.052-.031 0-.057.02-.057.052 0 .03.01.051.02.051zm4.524 0c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm-4.636-.051c.02 0 .035-.02.035-.047 0-.025-.025-.061-.05-.082a.115.115 0 00-.109.005c-.04.026-.036.047.01.077a.342.342 0 00.114.047zm-7.667-.057c.041 0 .062-.005.052-.015a3.71 3.71 0 00-.427-.134c-.22-.061-.41-.102-.426-.087-.015.01.144.072.35.128.21.057.41.108.451.108zm2.88 0c.016 0-.03-.04-.102-.097s-.108-.103-.087-.103c.02 0 .087.02.139.051.056.031.097.046.097.031s-.185-.133-.406-.267c-.226-.133-.405-.267-.4-.293.005-.025-.139-.133-.313-.246a6.528 6.528 0 00-.709-.36c-.21-.087-.416-.174-.452-.184-.051-.02-.04.03.031.17a.85.85 0 01.098.287c0 .066.092.118.349.195.19.056.657.267 1.037.462.38.195.703.354.719.354zm-.235-.2c-.026 0-.195-.082-.38-.18a14.926 14.926 0 00-.575-.287c-.14-.062-.231-.134-.21-.165.02-.036 0-.04-.068-.015-.072.026-.082.02-.04-.02.04-.042.215.03.667.282.334.19.621.349.631.364.01.01 0 .02-.025.02zm-.56-.467a.61.61 0 01-.205-.103c-.088-.057-.134-.098-.103-.098.026 0 .118.047.205.103.082.057.129.098.103.098zm-.837-.206c-.02 0-.082-.025-.139-.046-.056-.026-.087-.046-.066-.046.02 0 .071-.02.123-.036.067-.026.077-.016.046.036-.03.051-.02.061.046.036.052-.02.077-.016.057.015-.02.02-.046.046-.067.041zm.35-.046c-.027 0-.062-.02-.083-.051-.02-.031 0-.036.046-.02.041.015.082.04.082.05.006.01-.015.021-.046.021zm-.54-.103c-.015 0-.026-.01-.026-.025 0-.016.01-.026.026-.026.015 0 .026.01.026.026 0 .015-.016.025-.026.025zm.36-.005c-.031 0-.17-.056-.309-.123-.143-.067-.22-.123-.18-.123.042 0 .18.056.309.123.128.067.205.123.18.123zm-.463-.046c-.015 0-.025-.01-.025-.026 0-.015.01-.025.025-.025.016 0 .026.01.026.025 0 .016-.015.026-.026.026zm-.154-.205c-.015 0-.025-.01-.025-.026 0-.015.01-.026.025-.026.016 0 .026.01.026.026 0 .015-.015.026-.026.026zm2.414 1.283c.01 0 .02-.01.02-.02s-.026-.041-.061-.062c-.036-.02-.047-.015-.021.02.026.037.051.062.062.062zm7.702 0c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026s-.026.01-.026.026c0 .015.01.025.026.025zm-2.26-.051c.016 0 .026-.01.026-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm.319-.01a.164.164 0 00.108-.082c.01-.036-.02-.062-.088-.062-.061 0-.107.03-.107.082 0 .046.036.072.087.062zm5.597-.057a.248.248 0 00.056-.19c-.015-.092-.03-.077-.077.077-.046.165-.046.18.02.113zM3.07 7.605c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.026.025.026zm6.214 0c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.026.026.026zm1.833 0c.02 0 .04-.01.04-.02 0-.011-.086-.083-.194-.165l-.19-.144.149.164c.082.093.169.165.195.165zm2.223 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.026.026.026zm.334 0c.026 0 .051-.02.051-.041a.449.449 0 00-.082-.155c-.046-.061-.103-.102-.128-.087a.104.104 0 00-.047.077c0 .026.036.046.077.046.042 0 .072.016.072.042a.196.196 0 000 .077c0 .025.026.04.057.04zm2.531-.031c.052-.02.077-.046.062-.062-.015-.015-.057 0-.092.036-.052.051-.042.057.03.026zm.324-.026c.04-.036.067-.072.056-.082-.01-.01-.056-.005-.102.01-.047.016-.072.057-.057.082.016.031.057.026.103-.01zm-9.043.005c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm7.549 0c.01 0 .02-.02.02-.051 0-.03-.026-.051-.056-.051-.031 0-.041.02-.02.05.02.027.045.052.056.052zm6.485-.025c.015-.016 0-.052-.036-.088s-.062-.04-.062-.01.016.067.036.087c.02.02.052.026.062.01zm-8.308-.026c.03 0 .051-.02.051-.046s-.02-.062-.051-.082c-.026-.016-.052.005-.052.046 0 .046.02.082.052.082zm2.172 0a.26.26 0 00.128-.046c.051-.031.041-.052-.046-.072-.062-.016-.134-.02-.16-.005-.025.015-.03.046-.015.077.016.03.062.046.093.046zm6.752 0c.062 0 .16-.046.216-.103.056-.056.102-.128.102-.154 0-.03-.015-.051-.04-.051-.021 0-.119.072-.216.154-.16.139-.165.154-.062.154zM7.178 7.399c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm11.744-.005c.036 0 .128-.077.195-.164l.128-.165-.18.113a.708.708 0 00-.195.165c-.01.03.01.056.052.051zM4.76 7.343c.056 0 .082-.01.067-.026-.016-.015-.062-.02-.098-.005-.041.015-.026.03.03.03zm-.252-.057c.082 0 .123-.01.093-.025a.261.261 0 00-.154 0c-.052.01-.021.025.061.025zm6.213.01c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.015.026.025.026zm4.96 0c.057 0 .093-.025.072-.05-.015-.032-.066-.052-.107-.052-.041 0-.072.02-.072.051 0 .026.051.052.108.052zm5.207-.05c.016 0 .026-.011.026-.027 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.015.026.025.026zm.426 0c.01 0 0-.021-.015-.052-.015-.031-.062-.052-.092-.052-.036 0-.031.021.015.052.046.025.087.051.092.051zm-10.788-.057c.005 0 .026-.02.041-.047.016-.025-.195-.205-.472-.4-.277-.195-.6-.41-.719-.488-.123-.077-.22-.133-.22-.123 0 .01.19.16.42.334.231.174.54.405.683.518.144.113.262.206.267.206zm3.759.005c.026 0 .062-.036.077-.082.015-.047.026-.093.015-.103a.897.897 0 00-.19-.051c-.123-.026-.159-.016-.133.025.02.031.072.062.113.062.04 0 .072.036.072.077 0 .036.02.072.046.072zm1.16-.005c.057 0 .083-.01.067-.026-.015-.015-.061-.02-.097-.005-.042.015-.031.026.03.03zm.57.005c.062 0 .062-.02-.015-.129-.051-.071-.128-.128-.17-.128-.056 0-.05.02.021.077.057.041.082.077.062.077-.02 0-.026.02-.005.051.02.026.066.052.107.052zM4.303 7.127c.113 0 .164-.01.118-.02a.462.462 0 00-.205 0c-.067.01-.026.02.087.02zm12.077.015c.067 0 .067-.015.015-.077-.036-.04-.082-.061-.108-.046-.025.016-.03.052-.015.077.015.026.067.046.108.046zm4.662 0c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.015.025.025.025zM3.661 7.076c.154 0 .22-.01.139-.02a1.298 1.298 0 00-.283 0c-.072.01-.01.02.144.02zm5.628.015c.01 0 .02-.01.02-.02s-.025-.041-.061-.062c-.036-.02-.047-.015-.02.02.02.036.045.062.06.062zm3.41-.026c.03-.02.05-.092.05-.169 0-.072-.01-.123-.02-.113a.608.608 0 00-.051.164c-.02.103-.016.139.02.118zm2.746.026c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm.2-.005c.057 0 .083-.01.067-.026-.015-.015-.061-.02-.097-.005-.041.016-.026.026.03.031zm2.47-.046c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026s.01.026.025.026zm2.979 0c.04 0 .077-.02.077-.046s.015-.088.036-.14c.025-.06.015-.076-.026-.05a.467.467 0 00-.113.138c-.041.077-.036.098.026.098zm-11.96-.052c.01 0 .021-.01.021-.02s-.025-.041-.061-.062c-.036-.02-.047-.015-.02.02.02.037.045.062.06.062zm6.414 0c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.016.025.026.025zm.128 0c.036 0 .052-.015.036-.036-.02-.02-.051-.02-.066 0-.02.021-.005.036.03.036zm.96 0c.006 0 .026-.025.047-.061.02-.036.02-.046-.005-.026-.02.02-.072 0-.113-.051-.057-.067-.067-.072-.057-.01.01.04.036.092.067.112.03.016.057.031.062.036zm-7.044-.05c.015 0 .025-.011.025-.027 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.015.026.026.026zm4.318 0c.01 0 .005-.037-.01-.078-.016-.041-.052-.077-.082-.077-.031 0-.026.03.01.077.036.041.072.077.082.077zm4.16 0c.01 0 .004-.037-.011-.078s-.051-.077-.082-.077c-.031 0-.026.03.01.077.036.041.072.077.082.077zM9 6.88c.016 0-.04-.057-.128-.129a3.896 3.896 0 00-.334-.236c-.098-.056-.154-.077-.123-.046.03.03.17.138.308.23.139.098.262.18.277.18zm5.366.005c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.026.026.026zm-6.033-.108c.015 0-.02-.036-.077-.082a3.7 3.7 0 00-.478-.257c-.205-.098-.37-.19-.37-.2 0-.016.052-.01.113.005.088.026.077.01-.036-.062a7.334 7.334 0 00-.446-.241c-.165-.082-.329-.185-.37-.231a.41.41 0 01-.087-.21.354.354 0 01.02-.19c.026-.042.005-.052-.061-.037-.052.016-.113 0-.134-.03-.02-.031-.056-.057-.087-.057-.031 0-.005.062.056.134a.55.55 0 01.108.277.266.266 0 01-.103.216c-.092.066-.087.071.103.077.113.005.36.066.55.138.19.072.359.144.374.16.016.015-.04.015-.123 0-.082-.021.113.102.437.272.318.18.595.313.61.318zm9.104-.046c.02 0 .02-.031 0-.062a4.479 4.479 0 01-.16-.426c-.082-.252-.107-.303-.092-.164.015.113.005.18-.026.164-.025-.016-.046-.016-.046.005 0 .02.062.139.139.262.082.118.164.22.185.22zm.344 0c.025 0 .051-.036.051-.082 0-.047-.026-.067-.051-.047a.098.098 0 00-.052.082c0 .021.026.047.052.047zM9.237 6.68c.01 0 .02-.01.02-.02s-.025-.041-.06-.062c-.037-.02-.047-.015-.021.02.02.037.046.062.061.062zm4.72 0c.015 0 .025-.01.025-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .01.01.025.025.025zm4.081 0c.026 0 .052-.01.052-.02s-.026-.036-.052-.057c-.03-.015-.05-.005-.05.02 0 .027.025.057.05.057zM9.386 6.63c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm4.73-.015c.015-.016.02-.062.005-.098-.016-.041-.031-.03-.031.03-.005.057.01.083.025.068zm-2.065-.036c.016 0 .041-.026.057-.052.015-.03.02-.051.005-.051-.016 0-.041.02-.057.051-.015.026-.02.052-.005.052zm1.34 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.026.025.026zm4.524 0c.01 0 .02-.036.02-.077s-.02-.077-.05-.077c-.026 0-.037.036-.021.077.02.04.041.077.051.077zM12.39 6.5c.129-.01.241-.02.257-.02.015-.006-.016-.032-.062-.057-.061-.036-.138-.031-.256.02l-.17.072zm.129-.026c-.016 0-.026-.01-.026-.026 0-.015.01-.025.026-.025.015 0 .025.01.025.025 0 .016-.01.026-.025.026zm4.554-.185c.02-.139.026-.257.016-.267-.01-.01-.072.03-.134.087-.092.088-.103.118-.046.185.036.041.046.077.025.077-.02 0-.005.036.031.088.067.071.077.05.108-.17zm.683.236c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.025.026.025zm-9.448-.102c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.026.026.026zm6.208-.016c.056-.005.108-.036.118-.072.01-.036-.02-.051-.082-.036a.348.348 0 01-.22-.036l-.124-.061.103.108c.061.061.154.102.205.097zm1.87-.01c.122-.01.235-.036.256-.057.02-.02.01-.025-.026-.005-.03.02-.067.016-.077-.01-.01-.026-.128-.036-.267-.02-.16.02-.226.046-.18.071.041.02.17.031.293.02zm-8.592-.026c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm.416 0c.01 0 .02-.01.02-.02a.352.352 0 00-.091-.093c-.083-.061-.083-.061-.021.02a.352.352 0 00.092.093zm10.044-.061a.372.372 0 00.118-.088c.016-.025-.04-.02-.123.01-.108.042-.236.042-.452 0-.164-.03-.323-.04-.349-.025-.03.015.123.056.334.087.21.031.426.036.472.016zm-10.562.01c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm4.508 0c.01 0 .108-.036.216-.082.174-.072.2-.072.287.01.088.082.098.082.098.005 0-.046.03-.087.062-.087.036 0 .005-.026-.062-.051-.092-.036-.185-.031-.344.03-.118.047-.231.103-.247.134-.02.02-.02.04-.01.04zm-3.199-.087c.016-.01-.01-.041-.051-.067-.041-.026-.098-.031-.123-.016-.026.016-.006.047.05.067.052.02.109.026.124.016zm-2.028-.016c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.025.026.025zm1.027 0c.015 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026s-.026.01-.026.026c0 .015.01.025.026.025zm5.705-.015c.015-.016.02-.062.005-.098-.016-.04-.031-.03-.031.031-.005.057.01.087.026.067zm.4.01c.057 0 .082-.01.067-.026-.015-.015-.062-.02-.098-.005-.04.016-.03.031.031.031zM6.82 6.167c.015 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025s-.026.01-.026.025c0 .016.01.026.026.026zm1.607 0c.005 0 .01-.02.01-.046s-.087-.088-.195-.134a9.265 9.265 0 01-.724-.431 8.167 8.167 0 01-.693-.478c-.154-.133-.154-.138-.03-.108a.543.543 0 01.205.093c.04.036.107.077.143.097.036.021.062.016.062-.015 0-.026-.128-.123-.282-.21a1.636 1.636 0 01-.283-.185c0-.01.051 0 .113.03.108.052.113.052.02-.02-.05-.041-.117-.067-.138-.051-.026.015-.113-.01-.2-.057-.088-.046-.154-.092-.154-.108 0-.015.051 0 .113.031.061.03.092.036.061.005a4.964 4.964 0 00-.554-.318c-.278-.15-.514-.257-.524-.247-.01.01.082.108.21.216.129.108.268.262.309.344.046.082.066.195.05.247-.025.071.006.102.134.123.088.015.396.149.683.287.288.139.776.406 1.084.59.308.19.57.345.58.345zm6.624-.01c.036.005.056-.016.041-.036-.015-.026-.087-.057-.16-.072-.071-.016-.143-.005-.153.015-.016.02.026.052.092.062.062.015.144.03.18.03zm.241.01c.016 0 .026-.01.026-.026 0-.015-.01-.025-.026-.025-.015 0-.025.01-.025.025 0 .016.01.026.025.026zm1.361 0c.036 0 .051-.016.036-.036-.015-.02-.051-.02-.067 0-.02.02-.01.036.031.036zm1.992-.026c.016-.015 0-.051-.036-.087s-.061-.041-.061-.005c0 .03.015.067.036.087.02.015.046.02.061.005zM6.716 6.116c.016 0 .026-.01.026-.026s-.01-.026-.026-.026c-.015 0-.026.01-.026.026 0 .015.01.026.026.026zm.257 0c.026 0 .015-.021-.026-.052a.35.35 0 00-.128-.051c-.026 0-.016.02.026.051a.319.319 0 00.128.052zm2.105 0c.016 0 .026-.01.026-.026s-.01-.026-.026-.026c-.015 0-.025.01-.025.026 0 .015.01.026.025.026zm7.26 0c.093 0 .211-.021.263-.052a.454.454 0 00.149-.21.909.909 0 00.051-.298c-.005-.123-.01-.123-.046-.031a.69.69 0 00-.046.236c0 .072-.047.17-.093.21a.503.503 0 01-.241.088c-.082.005-.16.02-.175.036-.015.01.046.02.139.02zm-7.347-.057c.01 0 0-.02-.016-.046a1.527 1.527 0 00-.261-.21c-.129-.088-.247-.15-.257-.134-.016.015.097.108.246.205.15.103.278.185.288.185zm4.426.005c.03 0 .067-.03.082-.072a.08.08 0 01.103-.046c.046.015.092-.026.128-.113a.545.545 0 01.144-.21.388.388 0 01.2-.067c.062 0 .129-.026.144-.052a.126.126 0 00-.005-.113c-.026-.04-.056-.03-.098.026-.061.082-.066.082-.097 0-.026-.072-.057-.056-.164.103-.072.103-.165.19-.206.19a.079.079 0 00-.077.077c0 .041-.015.077-.04.077-.021 0-.068.046-.104.103-.04.061-.04.097-.01.097zm.745 0c.015 0 .025-.01.025-.026 0-.015-.01-.025-.025-.025-.016 0-.026.01-.026.025 0 .016.01.026.026.026zm2.67-.051c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026s.01.026.026.026zm.102 0c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.025.01-.025.026s.01.026.025.026zm1.459-.016c.067-.005.144-.066.19-.149.04-.077.056-.143.03-.143-.025 0-.107.066-.19.149-.138.149-.138.154-.03.143zm-5.726-.036c.016 0 .042-.02.057-.05.015-.032.02-.052.005-.052s-.041.02-.056.051c-.021.026-.021.051-.006.051zm.386-.05c.025 0 .071-.083.107-.18.031-.098.083-.18.108-.18.026 0 .046-.02.046-.052 0-.025-.036-.036-.077-.02-.04.015-.113.097-.154.174a.738.738 0 00-.077.2c0 .031.02.057.047.057zm-6.85-.052c.015 0 .025-.01.025-.026 0-.015-.01-.026-.025-.026-.016 0-.026.01-.026.026 0 .015.01.026.026.026zm1.232 0c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.026.026.026zm.868 0c.026 0 .005-.031-.052-.072a.406.406 0 00-.148-.077c-.026 0-.006.03.05.072a.406.406 0 00.15.077zm8.74-.016c.015-.015.015-.077-.006-.138-.02-.057-.072-.108-.118-.103-.077 0-.077.005.005.051.052.031.093.088.093.134 0 .046.005.077.025.056zm.179-.046a.538.538 0 00.046-.241c0-.15-.01-.165-.077-.108a.247.247 0 00-.077.154c0 .051.016.134.031.18.026.066.041.072.077.015zm.436-.04l.057-.155a.318.318 0 00.015-.154c-.01-.057.01-.051.093.02.108.098.108.098.108-.005 0-.071-.041-.113-.129-.128-.072-.015-.144-.005-.159.026-.015.03-.062.036-.097.02-.052-.02-.052.005.005.113a.763.763 0 01.077.242c.005.066.015.077.03.02zm-3.584-.027c.016-.015 0-.051-.036-.087s-.061-.041-.061-.01c0 .03.015.067.036.087.02.02.046.026.061.01zm.36 0c.015-.015 0-.051-.036-.087s-.062-.041-.062-.01c0 .03.016.067.036.087.02.02.046.026.062.01zm3.476-.025c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.026.026.026zM7.317 5.653c.02 0 .041-.01.041-.02a.712.712 0 00-.175-.123 1.645 1.645 0 00-.297-.139c-.072-.02-.006.036.133.123.144.087.277.16.298.16zm.698-.005c.01 0 0-.02-.015-.046a.375.375 0 00-.134-.103c-.072-.036-.097-.036-.097 0 0 .031.051.077.113.103.067.026.123.046.133.046zm.344 0c.026 0 .005-.03-.051-.077-.057-.04-.36-.23-.668-.416-.313-.185-.62-.375-.693-.41-.123-.072-.123-.072-.025.015.056.046.251.174.436.287.185.108.472.293.642.401.17.108.329.2.36.2zm-1.514-.046c.035 0 .05-.015.035-.036-.02-.02-.05-.02-.066 0-.02.02-.005.036.03.036zm7.589-.051c.077 0 .077-.005.01-.052a.353.353 0 00-.118-.051c-.02 0-.026.02-.01.051.015.026.072.052.118.052zm-6.742-.108c.025 0 .005-.036-.046-.077a.406.406 0 00-.15-.077c-.03 0-.004.036.047.077.051.04.118.077.149.077zm6.603-.15c.046 0 .113-.03.15-.076.035-.041.05-.087.04-.103-.015-.015-.082.02-.149.077-.097.077-.102.098-.04.103zm3.518-.014c.015-.016.02-.062.005-.098-.016-.041-.031-.03-.031.03-.005.057.01.088.025.068zM7.358 5.243c.036 0 .051-.016.036-.036-.02-.02-.051-.02-.067 0-.02.02-.005.036.031.036zm10.357-.165a1.7 1.7 0 00.067-.174c0-.01-.02-.02-.046-.02s-.088.06-.134.133c-.072.107-.077.143-.02.174.046.031.087 0 .133-.113zm-3.117.01c.036 0 .051-.015.036-.035-.02-.02-.051-.02-.067 0-.02.02-.005.036.031.036zm-8.036-.41c.016 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.026.026.026zm-.616-.462c.015 0 .026-.01.026-.026 0-.015-.01-.026-.026-.026-.015 0-.026.01-.026.026 0 .015.01.026.026.026zm-.103-.052c.016 0 .026-.01.026-.025 0-.016-.01-.026-.026-.026-.015 0-.025.01-.025.026 0 .015.01.025.025.025zm-.734-.262a.04.04 0 00.041-.04c0-.026-.077-.083-.175-.13a1.037 1.037 0 00-.215-.081c-.02 0 .036.056.133.123a.855.855 0 00.216.128z" />
        </svg>
        <svg
          role="img"
          viewBox="0 0 24 24"
          xmlns="http://www.w3.org/2000/svg"
          fill="currentColor"
          className="h-6 w-6"
        >
          {/*PNPM*/}
          <path d="M0 0v7.5h7.5V0zm8.25 0v7.5h7.498V0zm8.25 0v7.5H24V0zM8.25 8.25v7.5h7.498v-7.5zm8.25 0v7.5H24v-7.5zM0 16.5V24h7.5v-7.5zm8.25 0V24h7.498v-7.5zm8.25 0V24H24v-7.5z" />
        </svg>
      </div>
    ),
  },
  node: {
    image: (
      <div className="space-y-4">
        <svg
          role="img"
          viewBox="0 0 24 24"
          xmlns="http://www.w3.org/2000/svg"
          fill="currentColor"
          className="h-6 w-6"
        >
          {/*NODEJS*/}
          <path d="M11.998,24c-0.321,0-0.641-0.084-0.922-0.247l-2.936-1.737c-0.438-0.245-0.224-0.332-0.08-0.383 c0.585-0.203,0.703-0.25,1.328-0.604c0.065-0.037,0.151-0.023,0.218,0.017l2.256,1.339c0.082,0.045,0.197,0.045,0.272,0l8.795-5.076 c0.082-0.047,0.134-0.141,0.134-0.238V6.921c0-0.099-0.053-0.192-0.137-0.242l-8.791-5.072c-0.081-0.047-0.189-0.047-0.271,0 L3.075,6.68C2.99,6.729,2.936,6.825,2.936,6.921v10.15c0,0.097,0.054,0.189,0.139,0.235l2.409,1.392 c1.307,0.654,2.108-0.116,2.108-0.89V7.787c0-0.142,0.114-0.253,0.256-0.253h1.115c0.139,0,0.255,0.112,0.255,0.253v10.021 c0,1.745-0.95,2.745-2.604,2.745c-0.508,0-0.909,0-2.026-0.551L2.28,18.675c-0.57-0.329-0.922-0.945-0.922-1.604V6.921 c0-0.659,0.353-1.275,0.922-1.603l8.795-5.082c0.557-0.315,1.296-0.315,1.848,0l8.794,5.082c0.57,0.329,0.924,0.944,0.924,1.603 v10.15c0,0.659-0.354,1.273-0.924,1.604l-8.794,5.078C12.643,23.916,12.324,24,11.998,24z M19.099,13.993 c0-1.9-1.284-2.406-3.987-2.763c-2.731-0.361-3.009-0.548-3.009-1.187c0-0.528,0.235-1.233,2.258-1.233 c1.807,0,2.473,0.389,2.747,1.607c0.024,0.115,0.129,0.199,0.247,0.199h1.141c0.071,0,0.138-0.031,0.186-0.081 c0.048-0.054,0.074-0.123,0.067-0.196c-0.177-2.098-1.571-3.076-4.388-3.076c-2.508,0-4.004,1.058-4.004,2.833 c0,1.925,1.488,2.457,3.895,2.695c2.88,0.282,3.103,0.703,3.103,1.269c0,0.983-0.789,1.402-2.642,1.402 c-2.327,0-2.839-0.584-3.011-1.742c-0.02-0.124-0.126-0.215-0.253-0.215h-1.137c-0.141,0-0.254,0.112-0.254,0.253 c0,1.482,0.806,3.248,4.655,3.248C17.501,17.007,19.099,15.91,19.099,13.993z" />
        </svg>
      </div>
    ),
  },
  react: {
    image: (
      <svg
        role="img"
        viewBox="0 0 24 24"
        xmlns="http://www.w3.org/2000/svg"
        fill="currentColor"
        className="h-6 w-6"
      >
        <path d="M14.23 12.004a2.236 2.236 0 0 1-2.235 2.236 2.236 2.236 0 0 1-2.236-2.236 2.236 2.236 0 0 1 2.235-2.236 2.236 2.236 0 0 1 2.236 2.236zm2.648-10.69c-1.346 0-3.107.96-4.888 2.622-1.78-1.653-3.542-2.602-4.887-2.602-.41 0-.783.093-1.106.278-1.375.793-1.683 3.264-.973 6.365C1.98 8.917 0 10.42 0 12.004c0 1.59 1.99 3.097 5.043 4.03-.704 3.113-.39 5.588.988 6.38.32.187.69.275 1.102.275 1.345 0 3.107-.96 4.888-2.624 1.78 1.654 3.542 2.603 4.887 2.603.41 0 .783-.09 1.106-.275 1.374-.792 1.683-3.263.973-6.365C22.02 15.096 24 13.59 24 12.004c0-1.59-1.99-3.097-5.043-4.032.704-3.11.39-5.587-.988-6.38-.318-.184-.688-.277-1.092-.278zm-.005 1.09v.006c.225 0 .406.044.558.127.666.382.955 1.835.73 3.704-.054.46-.142.945-.25 1.44-.96-.236-2.006-.417-3.107-.534-.66-.905-1.345-1.727-2.035-2.447 1.592-1.48 3.087-2.292 4.105-2.295zm-9.77.02c1.012 0 2.514.808 4.11 2.28-.686.72-1.37 1.537-2.02 2.442-1.107.117-2.154.298-3.113.538-.112-.49-.195-.964-.254-1.42-.23-1.868.054-3.32.714-3.707.19-.09.4-.127.563-.132zm4.882 3.05c.455.468.91.992 1.36 1.564-.44-.02-.89-.034-1.345-.034-.46 0-.915.01-1.36.034.44-.572.895-1.096 1.345-1.565zM12 8.1c.74 0 1.477.034 2.202.093.406.582.802 1.203 1.183 1.86.372.64.71 1.29 1.018 1.946-.308.655-.646 1.31-1.013 1.95-.38.66-.773 1.288-1.18 1.87-.728.063-1.466.098-2.21.098-.74 0-1.477-.035-2.202-.093-.406-.582-.802-1.204-1.183-1.86-.372-.64-.71-1.29-1.018-1.946.303-.657.646-1.313 1.013-1.954.38-.66.773-1.286 1.18-1.868.728-.064 1.466-.098 2.21-.098zm-3.635.254c-.24.377-.48.763-.704 1.16-.225.39-.435.782-.635 1.174-.265-.656-.49-1.31-.676-1.947.64-.15 1.315-.283 2.015-.386zm7.26 0c.695.103 1.365.23 2.006.387-.18.632-.405 1.282-.66 1.933-.2-.39-.41-.783-.64-1.174-.225-.392-.465-.774-.705-1.146zm3.063.675c.484.15.944.317 1.375.498 1.732.74 2.852 1.708 2.852 2.476-.005.768-1.125 1.74-2.857 2.475-.42.18-.88.342-1.355.493-.28-.958-.646-1.956-1.1-2.98.45-1.017.81-2.01 1.085-2.964zm-13.395.004c.278.96.645 1.957 1.1 2.98-.45 1.017-.812 2.01-1.086 2.964-.484-.15-.944-.318-1.37-.5-1.732-.737-2.852-1.706-2.852-2.474 0-.768 1.12-1.742 2.852-2.476.42-.18.88-.342 1.356-.494zm11.678 4.28c.265.657.49 1.312.676 1.948-.64.157-1.316.29-2.016.39.24-.375.48-.762.705-1.158.225-.39.435-.788.636-1.18zm-9.945.02c.2.392.41.783.64 1.175.23.39.465.772.705 1.143-.695-.102-1.365-.23-2.006-.386.18-.63.406-1.282.66-1.933zM17.92 16.32c.112.493.2.968.254 1.423.23 1.868-.054 3.32-.714 3.708-.147.09-.338.128-.563.128-1.012 0-2.514-.807-4.11-2.28.686-.72 1.37-1.536 2.02-2.44 1.107-.118 2.154-.3 3.113-.54zm-11.83.01c.96.234 2.006.415 3.107.532.66.905 1.345 1.727 2.035 2.446-1.595 1.483-3.092 2.295-4.11 2.295-.22-.005-.406-.05-.553-.132-.666-.38-.955-1.834-.73-3.703.054-.46.142-.944.25-1.438zm4.56.64c.44.02.89.034 1.345.034.46 0 .915-.01 1.36-.034-.44.572-.895 1.095-1.345 1.565-.455-.47-.91-.993-1.36-1.565z" />
      </svg>
    ),
  },
  angular: {
    image: (
      <svg
        role="img"
        viewBox="0 0 24 24"
        xmlns="http://www.w3.org/2000/svg"
        fill="currentColor"
        className="h-6 w-6"
      >
        {/*ANGULAR*/}
        <path d="M9.931 12.645h4.138l-2.07-4.908m0-7.737L.68 3.982l1.726 14.771L12 24l9.596-5.242L23.32 3.984 11.999.001zm7.064 18.31h-2.638l-1.422-3.503H8.996l-1.422 3.504h-2.64L12 2.65z" />
      </svg>
    ),
  },
  create: {
    image: <DocumentPlusIcon role="img" className="h-6 w-6" />,
  },
  share: {
    image: <ShareIcon role="img" className="h-6 w-6" />,
  },
  extend: {
    image: (
      <svg
        role="img"
        fill="currentColor"
        viewBox="0 0 24 24"
        className="h-6 w-6"
        xmlns="http://www.w3.org/2000/svg"
      >
        <title>Nx</title>
        <path d="M11.987 14.138l-3.132 4.923-5.193-8.427-.012 8.822H0V4.544h3.691l5.247 8.833.005-3.998 3.044 4.759zm.601-5.761c.024-.048 0-3.784.008-3.833h-3.65c.002.059-.005 3.776-.003 3.833h3.645zm5.634 4.134a2.061 2.061 0 0 0-1.969 1.336 1.963 1.963 0 0 1 2.343-.739c.396.161.917.422 1.33.283a2.1 2.1 0 0 0-1.704-.88zm3.39 1.061c-.375-.13-.8-.277-1.109-.681-.06-.08-.116-.17-.176-.265a2.143 2.143 0 0 0-.533-.642c-.294-.216-.68-.322-1.18-.322a2.482 2.482 0 0 0-2.294 1.536 2.325 2.325 0 0 1 4.002.388.75.75 0 0 0 .836.334c.493-.105.46.36 1.203.518v-.133c-.003-.446-.246-.55-.75-.733zm2.024 1.266a.723.723 0 0 0 .347-.638c-.01-2.957-2.41-5.487-5.37-5.487a5.364 5.364 0 0 0-4.487 2.418c-.01-.026-1.522-2.39-1.538-2.418H8.943l3.463 5.423-3.379 5.32h3.54l1.54-2.366 1.568 2.366h3.541l-3.21-5.052a.7.7 0 0 1-.084-.32 2.69 2.69 0 0 1 2.69-2.691h.001c1.488 0 1.736.89 2.057 1.308.634.826 1.9.464 1.9 1.541a.707.707 0 0 0 1.066.596zm.35.133c-.173.372-.56.338-.755.639-.176.271.114.412.114.412s.337.156.538-.311c.104-.231.14-.488.103-.74z" />
      </svg>
    ),
  },
  browse: {
    image: <DocumentMagnifyingGlassIcon role="img" className="h-6 w-6" />,
  },
};

export function Persona({
  title,
  type,
  url,
  children,
}: {
  title: string;
  type: PersonaType;
  url: string;
  children: ReactNode;
}): JSX.Element {
  const ui = typeMap[type];

  return (
    <section className="relative flex overflow-hidden rounded-md border border-slate-200 bg-slate-50 p-4 transition hover:bg-slate-50/40 dark:border-slate-800/40 dark:bg-slate-800/60 dark:hover:bg-slate-800">
      <div className="flex-shrink-0">{ui.image}</div>
      <div className="ml-4">
        {title && <h5 className="mt-0 text-base font-medium">{title}</h5>}
        <div className="prose-sm dark:prose-invert mt-2">{children}</div>
        <Link
          href={url}
          title={title}
          aria-hidden="true"
          className="absolute inset-0"
          prefetch={false}
        />
      </div>
    </section>
  );
}
