'use client';
import { motion } from 'framer-motion';
import { FC, SVGProps } from 'react';

export const NxAgentsIcon: FC<SVGProps<SVGSVGElement>> = (props) => (
  <svg
    role="img"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg"
    stroke="currentColor"
    fill="none"
    {...props}
  >
    <path
      strokeLinejoin="round"
      d="M21 12.5h-4m4 0a1 1 0 1 0 2 0 1 1 0 0 0-2 0Zm-2 8h-5v-3m5 3a1 1 0 1 0 2 0 1 1 0 0 0-2 0Zm-16-8h4m-4 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm2 8h5v-3m-5 3a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm0-17h5v4m-5-4a1 1 0 1 0-2 0 1 1 0 0 0 2 0Zm14 0h-5v4m5-4a1 1 0 1 1 2 0 1 1 0 0 1-2 0Zm-3 14H8a1 1 0 0 1-1-1v-8a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1Zm-5-8h2l-.667 1.875L14 11.346 11.333 15.5l.334-2.77H10l1-3.23Z"
    />
  </svg>
);

export const NxReplayIcon: FC<SVGProps<SVGSVGElement>> = (props) => (
  <svg
    role="img"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg"
    stroke="currentColor"
    fill="none"
    {...props}
  >
    <path
      strokeLinecap="round"
      d="m8.625 2.621-.014.004c-.317.09-.622.22-.907.387m4.796-.965-.014-.002a3.958 3.958 0 0 0-.986.002m3.875.574.014.004c.317.09.622.22.907.387m-.92 18.367.013-.004c.317-.09.622-.22.907-.387m-4.796.965.014.002c.328.04.659.04.986-.002m-3.875-.574-.014-.004a3.96 3.96 0 0 1-.907-.387M21.38 8.625l-.004-.014a3.96 3.96 0 0 0-.387-.907m.965 4.796.002-.014c.04-.328.04-.659-.002-.986m-.574 3.875-.004.014a3.96 3.96 0 0 1-.387.907m-18.367-.92.004.013c.09.317.22.622.387.907M2.047 11.5l-.002.014c-.04.328-.04.659.002.986m.574-3.875.004-.014c.09-.317.22-.622.387-.907M7.5 10.516h9m-9 0a1.5 1.5 0 0 1 0-3h9a1.5 1.5 0 0 1 0 3m-9 0a1.5 1.5 0 0 0 0 3m9-3a1.5 1.5 0 0 1 0 3m-6.412-4.5h.01m-1.883 0h.01m-.725 4.5h9m-9 0a1.5 1.5 0 0 0 0 3h9a1.5 1.5 0 0 0 0-3m-6.412-1.5h.01m-1.883 0h.01m1.863 3h.01m-1.883 0h.01M3 4.516a1.5 1.5 0 1 0 3 0 1.5 1.5 0 0 0-3 0Zm15 0a1.5 1.5 0 1 0 3 0 1.5 1.5 0 0 0-3 0Zm-15 15a1.5 1.5 0 1 0 3 0 1.5 1.5 0 0 0-3 0Zm15 0a1.5 1.5 0 1 0 3 0 1.5 1.5 0 0 0-3 0Z"
    />
  </svg>
);

export const NxWorkflowsIcon: FC<SVGProps<SVGSVGElement>> = (props) => (
  <svg
    role="img"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg"
    stroke="currentColor"
    fill="none"
    {...props}
  >
    <g clipPath="url(#a)">
      <path
        strokeLinecap="round"
        d="M13.315 10h7.37m-7.37-6h7.37m-5.95-1v2m-1.42 2h7.37m-1.159-1v2M17 9v2M4.678 3.5h.75m2.29 0h.75m-3.79 7h.75m2.29 0h.75m1.605-5.395v.75m0 2.29v.75m-7-3.79v.75m0 2.29v.75M3.698 21h6a1 1 0 0 0 1-1v-.763a1 1 0 0 0-1-1h-6a1 1 0 0 0-1 1V20a1 1 0 0 0 1 1Zm0-4.605h6a1 1 0 0 0 1-1v-.763a1 1 0 0 0-1-1h-6a1 1 0 0 0-1 1v.763a1 1 0 0 0 1 1Zm14.723.976a1.42 1.42 0 1 1-2.842 0 1.42 1.42 0 0 1 2.842 0ZM2.499.499H21.5a2 2 0 0 1 2 2V21.5a2 2 0 0 1-2 2h-19a2 2 0 0 1-2-2v-19a2 2 0 0 1 2-2ZM20.11 16.087l.599.126a.6.6 0 0 1 .476.587v1.133a.6.6 0 0 1-.477.588l-.594.123a.6.6 0 0 0-.448.773l.19.583a.6.6 0 0 1-.27.706l-.983.566a.6.6 0 0 1-.747-.12l-.408-.456a.6.6 0 0 0-.896.001l-.403.454a.6.6 0 0 1-.748.12l-.98-.565a.6.6 0 0 1-.27-.704l.19-.586a.6.6 0 0 0-.449-.773l-.594-.124a.6.6 0 0 1-.478-.588l.001-1.13a.6.6 0 0 1 .476-.587l.6-.127a.6.6 0 0 0 .446-.775l-.19-.576a.6.6 0 0 1 .27-.707l.978-.567a.6.6 0 0 1 .747.119l.408.454a.6.6 0 0 0 .894 0l.405-.454a.6.6 0 0 1 .747-.12l.982.567a.6.6 0 0 1 .27.707l-.19.578a.6.6 0 0 0 .446.774Z"
      />
    </g>
    <defs>
      <clipPath id="a">
        <path fill="transparent" d="M0 0h24v24H0z" />
      </clipPath>
    </defs>
  </svg>
);

export const NxCloudAnimatedIcon: FC<SVGProps<SVGSVGElement>> = (props) => (
  <svg
    role="img"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg"
    stroke="currentColor"
    fill="transparent"
    {...props}
  >
    <motion.path
      d="M22.167 7.167v-2.5a2.5 2.5 0 0 0-2.5-2.5h-15a2.5 2.5 0 0 0-2.5 2.5v15a2.5 2.5 0 0 0 2.5 2.5h2.5m15-15c-2.76 0-5 2.24-5 5s-2.24 5-5 5-5 2.24-5 5m15-15V19.59a2.577 2.577 0 0 1-2.576 2.576H7.167"
      strokeWidth="2"
      initial={{ pathLength: 0 }}
      animate={{ pathLength: 1 }}
      transition={{ duration: 1.5, ease: 'easeOut' }}
    />
  </svg>
);

export const NxCloudIcon: FC<SVGProps<SVGSVGElement>> = (props) => (
  <svg
    role="img"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg"
    stroke="currentColor"
    fill="transparent"
    {...props}
  >
    <path
      d="M22.167 7.167v-2.5a2.5 2.5 0 0 0-2.5-2.5h-15a2.5 2.5 0 0 0-2.5 2.5v15a2.5 2.5 0 0 0 2.5 2.5h2.5m15-15c-2.76 0-5 2.24-5 5s-2.24 5-5 5-5 2.24-5 5m15-15V19.59a2.577 2.577 0 0 1-2.576 2.576H7.167"
      strokeWidth="2"
    />
  </svg>
);
/**
 * Use `#143055` for a colored version.
 */
export const NxIcon: FC<SVGProps<SVGSVGElement>> = (props) => (
  <svg
    role="img"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg"
    fill="currentColor"
    {...props}
  >
    <title>Nx</title>
    <path d="M11.987 14.138l-3.132 4.923-5.193-8.427-.012 8.822H0V4.544h3.691l5.247 8.833.005-3.998 3.044 4.759zm.601-5.761c.024-.048 0-3.784.008-3.833h-3.65c.002.059-.005 3.776-.003 3.833h3.645zm5.634 4.134a2.061 2.061 0 0 0-1.969 1.336 1.963 1.963 0 0 1 2.343-.739c.396.161.917.422 1.33.283a2.1 2.1 0 0 0-1.704-.88zm3.39 1.061c-.375-.13-.8-.277-1.109-.681-.06-.08-.116-.17-.176-.265a2.143 2.143 0 0 0-.533-.642c-.294-.216-.68-.322-1.18-.322a2.482 2.482 0 0 0-2.294 1.536 2.325 2.325 0 0 1 4.002.388.75.75 0 0 0 .836.334c.493-.105.46.36 1.203.518v-.133c-.003-.446-.246-.55-.75-.733zm2.024 1.266a.723.723 0 0 0 .347-.638c-.01-2.957-2.41-5.487-5.37-5.487a5.364 5.364 0 0 0-4.487 2.418c-.01-.026-1.522-2.39-1.538-2.418H8.943l3.463 5.423-3.379 5.32h3.54l1.54-2.366 1.568 2.366h3.541l-3.21-5.052a.7.7 0 0 1-.084-.32 2.69 2.69 0 0 1 2.69-2.691h.001c1.488 0 1.736.89 2.057 1.308.634.826 1.9.464 1.9 1.541a.707.707 0 0 0 1.066.596zm.35.133c-.173.372-.56.338-.755.639-.176.271.114.412.114.412s.337.156.538-.311c.104-.231.14-.488.103-.74z" />
  </svg>
);

export const NxConsoleIcon: FC<SVGProps<SVGSVGElement>> = (props) => (
  <svg
    role="img"
    xmlns="http://www.w3.org/2000/svg"
    fill="currentColor"
    viewBox="0 0 344 221"
    {...props}
  >
    <title>Nx Console</title>
    <path d="M43.3535 191.192C40.8271 191.192 38.5414 190.639 36.4963 189.532C34.4752 188.401 32.8872 186.861 31.7323 184.912C30.5774 182.939 30 180.726 30 178.272C30 175.818 30.5774 173.616 31.7323 171.667C32.8872 169.694 34.4872 168.154 36.5324 167.048C38.5775 165.917 40.8632 165.351 43.3896 165.351C45.3625 165.351 47.167 165.688 48.8031 166.362C50.4392 167.011 51.8347 167.986 52.9896 169.285L50.6437 171.559C48.743 169.562 46.373 168.563 43.5339 168.563C41.6572 168.563 39.961 168.984 38.4452 169.827C36.9294 170.669 35.7384 171.836 34.8722 173.327C34.0301 174.795 33.609 176.443 33.609 178.272C33.609 180.1 34.0301 181.76 34.8722 183.252C35.7384 184.72 36.9294 185.875 38.4452 186.717C39.961 187.559 41.6572 187.98 43.5339 187.98C46.349 187.98 48.7189 186.969 50.6437 184.948L52.9896 187.222C51.8347 188.521 50.4272 189.508 48.767 190.182C47.1309 190.855 45.3264 191.192 43.3535 191.192Z" />
    <path d="M85.9764 191.192C83.426 191.192 81.1282 190.639 79.0831 189.532C77.038 188.401 75.4259 186.849 74.247 184.876C73.0921 182.903 72.5146 180.702 72.5146 178.272C72.5146 175.842 73.0921 173.64 74.247 171.667C75.4259 169.694 77.038 168.154 79.0831 167.048C81.1282 165.917 83.426 165.351 85.9764 165.351C88.5027 165.351 90.7884 165.917 92.8336 167.048C94.8787 168.154 96.4787 169.694 97.6336 171.667C98.7885 173.616 99.3659 175.818 99.3659 178.272C99.3659 180.726 98.7885 182.939 97.6336 184.912C96.4787 186.861 94.8787 188.401 92.8336 189.532C90.7884 190.639 88.5027 191.192 85.9764 191.192ZM85.9764 187.98C87.829 187.98 89.4892 187.559 90.9568 186.717C92.4486 185.875 93.6155 184.72 94.4576 183.252C95.3238 181.76 95.757 180.1 95.757 178.272C95.757 176.443 95.3238 174.795 94.4576 173.327C93.6155 171.836 92.4486 170.669 90.9568 169.827C89.4892 168.984 87.829 168.563 85.9764 168.563C84.1237 168.563 82.4395 168.984 80.9237 169.827C79.432 170.669 78.253 171.836 77.3868 173.327C76.5447 174.795 76.1237 176.443 76.1237 178.272C76.1237 180.1 76.5447 181.76 77.3868 183.252C78.253 184.72 79.432 185.875 80.9237 186.717C82.4395 187.559 84.1237 187.98 85.9764 187.98Z" />
    <path d="M143.571 165.64V190.903H140.612L125.454 172.064V190.903H121.845V165.64H124.804L139.962 184.479V165.64H143.571Z" />
    <path d="M175.458 191.192C173.557 191.192 171.717 190.903 169.936 190.326C168.18 189.724 166.796 188.954 165.786 188.016L167.121 185.201C168.084 186.067 169.311 186.777 170.802 187.33C172.318 187.86 173.87 188.124 175.458 188.124C177.551 188.124 179.115 187.776 180.15 187.078C181.184 186.356 181.702 185.406 181.702 184.227C181.702 183.36 181.413 182.663 180.836 182.133C180.282 181.58 179.584 181.159 178.742 180.87C177.924 180.581 176.757 180.257 175.241 179.896C173.341 179.439 171.801 178.981 170.622 178.524C169.467 178.067 168.469 177.369 167.626 176.431C166.808 175.469 166.399 174.181 166.399 172.569C166.399 171.222 166.748 170.007 167.446 168.924C168.168 167.842 169.25 166.975 170.694 166.326C172.138 165.676 173.93 165.351 176.072 165.351C177.563 165.351 179.031 165.544 180.475 165.929C181.918 166.314 183.157 166.867 184.192 167.589L183.001 170.476C181.942 169.802 180.811 169.297 179.608 168.96C178.405 168.599 177.226 168.419 176.072 168.419C174.026 168.419 172.487 168.792 171.452 169.538C170.441 170.284 169.936 171.246 169.936 172.425C169.936 173.291 170.225 174.001 170.802 174.554C171.38 175.084 172.09 175.505 172.932 175.818C173.798 176.106 174.965 176.419 176.432 176.756C178.333 177.213 179.861 177.67 181.016 178.127C182.171 178.584 183.157 179.282 183.975 180.221C184.817 181.159 185.239 182.422 185.239 184.01C185.239 185.333 184.878 186.548 184.156 187.655C183.434 188.738 182.339 189.604 180.872 190.254C179.404 190.879 177.599 191.192 175.458 191.192Z" />
    <path d="M218.878 191.192C216.328 191.192 214.03 190.639 211.985 189.532C209.94 188.401 208.328 186.849 207.149 184.876C205.994 182.903 205.416 180.702 205.416 178.272C205.416 175.842 205.994 173.64 207.149 171.667C208.328 169.694 209.94 168.154 211.985 167.048C214.03 165.917 216.328 165.351 218.878 165.351C221.405 165.351 223.69 165.917 225.735 167.048C227.781 168.154 229.381 169.694 230.535 171.667C231.69 173.616 232.268 175.818 232.268 178.272C232.268 180.726 231.69 182.939 230.535 184.912C229.381 186.861 227.781 188.401 225.735 189.532C223.69 190.639 221.405 191.192 218.878 191.192ZM218.878 187.98C220.731 187.98 222.391 187.559 223.859 186.717C225.35 185.875 226.517 184.72 227.359 183.252C228.226 181.76 228.659 180.1 228.659 178.272C228.659 176.443 228.226 174.795 227.359 173.327C226.517 171.836 225.35 170.669 223.859 169.827C222.391 168.984 220.731 168.563 218.878 168.563C217.026 168.563 215.341 168.984 213.826 169.827C212.334 170.669 211.155 171.836 210.289 173.327C209.447 174.795 209.026 176.443 209.026 178.272C209.026 180.1 209.447 181.76 210.289 183.252C211.155 184.72 212.334 185.875 213.826 186.717C215.341 187.559 217.026 187.98 218.878 187.98Z" />
    <path d="M254.747 165.64H258.356V187.763H272.034V190.903H254.747V165.64Z" />
    <path d="M311.472 187.763V190.903H293.138V165.64H310.966V168.78H296.747V176.539H309.414V179.607H296.747V187.763H311.472Z" />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M54.4938 30H30.2227V127.745H59.4861V79.9321L99.0951 127.745H123.366V30H94.1028V77.8129L54.4938 30ZM33.2303 124.737V33.0075H53.0798L97.1104 86.1577V33.0075H120.358V124.737H100.509L56.4785 71.5873V124.737H33.2303ZM153.172 30H186.673L220.749 78.3213L186.683 127.745H151.648L187.249 78.3219L153.172 30ZM158.973 33.0075L190.942 78.3404L157.521 124.737H185.103L217.083 78.341L185.113 33.0075H158.973ZM243.307 108.196H313.984V127.745H243.307V108.196ZM246.314 111.204V124.737H310.976V111.204H246.314Z"
    />
  </svg>
);
