import { FC, SVGProps } from 'react';

/**
 * Use `#0000EB` for a colored version.
 */
export const SiriusxmIcon: FC<SVGProps<SVGSVGElement>> = (props) => (
  <svg
    role="img"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg"
    fill="currentColor"
    {...props}
  >
    <title>SiriusXM</title>
    <path
      xmlns="http://www.w3.org/2000/svg"
      d="M4.5741 10.7134h1.041v2.6201H4.574v-2.6201Zm0-.7134h1.041v.4998H4.574V10Zm3.436 0H9.051v.5012H8.0101V10Zm0 .7134H9.051v2.6201H8.0101v-2.6201Zm3.1071 0h1.0423v2.6201h-.9669v-.3859c-.2591.3602-.5154.4599-.9469.4599-.571 0-.9398-.3489-.9398-1.0993v-1.5948h1.0409v1.4154c0 .3588.1253.4742.3745.4742.3004 0 .3959-.2236.3959-.6294v-1.2602Zm3.8788 1.7799c0 .5454-.45.9142-1.4111.9142-.601 0-1.2617-.1837-1.3172-.89h.9911c0 .1054.0398.1852.111.2393.0641.0498.1552.0811.2549.0811.1609 0 .3318-.0498.3318-.2349 0-.4215-1.6076-.0855-1.6076-1.1007 0-.6693.6949-.8658 1.2402-.8658.571 0 1.2417.1296 1.3015.8245h-.9469c-.01-.084-.0442-.1438-.0997-.1894-.0541-.0456-.1296-.0655-.2093-.0655-.1808 0-.2962.0541-.2962.1851.0014.3674 1.6575.1225 1.6575 1.1021ZM4.268 11.834c.0797.1211.1267.2677.1267.45-.0057.6707-.561 1.1249-1.7572 1.1249-.7475 0-1.5692-.2278-1.6375-1.095v-.0427h1.1206l-.2477.7305.8173-.5682.8174.5682-.2122-.628c-.0328-.0641-.1182-.0997-.1182-.0997-.4471-.2477-2.0761-.1139-2.0761-1.2089 0-.8245.8672-1.0651 1.5464-1.0651.7106 0 1.545.1609 1.619 1.0153v.0327H3.005l-.3118-.9184-.3133.9184h-1.011l.5653.3888c.1652-.0655.3418-.094.5183-.114a3.3187 3.3187 0 0 1 .571-.0113 2.834 2.834 0 0 1 .4756.0697c.141.0328.2848.0698.413.1396.1438.0797.2691.1794.356.3132Zm3.3847-1.1961c.064 0 .1338.0157.1338.0157v1.0409s-.054-.0313-.215-.0313c-.4257 0-.6408.1993-.6408.7646v.9071H5.8898v-2.6215h.9455v.5297h.01c.1467-.4087.4001-.6052.8074-.6052Zm13.593-.5639H23v3.2595h-1.1093v-.9256c0-.4485.0086-.8643.0257-1.2445a5.7576 5.7576 0 0 1-.1111.4428l-.4528 1.7258h-.927l-.4642-1.7244-.0484-.1822a3.073 3.073 0 0 1-.0385-.1567.7343.7343 0 0 0-.0199-.0783c.0157.3731.0242.7789.0242 1.2175v.9256h-1.1064V10.074h1.7529l.2819 1.236.0855.3888c.037-.1956.0636-.3252.0797-.3888l.2734-1.236Zm-3.8646 1.5208 1.2844 1.7401h-1.3342l-.198-.2976-.383-.591c-.1054.1567-.2449.3518-.4186.591l-.2165.2976h-1.2659l1.32-1.6717-1.179-1.5877h1.32l.1979.2833.2877.4201c.0057-.0128.0512-.0783.1352-.2008l.1524-.2207.1965-.2834h1.2303l-1.1292 1.5208Z"
    />
  </svg>
);

/**
 * Use `#0000EB` for a colored version.
 */
export const SiriusxmAlternateIcon: FC<SVGProps<SVGSVGElement>> = (props) => (
  <svg
    role="img"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg"
    fill="currentColor"
    {...props}
  >
    <path d="M22.1788 12.8373c.5174.7808.8212 1.7273.8212 2.9036C22.9642 20.0692 19.3641 23 11.6123 23 6.7683 23 1.4428 21.5296 1 15.9336v-.2755h7.2631l-1.6065 4.7138 5.2968-3.666 5.2983 3.666-1.3758-4.0528c-.2121-.4126-.7653-.6424-.7653-.6424-2.8978-1.5989-13.4557-.7352-13.4557-7.803C1.655 2.5532 7.2757 1 11.6768 1c4.6061 0 10.0133 1.0378 10.4934 6.5525v.2112h-8.176l-2.0221-5.9272-2.0294 5.9272H3.3905l3.663 2.5082c1.0706-.4225 2.2157-.6052 3.3593-.7351 1.2282-.1285 2.4636-.1556 3.7004-.0728 1.0332.0642 2.068.2112 3.0826.4496.9144.2113 1.8459.4511 2.6757.9008.9329.5154 1.7441 1.1578 2.3073 2.0229Z" />
  </svg>
);
