import { FC, SVGProps } from 'react';

export const RoyalBankOfCanadaIcon: FC<SVGProps<SVGSVGElement>> = (props) => (
  <svg
    role="img"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg"
    fill="currentColor"
    {...props}
  >
    <title>Royal Bank of Canada</title>
    <path d="M3 0v21.047c0 .805.318 1.235.953 1.504C6.388 23.517 9.247 24 12 24c2.753 0 5.612-.483 8.047-1.45.635-.268.953-.698.953-1.503V0H3zm3.793 1.092h1.361v.914h5.233v1.4c0 .216 0 .537-.053.752 0 .162-.053.379-.314.594-.157.108-.417.16-.784.16-.314 0-.629.001-.943-.053-.576-.053-.785.215-.785.43v.162c.261-.215.68-.376 1.1-.215.784.27.993.269 1.412-.054l.052.107a.622.622 0 0 0-.047.057c-.043.057-.102.135-.214.213h.367V7.71l1.203-.752h3.35l1.62.861c.21.108.263.269.315.43 0 .161 0 .377-.105.484-.053.108-.418.754-.627 1.077.627.7.941 1.561.941 2.476s-.315 2.045-1.361 2.906c.418.108.732.377.994.754l-.26 1.184h-.158c0-.969-.837-1.184-1.727-1.184H14.59c.105.485.105 1.024.053 1.508h-.157c-.261-2.1-1.413-3.176-3.035-4.307v.97h-.158c-.419-1.024-1.359-1.939-2.3-2.585l-.735-.537v1.022h-.156c-.367-1.023-1.1-1.83-2.041-2.745-1.047-.968-1.518-1.562-1.727-2.261a3.143 3.143 0 0 1-.209-1.184c0-.807.365-1.56.889-1.83v.377c-.262.323-.366.753-.366 1.184 0 .376.105.861.262 1.238.628 1.184 2.616 2.637 3.924 3.498l.531.361c3.57 2.43 4.314 2.939 4.963 4.377.016.05.036.102.059.16.052.136.114.297.15.485.576-.108 2.67-.43 3.088-.485a.618.618 0 0 0 .107-.02c.066-.014.146-.032.207-.032.367-.216.628-.54.89-.916l-1.518-.108c-.037.113-.099.226-.15.32-.023.041-.044.077-.06.11h-.103c.026-.08.038-.162.05-.242.014-.081.027-.162.054-.242l-.418-.053v-.108l.418-.054c.104-.43.105-.862.105-1.239l-1.937-.107v.592h-.104c-.026-.108-.04-.201-.053-.295a2.869 2.869 0 0 0-.052-.297h-.418v-.107h.418a13.494 13.494 0 0 1-.053-1.454l-1.15-.054.156.324c.261.7.21 1.506.105 1.883h-.156c0-.43-.158-.968-.315-1.291-.314-.754-.993-1.454-2.197-2.207v.968h-.158c-.366-1.291-1.36-1.99-2.824-2.744-1.204-.646-1.57-1.4-1.518-2.584l.418.268c.105 1.076.942 1.723 1.78 1.723a6.44 6.44 0 0 0 1.464-.16c.68-.162 1.256-.27 1.78-.055v-.647h-.418c-.157.108-.42.27-.838.27-.471 0-1.362-.269-1.362-1.291 0-.915.733-1.024 1.309-1.024h1.047a.437.437 0 0 0 .254-.074l.06-.033a.41.41 0 0 0 .104-.215v-1.13H9.775v1.13L8.73 3.566v-.27h.522v-.429h-1.83v-.914h-.629c-.366 0-.733.215-.785.7 0 .484.158.86.629.86h.105v.538h-.105c-.785 0-1.412-.592-1.412-1.453 0-.862.678-1.506 1.568-1.506zm4.584 4.521-.012.002c-.214.013-.38.098-.543.266.157.054.314.107.471.107.262-.054.419-.214.523-.322a1.685 1.685 0 0 0-.427-.053h-.012zm.545 2.098c-.312 0-.739.094-1.098.174-.183.04-.349.077-.472.095.05.035.15.098.275.176.26.164.627.396.875.578l1.309-.806c-.262-.162-.575-.217-.89-.217zm2.826 0L12.34 9.166c.47.323.838.645 1.152 1.021.628-.968 1.778-1.56 2.877-1.56.262 0 .68.054 1.047.162l.209-.27-.262-.376.053-.108.785.43-.158.539c.105.054.263.162.42.27l.523-.862-1.308-.701h-2.93zM4.439 8.789l.21.16a4.281 4.281 0 0 0-.106.809c.052 1.076.89 1.775 3.35 3.336 2.616 1.668 3.347 2.692 3.609 3.984h-.156c-.576-1.292-1.727-1.992-3.035-2.746v1.023h-.157c-.366-.915-1.046-1.775-1.988-2.529-.89-.646-1.257-1.024-1.623-1.562a2.585 2.585 0 0 1-.418-1.399c0-.377.105-.753.314-1.076zm11.512.537c-.157.377-.262.808-.367 1.238l1.361-.052a5.594 5.594 0 0 0-.47-1.186h-.524zm1.412.215c.105.323.21.647.262.916l.941-.055c-.314-.376-.732-.646-1.203-.861zm-2.25.11c-.523.269-.89.591-1.256 1.076l1.1-.055c.052-.538.104-.86.156-1.022zm.367 1.29c-.093.432-.146.863-.193 1.256l-.017.145 1.937-.11c0-.43-.053-.805-.158-1.236l-1.569-.055zm2.25.108c.053.43.051.807.051 1.183l1.57-.107a3.306 3.306 0 0 0-.314-1.021l-1.307-.055zm-.052 1.668c-.053.43-.158.809-.315 1.185l1.727-.214c.105-.27.209-.593.209-.862l-1.621-.11zM5.25 17.455h2.4c1.1 0 1.55.351 1.55 1.104 0 .652-.5 1.001-1.1 1.152l1.55 2.008h-1.2l-1.4-1.907H6.7v1.907h-1v-3.31c0-.352-.05-.604-.2-.755-.05-.05-.15-.1-.25-.15v-.049zm4.85 0h2.25c1.35 0 1.55.502 1.55.953 0 .502-.4.852-.85.903.6.05 1.15.35 1.1 1.103 0 .903-.7 1.305-1.75 1.305h-1.85v-3.412c0-.301-.05-.502-.2-.653-.05-.05-.2-.15-.25-.15v-.049zm7.35 0c.9 0 1.3.25 1.3.25l-.2.703h-.05s-.1-.2-.35-.351c-.15-.1-.35-.2-.75-.1-.75 0-1.3.401-1.3 1.705 0 1.405.9 1.705 1.55 1.705.75 0 1.1-.351 1.1-.351v.502s-.4.3-1.4.3c-1.05 0-2.3-.45-2.3-2.156 0-1.505 1-2.207 2.4-2.207zm-10.7.4v1.606h.5c.6 0 .95-.352.95-.854 0-.601-.3-.752-.85-.752h-.6zm4.75 0v1.305h.45c.5 0 .95-.151.95-.703 0-.502-.3-.602-.8-.602h-.6zm.05 1.706v1.755h.6c.65 0 1.05-.3 1.1-.902 0-.602-.3-.853-1.1-.853h-.6z" />
  </svg>
);

export const RoyalBankOfCanadaColoredIcon: FC<SVGProps<SVGSVGElement>> = (
  props
) => (
  <svg
    role="img"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
    fill="none"
  >
    <title>Royal Bank of Canada</title>
    <g clipPath="url(#a)">
      <path
        fill="#0059B3"
        d="M21 21.047c0 .8053-.3176 1.2349-.9529 1.5033C17.6118 23.5168 14.7529 24 12 24c-2.75294 0-5.61176-.4832-8.04706-1.4497C3.31765 22.2819 3 21.8523 3 21.047V0h18v21.047Z"
      />
      {/*<path*/}
      {/*  stroke="#fff"*/}
      {/*  strokeWidth="1"*/}
      {/*  d="M21 21.047c0 .8053-.3176 1.2349-.9529 1.5033C17.6118 23.5168 14.7529 24 12 24c-2.75294 0-5.61176-.4832-8.04706-1.4497C3.31765 22.2819 3 21.8523 3 21.047V0h18v21.047Z"*/}
      {/*/>*/}
      <path
        fill="#FFDF01"
        d="M7.82724 12.7368c-2.49834-1.5263-3.34883-2.2105-3.40199-3.26312 0-.21052.05316-.57894.10631-.78947l-.21262-.15789C4.10631 8.84211 4 9.21053 4 9.57895c0 .57895.21262 1.05265.42525 1.36845.37209.5263.74419.8947 1.64784 1.5263.95681.7368 1.64784 1.5789 2.01993 2.4737h.15947v-1c1.3289.7368 2.49831 1.421 3.08301 2.6842h.1595c-.2658-1.2632-1.01-2.2632-3.66776-3.8948Zm7.33556-3.36838c-.5316.26316-.9037.57895-1.2758 1.05268l1.1163-.0527c.0532-.52629.1063-.84208.1595-.99998Zm4.0399 3.94738c.1063-.2632.2126-.579.2126-.8421l-1.6479-.1053c-.0531.4211-.1594.7895-.3189 1.1579l1.7542-.2105Zm-1.7542-4.05264c.1063.31579.2126.63158.2658.89474l.9568-.0526c-.3189-.36846-.7442-.63162-1.2226-.84214Zm-.4252.94734c-.1064-.36839-.2658-.78945-.4784-1.15787h-.5316c-.1595.36842-.2658.78948-.3721 1.21057l1.3821-.0527Zm.7973.5263c.0532.4211.0532.7895.0532 1.1579l1.5946-.1052c-.0531-.3684-.1594-.6842-.3189-1l-1.3289-.0527Zm-.5316 1.1579c0-.421-.0531-.7894-.1594-1.2105l-1.5947-.0526c-.1063.4737-.1595.9473-.2126 1.3684l1.9667-.1053Zm.2127-3.36838.2126-.26316-.2658-.36842.0532-.10527.7973.42106-.1595.52631c.1063.05263.2658.1579.4253.26316l.5315-.8421-1.3289-.68422h-2.9767l-2.4452 1.42106c.4784.31579.8505.63158 1.1694 1 .6379-.94737 1.8074-1.52632 2.9236-1.52632.2658 0 .6911.05263 1.0632.1579Zm-6.0067-.05264 1.3289-.78947c-.2658-.15789-.5847-.21053-.9036-.21053-.4784 0-1.2226.21053-1.5947.26316.1594.10527.7973.47369 1.1694.73684Zm.319-3c-.4785-.10526-.7442-.05263-1.01.21053.1595.05263.3189.10526.4784.10526.2658-.05263.4252-.21052.5316-.31579Zm7.5481 11.21052h-.1594c0-.9474-.8505-1.1579-1.7542-1.1579h-2.8173c.1063.4737.1063 1 .0532 1.4737h-.1595c-.2658-2.0526-1.4352-3.1053-3.083-4.2105v.9473h-.1595c-.4253-1-1.38207-1.8947-2.33888-2.5263l-.74418-.5263v1h-.15947c-.3721-1-1.11628-1.78946-2.07309-2.6842-1.06313-.94737-1.54153-1.52632-1.75416-2.21053C4.05316 6.36842 4 6.05263 4 5.63158c0-.78948.37209-1.52632.90365-1.78947v.36842c-.26578.31579-.37209.73684-.37209 1.15789 0 .36842.10631.84211.26578 1.21053C5.43522 7.73684 7.45515 9.1579 8.78405 10c4.09305 2.6842 4.89035 3.1579 5.58135 4.6316.0532.1579.1595.3684.2127.6316.5847-.1053 2.7109-.4211 3.1362-.4737.0531 0 .2126-.0527.3189-.0527.3721-.2105.6379-.5263.9037-.8947l-1.5416-.1053c-.0531.1579-.1594.3158-.2126.4211h-.1063c.0532-.1579.0532-.3158.1063-.4737l-.4252-.0526v-.1053l.4252-.0526c.1063-.4211.1063-.8421.1063-1.2105l-1.9667-.1053v.5789h-.1064c-.0531-.2105-.0531-.3684-.1063-.5789h-.4252v-.1053h.4252c-.0531-.4737-.0531-.9473-.0531-1.421l-1.1695-.0527.1595.3158c.2658.6842.2126 1.4737.1063 1.8421h-.1594c0-.421-.1595-.9473-.319-1.2631-.3189-.7369-1.0099-1.4211-2.2325-2.15791v.94741h-.1595C10.9103 9 9.90033 8.31579 8.41196 7.57895c-1.22259-.63158-1.59468-1.36842-1.54153-2.52632l.42525.26316C7.40199 6.36842 8.25249 7 9.10299 7c.53156 0 1.01001-.05263 1.48841-.15789.691-.1579 1.2757-.26316 1.8073-.05264v-.63158h-.4253c-.1594.10527-.4252.26316-.8505.26316-.4784 0-1.38204-.26316-1.38204-1.26316 0-.89473.74414-.99999 1.32894-.99999h1.0631c.1595 0 .2126-.05264.3189-.10527.0532-.05263.1063-.15789.1063-.21052V2.73684H9.74086v1.10527l-1.06312-.42106v-.26316h.53156v-.42105H7.34884v-.89473h-.63788c-.37209 0-.74418.21052-.79734.68421 0 .47368.15947.8421.63787.8421h.10632v.52632h-.10632c-.79734 0-1.43521-.57895-1.43521-1.42106C5.11628 1.63158 5.80731 1 6.71096 1h1.38206v.89474h5.31558v1.36842c0 .21052 0 .52631-.0531.73684 0 .1579-.0532.36842-.319.57895-.1594.10526-.4252.15789-.7973.15789-.3189 0-.6379 0-.9568-.05263-.5847-.05263-.7974.21053-.7974.42105v.1579c.2658-.21053.6911-.36842 1.1163-.21053.7974.26316 1.01.26316 1.4352-.05263l.0532.10526c-.0532.05263-.1063.1579-.2658.26316h.3721v2.10526l1.2226-.73684h3.402l1.6478.84211c.2127.10526.2658.26316.319.42105 0 .15789 0 .36842-.1063.47368-.0532.10527-.4253.73685-.6379 1.05264.6379.68418.9568 1.52628.9568 2.42108 0 .8947-.3189 2-1.3821 2.8421.4253.1052.7442.3684 1.01.7368l-.2658 1.1579Z"
      />
      <path
        fill="#fff"
        d="M12.1556 21.4253h-.6223v-2.0115h.6223c.8296 0 1.1407.2873 1.1407.977-.0519.6897-.4667 1.0345-1.1407 1.0345Zm-.0519-3.9655c.5185 0 .8296.1149.8296.6896 0 .6322-.4666.8046-.9852.8046h-.4666v-1.4942h.6222Zm.9852 1.6666c.4667-.0574.8815-.4597.8815-1.0344 0-.5173-.2074-1.092-1.6074-1.092h-2.3334v.0575c.0519 0 .2074.1149.2593.1724.1555.1724.2074.4023.2074.7471v3.9081h1.9185c1.0889 0 1.8148-.4598 1.8148-1.4943.0519-.8621-.5185-1.2069-1.1407-1.2644Zm-6.5852-1.6666h.67408c.57037 0 .88148.1724.88148.862 0 .5748-.36296.9771-.98519.9771h-.51851v-1.8391H6.5037Zm1.81482 4.4253h1.24444l-1.6074-2.2989c.62222-.1724 1.14074-.5747 1.14074-1.3218 0-.8621-.46667-1.2644-1.60741-1.2644H5v.0575c.1037.0574.20741.1149.25926.1724.15555.1724.20741.4598.20741.8621v3.7931H6.5037v-2.184h.36297l1.45185 2.184Zm10.05928-4.1954c.2592.1724.3629.4023.3629.4023h.0519L19 17.2874S18.5852 17 17.6519 17c-1.4519 0-2.4889.8046-2.4889 2.5287 0 1.9541 1.2963 2.4713 2.3851 2.4713C18.5852 22 19 21.6552 19 21.6552v-.5747s-.363.4023-1.1407.4023c-.6741 0-1.6074-.3449-1.6074-1.9541 0-1.4942.5703-1.954 1.3481-1.954.4148-.1149.6222 0 .7778.115Z"
      />
    </g>
    <defs>
      <clipPath id="a">
        <path fill="#fff" d="M0 0h24v24H0z" />
      </clipPath>
    </defs>
  </svg>
);
