import { FC, SVGProps } from 'react';

export const ModernaIcon: FC<SVGProps<SVGSVGElement>> = (props) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    viewBox="0 0 24 5.34"
    fill="currentColor"
    {...props}
  >
    <path d="M22.09599 5.06046h-.35205c-.0839 0-.12396.04717-.12396.14197 0 .09102.04407.13842.12396.13842h1.36013c.0839 0 .12796-.0474.12796-.13842 0-.0908-.04406-.1422-.12796-.1422H22.096zm-1.91203 0h-.33603c-.0801 0-.12395.04717-.12395.14197 0 .09102.04406.13842.12395.13842h1.29605c.0839 0 .12395-.0474.12395-.13842 0-.0908-.04005-.1422-.12395-.1422h-.96002Zm-1.96788 0h-.33603c-.08411 0-.12017.04717-.12017.14197 0 .09102.03606.13842.12017.13842h1.30006c.0839 0 .12395-.0474.12395-.13842 0-.0908-.04006-.1422-.12395-.1422h-.96403zm-2.03219 0h-.33603c-.0839 0-.12395.04717-.12395.14197 0 .09102.04005.13842.12417.13842h1.29605c.0839 0 .12395-.0474.12395-.13842 0-.0908-.04006-.1422-.12395-.1422h-.96024zm-1.96388 0h-.33603c-.0839 0-.12395.04717-.12395.14197 0 .09102.04006.13842.12395.13842h1.29605c.0839 0 .12395-.0474.12395-.13842 0-.0908-.04005-.1422-.12395-.1422h-.96002Zm-1.94407 0h-.35182c-.08412 0-.12818.04717-.12818.14197 0 .09102.04406.13842.12818.13842h1.3559c.0839 0 .12796-.0474.12796-.13842 0-.0908-.04406-.1422-.12796-.1422h-1.00408zm-1.98813 0h-.33603c-.0839 0-.12373.04717-.12373.14197 0 .09102.04006.13842.12396.13842h1.29604c.0839 0 .12396-.0474.12396-.13842 0-.0908-.03606-.1422-.12396-.1422h-.96024Zm-1.96387 0H7.9879c-.0839 0-.12395.04717-.12395.14197 0 .09102.04005.13842.12395.13842h1.30005c.08011 0 .12017-.0474.12017-.13842 0-.0908-.04006-.1422-.12017-.1422h-.96402zm-1.96388 0h-.33603c-.08411 0-.12395.04717-.12395.14197 0 .09102.04006.13842.12395.13842h1.29605c.0839 0 .12395-.0474.12395-.13842 0-.0908-.04005-.1422-.12395-.1422h-.96002Zm-1.9681 0h-.33202c-.0839 0-.12396.04717-.12396.14197 0 .09102.04006.13842.12396.13842h1.29604c.08412 0 .12395-.0474.12395-.13842 0-.0908-.04005-.1422-.12395-.1422h-.96402zm-1.9641 0h-.33603c-.0839 0-.12373.04717-.12373.14197 0 .09102.04006.13842.12396.13842H3.3881c.0839 0 .12395-.0474.12395-.13842 0-.0908-.04005-.1422-.12395-.1422h-.96024Zm-1.96788 0H.12395c-.0839 0-.12017.04717-.12017.14197 0 .09102.03628.13842.12017.13842h1.30028c.0839 0 .12395-.0474.12395-.13842 0-.0908-.04006-.1422-.12395-.1422H.45998ZM.004 1.0468h.36407v.49404c.12396-.18182.25592-.31222.38788-.39923C.94 1.031 1.13204.9718 1.3321.9718c.13574 0 .26392.0276.39188.079.12017.05119.2241.1264.29998.2172.0761.087.14398.21741.20006.3832.12017-.2212.27194-.391.45197-.5096a1.07818 1.07818 0 0 1 .58393-.1698c.19606 0 .36807.0474.51628.15021.14777.09859.25592.237.3318.41481.07188.17358.10793.4424.10793.794v1.55241h-.36785v-1.5524c0-.30421-.02403-.51362-.06409-.62822a.56212.56212 0 0 0-.2241-.27639c-.10391-.0672-.22787-.10281-.37185-.10281-.17602 0-.33202.0554-.48.158a.92285.92285 0 0 0-.32001.4148c-.0641.17781-.10014.46622-.10014.87301v1.11h-.36385v-1.4536c0-.34381-.02003-.5768-.06008-.6992-.04407-.1224-.11594-.2212-.22387-.29241a.6676.6676 0 0 0-.37609-.1106c-.16801 0-.32401.05118-.472.154-.14398.0988-.2519.237-.324.4108-.0681.17402-.10393.4346-.10393.79v1.20502H0V1.04681ZM6.28797.97182c.42393 0 .77598.162 1.05593.474.25592.2884.3841.62822.3841 1.02723 0 .395-.13197.7426-.4039 1.03479-.26816.29641-.61198.44662-1.03212.44662-.42393 0-.76797-.1502-1.0359-.4464-.27217-.29241-.40413-.64001-.40413-1.03501s.12796-.73482.3841-1.02322c.27193-.316.62399-.478 1.05192-.478zm0 .35962c-.29597 0-.54788.1106-.75996.33558-.21207.2212-.32.49403-.32.81381 0 .2014.04806.39122.14398.57281a1.04592 1.04592 0 0 0 .3921.40702 1.0526 1.0526 0 0 0 .53988.14598c.19204 0 .37608-.05118.54009-.14598.16801-.09502.29597-.23322.39188-.40702a1.20592 1.20592 0 0 0 .14398-.5728c0-.32001-.10793-.59262-.32-.81382-.20785-.22498-.45998-.33558-.75195-.33558ZM11.23203.004v3.87923h-.36006v-.482a1.56732 1.56732 0 0 1-.51183.4148 1.44136 1.44136 0 0 1-.62422.1382c-.3999 0-.74393-.1422-1.02388-.4344-.28396-.2884-.42794-.636-.42794-1.05081 0-.399.14398-.7466.43172-1.03501.28418-.2884.62822-.4306 1.03212-.4306.2321 0 .44396.0474.628.1462.19204.09858.35605.24479.49625.4424V0h.35984zM9.77999 1.35079c-.20807 0-.39189.05118-.5639.1462a1.11646 1.11646 0 0 0-.40814.4186 1.13716 1.13716 0 0 0-.15199.561c0 .2014.05207.38722.152.56502a1.1376 1.1376 0 0 0 .41213.4226c.1758.0988.35984.15021.5559.15021.20005 0 .3881-.0514.56812-.15021a1.08397 1.08397 0 0 0 .4117-.40279c.09613-.17002.1402-.36362.1402-.57303 0-.32379-.10794-.5964-.32402-.8098-.21208-.2172-.48-.3278-.792-.3278Zm4.63585 1.58824.3002.166a1.71753 1.71753 0 0 1-.34403.47801 1.48253 1.48253 0 0 1-.43996.2804 1.58022 1.58022 0 0 1-.55189.0948c-.4562 0-.81225-.154-1.06817-.4542-.25591-.3042-.38387-.64401-.38387-1.02722 0-.3634.10393-.68318.32401-.9598.27995-.35961.6478-.53742 1.10778-.53742.47222 0 .85231.18181 1.14005.54922.20407.26059.30399.58082.308.9678h-2.50798c.008.3278.10815.6004.312.80981.20005.20918.44796.316.74015.316.14398 0 .27594-.0276.4119-.075a1.1267 1.1267 0 0 0 .34004-.1976c.10393-.0908.20407-.22521.312-.4108zm0-.76642c-.04784-.1936-.11972-.3476-.20784-.46599a.954.954 0 0 0-.36385-.2766 1.09754 1.09754 0 0 0-.47222-.10682c-.27594 0-.50782.087-.70788.26882-.14398.1304-.25214.32401-.32802.5846h2.08004v-.004Zm.88814-1.1258h.3801v.4148c.11193-.162.23588-.2844.36006-.36718.12795-.07922.25992-.1224.3961-.1224.10772 0 .21587.03539.33582.09458l-.19584.30821c-.0801-.0356-.1442-.0514-.19627-.0514-.12395 0-.2479.05118-.35984.15021-.12017.09858-.20407.25658-.26816.46599-.04784.162-.07188.4898-.07188.97982v.9598h-.3803V1.0468Zm1.892 0h.36006v.5096c.14398-.1936.308-.33959.48402-.43439a1.19457 1.19457 0 0 1 .57191-.1462c.21208 0 .40012.05519.56413.162a.98027.98027 0 0 1 .35984.4344c.08011.1818.11616.4662.11616.8572v1.4576h-.36006V2.53625c0-.32802-.01602-.54522-.04406-.65582-.04006-.18559-.11995-.32801-.2439-.42281-.11594-.0908-.27194-.1422-.468-.1422-.21585 0-.41613.0712-.58793.21741-.17603.15-.28818.3278-.34003.54121-.03606.1422-.05208.40279-.05208.7702v1.04302h-.36006zm5.96395 0v2.83643h-.34782v-.48601c-.14821.18581-.316.324-.50004.4188a1.39307 1.39307 0 0 1-.61197.1422c-.39211 0-.72814-.1462-1.00008-.43839-.27594-.2884-.41614-.64-.41614-1.05882 0-.40279.1402-.7544.42015-1.0468C20.98398 1.1258 21.32.9796 21.7121.9796c.22788 0 .43172.0474.61598.15021.18382.0988.34382.2488.48402.4464v-.5214h.34782zm-1.416.2766c-.19583 0-.37986.0512-.55188.15-.16802.1028-.29597.241-.40012.42281a1.19502 1.19502 0 0 0-.14799.5688c0 .2014.05208.395.14799.57281a1.12914 1.12914 0 0 0 .40412.4266c.17202.0988.34805.154.54388.154.19205 0 .3801-.05119.55612-.154.17202-.0988.30398-.237.4039-.4068.09213-.17001.13597-.3674.13597-.58081 0-.3278-.10393-.6044-.312-.8216-.21586-.2212-.476-.3318-.77998-.3318zm2.01217-.2806c.03983 0 .0839.008.11995.0238a.20295.20295 0 0 1 .0919.0908c.02404.0396.03205.079.03205.1264 0 .04361-.00801.083-.02804.1224a.28707.28707 0 0 1-.0919.091c-.04407.01981-.08012.0276-.12396.0276a.24479.24479 0 0 1-.12017-.0276.28863.28863 0 0 1-.0919-.09079.25102.25102 0 0 1-.02804-.1224c0-.04761.008-.087.02803-.12661.02404-.0356.05608-.07121.09191-.0908.04006-.0158.08412-.0238.12017-.0238zm0 .0316a.1827.1827 0 0 0-.10014.0278.15466.15466 0 0 0-.07588.075.20273.20273 0 0 0-.02804.10682c0 .03538.008.06698.02804.09858a.15466.15466 0 0 0 .07588.075.19227.19227 0 0 0 .10014.02781.19583.19583 0 0 0 .10393-.02781.15377.15377 0 0 0 .07588-.075c.01602-.0356.02804-.0672.02804-.0988 0-.0356-.01202-.07121-.02804-.1066a.1718.1718 0 0 0-.07588-.075.1867.1867 0 0 0-.10393-.0278zm-.10415.3438v-.2648h.08813c.03583 0 .05585 0 .07188.004.01201.008.02403.0158.03204.0276a.0632.0632 0 0 1 .01202.0356.07455.07455 0 0 1-.02003.0514.13686.13686 0 0 1-.06008.0236c.01201.004.01602.008.02403.012.00801.0118.02003.0276.03605.0552l.03605.0514h-.05608l-.02003-.03939c-.02002-.0316-.03182-.0554-.04383-.0632a.07633.07633 0 0 0-.03205-.008h-.02403v.1146zm.04006-.1502h.05207c.02404 0 .04384 0 .05185-.0078.01202-.008.01603-.0158.01603-.0278a.03004.03004 0 0 0-.00801-.0196.03115.03115 0 0 0-.01603-.0158c-.008 0-.0238-.004-.04784-.004h-.04406v.075z" />
  </svg>
);

export const ModernaColorIcon: FC<SVGProps<SVGSVGElement>> = (props) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    fill="currentColor"
    viewBox="0 0 24 5.34"
    {...props}
  >
    <path
      fill="#2AACE2"
      fillRule="evenodd"
      d="M99.292 22.74H97.71c-.377 0-.557.212-.557.638 0 .409.198.622.557.622h6.112c.377 0 .575-.213.575-.622 0-.408-.198-.639-.575-.639h-4.53z"
      clip-rule="evenodd"
    />
    <path
      fill="#3FB4E5"
      fillRule="evenodd"
      d="M90.7 22.74h-1.51c-.36 0-.557.212-.557.638 0 .409.198.622.557.622h5.824c.377 0 .557-.213.557-.622 0-.408-.18-.639-.557-.639H90.7z"
      clip-rule="evenodd"
    />
    <path
      fill="#4CB9E7"
      fillRule="evenodd"
      d="M81.857 22.74h-1.51c-.378 0-.54.212-.54.638 0 .409.162.622.54.622h5.842c.377 0 .557-.213.557-.622 0-.408-.18-.639-.557-.639h-4.332z"
      clip-rule="evenodd"
    />
    <path
      fill="#58BEE9"
      fillRule="evenodd"
      d="M72.725 22.74h-1.51c-.377 0-.557.212-.557.638 0 .409.18.622.558.622h5.824c.377 0 .557-.213.557-.622 0-.408-.18-.639-.557-.639h-4.315z"
      clip-rule="evenodd"
    />
    <path
      fill="#65C3EB"
      fillRule="evenodd"
      d="M63.9 22.74h-1.51c-.377 0-.557.212-.557.638 0 .409.18.622.557.622h5.824c.377 0 .557-.213.557-.622 0-.408-.18-.639-.557-.639H63.9z"
      clip-rule="evenodd"
    />
    <path
      fill="#72C8EC"
      fillRule="evenodd"
      d="M55.164 22.74h-1.581c-.378 0-.576.212-.576.638 0 .409.198.622.576.622h6.093c.377 0 .575-.213.575-.622 0-.408-.198-.639-.575-.639h-4.512z"
      clip-rule="evenodd"
    />
    <path
      fill="#7FCDEE"
      fillRule="evenodd"
      d="M46.23 22.74h-1.51c-.377 0-.556.212-.556.638 0 .409.18.622.557.622h5.824c.377 0 .557-.213.557-.622 0-.408-.162-.639-.557-.639H46.23z"
      clip-rule="evenodd"
    />
    <path
      fill="#8CD2F0"
      fillRule="evenodd"
      d="M37.405 22.74h-1.51c-.377 0-.557.212-.557.638 0 .409.18.622.557.622h5.842c.36 0 .54-.213.54-.622 0-.408-.18-.639-.54-.639h-4.332z"
      clip-rule="evenodd"
    />
    <path
      fill="#98D7F1"
      fillRule="evenodd"
      d="M28.58 22.74h-1.51c-.378 0-.557.212-.557.638 0 .409.18.622.557.622h5.824c.377 0 .557-.213.557-.622 0-.408-.18-.639-.557-.639H28.58z"
      clip-rule="evenodd"
    />
    <path
      fill="#A5DCF3"
      fillRule="evenodd"
      d="M19.736 22.74h-1.492c-.377 0-.557.212-.557.638 0 .409.18.622.557.622h5.824c.378 0 .557-.213.557-.622 0-.408-.18-.639-.557-.639h-4.332z"
      clip-rule="evenodd"
    />
    <path
      fill="#B2E1F5"
      fillRule="evenodd"
      d="M10.91 22.74H9.4c-.377 0-.556.212-.556.638 0 .409.18.622.557.622h5.824c.377 0 .557-.213.557-.622 0-.408-.18-.639-.557-.639H10.91z"
      clip-rule="evenodd"
    />
    <path
      fill="#BFE6F6"
      fillRule="evenodd"
      d="M2.067 22.74H.557c-.377 0-.54.212-.54.638 0 .409.163.622.54.622H6.4c.377 0 .557-.213.557-.622 0-.408-.18-.639-.557-.639H2.067z"
      clip-rule="evenodd"
    />
    <path
      fill="#E31837"
      fillRule="evenodd"
      d="M.018 4.704h1.636v2.22c.557-.817 1.15-1.403 1.743-1.794.827-.497 1.69-.763 2.589-.763.61 0 1.186.124 1.761.355.54.23 1.007.568 1.348.976.342.391.647.977.899 1.722.54-.994 1.222-1.757 2.031-2.29a4.845 4.845 0 0 1 2.624-.763c.881 0 1.654.213 2.32.675.664.443 1.15 1.065 1.491 1.864.323.78.485 1.988.485 3.568v6.976h-1.653v-6.976c0-1.367-.108-2.308-.288-2.823a2.526 2.526 0 0 0-1.007-1.242c-.467-.302-1.024-.462-1.671-.462-.791 0-1.492.249-2.157.71a4.147 4.147 0 0 0-1.438 1.864c-.288.799-.45 2.095-.45 3.923v4.988H8.646V10.9c0-1.545-.09-2.592-.27-3.142-.198-.55-.521-.994-1.006-1.314a3 3 0 0 0-1.69-.497c-.755 0-1.456.23-2.121.692-.647.444-1.132 1.065-1.456 1.846-.306.782-.467 1.953-.467 3.55v5.415H0V4.704h.018zm28.238-.337c1.905 0 3.487.728 4.745 2.13 1.15 1.296 1.726 2.823 1.726 4.616 0 1.775-.593 3.337-1.815 4.65-1.205 1.332-2.75 2.007-4.638 2.007-1.905 0-3.451-.675-4.655-2.006-1.223-1.314-1.816-2.876-1.816-4.651s.575-3.302 1.726-4.598c1.222-1.42 2.804-2.148 4.727-2.148zm0 1.616c-1.33 0-2.462.497-3.415 1.508-.953.994-1.438 2.22-1.438 3.657 0 .905.216 1.758.647 2.574a4.7 4.7 0 0 0 1.762 1.829 4.73 4.73 0 0 0 2.426.656c.863 0 1.69-.23 2.427-.656.755-.427 1.33-1.048 1.761-1.829a5.419 5.419 0 0 0 .647-2.574c0-1.438-.485-2.663-1.438-3.657-.934-1.011-2.067-1.508-3.379-1.508zM50.473.018V17.45h-1.618v-2.166a7.043 7.043 0 0 1-2.3 1.864 6.477 6.477 0 0 1-2.805.621c-1.797 0-3.343-.639-4.601-1.952-1.276-1.296-1.923-2.858-1.923-4.722 0-1.793.647-3.355 1.94-4.651 1.277-1.296 2.823-1.935 4.638-1.935 1.043 0 1.995.213 2.822.657.863.443 1.6 1.1 2.23 1.988V0h1.617v.018zM43.948 6.07c-.935 0-1.761.23-2.534.657a5.017 5.017 0 0 0-1.834 1.881 5.11 5.11 0 0 0-.683 2.521c0 .905.234 1.74.683 2.539a5.112 5.112 0 0 0 1.852 1.899c.79.444 1.617.675 2.498.675.899 0 1.744-.231 2.553-.675a4.871 4.871 0 0 0 1.85-1.81c.432-.764.63-1.634.63-2.575 0-1.455-.485-2.68-1.456-3.639-.953-.976-2.157-1.473-3.559-1.473zm20.832 7.137 1.349.746a7.718 7.718 0 0 1-1.546 2.148 6.662 6.662 0 0 1-1.977 1.26 7.101 7.101 0 0 1-2.48.426c-2.05 0-3.65-.692-4.8-2.041-1.15-1.367-1.725-2.894-1.725-4.616 0-1.633.467-3.07 1.456-4.313 1.258-1.616 2.911-2.415 4.978-2.415 2.122 0 3.83.817 5.123 2.468.917 1.171 1.366 2.61 1.384 4.349h-11.27c.036 1.473.486 2.698 1.402 3.639.899.94 2.013 1.42 3.326 1.42.647 0 1.24-.124 1.851-.337a5.063 5.063 0 0 0 1.528-.888c.467-.408.917-1.012 1.402-1.846zm0-3.444c-.215-.87-.538-1.562-.934-2.094a4.287 4.287 0 0 0-1.635-1.243 4.932 4.932 0 0 0-2.122-.48c-1.24 0-2.282.391-3.181 1.208-.647.586-1.133 1.456-1.474 2.627h9.347v-.018zm3.991-5.059h1.708v1.864c.503-.728 1.06-1.278 1.618-1.65.575-.356 1.168-.55 1.78-.55.484 0 .97.159 1.509.425l-.88 1.385c-.36-.16-.648-.231-.882-.231-.557 0-1.114.23-1.617.675-.54.443-.917 1.153-1.205 2.094-.215.728-.323 2.201-.323 4.403v4.313H68.77V4.704zm8.502 0h1.618v2.29c.647-.87 1.384-1.526 2.175-1.952a5.368 5.368 0 0 1 2.57-.657c.953 0 1.798.248 2.535.728a4.405 4.405 0 0 1 1.617 1.952c.36.817.522 2.095.522 3.852v6.55h-1.618v-6.07c0-1.474-.072-2.45-.198-2.947-.18-.834-.539-1.474-1.096-1.9-.521-.408-1.222-.639-2.103-.639-.97 0-1.87.32-2.642.977-.791.674-1.295 1.473-1.528 2.432-.162.639-.234 1.81-.234 3.461v4.687h-1.618V4.704zm26.8 0V17.45h-1.563v-2.184c-.666.835-1.42 1.456-2.247 1.882a6.26 6.26 0 0 1-2.75.639c-1.762 0-3.272-.657-4.494-1.97-1.24-1.296-1.87-2.876-1.87-4.758 0-1.81.63-3.39 1.888-4.704 1.258-1.296 2.768-1.953 4.53-1.953 1.024 0 1.94.213 2.768.675.826.444 1.545 1.118 2.175 2.006V4.74h1.563v-.036zM97.71 5.947c-.88 0-1.707.23-2.48.674-.755.462-1.33 1.083-1.798 1.9a5.37 5.37 0 0 0-.665 2.556c0 .905.234 1.775.665 2.574a5.074 5.074 0 0 0 1.816 1.917c.773.444 1.564.692 2.444.692.863 0 1.708-.23 2.499-.692.773-.444 1.366-1.065 1.815-1.828.414-.764.611-1.651.611-2.61 0-1.473-.467-2.716-1.402-3.692-.97-.994-2.139-1.491-3.505-1.491zm9.042-1.261c.179 0 .377.036.539.107a.912.912 0 0 1 .413.408c.108.178.144.355.144.568 0 .196-.036.373-.126.55a1.29 1.29 0 0 1-.413.409c-.198.089-.36.124-.557.124a1.1 1.1 0 0 1-.54-.124 1.297 1.297 0 0 1-.413-.408 1.128 1.128 0 0 1-.126-.55c0-.214.036-.391.126-.569.108-.16.252-.32.413-.408.18-.071.378-.107.54-.107zm0 .142a.821.821 0 0 0-.45.125.695.695 0 0 0-.341.337.911.911 0 0 0-.126.48c0 .159.036.301.126.443a.695.695 0 0 0 .341.337.864.864 0 0 0 .45.125.88.88 0 0 0 .467-.125.691.691 0 0 0 .341-.337c.072-.16.126-.302.126-.444 0-.16-.054-.32-.126-.479a.772.772 0 0 0-.341-.337.839.839 0 0 0-.467-.125zm-.468 1.545v-1.19h.396c.161 0 .251 0 .323.018.054.036.108.071.144.124a.284.284 0 0 1 .054.16.335.335 0 0 1-.09.231.615.615 0 0 1-.27.106c.054.018.072.036.108.054.036.053.09.124.162.248l.162.231h-.252l-.09-.177c-.09-.142-.143-.249-.197-.284a.343.343 0 0 0-.144-.036h-.108v.515h-.198zm.18-.675h.234c.108 0 .197 0 .233-.035.054-.036.072-.071.072-.125a.135.135 0 0 0-.036-.088.14.14 0 0 0-.072-.071c-.036 0-.107-.018-.215-.018h-.198v.337h-.018z"
      clip-rule="evenodd"
    />
  </svg>
);
