import { FC, SVGProps } from 'react';

export const CapitalOneIcon: FC<SVGProps<SVGSVGElement>> = (props) => (
  <svg
    role="img"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg"
    fill="currentColor"
    {...props}
  >
    <title>Capital One</title>
    <path d="M15.55 13.706c.015.487.326.883.728.883.778 0 1.109-.954 1.089-1.596-.015-.487-.331-.888-.733-.888-.678.01-1.11.958-1.084 1.6zm-.411-.025c-.03-.834.622-1.682 1.566-1.682.632 0 1.044.422 1.069 1.07.03.877-.578 1.68-1.566 1.68-.633 0-1.05-.42-1.07-1.069zm-8.96-.221a.6.6 0 0 1-.13.035c-.055.01-.15.03-.296.05a.47.47 0 0 0-.206.065c-.035.03-.06.06-.065.1-.01.045.005.076.045.106.04.025.1.04.19.04.066 0 .131-.01.197-.03.065-.02.12-.05.16-.085.03-.025.05-.06.07-.1.005-.026.02-.086.035-.181zm.824-.507a2.388 2.388 0 0 1-.035.26l-.141.784c-.01.07.015.125.08.16l-.005.03h-.798l-.005-.2a1.59 1.59 0 0 1-.382.165 1.47 1.47 0 0 1-.381.045c-.256 0-.407-.025-.507-.115-.105-.09-.156-.15-.15-.281a.44.44 0 0 1 .095-.231.567.567 0 0 1 .211-.146c.08-.04.18-.065.321-.09a6.58 6.58 0 0 1 .598-.065c.135-.01.22-.045.26-.06.056-.02.076-.046.086-.091.015-.08-.01-.126-.115-.146-.286-.055-.823.035-1.104.106l.15-.407a7.014 7.014 0 0 1 1.07-.085c.57-.01.757.156.752.367zm2.308 1.23.276-1.562h.763l-.276 1.561h-.763Zm.317-1.923c.025-.13.226-.23.451-.23.226 0 .392.105.372.23-.025.13-.226.231-.452.231-.23.005-.391-.1-.371-.23zm3.427 1.205c-.035.01-.08.025-.13.035-.055.015-.15.03-.296.05a.47.47 0 0 0-.206.065.149.149 0 0 0-.065.1c-.01.046.01.08.045.106.04.025.1.04.19.04.066 0 .131-.01.197-.03.065-.02.12-.05.16-.085.03-.025.05-.06.07-.1.005-.026.02-.086.035-.181zm.824-.512a1.652 1.652 0 0 1-.04.26l-.141.784c-.01.07.015.125.075.16l-.005.026h-.798l-.005-.2c-.115.07-.256.13-.381.165a1.307 1.307 0 0 1-.382.045c-.256 0-.401-.026-.507-.116-.105-.09-.155-.15-.15-.28a.425.425 0 0 1 .095-.232.635.635 0 0 1 .211-.15c.08-.04.181-.065.316-.09.141-.02.337-.046.603-.066a.9.9 0 0 0 .26-.055c.056-.02.076-.045.086-.09.015-.08-.01-.126-.115-.146-.287-.056-.824.035-1.104.105l.15-.407c.366-.055.708-.09 1.069-.09.582.006.768.166.763.377zm-9.305.668a2.73 2.73 0 0 1-.633.07c-.366 0-.652-.181-.637-.512.01-.221.27-.688.938-.688.211 0 .372.035.593.161l.095-.542a1.763 1.763 0 0 0-.753-.126c-.873.01-1.706.407-1.812 1.21-.105.818.894 1.023 1.335 1.023.256 0 .522-.01.773-.035l.1-.562zm6.193-1.004.055-.317.798-.175-.085.492h.391l-.075.316h-.377l-.23 1.255s-.769-.005-.773 0l.23-1.25h-.29l.06-.316h.296zm3.885 1.565h-.778l.391-2.173.758.02zm-6.35-1.194c-.1 0-.19.03-.27.09-.08.06-.13.15-.15.267-.026.135-.01.235.044.296.056.06.13.09.236.09.07 0 .14-.01.196-.04a.38.38 0 0 0 .15-.13.54.54 0 0 0 .086-.206c.02-.126.005-.216-.056-.276a.322.322 0 0 0-.235-.091Zm-1.39 1.731.372-2.088h.668l-.05.267c.06-.08.15-.146.28-.201.13-.055.277-.09.432-.09.176 0 .281.01.412.075.13.07.22.165.27.296a.8.8 0 0 1 .036.427.934.934 0 0 1-.377.612c-.205.15-.386.19-.652.19-.096 0-.17-.01-.236-.025a.421.421 0 0 1-.15-.06.823.823 0 0 1-.126-.115l-.125.718h-.753v-.006zm13.843-1.54c-.005-.126-.065-.211-.196-.211-.311 0-.648.612-.703.858.512.005.909-.301.899-.647zm.065.963.06.04c-.15.312-.461.563-.828.563-.296 0-.542-.2-.557-.572-.025-.668.602-1.29 1.114-1.29.221 0 .422.096.432.331.02.532-.728.693-1.22.703a.714.714 0 0 0-.02.196c.01.22.14.407.417.407.246-.001.481-.192.602-.377zm-3.057-.978c.056-.005.14-.015.176-.015.055 0 .11.01.11.065 0 .035-.06.27-.07.326l-.12.522c-.05.216-.1.442-.146.617h.306l.17-.833c.523-.547.728-.723.849-.723.055 0 .095.03.095.096.006.096-.055.316-.075.376l-.176.607c-.04.136-.07.261-.065.347.005.135.085.19.206.19.22 0 .386-.23.527-.461l-.04-.075c-.056.09-.191.29-.296.29-.036 0-.066-.02-.066-.075-.005-.07.026-.176.045-.246l.196-.708c.05-.195.076-.32.076-.386-.005-.13-.08-.196-.2-.196-.201 0-.468.146-1.035.798h-.01l.07-.316c.041-.176.076-.356.116-.482-.196.07-.477.15-.647.181l.004.1zm3.328-.567a.27.27 0 0 1 .276-.271c.146 0 .276.115.276.27a.27.27 0 0 1-.276.271.265.265 0 0 1-.276-.27zm.276.23a.22.22 0 0 0 .22-.226.218.218 0 0 0-.22-.226.218.218 0 0 0-.22.226c0 .131.095.226.22.226zm-.055-.07h-.05v-.311h.12c.076 0 .11.025.11.09 0 .056-.034.08-.08.085l.091.136h-.055l-.08-.136h-.056zm.055-.175c.04 0 .076-.006.076-.05 0-.04-.036-.046-.07-.046h-.066v.096zm-6.33 1.49c-.798.567-1.741 1.16-2.755 1.777l-.04.025a.027.027 0 0 0-.005.04c.01.016.03.016.04.006l.035-.02c.858-.447 1.847-.984 2.84-1.531l.016-.01a1.414 1.414 0 0 1-.13-.287zm5.225-4.23c-1.255-1.386-9.325-.142-12.758.611l-.08.016a.038.038 0 0 0-.026.035c.006.015.02.025.036.025l.08-.015c2.845-.507 8.758-1.21 10.033.055.386.387.296.883-.156 1.466.24.155.417.402.492.707 1.757-1.17 2.941-2.283 2.379-2.9z" />
  </svg>
);

export const CapitalOneColoredIcon: FC<SVGProps<SVGSVGElement>> = (props) => (
  <svg
    role="img"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
    fill="none"
  >
    <title>7eleven</title>
    <path
      fill="#147350"
      d="M15.92 17.5c.34 0 .6422.2933.6422.6233 0 .33-.2644.6234-.6422.6234-.34 0-.6044-.2934-.6044-.6234 0-.33.2644-.6233.6044-.6233Zm0 1.1c.2644 0 .4911-.22.4911-.4767 0-.2933-.2267-.4766-.4911-.4766-.2644 0-.4911.22-.4911.4766 0 .2934.2267.4767.4911.4767Zm-.0756-.1467h-.1133v-.66h.2267c.1511 0 .2266.0734.2266.22 0 .11-.0755.1834-.1511.1834l.1511.2566h-.1511l-.1511-.2566h-.0378v.2566Zm.0756-.3666c.0756 0 .1133-.0367.1133-.11 0-.0734-.0377-.11-.1133-.11h-.0756v.1833h.0756v.0367ZM18.9422 12.8433c-.34 0-.5666.1467-.7933.33l-.1511.22-.0378-.0366.1889-.2934V12.88H16.94v3.8867h1.0956V14.31c0-.4033.2644-.5133.4533-.55.1889-.0367.4155.0733.4155.2933v2.7134H20V14.09c0-.8433-.3778-1.2467-1.0578-1.2467ZM6.74 15.8867h1.13333v.8433H5.64444v-3.8867H6.74v3.0434ZM3 16.73h2.22889v-.77H4.09556v-.8433h1.13333v-.7334H4.09556V13.65h1.13333v-.8067H3V16.73ZM8.25111 16.73h2.26669v-.77H9.34667v-.8433h1.17113v-.7334H9.34667V13.65h1.17113v-.8067H8.25111V16.73ZM14.2956 16.73h2.2666v-.77h-1.1711v-.8433h1.1711v-.7334h-1.1711V13.65h1.1711v-.8067h-2.2666V16.73ZM12.86 12.8433 12.4444 15.3l-.0377.44v.0367h-.0378V15.74l-.0378-.44-.4155-2.4567H10.82l.9067 3.8867h1.36l.9066-3.8867H12.86Z"
    />
    <path
      fill="#FF6C00"
      d="M17.2422 1H3v5.5h7.5178c1.7-2.38333 4.0044-4.29 6.7244-5.5Z"
    />
    <path
      fill="#EB0F2A"
      d="M8.66667 22.9633h5.66663v-5.5H8.66667v5.5ZM20 6.5V1c-5.4022 1.43-9.6333 5.64667-10.91778 11h5.77998C15.7311 9.54333 17.62 7.56333 20 6.5Z"
    />
  </svg>
);
