import { FC, SVGProps } from 'react';

export const BillIcon: FC<SVGProps<SVGSVGElement>> = (props) => (
  <svg
    role="img"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg"
    fill="currentColor"
    {...props}
  >
    <title>bill</title>
    <path d="M11.8195 9.04933c.8127 0 1.4715-.68261 1.4715-1.52466C13.291 6.68262 12.6322 6 11.8195 6c-.8128 0-1.4716.68262-1.4716 1.52467s.6588 1.52466 1.4716 1.52466zM6.81983 15.778c0 .3762-.31493.685-.67095.685H4.22621v-4.0196h1.92267c.35824 0 .67095.3052.67095.6849zM4.2412 10.2533V6.26878H2V18.6942h4.69013c1.31946 0 2.38841-1.1629 2.38841-2.5983v-3.2443c0-1.4354-1.06895-2.5983-2.38841-2.5983zm16.6149-3.9896h-2.2525v12.4318h2.2525zm-3.9475 0H14.656v12.4318h2.2526zm-3.9493 3.9868h-2.2525v8.4449h2.2525zm-8.11129-.68905V6.36853l3.01048 2.41372c1.04256.84687 1.2403 2.07955 1.21589 2.04875-.67876-.87376-1.58524-1.25717-2.20927-1.26744Z" />
  </svg>
);

export const BillColoredIcon: FC<SVGProps<SVGSVGElement>> = (props) => (
  <svg
    role="img"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
    fill="none"
  >
    <title>bill</title>
    <path
      fill="#FF9C6C"
      d="M4.84801 9.56145V6.36853l3.01048 2.41372c1.04256.84687 1.2403 2.07955 1.21589 2.04875-.67876-.87376-1.58524-1.25717-2.20927-1.26744l-2.0171-.00211Z"
    />
    <path
      fill="#FF5A0A"
      d="M12.9593 10.2505h-2.2525v8.4449h2.2525v-8.4449ZM16.9086 6.2637H14.656v12.4318h2.2526V6.2637ZM20.8561 6.2637h-2.2525v12.4318h2.2525V6.2637ZM6.81983 15.778c0 .3762-.31493.685-.67095.685H4.22621v-4.0196h1.92267c.35824 0 .67095.3052.67095.6849v2.6497ZM4.2412 10.2533V6.26878H2V18.6942h4.69013c1.31946 0 2.38841-1.1629 2.38841-2.5983v-3.2443c0-1.4354-1.06895-2.5983-2.38841-2.5983H4.2412ZM11.8195 9.04933c.8127 0 1.4715-.68261 1.4715-1.52466C13.291 6.68262 12.6322 6 11.8195 6c-.8128 0-1.4716.68262-1.4716 1.52467s.6588 1.52466 1.4716 1.52466Z"
    />
  </svg>
);
