import { FC, SVGProps } from 'react';

export const VideoTutorialIllustration: FC<SVGProps<SVGSVGElement>> = (
  props
) => (
  <svg
    role="img"
    xmlns="http://www.w3.org/2000/svg"
    fill="none"
    viewBox="0 0 336 336"
    {...props}
  >
    <g clipPath="url(#a)">
      <mask
        id="c"
        width={316}
        height={316}
        x={10}
        y={10}
        maskUnits="userSpaceOnUse"
        style={{
          maskType: 'alpha',
        }}
      >
        <circle cx={168} cy={168} r={158} fill="url(#b)" />
      </mask>
      <g mask="url(#c)">
        <rect
          width={124}
          height={124}
          x={4}
          y={-22}
          stroke="#F8F8F8"
          strokeWidth={1.5}
          opacity={0.1}
          rx={12}
        />
        <path fill="url(#d)" d="M256-22H132v124h124V-22Z" opacity={0.5} />
        <path
          stroke="#F8F8F8"
          strokeWidth={1.5}
          d="M372-22H272c-6.627 0-12 5.373-12 12V90c0 6.627 5.373 12 12 12h100c6.627 0 12-5.373 12-12V-10c0-6.627-5.373-12-12-12Z"
          opacity={0.1}
        />
        <rect
          width={124}
          height={124}
          x={-47}
          y={234}
          stroke="#F8F8F8"
          strokeWidth={1.5}
          opacity={0.1}
          rx={12}
        />
        <g filter="url(#e)">
          <g clipPath="url(#f)">
            <rect
              width={32}
              height={32}
              x={-1}
              y={280}
              fill="#F8F8F8"
              fillOpacity={0.01}
              rx={16}
              shapeRendering="crispEdges"
            />
            <rect
              width={32}
              height={32}
              x={-1}
              y={280}
              fill="#121212"
              fillOpacity={0.3}
              rx={16}
              shapeRendering="crispEdges"
            />
            <path
              fill="#F8F8F8"
              d="M14.192 291.845a1 1 0 0 0-1.525.85v4.61a1 1 0 0 0 1.525.85l3.731-2.304a1 1 0 0 0 0-1.702l-3.73-2.304Z"
            />
          </g>
          <rect
            width={30.5}
            height={30.5}
            x={-0.25}
            y={280.75}
            stroke="url(#g)"
            strokeOpacity={0.25}
            strokeWidth={1.5}
            rx={15.25}
            shapeRendering="crispEdges"
          />
        </g>
        <rect
          width={124}
          height={124}
          x={-48}
          y={106}
          stroke="#F8F8F8"
          strokeWidth={1.5}
          opacity={0.1}
          rx={12}
        />
        <g filter="url(#h)">
          <g clipPath="url(#i)">
            <rect
              width={32}
              height={32}
              x={-2}
              y={152}
              fill="#F8F8F8"
              fillOpacity={0.01}
              rx={16}
              shapeRendering="crispEdges"
            />
            <rect
              width={32}
              height={32}
              x={-2}
              y={152}
              fill="#121212"
              fillOpacity={0.3}
              rx={16}
              shapeRendering="crispEdges"
            />
            <path
              fill="#F8F8F8"
              d="M13.192 163.845a1 1 0 0 0-1.525.85v4.61a1 1 0 0 0 1.525.85l3.731-2.304a1 1 0 0 0 0-1.702l-3.73-2.304Z"
            />
          </g>
          <rect
            width={30.5}
            height={30.5}
            x={-1.25}
            y={152.75}
            stroke="url(#j)"
            strokeOpacity={0.25}
            strokeWidth={1.5}
            rx={15.25}
            shapeRendering="crispEdges"
          />
        </g>
        <rect
          width={124}
          height={124}
          x={260}
          y={106}
          stroke="#F8F8F8"
          strokeWidth={1.5}
          opacity={0.1}
          rx={12}
        />
        <g filter="url(#k)">
          <g clipPath="url(#l)">
            <rect
              width={32}
              height={32}
              x={306}
              y={152}
              fill="#F8F8F8"
              fillOpacity={0.01}
              rx={16}
              shapeRendering="crispEdges"
            />
            <rect
              width={32}
              height={32}
              x={306}
              y={152}
              fill="#121212"
              fillOpacity={0.3}
              rx={16}
              shapeRendering="crispEdges"
            />
            <path
              fill="#F8F8F8"
              d="M321.192 163.845a1 1 0 0 0-1.525.85v4.61a1 1 0 0 0 1.525.85l3.732-2.304a1 1 0 0 0 0-1.702l-3.732-2.304Z"
            />
          </g>
          <rect
            width={30.5}
            height={30.5}
            x={306.75}
            y={152.75}
            stroke="url(#m)"
            strokeOpacity={0.25}
            strokeWidth={1.5}
            rx={15.25}
            shapeRendering="crispEdges"
          />
        </g>
        <path fill="url(#n)" d="M205 234H81v124h124V234Z" opacity={0.5} />
        <path
          stroke="#F8F8F8"
          strokeWidth={1.5}
          d="M321 234H221c-6.627 0-12 5.373-12 12v100c0 6.627 5.373 12 12 12h100c6.627 0 12-5.373 12-12V246c0-6.627-5.373-12-12-12Z"
          opacity={0.1}
        />
      </g>
      <g filter="url(#o)">
        <g clipPath="url(#p)">
          <rect
            width={176}
            height={124}
            x={80}
            y={106}
            fill="#fff"
            fillOpacity={0.05}
            rx={10}
            shapeRendering="crispEdges"
          />
          <g filter="url(#q)">
            <g clipPath="url(#r)" filter="url(#s)">
              <rect
                width={52}
                height={52}
                x={142}
                y={142}
                fill="#F8F8F8"
                fillOpacity={0.01}
                rx={26}
                shapeRendering="crispEdges"
              />
              <rect
                width={52}
                height={52}
                x={142}
                y={142}
                fill="#121212"
                fillOpacity={0.3}
                rx={26}
                shapeRendering="crispEdges"
              />
              <rect
                width={50.5}
                height={50.5}
                x={142.75}
                y={142.75}
                stroke="url(#t)"
                strokeOpacity={0.25}
                strokeWidth={1.5}
                rx={25.25}
                shapeRendering="crispEdges"
              />
              <path
                fill="#F8F8F8"
                d="M167.464 160.812c-1.773-1.165-4.131.107-4.131 2.229v7.918c0 2.122 2.358 3.394 4.131 2.229l6.025-3.959c1.603-1.054 1.603-3.404 0-4.458l-6.025-3.959Z"
              />
            </g>
            <rect
              width={58.5}
              height={58.5}
              x={138.75}
              y={138.75}
              stroke="#F8F8F8"
              strokeOpacity={0.4}
              strokeWidth={1.5}
              rx={29.25}
              shapeRendering="crispEdges"
            />
          </g>
          <g fill="#F8F8F8" filter="url(#u)">
            <rect
              width={32}
              height={22}
              x={216}
              y={114}
              fillOpacity={0.05}
              rx={4}
              shapeRendering="crispEdges"
              style={{
                mixBlendMode: 'luminosity',
              }}
            />
            <path
              fillOpacity={0.7}
              d="M228.817 129a.278.278 0 0 1-.204-.084.292.292 0 0 1-.084-.216v-1.44h-3.78a.278.278 0 0 1-.204-.084.292.292 0 0 1-.084-.216v-.972c0-.056.012-.116.036-.18a.78.78 0 0 1 .096-.18l3.516-4.824a.526.526 0 0 1 .444-.204h1.524c.08 0 .148.028.204.084a.292.292 0 0 1 .084.216v4.764h1.068c.096 0 .168.028.216.084a.278.278 0 0 1 .084.204v1.008c0 .088-.028.16-.084.216a.278.278 0 0 1-.204.084h-1.08v1.44c0 .088-.028.16-.084.216a.278.278 0 0 1-.204.084h-1.26Zm-2.496-3.276h2.244v-3.156l-2.244 3.156Zm6.984 3.276a.292.292 0 0 1-.216-.084.292.292 0 0 1-.084-.216v-7.8c0-.088.028-.16.084-.216a.292.292 0 0 1 .216-.084h1.272c.088 0 .16.028.216.084a.292.292 0 0 1 .084.216v2.736l2.472-2.808a.553.553 0 0 1 .468-.228h1.452c.072 0 .132.028.18.084a.23.23 0 0 1 .072.168.223.223 0 0 1-.048.144l-3.084 3.624 3.312 3.984c.032.032.048.08.048.144a.272.272 0 0 1-.072.18.244.244 0 0 1-.18.072h-1.5c-.144 0-.252-.032-.324-.096a4.067 4.067 0 0 1-.144-.132l-2.652-3.072v3c0 .088-.028.16-.084.216a.292.292 0 0 1-.216.084h-1.272Z"
            />
          </g>
        </g>
        <rect
          width={174.5}
          height={122.5}
          x={80.75}
          y={106.75}
          stroke="url(#v)"
          strokeOpacity={0.1}
          strokeWidth={1.5}
          rx={9.25}
          shapeRendering="crispEdges"
        />
      </g>
      <path
        stroke="url(#w)"
        strokeWidth={1.5}
        d="M-52-13V94c0 6.627 5.373 12 12 12H64c6.627 0 12 5.373 12 12v104c0 6.627 5.373 12 12 12h103.5c6.627 0 12 5.373 12 12v122.5"
      />
      <path
        stroke="url(#x)"
        strokeWidth={1.5}
        d="M132-17V90c0 6.627 5.373 12 12 12h104c6.627 0 12 5.373 12 12v104c0 6.627 5.373 12 12 12h122"
      />
      <circle cx={20} cy={16} r={4} fill="#F8F8F8" opacity={0.1} />
      <circle cx={34} cy={16} r={4} fill="#F8F8F8" opacity={0.1} />
      <circle cx={48} cy={16} r={4} fill="#F8F8F8" opacity={0.1} />
    </g>
    <rect
      width={334.5}
      height={334.5}
      x={0.75}
      y={0.75}
      stroke="url(#y)"
      strokeWidth={1.5}
      rx={15.25}
    />
    <defs>
      <linearGradient
        id="g"
        x1={15}
        x2={28.921}
        y1={280}
        y2={315.14}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0.4} />
        <stop offset={0.4} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={0.6} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.1} />
      </linearGradient>
      <linearGradient
        id="j"
        x1={14}
        x2={27.921}
        y1={152}
        y2={187.14}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0.4} />
        <stop offset={0.4} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={0.6} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.1} />
      </linearGradient>
      <linearGradient
        id="m"
        x1={322}
        x2={335.921}
        y1={152}
        y2={187.14}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0.4} />
        <stop offset={0.4} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={0.6} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.1} />
      </linearGradient>
      <linearGradient
        id="t"
        x1={168}
        x2={190.621}
        y1={142}
        y2={199.102}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0.4} />
        <stop offset={0.4} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={0.6} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.1} />
      </linearGradient>
      <linearGradient
        id="v"
        x1={182.5}
        x2={256}
        y1={142.5}
        y2={106}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#F8F8F8" />
        <stop offset={1} stopColor="#F8F8F8" stopOpacity={0.01} />
      </linearGradient>
      <linearGradient
        id="w"
        x1={-26}
        x2={203}
        y1={105}
        y2={306}
        gradientUnits="userSpaceOnUse"
      >
        <stop offset={0.325} stopColor="#F8F8F8" stopOpacity={0.01} />
        <stop offset={0.713} stopColor="#F8F8F8" stopOpacity={0.61} />
        <stop offset={0.992} stopColor="#F8F8F8" stopOpacity={0.01} />
      </linearGradient>
      <linearGradient
        id="x"
        x1={158.661}
        x2={291.412}
        y1={59.398}
        y2={273.783}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#F8F8F8" stopOpacity={0.01} />
        <stop offset={0.475} stopColor="#F8F8F8" stopOpacity={0.61} />
        <stop offset={0.992} stopColor="#F8F8F8" stopOpacity={0.01} />
      </linearGradient>
      <linearGradient
        id="y"
        x1={168}
        x2={168}
        y1={0}
        y2={336}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#F8F8F8" stopOpacity={0.1} />
        <stop offset={0.753} stopColor="#F8F8F8" stopOpacity={0} />
      </linearGradient>
      <filter
        id="e"
        width={56}
        height={84}
        x={-13}
        y={268}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={6} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13462"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feMorphology
          in="SourceAlpha"
          radius={16}
          result="effect2_dropShadow_282_13462"
        />
        <feOffset dy={32} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.4 0" />
        <feBlend
          in2="effect1_backgroundBlur_282_13462"
          mode="multiply"
          result="effect2_dropShadow_282_13462"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect2_dropShadow_282_13462"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect3_innerShadow_282_13462" />
      </filter>
      <filter
        id="h"
        width={56}
        height={84}
        x={-14}
        y={140}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={6} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13462"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feMorphology
          in="SourceAlpha"
          radius={16}
          result="effect2_dropShadow_282_13462"
        />
        <feOffset dy={32} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.4 0" />
        <feBlend
          in2="effect1_backgroundBlur_282_13462"
          mode="multiply"
          result="effect2_dropShadow_282_13462"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect2_dropShadow_282_13462"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect3_innerShadow_282_13462" />
      </filter>
      <filter
        id="k"
        width={56}
        height={84}
        x={294}
        y={140}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={6} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13462"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feMorphology
          in="SourceAlpha"
          radius={16}
          result="effect2_dropShadow_282_13462"
        />
        <feOffset dy={32} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.4 0" />
        <feBlend
          in2="effect1_backgroundBlur_282_13462"
          mode="multiply"
          result="effect2_dropShadow_282_13462"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect2_dropShadow_282_13462"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect3_innerShadow_282_13462" />
      </filter>
      <filter
        id="o"
        width={200}
        height={176}
        x={68}
        y={94}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={6} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13462"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feMorphology
          in="SourceAlpha"
          radius={16}
          result="effect2_dropShadow_282_13462"
        />
        <feOffset dy={32} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.4 0" />
        <feBlend
          in2="effect1_backgroundBlur_282_13462"
          mode="multiply"
          result="effect2_dropShadow_282_13462"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect2_dropShadow_282_13462"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect3_innerShadow_282_13462" />
      </filter>
      <filter
        id="q"
        width={76}
        height={100}
        x={130}
        y={138}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feMorphology
          in="SourceAlpha"
          radius={16}
          result="effect1_dropShadow_282_13462"
        />
        <feOffset dy={32} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.4 0" />
        <feBlend
          in2="BackgroundImageFix"
          mode="multiply"
          result="effect1_dropShadow_282_13462"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_dropShadow_282_13462"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect2_innerShadow_282_13462" />
      </filter>
      <filter
        id="s"
        width={76}
        height={104}
        x={130}
        y={130}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={6} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13462"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feMorphology
          in="SourceAlpha"
          radius={16}
          result="effect2_dropShadow_282_13462"
        />
        <feOffset dy={32} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.4 0" />
        <feBlend
          in2="effect1_backgroundBlur_282_13462"
          mode="multiply"
          result="effect2_dropShadow_282_13462"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect2_dropShadow_282_13462"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect3_innerShadow_282_13462" />
      </filter>
      <filter
        id="u"
        width={56}
        height={74}
        x={204}
        y={102}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={6} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13462"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feMorphology
          in="SourceAlpha"
          radius={16}
          result="effect2_dropShadow_282_13462"
        />
        <feOffset dy={32} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.4 0" />
        <feBlend
          in2="effect1_backgroundBlur_282_13462"
          mode="multiply"
          result="effect2_dropShadow_282_13462"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect2_dropShadow_282_13462"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect3_innerShadow_282_13462" />
      </filter>
      <clipPath id="a">
        <rect width={336} height={336} fill="#fff" rx={16} />
      </clipPath>
      <clipPath id="f">
        <rect width={32} height={32} x={-1} y={280} fill="#fff" rx={16} />
      </clipPath>
      <clipPath id="i">
        <rect width={32} height={32} x={-2} y={152} fill="#fff" rx={16} />
      </clipPath>
      <clipPath id="l">
        <rect width={32} height={32} x={306} y={152} fill="#fff" rx={16} />
      </clipPath>
      <clipPath id="p">
        <rect width={176} height={124} x={80} y={106} fill="#fff" rx={10} />
      </clipPath>
      <clipPath id="r">
        <rect width={60} height={60} x={138} y={138} fill="#fff" rx={30} />
      </clipPath>
      <radialGradient
        id="b"
        cx={0}
        cy={0}
        r={1}
        gradientTransform="rotate(90 0 168) scale(158)"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#D9D9D9" />
        <stop offset={1} stopColor="#737373" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="d"
        cx={0}
        cy={0}
        r={1}
        gradientTransform="matrix(0 62 -62 0 194 40)"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset={0.169} stopColor="#fff" stopOpacity={0} />
        <stop offset={0.628} stopColor="#fff" stopOpacity={0.15} />
        <stop offset={0.9} stopColor="#fff" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="n"
        cx={0}
        cy={0}
        r={1}
        gradientTransform="matrix(0 62 -62 0 143 296)"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset={0.169} stopColor="#fff" stopOpacity={0} />
        <stop offset={0.805} stopColor="#fff" stopOpacity={0} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.15} />
      </radialGradient>
    </defs>
  </svg>
);
