import { FC, SVGProps } from 'react';

export const RemoteCachingIllustration: FC<SVGProps<SVGSVGElement>> = (
  props
) => (
  <svg
    role="img"
    xmlns="http://www.w3.org/2000/svg"
    fill="none"
    viewBox="0 0 336 336"
    {...props}
  >
    <g clipPath="url(#a)">
      <mask
        id="c"
        width={336}
        height={336}
        x={0}
        y={0}
        maskUnits="userSpaceOnUse"
        style={{
          maskType: 'alpha',
        }}
      >
        <circle cx={168} cy={168} r={168} fill="url(#b)" />
      </mask>
      <g mask="url(#c)">
        <g clipPath="url(#d)">
          <rect
            width={58.5}
            height={58.5}
            x={-21.25}
            y={92.75}
            stroke="#F8F8F8"
            strokeOpacity={0.1}
            strokeWidth={1.5}
            rx={15.25}
          />
        </g>
        <g clipPath="url(#e)">
          <rect
            width={250.5}
            height={58.5}
            x={42.75}
            y={220.75}
            stroke="#F8F8F8"
            strokeOpacity={0.1}
            strokeWidth={1.5}
            rx={15.25}
          />
        </g>
        <g clipPath="url(#f)">
          <rect
            width={58.5}
            height={58.5}
            x={42.75}
            y={92.75}
            stroke="#F8F8F8"
            strokeWidth={1.5}
            opacity={0.3}
            rx={15.25}
          />
          <g filter="url(#g)" opacity={0.05} shapeRendering="crispEdges">
            <circle cx={72} cy={122} r={6} fill="url(#h)" />
            <circle
              cx={72}
              cy={122}
              r={5.5}
              stroke="#F8F8F8"
              strokeOpacity={0.1}
            />
          </g>
        </g>
        <g clipPath="url(#i)">
          <rect
            width={58.5}
            height={58.5}
            x={106.75}
            y={156.75}
            stroke="#F8F8F8"
            strokeWidth={1.5}
            opacity={0.3}
            rx={15.25}
          />
          <g filter="url(#j)" opacity={0.05} shapeRendering="crispEdges">
            <circle cx={136} cy={186} r={6} fill="url(#k)" />
            <circle
              cx={136}
              cy={186}
              r={5.5}
              stroke="#F8F8F8"
              strokeOpacity={0.1}
            />
          </g>
        </g>
        <g clipPath="url(#l)">
          <rect
            width={58.5}
            height={58.5}
            x={170.75}
            y={92.75}
            stroke="#F8F8F8"
            strokeWidth={1.5}
            opacity={0.3}
            rx={15.25}
          />
          <g filter="url(#m)" opacity={0.05} shapeRendering="crispEdges">
            <circle cx={200} cy={122} r={6} fill="url(#n)" />
            <circle
              cx={200}
              cy={122}
              r={5.5}
              stroke="#F8F8F8"
              strokeOpacity={0.1}
            />
          </g>
        </g>
        <g clipPath="url(#o)">
          <rect
            width={122.5}
            height={58.5}
            x={-21.25}
            y={156.75}
            stroke="#F8F8F8"
            strokeOpacity={0.1}
            strokeWidth={1.5}
            rx={15.25}
          />
        </g>
        <g clipPath="url(#p)">
          <rect
            width={58.5}
            height={58.5}
            x={170.75}
            y={156.75}
            stroke="#F8F8F8"
            strokeOpacity={0.1}
            strokeWidth={1.5}
            rx={15.25}
          />
          <g filter="url(#q)" opacity={0.05} shapeRendering="crispEdges">
            <circle cx={200} cy={186} r={6} fill="url(#r)" />
            <circle
              cx={200}
              cy={186}
              r={5.5}
              stroke="#F8F8F8"
              strokeOpacity={0.1}
            />
          </g>
        </g>
        <g filter="url(#s)">
          <g clipPath="url(#t)" filter="url(#u)">
            <rect
              width={52}
              height={52}
              x={110}
              y={96}
              fill="#F8F8F8"
              fillOpacity={0.01}
              rx={12}
              shapeRendering="crispEdges"
            />
            <rect
              width={52}
              height={52}
              x={110}
              y={96}
              fill="#121212"
              fillOpacity={0.3}
              rx={12}
              shapeRendering="crispEdges"
            />
            <rect
              width={50.5}
              height={50.5}
              x={110.75}
              y={96.75}
              stroke="url(#v)"
              strokeOpacity={0.25}
              strokeWidth={1.5}
              rx={11.25}
              shapeRendering="crispEdges"
            />
            <path
              fill="#F8F8F8"
              fillRule="evenodd"
              d="M136 115.76a1.76 1.76 0 0 0-1.76-1.76h-4.48a1.76 1.76 0 0 0-1.76 1.76v4.538c0 .972.788 1.76 1.76 1.76h4.48c.972 0 1.76.788 1.76 1.76v4.422c0 .972.788 1.76 1.76 1.76h4.48a1.76 1.76 0 0 0 1.76-1.76v-4.538a1.76 1.76 0 0 0-1.76-1.76h-4.48a1.76 1.76 0 0 1-1.76-1.76v-4.422Z"
              clipRule="evenodd"
            />
          </g>
          <rect
            width={58.5}
            height={58.5}
            x={106.75}
            y={92.75}
            stroke="#F8F8F8"
            strokeOpacity={0.4}
            strokeWidth={1.5}
            rx={15.25}
            shapeRendering="crispEdges"
          />
        </g>
        <g clipPath="url(#w)">
          <rect
            width={58.5}
            height={58.5}
            x={298.75}
            y={156.75}
            stroke="#F8F8F8"
            strokeOpacity={0.1}
            strokeWidth={1.5}
            rx={15.25}
          />
          <g filter="url(#x)" opacity={0.05} shapeRendering="crispEdges">
            <circle cx={328} cy={186} r={6} fill="url(#y)" />
            <circle
              cx={328}
              cy={186}
              r={5.5}
              stroke="#F8F8F8"
              strokeOpacity={0.1}
            />
          </g>
        </g>
        <g clipPath="url(#z)">
          <rect
            width={58.5}
            height={58.5}
            x={-21.25}
            y={220.75}
            stroke="#F8F8F8"
            strokeOpacity={0.1}
            strokeWidth={1.5}
            rx={15.25}
          />
        </g>
        <g clipPath="url(#A)">
          <rect
            width={58.5}
            height={58.5}
            x={234.75}
            y={156.75}
            stroke="#F8F8F8"
            strokeOpacity={0.1}
            strokeWidth={1.5}
            rx={15.25}
          />
          <g filter="url(#B)" opacity={0.05} shapeRendering="crispEdges">
            <circle cx={264} cy={186} r={6} fill="url(#C)" />
            <circle
              cx={264}
              cy={186}
              r={5.5}
              stroke="#F8F8F8"
              strokeOpacity={0.1}
            />
          </g>
        </g>
        <g clipPath="url(#D)">
          <rect
            width={58.5}
            height={58.5}
            x={298.75}
            y={220.75}
            stroke="#F8F8F8"
            strokeOpacity={0.1}
            strokeWidth={1.5}
            rx={15.25}
          />
        </g>
        <g clipPath="url(#E)">
          <rect
            width={122.5}
            height={58.5}
            x={234.75}
            y={92.75}
            stroke="#F8F8F8"
            strokeOpacity={0.1}
            strokeWidth={1.5}
            rx={15.25}
          />
        </g>
        <path
          stroke="#F8F8F8"
          strokeWidth={1.5}
          d="M77-81V45.5c0 6.627 5.373 12 12 12h36c6.627 0 12 5.373 12 12V93m0 186.5v29.086c0 6.628 5.373 12 12 12h102c6.627 0 12 5.373 12 12V354"
        />
        <g filter="url(#F)" shapeRendering="crispEdges">
          <circle cx={137} cy={93} r={6} fill="#F8F8F8" fillOpacity={0.01} />
          <circle cx={137} cy={93} r={6} fill="#121212" fillOpacity={0.3} />
          <circle
            cx={137}
            cy={93}
            r={5.25}
            stroke="url(#G)"
            strokeOpacity={0.25}
            strokeWidth={1.5}
          />
        </g>
        <circle cx={137} cy={93} r={3} fill="#F8F8F8" />
        <g filter="url(#H)" shapeRendering="crispEdges">
          <circle cx={137} cy={279} r={6} fill="#F8F8F8" fillOpacity={0.01} />
          <circle cx={137} cy={279} r={6} fill="#121212" fillOpacity={0.3} />
          <circle
            cx={137}
            cy={279}
            r={5.25}
            stroke="url(#I)"
            strokeOpacity={0.25}
            strokeWidth={1.5}
          />
        </g>
        <circle cx={137} cy={279} r={3} fill="#F8F8F8" />
      </g>
    </g>
    <defs>
      <clipPath id="a">
        <path fill="#fff" d="M0 0h336v336H0z" />
      </clipPath>
      <clipPath id="d">
        <path fill="#fff" d="M-22 92h60v60h-60z" />
      </clipPath>
      <clipPath id="e">
        <path fill="#fff" d="M42 220h252v60H42z" />
      </clipPath>
      <clipPath id="f">
        <path fill="#fff" d="M42 92h60v60H42z" />
      </clipPath>
      <clipPath id="i">
        <path fill="#fff" d="M106 156h60v60h-60z" />
      </clipPath>
      <clipPath id="l">
        <path fill="#fff" d="M170 92h60v60h-60z" />
      </clipPath>
      <clipPath id="o">
        <path fill="#fff" d="M-22 156h124v60H-22z" />
      </clipPath>
      <clipPath id="p">
        <path fill="#fff" d="M170 156h60v60h-60z" />
      </clipPath>
      <clipPath id="t">
        <rect width={60} height={60} x={106} y={92} fill="#fff" rx={16} />
      </clipPath>
      <clipPath id="w">
        <path fill="#fff" d="M298 156h60v60h-60z" />
      </clipPath>
      <clipPath id="z">
        <path fill="#fff" d="M-22 220h60v60h-60z" />
      </clipPath>
      <clipPath id="A">
        <path fill="#fff" d="M234 156h60v60h-60z" />
      </clipPath>
      <clipPath id="D">
        <path fill="#fff" d="M298 220h60v60h-60z" />
      </clipPath>
      <clipPath id="E">
        <path fill="#fff" d="M234 92h124v60H234z" />
      </clipPath>
      <filter
        id="g"
        width={60}
        height={60}
        x={42}
        y={116}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy={24} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.3 0" />
        <feBlend
          in2="BackgroundImageFix"
          mode="multiply"
          result="effect1_dropShadow_282_13448"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_dropShadow_282_13448"
          result="shape"
        />
      </filter>
      <filter
        id="j"
        width={60}
        height={60}
        x={106}
        y={180}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy={24} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.3 0" />
        <feBlend
          in2="BackgroundImageFix"
          mode="multiply"
          result="effect1_dropShadow_282_13448"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_dropShadow_282_13448"
          result="shape"
        />
      </filter>
      <filter
        id="m"
        width={60}
        height={60}
        x={170}
        y={116}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy={24} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.3 0" />
        <feBlend
          in2="BackgroundImageFix"
          mode="multiply"
          result="effect1_dropShadow_282_13448"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_dropShadow_282_13448"
          result="shape"
        />
      </filter>
      <filter
        id="q"
        width={60}
        height={60}
        x={170}
        y={180}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy={24} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.3 0" />
        <feBlend
          in2="BackgroundImageFix"
          mode="multiply"
          result="effect1_dropShadow_282_13448"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_dropShadow_282_13448"
          result="shape"
        />
      </filter>
      <filter
        id="s"
        width={76}
        height={100}
        x={98}
        y={92}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feMorphology
          in="SourceAlpha"
          radius={16}
          result="effect1_dropShadow_282_13448"
        />
        <feOffset dy={32} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.4 0" />
        <feBlend
          in2="BackgroundImageFix"
          mode="multiply"
          result="effect1_dropShadow_282_13448"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_dropShadow_282_13448"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect2_innerShadow_282_13448" />
      </filter>
      <filter
        id="u"
        width={76}
        height={104}
        x={98}
        y={84}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={6} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13448"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feMorphology
          in="SourceAlpha"
          radius={16}
          result="effect2_dropShadow_282_13448"
        />
        <feOffset dy={32} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.4 0" />
        <feBlend
          in2="effect1_backgroundBlur_282_13448"
          mode="multiply"
          result="effect2_dropShadow_282_13448"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect2_dropShadow_282_13448"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect3_innerShadow_282_13448" />
      </filter>
      <filter
        id="x"
        width={60}
        height={60}
        x={298}
        y={180}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy={24} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.3 0" />
        <feBlend
          in2="BackgroundImageFix"
          mode="multiply"
          result="effect1_dropShadow_282_13448"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_dropShadow_282_13448"
          result="shape"
        />
      </filter>
      <filter
        id="B"
        width={60}
        height={60}
        x={234}
        y={180}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy={24} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.3 0" />
        <feBlend
          in2="BackgroundImageFix"
          mode="multiply"
          result="effect1_dropShadow_282_13448"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_dropShadow_282_13448"
          result="shape"
        />
      </filter>
      <filter
        id="F"
        width={28}
        height={46.667}
        x={123}
        y={79}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={4} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13448"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feMorphology
          in="SourceAlpha"
          radius={10.667}
          result="effect2_dropShadow_282_13448"
        />
        <feOffset dy={21.333} />
        <feGaussianBlur stdDeviation={8} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.4 0" />
        <feBlend
          in2="effect1_backgroundBlur_282_13448"
          mode="multiply"
          result="effect2_dropShadow_282_13448"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect2_dropShadow_282_13448"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={2.667} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect3_innerShadow_282_13448" />
      </filter>
      <filter
        id="H"
        width={28}
        height={46.667}
        x={123}
        y={265}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={4} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13448"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feMorphology
          in="SourceAlpha"
          radius={10.667}
          result="effect2_dropShadow_282_13448"
        />
        <feOffset dy={21.333} />
        <feGaussianBlur stdDeviation={8} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.4 0" />
        <feBlend
          in2="effect1_backgroundBlur_282_13448"
          mode="multiply"
          result="effect2_dropShadow_282_13448"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect2_dropShadow_282_13448"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={2.667} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect3_innerShadow_282_13448" />
      </filter>
      <linearGradient
        id="h"
        x1={72}
        x2={72}
        y1={116}
        y2={128}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#F8F8F8" stopOpacity={0.9} />
        <stop offset={1} stopColor="#F8F8F8" stopOpacity={0.3} />
      </linearGradient>
      <linearGradient
        id="k"
        x1={136}
        x2={136}
        y1={180}
        y2={192}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#F8F8F8" stopOpacity={0.9} />
        <stop offset={1} stopColor="#F8F8F8" stopOpacity={0.3} />
      </linearGradient>
      <linearGradient
        id="n"
        x1={200}
        x2={200}
        y1={116}
        y2={128}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#F8F8F8" stopOpacity={0.9} />
        <stop offset={1} stopColor="#F8F8F8" stopOpacity={0.3} />
      </linearGradient>
      <linearGradient
        id="r"
        x1={200}
        x2={200}
        y1={180}
        y2={192}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#F8F8F8" stopOpacity={0.9} />
        <stop offset={1} stopColor="#F8F8F8" stopOpacity={0.3} />
      </linearGradient>
      <linearGradient
        id="v"
        x1={136}
        x2={158.621}
        y1={96}
        y2={153.102}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0.4} />
        <stop offset={0.4} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={0.6} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.1} />
      </linearGradient>
      <linearGradient
        id="y"
        x1={328}
        x2={328}
        y1={180}
        y2={192}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#F8F8F8" stopOpacity={0.9} />
        <stop offset={1} stopColor="#F8F8F8" stopOpacity={0.3} />
      </linearGradient>
      <linearGradient
        id="C"
        x1={264}
        x2={264}
        y1={180}
        y2={192}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#F8F8F8" stopOpacity={0.9} />
        <stop offset={1} stopColor="#F8F8F8" stopOpacity={0.3} />
      </linearGradient>
      <linearGradient
        id="G"
        x1={137}
        x2={142.22}
        y1={87}
        y2={100.177}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0.4} />
        <stop offset={0.4} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={0.6} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.1} />
      </linearGradient>
      <linearGradient
        id="I"
        x1={137}
        x2={142.22}
        y1={273}
        y2={286.177}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0.4} />
        <stop offset={0.4} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={0.6} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.1} />
      </linearGradient>
      <radialGradient
        id="b"
        cx={0}
        cy={0}
        r={1}
        gradientTransform="rotate(90 0 168) scale(168)"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#D9D9D9" />
        <stop offset={1} stopColor="#737373" stopOpacity={0} />
      </radialGradient>
    </defs>
  </svg>
);
