import { FC, SVGProps } from 'react';

export const InferredTasksIllustration: FC<SVGProps<SVGSVGElement>> = (
  props
) => (
  <svg
    role="img"
    xmlns="http://www.w3.org/2000/svg"
    fill="none"
    viewBox="0 0 336 336"
    {...props}
  >
    <mask
      id="b"
      width={336}
      height={336}
      x={0}
      y={0}
      maskUnits="userSpaceOnUse"
      style={{
        maskType: 'alpha',
      }}
    >
      <circle cx={168} cy={168} r={168} fill="url(#a)" />
    </mask>
    <g mask="url(#b)">
      <g clipPath="url(#c)">
        <rect
          width={58.5}
          height={58.5}
          x={-21.25}
          y={10.75}
          stroke="#F8F8F8"
          strokeWidth={1.5}
          opacity={0.5}
          rx={15.25}
        />
        <rect
          width={58.5}
          height={58.5}
          x={42.75}
          y={10.75}
          stroke="#F8F8F8"
          strokeWidth={1.5}
          opacity={0.5}
          rx={15.25}
        />
        <rect
          width={58.5}
          height={58.5}
          x={106.75}
          y={10.75}
          stroke="#F8F8F8"
          strokeWidth={1.5}
          opacity={0.1}
          rx={15.25}
        />
        <rect
          width={122.5}
          height={58.5}
          x={170.75}
          y={10.75}
          stroke="#F8F8F8"
          strokeWidth={1.5}
          opacity={0.5}
          rx={15.25}
        />
        <rect
          width={58.5}
          height={58.5}
          x={298.75}
          y={10.75}
          stroke="#F8F8F8"
          strokeWidth={1.5}
          opacity={0.5}
          rx={15.25}
        />
        <rect
          width={58.5}
          height={58.5}
          x={-21.25}
          y={74.75}
          stroke="#F8F8F8"
          strokeWidth={1.5}
          opacity={0.1}
          rx={15.25}
        />
        <rect
          width={58.5}
          height={58.5}
          x={298.75}
          y={74.75}
          stroke="#F8F8F8"
          strokeWidth={1.5}
          opacity={0.5}
          rx={15.25}
        />
        <rect
          width={58.5}
          height={122.5}
          x={-21.25}
          y={138.75}
          stroke="#F8F8F8"
          strokeWidth={1.5}
          opacity={0.5}
          rx={15.25}
        />
        <rect
          width={58.5}
          height={58.5}
          x={298.75}
          y={138.75}
          stroke="#F8F8F8"
          strokeWidth={1.5}
          opacity={0.1}
          rx={15.25}
        />
        <rect
          width={58.5}
          height={58.5}
          x={298.75}
          y={202.75}
          stroke="#F8F8F8"
          strokeWidth={1.5}
          opacity={0.5}
          rx={15.25}
        />
        <mask
          id="e"
          width={193}
          height={193}
          x={72}
          y={72}
          maskUnits="userSpaceOnUse"
          style={{
            maskType: 'alpha',
          }}
        >
          <circle cx={168.5} cy={168.5} r={96.5} fill="url(#d)" />
        </mask>
        <g mask="url(#e)">
          <path
            stroke="#F8F8F8"
            strokeWidth={1.5}
            d="M170.5 104H150c-6.627 0-12 5.373-12 12v80"
          />
          <rect
            width={58.5}
            height={58.5}
            x={170.75}
            y={202.75}
            stroke="#F8F8F8"
            strokeWidth={1.5}
            rx={15.25}
          />
          <rect
            width={58.5}
            height={122.5}
            x={234.75}
            y={138.75}
            stroke="#F8F8F8"
            strokeWidth={1.5}
            rx={15.25}
          />
          <rect
            width={58.5}
            height={58.5}
            x={170.75}
            y={138.75}
            stroke="#F8F8F8"
            strokeWidth={1.5}
            opacity={0.1}
            rx={15.25}
          />
          <path
            fill="#D9D9D9"
            d="M129 198a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v4h-14v-4Z"
          />
        </g>
        <rect
          width={58.5}
          height={58.5}
          x={-21.25}
          y={266.75}
          stroke="#F8F8F8"
          strokeWidth={1.5}
          opacity={0.5}
          rx={15.25}
        />
        <rect
          width={58.5}
          height={58.5}
          x={42.75}
          y={266.75}
          stroke="#F8F8F8"
          strokeWidth={1.5}
          opacity={0.5}
          rx={15.25}
        />
        <rect
          width={122.5}
          height={58.5}
          x={106.75}
          y={266.75}
          stroke="#F8F8F8"
          strokeWidth={1.5}
          opacity={0.5}
          rx={15.25}
        />
        <rect
          width={58.5}
          height={58.5}
          x={234.75}
          y={266.75}
          stroke="#F8F8F8"
          strokeWidth={1.5}
          opacity={0.1}
          rx={15.25}
        />
        <rect
          width={58.5}
          height={58.5}
          x={298.75}
          y={266.75}
          stroke="#F8F8F8"
          strokeWidth={1.5}
          opacity={0.5}
          rx={15.25}
        />
        <path
          stroke="#F8F8F8"
          strokeWidth={1.5}
          d="M102 104h20c6.627 0 12 5.373 12 12v80"
          opacity={0.5}
        />
        <g filter="url(#f)" shapeRendering="crispEdges">
          <circle cx={102} cy={104} r={6} fill="#F8F8F8" fillOpacity={0.01} />
          <circle cx={102} cy={104} r={6} fill="#121212" fillOpacity={0.3} />
          <circle
            cx={102}
            cy={104}
            r={5.25}
            stroke="url(#g)"
            strokeOpacity={0.25}
            strokeWidth={1.5}
          />
        </g>
        <circle cx={102} cy={104} r={3} fill="#F8F8F8" />
        <g filter="url(#h)" shapeRendering="crispEdges">
          <circle cx={171} cy={104} r={6} fill="#F8F8F8" fillOpacity={0.01} />
          <circle cx={171} cy={104} r={6} fill="#121212" fillOpacity={0.3} />
          <circle
            cx={171}
            cy={104}
            r={5.25}
            stroke="url(#i)"
            strokeOpacity={0.25}
            strokeWidth={1.5}
          />
        </g>
        <circle cx={171} cy={104} r={3} fill="#F8F8F8" />
      </g>
      <g filter="url(#j)" shapeRendering="crispEdges">
        <g clipPath="url(#k)" filter="url(#l)">
          <rect
            width={52}
            height={52}
            x={110}
            y={206}
            fill="#F8F8F8"
            fillOpacity={0.01}
            rx={12}
          />
          <rect
            width={52}
            height={52}
            x={110}
            y={206}
            fill="#121212"
            fillOpacity={0.3}
            rx={12}
          />
          <rect
            width={50.5}
            height={50.5}
            x={110.75}
            y={206.75}
            stroke="url(#m)"
            strokeOpacity={0.25}
            strokeWidth={1.5}
            rx={11.25}
          />
        </g>
        <rect
          width={58.5}
          height={58.5}
          x={106.75}
          y={202.75}
          stroke="#F8F8F8"
          strokeOpacity={0.4}
          strokeWidth={1.5}
          rx={15.25}
        />
      </g>
      <g filter="url(#n)">
        <g clipPath="url(#o)">
          <g filter="url(#p)">
            <rect
              width={60}
              height={60}
              x={42}
              y={74}
              fill="#282828"
              fillOpacity={0.1}
              rx={16}
            />
            <rect
              width={60}
              height={60}
              x={42}
              y={74}
              fill="#121212"
              fillOpacity={0.2}
              rx={16}
            />
          </g>
          <rect
            width={59}
            height={59}
            x={42.5}
            y={74.5}
            stroke="#F8F8F8"
            strokeOpacity={0.1}
            rx={15.5}
          />
        </g>
      </g>
      <g filter="url(#q)">
        <rect
          width={60}
          height={60}
          x={170}
          y={74}
          fill="#282828"
          fillOpacity={0.1}
          rx={16}
        />
        <rect
          width={60}
          height={60}
          x={170}
          y={74}
          fill="#121212"
          fillOpacity={0.2}
          rx={16}
        />
      </g>
      <rect
        width={59}
        height={59}
        x={170.5}
        y={74.5}
        stroke="#F8F8F8"
        strokeOpacity={0.1}
        rx={15.5}
      />
    </g>
    <defs>
      <filter
        id="f"
        width={28}
        height={46.667}
        x={88}
        y={90}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={4} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13447"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feMorphology
          in="SourceAlpha"
          radius={10.667}
          result="effect2_dropShadow_282_13447"
        />
        <feOffset dy={21.333} />
        <feGaussianBlur stdDeviation={8} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.4 0" />
        <feBlend
          in2="effect1_backgroundBlur_282_13447"
          mode="multiply"
          result="effect2_dropShadow_282_13447"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect2_dropShadow_282_13447"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={2.667} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect3_innerShadow_282_13447" />
      </filter>
      <filter
        id="h"
        width={28}
        height={46.667}
        x={157}
        y={90}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={4} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13447"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feMorphology
          in="SourceAlpha"
          radius={10.667}
          result="effect2_dropShadow_282_13447"
        />
        <feOffset dy={21.333} />
        <feGaussianBlur stdDeviation={8} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.4 0" />
        <feBlend
          in2="effect1_backgroundBlur_282_13447"
          mode="multiply"
          result="effect2_dropShadow_282_13447"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect2_dropShadow_282_13447"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={2.667} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect3_innerShadow_282_13447" />
      </filter>
      <filter
        id="j"
        width={76}
        height={100}
        x={98}
        y={202}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feMorphology
          in="SourceAlpha"
          radius={16}
          result="effect1_dropShadow_282_13447"
        />
        <feOffset dy={32} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.4 0" />
        <feBlend
          in2="BackgroundImageFix"
          mode="multiply"
          result="effect1_dropShadow_282_13447"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_dropShadow_282_13447"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect2_innerShadow_282_13447" />
      </filter>
      <filter
        id="l"
        width={76}
        height={104}
        x={98}
        y={194}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={6} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13447"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feMorphology
          in="SourceAlpha"
          radius={16}
          result="effect2_dropShadow_282_13447"
        />
        <feOffset dy={32} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.4 0" />
        <feBlend
          in2="effect1_backgroundBlur_282_13447"
          mode="multiply"
          result="effect2_dropShadow_282_13447"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect2_dropShadow_282_13447"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect3_innerShadow_282_13447" />
      </filter>
      <filter
        id="n"
        width={76}
        height={100}
        x={34}
        y={74}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feMorphology
          in="SourceAlpha"
          radius={16}
          result="effect1_dropShadow_282_13447"
        />
        <feOffset dy={32} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.4 0" />
        <feBlend
          in2="BackgroundImageFix"
          mode="multiply"
          result="effect1_dropShadow_282_13447"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_dropShadow_282_13447"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect2_innerShadow_282_13447" />
      </filter>
      <filter
        id="p"
        width={60}
        height={60}
        x={42}
        y={74}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feBlend in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect1_innerShadow_282_13447" />
      </filter>
      <filter
        id="q"
        width={60}
        height={60}
        x={170}
        y={74}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feBlend in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect1_innerShadow_282_13447" />
      </filter>
      <linearGradient
        id="g"
        x1={102}
        x2={107.22}
        y1={98}
        y2={111.177}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0.4} />
        <stop offset={0.4} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={0.6} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.1} />
      </linearGradient>
      <linearGradient
        id="i"
        x1={171}
        x2={176.22}
        y1={98}
        y2={111.177}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0.4} />
        <stop offset={0.4} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={0.6} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.1} />
      </linearGradient>
      <linearGradient
        id="m"
        x1={136}
        x2={158.621}
        y1={206}
        y2={263.102}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0.4} />
        <stop offset={0.4} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={0.6} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.1} />
      </linearGradient>
      <clipPath id="c">
        <path fill="#fff" d="M0 0h336v336H0z" />
      </clipPath>
      <clipPath id="k">
        <rect width={60} height={60} x={106} y={202} fill="#fff" rx={16} />
      </clipPath>
      <clipPath id="o">
        <rect width={60} height={60} x={42} y={74} fill="#fff" rx={16} />
      </clipPath>
      <radialGradient
        id="a"
        cx={0}
        cy={0}
        r={1}
        gradientTransform="rotate(90 0 168) scale(168)"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#D9D9D9" />
        <stop offset={1} stopColor="#737373" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="d"
        cx={0}
        cy={0}
        r={1}
        gradientTransform="rotate(90 0 168.5) scale(96.5)"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#D9D9D9" />
        <stop offset={1} stopColor="#737373" stopOpacity={0} />
      </radialGradient>
    </defs>
  </svg>
);
