import { FC, SVGProps } from 'react';

export const DistributedTaskExecutionIllustration: FC<
  SVGProps<SVGSVGElement>
> = (props) => (
  <svg
    role="img"
    xmlns="http://www.w3.org/2000/svg"
    fill="none"
    viewBox="0 0 336 336"
    {...props}
  >
    <mask
      id="b"
      width={336}
      height={336}
      x={0}
      y={0}
      maskUnits="userSpaceOnUse"
      style={{
        maskType: 'alpha',
      }}
    >
      <path fill="url(#a)" d="M0 0h336v336H0z" />
    </mask>
    <g mask="url(#b)">
      <rect
        width={62.5}
        height={62.5}
        x={0.75}
        y={0.75}
        stroke="#F8F8F8"
        strokeWidth={1.5}
        opacity={0.1}
        rx={15.25}
      />
      <rect
        width={198.5}
        height={62.5}
        x={68.75}
        y={0.75}
        stroke="#F8F8F8"
        strokeWidth={1.5}
        opacity={0.1}
        rx={15.25}
      />
      <rect
        width={62.5}
        height={62.5}
        x={272.75}
        y={0.75}
        stroke="#F8F8F8"
        strokeWidth={1.5}
        opacity={0.1}
        rx={15.25}
      />
      <g filter="url(#c)">
        <g clipPath="url(#d)">
          <rect
            width={62.5}
            height={62.5}
            x={136.75}
            y={136.75}
            stroke="#F8F8F8"
            strokeWidth={1.5}
            opacity={0.4}
            rx={15.25}
          />
          <g filter="url(#e)">
            <rect
              width={52}
              height={52}
              x={142}
              y={142}
              fill="#F8F8F8"
              fillOpacity={0.01}
              rx={10}
            />
            <g filter="url(#f)" opacity={0.25}>
              <path
                fill="#F8F8F8"
                fillRule="evenodd"
                d="M170 162a2 2 0 1 0-4 0v1a3 3 0 0 1-3 3h-1a2 2 0 1 0 0 4h1a3 3 0 0 1 3 3v1a2 2 0 1 0 4 0v-1a3 3 0 0 1 3-3h1a2 2 0 1 0 0-4h-1a3 3 0 0 1-3-3v-1Z"
                clipRule="evenodd"
              />
            </g>
          </g>
        </g>
      </g>
      <mask
        id="g"
        width={207}
        height={207}
        x={12}
        y={65}
        maskUnits="userSpaceOnUse"
        style={{
          maskType: 'alpha',
        }}
      >
        <circle cx={115.5} cy={168.5} r={103.5} fill="#D9D9D9" />
      </mask>
      <g stroke="#F8F8F8" strokeWidth={1.5} mask="url(#g)">
        <rect width={130.5} height={62.5} x={-67.25} y={68.75} rx={15.25} />
        <rect width={130.5} height={62.5} x={-67.25} y={136.75} rx={15.25} />
        <rect width={130.5} height={62.5} x={-67.25} y={204.75} rx={15.25} />
      </g>
      <mask
        id="h"
        width={207}
        height={207}
        x={117}
        y={65}
        maskUnits="userSpaceOnUse"
        style={{
          maskType: 'alpha',
        }}
      >
        <circle cx={220.5} cy={168.5} r={103.5} fill="#D9D9D9" />
      </mask>
      <g stroke="#F8F8F8" strokeWidth={1.5} mask="url(#h)">
        <rect width={62.5} height={62.5} x={272.75} y={68.75} rx={15.25} />
        <rect width={62.5} height={62.5} x={272.75} y={136.75} rx={15.25} />
        <rect width={62.5} height={62.5} x={272.75} y={204.75} rx={15.25} />
      </g>
      <rect
        width={62.5}
        height={62.5}
        x={0.75}
        y={272.75}
        stroke="#F8F8F8"
        strokeWidth={1.5}
        opacity={0.1}
        rx={15.25}
      />
      <rect
        width={198.5}
        height={62.5}
        x={68.75}
        y={272.75}
        stroke="#F8F8F8"
        strokeWidth={1.5}
        opacity={0.1}
        rx={15.25}
      />
      <rect
        width={62.5}
        height={62.5}
        x={272.75}
        y={272.75}
        stroke="#F8F8F8"
        strokeWidth={1.5}
        opacity={0.1}
        rx={15.25}
      />
      <g opacity={0.25}>
        <path
          fill="#F8F8F8"
          d="M73 99.25a.75.75 0 0 0 0 1.5v-1.5Zm0 1.5h11.505v-1.5H73v1.5Zm25.746 9.796 18.169 47.444 1.401-.536-18.169-47.444-1.401.536Zm33.811 58.204H137v-1.5h-4.443v1.5Zm-15.642-10.76a16.75 16.75 0 0 0 15.642 10.76v-1.5a15.25 15.25 0 0 1-14.241-9.796l-1.401.536Zm-32.41-57.24a15.25 15.25 0 0 1 14.241 9.796l1.401-.536a16.75 16.75 0 0 0-15.642-10.76v1.5Z"
        />
        <path
          fill="#F8F8F8"
          d="M73 238.75a.75.75 0 0 1 0-1.5v1.5Zm26.387-11.171-.703-.262.703.262ZM73 237.25h11.391v1.5H73v-1.5Zm25.684-9.933 18.288-49.157 1.406.523-18.288 49.157-1.406-.523Zm33.987-60.067H137v1.5h-4.329v-1.5Zm-15.699 10.91a16.75 16.75 0 0 1 15.699-10.91v1.5a15.249 15.249 0 0 0-14.293 9.933l-1.406-.523Zm-32.58 59.09a15.25 15.25 0 0 0 14.292-9.933l1.406.523a16.75 16.75 0 0 1-15.699 10.91v-1.5Z"
        />
        <path
          stroke="#F8F8F8"
          strokeLinecap="round"
          strokeWidth={1.5}
          d="M73 168h44"
        />
      </g>
      <g opacity={0.25}>
        <path
          fill="#F8F8F8"
          d="M263 99.25a.75.75 0 0 1 0 1.5v-1.5Zm0 1.5h-11.505v-1.5H263v1.5Zm-25.746 9.796-18.169 47.444-1.401-.536 18.169-47.444 1.401.536Zm-33.811 58.204H199v-1.5h4.443v1.5Zm15.642-10.76a16.75 16.75 0 0 1-15.642 10.76v-1.5a15.25 15.25 0 0 0 14.241-9.796l1.401.536Zm32.41-57.24a15.25 15.25 0 0 0-14.241 9.796l-1.401-.536a16.75 16.75 0 0 1 15.642-10.76v1.5Z"
        />
        <path
          fill="#F8F8F8"
          d="M263 238.75a.75.75 0 0 0 0-1.5v1.5Zm-26.387-11.171.703-.262-.703.262ZM263 237.25h-11.391v1.5H263v-1.5Zm-25.684-9.933-18.288-49.157-1.406.523 18.288 49.157 1.406-.523Zm-33.987-60.067H199v1.5h4.329v-1.5Zm15.699 10.91a16.75 16.75 0 0 0-15.699-10.91v1.5a15.249 15.249 0 0 1 14.293 9.933l1.406-.523Zm32.581 59.09a15.249 15.249 0 0 1-14.293-9.933l-1.406.523a16.75 16.75 0 0 0 15.699 10.91v-1.5Z"
        />
        <path
          stroke="#F8F8F8"
          strokeLinecap="round"
          strokeWidth={1.5}
          d="M263 168h-44"
        />
      </g>
    </g>
    <defs>
      <filter
        id="c"
        width={80}
        height={104}
        x={128}
        y={136}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feMorphology
          in="SourceAlpha"
          radius={16}
          result="effect1_dropShadow_282_13464"
        />
        <feOffset dy={32} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.4 0" />
        <feBlend
          in2="BackgroundImageFix"
          mode="multiply"
          result="effect1_dropShadow_282_13464"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_dropShadow_282_13464"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect2_innerShadow_282_13464" />
      </filter>
      <filter
        id="e"
        width={52}
        height={52}
        x={142}
        y={142}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feBlend in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect1_innerShadow_282_13464" />
      </filter>
      <filter
        id="f"
        width={16}
        height={16}
        x={160}
        y={160}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feBlend in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.25 0" />
        <feBlend in2="shape" result="effect1_innerShadow_282_13464" />
      </filter>
      <radialGradient
        id="a"
        cx={0}
        cy={0}
        r={1}
        gradientTransform="rotate(90 0 168) scale(168)"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#D9D9D9" />
        <stop offset={1} stopColor="#737373" stopOpacity={0} />
      </radialGradient>
      <clipPath id="d">
        <rect width={64} height={64} x={136} y={136} fill="#fff" rx={16} />
      </clipPath>
    </defs>
  </svg>
);
