import { FC, SVGProps } from 'react';

export const AutomatedMigrationIllustration: FC<SVGProps<SVGSVGElement>> = (
  props
) => (
  <svg
    role="img"
    xmlns="http://www.w3.org/2000/svg"
    fill="none"
    viewBox="0 0 336 336"
    {...props}
  >
    <mask
      id="b"
      width={336}
      height={336}
      x={0}
      y={0}
      maskUnits="userSpaceOnUse"
      style={{
        maskType: 'alpha',
      }}
    >
      <path fill="url(#a)" d="M0 0h336v336H0z" />
    </mask>
    <g mask="url(#b)">
      <circle
        cx={167.5}
        cy={388.5}
        r={252.5}
        stroke="#F8F8F8"
        strokeDasharray="1 32"
        strokeWidth={1.5}
      />
      <circle
        cx={167.5}
        cy={388.5}
        r={180.5}
        stroke="#F8F8F8"
        strokeDasharray="1 24"
        strokeWidth={4}
        opacity={0.1}
      />
      <circle
        cx={167.5}
        cy={388.5}
        r={326.5}
        stroke="#F8F8F8"
        strokeDasharray="1 24"
        strokeWidth={4}
        opacity={0.1}
      />
      <mask
        id="d"
        width={337}
        height={326}
        x={-2}
        y={21}
        maskUnits="userSpaceOnUse"
        style={{
          maskType: 'alpha',
        }}
      >
        <path fill="url(#c)" d="M-1 21h336v326H-1z" />
      </mask>
      <g mask="url(#d)">
        <g
          filter="url(#e)"
          shapeRendering="crispEdges"
          transform="rotate(-60 -51.173 262.25)"
        >
          <circle
            cx={-51.173}
            cy={262.25}
            r={24}
            fill="#F8F8F8"
            fillOpacity={0.05}
            style={{
              mixBlendMode: 'luminosity',
            }}
          />
          <circle
            cx={-51.173}
            cy={262.25}
            r={23.25}
            stroke="url(#f)"
            strokeOpacity={0.25}
            strokeWidth={1.5}
          />
        </g>
        <g
          filter="url(#g)"
          shapeRendering="crispEdges"
          transform="rotate(-45 -11.046 209.956)"
        >
          <circle
            cx={-11.046}
            cy={209.956}
            r={24}
            fill="#F8F8F8"
            fillOpacity={0.05}
            style={{
              mixBlendMode: 'luminosity',
            }}
          />
          <circle
            cx={-11.046}
            cy={209.956}
            r={23.25}
            stroke="url(#h)"
            strokeOpacity={0.25}
            strokeWidth={1.5}
          />
        </g>
        <g
          filter="url(#i)"
          shapeRendering="crispEdges"
          transform="rotate(-30 41.249 169.829)"
        >
          <circle
            cx={41.249}
            cy={169.829}
            r={24}
            fill="#F8F8F8"
            fillOpacity={0.05}
            style={{
              mixBlendMode: 'luminosity',
            }}
          />
          <circle
            cx={41.249}
            cy={169.829}
            r={23.25}
            stroke="url(#j)"
            strokeOpacity={0.25}
            strokeWidth={1.5}
          />
        </g>
        <path
          fill="#F8F8F8"
          fillOpacity={0.7}
          d="M44.254 174.029a5.406 5.406 0 0 1-1.396.579 3.671 3.671 0 0 1-1.3.072 2.793 2.793 0 0 1-1.112-.441 2.782 2.782 0 0 1-.846-.934c-.285-.493-.413-.985-.383-1.476.037-.496.2-.951.488-1.366a2.382 2.382 0 0 1-1.16-.3c-.35-.197-.644-.501-.882-.913-.28-.485-.398-.961-.355-1.428.046-.479.23-.936.551-1.369.33-.438.78-.822 1.355-1.154.565-.326 1.116-.52 1.652-.582.539-.074 1.024-.009 1.454.195.439.2.796.538 1.07 1.015.239.412.358.823.357 1.233a2.41 2.41 0 0 1-.307 1.147c.503-.042.975.046 1.414.267.448.215.814.57 1.1 1.063.302.525.433 1.059.39 1.601-.047.534-.249 1.043-.604 1.529-.36.477-.856.898-1.486 1.262Zm-.56-.97c.371-.215.67-.473.894-.775.224-.302.358-.622.4-.959a1.61 1.61 0 0 0-.223-1.002c-.191-.332-.441-.559-.75-.683a1.904 1.904 0 0 0-1.023-.12 2.888 2.888 0 0 0-1.118.387 2.988 2.988 0 0 0-.907.782 1.912 1.912 0 0 0-.407.946c-.047.329.025.659.216.991.187.323.439.555.757.694.313.132.656.176 1.03.133a2.995 2.995 0 0 0 1.13-.394Zm-2.373-4.11c.307-.178.557-.397.75-.66.202-.267.323-.542.365-.825a1.227 1.227 0 0 0-.164-.843 1.322 1.322 0 0 0-.643-.582 1.554 1.554 0 0 0-.884-.104 2.498 2.498 0 0 0-.971.334 2.599 2.599 0 0 0-.787.681 1.656 1.656 0 0 0-.353.818c-.037.291.024.573.183.848.163.283.38.481.65.595.266.105.558.135.877.091a2.78 2.78 0 0 0 .977-.353Z"
        />
        <g
          filter="url(#k)"
          shapeRendering="crispEdges"
          transform="rotate(-15 102.147 144.603)"
        >
          <circle
            cx={102.147}
            cy={144.603}
            r={24}
            fill="#F8F8F8"
            fillOpacity={0.05}
            style={{
              mixBlendMode: 'luminosity',
            }}
          />
          <circle
            cx={102.147}
            cy={144.603}
            r={23.25}
            stroke="url(#l)"
            strokeOpacity={0.25}
            strokeWidth={1.5}
          />
        </g>
        <path
          fill="#F8F8F8"
          fillOpacity={0.7}
          d="M101.99 149.822a.284.284 0 0 1-.225-.027.37.37 0 0 1-.125-.198.433.433 0 0 1-.006-.129l1.258-8.773-4.435 1.189a.35.35 0 0 1-.252-.02.352.352 0 0 1-.143-.208l-.144-.541c-.027-.099-.02-.183.02-.251a.328.328 0 0 1 .204-.157l5.544-1.485a.293.293 0 0 1 .255.033c.078.037.13.105.157.204l.134.501c.031.117.047.214.049.291a2.02 2.02 0 0 1-.016.265l-1.257 8.671a.919.919 0 0 1-.074.266c-.034.087-.106.144-.214.173l-.73.196Z"
        />
        <g filter="url(#m)">
          <g clipPath="url(#n)">
            <rect
              width={52}
              height={92}
              x={142}
              y={90}
              fill="url(#o)"
              fillOpacity={0.05}
              rx={26}
            />
            <g filter="url(#p)">
              <rect
                width={44}
                height={84}
                x={146}
                y={94}
                fill="#F8F8F8"
                fillOpacity={0.05}
                rx={22}
                shapeRendering="crispEdges"
                style={{
                  mixBlendMode: 'luminosity',
                }}
              />
              <rect
                width={42.5}
                height={82.5}
                x={146.75}
                y={94.75}
                stroke="url(#q)"
                strokeOpacity={0.25}
                strokeWidth={1.5}
                rx={21.25}
                shapeRendering="crispEdges"
              />
              <path
                fill="#F8F8F8"
                fillOpacity={0.95}
                d="M168.002 141.16c-.619 0-1.19-.075-1.712-.224a4.201 4.201 0 0 1-1.328-.672 3.169 3.169 0 0 1-.848-1.072 3.168 3.168 0 0 1-.304-1.408c0-.651.154-1.211.464-1.68.32-.469.741-.827 1.264-1.072a2.707 2.707 0 0 1-.976-.96c-.235-.395-.352-.864-.352-1.408 0-.64.154-1.179.464-1.616.32-.448.762-.795 1.328-1.04.576-.245 1.242-.368 2-.368.746 0 1.402.123 1.968.368.576.235 1.018.576 1.328 1.024.32.448.48.987.48 1.616 0 .544-.118 1.019-.352 1.424a2.758 2.758 0 0 1-.96.96c.522.245.938.603 1.248 1.072.32.469.48 1.029.48 1.68 0 .693-.176 1.296-.528 1.808-.352.501-.843.891-1.472 1.168-.63.267-1.36.4-2.192.4Zm0-1.28c.49 0 .933-.085 1.328-.256.394-.171.709-.411.944-.72.234-.32.352-.693.352-1.12 0-.437-.118-.805-.352-1.104a2.194 2.194 0 0 0-.944-.704 3.311 3.311 0 0 0-1.328-.256c-.491 0-.939.085-1.344.256-.395.16-.71.395-.944.704-.235.299-.352.667-.352 1.104 0 .427.117.8.352 1.12.234.309.549.549.944.72.405.171.853.256 1.344.256Zm0-5.424c.405 0 .778-.075 1.12-.224a2.06 2.06 0 0 0 .832-.608c.213-.256.32-.565.32-.928a1.52 1.52 0 0 0-.304-.944 1.776 1.776 0 0 0-.816-.608 2.856 2.856 0 0 0-1.152-.224c-.427 0-.816.075-1.168.224a1.887 1.887 0 0 0-.816.608 1.514 1.514 0 0 0-.304.944c0 .373.101.693.304.96.202.256.474.453.816.592.352.139.741.208 1.168.208Z"
              />
            </g>
          </g>
          <rect
            width={50.5}
            height={90.5}
            x={142.75}
            y={90.75}
            stroke="#fff"
            strokeOpacity={0.4}
            strokeWidth={1.5}
            rx={25.25}
          />
        </g>
        <g
          filter="url(#r)"
          shapeRendering="crispEdges"
          transform="rotate(15 232.851 144.603)"
        >
          <circle
            cx={232.851}
            cy={144.603}
            r={24}
            fill="#F8F8F8"
            fillOpacity={0.05}
            style={{
              mixBlendMode: 'luminosity',
            }}
          />
          <circle
            cx={232.851}
            cy={144.603}
            r={23.25}
            stroke="url(#s)"
            strokeOpacity={0.25}
            strokeWidth={1.5}
          />
        </g>
        <path
          fill="#F8F8F8"
          fillOpacity={0.7}
          d="M230.642 149.188a.284.284 0 0 1-.181-.136.367.367 0 0 1-.01-.234.35.35 0 0 1 .043-.105.82.82 0 0 0 .058-.056l2.841-2.326a3.272 3.272 0 0 1-.752-.115 3.663 3.663 0 0 1-1.28-.633 3.208 3.208 0 0 1-.829-.961 3.22 3.22 0 0 1-.272-2.392c.106-.397.277-.766.514-1.109.246-.34.549-.626.911-.857a3.244 3.244 0 0 1 1.264-.444c.474-.076 1-.037 1.577.118.568.152 1.04.375 1.415.669.387.287.684.623.89 1.007.218.377.344.773.377 1.188.043.417.01.829-.099 1.234-.099.37-.243.694-.434.971-.19.278-.394.518-.613.72-.209.205-.414.391-.614.56l-3.571 2.942a5.303 5.303 0 0 1-.196.136c-.08.046-.183.052-.309.019l-.73-.196Zm2.482-4.017a2.31 2.31 0 0 0 1.106.036c.371-.084.691-.25.96-.497.271-.255.464-.595.577-1.019.114-.424.116-.81.006-1.158a1.943 1.943 0 0 0-.582-.91 2.227 2.227 0 0 0-.973-.535 2.179 2.179 0 0 0-1.096-.019 1.968 1.968 0 0 0-.946.5c-.269.247-.46.582-.574 1.006-.114.424-.117.814-.01 1.172.11.348.3.65.569.906.272.246.593.419.963.518Z"
        />
        <g
          filter="url(#t)"
          shapeRendering="crispEdges"
          transform="rotate(30 293.749 169.829)"
        >
          <circle
            cx={293.749}
            cy={169.829}
            r={24}
            fill="#F8F8F8"
            fillOpacity={0.05}
            style={{
              mixBlendMode: 'luminosity',
            }}
          />
          <circle
            cx={293.749}
            cy={169.829}
            r={23.25}
            stroke="url(#u)"
            strokeOpacity={0.25}
            strokeWidth={1.5}
          />
        </g>
        <path
          fill="#F8F8F8"
          fillOpacity={0.7}
          d="M288.587 172.622a.356.356 0 0 1-.164-.192.356.356 0 0 1 .046-.248l3.92-6.79-2.908.39c-.093.011-.173-.008-.241-.058s-.108-.122-.119-.214l-.084-.582a.374.374 0 0 1 .065-.254.354.354 0 0 1 .226-.111l3.819-.511a.446.446 0 0 1 .2.018c.053.02.108.046.165.079l.618.357a.278.278 0 0 1 .145.197.308.308 0 0 1-.039.236l-4.578 7.929a.352.352 0 0 1-.192.164.299.299 0 0 1-.236-.039l-.643-.371Zm5.613 3.402c-.557-.322-.981-.68-1.271-1.073a2.94 2.94 0 0 1-.514-1.267 3.486 3.486 0 0 1 .076-1.363c.123-.456.305-.912.546-1.366l.375-.705.42-.727c.152-.246.298-.48.437-.701.265-.44.568-.826.91-1.156a3.619 3.619 0 0 1 1.142-.747 2.79 2.79 0 0 1 1.359-.17c.491.047 1.011.228 1.56.546.558.322.976.681 1.253 1.078.29.394.467.815.533 1.262.069.439.044.893-.076 1.363a5.26 5.26 0 0 1-.534 1.373c-.123.231-.256.471-.401.722-.132.247-.272.489-.42.727-.14.243-.277.471-.411.684a5.28 5.28 0 0 1-.922 1.149c-.342.331-.723.58-1.142.747a2.787 2.787 0 0 1-1.354.189c-.478-.05-1-.238-1.566-.565Zm.595-1.03c.631.364 1.215.426 1.752.186.549-.243 1.036-.722 1.46-1.436.151-.225.29-.447.416-.665l.385-.667c.13-.226.251-.453.361-.681.397-.708.564-1.361.5-1.958-.052-.601-.393-1.084-1.024-1.448-.622-.359-1.21-.413-1.765-.162-.542.247-1.024.718-1.446 1.412-.126.218-.258.438-.397.66l-.385.667c-.118.223-.244.451-.38.686-.399.728-.566 1.392-.502 1.989.069.59.411 1.062 1.025 1.417Z"
        />
        <g
          filter="url(#v)"
          shapeRendering="crispEdges"
          transform="rotate(45 346.044 209.956)"
        >
          <circle
            cx={346.044}
            cy={209.956}
            r={24}
            fill="#F8F8F8"
            fillOpacity={0.05}
            style={{
              mixBlendMode: 'luminosity',
            }}
          />
          <circle
            cx={346.044}
            cy={209.956}
            r={23.25}
            stroke="url(#w)"
            strokeOpacity={0.25}
            strokeWidth={1.5}
          />
        </g>
        <g
          filter="url(#x)"
          shapeRendering="crispEdges"
          transform="rotate(60 386.172 262.25)"
        >
          <circle
            cx={386.172}
            cy={262.25}
            r={24}
            fill="#F8F8F8"
            fillOpacity={0.05}
            style={{
              mixBlendMode: 'luminosity',
            }}
          />
          <circle
            cx={386.172}
            cy={262.25}
            r={23.25}
            stroke="url(#y)"
            strokeOpacity={0.25}
            strokeWidth={1.5}
          />
        </g>
      </g>
      <g filter="url(#z)">
        <rect
          width={136}
          height={48}
          x={100}
          y={248}
          fill="#F8F8F8"
          fillOpacity={0.05}
          rx={8}
          shapeRendering="crispEdges"
          style={{
            mixBlendMode: 'luminosity',
          }}
        />
        <rect
          width={135}
          height={47}
          x={100.5}
          y={248.5}
          stroke="url(#A)"
          strokeOpacity={0.25}
          rx={7.5}
          shapeRendering="crispEdges"
        />
        <rect
          width={44}
          height={4}
          x={146}
          y={270}
          fill="#F8F8F8"
          fillOpacity={0.95}
          rx={1}
        />
      </g>
      <path
        fill="#F8F8F8"
        d="M143 21c-1.105 0-2 .759-2 1.695s.895 1.696 2 1.696h17.323a4 4 0 0 1 2.853 1.195l3.056 3.109c.4.407 1.136.407 1.536 0l3.056-3.109a4 4 0 0 1 2.853-1.195H191c1.105 0 2-.76 2-1.696S192.105 21 191 21h-48Z"
        opacity={0.2}
      />
    </g>
    <defs>
      <linearGradient
        id="c"
        x1={335}
        x2={-1}
        y1={184}
        y2={184}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopOpacity={0} />
        <stop offset={0.15} />
        <stop offset={0.85} />
        <stop offset={1} stopOpacity={0} />
      </linearGradient>
      <linearGradient
        id="f"
        x1={-51.173}
        x2={-30.292}
        y1={238.25}
        y2={290.96}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0.4} />
        <stop offset={0.4} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={0.6} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.1} />
      </linearGradient>
      <linearGradient
        id="h"
        x1={-11.046}
        x2={9.835}
        y1={185.956}
        y2={238.665}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0.4} />
        <stop offset={0.4} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={0.6} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.1} />
      </linearGradient>
      <linearGradient
        id="j"
        x1={41.249}
        x2={62.13}
        y1={145.829}
        y2={198.538}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0.4} />
        <stop offset={0.4} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={0.6} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.1} />
      </linearGradient>
      <linearGradient
        id="l"
        x1={102.147}
        x2={123.028}
        y1={120.603}
        y2={173.313}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0.4} />
        <stop offset={0.4} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={0.6} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.1} />
      </linearGradient>
      <linearGradient
        id="o"
        x1={168}
        x2={168}
        y1={90}
        y2={182}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.05} />
      </linearGradient>
      <linearGradient
        id="q"
        x1={168}
        x2={219.342}
        y1={94}
        y2={161.888}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0.4} />
        <stop offset={0.4} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={0.6} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.1} />
      </linearGradient>
      <linearGradient
        id="s"
        x1={232.851}
        x2={253.732}
        y1={120.603}
        y2={173.313}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0.4} />
        <stop offset={0.4} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={0.6} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.1} />
      </linearGradient>
      <linearGradient
        id="u"
        x1={293.749}
        x2={314.63}
        y1={145.829}
        y2={198.538}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0.4} />
        <stop offset={0.4} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={0.6} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.1} />
      </linearGradient>
      <linearGradient
        id="w"
        x1={346.045}
        x2={366.925}
        y1={185.956}
        y2={238.666}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0.4} />
        <stop offset={0.4} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={0.6} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.1} />
      </linearGradient>
      <linearGradient
        id="y"
        x1={386.172}
        x2={407.053}
        y1={238.25}
        y2={290.96}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0.4} />
        <stop offset={0.4} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={0.6} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.1} />
      </linearGradient>
      <linearGradient
        id="A"
        x1={168}
        x2={176.363}
        y1={248}
        y2={307.813}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#fff" stopOpacity={0.4} />
        <stop offset={0.4} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={0.6} stopColor="#fff" stopOpacity={0.01} />
        <stop offset={1} stopColor="#fff" stopOpacity={0.1} />
      </linearGradient>
      <filter
        id="e"
        width={112.008}
        height={112.008}
        x={-107.177}
        y={206.246}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={16} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13442"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_backgroundBlur_282_13442"
          result="shape"
        />
      </filter>
      <filter
        id="g"
        width={112}
        height={128}
        x={-67.046}
        y={153.956}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={16} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13442"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy={24} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.3 0" />
        <feBlend
          in2="effect1_backgroundBlur_282_13442"
          mode="multiply"
          result="effect2_dropShadow_282_13442"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect2_dropShadow_282_13442"
          result="shape"
        />
      </filter>
      <filter
        id="i"
        width={112.008}
        height={128.008}
        x={-14.755}
        y={113.824}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={16} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13442"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy={24} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.3 0" />
        <feBlend
          in2="effect1_backgroundBlur_282_13442"
          mode="multiply"
          result="effect2_dropShadow_282_13442"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect2_dropShadow_282_13442"
          result="shape"
        />
      </filter>
      <filter
        id="k"
        width={112.012}
        height={128.012}
        x={46.141}
        y={88.597}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={16} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13442"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy={24} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.3 0" />
        <feBlend
          in2="effect1_backgroundBlur_282_13442"
          mode="multiply"
          result="effect2_dropShadow_282_13442"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect2_dropShadow_282_13442"
          result="shape"
        />
      </filter>
      <filter
        id="m"
        width={252}
        height={292}
        x={42}
        y={-10}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={50} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13442"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_backgroundBlur_282_13442"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dx={2} dy={4} />
        <feGaussianBlur stdDeviation={8} />
        <feComposite in2="hardAlpha" k2={-1} k3={1} operator="arithmetic" />
        <feColorMatrix values="0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0 0.972549 0 0 0 0.06 0" />
        <feBlend in2="shape" result="effect2_innerShadow_282_13442" />
      </filter>
      <filter
        id="p"
        width={108}
        height={164}
        x={114}
        y={62}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={16} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13442"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy={24} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.3 0" />
        <feBlend
          in2="effect1_backgroundBlur_282_13442"
          mode="multiply"
          result="effect2_dropShadow_282_13442"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect2_dropShadow_282_13442"
          result="shape"
        />
      </filter>
      <filter
        id="r"
        width={112.012}
        height={128.012}
        x={176.845}
        y={88.597}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={16} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13442"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy={24} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.3 0" />
        <feBlend
          in2="effect1_backgroundBlur_282_13442"
          mode="multiply"
          result="effect2_dropShadow_282_13442"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect2_dropShadow_282_13442"
          result="shape"
        />
      </filter>
      <filter
        id="t"
        width={112.008}
        height={128.008}
        x={237.745}
        y={113.824}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={16} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13442"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy={24} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.3 0" />
        <feBlend
          in2="effect1_backgroundBlur_282_13442"
          mode="multiply"
          result="effect2_dropShadow_282_13442"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect2_dropShadow_282_13442"
          result="shape"
        />
      </filter>
      <filter
        id="v"
        width={112}
        height={128}
        x={290.044}
        y={153.956}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={16} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13442"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy={24} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.3 0" />
        <feBlend
          in2="effect1_backgroundBlur_282_13442"
          mode="multiply"
          result="effect2_dropShadow_282_13442"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect2_dropShadow_282_13442"
          result="shape"
        />
      </filter>
      <filter
        id="x"
        width={112.008}
        height={112.008}
        x={330.168}
        y={206.246}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={16} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_282_13442"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_backgroundBlur_282_13442"
          result="shape"
        />
      </filter>
      <filter
        id="z"
        width={184}
        height={96}
        x={76}
        y={248}
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy={24} />
        <feGaussianBlur stdDeviation={12} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.3 0" />
        <feBlend
          in2="BackgroundImageFix"
          mode="multiply"
          result="effect1_dropShadow_282_13442"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect1_dropShadow_282_13442"
          result="shape"
        />
      </filter>
      <radialGradient
        id="a"
        cx={0}
        cy={0}
        r={1}
        gradientTransform="rotate(90 0 168) scale(226)"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset={0.344} stopColor="#D9D9D9" />
        <stop offset={1} stopColor="#737373" stopOpacity={0} />
      </radialGradient>
      <clipPath id="n">
        <rect width={52} height={92} x={142} y={90} fill="#fff" rx={26} />
      </clipPath>
    </defs>
  </svg>
);
