import { ComponentProps } from 'react';

export function ChatGptLogo(
  props: ComponentProps<'svg'> & { title?: string; titleId?: string }
): JSX.Element {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="20"
      height="20"
      viewBox="0 0 20 20"
      fill="currentColor"
      stroke="none"
      {...props}
    >
      <path d="M18.6816 8.18531C18.8527 7.67776 18.94 7.14633 18.9401 6.61141C18.9401 5.72627 18.7011 4.85712 18.2478 4.09329C17.337 2.52895 15.6474 1.56315 13.8188 1.56315C13.4586 1.56315 13.0993 1.60069 12.7471 1.67514C12.2733 1.14844 11.6917 0.726808 11.0407 0.438063C10.3897 0.149318 9.68404 1.53941e-05 8.97029 0H8.93823L8.9262 6.97855e-05C6.71144 6.97855e-05 4.74733 1.41016 4.06649 3.48896C3.36173 3.63138 2.69594 3.92071 2.11369 4.33757C1.53143 4.75444 1.04615 5.28922 0.690321 5.90612C0.238418 6.67455 0.000276531 7.54714 0 8.43556C0.000172701 9.68414 0.469901 10.8882 1.31823 11.8147C1.14699 12.3222 1.05965 12.8537 1.05958 13.3886C1.05966 14.2737 1.29861 15.1429 1.75188 15.9067C2.2909 16.8327 3.11405 17.5659 4.10264 18.0005C5.09122 18.435 6.19415 18.5486 7.25237 18.3248C7.72623 18.8515 8.30786 19.2731 8.95891 19.5619C9.60995 19.8506 10.3156 20 11.0294 20H11.0615L11.0745 19.9999C13.2905 19.9999 15.2539 18.5898 15.9348 16.5091C16.6395 16.3666 17.3053 16.0773 17.8876 15.6604C18.4698 15.2435 18.9552 14.7087 19.311 14.0919C19.7624 13.3241 20.0001 12.4522 20 11.5646C19.9998 10.3161 19.5301 9.11202 18.6818 8.18559L18.6816 8.18531ZM11.0628 18.6925H11.0575C10.1708 18.6922 9.31227 18.3853 8.63118 17.8251C8.67162 17.8036 8.71159 17.7812 8.75105 17.758L12.787 15.4578C12.8877 15.4012 12.9714 15.3194 13.0297 15.2205C13.088 15.1217 13.1187 15.0094 13.1187 14.895V9.27708L14.8246 10.249C14.8336 10.2534 14.8413 10.2599 14.8471 10.2679C14.8529 10.276 14.8565 10.2853 14.8578 10.2951V14.9444C14.8555 17.0115 13.1579 18.6883 11.0628 18.6925ZM2.9014 15.2532C2.56803 14.6844 2.39239 14.039 2.39217 13.382C2.39217 13.1677 2.41114 12.9529 2.44808 12.7417C2.47808 12.7595 2.53045 12.791 2.56802 12.8123L6.60394 15.1125C6.70456 15.1705 6.81899 15.201 6.9355 15.201C7.05201 15.201 7.16643 15.1704 7.26702 15.1124L12.1945 12.3051V14.249L12.1945 14.2523C12.1945 14.2617 12.1923 14.2709 12.1881 14.2793C12.1838 14.2876 12.1777 14.2949 12.1701 14.3006L8.09017 16.6249C7.51288 16.9527 6.85851 17.1253 6.19244 17.1255C5.52566 17.1254 4.87062 16.9523 4.293 16.6237C3.71538 16.295 3.23547 15.8223 2.9014 15.253V15.2532ZM1.83963 6.55967C2.2829 5.79999 2.98282 5.21831 3.8169 4.91644C3.8169 4.95072 3.81492 5.01147 3.81492 5.05364V9.65413L3.81485 9.6579C3.81487 9.77213 3.84552 9.88432 3.9037 9.98308C3.96188 10.0818 4.04551 10.1636 4.1461 10.2202L9.07353 13.027L7.36772 13.9989C7.3593 14.0044 7.34965 14.0077 7.33961 14.0086C7.32957 14.0095 7.31947 14.008 7.31019 14.0041L3.22983 11.6778C2.65301 11.3481 2.17414 10.8746 1.84122 10.3048C1.5083 9.73494 1.33302 9.08877 1.33295 8.43102C1.3332 7.77431 1.50798 7.12914 1.83984 6.55988L1.83963 6.55967ZM15.8552 9.77779L10.9277 6.97059L12.6336 5.99906C12.642 5.99358 12.6517 5.99024 12.6617 5.98934C12.6718 5.98844 12.6819 5.99 12.6912 5.99389L16.7714 8.31819C17.3487 8.64738 17.8281 9.12062 18.1614 9.69041C18.4948 10.2602 18.6703 10.9065 18.6705 11.5644C18.6705 13.1346 17.6774 14.5397 16.1842 15.082V10.344C16.1844 10.3422 16.1844 10.3404 16.1844 10.3387C16.1844 10.2249 16.154 10.1131 16.0961 10.0146C16.0383 9.91613 15.9552 9.83444 15.8552 9.77779ZM17.5531 7.25638C17.5134 7.23239 17.4734 7.20889 17.4332 7.18585L13.3973 4.88558C13.2966 4.82772 13.1823 4.79722 13.0658 4.79718C12.9493 4.79722 12.835 4.82772 12.7343 4.88558L7.80682 7.69284V5.74902L7.80675 5.74567C7.80675 5.72667 7.81588 5.7088 7.83124 5.69742L11.9112 3.37508C12.4883 3.0468 13.1427 2.87398 13.8088 2.87395C15.9066 2.87395 17.6078 4.55252 17.6078 6.62238C17.6077 6.83479 17.5894 7.04681 17.5531 7.25617V7.25638ZM6.87936 10.7209L5.17313 9.74902C5.16417 9.74462 5.15646 9.7381 5.15067 9.73005C5.14488 9.72199 5.1412 9.71266 5.13994 9.70286V5.0535C5.14086 2.98476 6.84207 1.30759 8.93894 1.30759C9.82702 1.30777 10.687 1.61474 11.3697 2.17522C11.339 2.19177 11.2854 2.22096 11.2498 2.24225L7.21388 4.54246C7.11317 4.59899 7.02944 4.68082 6.97118 4.77963C6.91292 4.87845 6.88222 4.99072 6.8822 5.10503V5.10873L6.87936 10.7209ZM7.80604 8.74956L10.0006 7.49887L12.1952 8.74872V11.2493L10.0006 12.4992L7.80604 11.2493V8.74956Z" />
    </svg>
  );
}
