- Nx

  - [Getting Started](/getting-started)
    - [Intro to Nx](/getting-started/intro)
    - [Installation](/getting-started/installation)
    - [Why Nx?](/getting-started/why-nx)
    - [Editor Setup](/getting-started/editor-setup)
    - [Tutorials](/getting-started/tutorials)
      - [NPM Workspaces Monorepo](/getting-started/tutorials/npm-workspaces-tutorial)
      - [React Standalone](/getting-started/tutorials/react-standalone-tutorial)
      - [React Monorepo](/getting-started/tutorials/react-monorepo-tutorial)
      - [Angular Standalone](/getting-started/tutorials/angular-standalone-tutorial)
      - [Angular Monorepo](/getting-started/tutorials/angular-monorepo-tutorial)
      - [Vue Standalone](/getting-started/tutorials/vue-standalone-tutorial)
      - [Gradle Monorepo](/getting-started/tutorials/gradle-tutorial)
  - [Features](/features)
    - [Run Tasks](/features/run-tasks)
    - [Cache Task Results](/features/cache-task-results)
    - [Explore Your Workspace](/features/explore-graph)
    - [Generate Code](/features/generate-code)
    - [Automate Updating Dependencies](/features/automate-updating-dependencies)
    - [Enforce Module Boundaries](/features/enforce-module-boundaries)
    - [Manage Releases](/features/manage-releases)
    - [CI Features](/features/ci-features)
  - [Concepts](/concepts)
    - [Mental Model](/concepts/mental-model)
    - [How Caching Works](/concepts/how-caching-works)
    - [What is a Task Pipeline](/concepts/task-pipeline-configuration)
    - [What Are Nx Plugins](/concepts/nx-plugins)
    - [Inferred Tasks](/concepts/inferred-tasks)
    - [Types of Configuration](/concepts/types-of-configuration)
    - [Executors and Configurations](/concepts/executors-and-configurations)
    - [Common Tasks](/concepts/common-tasks)
    - [Nx Daemon](/concepts/nx-daemon)
    - [Sync Generators](/concepts/sync-generators)
    - [Nx and Turborepo](/concepts/turbo-and-nx)
    - [Buildable and Publishable Libraries](/concepts/buildable-and-publishable-libraries)
    - [Module Federation](/concepts/module-federation)
      - [Module Federation and Nx](/concepts/module-federation/module-federation-and-nx)
      - [Nx Module Federation Technical Overview](/concepts/module-federation/nx-module-federation-technical-overview)
      - [Faster Builds with Module Federation](/concepts/module-federation/faster-builds-with-module-federation)
      - [Micro Frontend Architecture](/concepts/module-federation/micro-frontend-architecture)
      - [Manage Library Versions with Module Federation](/concepts/module-federation/manage-library-versions-with-module-federation)
    - [Organizational Decisions](/concepts/decisions)
      - [Overview](/concepts/decisions/overview)
      - [Monorepos](/concepts/decisions/why-monorepos)
      - [Dependency Management](/concepts/decisions/dependency-management)
      - [Code Ownership](/concepts/decisions/code-ownership)
      - [Project Size](/concepts/decisions/project-size)
      - [Project Dependency Rules](/concepts/decisions/project-dependency-rules)
      - [Folder Structure](/concepts/decisions/folder-structure)
  - [Recipes](/recipes)
    - [Installation](/recipes/installation)
      - [Install Nx in a Non-Javascript Repo](/recipes/installation/install-non-javascript)
      - [Update Your Global Nx Installation](/recipes/installation/update-global-installation)
    - [Tasks & Caching](/recipes/running-tasks)
      - [Configure Inputs for Task Caching](/recipes/running-tasks/configure-inputs)
      - [Configure Outputs for Task Caching](/recipes/running-tasks/configure-outputs)
      - [Define a Task Pipeline](/recipes/running-tasks/defining-task-pipeline)
      - [Run Custom Commands](/recipes/running-tasks/run-commands-executor)
      - [Pass Args to Commands](/recipes/running-tasks/pass-args-to-commands)
      - [Run Tasks in Parallel](/recipes/running-tasks/run-tasks-in-parallel)
      - [Run Root-Level NPM Scripts with Nx](/recipes/running-tasks/root-level-scripts)
      - [Workspace Watching](/recipes/running-tasks/workspace-watching)
      - [Reduce Repetitive Configuration](/recipes/running-tasks/reduce-repetitive-configuration)
      - [Change Cache Location](/recipes/running-tasks/change-cache-location)
      - [Skip Task Caching](/recipes/running-tasks/skipping-cache)
      - [Migrate to Inferred Tasks (Project Crystal)](/recipes/running-tasks/convert-to-inferred)
    - [Adopting Nx](/recipes/adopting-nx)
      - [NPM/Yarn/PNPM workspaces](/recipes/adopting-nx/adding-to-monorepo)
      - [Migrate From Turborepo](/recipes/adopting-nx/from-turborepo)
      - [Add to any Project](/recipes/adopting-nx/adding-to-existing-project)
      - [Import an Existing Project into an Nx Workspace](/recipes/adopting-nx/import-project)
      - [Preserving Git Histories](/recipes/adopting-nx/preserving-git-histories)
      - [Manual migration](/recipes/adopting-nx/manual)
    - [Nx Release](/recipes/nx-release)
      - [Get Started with Nx Release](/recipes/nx-release/get-started-with-nx-release)
      - [Release Projects Independently](/recipes/nx-release/release-projects-independently)
      - [Updating Version References in Manifest Files (e.g. package.json)](/recipes/nx-release/updating-version-references)
      - [Automatically Version with Conventional Commits](/recipes/nx-release/automatically-version-with-conventional-commits)
      - [Customize Conventional Commit Types](/recipes/nx-release/customize-conventional-commit-types)
      - [File Based Versioning (Version Plans)](/recipes/nx-release/file-based-versioning-version-plans)
      - [Configure Custom Registries](/recipes/nx-release/configure-custom-registries)
      - [Publish in CI/CD](/recipes/nx-release/publish-in-ci-cd)
      - [Automate GitHub Releases](/recipes/nx-release/automate-github-releases)
      - [Publish Rust Crates](/recipes/nx-release/publish-rust-crates)
      - [Update Your Local Registry Setup to use Nx Release](/recipes/nx-release/update-local-registry-setup)
      - [Configure Changelog Format](/recipes/nx-release/configure-changelog-format)
      - [Build Before Versioning](/recipes/nx-release/build-before-versioning)
      - [Configuring Version Prefix for Dependency Versions](/recipes/nx-release/configuration-version-prefix)
    - [Module Federation](/recipes/module-federation)
      - [How to create a Module Federation Host Application](/recipes/module-federation/create-a-host)
      - [How to create a Module Federation Remote Application](/recipes/module-federation/create-a-remote)
      - [How to Federate a Module](/recipes/module-federation/federate-a-module)
    - [Nx Console](/recipes/nx-console)
      - [Telemetry](/recipes/nx-console/console-telemetry)
      - [Project Details View](/recipes/nx-console/console-project-details)
      - [Generate Command](/recipes/nx-console/console-generate-command)
      - [Run Command](/recipes/nx-console/console-run-command)
      - [Nx Cloud Integration](/recipes/nx-console/console-nx-cloud)
      - [Troubleshooting](/recipes/nx-console/console-troubleshooting)
    - [React](/recipes/react)
      - [React Native with Nx](/recipes/react/react-native)
      - [Remix with Nx](/recipes/react/remix)
      - [Use Environment Variables in React](/recipes/react/use-environment-variables-in-react)
      - [Using Tailwind CSS in React](/recipes/react/using-tailwind-css-in-react)
      - [Adding Images, Fonts, and Files](/recipes/react/adding-assets-react)
      - [Setup Module Federation with SSR for React](/recipes/react/module-federation-with-ssr)
      - [Deploying Next.js applications to Vercel](/recipes/react/deploy-nextjs-to-vercel)
      - [React Compiler with Nx](/recipes/react/react-compiler)
    - [Angular](/recipes/angular)
      - [Migration](/recipes/angular/migration)
        - [Migrating from Angular CLI](/recipes/angular/migration/angular)
        - [Migrating From Multiple Angular CLI Repos](/recipes/angular/migration/angular-multiple)
      - [Use Environment Variables in Angular](/recipes/angular/use-environment-variables-in-angular)
      - [Using Tailwind CSS with Angular projects](/recipes/angular/using-tailwind-css-with-angular-projects)
      - [Setup Module Federation with SSR for Angular](/recipes/angular/module-federation-with-ssr)
      - [Advanced Micro Frontends with Angular using Dynamic Federation](/recipes/angular/dynamic-module-federation-with-angular)
      - [Setup incremental builds for Angular applications](/recipes/angular/setup-incremental-builds-angular)
    - [Node](/recipes/node)
      - [Deploying a Node App to Fly.io](/recipes/node/node-server-fly-io)
      - [Add and Deploy Netlify Edge Functions with Node](/recipes/node/node-serverless-functions-netlify)
      - [Deploying AWS lambda in Node.js (deprecated)](/recipes/node/node-aws-lambda)
      - [Set Up Application Proxies](/recipes/node/application-proxies)
      - [Wait for Tasks to Finish](/recipes/node/wait-for-tasks)
    - [Storybook](/recipes/storybook)
      - [Set up Storybook for React Projects](/recipes/storybook/overview-react)
      - [Set up Storybook for Angular Projects](/recipes/storybook/overview-angular)
      - [Set up Storybook for Vue Projects](/recipes/storybook/overview-vue)
      - [Configuring Storybook on Nx](/recipes/storybook/configuring-storybook)
      - [One main Storybook instance for all projects](/recipes/storybook/one-storybook-for-all)
      - [One Storybook instance per scope](/recipes/storybook/one-storybook-per-scope)
      - [One main Storybook instance using Storybook Composition](/recipes/storybook/one-storybook-with-composition)
      - [How to configure Webpack and Vite for Storybook](/recipes/storybook/custom-builder-configs)
      - [Setting up Storybook Interaction Tests with Nx](/recipes/storybook/storybook-interaction-tests)
      - [Upgrading Storybook using the Storybook CLI](/recipes/storybook/upgrading-storybook)
      - [Setting up Storybook Composition with Nx](/recipes/storybook/storybook-composition-setup)
      - [Angular: Set up Compodoc for Storybook on Nx](/recipes/storybook/angular-storybook-compodoc)
      - [Angular: Configuring styles and preprocessor options](/recipes/storybook/angular-configuring-styles)
    - [Cypress](/recipes/cypress)
      - [Component Testing](/recipes/cypress/cypress-component-testing)
      - [Using setupNodeEvents with Cypress preset](/recipes/cypress/cypress-setup-node-events)
      - [Cypress v11 Migration Guide](/recipes/cypress/cypress-v11-migration)
    - [Next](/recipes/next)
      - [How to configure Next.js plugins](/recipes/next/next-config-setup)
    - [Nuxt](/recipes/nuxt)
      - [Deploying Nuxt applications to Vercel](/recipes/nuxt/deploy-nuxt-to-vercel)
    - [Vite](/recipes/vite)
      - [Configure Vite on your Nx workspace](/recipes/vite/configure-vite)
    - [Webpack](/recipes/webpack)
      - [How to configure Webpack in your Nx workspace](/recipes/webpack/webpack-config-setup)
      - [Webpack plugins](/recipes/webpack/webpack-plugins)
    - [Enforce Module Boundaries](/recipes/enforce-module-boundaries)
      - [Ban Dependencies with Certain Tags](/recipes/enforce-module-boundaries/ban-dependencies-with-tags)
      - [Tag in Multiple Dimensions](/recipes/enforce-module-boundaries/tag-multiple-dimensions)
      - [Ban External Imports](/recipes/enforce-module-boundaries/ban-external-imports)
      - [Tags Allow List](/recipes/enforce-module-boundaries/tags-allow-list)
    - [Tips and tricks](/recipes/tips-n-tricks)
      - [Convert from a Standalone Repository to a Monorepo](/recipes/tips-n-tricks/standalone-to-monorepo)
      - [Configuring ESLint with Typescript](/recipes/tips-n-tricks/eslint)
      - [Enable Typescript Batch Mode](/recipes/tips-n-tricks/enable-tsc-batch-mode)
      - [Define Secondary Entrypoints for Typescript Packages](/recipes/tips-n-tricks/define-secondary-entrypoints)
      - [Compile Typescript Packages to Multiple Formats](/recipes/tips-n-tricks/compile-multiple-formats)
      - [Keep Nx Versions in Sync](/recipes/tips-n-tricks/keep-nx-versions-in-sync)
      - [Define Environment Variables](/recipes/tips-n-tricks/define-environment-variables)
      - [Configuring Browser Support](/recipes/tips-n-tricks/browser-support)
      - [Include Assets in Build](/recipes/tips-n-tricks/include-assets-in-build)
      - [Include All package.json Files as Projects](/recipes/tips-n-tricks/include-all-packagejson)
      - [Identify Dependencies Between Folders](/recipes/tips-n-tricks/identify-dependencies-between-folders)
      - [Disable Graph Links Created from Analyzing Source Files](/recipes/tips-n-tricks/analyze-source-files)
      - [Use JavaScript instead TypeScript](/recipes/tips-n-tricks/js-and-ts)
      - [Altering Migration Process](/recipes/tips-n-tricks/advanced-update)
      - [Using Yarn PnP](/recipes/tips-n-tricks/yarn-pnp)
      - [Switching to ESLint's flat config format](/recipes/tips-n-tricks/flat-config)
      - [Troubleshoot Nx Console Issues](/recipes/nx-console/console-troubleshooting)
  - [Enterprise](/nx-enterprise)
    - [Activate Powerpack](/nx-enterprise/activate-powerpack)
    - [Powerpack Features](/nx-enterprise/powerpack)
      - [Run Language-Agnostic Conformance Rules](/nx-enterprise/powerpack/conformance)
      - [Define Code Ownership at the Project Level](/nx-enterprise/powerpack/owners)
      - [Self-Host the Remote Cache](/nx-enterprise/powerpack/custom-caching)
  - [Showcase](/showcase)
    - [Nx with your favorite tech](/showcase/example-repos)
      - [Express](/showcase/example-repos/add-express)
      - [Lit](/showcase/example-repos/add-lit)
      - [Solid](/showcase/example-repos/add-solid)
      - [Qwik](/showcase/example-repos/add-qwik)
      - [Rust](/showcase/example-repos/add-rust)
      - [.NET](/showcase/example-repos/add-dotnet)
      - [Astro](/showcase/example-repos/add-astro)
      - [Svelte](/showcase/example-repos/add-svelte)
      - [Fastify](/showcase/example-repos/add-fastify)
      - [Apollo GraphQL](/showcase/example-repos/apollo-react)
      - [Prisma with NestJS](/showcase/example-repos/nestjs-prisma)
      - [Mongo with Fastify](/showcase/example-repos/mongo-fastify)
      - [Redis with Fastify](/showcase/example-repos/redis-fastify)
      - [Postgres with Fastify](/showcase/example-repos/postgres-fastify)
      - [PlanetScale with Serverless Fastify](/showcase/example-repos/serverless-fastify-planetscale)
      - [Nx with Micro-frontends](/showcase/example-repos/mfe)
    - [Benchmarks](/showcase/benchmarks)
      - [Typescript Batch Mode Compilation](/showcase/benchmarks/tsc-batch-mode)
      - [Large Repo and Caching](/showcase/benchmarks/caching)
      - [Large Repo and DTE](/showcase/benchmarks/dte)
  - [Reference](/reference)
    - [Commands](/reference/nx-commands)
    - [Nx Configuration](/reference/nx-json)
    - [Project Configuration](/reference/project-configuration)
    - [Inputs and Named Inputs](/reference/inputs)
    - [.nxignore](/reference/nxignore)
    - [Environment Variables](/reference/environment-variables)
    - [Glossary](/reference/glossary)
    - [Releases](/reference/releases)
  - [Troubleshooting](/troubleshooting)
    - [Resolve Circular Dependencies](/troubleshooting/resolve-circular-dependencies)
    - [Troubleshoot Nx Install Issues](/troubleshooting/troubleshoot-nx-install-issues)
    - [Troubleshoot Cache Misses](/troubleshooting/troubleshoot-cache-misses)
    - [Unknown Local Cache Error](/troubleshooting/unknown-local-cache)
    - [Profiling Build Performance](/troubleshooting/performance-profiling)
    - [Troubleshoot Convert to Inferred Migration](/troubleshooting/convert-to-inferred)
  - [Deprecated](/deprecated)
    - [affected:graph](/deprecated/affected-graph)
    - [print-affected](/deprecated/print-affected)
    - [workspace.json](/deprecated/workspace-json)
    - [As Provided vs. Derived](/deprecated/as-provided-vs-derived)
    - [Workspace Generators](/deprecated/workspace-generators)
    - [Legacy Cache](/deprecated/legacy-cache)
    - [Workspace Executors](/deprecated/workspace-executors)
    - [runtimeCacheInputs](/deprecated/runtime-cache-inputs)
    - [cacheableOperations](/deprecated/cacheable-operations)
    - [npmScope](/deprecated/npm-scope)
    - [globalImplicitDependencies](/deprecated/global-implicit-dependencies)
    - [Angular Schematics and Builders](/deprecated/angular-schematics-builders)
    - [v1 Nx Plugin API](/deprecated/v1-nx-plugin-api)
    - [Rescope Packages from @nrwl to @nx](/deprecated/rescope)
    - [Integrated Repos vs. Package-Based Repos vs. Standalone Apps](/deprecated/integrated-vs-package-based)
  - [See Also](/see-also)
    - [Site Map](/see-also/sitemap)

- Extending-nx

  - [Intro](/extending-nx/intro)
    - [Extending Nx with Plugins](/extending-nx/intro/getting-started)
  - [Tutorials](/extending-nx/tutorials)
    - [Enforce Organizational Best Practices](/extending-nx/tutorials/organization-specific-plugin)
    - [Create a Tooling Plugin](/extending-nx/tutorials/tooling-plugin)
  - [Recipes](/extending-nx/recipes)
    - [Write a Simple Generator](/extending-nx/recipes/local-generators)
    - [Compose Generators](/extending-nx/recipes/composing-generators)
    - [Provide Options for Generators](/extending-nx/recipes/generator-options)
    - [Create Files](/extending-nx/recipes/creating-files)
    - [Modify Files](/extending-nx/recipes/modifying-files)
    - [Create a Sync Generator](/extending-nx/recipes/create-sync-generator)
    - [Write a Migration](/extending-nx/recipes/migration-generators)
    - [Write a Simple Executor](/extending-nx/recipes/local-executors)
    - [Compose Executors](/extending-nx/recipes/compose-executors)
    - [Create a Preset](/extending-nx/recipes/create-preset)
    - [Create an Install Package](/extending-nx/recipes/create-install-package)
    - [Infer Tasks or Projects](/extending-nx/recipes/project-graph-plugins)
    - [Publish a Plugin](/extending-nx/recipes/publish-plugin)

- Ci

  - [Intro](/ci/intro)
    - [CI with Nx](/ci/intro/ci-with-nx)
    - [Why Nx Cloud?](/ci/intro/why-nx-cloud)
    - [Connect to Nx Cloud](/ci/intro/connect-to-nx-cloud)
    - [Tutorials](/ci/intro/tutorials)
      - [Circle CI with Nx](/ci/intro/tutorials/circle)
      - [GitHub Actions with Nx](/ci/intro/tutorials/github-actions)
  - [Features](/ci/features)
    - [Run Only Tasks Affected by a PR](/ci/features/affected)
    - [Use Remote Caching (Nx Replay)](/ci/features/remote-cache)
    - [Distribute Task Execution (Nx Agents)](/ci/features/distribute-task-execution)
    - [Automatically Split E2E Tasks (Atomizer)](/ci/features/split-e2e-tasks)
    - [Identify and Re-run Flaky Tasks](/ci/features/flaky-tasks)
    - [Dynamically Allocate Agents](/ci/features/dynamic-agents)
    - [Explain With AI](/ci/features/explain-with-ai)
    - [GitHub Integration](/ci/features/github-integration)
  - [Concepts](/ci/concepts)
    - [The Building Blocks of Fast CI](/ci/concepts/building-blocks-fast-ci)
    - [Reduce Wasted Time in CI](/ci/concepts/reduce-waste)
    - [Parallelization and Distribution](/ci/concepts/parallelization-distribution)
    - [Cache Security](/ci/concepts/cache-security)
    - [Nx Cloud AI](/ci/concepts/nx-cloud-ai)
  - [Recipes](/ci/recipes)
    - [Set Up CI](/ci/recipes/set-up)
      - [Setting up Azure Pipelines](/ci/recipes/set-up/monorepo-ci-azure)
      - [Setting up CircleCI](/ci/recipes/set-up/monorepo-ci-circle-ci)
      - [Setting up GitHub Actions](/ci/recipes/set-up/monorepo-ci-github-actions)
      - [Setting up Jenkins](/ci/recipes/set-up/monorepo-ci-jenkins)
      - [Setting up GitLab](/ci/recipes/set-up/monorepo-ci-gitlab)
      - [Setting up Bitbucket](/ci/recipes/set-up/monorepo-ci-bitbucket-pipelines)
    - [Security](/ci/recipes/security)
      - [Authenticate with Google Identity](/ci/recipes/security/google-auth)
      - [CI Access Tokens](/ci/recipes/security/access-tokens)
      - [Personal Access Tokens](/ci/recipes/security/personal-access-tokens)
      - [Enable End to End Encryption](/ci/recipes/security/encryption)
    - [Source Control Integration](/ci/recipes/source-control-integration)
      - [Enable GitHub PR Integration](/ci/recipes/source-control-integration/github)
      - [Enable Bitbucket PR Integration](/ci/recipes/source-control-integration/bitbucket)
      - [Enable GitLab MR Integration](/ci/recipes/source-control-integration/gitlab)
      - [Enable Azure DevOps PR Integration](/ci/recipes/source-control-integration/azure-devops)
    - [Enterprise](/ci/recipes/enterprise)
      - [Single Tenant](/ci/recipes/enterprise/single-tenant)
        - [Single Tenant Nx Cloud Hosting](/ci/recipes/enterprise/single-tenant/overview)
        - [Authenticate with GitHub](/ci/recipes/enterprise/single-tenant/auth-github)
        - [Authenticate with GitLab](/ci/recipes/enterprise/single-tenant/auth-gitlab)
        - [Authenticate with BitBucket](/ci/recipes/enterprise/single-tenant/auth-bitbucket)
        - [Authenticate with BitBucket Data Center](/ci/recipes/enterprise/single-tenant/auth-bitbucket-data-center)
        - [Authenticate via SAML](/ci/recipes/enterprise/single-tenant/auth-saml)
        - [Custom GitHub App](/ci/recipes/enterprise/single-tenant/custom-github-app)
      - [Custom Distributed Task Execution](/ci/recipes/enterprise/dte)
        - [GitHub Actions Custom DTE](/ci/recipes/enterprise/dte/github-dte)
        - [Circle CI Custom DTE](/ci/recipes/enterprise/dte/circle-ci-dte)
        - [Azure Pipelines Custom DTE](/ci/recipes/enterprise/dte/azure-dte)
        - [Bitbucket Pipelines Custom DTE](/ci/recipes/enterprise/dte/bitbucket-dte)
        - [GitLab Custom DTE](/ci/recipes/enterprise/dte/gitlab-dte)
        - [Jenkins Custom DTE](/ci/recipes/enterprise/dte/jenkins-dte)
      - [Conformance](/ci/recipes/enterprise/conformance)
        - [Configure Conformance Rules in Nx Cloud](/ci/recipes/enterprise/conformance/configure-conformance-rules-in-nx-cloud)
        - [Publish Conformance Rules to Nx Cloud](/ci/recipes/enterprise/conformance/publish-conformance-rules-to-nx-cloud)
    - [Other](/ci/recipes/other)
      - [Record Non-Nx Commands](/ci/recipes/other/record-commands)
      - [Prepare applications for deployment via CI](/ci/recipes/other/ci-deployment)
      - [Reduce the Number of Affected Projects in a CI Pipeline Execution](/ci/recipes/other/cipe-affected-project-graph)
  - [Reference](/ci/reference)
    - [Configuration Options](/ci/reference/config)
    - [nx-cloud CLI](/ci/reference/nx-cloud-cli)
    - [Launch Templates](/ci/reference/launch-templates)
    - [Assignment Rules](/ci/reference/assignment-rules)
    - [Custom Steps](/ci/reference/custom-steps)
    - [Environment Variables](/ci/reference/env-vars)
    - [Release Notes](/ci/reference/release-notes)
  - [Troubleshooting](/ci/troubleshooting)
    - [CI Execution Failed](/ci/troubleshooting/ci-execution-failed)

- Nx-api
  - [angular](/nx-api/angular)
    - [documents](/nx-api/angular/documents)
      - [Overview](/nx-api/angular/documents/overview)
      - [Nx and the Angular CLI](/nx-api/angular/documents/nx-and-angular)
      - [Nx Devkit and Angular Devkit](/nx-api/angular/documents/nx-devkit-angular-devkit)
      - [Angular and Nx Version Matrix](/nx-api/angular/documents/angular-nx-version-matrix)
    - [executors](/nx-api/angular/executors)
      - [delegate-build](/nx-api/angular/executors/delegate-build)
      - [ng-packagr-lite](/nx-api/angular/executors/ng-packagr-lite)
      - [package](/nx-api/angular/executors/package)
      - [browser-esbuild](/nx-api/angular/executors/browser-esbuild)
      - [module-federation-dev-server](/nx-api/angular/executors/module-federation-dev-server)
      - [module-federation-dev-ssr](/nx-api/angular/executors/module-federation-dev-ssr)
      - [application](/nx-api/angular/executors/application)
      - [extract-i18n](/nx-api/angular/executors/extract-i18n)
      - [webpack-browser](/nx-api/angular/executors/webpack-browser)
      - [dev-server](/nx-api/angular/executors/dev-server)
      - [webpack-server](/nx-api/angular/executors/webpack-server)
    - [generators](/nx-api/angular/generators)
      - [add-linting](/nx-api/angular/generators/add-linting)
      - [application](/nx-api/angular/generators/application)
      - [component](/nx-api/angular/generators/component)
      - [component-story](/nx-api/angular/generators/component-story)
      - [component-test](/nx-api/angular/generators/component-test)
      - [convert-to-application-executor](/nx-api/angular/generators/convert-to-application-executor)
      - [directive](/nx-api/angular/generators/directive)
      - [federate-module](/nx-api/angular/generators/federate-module)
      - [init](/nx-api/angular/generators/init)
      - [library](/nx-api/angular/generators/library)
      - [library-secondary-entry-point](/nx-api/angular/generators/library-secondary-entry-point)
      - [remote](/nx-api/angular/generators/remote)
      - [move](/nx-api/angular/generators/move)
      - [convert-to-with-mf](/nx-api/angular/generators/convert-to-with-mf)
      - [host](/nx-api/angular/generators/host)
      - [ng-add](/nx-api/angular/generators/ng-add)
      - [ngrx](/nx-api/angular/generators/ngrx)
      - [ngrx-feature-store](/nx-api/angular/generators/ngrx-feature-store)
      - [ngrx-root-store](/nx-api/angular/generators/ngrx-root-store)
      - [pipe](/nx-api/angular/generators/pipe)
      - [scam-to-standalone](/nx-api/angular/generators/scam-to-standalone)
      - [scam](/nx-api/angular/generators/scam)
      - [scam-directive](/nx-api/angular/generators/scam-directive)
      - [scam-pipe](/nx-api/angular/generators/scam-pipe)
      - [setup-mf](/nx-api/angular/generators/setup-mf)
      - [setup-ssr](/nx-api/angular/generators/setup-ssr)
      - [setup-tailwind](/nx-api/angular/generators/setup-tailwind)
      - [stories](/nx-api/angular/generators/stories)
      - [storybook-configuration](/nx-api/angular/generators/storybook-configuration)
      - [cypress-component-configuration](/nx-api/angular/generators/cypress-component-configuration)
      - [web-worker](/nx-api/angular/generators/web-worker)
  - [create-nx-plugin](/nx-api/create-nx-plugin)
  - [create-nx-workspace](/nx-api/create-nx-workspace)
  - [cypress](/nx-api/cypress)
    - [documents](/nx-api/cypress/documents)
      - [Overview](/nx-api/cypress/documents/overview)
    - [executors](/nx-api/cypress/executors)
      - [cypress](/nx-api/cypress/executors/cypress)
    - [generators](/nx-api/cypress/generators)
      - [init](/nx-api/cypress/generators/init)
      - [configuration](/nx-api/cypress/generators/configuration)
      - [component-configuration](/nx-api/cypress/generators/component-configuration)
      - [migrate-to-cypress-11](/nx-api/cypress/generators/migrate-to-cypress-11)
      - [convert-to-inferred](/nx-api/cypress/generators/convert-to-inferred)
  - [detox](/nx-api/detox)
    - [documents](/nx-api/detox/documents)
      - [Overview](/nx-api/detox/documents/overview)
    - [executors](/nx-api/detox/executors)
      - [build](/nx-api/detox/executors/build)
      - [test](/nx-api/detox/executors/test)
    - [generators](/nx-api/detox/generators)
      - [init](/nx-api/detox/generators/init)
      - [application](/nx-api/detox/generators/application)
      - [convert-to-inferred](/nx-api/detox/generators/convert-to-inferred)
  - [devkit](/nx-api/devkit)
    - [documents](/nx-api/devkit/documents)
      - [Overview](/nx-api/devkit/documents/nx_devkit)
      - [Ng CLI Adapter](/nx-api/devkit/documents/ngcli_adapter)
  - [esbuild](/nx-api/esbuild)
    - [documents](/nx-api/esbuild/documents)
      - [Overview](/nx-api/esbuild/documents/overview)
    - [executors](/nx-api/esbuild/executors)
      - [esbuild](/nx-api/esbuild/executors/esbuild)
    - [generators](/nx-api/esbuild/generators)
      - [init](/nx-api/esbuild/generators/init)
      - [configuration](/nx-api/esbuild/generators/configuration)
  - [eslint](/nx-api/eslint)
    - [documents](/nx-api/eslint/documents)
      - [Overview](/nx-api/eslint/documents/overview)
    - [executors](/nx-api/eslint/executors)
      - [lint](/nx-api/eslint/executors/lint)
    - [generators](/nx-api/eslint/generators)
      - [init](/nx-api/eslint/generators/init)
      - [workspace-rules-project](/nx-api/eslint/generators/workspace-rules-project)
      - [workspace-rule](/nx-api/eslint/generators/workspace-rule)
      - [convert-to-flat-config](/nx-api/eslint/generators/convert-to-flat-config)
      - [convert-to-inferred](/nx-api/eslint/generators/convert-to-inferred)
  - [eslint-plugin](/nx-api/eslint-plugin)
    - [documents](/nx-api/eslint-plugin/documents)
      - [Overview](/nx-api/eslint-plugin/documents/overview)
      - [The `enforce-module-boundaries` rule](/nx-api/eslint-plugin/documents/enforce-module-boundaries)
      - [The `dependency-checks` rule](/nx-api/eslint-plugin/documents/dependency-checks)
  - [expo](/nx-api/expo)
    - [documents](/nx-api/expo/documents)
      - [Overview](/nx-api/expo/documents/overview)
    - [executors](/nx-api/expo/executors)
      - [update](/nx-api/expo/executors/update)
      - [build](/nx-api/expo/executors/build)
      - [build-list](/nx-api/expo/executors/build-list)
      - [run](/nx-api/expo/executors/run)
      - [start](/nx-api/expo/executors/start)
      - [sync-deps](/nx-api/expo/executors/sync-deps)
      - [ensure-symlink](/nx-api/expo/executors/ensure-symlink)
      - [prebuild](/nx-api/expo/executors/prebuild)
      - [install](/nx-api/expo/executors/install)
      - [export](/nx-api/expo/executors/export)
      - [submit](/nx-api/expo/executors/submit)
      - [serve](/nx-api/expo/executors/serve)
    - [generators](/nx-api/expo/generators)
      - [init](/nx-api/expo/generators/init)
      - [application](/nx-api/expo/generators/application)
      - [library](/nx-api/expo/generators/library)
      - [component](/nx-api/expo/generators/component)
      - [convert-to-inferred](/nx-api/expo/generators/convert-to-inferred)
  - [express](/nx-api/express)
    - [documents](/nx-api/express/documents)
      - [Overview](/nx-api/express/documents/overview)
    - [generators](/nx-api/express/generators)
      - [init](/nx-api/express/generators/init)
      - [application](/nx-api/express/generators/application)
  - [gradle](/nx-api/gradle)
    - [documents](/nx-api/gradle/documents)
      - [Overview](/nx-api/gradle/documents/overview)
    - [generators](/nx-api/gradle/generators)
      - [init](/nx-api/gradle/generators/init)
      - [ci-workflow](/nx-api/gradle/generators/ci-workflow)
  - [jest](/nx-api/jest)
    - [documents](/nx-api/jest/documents)
      - [Overview](/nx-api/jest/documents/overview)
    - [executors](/nx-api/jest/executors)
      - [jest](/nx-api/jest/executors/jest)
    - [generators](/nx-api/jest/generators)
      - [init](/nx-api/jest/generators/init)
      - [configuration](/nx-api/jest/generators/configuration)
      - [convert-to-inferred](/nx-api/jest/generators/convert-to-inferred)
  - [js](/nx-api/js)
    - [documents](/nx-api/js/documents)
      - [Overview](/nx-api/js/documents/overview)
      - [Configure TypeScript Project References in an Nx Workspace](/nx-api/js/documents/typescript-project-references)
    - [executors](/nx-api/js/executors)
      - [tsc](/nx-api/js/executors/tsc)
      - [swc](/nx-api/js/executors/swc)
      - [node](/nx-api/js/executors/node)
      - [release-publish](/nx-api/js/executors/release-publish)
      - [verdaccio](/nx-api/js/executors/verdaccio)
    - [generators](/nx-api/js/generators)
      - [library](/nx-api/js/generators/library)
      - [init](/nx-api/js/generators/init)
      - [convert-to-swc](/nx-api/js/generators/convert-to-swc)
      - [release-version](/nx-api/js/generators/release-version)
      - [setup-verdaccio](/nx-api/js/generators/setup-verdaccio)
      - [setup-build](/nx-api/js/generators/setup-build)
      - [typescript-sync](/nx-api/js/generators/typescript-sync)
      - [setup-prettier](/nx-api/js/generators/setup-prettier)
  - [module-federation](/nx-api/module-federation)
  - [nest](/nx-api/nest)
    - [documents](/nx-api/nest/documents)
      - [Overview](/nx-api/nest/documents/overview)
    - [generators](/nx-api/nest/generators)
      - [application](/nx-api/nest/generators/application)
      - [init](/nx-api/nest/generators/init)
      - [library](/nx-api/nest/generators/library)
      - [class](/nx-api/nest/generators/class)
      - [controller](/nx-api/nest/generators/controller)
      - [decorator](/nx-api/nest/generators/decorator)
      - [filter](/nx-api/nest/generators/filter)
      - [gateway](/nx-api/nest/generators/gateway)
      - [guard](/nx-api/nest/generators/guard)
      - [interceptor](/nx-api/nest/generators/interceptor)
      - [interface](/nx-api/nest/generators/interface)
      - [middleware](/nx-api/nest/generators/middleware)
      - [module](/nx-api/nest/generators/module)
      - [pipe](/nx-api/nest/generators/pipe)
      - [provider](/nx-api/nest/generators/provider)
      - [resolver](/nx-api/nest/generators/resolver)
      - [resource](/nx-api/nest/generators/resource)
      - [service](/nx-api/nest/generators/service)
  - [next](/nx-api/next)
    - [documents](/nx-api/next/documents)
      - [Overview](/nx-api/next/documents/overview)
    - [executors](/nx-api/next/executors)
      - [build](/nx-api/next/executors/build)
      - [server](/nx-api/next/executors/server)
    - [generators](/nx-api/next/generators)
      - [init](/nx-api/next/generators/init)
      - [application](/nx-api/next/generators/application)
      - [page](/nx-api/next/generators/page)
      - [component](/nx-api/next/generators/component)
      - [library](/nx-api/next/generators/library)
      - [custom-server](/nx-api/next/generators/custom-server)
      - [cypress-component-configuration](/nx-api/next/generators/cypress-component-configuration)
      - [convert-to-inferred](/nx-api/next/generators/convert-to-inferred)
  - [node](/nx-api/node)
    - [documents](/nx-api/node/documents)
      - [Overview](/nx-api/node/documents/overview)
    - [generators](/nx-api/node/generators)
      - [init](/nx-api/node/generators/init)
      - [application](/nx-api/node/generators/application)
      - [library](/nx-api/node/generators/library)
      - [setup-docker](/nx-api/node/generators/setup-docker)
  - [nuxt](/nx-api/nuxt)
    - [documents](/nx-api/nuxt/documents)
      - [Overview](/nx-api/nuxt/documents/overview)
    - [generators](/nx-api/nuxt/generators)
      - [init](/nx-api/nuxt/generators/init)
      - [application](/nx-api/nuxt/generators/application)
      - [storybook-configuration](/nx-api/nuxt/generators/storybook-configuration)
  - [nx](/nx-api/nx)
    - [documents](/nx-api/nx/documents)
      - [create-nx-workspace](/nx-api/nx/documents/create-nx-workspace)
      - [init](/nx-api/nx/documents/init)
      - [generate](/nx-api/nx/documents/generate)
      - [run](/nx-api/nx/documents/run)
      - [daemon](/nx-api/nx/documents/daemon)
      - [graph](/nx-api/nx/documents/dep-graph)
      - [run-many](/nx-api/nx/documents/run-many)
      - [affected](/nx-api/nx/documents/affected)
      - [format:check](/nx-api/nx/documents/format-check)
      - [format:write](/nx-api/nx/documents/format-write)
      - [migrate](/nx-api/nx/documents/migrate)
      - [report](/nx-api/nx/documents/report)
      - [list](/nx-api/nx/documents/list)
      - [connect-to-nx-cloud](/nx-api/nx/documents/connect-to-nx-cloud)
      - [reset](/nx-api/nx/documents/reset)
      - [repair](/nx-api/nx/documents/repair)
      - [sync](/nx-api/nx/documents/sync)
      - [sync:check](/nx-api/nx/documents/sync-check)
      - [import](/nx-api/nx/documents/import)
      - [exec](/nx-api/nx/documents/exec)
      - [watch](/nx-api/nx/documents/watch)
      - [show](/nx-api/nx/documents/show)
      - [view-logs](/nx-api/nx/documents/view-logs)
      - [release](/nx-api/nx/documents/release)
      - [add](/nx-api/nx/documents/add)
      - [login](/nx-api/nx/documents/login)
      - [logout](/nx-api/nx/documents/logout)
    - [executors](/nx-api/nx/executors)
      - [noop](/nx-api/nx/executors/noop)
      - [run-commands](/nx-api/nx/executors/run-commands)
      - [run-script](/nx-api/nx/executors/run-script)
    - [generators](/nx-api/nx/generators)
      - [connect-to-nx-cloud](/nx-api/nx/generators/connect-to-nx-cloud)
  - [playwright](/nx-api/playwright)
    - [documents](/nx-api/playwright/documents)
      - [Overview](/nx-api/playwright/documents/overview)
    - [executors](/nx-api/playwright/executors)
      - [playwright](/nx-api/playwright/executors/playwright)
    - [generators](/nx-api/playwright/generators)
      - [configuration](/nx-api/playwright/generators/configuration)
      - [init](/nx-api/playwright/generators/init)
      - [convert-to-inferred](/nx-api/playwright/generators/convert-to-inferred)
  - [plugin](/nx-api/plugin)
    - [documents](/nx-api/plugin/documents)
      - [Overview](/nx-api/plugin/documents/overview)
    - [generators](/nx-api/plugin/generators)
      - [plugin](/nx-api/plugin/generators/plugin)
      - [create-package](/nx-api/plugin/generators/create-package)
      - [e2e-project](/nx-api/plugin/generators/e2e-project)
      - [migration](/nx-api/plugin/generators/migration)
      - [generator](/nx-api/plugin/generators/generator)
      - [executor](/nx-api/plugin/generators/executor)
      - [plugin-lint-checks](/nx-api/plugin/generators/plugin-lint-checks)
      - [preset](/nx-api/plugin/generators/preset)
  - [react](/nx-api/react)
    - [documents](/nx-api/react/documents)
      - [Overview](/nx-api/react/documents/overview)
    - [executors](/nx-api/react/executors)
      - [module-federation-dev-server](/nx-api/react/executors/module-federation-dev-server)
      - [module-federation-ssr-dev-server](/nx-api/react/executors/module-federation-ssr-dev-server)
      - [module-federation-static-server](/nx-api/react/executors/module-federation-static-server)
    - [generators](/nx-api/react/generators)
      - [init](/nx-api/react/generators/init)
      - [application](/nx-api/react/generators/application)
      - [library](/nx-api/react/generators/library)
      - [component](/nx-api/react/generators/component)
      - [redux](/nx-api/react/generators/redux)
      - [storybook-configuration](/nx-api/react/generators/storybook-configuration)
      - [component-story](/nx-api/react/generators/component-story)
      - [stories](/nx-api/react/generators/stories)
      - [hook](/nx-api/react/generators/hook)
      - [host](/nx-api/react/generators/host)
      - [remote](/nx-api/react/generators/remote)
      - [cypress-component-configuration](/nx-api/react/generators/cypress-component-configuration)
      - [component-test](/nx-api/react/generators/component-test)
      - [setup-tailwind](/nx-api/react/generators/setup-tailwind)
      - [setup-ssr](/nx-api/react/generators/setup-ssr)
      - [federate-module](/nx-api/react/generators/federate-module)
  - [react-native](/nx-api/react-native)
    - [documents](/nx-api/react-native/documents)
      - [Overview](/nx-api/react-native/documents/overview)
    - [executors](/nx-api/react-native/executors)
      - [run-android](/nx-api/react-native/executors/run-android)
      - [run-ios](/nx-api/react-native/executors/run-ios)
      - [bundle](/nx-api/react-native/executors/bundle)
      - [build-android](/nx-api/react-native/executors/build-android)
      - [build-ios](/nx-api/react-native/executors/build-ios)
      - [start](/nx-api/react-native/executors/start)
      - [sync-deps](/nx-api/react-native/executors/sync-deps)
      - [ensure-symlink](/nx-api/react-native/executors/ensure-symlink)
      - [storybook](/nx-api/react-native/executors/storybook)
      - [pod-install](/nx-api/react-native/executors/pod-install)
      - [upgrade](/nx-api/react-native/executors/upgrade)
    - [generators](/nx-api/react-native/generators)
      - [init](/nx-api/react-native/generators/init)
      - [application](/nx-api/react-native/generators/application)
      - [library](/nx-api/react-native/generators/library)
      - [component](/nx-api/react-native/generators/component)
      - [storybook-configuration](/nx-api/react-native/generators/storybook-configuration)
      - [component-story](/nx-api/react-native/generators/component-story)
      - [stories](/nx-api/react-native/generators/stories)
      - [upgrade-native](/nx-api/react-native/generators/upgrade-native)
      - [web-configuration](/nx-api/react-native/generators/web-configuration)
      - [convert-to-inferred](/nx-api/react-native/generators/convert-to-inferred)
  - [remix](/nx-api/remix)
    - [documents](/nx-api/remix/documents)
      - [Overview](/nx-api/remix/documents/overview)
    - [executors](/nx-api/remix/executors)
      - [serve](/nx-api/remix/executors/serve)
      - [build](/nx-api/remix/executors/build)
    - [generators](/nx-api/remix/generators)
      - [preset](/nx-api/remix/generators/preset)
      - [setup](/nx-api/remix/generators/setup)
      - [application](/nx-api/remix/generators/application)
      - [cypress-component-configuration](/nx-api/remix/generators/cypress-component-configuration)
      - [library](/nx-api/remix/generators/library)
      - [init](/nx-api/remix/generators/init)
      - [route](/nx-api/remix/generators/route)
      - [resource-route](/nx-api/remix/generators/resource-route)
      - [action](/nx-api/remix/generators/action)
      - [loader](/nx-api/remix/generators/loader)
      - [style](/nx-api/remix/generators/style)
      - [setup-tailwind](/nx-api/remix/generators/setup-tailwind)
      - [storybook-configuration](/nx-api/remix/generators/storybook-configuration)
      - [meta](/nx-api/remix/generators/meta)
      - [error-boundary](/nx-api/remix/generators/error-boundary)
      - [convert-to-inferred](/nx-api/remix/generators/convert-to-inferred)
  - [rollup](/nx-api/rollup)
    - [executors](/nx-api/rollup/executors)
      - [rollup](/nx-api/rollup/executors/rollup)
    - [generators](/nx-api/rollup/generators)
      - [init](/nx-api/rollup/generators/init)
      - [configuration](/nx-api/rollup/generators/configuration)
      - [convert-to-inferred](/nx-api/rollup/generators/convert-to-inferred)
  - [rsbuild](/nx-api/rsbuild)
    - [generators](/nx-api/rsbuild/generators)
      - [init](/nx-api/rsbuild/generators/init)
      - [configuration](/nx-api/rsbuild/generators/configuration)
  - [rspack](/nx-api/rspack)
    - [documents](/nx-api/rspack/documents)
      - [Overview](/nx-api/rspack/documents/overview)
    - [executors](/nx-api/rspack/executors)
      - [rspack](/nx-api/rspack/executors/rspack)
      - [dev-server](/nx-api/rspack/executors/dev-server)
      - [ssr-dev-server](/nx-api/rspack/executors/ssr-dev-server)
      - [module-federation-dev-server](/nx-api/rspack/executors/module-federation-dev-server)
      - [module-federation-ssr-dev-server](/nx-api/rspack/executors/module-federation-ssr-dev-server)
      - [module-federation-static-server](/nx-api/rspack/executors/module-federation-static-server)
    - [generators](/nx-api/rspack/generators)
      - [configuration](/nx-api/rspack/generators/configuration)
      - [init](/nx-api/rspack/generators/init)
      - [preset](/nx-api/rspack/generators/preset)
      - [application](/nx-api/rspack/generators/application)
      - [convert-webpack](/nx-api/rspack/generators/convert-webpack)
      - [convert-config-to-rspack-plugin](/nx-api/rspack/generators/convert-config-to-rspack-plugin)
      - [convert-to-inferred](/nx-api/rspack/generators/convert-to-inferred)
  - [storybook](/nx-api/storybook)
    - [documents](/nx-api/storybook/documents)
      - [Overview](/nx-api/storybook/documents/overview)
      - [Storybook best practices for making the most out of Nx](/nx-api/storybook/documents/best-practices)
      - [Storybook 7](/nx-api/storybook/documents/storybook-7-setup)
    - [executors](/nx-api/storybook/executors)
      - [storybook](/nx-api/storybook/executors/storybook)
      - [build](/nx-api/storybook/executors/build)
    - [generators](/nx-api/storybook/generators)
      - [init](/nx-api/storybook/generators/init)
      - [configuration](/nx-api/storybook/generators/configuration)
      - [cypress-project](/nx-api/storybook/generators/cypress-project)
      - [convert-to-inferred](/nx-api/storybook/generators/convert-to-inferred)
      - [migrate-7](/nx-api/storybook/generators/migrate-7)
      - [migrate-8](/nx-api/storybook/generators/migrate-8)
  - [vite](/nx-api/vite)
    - [documents](/nx-api/vite/documents)
      - [Overview](/nx-api/vite/documents/overview)
    - [executors](/nx-api/vite/executors)
      - [dev-server](/nx-api/vite/executors/dev-server)
      - [build](/nx-api/vite/executors/build)
      - [test](/nx-api/vite/executors/test)
      - [preview-server](/nx-api/vite/executors/preview-server)
    - [generators](/nx-api/vite/generators)
      - [init](/nx-api/vite/generators/init)
      - [configuration](/nx-api/vite/generators/configuration)
      - [setup-paths-plugin](/nx-api/vite/generators/setup-paths-plugin)
      - [convert-to-inferred](/nx-api/vite/generators/convert-to-inferred)
      - [vitest](/nx-api/vite/generators/vitest)
  - [vue](/nx-api/vue)
    - [documents](/nx-api/vue/documents)
      - [Overview](/nx-api/vue/documents/overview)
    - [generators](/nx-api/vue/generators)
      - [init](/nx-api/vue/generators/init)
      - [application](/nx-api/vue/generators/application)
      - [library](/nx-api/vue/generators/library)
      - [component](/nx-api/vue/generators/component)
      - [setup-tailwind](/nx-api/vue/generators/setup-tailwind)
      - [storybook-configuration](/nx-api/vue/generators/storybook-configuration)
      - [stories](/nx-api/vue/generators/stories)
  - [web](/nx-api/web)
    - [documents](/nx-api/web/documents)
      - [Overview](/nx-api/web/documents/overview)
    - [executors](/nx-api/web/executors)
      - [file-server](/nx-api/web/executors/file-server)
    - [generators](/nx-api/web/generators)
      - [init](/nx-api/web/generators/init)
      - [application](/nx-api/web/generators/application)
      - [static-config](/nx-api/web/generators/static-config)
  - [webpack](/nx-api/webpack)
    - [documents](/nx-api/webpack/documents)
      - [Overview](/nx-api/webpack/documents/overview)
    - [executors](/nx-api/webpack/executors)
      - [webpack](/nx-api/webpack/executors/webpack)
      - [dev-server](/nx-api/webpack/executors/dev-server)
      - [ssr-dev-server](/nx-api/webpack/executors/ssr-dev-server)
    - [generators](/nx-api/webpack/generators)
      - [init](/nx-api/webpack/generators/init)
      - [configuration](/nx-api/webpack/generators/configuration)
      - [convert-config-to-webpack-plugin](/nx-api/webpack/generators/convert-config-to-webpack-plugin)
      - [convert-to-inferred](/nx-api/webpack/generators/convert-to-inferred)
  - [workspace](/nx-api/workspace)
    - [documents](/nx-api/workspace/documents)
      - [Overview](/nx-api/workspace/documents/overview)
      - [Nx, NodeJS and Typescript Versions](/nx-api/workspace/documents/nx-nodejs-typescript-version-matrix)
    - [executors](/nx-api/workspace/executors)
      - [counter](/nx-api/workspace/executors/counter)
    - [generators](/nx-api/workspace/generators)
      - [preset](/nx-api/workspace/generators/preset)
      - [move](/nx-api/workspace/generators/move)
      - [remove](/nx-api/workspace/generators/remove)
      - [convert-to-monorepo](/nx-api/workspace/generators/convert-to-monorepo)
      - [new](/nx-api/workspace/generators/new)
      - [run-commands](/nx-api/workspace/generators/run-commands)
      - [fix-configuration](/nx-api/workspace/generators/fix-configuration)
      - [npm-package](/nx-api/workspace/generators/npm-package)
      - [ci-workflow](/nx-api/workspace/generators/ci-workflow)
      - [infer-targets](/nx-api/workspace/generators/infer-targets)
  - [powerpack-azure-cache](/nx-api/powerpack-azure-cache)
    - [documents](/nx-api/powerpack-azure-cache/documents)
      - [Overview](/nx-api/powerpack-azure-cache/documents/overview)
  - [powerpack-conformance](/nx-api/powerpack-conformance)
    - [documents](/nx-api/powerpack-conformance/documents)
      - [Overview](/nx-api/powerpack-conformance/documents/overview)
    - [executors](/nx-api/powerpack-conformance/executors)
      - [bundle-rules](/nx-api/powerpack-conformance/executors/bundle-rules)
  - [powerpack-enterprise-cloud](/nx-api/powerpack-enterprise-cloud)
    - [generators](/nx-api/powerpack-enterprise-cloud/generators)
      - [init](/nx-api/powerpack-enterprise-cloud/generators/init)
  - [powerpack-gcs-cache](/nx-api/powerpack-gcs-cache)
    - [documents](/nx-api/powerpack-gcs-cache/documents)
      - [Overview](/nx-api/powerpack-gcs-cache/documents/overview)
  - [powerpack-license](/nx-api/powerpack-license)
  - [powerpack-owners](/nx-api/powerpack-owners)
    - [documents](/nx-api/powerpack-owners/documents)
      - [Overview](/nx-api/powerpack-owners/documents/overview)
    - [generators](/nx-api/powerpack-owners/generators)
      - [init](/nx-api/powerpack-owners/generators/init)
      - [sync-codeowners-file](/nx-api/powerpack-owners/generators/sync-codeowners-file)
  - [powerpack-s3-cache](/nx-api/powerpack-s3-cache)
    - [documents](/nx-api/powerpack-s3-cache/documents)
      - [Overview](/nx-api/powerpack-s3-cache/documents/overview)
    - [generators](/nx-api/powerpack-s3-cache/generators)
      - [init](/nx-api/powerpack-s3-cache/generators/init)
  - [powerpack-shared-fs-cache](/nx-api/powerpack-shared-fs-cache)
    - [documents](/nx-api/powerpack-shared-fs-cache/documents)
      - [Overview](/nx-api/powerpack-shared-fs-cache/documents/overview)
    - [generators](/nx-api/powerpack-shared-fs-cache/generators)
      - [init](/nx-api/powerpack-shared-fs-cache/generators/init)
