# Environment Variables

The following environment variables are ones that you can set to change the behavior of Nx in different environments.

| Property                       | Type    | Description                                                                                                                                                                                                                                                                                                   |
| ------------------------------ | ------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| NX_ADD_PLUGINS                 | boolean | If set to `false`, Nx will not add plugins to infer tasks. This is `true` by default. Workspaces created before Nx 18 will have this disabled via a migration for backwards compatibility                                                                                                                     |
| NX_ADD_TS_PLUGIN               | boolean | If set to `false` when creating a new workspace using the `ts` preset, Nx will not add the `@nx/js/typescript` plugin to infer tasks and will not set up the workspace with [TypeScript project references](https://www.typescriptlang.org/docs/handbook/project-references.html). This is `true` by default. |
| NX_BASE                        | string  | The default base branch to use when calculating the affected projects. Can be overridden on the command line with `--base`.                                                                                                                                                                                   |
| NX_CACHE_DIRECTORY             | string  | The cache for task outputs is stored in `.nx/cache` by default. Set this variable to use a different directory.                                                                                                                                                                                               |
| NX_CACHE_PROJECT_GRAPH         | boolean | If set to `false`, disables the project graph cache. Most useful when developing a plugin that modifies the project graph.                                                                                                                                                                                    |
| NX_DAEMON                      | boolean | If set to `false`, disables the Nx daemon process. Disable the daemon to print `console.log` statements in plugin code you are developing.                                                                                                                                                                    |
| NX_DEFAULT_PROJECT             | string  | The default project used for commands which require a project. e.g. `nx build`, `nx g component`, etc.                                                                                                                                                                                                        |
| NX_HEAD                        | string  | The default head branch to use when calculating the affected projects. Can be overridden on the command line with `--head`.                                                                                                                                                                                   |
| NX_PERF_LOGGING                | boolean | If set to `true`, will print debug information useful for profiling executors and Nx itself                                                                                                                                                                                                                   |
| NX_PROFILE                     | string  | Prepend `NX_PROFILE=profile.json` before running targets with Nx to generate a file that be [loaded in Chrome dev tools](/troubleshooting/performance-profiling) to visualize the performance of Nx across multiple processes.                                                                                |
| NX_WORKSPACE_DATA_DIRECTORY    | string  | The project graph cache and some other internal nx caches are stored in `.nx/workspace-data` by default. Set this variable to use a different directory.                                                                                                                                                      |
| NX_PARALLEL                    | number  | The number of tasks Nx should run in parallel. Overrides any configured value inside nx.json                                                                                                                                                                                                                  |
| NX_RUNNER                      | string  | The name of task runner from the config to use. Can be overridden on the command line with `--runner`. Not read if `NX_TASKS_RUNNER` is set.                                                                                                                                                                  |
| NX_SKIP_NX_CACHE               | boolean | Rerun the tasks even when the results are available in the cache                                                                                                                                                                                                                                              |
| NX_TASKS_RUNNER                | string  | The name of task runner from the config to use. Can be overridden on the command line with `--runner`. Preferred over `NX_RUNNER`.                                                                                                                                                                            |
| NX_TASKS_RUNNER_DYNAMIC_OUTPUT | boolean | If set to `false`, will use non-dynamic terminal output strategy (what you see in CI), even when you terminal can support the dynamic version                                                                                                                                                                 |
| NX_VERBOSE_LOGGING             | boolean | If set to `true`, will print debug information useful for troubleshooting                                                                                                                                                                                                                                     |
| NX_DRY_RUN                     | boolean | If set to `true`, will perform a dry run of the generator. No files will be created and no packages will be installed.                                                                                                                                                                                        |
| NX_INTERACTIVE                 | boolean | If set to `true`, will allow Nx to prompt you in the terminal to answer some further questions when running generators.                                                                                                                                                                                       |
| NX_GENERATE_QUIET              | boolean | If set to `true`, will prevent Nx logging file operations during generate                                                                                                                                                                                                                                     |
| NX_PREFER_TS_NODE              | boolean | If set to `true`, Nx will use `ts-node` for local execution of plugins even if `@swc-node/register` is installed.                                                                                                                                                                                             |
| NX_IGNORE_CYCLES               | boolean | If set to `true`, Nx will ignore errors created by a task graph circular dependency. Can be overridden on the command line with `--nxIgnoreCycles`                                                                                                                                                            |
| NX_BATCH_MODE                  | boolean | If set to `true`, Nx will run task(s) in batches for executors which support batches.                                                                                                                                                                                                                         |
| NX_SKIP_LOG_GROUPING           | boolean | If set to `true`, Nx will not group command's logs on CI.                                                                                                                                                                                                                                                     |
| NX_MIGRATE_CLI_VERSION         | string  | The version of Nx to use for running the `nx migrate` command. If not set, it defaults to `latest`.                                                                                                                                                                                                           |
| NX_LOAD_DOT_ENV_FILES          | boolean | If set to 'false', Nx will not load any environment files (e.g. `.local.env`, `.env.local`)                                                                                                                                                                                                                   |
| NX_NATIVE_FILE_CACHE_DIRECTORY | string  | The cache for native `.node` files is stored under a global temp directory by default. Set this variable to use a different directory. This is interpreted as an absolute path.                                                                                                                               |
| NX_PLUGIN_NO_TIMEOUTS          | boolean | If set to `true`, plugin operations will not timeout                                                                                                                                                                                                                                                          |

Nx will set the following environment variables so they can be accessible within the process even outside of executors and generators.

| Property                     | Type    | Description                                                                                                                                               |
| ---------------------------- | ------- | --------------------------------------------------------------------------------------------------------------------------------------------------------- |
| NX_TASK_TARGET_PROJECT       | string  | Set to the project name of the task being run. Use this to tell which project is being run.                                                               |
| NX_TASK_TARGET_TARGET        | string  | Set to the target name of the task being run. Use this to tell which target of the project is being run.                                                  |
| NX_TASK_TARGET_CONFIGURATION | string  | Set to the configuration name of the task being run. Use this to tell which configuration of the target is being run.                                     |
| NX_GRAPH_CREATION            | boolean | Set to `true` during the graph creation process. Use this to have inference plugins run different code during graph creation versus during task execution |
| NX_DRY_RUN                   | boolean | Set to `true` during dry runs of generators. Use this to avoid side effects during generators.                                                            |
| NX_INTERACTIVE               | boolean | Set to `false` when running generators with `--interactive=false`. Use this to prevent prompting during generators                                        |

[Nx Cloud Environment Variables](/ci/reference/env-vars) are listed on a dedicated page.
