# Convert from a Standalone Repository to a Monorepo

You can always add another app to a standalone repository the same way you would in a monorepo. But at some point, you may want to move the primary app out of the root of your repo because the repo is no longer primarily focused on that one app. There are other apps that are equally important and you want the folder structure to align with the new reality.

{% youtube
src="https://youtu.be/ztNpLf2Zl-c?si=u0CfLAx_tpioZ3Vu"
title="Graduating your Standalone Nx Repo to a Monorepo"
width="100%" /%}

## Run the Generator

The `convert-to-monorepo` generator will attempt to convert a standalone repo to a monorepo.

```shell
nx g convert-to-monorepo
```

If you need to do the conversion manually, you can follow the steps below.

## Manual Conversion Strategy

For this recipe, we'll assume that the root-level app is named `my-app`. The high-level process we'll go through to move the app involves four stages:

1. Create a new app named `temp` under `apps/temp`.
2. Move source and config files from `my-app` into `apps/temp`.
3. Delete the files for `my-app`.
4. Rename `apps/temp` to `apps/my-app`

## Steps

1. Update the `workspaceLayout` property in `nx.json` to be:

   ```jsonc {% fileName="nx.json" %}
   {
     "workspaceLayout": {
       "appsDir": "apps",
       "libsDir": "libs"
     }
   }
   ```

   This will make sure that new apps are created under `apps` and new libraries are created under `libs`.

2. If there is a `tsconfig.json` file in the root, rename it to `tsconfig.old.json`

   This step is to make sure that a `tsconfig.base.json` file is generated by the app generator in the next step.

3. Create a new app using the appropriate plugin under `apps/temp`

   ```shell
   nx g app apps/temp
   ```

4. Move the `/src` (and `/public`, if present) folders to `apps/temp/`, overwriting the folders already there.

5. For each config file in `apps/temp`, copy over the corresponding file from the root of the repo.

   It can be difficult to know which files are root-level config files and which files are project-specific config files. Here is a non-exhaustive list of config files to help distinguish between the two.

   | Type of Config  | Files                                                                                                                                                                       |
   | --------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
   | _Root-level_    | `.eslintignore`, `.eslintrc.base.json`, `.gitignore`, `.prettierignore`, `jest.config.ts`, `jest.preset.js`, `.prettierrc`, `nx.json`, `package.json`, `tsconfig.base.json` |
   | _Project-level_ | `.eslintrc.json`, `index.html`, `project.json`, `jest.config.app.ts`, `tsconfig.app.json`, `tsconfig.json`, `tsconfig.spec.json`, `vite.config.ts`, `webpack.config.js`     |

   {% callout title="jest.config.app.ts" type="note" %}
   `jest.config.app.ts` in the root should be renamed to `jest.config.ts` when moved to `apps/temp`. Also update the `jestConfig` option in `project.json` to point to `jest.config.ts` instead of `jest.config.app.ts`.
   {% /callout %}

6. Update the paths of the project-specific config files that were copied into `apps/temp`.

   Here is a non-exhaustive list of properties that will need to be updated to have the correct path:

   | Config File(s)                                             | Properties to Check                                                                                                                                                   |
   | ---------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
   | `project.json`                                             | `$schema`, `sourceRoot`, `root`, `outputPath`, `reportsDirectory`, `cypressConfig`, `lintFilePatterns`, `index`, `main`, `tsConfig`, `assets`, `styles`, `jestConfig` |
   | `tsconfig.json`, `tsconfig.app.json`, `tsconfig.spec.json` | `extends`, `outDir`, `files`                                                                                                                                          |
   | `.eslintrc.json`                                           | `extends`                                                                                                                                                             |
   | `jest.config.ts`                                           | `preset`, `coverageDirectory`                                                                                                                                         |
   | `vite.config.ts`                                           | `cacheDir`, `root`, `dir`                                                                                                                                             |

7. Doublecheck that all the tasks defined in the `apps/temp/project.json` file still work.

   ```shell
   nx build temp
   nx test temp
   nx lint temp
   ```

8. Move the `/e2e/src` folder to `/apps/temp-e2e`, overwriting the folder already there
9. For each config file in `apps/temp-e2e`, copy over the corresponding file from the root of the repo. Update the paths for these files in the same way you did for the `my-app` config files.
10. Update the `/apps/temp-e2e/project.json` `implicitDependencies` to be `temp` instead of `my-app`
11. Doublecheck that all the tasks defined in the `apps/temp-e2e/project.json` file still work.

    ```shell
    nx lint temp-e2e
    nx e2e temp-e2e
    ```

12. Delete all the project specific config files in the root and under `e2e`
13. Once the `project.json` file has been deleted in the root, rename `temp-e2e` to `my-app-e2e` and rename `temp` to `my-app`

    ```shell
    nx g move --projectName=temp-e2e --destination=my-app-e2e
    nx g move --projectName=temp --destination=my-app
    ```

14. Update the `defaultProject` in `nx.json` if needed
15. Check again that all the tasks still work and that the `nx graph` displays what you expect.
