---
title: How Storybook is configured on your Nx workspace
description: This guide explains how Storybook is configured on your Nx workspace.
---

# Configuring Storybook on Nx

{% callout type="info" title="Best practices" %}
Read our [Using Storybook in a Nx workspace - Best practices](/nx-api/storybook/documents/best-practices) guide!
{% /callout %}

Nx does not generate a root Storybook directory and shared root Storybook configurations. Instead, it only generates a Storybook configuration for each project in your workspace. You may still manually create a root Storybook configuration file, if it is needed for your use case.

You can read all about creating and using a root Storybook configuration in our guide [How to configure Webpack and Vite for Storybook](/recipes/storybook/custom-builder-configs).

This change means that each of your projects that has Storybook configured has only one, project-level, project-specific `.storybook/main.js|ts` file that it relies on, without importing settings from external files. This simplifies the configuration process, makes it easier for the user to understand the configuration that each project is using, and also makes it easier to maintain, relying on automatic migration scripts, for example.

This does not change much for the user, as the configuration process is still the same, and you may still manually create a root Storybook configuration file, if it is needed for your use case.

## Project-specific configuration

You will notice that all project-specific configuration files contain the `@storybook/addon-essentials` addon, which is the shared setting among projects. Other than that, depending on the project type, the settings differ in regards to the builder used, the stories import glob pattern, and, in the case of projects using Vite, the path to the `vite.config.ts` file or the root of the project, for correct path resolution.
All these are automatically generated by Nx, so you don't have to worry about them.

## Root Storybook configuration

If you need to create a root Storybook configuration file, you can do so by creating a `.storybook/main.js|ts` file in your workspace root. Then, you may import this file in your project-level Storybook configuration files. However, this is rarely needed in most cases, since most settings for builders like Webpack and Vite, for example, are already built-in into the Storybook builders.

## Read our guides for Configuring Storybook

You can read all our guides for configuring Storybook in our [Storybook documents page](/nx-api/storybook/documents).

Please also make sure to read our [Using Storybook in a Nx workspace - Best practices](/nx-api/storybook/documents/best-practices) guide, where you can find some best practices for using Storybook in a Nx workspace.
