# Automate GitHub Releases

Nx Release can automate the creation of [GitHub releases](https://docs.github.com/en/repositories/releasing-projects-on-github/managing-releases-in-a-repository) for you. GitHub releases are a great way to communicate the changes in your projects to your users.

<!-- Prettier will mess up the end tag of the callout causing it to capture all content that follows it -->
<!-- prettier-ignore-start -->

{% callout type="note" title="Authenticating with GitHub" %}
In order to be able to create the release on GitHub, you need to provide a valid token which can be used for authenticating with the GitHub API.

Nx release supports two main ways of doing this:

1. In all environments it will preferentially check for an environment variable (the environment variable can either be called `GITHUB_TOKEN` or `GH_TOKEN`). Please ensure that this environment variable is set in your CI environment (and that the token it has been set to has been configured with the appropriate permissions to create releases) before attempting to create a release in CI.
2. It can also detect if you have a valid, authenticated installation of the official `gh` CLI tool (https://cli.github.com/) and leverage that automatically as a fallback when no environment variable is set.
{% /callout %}
<!-- prettier-ignore-end -->

## GitHub Release Contents

When a GitHub release is created, it will include the changelog that Nx Release generates with entries based on the changes since the last release. Nx Release will parse the `feat` and `fix` type commits according to the [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0/) specification and sort them into appropriate sections of the changelog. Take a look at the [Nx releases page](https://github.com/nrwl/nx/releases) to see examples of GitHub releases generated by Nx Release.

## Enable Release Creation

To enable GitHub release creation for your workspace, set `release.changelog.workspaceChangelog.createRelease` to `'github'` in `nx.json`:

```json
{
  "release": {
    "changelog": {
      "workspaceChangelog": {
        "createRelease": "github"
      }
    }
  }
}
```

## Preview the Release

Use `nx release --dry-run` to preview the GitHub release instead of creating it. This allows you to see what the release will look like without pushing anything to GitHub.

## Disable File Creation

Since GitHub releases contain the changelog, you may wish to disable the generation and management of local the `CHANGELOG.md` file. To do this, set `release.changelog.workspaceChangelog.file` to `false` in `nx.json`:

```json
{
  "release": {
    "changelog": {
      "workspaceChangelog": {
        "file": false,
        "createRelease": "github"
      }
    }
  }
}
```

Note: When configured this way, Nx Release will not delete existing changelog files, just ignore them.

## Project Level Changelogs

Nx Release supports creating GitHub releases for project level changelogs as well. This is particularly useful when [releasing projects independently](/recipes/nx-release/release-projects-independently). To enable this, set `release.changelog.projectChangelogs.createRelease` to `'github'` in `nx.json`:

```json
{
  "release": {
    "changelog": {
      "projectChangelogs": {
        "createRelease": "github"
      }
    }
  }
}
```

{% callout type="warning" title="Project and Workspace GitHub Releases" %}
Nx Release does not support creating GitHub releases for both project level changelogs and the workspace changelog. You will need to choose one or the other.
{% /callout %}
