---
title: Storybook 7 overview
description: This guide explains how you can set up Storybook version 7 in your Nx workspace. It also highlights the changes that you should expect to see when migrating from Storybook 6 to Storybook 7.
---

# Storybook 7 is here - and Nx is ready

Storybook 7 is a major release that brings a lot of new features and improvements. You can read more about it in the [Storybook 7.0.0 release article](https://storybook.js.org/blog/storybook-7-0/). Apart from the new features and improvements it introduces, it also brings some breaking changes. You can read more about them in the [Storybook 7 migration docs](https://github.com/storybookjs/storybook/blob/next/MIGRATION.md#from-version-65x-to-700) and the [Storybook 7.0.0 migration guide](https://storybook.js.org/docs/react/migration-guide).

Nx provides new generators that allow you to generate Storybook 7 configuration for your projects, by installing the correct dependencies and creating the corresponding version 7 configuration files. Nx also provides a [Storybook 7 migration generator](/nx-api/storybook/generators/migrate-7) that you can use to migrate your existing Storybook configuration to version 7.

So, let's see how you can use Storybook 7 on your Nx workspace.

## Migrate your existing workspace to Storybook 7

If you already have Storybook configured in your Nx workspace, you can use the [Storybook 7 migrator generator](/nx-api/storybook/generators/migrate-7) to migrate your existing Storybook configuration to version 7.

## Set up Storybook 7 in a _new_ Nx Workspace

Please read the [`@nx/storybook` package overview](/nx-api/storybook) to see how you can configure Storybook in your Nx workspace.

## Changes from the v6.5 Storybook configuration

The Storybook configuration generated by Nx for Storybook 7 is very similar to the one generated for Storybook 6.5. Here are the new things that you should expect to see:

### Changes in `.storybook/main.js|ts` file

- No longer set the `core` field which contains the `builder` option.
- The `framework` field is now mandatory, and it "replaces" the `builder` configuration. You can read more [in the Storybook docs](https://github.com/storybookjs/storybook/blob/next/MIGRATION.md#mainjs-framework-field).
- Nx no longer adds the `webpackFinal` field to the `.storybook/main.js|ts` files. This is just for the sake of simplicity. You can still edit your webpack configuration by using the `webpackFinal` field, just as you can edit your Vite configuration by using the `viteFinal` field. You can read more about how to customize your webpack configuration [in the Storybook webpack docs](https://storybook.js.org/docs/react/builders/webpack#extending-storybooks-webpack-config), and you can read more about how to customize your Vite configuration [in the Storybook Vite docs](https://storybook.js.org/docs/react/builders/vite#configuration).

### Changes in the `storybook` and `build-storybook` targets

- The `uiFramework` field is not needed any more, thus it is not set. Nx was using the `uiFramework` field to load any framework specific options for the Storybook builder. This is no longer needed, since the `framework` set in `.storybook/main.js|ts` takes care of that.
- More options from the Storybook CLI are now exposed in the executors. You can see these in the [`@nx/storybook:storybook`](/nx-api/storybook/executors/storybook) and [`@nx/storybook:build`](/nx-api/storybook/executors/build) executor schemas. You can read more about these options in the [Storybook 7 CLI docs](https://storybook.js.org/docs/7.0/react/api/cli-options). If there's an option you need to pass but it's not in the executor schema, you can always pass it, since the executors are just passing the options to the Storybook CLI.

## Report any issues and bugs

Please report any issues and bugs you find [on the Nx GitHub page](https://github.com/nrwl/nx/issues/new/choose) or on the [Storybook GitHub page](https://github.com/storybookjs/storybook/issues/new/choose).
