---
title: 'release - CLI command'
description: 'Orchestrate versioning and publishing of applications and libraries.'
---

# release

Orchestrate versioning and publishing of applications and libraries.

## Usage

```shell
nx release
```

Install `nx` globally to invoke the command directly using `nx`, or use `npx nx`, `yarn nx`, or `pnpm nx`.

## Options

| Shared Option   | Type    | Description                                                                                           |
| --------------- | ------- | ----------------------------------------------------------------------------------------------------- |
| `--dry-run`     | boolean | Preview the changes without updating files/creating releases. (Default: `false`)                      |
| `--groups`      | string  | One or more release groups to target with the current command.                                        |
| `--help`        | boolean | Show help.                                                                                            |
| `--printConfig` | string  | Print the resolved nx release configuration that would be used for the current command and then exit. |
| `--projects`    | string  | Projects to run. (comma/space delimited project names and/or patterns).                               |
| `--verbose`     | boolean | Prints additional information about the commands (e.g., stack traces).                                |
| `--version`     | boolean | Show version number.                                                                                  |

## Subcommands

### Base Command Options

Create a version and release for the workspace, generate a changelog, and optionally publish the packages.

```shell
nx release [specifier]
```

## Options

| Option            | Type    | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ----------------- | ------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `--first-release` | boolean | Indicates that this is the first release for the selected release group. If the current version cannot be determined as usual, the version on disk will be used as a fallback. This is useful when using git or the registry to determine the current version of packages, since those sources are only available after the first release. Also indicates that changelog generation should not assume a previous git tag exists and that publishing should not check for the existence of the package before running. |
| `--help`          | boolean | Show help.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| `--skip-publish`  | boolean | Skip publishing by automatically answering no to the confirmation prompt for publishing.                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `--specifier`     | string  | Exact version or semver keyword to apply to the selected release group.                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `--version`       | boolean | Show version number.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `--yes`           | boolean | Automatically answer yes to the confirmation prompt for publishing.                                                                                                                                                                                                                                                                                                                                                                                                                                                   |

### version

Create a version and release for one or more applications and libraries.

```shell
nx release version [specifier]
```

## Options

| Option                 | Type    | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ---------------------- | ------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `--first-release`      | boolean | Indicates that this is the first release for the selected release group. If the current version cannot be determined as usual, the version on disk will be used as a fallback. This is useful when using git or the registry to determine the current version of packages, since those sources are only available after the first release. Also indicates that changelog generation should not assume a previous git tag exists and that publishing should not check for the existence of the package before running. |
| `--git-commit`         | boolean | Whether or not to automatically commit the changes made by this command.                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `--git-commit-args`    | string  | Additional arguments (added after the --message argument, which may or may not be customized with --git-commit-message) to pass to the `git commit` command invoked behind the scenes.                                                                                                                                                                                                                                                                                                                                |
| `--git-commit-message` | string  | Custom git commit message to use when committing the changes made by this command. {version} will be dynamically interpolated when performing fixed releases, interpolated tags will be appended to the commit body when performing independent releases.                                                                                                                                                                                                                                                             |
| `--git-push`           | boolean | Whether or not to automatically push the changes made by this command to the remote git repository.                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `--git-remote`         | string  | Alternate git remote to push commits and tags to (can be useful for testing). (Default: `origin`)                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `--git-tag`            | boolean | Whether or not to automatically tag the changes made by this command.                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `--git-tag-args`       | string  | Additional arguments to pass to the `git tag` command invoked behind the scenes.                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `--git-tag-message`    | string  | Custom git tag message to use when tagging the changes made by this command. This defaults to be the same value as the tag itself.                                                                                                                                                                                                                                                                                                                                                                                    |
| `--help`               | boolean | Show help.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| `--preid`              | string  | The optional prerelease identifier to apply to the version. This will only be applied in the case that the specifier argument has been set to `prerelease` OR when conventional commits are enabled, in which case it will modify the resolved specifier from conventional commits to be its prerelease equivalent. E.g. minor -> preminor. (Default: ``)                                                                                                                                                             |
| `--specifier`          | string  | Exact version or semver keyword to apply to the selected release group.                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `--stage-changes`      | boolean | Whether or not to stage the changes made by this command. Always treated as true if git-commit is true.                                                                                                                                                                                                                                                                                                                                                                                                               |
| `--version`            | boolean | Show version number.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |

### changelog

Generate a changelog for one or more projects, and optionally push to Github.

```shell
nx release changelog [version]
```

## Options

| Option                 | Type                           | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ---------------------- | ------------------------------ | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `--first-release`      | boolean                        | Indicates that this is the first release for the selected release group. If the current version cannot be determined as usual, the version on disk will be used as a fallback. This is useful when using git or the registry to determine the current version of packages, since those sources are only available after the first release. Also indicates that changelog generation should not assume a previous git tag exists and that publishing should not check for the existence of the package before running. |
| `--from`               | string                         | The git reference to use as the start of the changelog. If not set it will attempt to resolve the latest tag and use that.                                                                                                                                                                                                                                                                                                                                                                                            |
| `--git-commit`         | boolean                        | Whether or not to automatically commit the changes made by this command.                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `--git-commit-args`    | string                         | Additional arguments (added after the --message argument, which may or may not be customized with --git-commit-message) to pass to the `git commit` command invoked behind the scenes.                                                                                                                                                                                                                                                                                                                                |
| `--git-commit-message` | string                         | Custom git commit message to use when committing the changes made by this command. {version} will be dynamically interpolated when performing fixed releases, interpolated tags will be appended to the commit body when performing independent releases.                                                                                                                                                                                                                                                             |
| `--git-push`           | boolean                        | Whether or not to automatically push the changes made by this command to the remote git repository.                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `--git-remote`         | string                         | Alternate git remote to push commits and tags to (can be useful for testing). (Default: `origin`)                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `--git-tag`            | boolean                        | Whether or not to automatically tag the changes made by this command.                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `--git-tag-args`       | string                         | Additional arguments to pass to the `git tag` command invoked behind the scenes.                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `--git-tag-message`    | string                         | Custom git tag message to use when tagging the changes made by this command. This defaults to be the same value as the tag itself.                                                                                                                                                                                                                                                                                                                                                                                    |
| `--help`               | boolean                        | Show help.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| `--interactive`        | `all`, `workspace`, `projects` | Interactively modify changelog markdown contents in your code editor before applying the changes. You can set it to be interactive for all changelogs, or only the workspace level, or only the project level.                                                                                                                                                                                                                                                                                                        |
| `--stage-changes`      | boolean                        | Whether or not to stage the changes made by this command. Always treated as true if git-commit is true.                                                                                                                                                                                                                                                                                                                                                                                                               |
| `--to`                 | string                         | The git reference to use as the end of the changelog. (Default: `HEAD`)                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `--version`            | string                         | The version to create a Github release and changelog for.                                                                                                                                                                                                                                                                                                                                                                                                                                                             |

### publish

Publish a versioned project to a registry.

```shell
nx release publish
```

## Options

| Option                      | Type                                                     | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| --------------------------- | -------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `--access`                  | `public`, `restricted`                                   | Overrides the access level of the published package. Unscoped packages cannot be set to restricted. See the npm publish documentation for more information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `--all`                     | boolean                                                  | [deprecated] `run-many` runs all targets on all projects in the workspace if no projects are provided. This option is no longer required. (Default: `true`)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `--exclude`                 | string                                                   | Exclude certain projects from being processed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `--excludeTaskDependencies` | boolean                                                  | Skips running dependent tasks first. (Default: `false`)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `--first-release`           | boolean                                                  | Indicates that this is the first release for the selected release group. If the current version cannot be determined as usual, the version on disk will be used as a fallback. This is useful when using git or the registry to determine the current version of packages, since those sources are only available after the first release. Also indicates that changelog generation should not assume a previous git tag exists and that publishing should not check for the existence of the package before running.                                                                                                                                                                                                                       |
| `--graph`                   | string                                                   | Show the task graph of the command. Pass a file path to save the graph data instead of viewing it in the browser. Pass "stdout" to print the results to the terminal.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| `--help`                    | boolean                                                  | Show help.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `--nxBail`                  | boolean                                                  | Stop command execution after the first failed task. (Default: `false`)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `--nxIgnoreCycles`          | boolean                                                  | Ignore cycles in the task graph. (Default: `false`)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| `--otp`                     | number                                                   | A one-time password for publishing to a registry that requires 2FA.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| `--output-style`            | `dynamic`, `static`, `stream`, `stream-without-prefixes` | Defines how Nx emits outputs tasks logs. **dynamic**: use dynamic output life cycle, previous content is overwritten or modified as new outputs are added, display minimal logs by default, always show errors. This output format is recommended on your local development environments. **static**: uses static output life cycle, no previous content is rewritten or modified as new outputs are added. This output format is recommened for CI environments. **stream**: nx by default logs output to an internal output stream, enable this option to stream logs to stdout / stderr. **stream-without-prefixes**: nx prefixes the project name the target is running on, use this option remove the project name prefix from output. |
| `--parallel`                | string                                                   | Max number of parallel processes [default is 3].                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| `--projects`                | string                                                   | Projects to run. (comma/space delimited project names and/or patterns).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `--registry`                | string                                                   | The registry to publish to.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `--runner`                  | string                                                   | This is the name of the tasks runner configured in nx.json.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `--skipNxCache`             | boolean                                                  | Rerun the tasks even when the results are available in the cache. (Default: `false`)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| `--skipSync`                | boolean                                                  | Skips running the sync generators associated with the tasks. (Default: `false`)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| `--tag`                     | string                                                   | The distribution tag to apply to the published package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `--verbose`                 | boolean                                                  | Prints additional information about the commands (e.g., stack traces).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `--version`                 | boolean                                                  | Show version number.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |

### plan

Create a version plan file to specify the desired semver bump for one or more projects or groups, as well as the relevant changelog entry.

```shell
nx release plan [bump]
```

## Options

| Option          | Type                                                                        | Description                                                                                                                             |
| --------------- | --------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------- |
| `--base`        | string                                                                      | Base of the current branch (usually main).                                                                                              |
| `--bump`        | `major`, `premajor`, `minor`, `preminor`, `patch`, `prepatch`, `prerelease` | Semver keyword to use for the selected release group.                                                                                   |
| `--exclude`     | string                                                                      | Exclude certain projects from being processed.                                                                                          |
| `--files`       | string                                                                      | Change the way Nx is calculating the affected command by providing directly changed files, list of files delimited by commas or spaces. |
| `--head`        | string                                                                      | Latest commit of the current branch (usually HEAD).                                                                                     |
| `--help`        | boolean                                                                     | Show help.                                                                                                                              |
| `--message`     | string                                                                      | Custom message to use for the changelog entry.                                                                                          |
| `--onlyTouched` | boolean                                                                     | Only include projects that have been affected by the current changes. (Default: `true`)                                                 |
| `--uncommitted` | boolean                                                                     | Uncommitted changes.                                                                                                                    |
| `--untracked`   | boolean                                                                     | Untracked changes.                                                                                                                      |
| `--version`     | boolean                                                                     | Show version number.                                                                                                                    |

### plan:check

Ensure that all touched projects have an applicable version plan created for them.

```shell
nx release plan:check
```

## Options

| Option          | Type    | Description                                                                                                                             |
| --------------- | ------- | --------------------------------------------------------------------------------------------------------------------------------------- |
| `--base`        | string  | Base of the current branch (usually main).                                                                                              |
| `--exclude`     | string  | Exclude certain projects from being processed.                                                                                          |
| `--files`       | string  | Change the way Nx is calculating the affected command by providing directly changed files, list of files delimited by commas or spaces. |
| `--head`        | string  | Latest commit of the current branch (usually HEAD).                                                                                     |
| `--help`        | boolean | Show help.                                                                                                                              |
| `--uncommitted` | boolean | Uncommitted changes.                                                                                                                    |
| `--untracked`   | boolean | Untracked changes.                                                                                                                      |
| `--version`     | boolean | Show version number.                                                                                                                    |
