---
title: 'create-nx-workspace - CLI command'
description: 'Create a new Nx workspace'
---

# create-nx-workspace

Create a new Nx workspace

## Usage

```bash
create-nx-workspace [name] [options]
```

Install `create-nx-workspace` globally to invoke the command directly, or use `npx create-nx-workspace`, `yarn create nx-workspace`, or `pnpx create-nx-workspace`.

## Options

| Option             | Type                                                                          | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| ------------------ | ----------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `--allPrompts`     | boolean                                                                       | Show all prompts. (Default: `false`)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `--appName`        | string                                                                        | The name of the app when using a monorepo with certain stacks.                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `--bundler`        | string                                                                        | Bundler to be used to build the app.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `--commit.email`   | string                                                                        | E-mail of the committer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `--commit.message` | string                                                                        | Commit message. (Default: `Initial commit`)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| `--commit.name`    | string                                                                        | Name of the committer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `--defaultBase`    | string                                                                        | Default base to use for new projects. (Default: `main`)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `--docker`         | boolean                                                                       | Generate a Dockerfile for the Node API.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `--e2eTestRunner`  | `playwright`, `cypress`, `none`                                               | Test runner to use for end to end (E2E) tests.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `--formatter`      | string                                                                        | Code formatter to use.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `--framework`      | string                                                                        | Framework option to be used with certain stacks.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| `--help`           | boolean                                                                       | Show help.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `--interactive`    | boolean                                                                       | Enable interactive mode with presets. (Default: `true`)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `--name`           | string                                                                        | Workspace name (e.g. org name).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| `--nextAppDir`     | boolean                                                                       | Enable the App Router for Next.js.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `--nextSrcDir`     | boolean                                                                       | Generate a 'src/' directory for Next.js.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `--nxCloud`        | `github`, `gitlab`, `azure`, `bitbucket-pipelines`, `circleci`, `skip`, `yes` | Which CI provider would you like to use?                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `--packageManager` | `bun`, `npm`, `pnpm`, `yarn`                                                  | Package manager to use. (Default: `npm`)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `--prefix`         | string                                                                        | Prefix to use for Angular component and directive selectors.                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| `--preset`         | string                                                                        | Customizes the initial content of your workspace. Default presets include: ["apps", "npm", "ts", "web-components", "angular-monorepo", "angular-standalone", "react-monorepo", "react-standalone", "vue-monorepo", "vue-standalone", "nuxt", "nuxt-standalone", "next", "nextjs-standalone", "remix-monorepo", "remix-standalone", "react-native", "expo", "nest", "express", "react", "vue", "angular", "node-standalone", "node-monorepo", "ts-standalone"]. To build your own see https://nx.dev/extending-nx/recipes/create-preset. |
| `--routing`        | boolean                                                                       | Add a routing setup for an Angular app. (Default: `true`)                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `--skipGit`        | boolean                                                                       | Skip initializing a git repository. (Default: `false`)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `--ssr`            | boolean                                                                       | Enable Server-Side Rendering (SSR) and Static Site Generation (SSG/Prerendering) for the Angular application.                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `--standaloneApi`  | boolean                                                                       | Use Standalone Components if generating an Angular app. (Default: `true`)                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `--style`          | string                                                                        | Stylesheet type to be used with certain stacks.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| `--useGitHub`      | boolean                                                                       | Will you be using GitHub as your git hosting provider? (Default: `false`)                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `--version`        | boolean                                                                       | Show version number.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `--workspaces`     | boolean                                                                       | Use package manager workspaces. (Default: `false`)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `--workspaceType`  | `integrated`, `package-based`, `standalone`                                   | The type of workspace to create.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |

## Presets

| Preset             | Description                                                                             |
| ------------------ | --------------------------------------------------------------------------------------- |
| angular            | Allows you to choose between the angular-standalone or angular-monorepo presets         |
| angular-monorepo   | An Angular monorepo                                                                     |
| angular-standalone | A single Angular application                                                            |
| apps               | A basic integrated style repository starting with no projects                           |
| expo               | A monorepo with an Expo application                                                     |
| express            | A monorepo with an Express application                                                  |
| nest               | A monorepo with a Nest application                                                      |
| next               | A Next monorepo                                                                         |
| nextjs-standalone  | A single Next application                                                               |
| node-monorepo      | A Node monorepo                                                                         |
| node-standalone    | A single Node application                                                               |
| npm                | A repository configured with NPM Workspaces using a package-based style.                |
| nuxt               | A Nuxt monorepo                                                                         |
| nuxt-standalone    | A single Nuxt application                                                               |
| react              | Allows you to choose between the react-standalone or react-monorepo presets             |
| react-monorepo     | A React monorepo                                                                        |
| react-native       | A monorepo with a React Native application                                              |
| react-standalone   | A single React application                                                              |
| remix-monorepo     | A Remix monorepo                                                                        |
| remix-standalone   | A single Remix application                                                              |
| ts                 | A basic integrated style repository starting with TypeScript configured but no projects |
| ts-standalone      | A single TypeScript application                                                         |
| vue                | Allows you to choose between the vue-standalone or vue-monorepo presets                 |
| vue-monorepo       | A Vue monorepo                                                                          |
| vue-standalone     | A single Vue application                                                                |
| web-components     | An integrated style repository with an application configured to use web components     |
