---
title: Import External Projects to Your Nx Monorepo With `nx import`
slug: nx-import
authors: [Zack DeRose]
tags: [nx]
cover_image: '/blog/images/2024-10-29/nx-import-thumbnail.avif'
youtubeUrl: https://youtu.be/hnbwoV2-620
---

- [The Need](#the-need)
- [How It Works](#how-it-works)
- [`git` History ✅; Selective `git` History ✅](#git-history-selective-git-history)
- [Resources And More](#resources-and-more)

## The Need

One of the larger and more frequent asks we've gotten through the years at Nx is for the ability to import other repos (and projects from other repos) into an organization's monorepo. And that's understandable.

The [benefits of monorepos](https://monorepo.tools/) are immense, and over time we've seen more and more organizations and developers in the wider community gravitate towards monorepos as a way of managing codebases that are broader and more complex.

However, while we've always had a great story for starting up a fresh monorepo from scratch, the ability to easily import other existing projects has become more and more in demand as organizations have warmed to the idea of monorepos - and like we said, it's understandable. Once you get a taste of how much better things get in a monorepo, you tend to want to bring in all the things!

Prior to this work, it was always possible to do manually - but it takes some finessing both in terms of copying/pasting files over, and (as we'll see later) maintaining combining git history from the old project into its new home.

We always wanted to make this better - and now, we've now added a new top-level command to Nx specifically to address this: [`nx import`](http://localhost:4200/nx-api/nx/documents/import).

## How It Works

Here's how it works:

```shell
nx import ../my-side-project
```

Simply provide either a path to the repo that you want to import from to the CLI, or if you want to import from a central repository - for example from GitHub, you can provide the URL of the repo as the command-line argument. This will take you through some interactive prompts. For this example I'm importing the project `promise-pool`, located on my local disk at `/my-side-project/projects/promise-pool`.

Here are those interactive prompts:

```shell
nx import ../example-ts-monorepo --dry-run

 NX   Nx will walk you through the process of importing code from the source repository into this repository:

1. Nx will clone the source repository into a temporary directory
2. The project code from the sourceDirectory will be moved to the destinationDirectory on a temporary branch in this repository
✔ Filtered git history to only include files in packages/promise-pool
✔ /Users/zackderose/example-ts-monorepo has been prepared to be imported into this workspace on a temporary branch: __nx_tmp_import__/main in /private/var/folders/r2/7dj0tnbd1174yxxj18nhl5v40000gn/T/nx-import/repo
✔ Fetched __nx_tmp_import__/main from __tmp_nx_import__
✔ Merged files and git history from main from /Users/zackderose/example-ts-monorepo into libs/promise-pool
✔ Cleaned up temporary files and remotes
```

Following this, Nx will prompt you to install any relevant Nx plugins that it can detect from the incoming project if they are missing!

```shell
Add these Nx plugins to integrate with the tools used in your workspace.

? Which plugins would you like to add? Press <Space> to select and <Enter> to submit. …
✔ @nx/eslint
✔ @nx/vite
✔ @nx/playwright
```

Following this step, we're essentially good-to-go, though in a real life scenario you're likely 90-95% of the way there. There may be some final finessing required in terms of merging CI pipelines and etc. - things that we can't really automate away!

## `git` History ✅; Selective `git` History ✅

One thing you may have missed in the example was this line here when the `nx import` command was running:

```shell
⠋ Filtering git history to only include files in packages/promise-pool (this might take a few minutes -- install git-filter-repo for faster performance)
```

As mentioned earlier, `nx import` WILL preserve the git history of your incoming project, merging it in with your monorepo's git history.

But as an extra feature - in the case like the example we were looking at (only importing one package from the `my-side-project` repo), `nx import` will automate a filtering of the git history of the incoming project, to ONLY match for commits that involved the projects being imported! We've found this feature to be especially helpful for our enterprise-level users who are importing a project from their legacy codebase into their Nx Workspace!

## Resources And More

For more on `nx import` be sure to check out our [recipe for using `nx import`](/recipes/adopting-nx/import-project), and as always, you can find more help:

- In the [Nx Docs](/getting-started/intro)
- On our [Nx Official Discord Server](https://go.nx.dev/community)

And you can keep up with us:

- On our [Nx Youtube Channel](https://www.youtube.com/@nxdevtools)
- On [X/Twitter](https://twitter.com/nxdevtools) -- [LinkedIn](https://www.linkedin.com/company/nrwl/)
- And on the [Nx GitHub](https://github.com/nrwl/nx)
