---
title: Nx 19.8 Update!!
slug: nx-19-8-update
authors: [Zack DeRose]
tags: [nx, release]
cover_image: /blog/images/2024-09-20/thumbnail.png
youtubeUrl: https://youtu.be/Zgv4LHvwGx0
---

Nx 19.8 is here! This is our last minor release before we get ready to move ahead into Nx v20, which should land in October around the same time as the [Monorepo World Conference](https://monorepo.world/)!

As always, you can find the general details for all Nx releases on our [changelog](/changelog), as well as details on our [Github Releases for the Nx repo](https://github.com/nrwl/nx/releases).

## Table of Contents

In this blog post:

- [Nx Import](#nx-import)
- [Improved Task Scheduling!](#improved-task-scheduling)
- [Project Crystal Comes to Angular](#project-crystal-comes-to-angular)
- [Crystalize Your Entire Workspace In One Command](#crystalize-your-entire-workspace-in-one-command)
- [New Nx Workspaces Create with ESLint v9](#new-nx-workspaces-created-with-eslint-v9)
- [Nx Release Enhancements](#nx-release-enhancements)
- [Migrate to Latest](#migrate-to-latest)
- [Round 2 of Monorepo World Conference Speakers Announced!!](#round-2-of-monorepo-world-conference-speakers-announced)
- [Learn More](#learn-more)

## Nx Import

In Nx 19.8, [`nx import`](/nx-api/nx/documents/import) has now moved from beta support to now generally available!

Nx Import is a new [top-level command of the Nx CLI](/reference/nx-commands) which allows you to import projects along with its git history from some other repository into your current Nx workspace.

Keep an eye out for more on Nx Import on our [YouTube Channel](https://www.youtube.com/@nxdevtools) coming soon, and in the meantime be sure to check [the documentation](/nx-api/nx/documents/import) as this is now fully documented!

## Improved Task Scheduling!

We've added some optimizations to the core of Nx - particularly around Nx's task scheduling. At the core of Nx is a task runner that supports [task dependencies](/features/run-tasks#defining-a-task-pipeline) (configurable for your entire workspace in the `targetDefaults` of your `nx.json` file, and on a per-project basis in your `project.json` files!), as well as the ability to run mulitple tasks in parallel.

With 19.8, nx will leverage historical data of previous runs of tasks to add some prioritization to the scheduling tasks that tend to take longer. This should optimize the total runtime of large batch commands in your workspace!

Read more on [running tasks with Nx](/features/run-tasks)! And checkout [this new optimization on GitHub](https://github.com/nrwl/nx/pull/27783) for more details!

## Project Crystal Comes to Angular

[Project Crystal](/concepts/inferred-tasks) has come to Angular!

Project Crystal allows Nx to _infer_ tasks for projects in your workspace - rather than requiring that they exist in every `project.json` or `angular.json` file of your workspace.

You can now run the command `nx init` in a project created by the Angular CLI, and we will generate `project.json` files for each angular project in your workspace - splitting that data out from the root `angular.json` file created by the Angular CLI.

This decision was made based on our feedback from the Angular community - where there is a strong preference for being able to split out the config.

## Crystalize Your Entire Workspace In One Command

When we initially launched [Project Crystal](/concepts/inferred-tasks), we shipped originally with `convert-to-inferred` generators, which would allow you to convert your workspace one plugin at a time.

With Nx 19.8, we've added a [`infer-targets`](/recipes/running-tasks/convert-to-inferred#migrate-all-plugins) generator, which will automatically detect all available `convert-to-inferred` generators, and run the ones you choose. You may also specify a specific project using the `--project` option of the generator.

## New Nx Workspaces Created with ESLint v9

When creating a new workspace with the command: `npx create-nx-workspace`, those workspaces will now be created with [`eslint`](https://www.npmjs.com/package/eslint) v9, and [`typescript-eslint`](https://www.npmjs.com/package/typescript-eslint) v8 - their most recent versions respectively.

Keep in mind as well that ESLint v8 faces end-of-life on October 5th, meaning only [flat config](https://eslint.org/docs/latest/use/configure/migration-guide) is supported moving forward. Nx users should migrate to this new config format using [our flat config generator](/recipes/tips-n-tricks/flat-config#switching-to-eslints-flat-config-format).

For more on eslint's flat config, and how to use our generator to get to flat config checkout this video:

{% youtube
src="https://www.youtube.com/watch?v=32XH909CZrY"
title="ESLint Config Automation With Nx"
/%}

## Nx Release Enhancements

[`nx release`](/nx-api/nx/documents/release) is a framework/language/platform agnostic solution to versioning, publishing, and changelogs for your monorepo. We've been continuing to invest in Nx Release in 19.8, adding support specifically for [`pnpm publish`](https://pnpm.io/cli/publish) and [Github Enterprise Server](https://github.com/nrwl/nx/pull/26482)!

We also have a new feature from Nx Champion, Jonathan Gelin - which allows you to use `groupPreVersionCommand` in addition to the `preVersionCommand` when using the release groups feature to support [building before versioning](/recipes/nx-release/build-before-versioning).

## Migrate to Latest

{% youtube
src="https://youtu.be/A0FjwsTlZ8A"
title="How Automated Code Migrations Work"
/%}

As always - updating Nx and its plugins is easy as we ship an [automated migration command](/features/automate-updating-dependencies).

```shell
npx nx migrate latest
```

After updating your dependencies, run any necessary migrations.

```shell
npx nx migrate --run-migrations
```

## Round 2 of Monorepo World Conference Speakers Announced!!

[![Monorepo World](/blog/images/2024-08-01/monorepo-world.avif)](https://monorepo.world)

The [Monorepo World conference](https://monorepo.world) is coming up soon on October 7, 2024 at the Computer History museum in Mountain View, California.

[Get your tickets now](https://ti.to/nx-conf/monorepoworld2024), consider [requesting access to the invite-only Enterprise Summit on October 8](https://ti.to/nx-conf/monorepoworld2024), and be sure to check out the [second round of speakers](https://monorepo.world/#speakers-title) that was just published earlier this week!

## Learn more

- [Nx Docs](/getting-started/intro)
- [X/Twitter](https://twitter.com/nxdevtools) -- [LinkedIn](https://www.linkedin.com/company/nrwl/)
- [Nx GitHub](https://github.com/nrwl/nx)
- [Nx Official Discord Server](https://go.nx.dev/community)
- [Nx Youtube Channel](https://www.youtube.com/@nxdevtools)
- [Speed up your CI](/nx-cloud)
