---
title: Announcing your Monorepo World Speakers Part 2
slug: announcing-your-monorepo-world-speakers-pt-2
authors: ['Mike Hartington']
tags: [monorepo-world]
cover_image: /blog/images/2024-09-16/mw-blog-post.avif
---

[Monorepo World](https://monorepo.world) is our two-track conference bringing together experts in developer tooling and of course, monorepos. We’re thrilled to share some of this year's speakers, including folks from Aspect Build Systems, Trunk.io, Aviator Technologies, and Postman. Without further ado, let’s meet your speakers!

## Python Monorepos with Bazel

[Alex Eagle](https://x.com/Jakeherringbone), Aspect Build Systems

Bazel is Google’s open source incremental build tool made for extreme scalability and support for many languages. Let’s look at how Bazel can provide features like CI/CD, building and testing, as well as formatting/linting in a Python environment.

## Merge Queues at Scale

[Joshua Marinacci](https://x.com/joshmarinacci), Trunk

Merge queues are quickly becoming a requirement for high-traffic repos, especially monorepos, - coordinating and merging many PRs from many people while avoiding breaking main can become quite a manual and involved task. This talk will explain what a merge queue is, their features, and how smart merge queues can take advantage of Monorepos with build graphs to scale as the repo grows.

## Scaling Ownership to Improve Developer Experience

[Ankit Jain](https://x.com/ankitxg), Aviator Technologies

Ownership of code and services can become complex and unwieldy, especially as engineering teams scale and codebase complexity grows. This talk will explore practical strategies to streamline ownership management, addressing the intricacies of reorgs, shifting priorities, and codebase complexities.

## Poly Monorepos, the Best of the Two Worlds

[Jonathan Gelin](https://x.com/jonathan_gelin), Nx Champion

We often pit Polyrepos against Monorepos, but why not merge the best of both worlds? In this session, let's look at effective management of distributed monorepos from both decentralized and centralized perspectives.

## How to Prevent a Wrong Version Breaking Your Micro Frontends

[Patrick Sevat](https://x.com/_Sevat), Postman

“Oops, it turns out my PR was actually a breaking change. I'm so sorry I broke production for all apps except ours”. This developer nightmare was the worst case scenario the team at Postman has solved. This talk will focus on how shared dependencies can keep federated apps small in bundle size, but come at the risk of breaking other apps when semantic versioning (SemVer) is not adhered to.

We hope you’re excited to see these amazing sessions! We’ll have more to share soon about what other speakers you can expect to see at Monorepo world! Don’t forget to register and get your ticket before it’s too late 😱!

[Get your tickets today!](https://bit.ly/3YZcb5r)
