---
title: 'Nx 19.5 is here! Stackblitz, Bun, Incremental Builds for Vite, Gradle Test Atomizer'
slug: 'nx-19-5-adds-stackblitz-new-features-and-more'
authors: ['Zack DeRose']
cover_image: '/blog/images/2024-08-01/nx-19-5-thumbnail.png'
tags: [nx, release]
---

## Table of Contents

In this blog post:

- [Video Summary](#video-summary)
- [Announcing Nx Cloud Hobby Tier](#announcing-nx-cloud-hobby-tier)
- [StackBlitz Support](#stackblitz-support)
- [Bun and Pnpm v9 Support](#bun-and-pnpm-v9-support)
- [Local Flaky Task Detection](#local-flaky-task-detection)
- [Project Detail View Enhancements](#project-detail-view-enhancements)
- [Pattern Support for `targetDefaults`](#pattern-support-for-targetdefaults)
- [Individual Targets Can Now Opt Out of Parallelism](#individual-targets-can-now-opt-out-of-parallelism)
- [Support For Incremental Builds For Vite](#support-for-incremental-builds-for-vite)
- [Project Crystal Conversion Generators](#project-crystal-conversion-generators)
- [Gradle Composite Builds Support](#gradle-composite-builds-support)
- [Experimental: Gradle Test Atomization](#experimental-gradle-test-atomization)
- [Experimental: Nx Release Adds File Based Versioning Support](#experimental-nx-release-adds-file-based-versioning-support)
- [Support for React 19 (rc) and Angular 18.1](#support-for-react-19-rc-and-angular-181)
- [Automatically Update Nx](#automatically-update-nx)
- [Monorepo World Conference Speakers Announced!!](#monorepo-world-conference-speakers-announced)
- [Learn more](#learn-more)

## Video Summary

{% youtube
src="https://youtu.be/ER-6sKbb9ck"
title="Nx 19.5 is here! Stackblitz, Bun, AND MORE!"
width="100%" /%}

## Announcing Nx Cloud Hobby Tier

We just added a new [Hobby Tier](/pricing#plan-details) to Nx Cloud! Why is this exciting? It is completely free and contains all major features, which includes the ability to [distribute your tasks with Nx Agents](/ci/features/distribute-task-execution).

This gives you plenty of opportunities to experiment with Nx Cloud on your workspace and see its impact on your teams productivity.

[![Nx Cloud Tiers](/blog/images/2024-08-01/start-with-everything-scale-when-you-need.avif)](/pricing#plan-details)

Checkout the [plan details page](/pricing#plan-details) for more info, and see how Nx Cloud can help you! And in case you missed it, check out our latest blog on the latest Nx Cloud feature: [Explain with AI](/blog/explain-with-ai)!

## StackBlitz Support

Nx now has support for [Stackblitz](https://stackblitz.com/) (again). For a while it was not possible to use Nx on Stackblitz because we implemented some perf critical parts of Nx as native components with Rust. Huge shoutout to [LongYinan](https://github.com/Brooooooklyn) for [their amazing work of pushing napi-rs](https://napi.rs/) forward and helping us [add WebAssembly support to Nx](https://github.com/nrwl/nx/pull/22870) as well as the StackBlitz team who helped debug issues.

This means we are back and you can create a StackBlitz with a whole Nx Workspace inside it and run all Nx capabilities from their embedded terminal.

[![Nx Workspace in Stackblitz](/blog/images/2024-08-01/react-app-in-stackblitz.avif)](https://stackblitz.com/edit/stackblitz-webcontainer-api-starter-cwruaw?file=apps%2Freact-app%2Fsrc%2Fapp%2Fapp.tsx)

[Check out the example](https://stackblitz.com/edit/stackblitz-webcontainer-api-starter-cwruaw?file=apps%2Freact-app%2Fsrc%2Fapp%2Fapp.tsx) above. You can use the standard Nx commands in the Stackblitz terminal, like

```shell
nx serve react-app
```

We're excited about this as it opens up many interesting use cases, including easier ways of sharing examples, better opportunities for reproducing issues or bugs, and the potential for us to use embedded examples in our documentation in the future.

Again, special shout out to community contributor [LongYinan](https://github.com/Brooooooklyn) and [their napi-rs project](https://napi.rs/).

## Bun and Pnpm v9 Support

We've been monitoring [Bun](https://bun.sh/) for a while both as a runtime and as a package manager, and we've decided to take the first step in Bun support now by supporting [Bun as a package manager](https://bun.sh/docs/cli/install)! This means that you can now use Bun like you would use npm, pnpm, or yarn to install and manage your dependencies, and Nx will be able to correctly understand those dependencies as `externalNodes` in the Nx dependency graph.

Sending a big thank you to community contributor [Jordan Hall](https://github.com/Jordan-Hall) for completing [this work](https://github.com/nrwl/nx/pull/22602).

In addition to supporting Bun, Nx now supports the latest format of [`pnpm`](https://pnpm.io/) lockfiles which was introduced in version 9.

## Local Flaky Task Detection

Nx Cloud has long offered [flaky task detection](/ci/features/flaky-tasks) on CI, and now this capability is available **even when running them locally**.

![Local Flaky Task Warning](/blog/images/2024-08-01/flaky-task.avif)

If a task is detected as flaky during local execution, you’ll receive a warning. Nx identifies flaky tasks by tracking the outcomes of your tasks in relation to your source code and external dependencies. When the same code produces different results, Nx flags the task as flaky and triggers the warning.

Detecting flaky tasks in the local environment empowers developers to address issues early in the development cycle—before they affect your CI pipelines.

## Project Detail View Enhancements

As part of [project Crystal](/concepts/inferred-tasks) we've added the ability to our plugins to automatically infer tasks based on the tools and configuration files available in your workspace. As part of that we created the "project detail view", allowing you to visualize such dynamically created tasks. You can launch it by using the [Nx Console IDE plugin](/getting-started/editor-setup) or by running the command:

```shell
nx show project [projectName]
```

In this iteration we've added several enhancements to the project detail view. For one, we've added more instructions on how to discover options for the underlying tools, and included examples on how to adjust these options via your `project.json` file.

![Project Detail View Vite Serve](/blog/images/2024-08-01/project-detail-view-vite-serve.avif)

In addition, we've added a callout for tasks that [leverage the `Nx Atomizer`](/ci/features/split-e2e-tasks). Since atomizer tasks are designed to be used with [Nx Agents](/ci/features/distribute-task-execution#distribute-task-execution-nx-agents), this callout will appear in yellow to warn if your project is not yet configured to run them on CI, and you can click on this callout for an easy way to complete that setup:

![Atomizer Warning](/blog/images/2024-08-01/atomizer-warning.avif)

Clicking this button will launch the [Nx Cloud onboarding](https://cloud.nx.app) process, which will generate a PR in your repository to complete the setup.

![Connect Your Repo](/blog/images/2024-08-01/connect-a-repo.avif)

Note that the new, free [hobby tier for Nx Cloud](#new-nx-cloud-hobby-tier) includes the ability to run [Nx Agents](/ci/features/distribute-task-execution) without the need to immediately jump onto a paid plan.

## Pattern Support for `targetDefaults`

When using the [Atomizer features](/ci/features/split-e2e-tasks) of plugins like [`@nx/playwright`](/nx-api/playwright) and [`@nx/cypress`](/nx-api/cypress), you end up creating tasks with dynamic but predictable names.

![Tasks Created With Atomizer](/blog/images/2024-08-01/e2e-task-names.avif)

Notice how the `e2e-ci--src/example.spec.ts` and `e2e-ci--src/test.spec.ts` tasks here are created by the `@nx/playwright` plugin dynamically based on the playwright spec files present in your workspace.

We've now **added pattern matching** to `targetDefaults` task names as a way to target these dynamic tasks.

In the past it was difficult to customize this dynamic set of targets. But with the new support for specifying a pattern to a target name, you can now customize this set of dynamic targets all at once.

The following will set all such tasks to depend on their `build` task:

```json
{
  "targetDefaults": {
    "e2e-ci--**/*": {
      "dependsOn": ["build"]
    }
  }
}
```

Note that our plugins will set sensible configurations here out of the box when creating new workspaces using our generators.

Read more about [reducing configuration with `targetDefaults`](/recipes/running-tasks/reduce-repetitive-configuration#reduce-configuration-with-targetdefaults) and [how you can define task pipelines with `targetDefaults`](/features/run-tasks#defining-a-task-pipeline).

## Individual Targets Can Now Opt Out of Parallelism

One of our goals in transforming the CI landscape is to **make CI more declarative** by focusing on defining the "what" rather than the "how."

To accommodate port collisions in end-to-end tests, we've long adjusted our generated CI script to look like this:

```yml
- run: npx nx affected -t lint test build
- run: npx nx affected --parallel 1 -t e2e-ci
```

Unfortunately, this approach is more imperative, as it instructs how to run and order your CI rather than defining what should be run. Additionally, these instructions cause `lint`, `test`, and `build` targets to run first and wait until they all complete before running `e2e-ci`, leading to inefficiencies.

To address this, all tasks now support a [`parallelism` property](/reference/project-configuration#parallelism). By setting this property to `false`, you can instruct the Nx task runner not to run a specific task in parallel. This allows us to define parallelism as a task property, making our CI configuration more declarative.

Both our `@nx/playwright` and `@nx/cypress` plugins will now automatically set `targetDefaults` for atomized tests to disable parallelism:

```json {% fileName="nx.json" %}
{
  // ...
  "targetDefaults": {
    "e2e-**/*": {
      // ...
      "parallelism": false
    }
  }
}
```

This way we can simply run the command:

```shell
nx affected --targets=lint,test,build,e2e-ci
```

In CI, Nx Agents will allow all tasks to run in parallel on the same machine, except for the atomized end-to-end tasks, which will only run in isolation.

Learn more about how you can [Parallelize Tasks Across Multiple Machines Using Nx Agents](/ci/intro/tutorials/github-actions#parallelize-tasks-across-multiple-machines-using-nx-agents):

{% youtube
src="https://youtu.be/0YxcxIR7QU0"
title="Faster e2e Tests!"
width="100%" /%}

## Support For Incremental Builds For Vite

Nx now supports incremental builds with our [`vite` plugin](/nx-api/vite). Incremental builds in Nx workspaces allow you to build any package in your workspace individually, and will then automatically use that built artifact when then building any project or application that consumes the package. This way you can speed up your build and CI times through optimizations like [only building packages that were affected](/nx-api/nx/documents/affected), using [Nx Replay](/ci/features/remote-cache) to effortlessly cache and share your built artifacts, and allowing you to run builds of your various packages in parallel using [Nx Agents](/ci/features/distribute-task-execution).

Read more about [buildable libraries and incremental builds](/concepts/buildable-and-publishable-libraries).

## Project Crystal Conversion Generators

Since launching [Nx Project Crystal](/concepts/inferred-tasks) in Nx version 18, we've adjusted our generators to leverage these features when creating new workspaces and projects. We've now added the `convert-to-inferred` generator to give you an automated way to opt into project crystal.

To run the generator, you can run the command:

```shell
npx nx g convert-to-inferred
```

The important thing to note here is that while this generator will make adjustments to the `project.json` file of the projects you convert, the behavior of your tasks should remain the same. You can see project details via the [Nx Console](/getting-started/editor-setup) plugin of your IDE, or in a browser by running the command: `nx show project [projectName]`.

In Nx 19, we were focused on adding `convert-to-inferred` to our [Playwright](/nx-api/playwright), [Cypress](/nx-api/cypress), and [ESLint](/nx-api/eslint) plugins - where bringing the [Nx Atomizer](/ci/features/split-e2e-tasks) provided the greatest value. Since then, we've added this generator to most other plugins. Currently, our React native plugins (react native, expo, detox) are the only plugins that are outstanding, and we'll be providing `convert-to-inferred` generators here in the near future.

## Gradle Composite Builds Support

In [Nx 19.0](/blog/nx-19-release), we introduced support for Gradle through our [Gradle plugin](/nx-api/gradle). With the latest update, this plugin now also supports [Gradle Composite builds](https://docs.gradle.org/current/userguide/composite_builds.html), in addition to multi-project builds.

Gradle Composite builds are commonly used in larger workspaces to manage dependencies across multiple projects. With this new support, Nx can now leverage composite builds to enhance the Nx Task Graph. For example, consider the following `settings.gradle.kts` file:

```kotlin
rootProject.name = "app"

includeBuild("number-utils")
includeBuild("string-utils")
```

Nx will now be able to automatically determine the dependencies between the `app` project and the `number-utils` and `string-utils` workspaces:

![Gradle Composite Project Dep Graph](/blog/images/2024-08-01/gradle-composite-dep-graph.avif)

You can read more on composite builds in the [Gradle documentation](https://docs.gradle.org/current/userguide/composite_builds.html).

## Experimental: Gradle Test Atomization

The new [`@nx/gradle` plugin](/nx-api/gradle) now includes experimental support for [Test Atomization](/ci/features/split-e2e-tasks).

![Gradle Atomized](/blog/images/2024-08-01/gradle-atomized.avif)

With Test Atomization, as you add tests to your Gradle projects, Nx will automatically create a separate task for each test class. This allows you to distribute the execution of these tasks across multiple machines on CI, similar to the functionality provided by our `@nx/playwright` and `@nx/cypress` plugins.

## Experimental: Nx Release Adds File Based Versioning Support

Currently with [Nx release](/nx-api/nx/documents/release), you already have two different ways of figuring out the how to modify the current version of a package to get its updated version:

- Imperatively via the CLI/prompt by telling it your desired relative (semver keyword) or absolute (e.g. `1.2.3`) version.
- Declaratively by letting Nx inspect your git history and determine the semver bump to apply based on the conventional commits specification.

Nx release now supports an experimental third way of deriving the version bump that we call "version plans".

The idea behind version plans is that you want to track your intended version bumps alongside your changes, just like you would do with conventional commits, but you want to make this tracking independent from your actual commit data. This might be because you do not want to/cannot use the conventional commits standard in your workspace, or it could just be that you find it a cleaner approach to versioning.

Version plan files use frontmatter enhanced markdown for their contents, and can be created by hand or by leveraging the new `nx release plan` subcommand. This will guide you through creating a git-tracked file within `.nx/version-plans` that will be committed alongside your normal changes.

![Nx Release Plan Command](/blog/images/2024-08-01/nx-release-plan-command.avif)

When your team is ready to release, you can now simply run the CLI command `nx release` (or use the [powerful programmatic API](/features/manage-releases#using-the-programmatic-api-for-nx-release)) and nx will ingest all the outstanding version plan files and use the combined information to determine the resulting version for all referenced projects and/or release groups as part of the versioning, changelog generation, and publishing steps. (You can also run the command `nx release version` if all you want to do is update the version!)

![Nx Release With Plans](/blog/images/2024-08-01/nx-release-with-plans.avif)

Anyone who has used the tools "Changesets" or "Beachball" will be familiar with the concept of file based versioning, but with Nx release you get the power to combine one or more of the above mentioned versioning strategies all within the same workspace for different release groups, and we are really excited to keep building out this feature set and mark it as non-experimental (by fully documenting it) very soon. To learn more about the other features of [Nx Release in the meantime, check out our docs](/features/manage-releases).

## Support for React 19 (rc) and Angular 18.1

Nx 19.5 adds support for the React 19 release candidate and updated our Angular package to support the latest Angular minor version: 18.1.

When using our `@nx/angular` package, we'll automatically update you to the latest angular version when you run our migration. Using the `--interactive` flag you can choose to opt in or out of the latest Angular version:

```shell
nx migrate latest --interactive
✔ Do you want to update to TypeScript v5.5? (Y/n) · true
✔ Do you want to update the Angular version to v18.1? (Y/n) · true
Fetching @angular/core@18.1.2

 NX   The migrate command has run successfully.
```

Our `@nx/react` package will now create new React applications using version 18.3, and we now support the new experimental `reactCompiler`. Users can install the [`babel-plugin-react-compiler` package](https://www.npmjs.com/package/babel-plugin-react-compiler) and you can follow [this guide for how to enable it with Nx](/recipes/react/react-compiler#react-compiler-with-nx).

Note that due to the extent of breaking changes coming with React 19, we will not be providing a automated migration to React 19 via [`nx migrate`](/nx-api/nx/documents/migrate).

## Automatically Update Nx

As always - updating Nx and its plugins is easy as we ship an [automated migration command](/features/automate-updating-dependencies).

```shell
npx nx migrate latest
```

After updating your dependencies, run any necessary migrations.

```shell
npx nx migrate --run-migrations
```

## Monorepo World Conference Speakers Announced!!

[![Monorepo World](/blog/images/2024-08-01/monorepo-world.avif)](https://monorepo.world)

The [Monorepo World conference](https://monorepo.world) is coming up soon on October 7, 2024 at the Computer History museum in Mountain View, California.

[Get your tickets now](https://ti.to/nx-conf/monorepoworld2024), consider [requesting access to the invite-only Enterprise Summit on October 8](https://ti.to/nx-conf/monorepoworld2024), and be sure to check out our [list of speakers](https://monorepo.world/#speakers-title) that was just published!

## Learn more

- [Nx Docs](/getting-started/intro)
- [X/Twitter](https://twitter.com/nxdevtools) -- [LinkedIn](https://www.linkedin.com/company/nrwl/)
- [Nx GitHub](https://github.com/nrwl/nx)
- [Nx Official Discord Server](https://go.nx.dev/community)
- [Nx Youtube Channel](https://www.youtube.com/@nxdevtools)
- [Speed up your CI](/nx-cloud)
