---
title: Nx 19.0 Release!!
slug: 'nx-19-release'
authors: ['Zack DeRose']
cover_image: '/blog/images/2024-05-08/nx-19-thumbnail.png'
tags: [nx, release]
---

Hey folks!

It's been awhile since February, where in the midsts our big launch week, we launched Nx 18. Nx 18 introduced the biggest new enhancement to Nx to date: Project Crystal.

[![Project Crystal](/blog/images/2024-02-05/featured_img.png)](/blog/what-if-nx-plugins-were-more-like-vscode-extensions)

You can read more on project crystal [here](/blog/what-if-nx-plugins-were-more-like-vscode-extensions). The main thing to know though is that Project Crystal adjusts the idea of Nx plugins, so that the mere presence of the plugin in your Nx Workspace removes the need to maintain any configuration for most cases.

Nx 18 was a significant departure for us in several ways - maybe the most noteworthy was that we broke our years-long cadence of releasing a new major version every 6 months.

Nx 19 represents a return to form, matching the reliable 6-month schedule. Nx 19 is releasing now 6 months from when Nx 17 released, making Nx 18 a special case to match the impact that Project Crystal had on Nx as a whole.

Here's the rundown of the major things we'll cover in this update:

- [NEW PLUGIN: @nx/gradle](#new-plugin-nxgradle)
- [Nx Atomizer Enhancements](#nx-atomizer-enhancements)
- [Associated Technologies Added To Tasks](#associated-technologies-added-to-tasks)
- [Generators to Convert to Project Crystal](#generators-to-convert-to-project-crystal)
- [BREAKING CHANGE: Updating Bundled Environment Variables: `NX_` to `NX_PUBLIC_`](#breaking-change-updating-bundled-environment-variables-nx-to-nxpublic)
- [General Crystal Polishing](#general-crystal-polishing)
- [Nx Cloud Updates!](#nx-cloud-updates)
- [More Miscellaneous Updates!](#more-miscellaneous-updates)
- [New Conference: Monorepo World 2024](#new-conference-monorepo-world-2024)
- [Wrapping Up, And A Heartfelt Thank You](#wrapping-up-and-a-heartfelt-thank-you)
- [Learn More](#learn-more)

**Prefer a video?**

{% youtube
src="https://youtu.be/U6eO8-w9DR0"
title="Nx 19.0 Has Landed!!"
width="100%" /%}

---

## NEW PLUGIN: @nx/gradle

[![NEW PLUGIN: @nx/gradle](/blog/images/2024-04-19/featured_img.png)](/blog/manage-your-gradle-project-using-nx)

We've launched a new first-party plugin for Gradle!

Emily, the engineer that worked on this effort, posted an entire article where you can find the full details [here](/blog/manage-your-gradle-project-using-nx).

Thanks to the benefits of Project Crystal - which allows us to determine information to create Nx Tasks based on the way your Gradle projects are setup - by adding this plugin, it makes it easy to add Gradle into an existing workspace without needing any Nx-specific configuration.

In addition, you can now find [a new tutorial on using Nx with Gradle](/getting-started/tutorials/gradle-tutorial) which will expand on the [Spring framework](https://spring.io/)'s tutorial for multi-module projects and show you how Nx further enhances the developer experience of that workspace. This tutorial takes you all the way through setting up your CI pipeline with Nx Cloud, so be sure to check it out!

As an editorial note, this Gradle plugin is a big step for Nx, as it represents the first major step we're taking outside of the Javascript ecosystem. This has always been the goal: to robustly support monorepos and full-stack development, even across language and ecosystem barriers. We're using this Gradle plugin internally for our closed-sourced projects (in particular Nx Cloud) and in [Nx Console](https://github.com/nrwl/nx-console/blob/master/package.json#L74) and we're very proud of this plugin and all that it represents.

## Nx Atomizer Enhancements

The Nx Atomizer launched in Nx 18 with Project Crystal. Essentially, "Atomizer" is the name we use to describe how Nx will automatically shard your e2e tests in your CI pipelines via our first party plugins. You can find out more information in the video below:

{% youtube
src="https://youtu.be/0YxcxIR7QU0"
title="10x Faster e2e Tests!"
width="100%" /%}

While the Atomizer was great for reducing the time of end-to-end tests in CI pipelines, one unfortunate trade-off of the Atomizer was that rather than having a single task to represent your end-to-end validation tasks, you instead had a collection of tasks. This tended to clutter up tools when viewing your Nx Tasks. It also wasn't very clear which tasks belonged to which group!

We've addressed this in Nx 19 by introducing the concept of Task Grouping inside of our tooling.

Now, when running the command:

```shell
nx show project nx-dev-e2e --web
```

You'll see the following in the project view:

![Nx Show Project Web View](/blog/images/2024-05-08/grouping-web-view.webp)

Notice how all tasks are now appropriately grouped in the `E2E (CI)` group!

You can also find the same enhancements in Nx Cloud. Below is a view of all tasks in the [CI pipeline](https://staging.nx.app/runs/ctbAZfiLy3):

{% video-player src="/documentation/blog/media/2024-05-08/nx-cloud-atomizer-groupings.mp4" alt="Showing the Atomizer in Nx Cloud" link="https://staging.nx.app/runs/ctbAZfiLy3" /%}

Notice how all e2e groups are collapsed by default to give a concise view, while allowing you to expand to see how each individual task is progressing!

Project Crystal is gathering the information to group your tasks, so this is automatically inferred for you based on the actual contents of your workspace. You can see this information by running the command:

```shell
nx show project nx-dev-e2e --json | jq
```

![Show Project JSON view](/blog/images/2024-05-08/show-project-json.webp)

All Nx Plugins that support this concept of "Atomization" will do this automatically for you, and if you are writing a custom plugin for your own tool or special use-case, you can implect this inferrence to group your targets in Nx and Nx Cloud tooling as well. We'll be adding more documentation on how to implement this in your own plugins in the future.

## Associated Technologies Added To Tasks

We've added icons for associated technologies on tasks in the project detail web view:

![Technology icons in Project Detail View](/blog/images/2024-05-08/icon-in-project-detail-view.gif)

And in Nx Cloud:

![Technology icons in Nx Cloud](/blog/images/2024-05-08/nx-cloud-icons.gif)

This will help easily identify at-a-glance the technology your tasks are associated with. All this is supported out of the box by our plugins and you should see this as soon as updating to Nx 19.

To see how we support this new feature, checkout the json view of our project again:

```shell
nx show project e2e-angular --json | jq
```

![Highlighting target metadata](/blog/images/2024-05-08/highlight-target-metadata.webp)

## Generators to Convert to Project Crystal

As part of Nx 19, we've included generators to our Playwright, Cypress, and ESLint plugins to allow you to easily convert your projects to opt into Project Crystal features!

To convert your workspace, you can use the command:

```shell
nx generate convert-to-inferred
```

Before running this command you could expect your project detail view to look like this:

```shell
nx show project my-react-app-e2e --web
```

![Before Conversion](/blog/images/2024-05-08/before-conversion.webp)

And after running the generator, you can expect your project detail view to look like this:

![After Conversion](/blog/images/2024-05-08/after-conversion.webp)

Notice that in addition to reducing the configuration in your `project.json` file, this generator will also turn on the Nx Atomizer for your Cypress and Playwright projects, so Nx will allow sharding for your end-to-end tasks in CI based on the tests present in your workspace going forward. Note that Nx Agents are very highly highly encouraged as a way of taking advantage of this sharding capability.

As a note, if you cannot see `e2e-ci` tasks after converting your cypress projects, you can [take a closer look here](/nx-api/cypress/documents/overview#splitting-e2e-tasks-by-file) at how to configure them correctly.

## BREAKING CHANGE: Updating Bundled Environment Variables: `NX_` to `NX_PUBLIC_`

An important update for folks using environment variables in their builds!

Previously, when building your projects in an Nx workspace, our builds were setup to include any environment variables prefixed with `NX_` and include them in the built artifact so they would be accessible there. This is often used for setting things like urls for different versions of external services to hit - for example, sending requests to your local development server while developing, but pointing to the production service for your production build.

Going forward, these environment variables will need to be prefixed with `NX_PUBLIC_`. This is a security consideration - by requiring a more specific prefix we're making sure that no secrets end up in your production builds unintentionally!

Because of the nature of this change we will NOT be providing an automatic migration. So be sure to manually update any environment variables that you want bundled into your builds from `NX_` to `NX_PUBLIC_`.

## General Crystal Polishing

Along with the features above (many of which further build upon Nx Project Crystal), we've done quite a bit since Nx 18 to polish the features that we introduced with Project Crystal.

Since Nx 18 release, we also started using Project Crystal inside of the Nx repo itself (as well as in Nx Console and in our closed-source monorepo as well). This has allowed us to find many improvements we can make, as well as issues we can fix.

You can find a full list of fixes and features applied in this major release [here](https://github.com/nrwl/nx/releases/tag/19.0.0).

{% video-player src="/documentation/blog/media/2024-05-08/fixes.mp4" alt="A display listing the Github changelog" /%}

With Project Crystal landed now, we're also adjusting our priorities to place a higher importance on stability. You should see this reflected in Nx 19.

As a note, we had noticed an increase in the rate of Github issues since Nx 18 launched. Previously, we had not allocated enough time to handling these issues. To address this, our team is going to be doubling the amount of time focusing on maintainence.

In addition - we are adding more process to make the triage of these issues more efficient. Github issues will now be assigned directly to specific members of the Nx Core Team. The main intention of this change is to increase the efficiency of the time that we do spend on addressing issues.

## Nx Cloud Updates!

[![The Nx Cloud Dashboard](/blog/images/2024-05-08/nx-cloud-dashboard.webp)](/nx-cloud#deep-understanding)

We've got some cool stats to share from our users regarding the benefits of [Nx Cloud](/nx-cloud), our premium CI service. The three areas we've identified as the critical aspects of a CI provider are: speed, cost, and reliablity. In these areas we've seen:

- **speed**: Reported 30% - 70% faster CI
- **cost**: Reported 40% - 75% reduction in CI costs
- **reliability**: Nx Cloud's automatic detection and retrying of flaky tests makes the issue of flaky tests largely go away entirely. You can read more on [our thoughts on reliability here](/blog/reliable-ci-a-new-execution-model-fixing-both-flakiness-and-slowness).

In February, we launched two big enhancements to Nx Cloud: the [Atomizer](/ci/features/split-e2e-tasks) and [Nx Agents](https://nx.app/products/agents#content).

Since then, the Atomizer has received a nice UI update (as we had seen earlier):

{% video-player src="/documentation/blog/media/2024-05-08/nx-cloud-atomizer-groupings.mp4" alt="Showing the Atomizer in Nx Cloud" link="https://staging.nx.app/runs/ctbAZfiLy3" /%}

Since February, we also revamped our task distribution algorithms. This has resulted in a 5-20% (depending on the repo) increase in both speed and cost efficiency for our users.

If you are interested in trying Nx Cloud, go to [https://cloud.nx.app](https://cloud.nx.app).

## More Miscellaneous updates!

We've been updating our docs site. We've tweeked the search to make it more helpful, updated navigation, and as you can tell since you're reading it, we've moved our blog to [nx.dev/blog](/blog) as well.

We've also added a page for [Nx Enterprise](/enterprise):

[![Nx Enterprise Site](/blog/images/2024-05-08/nx-enterprise-site.webp)](/enterprise)

And! We've revamped our newsletter, written by our CTO, Victor Savkin. [Subscribe here](https://go.nx.dev/nx-newsletter) to start receiving it!

## NEW CONFERENCE: Monorepo World 2024

[![NEW CONFERENCE: Monorepo World 2024](/blog/images/2024-05-08/welcome-to-monorepo-world-2024.webp)](https://monorepo.world)

We've got a new conference coming up: [Monorepo World 2024](https://monorepo.world)!

This conference will cover all things dealing with monorepos, and we're excited to host it at the Computer History Museum in Mountain View, California this October 7th!

You can [reserve your tickets now](https://ti.to/nx-conf/monorepoworld2024)! In person tickets start at $300 a piece for Early Bird (open until May 31), and online attendance is free.

The [Call for Speakers](https://sessionize.com/monorepo-world) is open now, and will close on June 20, 2024.

We'll be excited to see y'all there!

## Wrapping Up, And A Heartfelt Thank You

That's it for now!

I did want to take a moment to give a heartfelt thank you to everyone out there. If you weren't aware, I had something of a [personal tragedy](https://twitter.com/zackderose/status/1759695615573864758) in February, not long after our big launch week.

[![My Sadie.](/blog/images/2024-05-08/sadie.webp)](https://twitter.com/zackderose/status/1759695615573864758)

For me, this blogpost represents the beginning of my return to Nx, and to the larger dev community.

To everyone out there - your kindness and care meant more to me than you could know. I intend to return that the positivity and care you invested in me in those dark days back as best I can. So here's looking forward to hard work, more releases, and better days to come.

With Many Thanks,

Zack

## Learn more

- [Nx Docs](/getting-started/intro)
- [X/Twitter](https://twitter.com/nxdevtools) -- [LinkedIn](https://www.linkedin.com/company/nrwl/)
- [Nx GitHub](https://github.com/nrwl/nx)
- [Nx Official Discord Server](https://go.nx.dev/community)
- [Nx Youtube Channel](https://www.youtube.com/@nxdevtools)
- [Speed up your CI](/nx-cloud)
