---
title: Nx — Highlights of 2023
slug: 'nx-highlights-of-2023'
authors: [Juri Strumpflohner, Victor Savkin, Zack DeRose]
cover_image: /blog/images/2023-12-28/featured_img.png
tags: [nx, nx-cloud]
---

It is that time again: getting flooded by Year of Review blog posts. We did it last year, and we should do it again! So here we go, and be warned, 2023 was massive!!

**Table of Contents**

- [Top 10 Nx Highlights of 2023](#top-10-nx-highlights-of-2023)
  - [TypeScript for Extensibility — Rust for Speed](#typescript-for-extensibility-rust-for-speed)
  - [First Class Vite Support](#first-class-vite-support)
  - [Nx’t Level Publishing](#nxt-level-publishing)
  - [Improved Node Backend Development: Fastify and Docker](#improved-node-backend-development-fastify-and-docker)
  - [Nx Console support for IntelliJ](#nx-console-support-for-intellij)
  - [Playwright for e2e testing](#playwright-for-e2e-testing)
  - [TypeScript Packaging and Batch Mode](#typescript-packaging-and-batch-mode)
  - [Nx team maintained Vue plugin](#nx-team-maintained-vue-plugin)
  - [Extending Nx: Local Generators, Build your Own CLI, Verdaccio Support](#extending-nx-local-generators-build-your-own-cli-verdaccio-support)
  - [Module Federation](#module-federation)
- [Many OSS repos adopt Nx](#many-oss-repos-adopt-nx)
- [Nx Community](#nx-community)
- [New Content & Improved Docs](#new-content-improved-docs)
- [New Tagline: Smart Monorepos — Fast CI](#new-tagline-smart-monorepos-fast-ci)
- [Nx Conf](#nx-conf)
- [Looking ahead — 2024](#looking-ahead-2024)
  - [Solving CI](#solving-ci)
  - [Solving the Simplicity vs Power Dilemma](#solving-the-simplicity-vs-power-dilemma)

## Top 10 Nx Highlights of 2023

We shipped a ton of features in 2023. You can find all our release blog posts and release-related info here: [/changelog](/changelog).

We've picked out 10 highlights for you.

### TypeScript for Extensibility — Rust for Speed

At Nx, we’ve heavily embraced Typescript from the beginning and we’ve been very happy with that decision. Nx also stands as the [fastest JS monorepo tool](https://github.com/vsavkin/large-monorepo) available, demonstrating that adopting TypeScript does not necessarily compromise speed. However, we don’t stop here. To push the boundaries further, we started to rewrite the most performance critical and computationally intensive parts of the Nx core in Rust.

Our initial focus was on [rewriting the task hasher](/blog/nx-15-8-rust-hasher-nx-console-for-intellij-deno-node-and-storybook), previously reliant on Git with a Node fallback. This shift to Rust brings a noticeable performance boost, particularly in large repositories, while maintaining the same user experience.

Following this, we revamped the TypeScript dependency resolution, observing an almost 5x speed increase with our Rust-based approach over the traditional TSC method.

{% tweet url="https://twitter.com/juristr/status/1726977598218199302" /%}

Such enhancements are especially crucial for the efficient [project graph calculation](/features/explore-graph). As we continue to evolve Nx, Rust will play a key role in optimizing performance-critical components. This strategic use of Rust complements our ongoing commitment to TypeScript, ensuring Nx remains as extensible and powerful as ever.

### First Class Vite Support

Vite is rapidly transforming the landscape of frontend development! Its refreshing simplicity and innovative approach have made a significant mark in the developer community. What truly stands out is not just Vite’s technological aspect but also how its team approaches and grows the community around the tool. Vite stands for speed and community, values that deeply resonate with us here at Nx.

Our collaboration with our friends in the Vite core team has been incredibly fruitful. Vite is not just compatible but a first-class option with many of Nx’s frontend plugins. When you create a new Nx powered React workspace, Vite (and [Vitest](https://vitest.dev/)) are your default options.

![](/blog/images/2023-12-28/bodyimg1.webp)

We also built some powerful code generators that not only facilitate a seamless [transition from Webpack to Vite](/nx-api/vite/generators/configuration#nxviteconfiguration) but also pave the way for an effortless [migration from a CRA-based setup](/recipes/adopting-nx/adding-to-existing-project) to a modern Nx + Vite based workspace. To see this process in action, [check out this short video](https://www.youtube.com/watch?v=zvYb7XCLQzU).

[AnalogJS](https://analogjs.org/) — the fullstack Angular meta-framework which also heavily builds on top of Vite — is using the `@nx/vite` plugin to power its Angular and Nx based workspaces.

We also spoke at both editions of [ViteConf](https://viteconf.org/23/). If you’re curious check out [Juri’s talk about High Speed Monorepos](https://www.youtube.com/watch?si=A5Nkg3rxe3DlODc4&v=TiU-hdn7_To&feature=youtu.be) and this year’s talk by [Katerina on Streamlining your Vite dev flow with Nx](https://www.youtube.com/watch?si=A5Nkg3rxe3DlODc4&v=TiU-hdn7_To&feature=youtu.be).

### Nx’t Level Publishing

Open source libraries and frameworks share a common necessity: the need to develop multiple packages cohesively and efficiently while managing their versioning and publishing to NPM. Nx has emerged as a go-to choice for handling such open source monorepos (as we’ll explore further in the next section of this blog post). Until recently, one area Nx did not address directly was versioning and release management. Traditionally, this gap has been filled with tools like [release-it](https://github.com/release-it/release-it), [changesets](https://github.com/changesets/changesets), or custom Node scripts, similar to our approach in the Nx repository.

However, many in our community have expressed a desire for a more native, integrated experience for versioning and publishing, akin to what Lerna offers. In response to this feedback, we’ve introduced [the “nx release” command](/features/manage-releases), a solution designed to seamlessly integrate these processes into the Nx workflow.

James Henry gave a deep dive talk of an early version of it at this year’s Nx Conf:

{% youtube src="https://www.youtube.com/embed/p5qW5-2nKqI" /%}

Since its introduction, the “nx release” feature has significantly evolved, leveraging the power of the Nx project graph to effectively understand inter-package dependencies. This understanding is crucial as it allows for:

- Versioning packages offering support for both independent and “locked” versioning strategies.
- Releasing packages in the correct sequence, ensuring dependency integrity.

Beyond these core functionalities, the feature also includes a robust grouping mechanism, supports semantic versioning, and changelog generation. Additionally, it provides various release targets, such as GitHub and NPM. For those having special requirements, the [programmatic API](/features/manage-releases#using-the-programmatic-api-for-nx-release) offers maximum flexibility.

### Improved Node Backend Development: Fastify and Docker

Colocating frontend and backend code within the same monorepo has become a popular practice. It greatly facilitates cross-functional teams and helps ensure end-to-end type safety. Although you can use [other backend stacks](https://www.nx-dotnet.com/) with Nx, Node is a popular backend companion for JS based frontends. We had support for [Express](https://expressjs.com/) and [NestJS](https://nestjs.com/) backend for a while.

This year we added another popular option: [Fastify](https://fastify.dev/). Known for its high performance, excellent developer experience, and useful built-in features like logging, Fastify aligns well with Nx’s modular software design principles. Its extensible and modular nature complements the Nx philosophy perfectly.

{% youtube src="https://www.youtube.com/embed/LHLW0b4fr2w?si=WeTqm5msQxssQ_d3" /%}

In tandem with Fastify, we’ve also introduced [Docker support](https://youtu.be/LHLW0b4fr2w?feature=shared) for Node deployments.

### Nx Console support for IntelliJ

Nx Console has evolved from an experimental side project of the Nx team to a core part for enhancing your productivity when working in a monorepo. Being integrated right into your editor it can provide useful information and functionality right where you need it, whether that’s running commands, [providing contextual autocomplete support](https://twitter.com/juristr/status/1653032530474565638) or the ability to explore the project and task graph.

![](/blog/images/2023-12-28/bodyimg2.webp)

This year we not only added a lot of new features to Nx Console, but also rewrote its [internals](/blog/nx-console-gets-lit) which paved the way to expand Nx Console to other code editors: **JetBrains IDEs.**

Yes, this means you can now use the latest Nx Console directly in your [Webstorm IDE](https://www.jetbrains.com/webstorm/). Read the [announcement blog post](/blog/expanding-nx-console-to-jetbrains-ides) for all the details or go ahead and install Nx Console if you didn’t already:

- [Nx Console for VSCode](https://marketplace.visualstudio.com/items?itemName=nrwl.angular-console)
- [Nx Console for IntelliJ](https://plugins.jetbrains.com/plugin/21060-nx-console)

### Playwright for e2e testing

2023 saw Nx introduce official support for [Playwright](https://playwright.dev/) — a popular testing tool from Microsoft.

In this video, Zack DeRose explains how you can use Playwright to test both a single web application, as well as stand up a full-stack system — including a backend server and a frontend application — and write and run tests using Playwright:

{% youtube src="https://www.youtube.com/embed/k1U3PuBrZFQ" /%}

The repo for this video can also be found [here](https://github.com/nrwl/tic-tac-toe-playwright).

Generally, Playwright fits in the Nx ecosystem as a tool that developers can use as a possible alternative to Cypress — a popular e2e testing tool that Nx has supported for a long time now! In addition to publishing an official [@nx/playwright package](https://www.npmjs.com/package/@nx/playwright), running the command to create a new workspace will now prompt for Playwright as an option for React, Angular, and Vue stacks:

```shell
$ npx create-nx-workspace@latest
> NX   Let's create a new workspace [/getting-started/intro]
✔ Which stack do you want to use? · react
✔ What framework would you like to use? · none
✔ Integrated monorepo, or standalone project? · integrated
✔ Which bundler would you like to use? · vite
? Test runner to use for end to end (E2E) tests …
Cypress [ https://www.cypress.io/ ]
Playwright [ https://playwright.dev/ ]
None
```

Similar options will appear when using Nx generators to create new frontend web applications for an existing workspace.

### TypeScript Packaging and Batch Mode

TypeScript has won. It has become the prevalent way of writing modern JavaScript applications. And we kept improving our support to streamline development and polish some of the rough edges. Like properly defining secondary package entry points. You can define them in the `package.json`, but both creating these entries but especially maintaining them can be quite painful.

```
{
  "exports": {
    "./package.json": "./package.json",
    ".": "./src/index.js",
    "./foo": "./src/foo.js",
    "./bar": "./src/bar.js"
  }
}
```

So in [v16.8](/blog/nx-16-8-release) we added the ability to automatically have these generated for you by defining the `additionalEntryPoints` and `generateExportsField` when using the `@nx/js` plugin.

```
// packages/my-awesome-lib/project.json
{
  "name": "my-awesome-lib",
  "targets": {
    "build": {
      "executor": "@nx/js:tsc",
      ...
      "options": {
        "main": "packages/my-awesome-lib/src/index.ts",
        ...
        "additionalEntryPoints": ["packages/my-awesome-lib/src/foo.ts"],
        "generateExportsField": true
      },
    },
    ...
  }
}
```

Similarly we improved the ability to package your TS libraries in multiple formats (ESM and CJS). When using the `@nx/rollup` plugin, all you need to do is define the `format` property in your config:

```
// packages/my-awesome-lib/project.json
{
  "name": "my-awesome-lib",
  "targets": {
    "build": {
      "executor": "@nx/rollup:rollup",
      ...
      "options": {
        "main": "packages/my-awesome-lib/src/index.ts",
        ...
        "format": ["esm", "cjs"],
        "additionalEntryPoints": ["packages/my-awesome-lib/src/foo.ts"],
        "generateExportsField": true
      },
    },
    ...
  }
}
```

Here’s a video that walks you through:

{% youtube src="https://www.youtube.com/embed/Vy4d0-SF5cY?si=mHatqRPRqHAK0X9o" /%}

But we wouldn’t be talking about Nx if we didn’t also look into speeding up TypeScript compilation for large monorepos. We called it “[batch mode](/showcase/benchmarks/tsc-batch-mode)”. When enabling batch mode, Nx leverages the underlying [project graph](/features/explore-graph) to generate TypeScript project references behind the scenes for you, to fully leverage TS incremental building. The results are amazing. According to [our benchmarks](https://github.com/nrwl/large-ts-monorepo), batch mode has the potential to speed up Typescript compilation by up to 5x for large monorepos.

![](/blog/images/2023-12-28/bodyimg3.gif)

### Nx team maintained Vue plugin

After adding Vite as a first-class citizen of Nx workspaces, it was only a matter of time before Nx started offering official support to Vue!

Vue is currently the second most popular frontend framework (according to npm downloads) behind React and slightly ahead of Angular.

![](/blog/images/2023-12-28/bodyimg4.webp)

The first place your might notice Nx’s support for Vue is in the `create-nx-workspace` script:

![](/blog/images/2023-12-28/bodyimg5.webp)

The option above will create a new Nx workspace with a fresh new Vue application, all set up and ready to develop! To add new Vue projects to an existing Nx workspace, you can also add our `@nx/vue` package as a dev dependency to your workspace:

```shell
% npm add -D @nx/vue
```

And you’ll then have access to Nx generators so you can create Vue applications, libraries, and more in your workspace!

![](/blog/images/2023-12-28/bodyimg6.gif)

Checkout out our [Vue standalone tutorial](/getting-started/tutorials/vue-standalone-tutorial) for more, as well as our [Vue API docs](/nx-api/vue), and stay tuned as Nx prepares to offer more Vue support (including support for [Nuxt](https://nuxt.com/), a full-stack framework built around Vue) in the near future!

### Extending Nx: Local Generators, Build your Own CLI, Verdaccio Support

Extensibility is at the heart of Nx, serving as the cornerstone of its flexibility. It enables the Nx core team to continually expand capabilities through dedicated plugins and simultaneously paves the way for a rich array of [community plugin contributions](/plugin-registry). Furthermore, Nx’s adaptable nature is particularly beneficial for large enterprises, as it allows for the creation of custom automation solutions, specifically tailored to meet their unique organizational needs.

In 2023 we kept improving Nx’s extensibility, unifying the Nx plugin development model and how you develop workspace-local automations. You can now scaffold a new plugin into your Nx workspace and run it right away which makes it an interesting approach to automate your monorepo.

{% youtube src="https://www.youtube.com/embed/myqfGDWC2go?si=q6_9JReS1nF8d3pZ" /%}

When creating automations with Nx you cannot just enhance existing Nx workspaces, but also develop a complete [Nx preset](/extending-nx/recipes/create-preset) that controls the entire appearance of an Nx workspace. Basically your own, personalized `create-nx-workspace`. You can publish and then use your preset like:

```shell
npx create-nx-workspace myrepo --preset=@yourpkg/nx-preset
```

We wanted to make building on top of Nx even more pleasant, allowing you to introduce your own branding by [building your own CLI with Nx](https://www.youtube.com/watch?v=ocllb5KEXZk). The [Qwik-Nx](https://github.com/qwikifiers/qwik-nx) repo is a great example where they allow you to scaffold a new Nx workspace for Qwik development with:

```shell
npx create-qwik-nx
```

And finally, we extracted our own [Verdaccio](https://verdaccio.org/) setup that we’ve been using to run our e2e tests in the [Nx repo](https://github.com/nrwl/nx) s.t. you can use it for your own plugin development as well. Check out [this video](https://www.youtube.com/watch?v=t1c925TzrzE) for a walkthrough on how this works.

### Module Federation

[Module Federation](https://medium.com/swlh/webpack-5-module-federation-a-game-changer-to-javascript-architecture-bcdd30e02669) is an exciting new feature of Webpack 5 that has gained a significant amount of interest in 2023.

Simply put, Module Federation allows a Javascript application running in a browser to dynamically load code from another application hosted at a different url, while facilitating optimal loading of shared dependencies.

This is an exciting development as it allows a paradigm shift in how you can architect, build, and deploy Javascript applications! And this is especially exciting for monorepo fans, as Nx has best-in-class support for module federation that makes a Module Federation approach easy to adopt and simple to understand!

Currently, our `@nx/angular` and `@nx/react` plugins both have generators to [create a “host” application](/recipes/module-federation/create-a-host) that will load and consume federated modules from [“remote” applications](/recipes/module-federation/create-a-remote), which you can also generate using Nx. Then, by running a simple command with Nx, you can serve all applications required for your host application with the command:

```shell
nx serve host-application --devRemotes=remote-application
```

Where in the example above your host application is named “host-application” and a remote application that you want live updates on as you’re developing is named “remote-application”.

Throughout 2023, we’ve continued to increase Nx’s support and general dev experience around Module Federation, including [adding a generator to federate an existing module](/recipes/module-federation/federate-a-module), improving the local developer experience by improving local webserver performance, and introducing the concept of [Dynamic Module Federation](/recipes/angular/dynamic-module-federation-with-angular#advanced-angular-micro-frontends-with-dynamic-module-federation) which will allow you to dynamically specify the location of your remote applications via a “module-federation.manifest.json” file!

At Nx, we’re excited about the Module Federation support we offer for our users, and think that it has many interesting applications when paired with Nx’s CI capabilities, in particular allowing for [much shorter build times](/concepts/module-federation/faster-builds-with-module-federation) especially for larger Angular applications.

## Many OSS repos adopt Nx

By simply installing the `nx` package (or initializing with `nx init` in any project or monorepo), you already get some cool features:

- Advanced task scheduling, including task pipelines and parallel execution.
- Efficient caching mechanisms.

> If you want to learn more about such setup, make sure to check out our blog post on [how to adopt Nx on a npm/yarn/pnpm workspace](/blog/setup-a-monorepo-with-pnpm-workspaces-and-speed-it-up-with-nx) or the corresponding [video version](https://www.youtube.com/watch?si=0XH6Sp025xM3Rru5&v=ngdoUQBvAjo&feature=youtu.be).

Numerous open-source packages are adopting Nx in this lightweight manner. It enables them to maintain their existing setup while notably enhancing the local developer experience (DX) in task execution and accelerating processes on CI.

I picked out some of the more well-known OSS repos that started using Nx this year:

[**Tanstack**](https://tanstack.com/) — Tanstack has evolved to an entire ecosystem consisting of the famous [Tanstack (or React) Query](https://github.com/tanstack/query), [Tanstack Table](https://github.com/tanstack/table), now also [Tanstack Router](https://github.com/tanstack/router) and [Tanstack Form](https://github.com/tanstack/form). It started with Tanstack Query, which adopted Nx and Nx Cloud. [Zack talked about this collab with Dominik](https://www.youtube.com/watch?v=NvPXK6DVZGE), and we also had [Dominik](https://twitter.com/TkDodo) on our [Nx live stream](https://www.youtube.com/live/IbU6b6s0H1Q?si=0QZexPwulLXB9FIN). Now, all the above-mentioned Tanstack libs have adopted Nx, and there’s more coming.

[**Sentry JavaScript**](https://github.com/getsentry/sentry-javascript/) — Sentry, renowned for its comprehensive solutions in frontend monitoring and error logging, recently adopted Nx for their [official JavaScript SDK](https://github.com/getsentry/sentry-javascript/). This move integrates Nx’s capabilities into their monorepo, containing packages for popular frontend and Node.js backend integrations. They also published a blog post on [the benefits they’ve seen following the adoption of Nx in their monorepo](https://sentry.engineering/blog/reduce-ci-time-with-nx-caching) (hint: reducing CI times by 35%).

[**RxJS**](https://github.com/ReactiveX/rxjs) — The library for reactive programming in JavaScript. It is widely popular, with over 40 million downloads/week on NPM. RxJS only recently adopted Nx, not only leveraging speed improvements via caching, but also leveraging Nx’s latest `nx release` feature to publish packages to NPM.

[**AnalogJS**](https://analogjs.org/) — Analog is a full-stack Angular meta-framework that brings exciting features to Angular, like faster Vite setup, support for both server-side and static rendering, and easy file-based routing. Analog uses an Nx monorepo for its development and also uses [Nx’s DevKit](/extending-nx/intro/getting-started) to create tools that work great in both Nx and Angular CLI workspaces.

[**Qwikifier**](https://github.com/qwikifiers/qwik-nx) — The Qwikifiers community built a dedicated Nx plugin to combine the power of Qwik and Nx. Their repo is a great example of building Nx plugins and [using Nx to build your own CLI](/extending-nx/recipes/create-install-package).

[**Builder.io Mitosis**](https://github.com/BuilderIO/mitosis) — [BuilderIO](https://www.builder.io/) has an ambitious compiler project that allows you to write a component once and then compile it to different frameworks. Check out their [mind-blowing demo page](https://mitosis.builder.io/?outputTab=G4VwpkA%3D). They adopted Nx to [coordinate task dependencies](/concepts/task-pipeline-configuration) and speed up their CI builds.

[**Ghost**](https://github.com/TryGhost/Ghost) — Are you into blogging? You might want to look at [Ghost](https://ghost.org/). They were using Lerna in the past and migrated to a fully Nx-powered workspace.

And these are just some of them that joined in 2023. If I missed some cool ones (which I’m pretty sure), [ping me](https://twitter.com/juristr) and let me know!

## Nx Community

Nx has a huge community! We’re lucky to have so many folks rooting for Nx, whether on socials, talking at conferences, writing blog posts or [creating awesome plugins](/plugin-registry).

**Nx Champions** — This year we finally launched which we had planned for a long time. Our [Nx Champions](/community) program.

![](/blog/images/2023-12-28/bodyimg7.webp)

These are individuals who stood out for their contributions and passion for helping within the Nx community. We wanted to build a more connected relationship with these folks and have a channel to gather more direct feedback as well. Get to know [all of our champions](/community).

**New Discord server** — Around September we also switched over from our previous Nx Slack community to a brand new [**Nx community Discord**](https://go.nx.dev/community), which is already 2,600 members and counting. Discord is popular among OSS communities and allows new folks to join easily. In addition, we now have a dedicated forum integrated, as well as a couple of useful automations. More coming next year!

Make sure [you join](https://go.nx.dev/community)!

## New Content & Improved Docs

Our [Youtube channel](https://www.youtube.com/@nxdevtools) has grown to over 15k subscribers and peaks of 65k views a month. We love to provide educational video content, so make sure to subscribe! It got a little silent towards the end of the year, but we’ve been working a lot behind the scenes. So stay tuned!

We also poured a lot of [effort into the docs](/getting-started/intro). We restructured them following the [Diataxis](https://diataxis.fr/) to make pages less overwhelming and more structured based on their type of content. You’ll find

- [**Concept docs**](/concepts) — which explain some of the inner workings and mental model behind certain features. Like [how caching works](/concepts/how-caching-works).
- [**Recipes**](/recipes) — which are solution oriented. You already know how to cook, we provide the exact recipe for it.
- [**Tutorials**](/getting-started/tutorials) — for when you just want to sit down and follow along, step by step to learn how to use Nx in a certain context.
- [**Reference**](/reference) and [**API docs**](/nx-api) — pure, raw and to the point.

We created a brand new [“Why Nx”](/getting-started/why-nx) page explaining the overall architecture of Nx including a [brand new video](https://www.youtube.com/watch?v=-_4WMl-Fn0w) giving you a holistic overview of what Nx is capable of.

We also refreshed our [entry pages](/getting-started/intro), including dedicated examples of using Nx with popular stacks:

![Examples include Express, Vue, Next, Nuxt, Rract Native, Rust, Go, Storybook, and more.](/blog/images/2023-12-28/bodyimg8.webp)

You can also browse them in the [nx-recipes](https://github.com/nrwl/nx-recipes) GitHub repository.

{% tweet url="https://twitter.com/juristr/status/1736023402933318011" /%}

And obviously, we jumped on the AI train as well. A couple of months ago, we added the [Nx Assistant](/ai-chat). A ChatGPT-powered interface trained on our docs. [Katerina](https://twitter.com/psybercity) wrote about it [on our blog](/blog/nx-docs-ai-assistant). The AI chat allows to interactively ask questions about Nx and will give you relevant answers from our docs (including linking to the sources).

## New Tagline: Smart Monorepos — Fast CI

Nx stands out for its flexibility, accommodating for both monorepo and non-monorepo project structures. This approach allows users to begin with simpler project configurations, leveraging the benefits of Nx’s robust tooling, and later, when the need arises, seamlessly [migrate to a monorepo](/recipes/tips-n-tricks/standalone-to-monorepo).

However, Nx’s true strength becomes most apparent at scale, typically within a monorepo setup. We wanted to capture it in our new tagline: **Smart Monorepos — Fast CI**.

{% tweet url="https://twitter.com/juristr/status/1734558895547568634" /%}

Setting up an efficient and maintainable CI process for monorepos can be a complex task, so we’ve also made it a focal point in our new tagline. Nx expands beyond the local development experience, helping you set up an efficient CI process. We’re publicly launching [Nx Agents](/ci/features/distribute-task-execution) to add seamless distribution to your CI pipeline, and more are coming in 2024.

As part of that, we also restructured our docs to have a section entirely dedicated to CI: [/ci](/ci/intro/ci-with-nx).

## Nx Conf

We did it again! The second in-person Nx Conf was a resounding success, this time set against the vibrant backdrop of the Big Apple.

![](/blog/images/2023-12-28/bodyimg9.webp)

There’s not much to say. Check out some of the amazing talks. I did a [Nx Conf 2023 recap blog post](/blog/nx-conf-2023-recap).

## Looking ahead — 2024

Although we shipped a lot in 2023, in many ways 2023 was about preparing for what we are planning to ship in Q1 2024.

### Solving CI

Legacy CI systems are a performance and productivity bottleneck if you use a powerful build system like Nx. Big tech companies know it and that’s why their CI systems look nothing like Circle or Jenkins. We’ve been narrowing this gap over the years, but only this year we finally built a turn-key CI solution that gives you great performance, scalability, dev ergonomics, and must better cost efficiency.

It has three components:

- [**Nx Cach**](/ci/features/remote-cache): Built-in local and remote caching to speed up your tasks and save you time and money. Available now.
- [**Nx Agents**](/ci/features/distribute-task-execution): A single line to enable distributed computation, across multiple machines. Fully managed agents, dynamically allocated based on PR size. Available early Feb.
- **Nx Workflows**: Next generation, fully managed CI solution with distribution at its core, designed from the ground up for monorepos. _Available later in 2024._

Optimal parallelization and distribution, using the right numbers of agents for each PR, rerunning flaky tests, splitting and distributing large test suites, handling dependencies between tasks across machines — are just some of the things we can now handle automatically for you. Turn it on and enjoy the speed.

### Solving the Simplicity vs Power Dilemma

Balancing simplicity and power is the trickiest part of the dev tools design. Simple onboarding for small projects or handling the biggest enterprise systems? Two years ago we solved this problem by giving you a choice between the package-based setup (a more powerful version of something like Turborepo) and the integrated setup (we manage your whole monorepo in the most optimal way). But now we believe we have a much better solution, where you have both, the simplicity of the former with the power of the latter. So you no longer have to choose.

We took inspiration from VSCode. Any project you open in VSCode will work right away: it is simple, and you don’t need to configure anything. If you install say a Playwright plugin, VSCode becomes aware of Playwright. It can run and debug your tests right in the editor. That’s what the Nx experience is going to be like. Any project, any tool will work right away. But if you — for instance — install the Playwright plugin, Nx will become aware of Playwright and will be able to cache test runs in the most optimal way and distribute your e2e tests across machines for best efficiency. All the benefits with none of the costs.

The whole team is excited about it as the new experience feels much more elegant.

As always, we try very hard not to break folks, so all your current workspaces will keep working, and we will [provide automatic migrations](/features/automate-updating-dependencies) to bring you to this new way of using Nx.

Exciting stuff! So keep an eye on our channels, and subscribe if you haven’t already ;)

---

## Learn more

- [Nx Docs](/getting-started/intro)
- [X/Twitter](https://twitter.com/nxdevtools)
- [LinkedIn](https://www.linkedin.com/company/nrwl/)
- [Nx GitHub](https://github.com/nrwl/nx)
- [Nx Official Discord Server](https://go.nx.dev/community)
- [Nx Youtube Channel](https://www.youtube.com/@nxdevtools)
- [Speed up your CI](/nx-cloud)
