---
title: Nx 17.2 Update
slug: 'nx-17-2-release'
authors: [Zack DeRose]
cover_image: '/blog/images/2023-12-20/featured_img.png'
tags: [nx, changelog, release]
---

It’s been a bit since we launched [Nx 17](/blog/nx-17-release)! In this article, we’ll go over some of the new developments and improvements that have landed in Nx 17.2:

- [Nx Closes In On 4 Million Weekly NPM Downloads!!](#nx-closes-in-on-4-million-weekly-npm-downloads)
- [New Simplified Project Configuration On the Way](#new-simplified-project-configuration-on-the-way)
- [Rust for Speed, Typescript for Extensibility](#rust-for-speed-typescript-for-extensibility)
- [Module Federation Updates](#module-federation-updates)
- [Nx Release Updates](#nx-release-updates)
- [Angular 17 (AND NgRx 17) Support](#angular-17-and-ngrx-17-support)
- [Smart Monorepos — Fast CI](#smart-monorepos-fast-ci)
- [New Canary Releases](#new-canary-releases)
- [Upcoming Release Livestream](#upcoming-release-livestream)
- [Automatically Update Nx](#automatically-update-nx)

## Nx Closes In On 4 Million Weekly NPM Downloads!!

2023 has been a great year for Nx! We worked with a lot of the teams out there building fantastic open source tools. And you can see the results: we made [Vite](https://vitejs.dev/) a first class citizen in many of our Nx plugins, we added support for [Rspack](https://www.youtube.com/watch?v=jGTE7xAcg24), streamlined our Node experience by adding an Nx team maintained [Fastify plugin](https://www.youtube.com/watch?si=P5MPIiD_mxTpQStY&v=LHLW0b4fr2w&feature=youtu.be), support for Storybook interaction testing, welcomed Playwright to the family and much more, continuing our missing to push developer productivity to the limits!

And our downloads on NPM keep confirming this. We are about to cross 4 million downloads per week.

![](/blog/images/2023-12-20/bodyimg1.webp)

If this made you curious, keep an eye on [our blog](/blog) or [X/Twitter](https://twitter.com/nxdevtools) as we’re going to release a 2023 year recap blog post next week.

## New Simplified Project Configuration On the Way

Adoption is crucial, and simplicity is the driver for adoption. Last year we heavily optimized how you can use Nx in an existing project. Just drop the `nx` package (or run `nx init`) and that's it. Nx understands your workspace and efficiently runs your `package.json` scripts.

Using Nx at that level is definitely useful as you get intelligent parallelization, task pipelines and caching. But it is just the tip of the iceberg of what Nx is actually capable of. Nx plugins provide much more, especially in terms of DX and developer productivity by taking away some of the burden of configuring your monorepo tooling. But many devs new to Nx found it harder to get started with them initially and incrementally migrating to Nx plugins wasn’t as straightforward as we’d wanted it to be.

This is something that’s gonna change drastically in 2024. And we’ve layed the first cornerstone for that. But it is behind a feature flag still as we’re streamlining the last bits. The goal?

- Going almost configuration-less (good defaults, you customize when you need to)
- Allowing easy drop-in of Nx plugins into existing workspaces (provides immediate productivity gains, but stays out of your way)

This opens up a series of possibilities which we’re already super excited about. You’ll hear more about this in the new year ;)

## Rust for Speed, Typescript for Extensibility

At Nx, we’ve heavily embraced Typescript from the beginning, and we’ve been very happy with that decision.

If you’ve been paying attention to previous release announcements though, you’ve probably noticed that we’ve been moving more and more of the computationally intensive and performance critical pieces of the core of Nx from Typescript to Rust.

That trend continues in Nx 17.2 with Nx [using Rust for its task hashing by default](https://github.com/nrwl/nx/pull/19617). There’s no adjustments needed for this change, and Nx will continue to behave the same way, just faster!

{% tweet url="https://twitter.com/victorsavkin/status/1724464283227234420" /%}

## Module Federation Updates

Module Federation has been a particularly hot topic lately, and 17.2 is coming in with some great enhancements to Nx’s already best-in-class support for Module Federation!

To start, we’ve greatly reduced the CPU and memory used for standing up your Module Federation “web” locally. These enhancements should be great news to larger workspaces using a Module Federation approach, where there were heavy CPU and memory costs to serving your entire federation locally.

We accomplished these improvements by batching any applications that are not being watched for changes (listed with the `--devRemotes` option) to a single server, rather than a unique server for each application. We also parallelized the builds of these static applications when you start up your serve! You can now use the `--parallel={number}` option to specify how many builds you want going at any given time.

In addition to performance improvements, we’ve brought the concept of dynamic federation to our React module federation support. Dynamic federation allows a host application to dynamically load remotes via the manifest file.

You can generate your react module federation workspace now to use dyanmic federation via the `--dynamic` flag:

```shell
nx generate @nx/react:host apps/acme --remotes=nx --dynamic
```

Or you can use the utility itself by importing from `@nx/react/mf`:

```ts
import { loadRemoteModule } from '@nx/react/mf';
```

Lastly, we have an [example repo](https://github.com/jaysoo/nx-react-vite-module-federation) available now to illustrate how to create a plugin for Module Federation using Nx with Vite! This is something that we are monitoring and may provide an out-of-the-box solution to this in a future release!

## Nx Release Updates

Nx 17 launched with the new `nx release` capability in the Nx CLI. Since then we've been streamlining the experience, accounting for various edge cases and release scenarios. (extensive docs are being worked on rn ;)

To give you full flexibility, in 17.2, we’ve added a programmatic API, which will allow you to easily write custom release scripts:

```ts
import { releaseChangelog, releasePublish, releaseVersion } from 'nx/release';

(async () => {
  const { workspaceVersion, projectsVersionData } = await releaseVersion({
    specifier: 'minor',
  });
  await releaseChangelog({
    versionData: projectsVersionData,
    version: workspaceVersion,
  });
  await releasePublish();
  process.exit(0);
})();
```

This script above demonstrates how you can use this API to create your own script for updating your workspace’s version, then creating a changelog, and then publishing your package!

We’ve also added first class support for independently released projects, meaning you can now target a specific project for release with the `--projects` command. For example, you can create a new version for just one project in your workspace with the command:

```shell
nx release version patch --project=my-project
```

## Angular 17 (AND NgRx 17) Support

![](/blog/images/2023-12-20/bodyimg2.webp)

[Angular](https://angular.dev/) is in the middle of [a HUGE renaissance](https://blog.angular.dev/introducing-angular-v17-4d7033312e4b), between their new logo, new docs site, and introduction of some awesome features like Signals.

Nx is here to support the transition! Nx has always been a great fit for Angular, and now supports Angular 17 as well as NgRx 17.

To automatically migrate existing workspaces to Angular v17, run the commands:

```shell
nx migrate latest
nx migrate --run-migrations
```

You can also use the `--interactive` flag if you want to migrate your workspace to the latest version of Nx while staying on your current version of Angular:

```shell
nx migrate latest --interactive
✔ Do you want to update to TypeScript v5.2? (Y/n) · true
✔ Do you want to update the Angular version to v17? (Y/n) · false

 >  NX   The migrate command has run successfully.

   - package.json has been updated.
   - migrations.json has been generated.

 >  NX   Next steps:

   - Run 'nx migrate --run-migrations'
```

## Smart Monorepos — Fast CI

We just gave our Nx homepage a small facelift, including a new tagline, subtagline and illustration to better reflect Nx’s mission statement.

![](/blog/images/2023-12-20/bodyimg3.webp)

When you enter the monorepo space, having good local development experience and tooling to support you is one thing, scaling is the other. And scaling comes with multiple challenges, from scaling teams working on the monorepo to maintaining high throughput on CI.

The latter is a common headache and we’ve seen companies struggle. With Nx we’re moving into the direction of becoming your e2e solution for monorepos, where we don’t just cover your local dev experience, but also provide robust and scalable solutions on CI.

![](/blog/images/2023-12-20/bodyimg4.webp)

We’re super excited to have launched “Nx Agents” to Early Access. If you haven’t seen Victor’s video yet about how he reduced e2e tests from 90 minutes to 10, then make sure to [check it out](/ci/features/distribute-task-execution).

**“Nx Agents”** are the next iteration of DTE, providing a more flexible, cost effective and more performant approach to distribution on CI. This includes things like being able to dynamically allocate machines based on the size of the PR and flaky task detection and re-running. Also, it can be configured with a single line:

```yaml
- name: Start CI run
  run: 'npx nx-cloud start-ci-run --distributes-on="8 linux-medium-js"'
  ...
```

You can run Nx Agents on any CI provider. If you’re curious, [sign up for early access](https://go.nx.dev/nx-agents-ea)!

## New Canary Releases

We’ve added a new npm release tag: canary!

![](/blog/images/2023-12-20/bodyimg5.webp)

This canary release is created via a [cron job](https://github.com/nrwl/nx/blob/master/.github/workflows/publish.yml#L5C61-L5C61) that will regularly publish the current contents of the master branch of Nx.

You can give the canary version a try new for a new workspace using the command:

```shell
npx create-nx-workspace@canary
```

This should be useful for previewing new not-yet released features!

## Upcoming Release Livestream

{% youtube src="https://www.youtube.com/embed/OXXTUjSO1hs?si=iDFETYdpg-0BrAIP" title="Nx 17.2 Release Livestream" /%}

We’re going live in January with the Nx team to go over these updates as well! Be sure to click the link to get notified when we go live! And feel free to come with your questions in the chat!

## Automatically Update Nx

Updating Nx and its plugins is easy as we ship an [automated migration command](/features/automate-updating-dependencies).

```shell
npx nx migrate latest
```

After updating your dependencies, run any necessary migrations.

```shell
npx nx migrate --run-migrations

```

## Wrapping up

That’s all for now folks! We’re just starting up a new iteration of development on Nx, so be sure to subscribe to our [YouTube channel](https://www.youtube.com/@nxdevtools) to get updates when new features land! Until next time, KEEP WORKING HARD!

---

## Learn more

- [Nx Docs](/getting-started/intro)
- [X/Twitter](https://twitter.com/nxdevtools) -- [LinkedIn](https://www.linkedin.com/company/nrwl/)
- [Nx GitHub](https://github.com/nrwl/nx)
- [Nx Official Discord Server](https://go.nx.dev/community)
- [Nx Youtube Channel](https://www.youtube.com/@nxdevtools)
- [Speed up your CI](/nx-cloud)
