---
title: 'Nx 16.5 Release!!!'
slug: 'nx-16-5-release'
authors: ['Zack DeRose']
cover_image: '/blog/images/2023-07-06/Gm3s_wLWrAf_uH2AzfJvvQ.png'
tags: [nx, release]
---

We have launched SO MANY features since our last release blog on Nx 16.0, so we’re covering the major features in this blog!

{% youtube src="https://youtu.be/7XLoLOc3afY" /%}

Be sure to mark your calendars for our Nx 16.5 livestream as well! We’ll highlight the features you see here AND field any questions live! Follow the link to schedule a notification for when we go live:

{% youtube src="https://youtu.be/EYgkKmYbRNI" /%}

## Targetting Tasks By Tags

Our first major feature actually comes to us from the community. Nx has supported a tags property in your project.json file for awhile now — and it’s main purpose has been to be used in conjuncture with the [Nx Module Boundary lint rule](/features/enforce-module-boundaries) to define which projects in your Nx workspace can depend on what — for example, you don’t want your frontend applications to depend on any backend-specific code.

With this new feature, you can add the `--tag` option to the [`nx affected`](/nx-api/nx/documents/affected) and [`nx run-many`](/nx-api/nx/documents/run-many) commands to specify to Nx to only run commands for projects that match the given tags.

{% youtube src="https://youtu.be/enQDQmFquGU" /%}

## NextJS 13 Support

React Server Components and the new NextJS app router are here, and Nx is here to support them. We’ve added support for the latest versions of Next — complete with generators and executors. We’ve also made sure that our [`withNx` NextJS plugin](/recipes/next/next-config-setup), which allows you to import from your other projects in your workspace while still working with the NextJS build scripts, works both for workspaces using our executors in an Integrated Monorepo approach, as well as for those using a Package-Based approach that are simply using the `next dev` command directly to start their dev server.

There’s also built-in support for the new turbopack builder option via the `--turbo` command, for example: `nx serve webapp --turbo`

We’ve also launched a new preset for `npx create-nx-workpace` for a standalone NextJS app. Checkout it out using the command: `npx create-nx-workspace@latest --preset=nextjs-standalone` or use the interactive prompts to find it:

![](/blog/images/2023-07-06/EZrDq742M_PZZhgn.avif)

We’ve added a couple videos specifically on Next development in an Nx workspace in the past month, so if you’re looking for more on Next, be sure to check them out!

{% youtube src="https://youtu.be/RupxGAQ3fBY" /%}

{% youtube src="https://youtu.be/X3WfXAZZH7s" /%}

## New Nx Recipes!!!

Did you know that we maintain [a set of Nx workspaces](https://github.com/nrwl/nx-recipes) designed to serve as examples for different Nx Workspaces?

We’ve recently added examples repos for:

- fastify + mongo
- fastify + postgres
- fastify + redis
- nextjs + trpc
- remix
- serverless + fastify + planetscale

Go check it out at [https://github.com/nrwl/nx-recipes](https://github.com/nrwl/nx-recipes) and let us know in the comments if there are more recipes you’d like to see or if you want to see videos made from any of the existing recipes!

## Angular 16 Support And Migrations

Angular is continuing their pattern of releasing new and exciting features — and in Nx 16.1, we added support for Angular 16, including updates to our NgRx generators and cypress support.

As usual, we provide migrations to the most recent Angular version to cover your codebase for any breaking changes going to Angular 16.

And in case you missed it, Nx is no longer tied to your Angular version — the most recent version of Nx will now always [support all currently LTS versions of Angular](/nx-api/angular/documents/angular-nx-version-matrix), meaning you DON’T have to upgrade your Angular version in order to get all these latest Nx Features. Be sure to use the `--interactive` flag to take advantage of this feature: `nx migrate latest --interactive`. You can find more details in [our docs for choosing optional packages to apply](/recipes/tips-n-tricks/advanced-update).

{% youtube src="https://youtu.be/AQV4WFldwlY" /%}

## New `verdaccio` support!

The `@nx/js` package now includes a new `setup-verdaccio` generator as well as a `verdaccio` executor!

{% youtube src="https://youtu.be/t1c925TzrzE" /%}

Running `nx g setup-verdaccio` will now add a new `local-registry` target to your workspace, that will use the new `verdaccio` executor.

To start your local registry, run the command `nx local-registry` in one terminal, and then you can publish via commands like `npm publish` as you normally would, but rather than publish packages to the npm registry, this will only publish those packages to your locally-running registry!

While the `local-registry` process is running, you will also be able to install packages published to your local registry as well.

These tools should help in particular with local testing of publishing packages to help support both manual and automated testing!

## Create your own CLI with Nx

The use of command-line interfaces (CLIs) to create new workspaces is common in various technologies. React has one, so does Angular, Vue, Vite and many more. Maintaining a good CLI experience can be tedious though, especially because framework authors would rather want to focus on the library or framework itself.

For a while now, Nx plugin authors had the possibility to create a so-called “preset” to control the entire Nx workspace structure. Once published it can be invoked by using the `--preset` flag:`npx create-nx-workspace myapp --preset=@my/plugin`. [Qwik-Nx](https://github.com/qwikifiers/qwik-nx) is an example of that.

However, many authors would rather want to have a more “branded” experience. Like being able to invoke the previous example as follows:

```shell
npx create-qwik-nx myapp
```

To fulfill this need, in 16.5 we ship with a new `create-package` generator that allows you to add and ship such "CLI package" with your Nx plugin.

You can either create a new Nx plugin workspace immediately with a CLI package using:

```shell
npx create-nx-plugin my-own-cli --create-package-name=create-my-own-cli-app
```

Or alternatively add it to an existing Nx plugin workspace using:

```
nx g @nx/plugin:create-package <cli name> --project=<existing plugin name> --e2eProject e2e
```

## New `externalDependencies` Input Type

Nx now supports a new input type: `externalDependencies` to add to the existing input types: `filesets`, `runtime` inputs, and `env` variables.

By default, Nx will take the defensive stance of assuming that all packages will affect your commands, meaning all external dependencies are taken into account when hashing your task’s dependencies.

The new `externalDependencies` input type allows you to specify a specific set of external dependencies for a given command, so you can configure your tasks to more accurately reflect their inputs.

For example, if you have a `publish-package` target that is using a `command` of `lerna publish` for your publishing, you can specify that the only external dependency for that specific input is `lerna`:

```json
{
  "name": "mylib",
  // ...
  "targets": {
    "publish-package": {
      "command": "lerna publish",
      "inputs": [{ "externalDependencies": ["lerna"] }]
    }
  }
}
```

This way you are free to change other dependencies that don’t affect this task without invalidating your cached run of the task.

{% youtube src="https://youtu.be/FRqgWBmHmAU" /%}

## New `@nx/dependency-checks` EsLint Rule

We’ve added a new `@nx/dependency-checks` lint rule to help with detecting any issues when specifying dependencies for your packages.

This rule will analyze your source code to determine any dependencies you are using in this specific package, and will catch any missing dependencies, mismatched versions, and unused dependencies in your project’s `package.json` file.

Even better, this rule supports the `--fix` option to automatically fix any issues that are found - making it a great tool for automating your dependencies.

After migrating your Nx workspace, you should have access to this lint rule. To turn it on, you’ll need to adjust the `lint` targets in your `project.json` files to include your `package.json` files like so:

```json
{
  "name": "webapp",
  // ...
  "targets": {
    // ...
    "lint": {
      "executor": "@nx/linter:eslint",
      "outputs": ["{options.outputFile}"],
      "options": {
        "lintFilePatterns": [
          "apps/webapp/**/*.{ts,tsx,js,jsx}",
          "apps/webapp/package.json" // here!
        ]
      }
    }
  }
}
```

Then in “webapp” project’s `.eslintrc.json` file you'll want to turn the rule on for your json files:

```json
{
  ...
  "overrides": [
    // ...
    {
      "files": ["*.json"],
      "parser": "jsonc-eslint-parser",
      "rules": {
         "@nx/dependency-checks": "error"
      }
    }
  ]
}
```

Now you should be able to run the linter via `nx run-many --target=lint` to catch any errors across any of your packages, and you can `nx run-many --target=lint --fix` to automatically fix all errors as well.

## Nx Goes Brrrrrr

Nx has continued to get faster!

Our biggest speed increase has come from moving our task hashing into the Nx Daemon. A daemon process refers to a process that runs continuously in the background.

Because the daemon persists between command runs, we are able to have more of the work that goes into hashing a task cached, which we added in Nx 16.3!

In Nx 16.4 we also moved to a rust-based watcher to further improve performance. We had already began the migration of some of the more performance-intensive computation of Nx to Rust in prior version, but we’re excited to bring more of the core of Nx into Rust and see more of these performance gains!

Since our last benchmarking of Nx in October of last year where we clocked Nx at 276.2ms per command, these speed boosts have now gotten us down to 149.3ms, nearly doubling our speed!!

You can see our results and the details of the benchmark — and even run the benchmarks for yourself in [this repo](https://github.com/vsavkin/large-monorepo).

## Nx Console Revamped

Nx Console got a new coat of paint in both the VsCode and JetBrains (IntelliJ/Webstorm) IDEs!

![](/blog/images/2023-07-06/5nr7ReGoDTIEw5kl.avif)
_New Nx Console Coat of Paint in VsCode_
![](/blog/images/2023-07-06/Uox5jg4O4DEM4kAJ.avif)
_New Nx Console Coat of Paint in IntelliJ_

As part of the redesign, we also moved our webviews to the Lit framework — checkout all the latest updates in this video:

{% youtube src="https://youtu.be/p455D4W7330" /%}

## Nx Changelog Launched

Last but CERTAINLY not least, we’ve launched [a new changelog](/changelog) to our docs site!

![](/blog/images/2023-07-06/RewMSU5fPazv_fn.avif)

This changelog includes links to all the release notes for all major and minor versions, as well as links to patch versions. We made sure to also include any deprecations or breaking changes brought about by each version as well.

## Wrap Up

That’s all for now folks! We’re just starting up a new iteration of development on Nx, so be sure to subscribe to [our YouTube channel](https://youtube.com/@nxdevtools) to get updates when new features land! Until next time, KEEP WORKING HARD!

## Learn more

- 🧠 [Nx Docs](/getting-started/intro)
- 👩‍💻 [Nx GitHub](https://github.com/nrwl/nx)
- 💬 [Nx Official Discord Server](https://go.nx.dev/community)
- 📹 [Nx Youtube Channel](https://www.youtube.com/@nxdevtools)
- 🥚 [Free Egghead course](https://egghead.io/courses/scale-react-development-with-nx-4038)
- 🚀 [Speed up your CI](/nx-cloud)

## More Nx Release Notes:

- [Nx 16.0](/blog/nx-16-is-here)
- [Nx 15.8](/blog/nx-15-8-rust-hasher-nx-console-for-intellij-deno-node-and-storybook)
- [Nx 15.7](/blog/nx-15-7-node-support-angular-lts-lockfile-pruning)
- [Nx 15.4](/blog/nx-15-4-vite-4-support-a-new-nx-watch-command-and-more)
- [Nx 15.3](/blog/nx-15-3-standalone-projects-vite-task-graph-and-more)
