---
title: 'Nx 16 is Here!'
slug: 'nx-16-is-here'
authors: ['Zack DeRose']
cover_image: '/blog/images/2023-05-02/n8JTIcKSYkebBOl8zZuF9w.png'
youtubeUrl: 'https://youtu.be/JIhOyJtuxEA'
tags: [nx, release]
---

We’re proud to announce the release of Nx version 16! In this article, we’ll go over the major updates from Nx 16 and the key pieces of information you’ll need to know for the changes that Nx 16 brings!

But before we jump into the new features of Nx 16, let’s recap some of the recent features from our Nx 15 minor releases!

- We introduced simpler presets for React, Angular, and [Node starter applications](https://youtu.be/K4f-fMuAoRY)
- We added official support for [Vite](/nx-api/vite) and Vitest for integrated Nx monorepos
- We introduced an [official Deno plugin](https://youtu.be/NpH8cFSp51E), including integration for Node and Deno project collocation and project graph support for Deno imports
- We added Rust into the Nx codebase to speed up core functionality
- We added support for [non-npm workspaces](https://youtu.be/QOhdL02f6BY) to support workspaces focused on other languages like C#, Java, and Kotlin, and saw some of those in action with community plugins for [.NET](https://www.nx-dotnet.com/) and [Java/Kotlin](https://github.com/tinesoft/nxrocks)
- Introduced [Nx Console for JetBrains IDEs like IntelliJ and WebStorm](https://youtu.be/xUTm6GDqwJM)
- We have [decoupled the Nx version from Angular](https://youtu.be/AQV4WFldwlY) versions allowing you to update Nx without updating Angular

### Table of Contents

· [Here’s how to Upgrade with Nx Migrate](#heres-how-to-upgrade-with-nx-migrate)  
· [Rescoping From @nrwl/_ to @nx/_](#rescoping-from-nrwl-to-nx)  
· [Deno Standalone Apps, Edge Deployment and More](#deno-standalone-apps-edge-deployment-and-more)  
· [Cypress Feature Testing](#cypress-feature-testing)  
· [Task Graph](#task-graph)  
· [The Nx Repo Switches to PNPM for its Package Manager](#the-nx-repo-switches-to-pnpm-for-its-package-manager)  
· [Learn more](#learn-more)

## Here’s how to Upgrade with Nx Migrate

As with all new Nx releases, `nx migrate` can be used to bump your Nx packages to the appropriate version, as well as run any necessary changes to your codebase.

To update to Nx 16, run

```
nx migrate latest
```

This will update your dependencies to the latest version, as well as update those dependencies in your root `package.json` file.

If further migrations are available, you’ll see a `migrations.json` file in the root of your workspace. This file will describe any further code generation scripts that should be run. To run these, use the command..

```
nx migrate --run-migrations
```

…as prompted in the terminal.

After the migrations have been run, you should be able to see them in your source control tools. Ensure that everything is still working properly by running any automated testing you have set up.

Check out this real-world example using the `nx migrate` command for the `Tanstack/query` repo:

{% youtube src="https://youtu.be/X1I1Aw2sV-Y" /%}

Also as a reminder to our Angular users — we’ve now **decoupled the Nx version from Angular versions**, so as long as you’re on an LTS version of Angular, you’re clear to migrate to the latest Nx version without having to touch your Angular version! To do so, be sure to use the `interactive` option (e.g. `nx migrate --interactive`). Check out this video for more info:

{% youtube src="https://youtu.be/AQV4WFldwlY" /%}

## Rescoping From @nrwl/_ to @nx/_

{% youtube src="https://youtu.be/HzkvhPKAepA" /%}

One of the more impactful changes from Nx 16 is that we’ll be changing the npm scope that we publish our packages under from `@nrwl` to `@nx`. In other words, `@nrwl/react` will now be published as `@nx/react`.

Nx will handle this migration automatically via the `nx migrate` command to update your workspaces!

To ensure that community plugins are not broken, the `@nrwl/*` versions of these packages are deprecated but will continue to be published until Nx 17 which is scheduled for October 2023.

## Deno Standalone Apps, Edge Deployment and More

Nx has had support for developing Node-based backends for a while. It was a popular choice for building your BFF in a monorepo-based setup alongside your React or Angular application. [In Nx 15.7](/blog/nx-15-7-node-support-angular-lts-lockfile-pruning) we decided to expand that support and really go deep into improving the overall DX.

**Deno got quite some love** in this iteration:

- Standalone App support — You can now scaffold a new single-project Deno workspace with Nx. Just run `npx create-nx-workspace --preset=@nx/deno`. Probably the fastest way to get up and running with Deno
- We also added Nx generators to set up Deno with [oak](https://oakserver.github.io/oak/). Just pass the `--framework` option when you set up a new Deno app (or use [Nx Console](/getting-started/editor-setup))

It’s all about **Edge functions** recently (and, well, serverless in general). Especially when developing with Node it is common that you might want to deploy to the Edge or some serverless environment. Therefore, we..

- created a brand new `@nx/netlify` package (currently [in labs](https://github.com/nrwl/nx-labs/tree/main/packages/netlify)) which allows you to set up a brand new project for developing and pushing Netlify functions, or you can add serverless deployment support to an existing project, using the `@nx/netlify:setup-serverless` generator. Check out our in-depth recipe on the topic: [/recipes/node/node-serverless-functions-netlify](/recipes/node/node-serverless-functions-netlify)
- published anew `@nx/aws-lambda` for deploying [Lambda functions](https://aws.amazon.com/lambda/) to AWS. All details in our latest recipe: [/recipes/node/node-aws-lambda](/recipes/node/node-aws-lambda)
- Improved our existing Deno package to add support for serverless deployment to both Deno Deploy as well as Netlify. Such support can be added to an existing app using the `@nx/deno:setup-serverless` generator and providing the `--platform` flag that either point to `deno-deploy` or `netlify`.

## Cypress Feature Testing

{% youtube src="https://youtu.be/d5i9_Y8Ip54" /%}

Nx sets up e2e tests for apps that tend to collect many features. This ends up as a large atomic suite that Nx isn’t good at separating out. With Nx 16, we’ve made it easier to distribute these tests closer to the actual feature they test. This will make it much easier for `nx affected` to determine which tests are actually necessary.

I also had the opportunity to have a live stream with Nx’s own Caleb (who lead most of the development for this feature), as well as Cypress’s Jordan Powell who also contributed to this effort — check it out:

{% youtube src="https://youtu.be/y3gFRSqarEo" /%}

## Task Graph

Nx 16.0 also introduces more helpful tools for visualizing your project and task graph as determined by Nx:

{% youtube src="https://youtu.be/9_Y6Mop-Kac" /%}

The task graph in particular is helpful for visualizing what actually runs when you run commands, and with Nx 16.0, you can now use the `--graph` option when running most Nx commands to visualize the graph of tasks that would have run - for example:

```
nx build react --graph
```

The task graph was also highlighted in a recent video demonstrating feature parity between our VsCode and JetBrains plugin:

{% youtube src="https://youtu.be/XCoeNiyM6hw" /%}

## The Nx Repo Switches to PNPM for its Package Manager

Internally, the [Nx repo](https://github.com/nrwl/nx) switched to using `pnpm` as its package manager. Since switching we have noted the following advantages:

- publish is 2x faster
- CI times decreased
- install times decreased

While we are using `pnpm` as our package manager, we are not using the `pnpm` workspaces functionality in the Nx repo, but we've found that Nx actually works extremely well with `pnpm` workspace setups. Juri had released [an article on this topic](/blog/setup-a-monorepo-with-pnpm-workspaces-and-speed-it-up-with-nx) previously, and we used this approach to introduce Task Caching and Distributed Caching (via Nx and Nx Cloud) to [the Tanstack/query repo](https://github.com/TanStack/query), which yielded excellent results:

{% youtube src="https://youtu.be/NvPXK6DVZGE" /%}

## Wrapping up!

That’s about it for Nx 16.0 — we’ve really loved the opportunity to bring you all this cool stuff, and we’re eager to start our next iteration with a steady focus on making Nx an awesome tool for increasing your productivity by taking all the repo management tasks out of the equation so you can focus on shipping great stuff.

### Learn more

- 🧠 [Nx Docs](/getting-started/intro)
- 👩‍💻 [Nx GitHub](https://github.com/nrwl/nx)
- 💬 [Nx Official Discord Server](https://go.nx.dev/community)
- 📹 [Nx Youtube Channel](https://www.youtube.com/@nxdevtools)
- 🚀 [Speed up your CI](/nx-cloud)

### More Nx Release Notes:

- Nx 15.3: [/blog/nx-15-3-standalone-projects-vite-task-graph-and-more-3ed23f7827ed](/blog/nx-15-3-standalone-projects-vite-task-graph-and-more)
- Nx 15.4: [/blog/nx-15-4-vite-4-support-a-new-nx-watch-command-and-more](/blog/nx-15-4-vite-4-support-a-new-nx-watch-command-and-more)
- Nx 15.7: [/blog/nx-15-7-node-support-angular-lts-lockfile-pruning](/blog/nx-15-7-node-support-angular-lts-lockfile-pruning)
- Nx 15.8: [/blog/nx-15-8-rust-hasher-nx-console-for-intellij-deno-node-and-storybook](/blog/nx-15-8-rust-hasher-nx-console-for-intellij-deno-node-and-storybook)
