---
title: 'From Bootstrapped to Venture-Backed: Nx Raises $8.6M'
slug: 'from-bootstrapped-to-venture-backed'
authors: ['Jeff Cross']
cover_image: '/blog/images/2022-11-17/a3eT-mjLsXTiHU5m.png'
tags: [nx]
---

I’m excited to let the Nx Community know about our first round of outside financing, led by [Nexus Venture Partners](https://nexusvp.com/) and [A16z](https://a16z.com/), with several amazing angel investors. We’ve raised a seed round of $8.6M to scale the growth of open source Nx, [Nx Cloud](/nx-cloud), and [Nx Enterprise](/enterprise). With this new capital, we’re able to allocate significantly more resources to rapidly evolving our open source and commercial products to help development teams **ship faster at any scale**.

![](/blog/images/2022-11-17/RYpEUOFtvrtdGwKx3RgGLA.avif)
_Just a few of the companies powered by Nx_

When Victor Savkin and I left Google to start this company in December 2016, we saw a big gap between how enterprises were building software and how companies like Google were building software. So in 2017, we released the first version of our developer toolkit, Nx, which focused on enabling monorepo-style development for large software teams. Nx has continued to evolve and grow in adoption since then, at more than 5x year-over-year in npm downloads to now 12M+ monthly downloads! We’re proud that the world’s top brands depend on Nx to help their development teams iterate faster on critical products.

![](/blog/images/2022-11-17/WIkl00uLsSt6p6dmQbIA0g.avif)

[Nx Cloud](/nx-cloud) has also seen a significant uptake in adoption, thanks in large part due to the addition of [Distributed Task Execution](/ci/concepts/parallelization-distribution) last year. With the combination of Distributed Task Execution and Distributed Caching, Nx Cloud is having a massive impact on the time it takes to validate and merge pull requests, drastically reducing product time-to-market. There are now more than 100k connected Nx Workspaces on nx.app. With Nx Cloud, Nx and Lerna workspaces can drastically reduce build times by letting Nx Cloud manage task cache distribution, and optimal distribution of tasks across many machines using Nx’s deep understanding of project relationships and task timings. We’ve determined that Nx and Nx Cloud have [saved over 250 years of compute time](/blog/helping-the-environment-by-saving-two-centuries-of-compute-time) since we started measuring.

![](/blog/images/2022-11-17/ysWZ8fn2K3m3GjCNGRwshw.avif)

Our most significant commercial innovation in the past year has been [Nx Enterprise](/enterprise), which allows companies to deploy Nx Cloud on their own infrastructure. Some of the world’s leading brands are relying on Nx Enterprise to help their developers get products and features to market significantly faster. One repository powered by Nx Enterprise is saving over 40,000 hours per month of compute time thanks to Distributed Caching and Distributed Task Execution, drastically reducing the time it takes to validate and merge pull requests.

![](/blog/images/2022-11-17/zkOkZXDTZiNB6TAk.avif)
_Monorepo.tools, by Nx in collaboration with other monorepo projects_

With Nx and Lerna under our stewardship, we now maintain [more than 75% of leading JavaScript monorepo tooling](https://npmtrends.com/@bazel/typescript-vs-@microsoft/rush-vs-@nrwl/tao-vs-lerna-vs-turbo). We’re sharing this space with some other great teams, who are all pushing the state of the art forward. We developed the site [monorepo.tools](https://monorepo.tools/) in collaboration with these teams to spread the monorepo love and help developers decide which tool is right for them.

## Why Outside Funding?

Victor Savkin and I originally decided not to raise funding when starting the company, to give ourselves space to experiment with different business models and find product-market fit. We’ve revisited the idea of funding from time to time, but our consulting business has provided more than enough income to sustain the company’s growth. It wasn’t until Nx Cloud and Nx Enterprise started growing at a much more rapid pace that we decided we could provide a lot more value, more quickly to our community and customers by taking on some partners and capital to help us with our next phase of growth.

We couldn’t be more excited to partner with our co-lead investors, [Nexus Venture Partners](https://nexusvp.com/) and [Andreesen Horowitz (a16z)](https://a16z.com/). Both firms have deep expertise in developer tooling and strongly believe in our vision of helping development teams scale. We’re excited to have them bring their own unique talents, experience, and resources to help us execute on that vision. Abhishek Sharma from Nexus has tremendous commercial open source experience, and has been excited about Nx for years. A16z is a powerhouse with an extremely talented enterprise infrastructure team led by Martin Casado and Jennifer Li, alongside amazing partners including, Satish Talluri, and Yoko Li. We’re also excited to be joined by many angels, including Tom Preston-Werner, Matt Biilmann, and several other notable CEOs, founders and technologists.

![](/blog/images/2022-11-17/37ySQYL9U1xF7ezq.avif)
_Most of the Nx team at Nx Conf in Tempe, AZ, October 2022_

We are only scratching the surface of how we can help teams scale their development, and we’re drastically increasing our R&D time to move even faster on new innovations in build performance and team scaling. Fortunately, we already have a world-class team of top engineers who’ve helped us build Nx and Nx Cloud, while also helping our customers succeed with Nx. With this new capital, our engineers are able spend significantly more R&D time building industry-changing products and features, while continuing to work with and learn from our Nx Cloud and Nx Enterprise customers.

We’ll be sharing more exciting announcements soon, so make sure to follow our journey on [@NxDevTools](https://twitter.com/nxdevtools)!

Jeff Cross  
CEO, Nx
