---
title: npm-rebuild
section: 1
description: Rebuild a package
---

### Synopsis

<!-- AUTOGENERATED USAGE DESCRIPTIONS -->

### Description

This command does the following:

1. Execute lifecycle scripts (`preinstall`, `install`, `postinstall`, `prepare`)
2. Links bins depending on whether bin links are enabled

This command is particularly useful in scenarios including but not limited to:

1. Installing a new version of **node.js**, where you need to recompile all your C++ add-ons with the updated binary.
2. Installing with `--ignore-scripts` and `--no-bin-links`, to explicitly choose which packages to build and/or link bins.

If one or more package specs are provided, then only packages with a name and version matching one of the specifiers will be rebuilt.

Usually, you should not need to run `npm rebuild` as it is already done for you as part of npm install (unless you suppressed these steps with `--ignore-scripts` or `--no-bin-links`).

If there is a `binding.gyp` file in the root of your package, then npm will use a default install hook:

```
"scripts": {
    "install": "node-gyp rebuild"
}
```

This default behavior is suppressed if the `package.json` has its own `install` or `preinstall` scripts. It is also suppressed if the package specifies `"gypfile": false`

### Configuration

<!-- AUTOGENERATED CONFIG DESCRIPTIONS -->

### See Also

* [package spec](/using-npm/package-spec)
* [npm install](/commands/npm-install)
