# Kulim Park
Kulim Park is currently undergoing a public consultation process for development direction by the Tauranga City Council as part of a wider strategy to evaluate and improve the cities parks. The current space is in need of redevelopment to better meet the changes in usage patterns, improve play facilities, control flood waters, recognise Ngāi Tamarāwaho's cultural perspectives and values for integration into the park and make better connections between the park space and Te Awanui (Tauranga City Council, 2018).

As a current user of this space with deep family ties to this area I have a vested interest in engaging in this development process to ensure that the space retains it's amenity and desirability as a destination.
The redevelopment of Kulim Park is an opportunity to engage with this process typographically to create an artefact which is both from and is for the space. Like any design project which is seeking to alleviate communication problems this project requires a brief, which as (Phillips, 2012) states is an early definition of the design problem and the possible descriptions of the strategy to solve it.

To arrive at a brief, a series of questions to generally help to elucidate any potential problems. With the outcome defined as a typeface these questions can be focused somewhat. Typographically, what problems does a typeface for and of, Kulim Park need to solve? Will it be a employed primarily on wayfinding signage or pluralistically across a far wider range of communications mediums? What political, economic and social aspects of this site does this typeface need to attempt to incorporate, if any? Should it simply regress to a range of literal illustrative dingbats or abstract itself into the formal norms of traditional typographic expression? Can it integrate into the physical space as an expression of Mahi Toi and become a part of a play space? Should the typeface be serif of sans-serif and what are the legibility ramifications from this choice?

As a designer with a design raison d'être focused on utility, creating a typeface which has the widest range of potential uses is far more attractive as this sees the typeface put to work across a diverse range of outcomes. This approach pushes the typographic response into formally restrained,  traditional typographic expression. Dingbats simply do not have the application reach of a 'standard' typeface such as Helvetica.

Differences in legibility between sans-serif and serif typefaces are not born out by research and it is better to make these decisions based on aesthetics as any well designed typeface will be equally legible (Poole, 2012). Personally, I prefer the formal restraint in sans-serif typefaces. When considering the community aspect of Kulim Park, humanist sans-serif typefaces with their touch of softness, open bowls and shift away from pure geometric forms more closely align with the emotive impression of the space.

Taking a meta view and considering the diverse role parks (papa rēhia) play in communities is useful for unpacking the political, cultural, economic and social aspects of the space and gives insight into which of these aspects are relevant for inclusion as elements for consideration when conceptualising and designing the typefaces glyphs. Generally speaking, parks have a number of benefits for communities, firstly they provide economic value alongside their health and environmental benefits and finally they have social importance. Each is manifested in differing ways. Parks contribute economically to local economies by increasing house values, increasing amenity and hence desirability of locations, decrease stormwater effects and provide coastal buffers. The connection between personal and community health and the landscape is encapsulated in the Biophilia hypothesis by Wilson (Wilson, 1984). Anecdotally this is born out by the continued patronage to park spaces by the public (Blaschke, 2013).

Socially parks provide gathering places, sites for social interaction, open access sites and contribute to a tangible reflection of the quality of life in a community. They provide identity for citizens and are a major factor in the perception of quality of life in a given community (nrpa, 2010). From this precis a conclusion is that parks are beneficial for the communities they support and that any typeface which is from and for this space should also seek to be beneficial. Potentially, this can be achieved in a number of ways. First the typeface should reflect the open access values that parks embody by using the permissive Open Font License (OFL) license. Secondly, the typeface should reflect the diversity of cultures which use Kulim park via its language support. This is especially important when rendering macrons used in Māori.

### Brief
Distilling the above down into a brief for the design of Kulim Park (typeface) the following design goals and approaches are most salient. Categories each falls into a provided alongside.

* Sans-serif (personal design bias)
* Humanist (reflection of accessibility and function of space)
* Highly legible (accessibility, utility)
* Available across a range of weights and styles (utility)
* Open, relaxed design language (reflection of accessibility and function of space)
* Wide language support (accessibility, utility)
* Permissive licence (accessibility, utility)

### Formal Language
Kulim Park is a humanist sans serif typeface, with high x-height, open counter 'a', minimal degrees of contrast in stem width, inviting bowls and a design language aimed at encapsulating openness.

### Bibliography
Blaschke, P. (2013). _Health and wellbeing benefits of conservation in New Zealand (New Zealand, Department of Conservation)_. Wellington, WGTN: Publishing Team, Department of Conservation.

National Recreation and Park Association [NRPA] (2010). _Why Parks and Recreation are Essential Public Services_.  Retrieved from https://www.nrpa.org/uploadedFiles/nrpa.org/Advocacy/Resources/Parks-Recreation-Essential-Public-Services-January-2010.pdf

OpenStreetMap contributors. (n.d.)._OpenStreetMap_. Retrieved from https://www.openstreetmap.org/#map= 17/-37.66460/176.14892

Phillips, P. (2012). _Creating the perfect design brief_ (2nd ed., p. 16). New York: Allworth Press.

Poole, A. (2012). _Which Are More Legible: Serif or Sans Serif Typefaces?_ | Alex Poole. Retrieved from http://alexpoole.info/blog/which-are-more-legible-serif-or-sans-serif-typefaces/
Tauranga City Council. (2018). Have your say on Kulim Park. [online] Available at: https://www.tauranga.govt.nz/community/have-your-say/open-consultations-and-engagements/consultation-details/artmid/1491/articleid/2326.

Wilson, E. O. (1984). _Biophilia_. Harvard University Press.
