# Awesome cryptocurrency security
😎 Curated list about cryptocurrency security. (reverse, exploit, fuzz..)

![alt text](https://blog.ret2.io/assets/img/evm_bytecode.png)

[Image from this Practical ETH decompilation blog](https://blog.ret2.io/2018/05/16/practical-eth-decompilation/) .

## Tools

[Porosity](https://github.com/comaeio/porosity) - Decompiler and Security Analysis tool for Blockchain-based Ethereum Smart-Contracts.

[Mythril](https://github.com/ConsenSys/mythril) - Security analysis tool for Ethereum smart contracts.

[MAIAN](https://github.com/MAIAN-tool/MAIAN) - Automatic tool for finding trace vulnerabilities in Ethereum smart contracts.

[Echidna](https://github.com/trailofbits/echidna) - Ethereum fuzz testing framework.

[Manticore](https://github.com/trailofbits/manticore) - Manticore uses symbolic execution to simulate complex multi-contract and multi-transaction attacks against EVM bytecode.

[Ethersplay](https://github.com/trailofbits/ethersplay) - A graphical EVM disassembler with advanced features. (Binja)

[Oyente](https://github.com/melonproject/oyente) - An automatic EVM code analyzer based on symbolic execution and Z3 SMT solver.

[IDA-EVM](https://github.com/trailofbits/ida-evm) - IDA Processor Module for the Ethereum Virtual Machine.

[Evmdis](https://github.com/arachnid/evmdis) - EVM disassembler.

[Securify](https://securify.ch/) - Formal Verification of Ethereum Smart Contracts.

[Rattle](https://trailofbits.wufoo.com/forms/m1qfujq31qyj9ee/) - Rattle is an EVM static analyzer that analyzes the EVM bytecode directly for vulnerabilities.

[Slither](https://github.com/trailofbits/slither) - Static analysis on Solidity.

[Diligence](https://consensys.net/diligence/) - Security Services, Tools and Best Practices for the Ethereum Ecosystem.

[fuildai](https://fluidai.co/) - Fluid is an AI that can automatically find and fix fatal security vulnerabilities in Smart Contracts.

[vs code](https://diligence.consensys.net/blog/2019/10/solidity-visual-auditor-extension-for-vs-code/) - Solidity Visual Auditor Extension for VS Code

## Blogs

[muellerberndt](https://medium.com/@muellerberndt/practical-smart-contract-security-analysis-and-exploitation-part-1-6c2f2320b0c) - Practical Smart Contract Security Analysis and Exploitation— Part 1

[blackhat](https://cansecwest.com/slides/2018/Blackhat%20Ethereum%20%20Ryan%20Stortz%20and%20Jay%20Little,%20Trail%20of%20Bits,%20Inc.pdf) - Blackhat Ethereum.

[solidified](https://medium.com/solidified/parity-hack-how-it-happened-and-its-aftermath-9bffb2105c0) - Parity hack.

[arvanaghi 1](https://arvanaghi.com/blog/reversing-ethereum-smart-contracts/) - Reversing ethereum smart contracts.

[arvanaghi 2](https://arvanaghi.com/blog/reversing-ethereum-smart-contracts-pt2/) - Reversing ethereum smart contracts 2.

[ret2](https://blog.ret2.io/2018/05/16/practical-eth-decompilation/) - Practical ETH decompilation.

[loom-network](https://medium.com/loom-network/how-to-secure-your-smart-contracts-6-solidity-vulnerabilities-and-how-to-avoid-them-part-1-c33048d4d17d) - 6 vulnerabilities and how to avoid them part 1.

[ETH assembly](https://medium.com/@xJonathan/reverse-engineering-ethereum-smart-contract-lets-talk-assembly-10c38b8e3c2) - Lets talk assembly.

[radare2](https://blog.positive.com/reversing-evm-bytecode-with-radare2-ab77247e5e53) - Reversing EVM bytecode with radare2.

[Etherum security tools](https://blog.trailofbits.com/2018/03/23/use-our-suite-of-ethereum-security-tools/) - Trailofbits Ethereum security tools.

[Hackernoon](https://hackernoon.com/scanning-ethereum-smart-contracts-for-vulnerabilities-b5caefd995df) - Analyzing Ethereum smart contracts for vulnerabilities.

[nccgroup](https://www.nccgroup.trust/us/our-research/discovering-smart-contract-vulnerabilities-with-goatcasino/?style=Cyber+Security) - Discovering Smart Contract Vulnerabilities with GOATCasino.

[Arseny Reutov](https://blog.positive.com/predicting-random-numbers-in-ethereum-smart-contracts-e5358c6b8620) - Predicting Random Numbers in Ethereum Smart Contracts.

[funfair](https://funfair.io/randomness-is-a-big-deal/) - Randomness is a big deal.

## Training

[Ethernaut](https://ethernaut.zeppelin.solutions/level/0x6545df87f57d21cb096a0bfcc53a70464d062512) - The ethernaut is a Web3/Solidity based wargame.

[GOATCasino](https://github.com/nccgroup/GOATCasino) - GOATCasino is a Truffle project which deploys a set of intentionally vulnerable smart contracts.

[ctf challs](https://eth.swampctf.com/) SWAMPCTF

## MISC

[dasp](http://dasp.co/) - Decentralized Application Security Project (or DASP) Top 10 of 2018.

[Not so smart conracts](https://github.com/trailofbits/not-so-smart-contracts) - Examples of Solidity security issues.

[EVM opcodes](https://github.com/trailofbits/evm-opcodes) - Ethereum opcodes and instruction reference.

[mint integer overflow](https://github.com/BlockChainsSecurity/EtherTokens/blob/master/GEMCHAIN/mint%20integer%20overflow.md) mint integer overflow.

[Uninitialized Pointer](https://medium.com/cryptronics/storage-allocation-exploits-in-ethereum-smart-contracts-16c2aa312743) Storage Allocation Exploits in Ethereum Smart Contracts.

## Paper

[Smarter](https://eprint.iacr.org/2016/633.pdf) - Making Smart Contracts Smarter.

[Yellow Paper](https://ethereum.github.io/yellowpaper/paper.pdf) - Ethereum: a secure decentralised generalised transaction ledger. 

## Awesomes

[awesome](https://github.com/sindresorhus/awesome)

[awesome ethereum](https://github.com/btomashvili/awesome-ethereum)

[awesome ethereum virtual  machine](https://github.com/pirapira/awesome-ethereum-virtual-machine)

## Jobs

[Ethercasts](https://jobs.ethercasts.com/)

[Solidified](https://solidified.io/)

[codementor](https://www.codementor.io/solidity-developers)

[iosiro](https://www.iosiro.com/)

[audithor](https://audithor.io)

## Twitter

[@withzombies](https://twitter.com/withzombies)
[@chaignc](https://twitter.com/chaignc)
[@trailofbits](https://twitter.com/trailofbits)

----
By [@chaignc][] [#HexpressoTeam][hexpresso].


[hexpresso]:     https://hexpresso.github.io
[@chaignc]:    https://twitter.com/chaignc
