<div align="center" id="top">
  <h1>Cult Directory Template</h1>
  <p>A full stack nextjs + shadcn + supabase template</p>
</div>

<br/>



<div align="center">
  <img src="https://github.com/Jordan-Gilliam/readme-assets/blob/master/cult-dir-home.png" width="85%" alt="cult-dir-home" />
</div>


<br/>


### Table of contents


<nav>
  <ul style="list-style-type: none; padding: 15px; text-align: center; background-color: #282c34; border-radius: 10px; box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);">
    <li style="display: inline; margin-right: 20px; ">
      <a href="#youtube-onboarding-video" style="text-decoration: none; color: #61dafb; font-weight: bold; font-size: 16px; transition: color 0.3s;"> Onboarding Video</a>
    </li>
    <li style="display: inline; margin-right: 20px; ">
      <a href="#features" style="text-decoration: none; color: #61dafb; font-weight: bold; font-size: 16px; transition: color 0.3s;">Features</a>
    </li>
    <li style="display: inline; margin-right: 20px;">
      <a href="#additional-templates-included-with-paid" style="text-decoration: none; color: #61dafb; font-weight: bold; font-size: 16px; transition: color 0.3s;">Additional Templates</a>
    </li>
    <li style="display: inline; margin-right: 20px;">
      <a href="#supabase" style="text-decoration: none; color: #61dafb; font-weight: bold; font-size: 16px; transition: color 0.3s;">Supabase Setup</a>
    </li>
    <li style="display: inline; margin-right: 20px;">
      <a href="#develop" style="text-decoration: none; color: #61dafb; font-weight: bold; font-size: 16px; transition: color 0.3s;">Develop</a>
    </li>
    <li style="display: inline; margin-right: 20px;">
      <a href="#adding-products-to-the-directory" style="text-decoration: none; color: #61dafb; font-weight: bold; font-size: 16px; transition: color 0.3s;">Adding Products to the Directory</a>
    </li>
    <li style="display: inline; margin-right: 20px;">
      <a href="#admin-setup" style="text-decoration: none; color: #61dafb; font-weight: bold; font-size: 16px; transition: color 0.3s;">Admin Setup</a>
    </li>
    <li style="display: inline; margin-right: 20px;">
      <a href="#accessing-the-admin-dashboard" style="text-decoration: none; color: #61dafb; font-weight: bold; font-size: 16px; transition: color 0.3s;">Accessing the Admin Dashboard</a>
    </li>
    <li style="display: inline; margin-right: 20px;">
      <a href="#customize" style="text-decoration: none; color: #61dafb; font-weight: bold; font-size: 16px; transition: color 0.3s;">Customize</a>
    </li>
    <li style="display: inline; margin-right: 20px;">
      <a href="#deploy" style="text-decoration: none; color: #61dafb; font-weight: bold; font-size: 16px; transition: color 0.3s;">Deploy</a>
    </li>
    <li style="display: inline; margin-right: 20px;">
      <a href="#other-open-source-work" style="text-decoration: none; color: #61dafb; font-weight: bold; font-size: 16px; transition: color 0.3s;">Other Open Source Work</a>
    </li>
  </ul>
</nav>



<div id="youtube-onboarding-video">

<div align="left">
  <h2>YouTube Onboarding Video</h2>
   <h4>This video walks you through how to set up the directory app from scratch. We will:</h4>
  <ul style="text-align: left; display: inline-block;">
    <li>Setup a new Supabase project using the CLI</li>
    <li>Link it to our app</li>
    <li>Setup environment variables</li>
    <li>Run the DB migrations to configure the schema</li>
    <li>Configure authentication</li>
    <li>Register an admin user (Paid)</li>
    <li>Run a 3-stage AI enrichment script to populate our directory (Paid)</li>
    <li>Review the admin panel (Paid)</li>
  </ul>
  <a href="https://youtu.be/zy9Wm9cv8O0">
    <img src="https://github.com/Jordan-Gilliam/readme-assets/blob/master/cult-dir-youtube-preview.png" width="85%" alt="YouTube Onboarding Video" />
  </a>
</div>

</div>


## Features

<div id="features">

<!-- prettier-ignore -->
| Feature | Free Version | Paid Version |
| --- | ------ | --- |
| Next.js v13 | ✅  | ✅ |
| /app Directory | ✅  | ✅ |
| Tailwind CSS   | ✅  | ✅ |
| Shadcn Components   | ✅  | ✅ |
| Vercel AI SDK   | ✅  | ✅ |
| Supabase Integration | ✅  | ✅ |
| Mobile Responsive | ✅  | ✅ |
| Submit Product RSC | ✅  | ✅ |
| Dark & Light Mode | ✅  | ✅ |
| User Authentication | ✅  | ✅ |
| Product Filters | ✅  | ✅ |
| Custom Color Themes | ✅ | ✅ |
| Free Updates | ✅  | ✅  |
| Admin Dashboard | ❌  | ✅ |
| Admin Analytics | ❌  | ✅ |
| Bulk AI Data Enrichment | ❌  | ✅ |
| License | GPL-2.0 | Commercial |
| &nbsp; | &nbsp;| &nbsp;|
| Pricing| Free|**$119**|

<a href="https://newcult.co" style="display: inline-block; padding: 10px 20px; font-size: 18px; color: white; background-color: #333; border-radius: 5px; text-decoration: none; margin-top: 20px;">✨ Join the Cult ✨</a>

### Additional Templates Included with Paid

<div align="center">
  <img src="https://github.com/Jordan-Gilliam/readme-assets/blob/master/newcult-landing.png" alt="newcult.co" width="90%" />
</div>

When you join the cult, you get lifetime access to a variety of other premium templates.

<!-- prettier-ignore -->
| Template | Description | Features | Link |
| --- | --- | --- | --- |
| Travel Stash | Offline-first travel app with real-time sync and PWA support, designed for managing and planning travel goals. | Offline Capabilities, Real-time Sync, PWA Support, Next.js, Tailwind CSS, Claude AI, RXDB Progressive Web App | [Travel Stash](https://www.newcult.co/templates/cult-offline-travel-stash) |
| Cult SEO | Tool for crawling websites, grading SEO, and providing AI-driven improvements. | RSC Web Scraping, Web Vitals, Structured AI output, Next.js, Tailwind CSS, Claude AI | [Cult SEO](https://www.newcult.co/templates/cult-seo) |
| Manifest | Full-stack template for shipping AI apps with vector embeddings and RAG retrieval. | Vector embeddings, RAG retrieval, Supabase, Next.js, Tailwind CSS, Open AI | [Manifest](https://www.newcult.co/templates/manifest) |
| Landing Page | Design subscription landing page. | Animation, Unique navigation, Next.js, Tailwind CSS | [Landing Page](https://www.newcult.co/templates/cult-landing-page) |
| Backend | Various backend templates for different needs. | Various backend solutions and snippets for different use cases. | [Backend](https://www.newcult.co/backend) |

Each of these templates is full designed and production ready like cult-directory. The cult stack is Next.js, Shadcn, Tailwind CSS, Supabase, and the vercel ai sdk.

Designed to help you build and launch well designed startups fast.

</div>

<div id="getting-started">
  
# Getting Started

> Watch the [Onboarding Video](https://youtu.be/zy9Wm9cv8O0) to spin up quickly

 
</div>


<div id="supabase" >
## Supabase

### Install the Supabase CLI

- **Mac:** `brew install supabase/tap/supabase`
- **Windows:**

  ```powershell
  scoop bucket add supabase https://github.com/supabase/scoop-bucket.git
  scoop install supabase
  ```

- **Linux:** `brew install supabase/tap/supabase`
- **NPM/Bun:** `npx supabase <command>`

<br/>



### Create a Supabase project

1. Create a Supabase project at [Supabase Dashboard](https://database.new), or via the CLI:

   ```shell
   npx supabase projects create -i "your-saas-app"
   ```

   Your Org ID can be found in the URL after [selecting an org](https://supabase.com/dashboard/org/_/general).

<br/>

### Link your CLI to the project

2. Link your CLI to the project:

   ```shell
   npx supabase init
   npx supabase link
   ```

   Select the project you just created.

<br/>

### Store Supabase URL & public anon key in `.env.local` for Next.js

3. Store Supabase URL & public anon key in `.env.local` for Next.js:

   ```shell
   NEXT_PUBLIC_SUPABASE_URL=<api-url>
   NEXT_PUBLIC_SUPABASE_ANON_KEY=<anon-key>
   ```

   You can get the project API URL and anonymous key from the [API settings page](https://supabase.com/dashboard/project/_/settings/api).

<br/>

### Setup DB schema

4. Setup DB schema:

   > This will run all of the migrations located in the `supabase/migrations` directory

   ```shell
   supabase db push
   ```

## Ensure your `.env` variables are configured correctly

```bash
cp .env.local.example .env.local
```

```bash
# Example Supabase Config
NEXT_PUBLIC_SUPABASE_URL="https://examplesqnwerasdfaser.supabase.co"
SUPABASE_PROJECT_ID="examplesqnwerasdfaser"
NEXT_PUBLIC_SUPABASE_ANON_KEY="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx.."
```

</div>

## Develop

<div id="develop" >


### Install dependencies and run the Next.js client

In a separate terminal, run the following commands:

```shell
pnpm i
```

```shell
pnpm run dev
```

Open [http://localhost:3000](http://localhost:3000/) in your browser.

#### Recommended Turn off confirm email 
> The default smtp rate limiting for supabase is very low now.


Providers Email - [API settings page](https://supabase.com/dashboard/project/_/auth/providers).

<div align="center">
  <img src="https://github.com/Jordan-Gilliam/readme-assets/blob/master/supabase-auth-email-switch.png" alt="supabase-auth-email-switch.png" width="90%" />
</div>


## Adding Products to the Directory


To add new products to your directory, simply visit the submission page:

[Submit Products](http://localhost:3000/submit)

</div>

### Congratulations!

You now have a fully seeded database with all the data you need to start building your own cult directory.


 <div id="admin-setup">
   
# Admin Setup
> Paid version only




<a href="https://newcult.co" style="display: inline-block; padding: 10px 20px; font-size: 18px; color: white; background-color: #333; border-radius: 5px; text-decoration: none; margin-top: 20px;">✨ Join the Cult ✨</a>




<div align="center">
  
  <img src="https://github.com/Jordan-Gilliam/readme-assets/blob/master/cult-dir-pro-admin-filters.png" alt="cult-dir-pro-admin-filters" width="90%" />
  
</div>
<div align="center">
  
  <img src="https://github.com/Jordan-Gilliam/readme-assets/blob/master/cult-dir-pro-admin-products-2.png" alt="cult-dir-pro-admin-products-2" width="90%" />
  
</div>

<div align="center">
  <img src="https://github.com/Jordan-Gilliam/readme-assets/blob/master/cult-dir-pro-admin-analytics.png" alt="cult-dir-pro-admin-analytics" width="90%" />
</div>



### Sign up with the email you want for your admin account


#### Recommended Turn off confirm email 

> The default smtp rate limiting for supabase is very low now.


- The rate was lowered to 4/hour for the built in SMTP service.
- Too low for production. You need to use your own SMTP service.

Providers Email - [API settings page](https://supabase.com/dashboard/project/_/auth/providers).

<div align="center">
  <img src="https://github.com/Jordan-Gilliam/readme-assets/blob/master/supabase-auth-email-switch.png" alt="supabase-auth-email-switch.png" width="90%" />
</div>

If you need email confirmation follow follow these guides
- [How to Increase Supabase signup rate limit (3000 free emails / mo)](https://medium.com/@techalchimiste/how-to-increase-supabase-signup-rate-limit-3000-emails-mo-261289882cf4)
- [How to configure Supabase to send emails from your domain](https://resend.com/blog/how-to-configure-supabase-to-send-emails-from-your-domain)


[Login](http://localhost:3000/login)



### Copy your newly created users UID


<div align="center">
  <img src="https://github.com/Jordan-Gilliam/readme-assets/blob/master/supabase-admin-user-uid.png" alt="supabase-admin-user-uid" width="90%" />
</div>

Retrieve from the auth users table [API settings page](https://supabase.com/dashboard/project/_/auth/users).

In `.env.local` copy the `SUPABASE_ADMIN_ID` variable and paste it into the SQL Editor.

### Assigning Admin Rights

Go to the SQL Editor in Supabase [API settings page](https://supabase.com/dashboard/project/_/sql/new).

```sql
UPDATE auth.users
SET raw_app_meta_data = jsonb_set(
    coalesce(raw_app_meta_data, '{}'),
    '{claims_admin}',
    'true'::jsonb
)
WHERE id = 'USER_UUID';
```

To assign admin rights to a user, run the following SQL script. Replace `'USER_UUID'` with the same user ID you copied from the auth users table.

### 3-Stage AI Bulk Enrichment Scripts

> The seed script is pretty complex. There are overview docs 0. `supabase/seed/src/README.md`
> And docs for each stage:

1. `supabase/seed/src/stage-1-crawl/readme.md`
2. `supabase/seed/src/stage-2-enrich/readme.md`
3. `supabase/seed/src/stage-3-seed/readme.md`

I've tried to make it as cheap as possible to run. Depending on your API support level you can increase the performance of the scripts by playing with the concurrency and timeout values.

#### Option 1

You need either the `ANTHROPIC_API_KEY` or an `ANTHROPIC_API_KEY` in your `.env.local` file to run `supabase/seed/src/stage-2-enrich`.

1. If you have an API key, copy it to your `.env.local` file.
2. Optionally edit the `SEED_URLS` variable in `supabase/seed/src/main.ts` to include the URLs you want to scrape and enrich.
3. Run the script:

   ```shell
   pnpm run enrich-seed
   ```

#### Option 2

If you don't have an API key, I've included a pre-enriched data set of a previous run. You can see this in `supabase/seed/src/stage-2-enrich/__data__/enriched-20240611T210738.json`.

To use this data set instead of enriching using your keys:

1. Open the file at `supabase/seed/src/main.ts`.
2. Comment out lines `104 - 110`:

   ```ts
   // console.log("Step 1: Crawl and save raw data")
   // await crawlAndSave(SEED_URLS)
   // console.log("Step 1 completed successfully")

   // console.log("Step 2: Enrich the latest raw data")
   // await enrichLatestData()
   // console.log("Step 2 completed successfully")
   ```

3. Run the script:

   ```shell
   pnpm run enrich-seed
   ```

</div>

## Accessing the Admin Dashboard

<div id="accessing-the-admin-dashboard" >


Manage the content and users of your directory through the admin dashboard. Access it here:

[Admin Dashboard](http://localhost:3000/admin)


</div>

## Customize

<div id="customize" />

### Custom Color Theme

To give your directory a unique look, create a custom color theme:

1. **Design Your Theme**

   Visit the [custom shadcn theme](https://www.cult-ui.com/themes) page to design your theme.

2. **Apply Your Theme**

   Once you have your theme, copy the relevant CSS and paste it into your `app/globals.css` file, replacing lines 5-67.



## Deploy

<div id="deploy">

1. **Create a new repository and push the project to GitHub.**

2. **Go to Vercel and import the GitHub repository: [Deploy](https://vercel.com/new).**

3. **Set up Environment Variables in Vercel**

   Go to your project settings on Vercel and set up the environment variables by copying the content from your `.env.local` file. Ensure the following variables are included:

   - `NEXT_PUBLIC_SUPABASE_URL` - Your Supabase API URL
   - `NEXT_PUBLIC_SUPABASE_ANON_KEY` - Your Supabase anonymous key
   - `SUPABASE_PROJECT_ID` - Your Supabase project ID
   - `SUPABASE_ADMIN_ID` - Admin user ID for your application
   - Any other environment variables specific to your project setup

   Here's an example of what your environment variables might look like:

   ```plaintext
   NEXT_PUBLIC_SUPABASE_URL="https://abcd1234.supabase.co"
   NEXT_PUBLIC_SUPABASE_ANON_KEY="eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9..."
   SUPABASE_PROJECT_ID="abcd1234"
   SUPABASE_ADMIN_ID="efgh5678"
   ```

4. **Deploy the Project**

   Once your environment variables are set, you can deploy your project. Vercel will handle the build and deployment process for you.

5. **Access Your Live Application**

   After deployment, you can access your live application through the URL provided by Vercel. Your application should now be live and ready to use.

</div>

## Conclusion

Welcome to the cult! :)

Follow the steps outlined in this README to deploy and customize your directory app. If you have any questions or run into issues, feel free to reach out for support on Twitter: [https://x.com/nolansym](https://x.com/nolansym)

Cheers! Stoked to see what you build!


## Other Open Source Work

<div id="other-open-source-work" >

Other Free Goods

<div align="center">
  <img src="https://github.com/Jordan-Gilliam/readme-assets/blob/master/cult-ui.png" alt="newcult.co" width="90%" />
  
</div>

### Cult UI

[Cult UI](https://github.com/nolly-studio/cult-ui) is a collection of beautifully designed React components built with Radix UI and Tailwind CSS. These components are optimized for ease of use and integration, making it simple to create visually appealing and functional web applications.

- **Repository**: [nolly-studio/cult-ui](https://github.com/nolly-studio/cult-ui)
- **Features**:
  - Radix UI components
  - Tailwind CSS styling
  - Ready-to-use and customizable
  - Open Source and free to use

### AI Template

[AI Template](https://github.com/Jordan-Gilliam/ai-template) is a full-stack template designed for building AI-powered applications. It leverages Next.js, Tailwind CSS, Supabase, and OpenAI to provide a robust foundation for developing sophisticated AI solutions.

- **Repository**: [Jordan-Gilliam/ai-template](https://github.com/Jordan-Gilliam/ai-template)
- **Features**:
  - Next.js framework
  - Tailwind CSS for styling
  - Supabase for backend and database management
  - Integration with OpenAI for advanced AI capabilities

</div>

<a href="#top" style="text-decoration: none; color: #007bff; font-weight: bold;">Scroll to top</a>