"""empty message

Revision ID: c266818dcfa1
Revises: 116f0f6e8f91
Create Date: 2019-03-25 20:31:35.838601

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "c266818dcfa1"
down_revision = "116f0f6e8f91"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "users_workspaces",
        sa.Column("user_id", sa.Integer(), nullable=False),
        sa.Column("workspace_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(["user_id"], ["users.id"]),
        sa.ForeignKeyConstraint(["workspace_id"], ["workspaces.id"]),
        sa.PrimaryKeyConstraint("user_id", "workspace_id"),
    )
    op.add_column("models", sa.Column("project_id", sa.Integer(), nullable=False))
    op.add_column("models", sa.Column("user_id", sa.Integer(), nullable=False))
    op.create_foreign_key(None, "models", "projects", ["project_id"], ["id"])
    op.create_foreign_key(None, "models", "users", ["user_id"], ["id"])
    op.add_column("projects", sa.Column("description", sa.Text(), nullable=True))
    op.add_column("projects", sa.Column("name", sa.String(length=40), nullable=False))
    op.add_column("projects", sa.Column("workspace_id", sa.Integer(), nullable=False))
    op.create_foreign_key(None, "projects", "workspaces", ["workspace_id"], ["id"])
    op.add_column("users", sa.Column("email", sa.String(length=128), nullable=True))
    op.add_column("users", sa.Column("full_name", sa.String(length=40), nullable=True))
    op.add_column("users", sa.Column("login", sa.String(length=20), nullable=False))
    op.add_column("users", sa.Column("password", sa.String(), nullable=False))
    op.create_unique_constraint(None, "users", ["email"])
    op.create_unique_constraint(None, "users", ["login"])
    op.add_column("workspaces", sa.Column("description", sa.Text(), nullable=True))
    op.add_column("workspaces", sa.Column("name", sa.String(length=40), nullable=False))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("workspaces", "name")
    op.drop_column("workspaces", "description")
    op.drop_constraint(None, "users", type_="unique")
    op.drop_constraint(None, "users", type_="unique")
    op.drop_column("users", "password")
    op.drop_column("users", "login")
    op.drop_column("users", "full_name")
    op.drop_column("users", "email")
    op.drop_constraint(None, "projects", type_="foreignkey")
    op.drop_column("projects", "workspace_id")
    op.drop_column("projects", "name")
    op.drop_column("projects", "description")
    op.drop_constraint(None, "models", type_="foreignkey")
    op.drop_constraint(None, "models", type_="foreignkey")
    op.drop_column("models", "user_id")
    op.drop_column("models", "project_id")
    op.drop_table("users_workspaces")
    # ### end Alembic commands ###
