"""Add metrics to base model entry

Revision ID: 75933cf6bdb9
Revises: c266818dcfa1
Create Date: 2019-03-27 17:35:05.894919

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "75933cf6bdb9"
down_revision = "c266818dcfa1"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "models",
        sa.Column("metrics", postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    )
    op.create_index(
        "ix_model_metrics", "models", ["metrics"], unique=False, postgresql_using="gin"
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_model_metrics", table_name="models")
    op.drop_column("models", "metrics")
    # ### end Alembic commands ###
