## FontBakery report

fontbakery version: 0.10.2

<details><summary><b>[6] Formera-Regular.ttf</b></summary><div><details><summary>🔥 <b>FAIL:</b> Do we have the latest version of FontBakery installed? (<a href="https://font-bakery.readthedocs.io/en/stable/fontbakery/profiles/universal.html#com.google.fonts/check/fontbakery_version">com.google.fonts/check/fontbakery_version</a>)</summary><div>


* 🔥 **FAIL** Current FontBakery version is 0.10.2, while a newer 0.11.2 is already available. Please upgrade it with 'pip install -U fontbakery' [code: outdated-fontbakery]
</div></details><details><summary>⚠ <b>WARN:</b> Check for codepoints not covered by METADATA subsets. (<a href="https://font-bakery.readthedocs.io/en/stable/fontbakery/profiles/googlefonts.html#com.google.fonts/check/metadata/unreachable_subsetting">com.google.fonts/check/metadata/unreachable_subsetting</a>)</summary><div>


* ⚠ **WARN** The following codepoints supported by the font are not covered by
    any subsets defined in the font's metadata file, and will never
    be served. You can solve this by either manually adding additional
    subset declarations to METADATA.pb, or by editing the glyphset
    definitions.

 * U+02BD MODIFIER LETTER REVERSED COMMA: not included in any glyphset definition
 * U+02BE MODIFIER LETTER RIGHT HALF RING: not included in any glyphset definition
 * U+02BF MODIFIER LETTER LEFT HALF RING: not included in any glyphset definition
 * U+02C7 CARON: try adding one of: yi, canadian-aboriginal, tifinagh
 * U+02C8 MODIFIER LETTER VERTICAL LINE: not included in any glyphset definition
 * U+02CA MODIFIER LETTER ACUTE ACCENT: not included in any glyphset definition
 * U+02CB MODIFIER LETTER GRAVE ACCENT: not included in any glyphset definition
 * U+02CC MODIFIER LETTER LOW VERTICAL LINE: not included in any glyphset definition
 * U+02D8 BREVE: try adding one of: yi, canadian-aboriginal
 * U+02D9 DOT ABOVE: try adding one of: yi, canadian-aboriginal
 * U+02DB OGONEK: try adding one of: yi, canadian-aboriginal
 * U+02DD DOUBLE ACUTE ACCENT: not included in any glyphset definition
 * U+0302 COMBINING CIRCUMFLEX ACCENT: try adding one of: cherokee, math, coptic, tifinagh
 * U+0306 COMBINING BREVE: try adding one of: old-permic, tifinagh
 * U+0307 COMBINING DOT ABOVE: try adding one of: old-permic, math, malayalam, syriac, coptic, tifinagh, tai-le, canadian-aboriginal
 * U+030A COMBINING RING ABOVE: try adding syriac
 * U+030B COMBINING DOUBLE ACUTE ACCENT: try adding one of: cherokee, osage
 * U+030C COMBINING CARON: try adding one of: cherokee, tai-le
 * U+0312 COMBINING TURNED COMMA ABOVE: not included in any glyphset definition
 * U+0326 COMBINING COMMA BELOW: not included in any glyphset definition
 * U+0327 COMBINING CEDILLA: not included in any glyphset definition
 * U+0328 COMBINING OGONEK: not included in any glyphset definition
 * U+032E COMBINING BREVE BELOW: try adding syriac
 * U+0330 COMBINING TILDE BELOW: try adding one of: cherokee, syriac, math
 * U+0331 COMBINING MACRON BELOW: try adding one of: caucasian-albanian, syriac, tifinagh, cherokee, gothic
 * U+0394 GREEK CAPITAL LETTER DELTA: try adding one of: math, greek, elbasan
 * U+03A9 GREEK CAPITAL LETTER OMEGA: try adding one of: math, greek, elbasan
 * U+03BC GREEK SMALL LETTER MU: try adding one of: math, greek
 * U+03C0 GREEK SMALL LETTER PI: try adding one of: yi, math, greek
 * U+1EA0 LATIN CAPITAL LETTER A WITH DOT BELOW: try adding vietnamese
 * U+1EA1 LATIN SMALL LETTER A WITH DOT BELOW: try adding vietnamese
 * U+1EB8 LATIN CAPITAL LETTER E WITH DOT BELOW: try adding vietnamese
 * U+1EB9 LATIN SMALL LETTER E WITH DOT BELOW: try adding vietnamese
 * U+1EBC LATIN CAPITAL LETTER E WITH TILDE: try adding vietnamese
 * U+1EBD LATIN SMALL LETTER E WITH TILDE: try adding vietnamese
 * U+1ECA LATIN CAPITAL LETTER I WITH DOT BELOW: try adding vietnamese
 * U+1ECB LATIN SMALL LETTER I WITH DOT BELOW: try adding vietnamese
 * U+1ECC LATIN CAPITAL LETTER O WITH DOT BELOW: try adding vietnamese
 * U+1ECD LATIN SMALL LETTER O WITH DOT BELOW: try adding vietnamese
 * U+1EE4 LATIN CAPITAL LETTER U WITH DOT BELOW: try adding vietnamese
 * U+1EE5 LATIN SMALL LETTER U WITH DOT BELOW: try adding vietnamese
 * U+2007 FIGURE SPACE: not included in any glyphset definition
 * U+2008 PUNCTUATION SPACE: not included in any glyphset definition
 * U+200A HAIR SPACE: not included in any glyphset definition
 * U+2010 HYPHEN: try adding one of: yi, kaithi, kharoshthi, cham, kayah-li, coptic, syloti-nagri, sundanese, sora-sompeng, lisu
 * U+2012 FIGURE DASH: not included in any glyphset definition
 * U+2015 HORIZONTAL BAR: try adding adlam
 * U+2021 DOUBLE DAGGER: try adding adlam
 * U+2030 PER MILLE SIGN: try adding adlam
 * U+2070 SUPERSCRIPT ZERO: not included in any glyphset definition
 * U+2075 SUPERSCRIPT FIVE: not included in any glyphset definition
 * U+2076 SUPERSCRIPT SIX: not included in any glyphset definition
 * U+2077 SUPERSCRIPT SEVEN: not included in any glyphset definition
 * U+2078 SUPERSCRIPT EIGHT: not included in any glyphset definition
 * U+2079 SUPERSCRIPT NINE: not included in any glyphset definition
 * U+2080 SUBSCRIPT ZERO: not included in any glyphset definition
 * U+2081 SUBSCRIPT ONE: not included in any glyphset definition
 * U+2082 SUBSCRIPT TWO: not included in any glyphset definition
 * U+2083 SUBSCRIPT THREE: not included in any glyphset definition
 * U+2084 SUBSCRIPT FOUR: not included in any glyphset definition
 * U+2085 SUBSCRIPT FIVE: not included in any glyphset definition
 * U+2086 SUBSCRIPT SIX: not included in any glyphset definition
 * U+2087 SUBSCRIPT SEVEN: not included in any glyphset definition
 * U+2088 SUBSCRIPT EIGHT: not included in any glyphset definition
 * U+2089 SUBSCRIPT NINE: not included in any glyphset definition
 * U+2105 CARE OF: not included in any glyphset definition
 * U+2106 CADA UNA: not included in any glyphset definition
 * U+2116 NUMERO SIGN: try adding cyrillic
 * U+2126 OHM SIGN: not included in any glyphset definition
 * U+212E ESTIMATED SYMBOL: not included in any glyphset definition
 * U+21E7 UPWARDS WHITE ARROW: try adding symbols
 * U+2202 PARTIAL DIFFERENTIAL: try adding math
 * U+2205 EMPTY SET: try adding math
 * U+2206 INCREMENT: try adding math
 * U+220F N-ARY PRODUCT: try adding math
 * U+2211 N-ARY SUMMATION: try adding math
 * U+2219 BULLET OPERATOR: try adding one of: tai-tham, symbols, math, yi
 * U+221A SQUARE ROOT: try adding math
 * U+221E INFINITY: try adding math
 * U+222B INTEGRAL: try adding math
 * U+2248 ALMOST EQUAL TO: try adding math
 * U+2260 NOT EQUAL TO: try adding math
 * U+2264 LESS-THAN OR EQUAL TO: try adding math
 * U+2265 GREATER-THAN OR EQUAL TO: try adding math
 * U+2317 VIEWDATA SQUARE: try adding symbols
 * U+2318 PLACE OF INTEREST SIGN: try adding symbols
 * U+2325 OPTION KEY: try adding symbols
 * U+25A0 BLACK SQUARE: try adding symbols
 * U+25A1 WHITE SQUARE: try adding symbols
 * U+25B2 BLACK UP-POINTING TRIANGLE: try adding symbols
 * U+25B3 WHITE UP-POINTING TRIANGLE: try adding one of: symbols, math
 * U+25B6 BLACK RIGHT-POINTING TRIANGLE: try adding symbols
 * U+25B7 WHITE RIGHT-POINTING TRIANGLE: try adding one of: symbols, math
 * U+25BC BLACK DOWN-POINTING TRIANGLE: try adding symbols
 * U+25BD WHITE DOWN-POINTING TRIANGLE: try adding one of: symbols, math
 * U+25C0 BLACK LEFT-POINTING TRIANGLE: try adding symbols
 * U+25C1 WHITE LEFT-POINTING TRIANGLE: try adding one of: symbols, math
 * U+25C6 BLACK DIAMOND: try adding symbols
 * U+25C7 WHITE DIAMOND: try adding symbols
 * U+25CA LOZENGE: try adding one of: symbols, math
 * U+25CB WHITE CIRCLE: try adding symbols
 * U+25CC DOTTED CIRCLE: try adding one of: caucasian-albanian, wancho, khojki, hebrew, bassa-vah, new-tai-lue, syloti-nagri, buginese, sundanese, balinese, tai-viet, mandaic, adlam, osage, tagbanwa, kayah-li, gujarati, lao, masaram-gondi, sogdian, ahom, yi, cham, malayalam, lepcha, oriya, old-permic, tamil, tifinagh, tirhuta, khudawadi, psalter-pahlavi, pahawh-hmong, thaana, bengali, sinhala, brahmi, duployan, math, tibetan, phags-pa, grantha, music, gunjala-gondi, tai-le, elbasan, batak, soyombo, buhid, mende-kikakui, meetei-mayek, manichaean, kharoshthi, thai, syriac, gurmukhi, mahajani, takri, siddham, rejang, mongolian, sharada, modi, marchen, coptic, javanese, devanagari, khmer, zanabazar-square, dogra, myanmar, kaithi, newa, miao, symbols, nko, hanifi-rohingya, kannada, telugu, bhaiksuki, tagalog, hanunoo, limbu, chakma
 * U+25CF BLACK CIRCLE: try adding symbols
 * U+2B1B BLACK LARGE SQUARE: try adding symbols
 * U+2B1C WHITE LARGE SQUARE: try adding symbols
 * U+2B98 THREE-D TOP-LIGHTED LEFTWARDS EQUILATERAL ARROWHEAD: try adding symbols
 * U+2B99 THREE-D RIGHT-LIGHTED UPWARDS EQUILATERAL ARROWHEAD: try adding symbols
 * U+2B9A THREE-D TOP-LIGHTED RIGHTWARDS EQUILATERAL ARROWHEAD: try adding symbols
 * U+2B9B THREE-D LEFT-LIGHTED DOWNWARDS EQUILATERAL ARROWHEAD: try adding symbols
 * U+2B9C BLACK LEFTWARDS EQUILATERAL ARROWHEAD: try adding symbols
 * U+2B9D BLACK UPWARDS EQUILATERAL ARROWHEAD: try adding symbols
 * U+2B9E BLACK RIGHTWARDS EQUILATERAL ARROWHEAD: try adding symbols
 * U+2B9F BLACK DOWNWARDS EQUILATERAL ARROWHEAD: try adding symbols
 * U+E133 : not included in any glyphset definition
 * U+E134 : not included in any glyphset definition
 * U+FB00 LATIN SMALL LIGATURE FF: not included in any glyphset definition
 * U+FB01 LATIN SMALL LIGATURE FI: not included in any glyphset definition
 * U+FB02 LATIN SMALL LIGATURE FL: not included in any glyphset definition
 * U+FB03 LATIN SMALL LIGATURE FFI: not included in any glyphset definition
 * U+FB04 LATIN SMALL LIGATURE FFL: not included in any glyphset definition

Or you can add the above codepoints to one of the subsets supported by the font: `latin`, `latin-ext` [code: unreachable-subsetting]
</div></details><details><summary>⚠ <b>WARN:</b> Is there kerning info for non-ligated sequences? (<a href="https://font-bakery.readthedocs.io/en/stable/fontbakery/profiles/googlefonts.html#com.google.fonts/check/kerning_for_non_ligated_sequences">com.google.fonts/check/kerning_for_non_ligated_sequences</a>)</summary><div>


* ⚠ **WARN** GPOS table lacks kerning info for the following non-ligated sequences:

	- f + f

	- f + i

	- i + f

	- f + l

	- l + f

	- i + l [code: lacks-kern-info]
</div></details><details><summary>⚠ <b>WARN:</b> Ensure fonts have ScriptLangTags declared on the 'meta' table. (<a href="https://font-bakery.readthedocs.io/en/stable/fontbakery/profiles/googlefonts.html#com.google.fonts/check/meta/script_lang_tags">com.google.fonts/check/meta/script_lang_tags</a>)</summary><div>


* ⚠ **WARN** This font file does not have a 'meta' table. [code: lacks-meta-table]
</div></details><details><summary>⚠ <b>WARN:</b> Check if each glyph has the recommended amount of contours. (<a href="https://font-bakery.readthedocs.io/en/stable/fontbakery/profiles/universal.html#com.google.fonts/check/contour_count">com.google.fonts/check/contour_count</a>)</summary><div>


* ⚠ **WARN** This check inspects the glyph outlines and detects the total number of contours in each of them. The expected values are infered from the typical ammounts of contours observed in a large collection of reference font families. The divergences listed below may simply indicate a significantly different design on some of your glyphs. On the other hand, some of these may flag actual bugs in the font such as glyphs mapped to an incorrect codepoint. Please consider reviewing the design and codepoint assignment of these to make sure they are correct.

The following glyphs do not have the recommended number of contours:

	- Glyph name: r	Contours detected: 2	Expected: 1

	- Glyph name: plusminus	Contours detected: 3	Expected: 1 or 2

	- Glyph name: Thorn	Contours detected: 3	Expected: 1 or 2

	- Glyph name: ae	Contours detected: 2	Expected: 3

	- Glyph name: aogonek	Contours detected: 3	Expected: 2

	- Glyph name: dcroat	Contours detected: 3	Expected: 2

	- Glyph name: eogonek	Contours detected: 3	Expected: 2

	- Glyph name: hbar	Contours detected: 2	Expected: 1

	- Glyph name: racute	Contours detected: 3	Expected: 2

	- Glyph name: uni0157	Contours detected: 3	Expected: 2

	- Glyph name: rcaron	Contours detected: 3	Expected: 2

	- Glyph name: Tbar	Contours detected: 2	Expected: 1

	- Glyph name: tbar	Contours detected: 2	Expected: 1

	- Glyph name: Uogonek	Contours detected: 2	Expected: 1

	- Glyph name: uogonek	Contours detected: 2	Expected: 1

	- Glyph name: uni01EA	Contours detected: 3	Expected: 2

	- Glyph name: uni01EB	Contours detected: 3	Expected: 2

	- Glyph name: aeacute	Contours detected: 3	Expected: 4

	- Glyph name: uni1E08	Contours detected: 3	Expected: 2

	- Glyph name: uni1E09	Contours detected: 3	Expected: 2

	- Glyph name: uni1E1C	Contours detected: 3	Expected: 2

	- Glyph name: uni1E1D	Contours detected: 4	Expected: 3

	- Glyph name: uni1E5B	Contours detected: 3	Expected: 2

	- Glyph name: rmacronbelow	Contours detected: 3	Expected: 2

	- Glyph name: Tbar	Contours detected: 2	Expected: 1

	- Glyph name: Thorn	Contours detected: 3	Expected: 1 or 2

	- Glyph name: Uogonek	Contours detected: 2	Expected: 1

	- Glyph name: ae	Contours detected: 2	Expected: 3

	- Glyph name: aeacute	Contours detected: 3	Expected: 4

	- Glyph name: aogonek	Contours detected: 3	Expected: 2

	- Glyph name: dcroat	Contours detected: 3	Expected: 2

	- Glyph name: eogonek	Contours detected: 3	Expected: 2

	- Glyph name: hbar	Contours detected: 2	Expected: 1

	- Glyph name: plusminus	Contours detected: 3	Expected: 1 or 2

	- Glyph name: r	Contours detected: 2	Expected: 1

	- Glyph name: racute	Contours detected: 3	Expected: 2

	- Glyph name: rcaron	Contours detected: 3	Expected: 2

	- Glyph name: tbar	Contours detected: 2	Expected: 1

	- Glyph name: uni0157	Contours detected: 3	Expected: 2

	- Glyph name: uni1E08	Contours detected: 3	Expected: 2

	- Glyph name: uni1E09	Contours detected: 3	Expected: 2

	- Glyph name: uni1E1C	Contours detected: 3	Expected: 2

	- Glyph name: uni1E1D	Contours detected: 4	Expected: 3

	- Glyph name: uni1E5B	Contours detected: 3	Expected: 2

	- Glyph name: uogonek	Contours detected: 2	Expected: 1
 [code: contour-count]
</div></details><details><summary>⚠ <b>WARN:</b> Do outlines contain any jaggy segments? (<a href="https://font-bakery.readthedocs.io/en/stable/fontbakery/profiles/<Section: Outline Correctness Checks>.html#com.google.fonts/check/outline_jaggy_segments">com.google.fonts/check/outline_jaggy_segments</a>)</summary><div>


* ⚠ **WARN** The following glyphs have jaggy segments:

	* Eng (U+014A): B<<540.0,-155.0>-<557.0,-159.0>-<556.0,-160.0>>/L<<556.0,-160.0>--<573.0,-147.0>> = 7.594643368591447

	* ampersand (U+0026): L<<276.0,448.0>--<275.0,447.0>>/L<<275.0,447.0>--<286.0,457.0>> = 2.726310993906212

	* ampersand (U+0026): L<<398.0,516.0>--<397.0,507.0>>/L<<397.0,507.0>--<397.0,510.0>> = 6.340191745909908

	* copyright (U+00A9): B<<594.0,190.0>-<596.0,193.0>-<596.0,192.0>>/B<<596.0,192.0>-<598.0,200.0>-<599.0,200.0>> = 14.036243467926484

	* copyright (U+00A9): L<<224.0,445.0>--<242.0,461.0>>/L<<242.0,461.0>--<241.0,460.0>> = 3.3664606634298315

	* copyright (U+00A9): L<<242.0,461.0>--<241.0,460.0>>/L<<241.0,460.0>--<249.0,466.0>> = 8.13010235415596

	* copyright (U+00A9): L<<363.0,588.0>--<366.0,588.0>>/L<<366.0,588.0>--<338.0,589.0>> = 2.0454084888871935

	* copyright (U+00A9): L<<373.0,587.0>--<363.0,588.0>>/L<<363.0,588.0>--<366.0,588.0>> = 5.710593137499633

	* copyright (U+00A9): L<<554.0,59.0>--<557.0,62.0>>/L<<557.0,62.0>--<535.0,47.0>> = 10.713123022791033

	* copyright (U+00A9): L<<574.0,77.0>--<554.0,59.0>>/L<<554.0,59.0>--<557.0,62.0>> = 3.012787504183286

	* currency (U+00A4): L<<298.0,562.0>--<321.0,560.0>>/L<<321.0,560.0>--<320.0,560.0>> = 4.969740728110289

	* currency (U+00A4): L<<321.0,560.0>--<320.0,560.0>>/L<<320.0,560.0>--<344.0,554.0>> = 14.036243467926484

	* currency (U+00A4): L<<55.0,360.0>--<58.0,382.0>>/L<<58.0,382.0>--<58.0,381.0>> = 7.765166018425308

	* currency (U+00A4): L<<58.0,382.0>--<58.0,381.0>>/L<<58.0,381.0>--<64.0,405.0>> = 14.036243467926484

	* estimated (U+212E): B<<406.0,677.5>-<409.0,677.0>-<408.0,677.0>>/L<<408.0,677.0>--<416.0,675.0>> = 14.036243467926484

	* estimated (U+212E): B<<469.0,95.0>-<472.0,96.0>-<471.0,95.0>>/L<<471.0,95.0>--<494.0,111.0>> = 10.175510843043194

	* estimated (U+212E): L<<305.0,-18.0>--<308.0,-18.0>>/L<<308.0,-18.0>--<281.0,-15.0>> = 6.340191745909908

	* estimated (U+212E): L<<312.0,-19.0>--<305.0,-18.0>>/L<<305.0,-18.0>--<308.0,-18.0>> = 8.13010235415596

	* greater (U+003E): B<<195.5,391.5>-<187.0,395.0>-<188.0,395.0>>/B<<188.0,395.0>-<177.0,397.0>-<177.0,400.0>> = 10.304846468766044

	* infinity (U+221E): L<<357.0,419.0>--<376.0,435.0>>/L<<376.0,435.0>--<375.0,434.0>> = 4.899092453787774

	* infinity (U+221E): L<<376.0,435.0>--<375.0,434.0>>/L<<375.0,434.0>--<387.0,443.0>> = 8.13010235415596

	* less (U+003C): B<<298.0,400.0>-<298.0,397.0>-<287.0,395.0>>/B<<287.0,395.0>-<288.0,395.0>-<279.5,391.5>> = 10.304846468766044

	* logicalnot (U+00AC): B<<382.0,-2.0>-<376.0,-1.0>-<377.0,0.0>>/L<<377.0,0.0>--<374.0,-2.0>> = 11.309932474020195

	* multiply (U+00D7): L<<254.0,377.0>--<267.0,393.0>>/L<<267.0,393.0>--<266.0,392.0>> = 5.906141113770435

	* multiply (U+00D7): L<<267.0,393.0>--<266.0,392.0>>/B<<266.0,392.0>-<270.0,397.0>-<273.0,400.0>> = 6.340191745909908

	* numbersign (U+0023): B<<333.0,122.0>-<333.0,124.0>-<334.0,124.0>>/B<<334.0,124.0>-<302.0,123.0>-<278.5,122.5>> = 1.789910608246076

	* paragraph (U+00B6): B<<285.0,576.0>-<277.0,574.0>-<277.0,578.0>>/L<<277.0,578.0>--<275.0,570.0>> = 14.036243467926484

	* paragraph (U+00B6): L<<366.0,557.0>--<366.0,556.0>>/B<<366.0,556.0>-<365.0,564.0>-<367.0,566.0>> = 7.125016348901757

	* paragraph (U+00B6): L<<367.0,546.0>--<366.0,557.0>>/L<<366.0,557.0>--<366.0,556.0>> = 5.1944289077348

	* partialdiff (U+2202): B<<214.0,55.0>-<217.0,54.0>-<216.0,54.0>>/L<<216.0,54.0>--<238.0,50.0>> = 10.304846468766044

	* partialdiff (U+2202): L<<111.0,638.0>--<145.0,632.0>>/L<<145.0,632.0>--<144.0,632.0>> = 10.00797980144135

	* partialdiff (U+2202): L<<145.0,632.0>--<144.0,632.0>>/B<<144.0,632.0>-<152.0,631.0>-<157.0,629.5>> = 7.125016348901757

	* percent (U+0025): L<<592.0,23.0>--<595.0,26.0>>/L<<595.0,26.0>--<573.0,10.0>> = 8.972626614896399

	* percent (U+0025): L<<599.0,29.0>--<592.0,23.0>>/L<<592.0,23.0>--<595.0,26.0>> = 4.398705354995591

	* perthousand (U+2030): B<<530.0,53.0>-<544.0,58.0>-<543.0,57.0>>/L<<543.0,57.0>--<551.0,64.0>> = 3.814074834290187

	* plusminus (U+00B1): L<<273.0,187.0>--<272.0,162.0>>/B<<272.0,162.0>-<272.0,165.0>-<248.0,165.0>> = 2.2906100426384346

	* plusminus (U+00B1): L<<29.0,326.0>--<29.0,325.0>>/B<<29.0,325.0>-<28.0,337.0>-<30.0,337.0>> = 4.763641690726143

	* plusminus (U+00B1): L<<29.0,370.0>--<31.0,391.0>>/B<<31.0,391.0>-<31.0,390.0>-<43.0,391.0>> = 5.4403320310054815

	* prime (U+2032): L<<41.0,572.0>--<44.0,596.0>>/L<<44.0,596.0>--<44.0,595.0>> = 7.1250163489018075

	* prime (U+2032): L<<44.0,596.0>--<44.0,595.0>>/L<<44.0,595.0>--<45.0,617.0>> = 2.6025622024998034

	* product (U+220F): L<<244.0,-217.0>--<243.0,-240.0>>/B<<243.0,-240.0>-<243.0,-237.0>-<219.0,-237.0>> = 2.4895529219991284

	* product (U+220F): L<<27.0,-238.0>--<19.0,-237.0>>/L<<19.0,-237.0>--<22.0,-237.0>> = 7.125016348901757

	* product (U+220F): L<<391.0,-196.0>--<394.0,-174.0>>/B<<394.0,-174.0>-<394.0,-175.0>-<416.0,-175.0>> = 7.765166018425308

	* product (U+220F): L<<469.0,-83.0>--<469.0,-84.0>>/B<<469.0,-84.0>-<468.0,-76.0>-<468.5,-71.5>> = 7.125016348901757

	* product (U+220F): L<<470.0,-90.0>--<469.0,-83.0>>/L<<469.0,-83.0>--<469.0,-84.0>> = 8.13010235415596

	* product (U+220F): L<<93.0,342.0>--<93.0,341.0>>/B<<93.0,341.0>-<92.0,354.0>-<95.0,354.0>> = 4.398705354995508

	* product (U+220F): L<<96.0,320.0>--<93.0,342.0>>/L<<93.0,342.0>--<93.0,341.0>> = 7.765166018425354

	* registered (U+00AE): B<<485.0,553.5>-<477.0,558.0>-<478.0,558.0>>/B<<478.0,558.0>-<467.0,560.0>-<467.0,562.0>> = 10.304846468766044

	* registered (U+00AE): B<<489.5,78.5>-<492.0,80.0>-<491.0,79.0>>/L<<491.0,79.0>--<511.0,91.0>> = 14.036243467926457

	* registered (U+00AE): L<<536.0,43.0>--<539.0,46.0>>/L<<539.0,46.0>--<526.0,35.0>> = 4.763641690726066

	* registered (U+00AE): L<<558.0,59.0>--<536.0,43.0>>/L<<536.0,43.0>--<539.0,46.0>> = 8.972626614896399

	* second (U+2033): L<<210.0,572.0>--<213.0,596.0>>/L<<213.0,596.0>--<213.0,595.0>> = 7.1250163489018075

	* second (U+2033): L<<213.0,596.0>--<213.0,595.0>>/L<<213.0,595.0>--<214.0,617.0>> = 2.6025622024998034

	* second (U+2033): L<<41.0,572.0>--<44.0,596.0>>/L<<44.0,596.0>--<44.0,595.0>> = 7.1250163489018075

	* second (U+2033): L<<44.0,596.0>--<44.0,595.0>>/L<<44.0,595.0>--<45.0,617.0>> = 2.6025622024998034

	* summation (U+2211): L<<503.0,507.0>--<493.0,508.0>>/B<<493.0,508.0>-<496.0,508.0>-<494.0,513.0>> = 5.710593137499633

	* uni00B5 (U+00B5): L<<364.0,300.0>--<361.0,322.0>>/L<<361.0,322.0>--<361.0,321.0>> = 7.765166018425354

	* uni03A9 (U+03A9): B<<387.5,82.5>-<390.0,84.0>-<389.0,83.0>>/L<<389.0,83.0>--<403.0,94.0>> = 6.842773412630916

	* uni03A9 (U+03A9): L<<116.0,566.0>--<138.0,586.0>>/L<<138.0,586.0>--<137.0,585.0>> = 2.726310993906212

	* uni03A9 (U+03A9): L<<138.0,586.0>--<137.0,585.0>>/L<<137.0,585.0>--<147.0,594.0>> = 3.0127875041834073

	* uni03A9 (U+03A9): L<<390.0,-3.0>--<358.0,0.0>>/B<<358.0,0.0>-<362.0,0.0>-<359.0,25.0>> = 5.355825042855143

	* uni03BC (U+03BC): L<<364.0,300.0>--<361.0,322.0>>/L<<361.0,322.0>--<361.0,321.0>> = 7.765166018425354

	* uni1E9E (U+1E9E): L<<514.0,661.0>--<529.0,660.0>>/B<<529.0,660.0>-<528.0,660.0>-<534.5,657.0>> = 3.8140748342903783

	* uni2113 (U+2113): B<<276.0,84.0>-<286.0,69.0>-<285.0,69.0>>/L<<285.0,69.0>--<309.0,67.0>> = 4.763641690726143

	* uni2113 (U+2113): B<<324.0,453.0>-<328.0,464.0>-<328.0,463.0>>/L<<328.0,463.0>--<329.0,468.0>> = 11.309932474020195

	* uni2113 (U+2113): L<<177.0,288.0>--<180.0,292.0>>/L<<180.0,292.0>--<179.0,291.0>> = 8.13010235415596

	* uni2113 (U+2113): L<<179.0,108.0>--<180.0,116.0>>/L<<180.0,116.0>--<180.0,115.0>> = 7.1250163489018075

	* uni2113 (U+2113): L<<180.0,116.0>--<180.0,115.0>>/L<<180.0,115.0>--<182.0,143.0>> = 4.085616779974888

	* uni2126 (U+2126): B<<387.5,82.5>-<390.0,84.0>-<389.0,83.0>>/L<<389.0,83.0>--<403.0,94.0>> = 6.842773412630916

	* uni2126 (U+2126): L<<116.0,566.0>--<138.0,586.0>>/L<<138.0,586.0>--<137.0,585.0>> = 2.726310993906212

	* uni2126 (U+2126): L<<138.0,586.0>--<137.0,585.0>>/L<<137.0,585.0>--<147.0,594.0>> = 3.0127875041834073

	* uni2126 (U+2126): L<<390.0,-3.0>--<358.0,0.0>>/B<<358.0,0.0>-<362.0,0.0>-<359.0,25.0>> = 5.355825042855143

	* uni2318 (U+2318): L<<167.0,-51.0>--<168.0,-51.0>>/L<<168.0,-51.0>--<139.0,-48.0>> = 5.906141113770497

	* uni2318 (U+2318): L<<192.0,-49.0>--<168.0,-51.0>>/L<<168.0,-51.0>--<168.0,-51.0>> = 4.763641690726143

	* uni2325 (U+2325): L<<316.0,436.0>--<318.0,460.0>>/B<<318.0,460.0>-<318.0,459.0>-<323.0,464.0>> = 4.763641690726143

	* uni2325 (U+2325): L<<348.0,389.0>--<324.0,391.0>>/B<<324.0,391.0>-<326.0,391.0>-<321.0,396.0>> = 4.763641690726143

	* uni25CC (U+25CC): L<<709.0,195.0>--<712.0,195.0>>/L<<712.0,195.0>--<697.0,196.0>> = 3.8140748342903783

	* uni2B1C (U+2B1C): B<<156.0,476.0>-<149.0,477.0>-<149.0,478.0>>/L<<149.0,478.0>--<146.0,457.0>> = 8.13010235415596 [code: found-jaggy-segments]
</div></details><br></div></details><details><summary><b>[7] Formera-Light.ttf</b></summary><div><details><summary>🔥 <b>FAIL:</b> Check the OS/2 usWeightClass is appropriate for the font's best SubFamily name. (<a href="https://font-bakery.readthedocs.io/en/stable/fontbakery/profiles/googlefonts.html#com.google.fonts/check/usweightclass">com.google.fonts/check/usweightclass</a>)</summary><div>


* 🔥 **FAIL** Best SubFamily name is 'Light'. Expected OS/2 usWeightClass is 300, got 400. [code: bad-value]
</div></details><details><summary>🔥 <b>FAIL:</b> Do we have the latest version of FontBakery installed? (<a href="https://font-bakery.readthedocs.io/en/stable/fontbakery/profiles/universal.html#com.google.fonts/check/fontbakery_version">com.google.fonts/check/fontbakery_version</a>)</summary><div>


* 🔥 **FAIL** Current FontBakery version is 0.10.2, while a newer 0.11.2 is already available. Please upgrade it with 'pip install -U fontbakery' [code: outdated-fontbakery]
</div></details><details><summary>⚠ <b>WARN:</b> Check for codepoints not covered by METADATA subsets. (<a href="https://font-bakery.readthedocs.io/en/stable/fontbakery/profiles/googlefonts.html#com.google.fonts/check/metadata/unreachable_subsetting">com.google.fonts/check/metadata/unreachable_subsetting</a>)</summary><div>


* ⚠ **WARN** The following codepoints supported by the font are not covered by
    any subsets defined in the font's metadata file, and will never
    be served. You can solve this by either manually adding additional
    subset declarations to METADATA.pb, or by editing the glyphset
    definitions.

 * U+02BD MODIFIER LETTER REVERSED COMMA: not included in any glyphset definition
 * U+02BE MODIFIER LETTER RIGHT HALF RING: not included in any glyphset definition
 * U+02BF MODIFIER LETTER LEFT HALF RING: not included in any glyphset definition
 * U+02C7 CARON: try adding one of: yi, canadian-aboriginal, tifinagh
 * U+02C8 MODIFIER LETTER VERTICAL LINE: not included in any glyphset definition
 * U+02CA MODIFIER LETTER ACUTE ACCENT: not included in any glyphset definition
 * U+02CB MODIFIER LETTER GRAVE ACCENT: not included in any glyphset definition
 * U+02CC MODIFIER LETTER LOW VERTICAL LINE: not included in any glyphset definition
 * U+02D8 BREVE: try adding one of: yi, canadian-aboriginal
 * U+02D9 DOT ABOVE: try adding one of: yi, canadian-aboriginal
 * U+02DB OGONEK: try adding one of: yi, canadian-aboriginal
 * U+02DD DOUBLE ACUTE ACCENT: not included in any glyphset definition
 * U+0302 COMBINING CIRCUMFLEX ACCENT: try adding one of: cherokee, math, coptic, tifinagh
 * U+0306 COMBINING BREVE: try adding one of: old-permic, tifinagh
 * U+0307 COMBINING DOT ABOVE: try adding one of: old-permic, math, malayalam, syriac, coptic, tifinagh, tai-le, canadian-aboriginal
 * U+030A COMBINING RING ABOVE: try adding syriac
 * U+030B COMBINING DOUBLE ACUTE ACCENT: try adding one of: cherokee, osage
 * U+030C COMBINING CARON: try adding one of: cherokee, tai-le
 * U+0312 COMBINING TURNED COMMA ABOVE: not included in any glyphset definition
 * U+0326 COMBINING COMMA BELOW: not included in any glyphset definition
 * U+0327 COMBINING CEDILLA: not included in any glyphset definition
 * U+0328 COMBINING OGONEK: not included in any glyphset definition
 * U+032E COMBINING BREVE BELOW: try adding syriac
 * U+0330 COMBINING TILDE BELOW: try adding one of: cherokee, syriac, math
 * U+0331 COMBINING MACRON BELOW: try adding one of: caucasian-albanian, syriac, tifinagh, cherokee, gothic
 * U+0394 GREEK CAPITAL LETTER DELTA: try adding one of: math, greek, elbasan
 * U+03A9 GREEK CAPITAL LETTER OMEGA: try adding one of: math, greek, elbasan
 * U+03BC GREEK SMALL LETTER MU: try adding one of: math, greek
 * U+03C0 GREEK SMALL LETTER PI: try adding one of: yi, math, greek
 * U+1EA0 LATIN CAPITAL LETTER A WITH DOT BELOW: try adding vietnamese
 * U+1EA1 LATIN SMALL LETTER A WITH DOT BELOW: try adding vietnamese
 * U+1EB8 LATIN CAPITAL LETTER E WITH DOT BELOW: try adding vietnamese
 * U+1EB9 LATIN SMALL LETTER E WITH DOT BELOW: try adding vietnamese
 * U+1EBC LATIN CAPITAL LETTER E WITH TILDE: try adding vietnamese
 * U+1EBD LATIN SMALL LETTER E WITH TILDE: try adding vietnamese
 * U+1ECA LATIN CAPITAL LETTER I WITH DOT BELOW: try adding vietnamese
 * U+1ECB LATIN SMALL LETTER I WITH DOT BELOW: try adding vietnamese
 * U+1ECC LATIN CAPITAL LETTER O WITH DOT BELOW: try adding vietnamese
 * U+1ECD LATIN SMALL LETTER O WITH DOT BELOW: try adding vietnamese
 * U+1EE4 LATIN CAPITAL LETTER U WITH DOT BELOW: try adding vietnamese
 * U+1EE5 LATIN SMALL LETTER U WITH DOT BELOW: try adding vietnamese
 * U+2007 FIGURE SPACE: not included in any glyphset definition
 * U+2008 PUNCTUATION SPACE: not included in any glyphset definition
 * U+200A HAIR SPACE: not included in any glyphset definition
 * U+2010 HYPHEN: try adding one of: yi, kaithi, kharoshthi, cham, kayah-li, coptic, syloti-nagri, sundanese, sora-sompeng, lisu
 * U+2012 FIGURE DASH: not included in any glyphset definition
 * U+2015 HORIZONTAL BAR: try adding adlam
 * U+2021 DOUBLE DAGGER: try adding adlam
 * U+2030 PER MILLE SIGN: try adding adlam
 * U+2070 SUPERSCRIPT ZERO: not included in any glyphset definition
 * U+2075 SUPERSCRIPT FIVE: not included in any glyphset definition
 * U+2076 SUPERSCRIPT SIX: not included in any glyphset definition
 * U+2077 SUPERSCRIPT SEVEN: not included in any glyphset definition
 * U+2078 SUPERSCRIPT EIGHT: not included in any glyphset definition
 * U+2079 SUPERSCRIPT NINE: not included in any glyphset definition
 * U+2080 SUBSCRIPT ZERO: not included in any glyphset definition
 * U+2081 SUBSCRIPT ONE: not included in any glyphset definition
 * U+2082 SUBSCRIPT TWO: not included in any glyphset definition
 * U+2083 SUBSCRIPT THREE: not included in any glyphset definition
 * U+2084 SUBSCRIPT FOUR: not included in any glyphset definition
 * U+2085 SUBSCRIPT FIVE: not included in any glyphset definition
 * U+2086 SUBSCRIPT SIX: not included in any glyphset definition
 * U+2087 SUBSCRIPT SEVEN: not included in any glyphset definition
 * U+2088 SUBSCRIPT EIGHT: not included in any glyphset definition
 * U+2089 SUBSCRIPT NINE: not included in any glyphset definition
 * U+2105 CARE OF: not included in any glyphset definition
 * U+2106 CADA UNA: not included in any glyphset definition
 * U+2116 NUMERO SIGN: try adding cyrillic
 * U+2126 OHM SIGN: not included in any glyphset definition
 * U+212E ESTIMATED SYMBOL: not included in any glyphset definition
 * U+21E7 UPWARDS WHITE ARROW: try adding symbols
 * U+2202 PARTIAL DIFFERENTIAL: try adding math
 * U+2205 EMPTY SET: try adding math
 * U+2206 INCREMENT: try adding math
 * U+220F N-ARY PRODUCT: try adding math
 * U+2211 N-ARY SUMMATION: try adding math
 * U+2219 BULLET OPERATOR: try adding one of: tai-tham, symbols, math, yi
 * U+221A SQUARE ROOT: try adding math
 * U+221E INFINITY: try adding math
 * U+222B INTEGRAL: try adding math
 * U+2248 ALMOST EQUAL TO: try adding math
 * U+2260 NOT EQUAL TO: try adding math
 * U+2264 LESS-THAN OR EQUAL TO: try adding math
 * U+2265 GREATER-THAN OR EQUAL TO: try adding math
 * U+2317 VIEWDATA SQUARE: try adding symbols
 * U+2318 PLACE OF INTEREST SIGN: try adding symbols
 * U+2325 OPTION KEY: try adding symbols
 * U+25A0 BLACK SQUARE: try adding symbols
 * U+25A1 WHITE SQUARE: try adding symbols
 * U+25B2 BLACK UP-POINTING TRIANGLE: try adding symbols
 * U+25B3 WHITE UP-POINTING TRIANGLE: try adding one of: symbols, math
 * U+25B6 BLACK RIGHT-POINTING TRIANGLE: try adding symbols
 * U+25B7 WHITE RIGHT-POINTING TRIANGLE: try adding one of: symbols, math
 * U+25BC BLACK DOWN-POINTING TRIANGLE: try adding symbols
 * U+25BD WHITE DOWN-POINTING TRIANGLE: try adding one of: symbols, math
 * U+25C0 BLACK LEFT-POINTING TRIANGLE: try adding symbols
 * U+25C1 WHITE LEFT-POINTING TRIANGLE: try adding one of: symbols, math
 * U+25C6 BLACK DIAMOND: try adding symbols
 * U+25C7 WHITE DIAMOND: try adding symbols
 * U+25CA LOZENGE: try adding one of: symbols, math
 * U+25CB WHITE CIRCLE: try adding symbols
 * U+25CC DOTTED CIRCLE: try adding one of: caucasian-albanian, wancho, khojki, hebrew, bassa-vah, new-tai-lue, syloti-nagri, buginese, sundanese, balinese, tai-viet, mandaic, adlam, osage, tagbanwa, kayah-li, gujarati, lao, masaram-gondi, sogdian, ahom, yi, cham, malayalam, lepcha, oriya, old-permic, tamil, tifinagh, tirhuta, khudawadi, psalter-pahlavi, pahawh-hmong, thaana, bengali, sinhala, brahmi, duployan, math, tibetan, phags-pa, grantha, music, gunjala-gondi, tai-le, elbasan, batak, soyombo, buhid, mende-kikakui, meetei-mayek, manichaean, kharoshthi, thai, syriac, gurmukhi, mahajani, takri, siddham, rejang, mongolian, sharada, modi, marchen, coptic, javanese, devanagari, khmer, zanabazar-square, dogra, myanmar, kaithi, newa, miao, symbols, nko, hanifi-rohingya, kannada, telugu, bhaiksuki, tagalog, hanunoo, limbu, chakma
 * U+25CF BLACK CIRCLE: try adding symbols
 * U+2B1B BLACK LARGE SQUARE: try adding symbols
 * U+2B1C WHITE LARGE SQUARE: try adding symbols
 * U+2B98 THREE-D TOP-LIGHTED LEFTWARDS EQUILATERAL ARROWHEAD: try adding symbols
 * U+2B99 THREE-D RIGHT-LIGHTED UPWARDS EQUILATERAL ARROWHEAD: try adding symbols
 * U+2B9A THREE-D TOP-LIGHTED RIGHTWARDS EQUILATERAL ARROWHEAD: try adding symbols
 * U+2B9B THREE-D LEFT-LIGHTED DOWNWARDS EQUILATERAL ARROWHEAD: try adding symbols
 * U+2B9C BLACK LEFTWARDS EQUILATERAL ARROWHEAD: try adding symbols
 * U+2B9D BLACK UPWARDS EQUILATERAL ARROWHEAD: try adding symbols
 * U+2B9E BLACK RIGHTWARDS EQUILATERAL ARROWHEAD: try adding symbols
 * U+2B9F BLACK DOWNWARDS EQUILATERAL ARROWHEAD: try adding symbols
 * U+E133 : not included in any glyphset definition
 * U+E134 : not included in any glyphset definition
 * U+FB00 LATIN SMALL LIGATURE FF: not included in any glyphset definition
 * U+FB01 LATIN SMALL LIGATURE FI: not included in any glyphset definition
 * U+FB02 LATIN SMALL LIGATURE FL: not included in any glyphset definition
 * U+FB03 LATIN SMALL LIGATURE FFI: not included in any glyphset definition
 * U+FB04 LATIN SMALL LIGATURE FFL: not included in any glyphset definition

Or you can add the above codepoints to one of the subsets supported by the font: `latin`, `latin-ext` [code: unreachable-subsetting]
</div></details><details><summary>⚠ <b>WARN:</b> Is there kerning info for non-ligated sequences? (<a href="https://font-bakery.readthedocs.io/en/stable/fontbakery/profiles/googlefonts.html#com.google.fonts/check/kerning_for_non_ligated_sequences">com.google.fonts/check/kerning_for_non_ligated_sequences</a>)</summary><div>


* ⚠ **WARN** GPOS table lacks kerning info for the following non-ligated sequences:

	- f + f

	- f + i

	- i + f

	- f + l

	- l + f

	- i + l [code: lacks-kern-info]
</div></details><details><summary>⚠ <b>WARN:</b> Ensure fonts have ScriptLangTags declared on the 'meta' table. (<a href="https://font-bakery.readthedocs.io/en/stable/fontbakery/profiles/googlefonts.html#com.google.fonts/check/meta/script_lang_tags">com.google.fonts/check/meta/script_lang_tags</a>)</summary><div>


* ⚠ **WARN** This font file does not have a 'meta' table. [code: lacks-meta-table]
</div></details><details><summary>⚠ <b>WARN:</b> Check if each glyph has the recommended amount of contours. (<a href="https://font-bakery.readthedocs.io/en/stable/fontbakery/profiles/universal.html#com.google.fonts/check/contour_count">com.google.fonts/check/contour_count</a>)</summary><div>


* ⚠ **WARN** This check inspects the glyph outlines and detects the total number of contours in each of them. The expected values are infered from the typical ammounts of contours observed in a large collection of reference font families. The divergences listed below may simply indicate a significantly different design on some of your glyphs. On the other hand, some of these may flag actual bugs in the font such as glyphs mapped to an incorrect codepoint. Please consider reviewing the design and codepoint assignment of these to make sure they are correct.

The following glyphs do not have the recommended number of contours:

	- Glyph name: r	Contours detected: 2	Expected: 1

	- Glyph name: uni00B5	Contours detected: 2	Expected: 1

	- Glyph name: ae	Contours detected: 2	Expected: 3

	- Glyph name: aogonek	Contours detected: 3	Expected: 2

	- Glyph name: dcroat	Contours detected: 3	Expected: 2

	- Glyph name: eogonek	Contours detected: 3	Expected: 2

	- Glyph name: hbar	Contours detected: 2	Expected: 1

	- Glyph name: lslash	Contours detected: 2	Expected: 1

	- Glyph name: racute	Contours detected: 3	Expected: 2

	- Glyph name: uni0157	Contours detected: 3	Expected: 2

	- Glyph name: rcaron	Contours detected: 3	Expected: 2

	- Glyph name: Tbar	Contours detected: 2	Expected: 1

	- Glyph name: tbar	Contours detected: 2	Expected: 1

	- Glyph name: Uogonek	Contours detected: 2	Expected: 1

	- Glyph name: uogonek	Contours detected: 2	Expected: 1

	- Glyph name: uni01EA	Contours detected: 3	Expected: 2

	- Glyph name: uni01EB	Contours detected: 3	Expected: 2

	- Glyph name: aeacute	Contours detected: 3	Expected: 4

	- Glyph name: uni03BC	Contours detected: 2	Expected: 1

	- Glyph name: uni1E08	Contours detected: 3	Expected: 2

	- Glyph name: uni1E09	Contours detected: 3	Expected: 2

	- Glyph name: uni1E1C	Contours detected: 3	Expected: 2

	- Glyph name: uni1E1D	Contours detected: 4	Expected: 3

	- Glyph name: uni1E5B	Contours detected: 3	Expected: 2

	- Glyph name: rmacronbelow	Contours detected: 3	Expected: 2

	- Glyph name: uni2113	Contours detected: 3	Expected: 2

	- Glyph name: estimated	Contours detected: 3	Expected: 2

	- Glyph name: Tbar	Contours detected: 2	Expected: 1

	- Glyph name: Uogonek	Contours detected: 2	Expected: 1

	- Glyph name: ae	Contours detected: 2	Expected: 3

	- Glyph name: aeacute	Contours detected: 3	Expected: 4

	- Glyph name: aogonek	Contours detected: 3	Expected: 2

	- Glyph name: dcroat	Contours detected: 3	Expected: 2

	- Glyph name: eogonek	Contours detected: 3	Expected: 2

	- Glyph name: estimated	Contours detected: 3	Expected: 2

	- Glyph name: hbar	Contours detected: 2	Expected: 1

	- Glyph name: lslash	Contours detected: 2	Expected: 1

	- Glyph name: r	Contours detected: 2	Expected: 1

	- Glyph name: racute	Contours detected: 3	Expected: 2

	- Glyph name: rcaron	Contours detected: 3	Expected: 2

	- Glyph name: tbar	Contours detected: 2	Expected: 1

	- Glyph name: uni00B5	Contours detected: 2	Expected: 1

	- Glyph name: uni0157	Contours detected: 3	Expected: 2

	- Glyph name: uni03BC	Contours detected: 2	Expected: 1

	- Glyph name: uni1E08	Contours detected: 3	Expected: 2

	- Glyph name: uni1E09	Contours detected: 3	Expected: 2

	- Glyph name: uni1E1C	Contours detected: 3	Expected: 2

	- Glyph name: uni1E1D	Contours detected: 4	Expected: 3

	- Glyph name: uni1E5B	Contours detected: 3	Expected: 2

	- Glyph name: uni2113	Contours detected: 3	Expected: 2

	- Glyph name: uogonek	Contours detected: 2	Expected: 1
 [code: contour-count]
</div></details><details><summary>⚠ <b>WARN:</b> Do outlines contain any jaggy segments? (<a href="https://font-bakery.readthedocs.io/en/stable/fontbakery/profiles/<Section: Outline Correctness Checks>.html#com.google.fonts/check/outline_jaggy_segments">com.google.fonts/check/outline_jaggy_segments</a>)</summary><div>


* ⚠ **WARN** The following glyphs have jaggy segments:

	* approxequal (U+2248): L<<334.0,171.0>--<338.0,171.0>>/L<<338.0,171.0>--<314.0,173.0>> = 4.763641690726143

	* approxequal (U+2248): L<<334.0,352.0>--<338.0,352.0>>/L<<338.0,352.0>--<314.0,354.0>> = 4.763641690726143

	* approxequal (U+2248): L<<350.0,168.0>--<334.0,171.0>>/L<<334.0,171.0>--<338.0,171.0>> = 10.61965527615514

	* approxequal (U+2248): L<<350.0,349.0>--<334.0,352.0>>/L<<334.0,352.0>--<338.0,352.0>> = 10.61965527615514

	* asciitilde (U+007E): L<<341.0,211.0>--<345.0,211.0>>/L<<345.0,211.0>--<321.0,213.0>> = 4.763641690726143

	* asciitilde (U+007E): L<<357.0,208.0>--<341.0,211.0>>/L<<341.0,211.0>--<345.0,211.0>> = 10.61965527615514

	* copyright (U+00A9): B<<186.5,599.0>-<189.0,600.0>-<188.0,599.0>>/L<<188.0,599.0>--<196.0,604.0>> = 12.994616791916483

	* copyright (U+00A9): B<<481.5,51.5>-<484.0,53.0>-<483.0,52.0>>/B<<483.0,52.0>-<487.0,55.0>-<488.5,56.0>> = 8.13010235415596

	* copyright (U+00A9): B<<617.0,193.0>-<622.0,208.0>-<622.0,205.0>>/L<<622.0,205.0>--<623.0,212.0>> = 8.13010235415596

	* copyright (U+00A9): L<<488.0,417.0>--<487.0,397.0>>/B<<487.0,397.0>-<487.0,400.0>-<480.0,408.0>> = 2.862405226111651

	* currency (U+00A4): L<<227.0,123.0>--<230.0,123.0>>/L<<230.0,123.0>--<201.0,128.0>> = 9.782407031807285

	* currency (U+00A4): L<<262.0,121.0>--<227.0,123.0>>/L<<227.0,123.0>--<230.0,123.0>> = 3.270487923183572

	* currency (U+00A4): L<<280.0,544.0>--<303.0,542.0>>/L<<303.0,542.0>--<302.0,542.0>> = 4.969740728110289

	* currency (U+00A4): L<<303.0,542.0>--<302.0,542.0>>/L<<302.0,542.0>--<314.0,539.0>> = 14.036243467926484

	* currency (U+00A4): L<<498.0,98.0>--<483.0,84.0>>/B<<483.0,84.0>-<486.0,87.0>-<477.0,94.0>> = 1.974934010881775

	* dagger (U+2020): B<<159.0,735.5>-<164.0,735.0>-<170.0,736.0>>/B<<170.0,736.0>-<166.0,736.0>-<175.0,737.0>> = 9.462322208025613

	* dagger (U+2020): B<<179.0,-53.5>-<170.0,-53.0>-<173.0,-53.0>>/B<<173.0,-53.0>-<167.0,-52.0>-<161.5,-51.5>> = 9.462322208025613

	* divide (U+00F7): L<<445.0,313.0>--<444.0,292.0>>/B<<444.0,292.0>-<444.0,295.0>-<432.0,292.0>> = 2.726310993906212

	* equal (U+003D): L<<421.0,264.0>--<439.0,263.0>>/B<<439.0,263.0>-<435.0,263.0>-<439.5,261.0>> = 3.1798301198641643

	* equal (U+003D): L<<422.0,399.0>--<435.0,398.0>>/B<<435.0,398.0>-<434.0,398.0>-<439.0,396.0>> = 4.398705354995508

	* equal (U+003D): L<<445.0,245.0>--<444.0,224.0>>/B<<444.0,224.0>-<444.0,227.0>-<431.0,224.0>> = 2.726310993906212

	* estimated (U+212E): B<<162.0,61.0>-<155.0,66.0>-<156.0,66.0>>/B<<156.0,66.0>-<145.0,68.0>-<147.0,70.0>> = 10.304846468766044

	* estimated (U+212E): L<<193.0,582.0>--<196.0,585.0>>/L<<196.0,585.0>--<175.0,569.0>> = 7.696051722016604

	* estimated (U+212E): L<<204.0,591.0>--<193.0,582.0>>/L<<193.0,582.0>--<196.0,585.0>> = 5.710593137499633

	* estimated (U+212E): L<<369.0,660.0>--<388.0,657.0>>/L<<388.0,657.0>--<387.0,657.0>> = 8.972626614896399

	* estimated (U+212E): L<<388.0,657.0>--<387.0,657.0>>/L<<387.0,657.0>--<400.0,656.0>> = 4.398705354995508

	* estimated (U+212E): L<<561.0,89.0>--<564.0,92.0>>/L<<564.0,92.0>--<547.0,76.0>> = 1.735704588928346

	* estimated (U+212E): L<<570.0,97.0>--<561.0,89.0>>/L<<561.0,89.0>--<564.0,92.0>> = 3.3664606634298315

	* fraction (U+2044): B<<22.5,-40.0>-<23.0,-40.0>-<25.0,-40.0>>/B<<25.0,-40.0>-<21.0,-39.0>-<15.5,-36.0>> = 14.036243467926484

	* fraction (U+2044): B<<37.5,-37.5>-<29.0,-40.0>-<25.0,-40.0>>/L<<25.0,-40.0>--<29.0,-41.0>> = 14.036243467926484

	* fraction (U+2044): B<<382.5,751.5>-<384.0,751.0>-<380.0,751.0>>/L<<380.0,751.0>--<384.0,750.0>> = 14.036243467926484

	* greater (U+003E): B<<254.5,209.0>-<247.0,206.0>-<248.0,207.0>>/B<<248.0,207.0>-<237.0,199.0>-<231.0,197.0>> = 8.972626614896358

	* infinity (U+221E): B<<132.0,222.0>-<147.0,219.0>-<144.0,219.0>>/L<<144.0,219.0>--<158.0,218.0>> = 4.085616779974888

	* infinity (U+221E): L<<198.0,421.0>--<199.0,421.0>>/B<<199.0,421.0>-<186.0,423.0>-<177.5,424.5>> = 8.746162262555211

	* infinity (U+221E): L<<227.0,243.0>--<240.0,255.0>>/L<<240.0,255.0>--<239.0,254.0>> = 2.2906100426385936

	* infinity (U+221E): L<<240.0,255.0>--<239.0,254.0>>/L<<239.0,254.0>--<250.0,264.0>> = 2.726310993906212

	* infinity (U+221E): L<<518.0,227.0>--<517.0,226.0>>/L<<517.0,226.0>--<524.0,232.0>> = 4.398705354995591

	* integral (U+222B): L<<211.0,-173.0>--<211.0,-174.0>>/L<<211.0,-174.0>--<218.0,-144.0>> = 13.134022306396298

	* less (U+003C): B<<244.0,197.0>-<238.0,199.0>-<227.0,207.0>>/B<<227.0,207.0>-<228.0,206.0>-<220.5,209.0>> = 8.972626614896358

	* minus (U+2212): L<<30.0,325.0>--<31.0,332.0>>/B<<31.0,332.0>-<31.0,331.0>-<38.0,332.0>> = 8.13010235415596

	* minus (U+2212): L<<421.0,332.0>--<445.0,331.0>>/B<<445.0,331.0>-<443.0,331.0>-<445.0,323.0>> = 2.3859440303887243

	* minus (U+2212): L<<54.0,292.0>--<29.0,295.0>>/B<<29.0,295.0>-<30.0,295.0>-<30.0,302.0>> = 6.842773412630916

	* multiply (U+00D7): B<<242.5,278.5>-<237.0,283.0>-<238.0,284.0>>/L<<238.0,284.0>--<217.0,266.0>> = 4.398705354995508

	* notequal (U+2260): B<<143.0,147.0>-<144.0,150.0>-<144.0,149.0>>/L<<144.0,149.0>--<145.0,153.0>> = 14.036243467926484

	* notequal (U+2260): B<<162.0,186.0>-<163.0,189.0>-<163.0,188.0>>/B<<163.0,188.0>-<164.0,194.0>-<169.5,209.5>> = 9.462322208025613

	* notequal (U+2260): B<<169.5,209.5>-<175.0,225.0>-<176.0,225.0>>/L<<176.0,225.0>--<151.0,227.0>> = 4.573921259900818

	* notequal (U+2260): L<<29.0,245.0>--<31.0,264.0>>/B<<31.0,264.0>-<31.0,262.0>-<53.0,264.0>> = 6.009005957494474

	* numbersign (U+0023): B<<25.5,132.0>-<25.0,133.0>-<25.0,132.0>>/B<<25.0,132.0>-<23.0,150.0>-<39.0,155.0>> = 6.340191745909908

	* numbersign (U+0023): L<<426.0,297.0>--<427.0,297.0>>/B<<427.0,297.0>-<417.0,296.0>-<412.5,285.5>> = 5.710593137499633

	* numbersign (U+0023): L<<445.0,299.0>--<426.0,297.0>>/L<<426.0,297.0>--<427.0,297.0>> = 6.009005957494535

	* onehalf (U+00BD): B<<22.5,-40.0>-<23.0,-40.0>-<25.0,-40.0>>/B<<25.0,-40.0>-<21.0,-39.0>-<15.5,-36.0>> = 14.036243467926484

	* onehalf (U+00BD): B<<37.5,-37.5>-<29.0,-40.0>-<25.0,-40.0>>/L<<25.0,-40.0>--<29.0,-41.0>> = 14.036243467926484

	* onehalf (U+00BD): B<<382.5,751.5>-<384.0,751.0>-<380.0,751.0>>/L<<380.0,751.0>--<384.0,750.0>> = 14.036243467926484

	* onequarter (U+00BC): B<<22.5,-40.0>-<23.0,-40.0>-<25.0,-40.0>>/B<<25.0,-40.0>-<21.0,-39.0>-<15.5,-36.0>> = 14.036243467926484

	* onequarter (U+00BC): B<<37.5,-37.5>-<29.0,-40.0>-<25.0,-40.0>>/L<<25.0,-40.0>--<29.0,-41.0>> = 14.036243467926484

	* onequarter (U+00BC): B<<382.5,751.5>-<384.0,751.0>-<380.0,751.0>>/L<<380.0,751.0>--<384.0,750.0>> = 14.036243467926484

	* partialdiff (U+2202): B<<171.0,585.0>-<166.0,587.0>-<167.0,587.0>>/B<<167.0,587.0>-<154.0,589.0>-<146.0,591.0>> = 8.746162262555211

	* partialdiff (U+2202): B<<236.5,555.0>-<229.0,560.0>-<230.0,560.0>>/B<<230.0,560.0>-<220.0,561.0>-<220.0,565.0>> = 5.710593137499633

	* partialdiff (U+2202): B<<433.5,127.5>-<430.0,119.0>-<430.0,120.0>>/L<<430.0,120.0>--<428.0,109.0>> = 10.304846468766044

	* partialdiff (U+2202): L<<260.0,376.0>--<263.0,376.0>>/L<<263.0,376.0>--<246.0,379.0>> = 10.007979801441312

	* partialdiff (U+2202): L<<289.0,372.0>--<260.0,376.0>>/L<<260.0,376.0>--<263.0,376.0>> = 7.853313301978193

	* partialdiff (U+2202): L<<323.0,48.0>--<328.0,51.0>>/L<<328.0,51.0>--<327.0,50.0>> = 14.036243467926484

	* percent (U+0025): B<<192.0,433.0>-<208.0,441.0>-<205.0,438.0>>/L<<205.0,438.0>--<227.0,455.0>> = 7.3057595333108205

	* percent (U+0025): L<<113.0,589.0>--<114.0,590.0>>/L<<114.0,590.0>--<93.0,574.0>> = 7.696051722016604

	* percent (U+0025): L<<324.0,208.0>--<340.0,223.0>>/B<<340.0,223.0>-<339.0,222.0>-<340.0,223.0>> = 1.8476102659947131

	* percent (U+0025): L<<461.0,196.0>--<462.0,197.0>>/L<<462.0,197.0>--<458.0,194.0>> = 8.13010235415596

	* percent (U+0025): L<<462.0,197.0>--<458.0,194.0>>/L<<458.0,194.0>--<461.0,197.0>> = 8.13010235415596

	* perthousand (U+2030): B<<797.0,70.0>-<805.0,83.0>-<805.0,82.0>>/L<<805.0,82.0>--<811.0,106.0>> = 14.036243467926484

	* perthousand (U+2030): L<<112.0,588.0>--<114.0,590.0>>/L<<114.0,590.0>--<93.0,574.0>> = 7.696051722016604

	* perthousand (U+2030): L<<490.0,12.0>--<493.0,15.0>>/B<<493.0,15.0>-<482.0,7.0>-<470.0,4.0>> = 8.972626614896399

	* perthousand (U+2030): L<<510.0,29.0>--<490.0,12.0>>/L<<490.0,12.0>--<493.0,15.0>> = 4.635463426902695

	* pi (U+03C0): B<<395.0,348.0>-<388.0,348.0>-<388.0,349.0>>/L<<388.0,349.0>--<386.0,326.0>> = 4.969740728110289

	* pi (U+03C0): L<<116.0,-3.0>--<94.0,0.0>>/L<<94.0,0.0>--<96.0,0.0>> = 7.765166018425354

	* pi (U+03C0): L<<345.0,126.0>--<345.0,125.0>>/B<<345.0,125.0>-<344.0,145.0>-<346.0,145.0>> = 2.862405226111651

	* pi (U+03C0): L<<348.0,96.0>--<345.0,126.0>>/L<<345.0,126.0>--<345.0,125.0>> = 5.710593137499633

	* plus (U+002B): L<<220.0,121.0>--<216.0,122.0>>/L<<216.0,122.0>--<219.0,122.0>> = 14.036243467926484

	* plus (U+002B): L<<397.0,331.0>--<421.0,332.0>>/L<<421.0,332.0>--<420.0,332.0>> = 2.3859440303887243

	* plus (U+002B): L<<421.0,332.0>--<420.0,332.0>>/B<<420.0,332.0>-<432.0,333.0>-<438.0,332.0>> = 4.763641690726143

	* plusminus (U+00B1): L<<216.0,298.0>--<216.0,297.0>>/B<<216.0,297.0>-<215.0,302.0>-<216.0,304.5>> = 11.309932474020195

	* plusminus (U+00B1): L<<217.0,294.0>--<216.0,298.0>>/L<<216.0,298.0>--<216.0,297.0>> = 14.036243467926484

	* plusminus (U+00B1): L<<40.0,71.0>--<29.0,72.0>>/B<<29.0,72.0>-<31.0,72.0>-<31.0,90.0>> = 5.1944289077348

	* plusminus (U+00B1): L<<445.0,90.0>--<444.0,69.0>>/B<<444.0,69.0>-<444.0,72.0>-<421.0,72.0>> = 2.726310993906212

	* product (U+220F): L<<429.0,-240.0>--<409.0,-237.0>>/B<<409.0,-237.0>-<411.0,-237.0>-<409.0,-228.0>> = 8.530765609948139

	* radical (U+221A): B<<249.0,139.0>-<246.0,131.0>-<246.0,132.0>>/B<<246.0,132.0>-<245.0,122.0>-<239.0,107.0>> = 5.710593137499633

	* radical (U+221A): L<<178.0,86.0>--<183.0,61.0>>/L<<183.0,61.0>--<183.0,65.0>> = 11.309932474020195

	* radical (U+221A): L<<381.0,710.0>--<382.0,716.0>>/L<<382.0,716.0>--<382.0,715.0>> = 9.462322208025613

	* radical (U+221A): L<<612.0,787.0>--<636.0,786.0>>/B<<636.0,786.0>-<634.0,786.0>-<636.0,770.0>> = 2.3859440303887243

	* radical (U+221A): L<<83.0,336.0>--<105.0,335.0>>/B<<105.0,335.0>-<104.0,335.0>-<106.0,331.0>> = 2.6025622024998034

	* registered (U+00AE): B<<501.5,26.5>-<494.0,23.0>-<495.0,24.0>>/B<<495.0,24.0>-<485.0,15.0>-<473.0,11.0>> = 3.012787504183286

	* registered (U+00AE): B<<608.0,176.0>-<615.0,189.0>-<615.0,187.0>>/B<<615.0,187.0>-<616.0,191.0>-<616.5,192.5>> = 14.036243467926484

	* registered (U+00AE): L<<640.0,266.0>--<641.0,289.0>>/L<<641.0,289.0>--<641.0,288.0>> = 2.4895529219991284

	* registered (U+00AE): L<<641.0,289.0>--<641.0,288.0>>/L<<641.0,288.0>--<643.0,303.0>> = 7.594643368591447

	* threequarters (U+00BE): B<<138.5,-40.0>-<139.0,-40.0>-<141.0,-40.0>>/B<<141.0,-40.0>-<137.0,-39.0>-<131.5,-36.0>> = 14.036243467926484

	* threequarters (U+00BE): B<<153.5,-37.5>-<145.0,-40.0>-<141.0,-40.0>>/L<<141.0,-40.0>--<145.0,-41.0>> = 14.036243467926484

	* threequarters (U+00BE): B<<202.5,411.0>-<197.0,421.0>-<191.0,431.0>>/B<<191.0,431.0>-<192.0,430.0>-<191.5,431.0>> = 14.036243467926457

	* threequarters (U+00BE): B<<498.5,751.5>-<500.0,751.0>-<496.0,751.0>>/L<<496.0,751.0>--<500.0,750.0>> = 14.036243467926484

	* uni00B3 (U+00B3): B<<211.5,411.0>-<206.0,421.0>-<200.0,431.0>>/B<<200.0,431.0>-<201.0,430.0>-<200.5,431.0>> = 14.036243467926457

	* uni00B5 (U+00B5): L<<367.0,71.0>--<368.0,72.0>>/L<<368.0,72.0>--<359.0,65.0>> = 7.1250163489018075

	* uni00B5 (U+00B5): L<<67.0,-158.0>--<66.0,-147.0>>/L<<66.0,-147.0>--<66.0,-148.0>> = 5.1944289077348

	* uni03A9 (U+03A9): B<<389.0,56.5>-<391.0,58.0>-<390.0,57.0>>/L<<390.0,57.0>--<408.0,68.0>> = 13.570434385161448

	* uni03A9 (U+03A9): L<<352.0,599.0>--<355.0,599.0>>/L<<355.0,599.0>--<344.0,600.0>> = 5.1944289077348

	* uni03A9 (U+03A9): L<<378.0,595.0>--<352.0,599.0>>/L<<352.0,599.0>--<355.0,599.0>> = 8.746162262555211

	* uni03A9 (U+03A9): L<<558.0,277.0>--<560.0,298.0>>/L<<560.0,298.0>--<560.0,297.0>> = 5.4403320310054815

	* uni03A9 (U+03A9): L<<560.0,297.0>--<562.0,320.0>>/L<<562.0,320.0>--<562.0,319.0>> = 4.969740728110289

	* uni03A9 (U+03A9): L<<560.0,298.0>--<560.0,297.0>>/L<<560.0,297.0>--<562.0,320.0>> = 4.969740728110289

	* uni03A9 (U+03A9): L<<562.0,320.0>--<562.0,319.0>>/L<<562.0,319.0>--<563.0,348.0>> = 1.9749340108819595

	* uni03BC (U+03BC): L<<367.0,71.0>--<368.0,72.0>>/L<<368.0,72.0>--<359.0,65.0>> = 7.1250163489018075

	* uni03BC (U+03BC): L<<67.0,-158.0>--<66.0,-147.0>>/L<<66.0,-147.0>--<66.0,-148.0>> = 5.1944289077348

	* uni1E9E (U+1E9E): L<<356.0,-5.0>--<357.0,-5.0>>/L<<357.0,-5.0>--<326.0,-3.0>> = 3.6913859864512575

	* uni1E9E (U+1E9E): L<<366.0,-6.0>--<356.0,-5.0>>/L<<356.0,-5.0>--<357.0,-5.0>> = 5.710593137499633

	* uni2083 (U+2083): B<<211.5,36.0>-<206.0,46.0>-<200.0,56.0>>/B<<200.0,56.0>-<201.0,55.0>-<200.5,56.0>> = 14.036243467926457

	* uni2105 (U+2105): B<<191.5,-40.0>-<192.0,-40.0>-<194.0,-40.0>>/B<<194.0,-40.0>-<190.0,-39.0>-<184.5,-36.0>> = 14.036243467926484

	* uni2105 (U+2105): B<<206.5,-37.5>-<198.0,-40.0>-<194.0,-40.0>>/L<<194.0,-40.0>--<198.0,-41.0>> = 14.036243467926484

	* uni2105 (U+2105): B<<551.5,751.5>-<553.0,751.0>-<549.0,751.0>>/L<<549.0,751.0>--<553.0,750.0>> = 14.036243467926484

	* uni2106 (U+2106): B<<192.5,-40.0>-<193.0,-40.0>-<195.0,-40.0>>/B<<195.0,-40.0>-<191.0,-39.0>-<185.5,-36.0>> = 14.036243467926484

	* uni2106 (U+2106): B<<207.5,-37.5>-<199.0,-40.0>-<195.0,-40.0>>/L<<195.0,-40.0>--<199.0,-41.0>> = 14.036243467926484

	* uni2106 (U+2106): B<<552.5,751.5>-<554.0,751.0>-<550.0,751.0>>/L<<550.0,751.0>--<554.0,750.0>> = 14.036243467926484

	* uni2113 (U+2113): B<<188.0,83.0>-<188.0,84.0>-<187.0,82.0>>/L<<187.0,82.0>--<190.0,92.0>> = 9.865806943084328

	* uni2113 (U+2113): L<<265.0,561.0>--<265.0,570.0>>/L<<265.0,570.0>--<260.0,532.0>> = 7.495857639729836

	* uni2113 (U+2113): L<<338.0,463.0>--<338.0,461.0>>/L<<338.0,461.0>--<339.0,466.0>> = 11.309932474020195

	* uni2113 (U+2113): L<<364.0,33.0>--<367.0,35.0>>/L<<367.0,35.0>--<350.0,21.0>> = 5.782392322364035

	* uni2113 (U+2113): L<<380.0,46.0>--<364.0,33.0>>/L<<364.0,33.0>--<367.0,35.0>> = 5.40379136024966

	* uni2126 (U+2126): B<<389.0,56.5>-<391.0,58.0>-<390.0,57.0>>/L<<390.0,57.0>--<408.0,68.0>> = 13.570434385161448

	* uni2126 (U+2126): L<<352.0,599.0>--<355.0,599.0>>/L<<355.0,599.0>--<344.0,600.0>> = 5.1944289077348

	* uni2126 (U+2126): L<<378.0,595.0>--<352.0,599.0>>/L<<352.0,599.0>--<355.0,599.0>> = 8.746162262555211

	* uni2126 (U+2126): L<<558.0,277.0>--<560.0,298.0>>/L<<560.0,298.0>--<560.0,297.0>> = 5.4403320310054815

	* uni2126 (U+2126): L<<560.0,297.0>--<562.0,320.0>>/L<<562.0,320.0>--<562.0,319.0>> = 4.969740728110289

	* uni2126 (U+2126): L<<560.0,298.0>--<560.0,297.0>>/L<<560.0,297.0>--<562.0,320.0>> = 4.969740728110289

	* uni2126 (U+2126): L<<562.0,320.0>--<562.0,319.0>>/L<<562.0,319.0>--<563.0,348.0>> = 1.9749340108819595

	* uni21E7 (U+21E7): B<<295.0,35.0>-<297.0,14.0>-<295.0,14.0>>/L<<295.0,14.0>--<316.0,13.0>> = 2.726310993906212

	* uni2325 (U+2325): L<<50.0,454.0>--<51.0,460.0>>/L<<51.0,460.0>--<51.0,459.0>> = 9.462322208025613

	* uni25CC (U+25CC): L<<691.0,213.0>--<693.0,213.0>>/L<<693.0,213.0>--<684.0,214.0>> = 6.340191745909908

	* uni2B1B (U+2B1B): L<<71.0,-115.0>--<60.0,-114.0>>/L<<60.0,-114.0>--<62.0,-114.0>> = 5.1944289077348

	* uni2B1C (U+2B1C): L<<54.0,469.0>--<51.0,493.0>>/L<<51.0,493.0>--<51.0,492.0>> = 7.125016348901757 [code: found-jaggy-segments]
</div></details><br></div></details>

### Summary

| 💔 ERROR | 🔥 FAIL | ⚠ WARN | 💤 SKIP | ℹ INFO | 🍞 PASS | 🔎 DEBUG |
|:-----:|:----:|:----:|:----:|:----:|:----:|:----:|
| 0 | 3 | 10 | 240 | 13 | 224 | 0 |
| 0% | 1% | 2% | 49% | 3% | 46% | 0% |

**Note:** The following loglevels were omitted in this report:
* **SKIP**
* **INFO**
* **PASS**
* **DEBUG**
