const faq = [
  {
    id: 'faq-who-is-this-book-for',
    question: 'Who is this book for?',
    answer: `This book is for developers and software architects who have some prior knowledge of JavaScript and Node.js
and now want to get the most out of these technologies in terms of productivity, design quality, and scalability.
Software professionals with intermediate experience in Node.js and JavaScript will also find valuable the more advanced
patterns and techniques presented in this book.`
  },
  {
    id: 'faq-is-this-book-for-me',
    question: 'I am new to JavaScript and Node.js, is this book for me?',
    answer: `This book assumes that you have an intermediate understanding of JavaScript, web application development,
databases, and software design principles. If you are new to JavaScript but you are familiar with other languages and
technologies this book can still be a valuable resource for you but we do recommend you to get familiar with the
basics of JavaScript first.
Some good FREE resources you could check out are [Eloquent JavaScript](https://eloquentjavascript.net),
[JavaScript introduction by W3C](https://www.edx.org/course/javascript-introduction) and
[JavaScript in 30 days](https://javascript30.com/).`
  },
  {
    id: 'faq-main-topics',
    question: 'What are the main topics I will learn in this book?',
    answer: `This book will get you comfortable with writing asynchronous code by leveraging **callbacks**, **promises**,
and the **async/await** syntax. It will teach you how to leverage Node.js **streams** to create data-driven asynchronous processing pipelines,
how to implement well-known software design patterns to create production grade applications, and how to share code between Node.js 
and the browser, taking full advantage of full-stack JavaScript. Finally, this book will show you how to build and scale 
**microservices** and **distributed systems** powered by Node.js and how to use Node.js in conjunction with other powerful
technologies such as Redis, RabbitMQ, ZeroMQ, and LevelDB.`
  },
  {
    id: 'faq-download-for-free',
    question: 'Can I download Node.js Design Patterns for FREE?',
    answer: `**No**. Node.js Design Patterns is the result of countless hours of hard work by the authors, the reviewers, and 
many professionals at Packt, so we simply can't afford to give it away for free. If you want to have a feeling about the
quality of the content in the book, you can [download Chapter 9: Behavioural Design Patterns](#sample-chapter) for FREE.
You can also check out for FREE all the code examples available in the book on
[the official GitHub repository](https://github.com/PacktPublishing/Node.js-Design-Patterns-Third-Edition).`
  },
  {
    id: 'faq-book-length',
    question: 'How long is the book?',
    answer: 'The book has 13 chapters totaling about 660 pages.'
  },
  {
    id: 'faq-should-i-read-660-pages',
    question: 'Do I have to read all 660 pages to make sense of the book?',
    answer: `The book was written to give you continuity throughout the chapters so that you can enjoy reading the book from 
the first to the very last page. Although, if you are already familiar with many Node.js concepts and design patterns, 
you can easily skim through the chapters and focus only on the content that matters the most to you. Check out the 
[Table of Contents](#book-chapters) if you want to have a better feeling on how the book is structured.`
  },
  {
    id: 'faq-full-list-of-patterns',
    question: 'What are all the patterns discussed in the book?',
    answer: `The central part of the book covers the most traditional design patterns from the gang of four book, but it also covers many other design patterns that are specific to JavaScript and Node.js.
    This is the full list of patterns covered in the book: **Factory**, **Builder**, **Revealing Constructor**, **Singleton**, **Dependency Injection**, **Proxy**, **Decorator**, **Adapter**, **Strategy**, **State**, **Template**, **Iterator** (including generators and async iterators), **Middleware**, and **Command**.`
  },
  {
    id: 'faq-is-it-up-to-date',
    question: 'How up to date is this book?',
    answer: `The third edition of this book (released in **July 2020**) has been updated to cover the features of the most 
recent Node.js LTS version (**Node.js 14**). Node.js Design Patterns (third edition) leverages modern best practices and 
Node.js features such as **Async/Await** and **EcmaScript Modules (ESM)**.`
  },
  {
    id: 'faq-code-examples-online',
    question: 'Are the code examples available online?',
    answer: 'All the code examples contained in the book are [available on GitHub](https://github.com/PacktPublishing/Node.js-Design-Patterns-Third-Edition) and can be accessed for FREE.'
  },
  {
    id: 'faq-real-life-applications',
    question: 'What are some examples of real-life applications that are presented in the book?',
    answer: `Node.js Design Patterns provides a mix of simple examples and real-life applications to gradually 
introduce you to new topics and patterns. Some examples of real-life applications are:

- Your own module loader
- A website spider and downloader
- A streaming file archive pipeline
- A plugin for LevelUp
- A full stack universal JavaScript website with Fastify, React and Webpack
- A dynamic HTTP load balancer using Consul
- A peer-to-peer network for web services
- A distributed real-time chat application with an interactive web UI which leverages ZeroMQ, RabbitMQ and Redis Streams
- A worker pool for background job executions using ZeroMQ, RabbitMQ and Redis Streams

You can checkout the source code for these examples for FREE [on GitHub](https://github.com/PacktPublishing/Node.js-Design-Patterns-Third-Edition).`
  },
  {
    id: 'faq-practice',
    question: 'How can I practice the learnings from the book?',
    answer: `Every chapter comes with a set of engaging coding challenges and exercises crafted to put your new learnings
into practice. Node.js Design Patterns contains 50 exercises in total.`
  },
  {
    id: 'faq-more-questions',
    question: 'I have more questions!',
    answer: `You are more than welcome to reach out to the authors on X 
([@mariocasciaro](https://twitter.com/mariocasciaro) and [@loige](https://twitter.com/loige)) or you can write an email to 
[authors@nodejsdesignpatterns.com](mailto:authors@nodejsdesignpatterns.com).`
  }
]

export default faq
