---
title: Contributing
...

# Technical Steering Committee

Technical Steering Committee (TSC) is responsible for overseeing all technical aspects of the project, NNStreamer, and its subsidiary projects in the same Github organization.

The initial TSC voting members are the committers of NNStreamer at the time of the first TSC meeting. Election or removal of TSC voting members should be approved by TSC voting. Except for approvals of license exceptions and the community charger amendments, approval of TSC voting requires approvals of more than half of present TSC voting members in a TSC meeting, which requires to have at least the half of the voting members present in the TSC meeting. Approvals of electronic TSC voting requires approvals of more than half of all TSC voting members. TSC may elect or replace the chairperson of the project with TSC voting.

With unresolvable issues with TSC voting, a TSC voting member may inquire about the issues to the Linux Foundation Series managers.

Each TSC voting member including a chairperson or its deputy has a single vote in TSC voting.

The TSC voting members are:

* MyungJoo Ham @myungjoo
* Jijoong Moon @jijoongmoon
* Geunsik Lim @leemgs
* Jaeyun Jung @jaeyun-jung
* Sangjung Woo @again4you
* Wook Song @wooksong
* Dongju Chae @dongju-chae
* HyoungJoo Ahn @helloahn
* Parichay Kapoor @kparichay
* Gichan Jang @gichan-jang
* Yongjoo Ahn @anyj0527
* Jihoon Lee @zhoonit


## TSC Meeting


A TSC meeting is required to be publicly announced (at least 10 days before the meeting) and publicly accessible. A chairperson or its deputy, who is designated by a chairperson or the former chairperson, may announce and hold a TSC meeting. A deputy designated by a former resigning chairperson should hold a TSC meeting to elect a new chairperson and is relieved automatically by electing a new chairperson.

A TSC meeting should be announced via the nnstreamer-announce LFAI mailing list (the mailing list). Other media (GitHub issues, gitter.im, social media, LFAI event calendar, and so on) may also be used along with the mailing list.

A TSC meeting should be held at a publicly accessible place. A TSC meeting is, by default, held conventionally (offline meeting) in a place where the chairperson or its deputy has announced. However, alternatively, a TSC meeting may be held virtually (audio or video conference) with publicly available media that are declared with the meeting announcement. A conventionally-held TSC meeting may include audio or video conferences to help those who cannot present physically.

A TSC meeting is, by default, recorded or scripted for the general public. The URLs or the contents of the recordings or scripts should be available via the mailing list. Alternatively, a live video stream may be broadcasted via methods declared by the mailing list.

In the case of the unavailability of the mailing list, a pinned GitHub issue of https://github.com/nnstreamer/nnstreamer can be used instead.


## Unavailability of a Chairperson or its Deputy
A chairperson should assign its deputy or hold a TSC meeting to elect a successor when he/she resigns.

If there is no chairperson or its deputy available, the most senior among available committers may and should announce and hold a TSC meeting to elect a chairperson. An available committer is a committer who has been submitting code commits or code reviews to the main project (nnstreamer.git) during the last 30 days. A senior committer is a committer who has committed codes to the main GitHub project (nnstreamer.git) before other available committers. Unavailability of chairperson and deputy can be declared via the mailing-list by a committer. The unavailability declaration becomes effective after the declaring committer tries to contact the chairperson or deputy personally, the declaration is acknowledged by other two or more committers, and there are no responses from chairperson or deputy via the mailing list or GitHub issues of the main project (nnstreamer.git) within 30 days. With the effective unavailability declaration, the most senior among available committers automatically becomes the deputy who holds the TSC meeting to elect a chairperson within the next 30 days. If the available senior committer fails to do this within the given 30 days after the effective declaration, the Linux Foundation Series manager may designate any TSC voting member of committer as a deputy chairperson and any TSC voting member or committer may contact Linux Foundation to initiate this process.



## Contributors

Anyone who has been contributed to the repository by submitting a pull-request and have it reviewed, accepted, and merged by committers is a contributor.

Each contributor should comply with the [Code of Conduct](CODE_OF_CONDUCT.md), this document (CONTRIBUTING.md), and [the Linux Foundation's policies](https://lfprojects.org/policies/).

Every contributor is able and encouraged to review codes and to participate in other developmental activities.



## Committers

A committer is responsible for reviewing incoming pull-requests and is able to reject or approve pull requests. Note that contributors may review pull-requests, but they cannot reject it or vote for approval.

A contributor may become a committer with approvals of more than half of the committers.

A committer may be retired by approvals of more than half of the committers.

Alternatively, TSC may decide to elect or to retire a committer with TSC voting as well or amend the rules on how to elect/retire committers.

Each committer is also a contributor and should comply with the [Code of Conduct](CODE_OF_CONDUCT.md), this document (CONTRIBUTING.md), and [the Linux Foundation's policies](https://lfprojects.org/policies/).

The committers are:

* MyungJoo Ham @myungjoo :beer: (maintainer)
* Jijoong Moon @jijoongmoon :beer:
* Geunsik Lim @leemgs :beer:
* Jaeyun Jung @jaeyun-jung :beer:
* Sangjung Woo @again4you :beer:
* Wook Song @wooksong :beer:
* Dongju Chae @dongju-chae :beer:
* HyoungJoo Ahn @helloahn :beer:
* Parichay Kapoor @kparichay :beer:
* Gichan Jang @gichan-jang
* Yongjoo Ahn @anyj0527
* Jihoon Lee @zhoonit


## Merging a pull-request

[How to Contribute # Merge Criteria](Documentation/contributing.md#merge-criteria) describes how a pull-request may be merged or rejected by committers.

In the above list, committers with :beer: have merging privilege.

Granting or revoking merging privileges require the same procedure of electing or retiring a committer.

A maintainer [Maintainers](MAINTAINERS.md#maintainer) is designated by TSC among committers.

Each sub-project may have its own maintainer in the sub-project.


# Links to related information

## Contributing

See [How to Contribute](Documentation/contributing.md) for information about coding styles, making pull requests, and more.

## Developers

- See [Getting Started](Documentation/getting-started.md) for information about building this software.
- See [How to Run Examples](Documentation/how-to-run-examples.md) for information about building and running examples applications.
- See [How to Use Testcases](Documentation/how-to-use-testcases.md) for information about running test cases and writing ones.
