	.386
	.model use16 large SHARED

include pc98.inc
include libs/master.lib/macros.inc
include th04/hardware/grppsafx.inc

	.code SHARED

public GRAPH_PUTSA_FX
graph_putsa_fx	proc far

@@str  	= dword	ptr  6
@@color	= word ptr  0Ah
@@y    	= word ptr  0Ch
@@x    	= word ptr  0Eh

	@@line	equ <ch>

	push	bp
	mov	bp, sp
	push	si
	push	di
	push	ds
	mov	dx, [bp+@@color]
	GRCG_NOINT_SETMODE_VIA_MOV al, GC_RMW
	GRCG_SETCOLOR_DIRECT dx
	mov	ax, GRAM_400
	mov	es, ax
	assume es:nothing
	mov	dx, [bp+@@y]
	shl	dx, 6
	mov	di, dx
	shr	dx, 2
	add	di, dx
	mov	cx, [bp+@@x]
	mov	al, 0Bh
	out	68h, al
	mov	bx, _graph_putsa_fx_func
	add	bx, bx
	cmp	bx, (FX_MASK * word)
	jb	short @@not_masking
	cmp	bx, (FX_MASK_END * word)
	jnb	short @@not_masking

	mov	ax, (GLYPH_MASK_TABLE - (FX_MASK * word))[bx]
	mov	word ptr cs:grppsafx_glyph_mask, ax
	mov	bx, (FX_MASK * word) ; offset of the [glyph_bold_and_mask] offset

@@not_masking:
	mov	ax, GLYPH_WEIGHT_FUNC_TABLE_1[bx]
	mov	word ptr cs:grppsafx_glyph_func_1, ax

	mov	ax, GLYPH_WEIGHT_FUNC_TABLE_2[bx]
	mov	word ptr cs:grppsafx_glyph_func_2, ax

	mov	ax, _graph_putsa_fx_spacing
	mov	word ptr cs:grppsafx_glyph_spacing_1, ax
	mov	word ptr cs:grppsafx_glyph_spacing_2, ax
	push	ds
	pop	fs
	assume fs:_DATA
	lds	si, [bp+@@str]
	lodsb
	or	al, al
	jz	short @@EXITLOOP

@@SLOOP:
	mov	dx, cx
	shr	dx, 3
	add	di, dx
	and	cx, 7
	mov	ah, 9
	test	al, 0E0h
	jns	short @@ANK_OR_RIGHT
	jp	short @@NOT_ANK_BUT_RIGHT

@@KANJI:	mov	ah, al
		lodsb
		shl	ah, 1
		cmp	al, 9Fh
		jnb	short @@SKIP
			cmp	al, 80h
			adc	ax, 0FEDFh
@@SKIP:			sbb	al, 0FEh

	and	ax, 7F7Fh
	out	0A1h, al
	mov	al, ah
	out	0A3h, al
	nop

@@graph_double_loop_kanji:
	mov	al, @@line
	or	al, 20h
	out	0A5h, al
	in	al, 0A9h
	mov	ah, al
	mov	al, @@line
	out	0A5h, al
	in	al, 0A9h

grppsafx_glyph_func_1 equ $+1
	call	glyph_weight_bold
	mov	bh, al
	mov	bl, 0
	shr	ax, cl
	shr	bx, cl
	xchg	ah, al
	stosw
	mov	es:[di], bl
	add	di, ROW_SIZE - 2
	inc	@@line
	cmp	@@line, GLYPH_H
	jb	short @@graph_double_loop_kanji
	sub	di, ROW_SIZE * GLYPH_H

grppsafx_glyph_spacing_1 equ $+1
	mov	dx, 1234h

@@next_char:
	xor	@@line, @@line
	add	cx, dx
	lodsb
	or	al, al
	jnz	short @@SLOOP

@@EXITLOOP:
	mov	al, 0Ah
	out	68h, al
	GRCG_OFF_VIA_XOR al
	pop	ds
	pop	di
	pop	si
	pop	bp
	retf	0Ah
; ---------------------------------------------------------------------------

@@NOT_ANK_BUT_RIGHT:
	add	ax, 80h

@@ANK_OR_RIGHT:
	cmp	al, ' '
	jz	short @@dont_print_space

	out	0A1h, al
	mov	al, ah
	out	0A3h, al
	nop

@@graph_double_loop_ank:
	mov	al, @@line
	or	al, 20h
	out	0A5h, al

	; ZUN bug: In contrast to the C++ version, this one stores halfwidth glyphs
	; in the low byte of a 16-dot variable rather than the high one. While this
	; seems better because it preserves additional dots generated by the weight
	; functions (and especially FX_WEIGHT_BLACK) in the high byte, it only works
	; for non-aligned [x] positions where these dots are ROR'd back into place.
	; For byte-aligned [x] positions, they remain in their original position
	; within the high byte, and appear on screen as glitches, 15 pixels to the
	; right of the glyph they belong to.
	in	al, 0A9h
	xor	ah, ah

grppsafx_glyph_func_2 equ $+1
	call	glyph_weight_bold
	ror	ax, cl
	stosw
	add	di, ROW_SIZE - 2
	inc	@@line
	cmp	@@line, GLYPH_H
	jb	short @@graph_double_loop_ank
	sub	di, ROW_SIZE * GLYPH_H

@@dont_print_space:
grppsafx_glyph_spacing_2 equ $+1
	mov	dx, 1234h
	shr	dx, 1
	jmp	short @@next_char
graph_putsa_fx	endp
	even

; Weight functions
; ----------------
; Directly applied to the 16-dot glyph [row].

row	equ <ax>
tmp	equ <dx>

glyph_weight_heavy	label near
	mov	tmp, row
	add	tmp, tmp
	or	row, tmp
glyph_weight_normal	label near
	retn

glyph_weight_black	label near
	mov	tmp, row
	shl	tmp, 1
	or	row, tmp
glyph_weight_bold	label near
	mov	tmp, row
	mov	bp, row
	add	bp, bp
	or	row, bp
	xor	tmp, row
	add	tmp, tmp
	not	tmp
	and	row, tmp
	retn

glyph_bold_and_mask	proc near
	call	glyph_weight_bold
	mov	bl, ch
	and	bx, 3
	add	bx, bx

grppsafx_glyph_mask equ $+3
	and	row, fs:[bx+1234h]
	retn
glyph_bold_and_mask	endp
; ----------------

	.data

GLYPH_WEIGHT_FUNC_TABLE_1 label word
	dw (glyph_weight_normal - (grppsafx_glyph_func_1 + 2))
	dw (glyph_weight_heavy  - (grppsafx_glyph_func_1 + 2))
	dw (glyph_weight_bold   - (grppsafx_glyph_func_1 + 2))
	dw (glyph_weight_black  - (grppsafx_glyph_func_1 + 2))
	dw (glyph_bold_and_mask - (grppsafx_glyph_func_1 + 2))

GLYPH_WEIGHT_FUNC_TABLE_2 label word
	dw (glyph_weight_normal - (grppsafx_glyph_func_2 + 2))
	dw (glyph_weight_heavy  - (grppsafx_glyph_func_2 + 2))
	dw (glyph_weight_bold   - (grppsafx_glyph_func_2 + 2))
	dw (glyph_weight_black  - (grppsafx_glyph_func_2 + 2))
	dw (glyph_bold_and_mask - (grppsafx_glyph_func_2 + 2))

GLYPH_MASK_TABLE label word
	dw _grppsafx_mask_1
	dw _grppsafx_mask_2
	dw _grppsafx_mask_3
	dw _grppsafx_mask_4

_grppsafx_mask_1 dw  8888h,    0h,  2222h,    0h
_grppsafx_mask_2 dw  8888h, 4444h,  2222h, 1111h
_grppsafx_mask_3 dw 0AAAAh, 4444h, 0AAAAh, 1111h
_grppsafx_mask_4 dw 0AAAAh, 5555h, 0AAAAh, 5555h

public _graph_putsa_fx_func, _graph_putsa_fx_spacing
_graph_putsa_fx_func   	dw FX_WEIGHT_BOLD
_graph_putsa_fx_spacing	dw 16

	end
