#include "pc98.h"
#include "shiftjis.hpp"

#define STAGEBONUS_TITLE_PREFIX "rs`fd@"

// The fullwidth stage number is directly inserted into the single static copy
// of this string.
#define stagebonus_title STAGEBONUS_TITLE_PREFIX "@@@bnlokdsd"

struct stagebonus_title_t {
	ShiftJISKanji prefix[(sizeof(STAGEBONUS_TITLE_PREFIX) - 1) / 2];
	ShiftJISKanji stage[2];
	ShiftJISKanji suffix[];
};

// ZUN bloat: Same here for all rendered fullwidth numbers. This constant seems
// to do us a favor by pre-filling the constant ones digit and the trailing
// space, but the game overwrites it anyway, making it entirely pointless.
#define stagebonus_digit_buf "@@@@O@"

#define STAGEBONUS_SUBTITLE     	"@@anmtr"
#define STAGEBONUS_TIME         	"   @s@"
#define STAGEBONUS_CARDCOMBO_MAX	"b"
#define STAGEBONUS_RESOURCES    	"ao"
#define STAGEBONUS_STAGE_NUMBER 	"@@rs`fd"
#define STAGEBONUS_TOTAL        	"anmtr@o"
#define STAGEBONUS_HIT_KEY      	"g@y@j"

static const pixel_t STAGEBONUS_TITLE_W = shiftjis_w(stagebonus_title);

// TRANSLATORS: Replace with your longest string.
static const pixel_t STAGEBONUS_LABEL_W = shiftjis_w(STAGEBONUS_TOTAL);

static const pixel_t STAGEBONUS_METRIC_ROW_W = (
	STAGEBONUS_LABEL_W + GLYPH_FULL_W + shiftjis_w(stagebonus_digit_buf)
);

static const pixel_t STAGEBONUS_W = (
	(STAGEBONUS_TITLE_W > STAGEBONUS_METRIC_ROW_W)
		? STAGEBONUS_TITLE_W
		: STAGEBONUS_METRIC_ROW_W
);
