// Function numbers for the SPRITE16.COM driver, according to SPRITE16.DOC.
// Refer to this file for the actual documentation on the functions itself,
// the comments here only provide additional context.
// Only includes functions that are actually used in TH03.

#include "planar.h"
#include "x86real.h"

#define SPRITE16 0x42

typedef enum {
	// Derives SPRITE16's internal alpha masks used for monochrome and
	// overlapped drawing from the sprite data area in VRAM. Should
	// consequently be called after every change to that area.
	SPRITE16_GENERATE_ALPHA = 1,
	SPRITE16_PUT = 2,
	SPRITE16_SET_MONO = 3,
	SPRITE16_SET_COLOR = 4,
	// Determines whether the VRAM area that will be occupied by newly drawn
	// sprites will be
	// • cleared using the alpha mask generated by SPRITE16_GENERATE_ALPHA
	//   before drawing (DX = OVERLAP_CLEAR, default)
	// • or left as is, with the bits of the new sprite being ORed on top of
	//   the existing VRAM content, separately on every individual bitplane
	//   (DX = OVERLAP_OR). This will consequently produce interesting colors
	//   wherever two sprites overlap.
	// This setting is ignored when in monochrome mode, which always touches
	// all bitplanes according to the alpha mask, identical to monochrome
	// blitting using the GRCG in RMW mode (e.g. using master.lib's
	// grcg_setcolor()).
	SPRITE16_SET_OVERLAP = 5,
	SPRITE16_SET_MASK = 8
} sprite16_func_t;

typedef enum {
	OVERLAP_CLEAR = 1,
	OVERLAP_OR = 0
} sprite16_overlap_t;

static const vram_y_t SPRITE16_RES_Y = 200;
static const vram_byte_amount_t SPRITE16_PLANE_SIZE = (
	SPRITE16_RES_Y * ROW_SIZE
);
static const vram_offset_t SPRITE16_OFFSET = SPRITE16_PLANE_SIZE;

inline void sprite16_mono(bool enable) {
	_AH = SPRITE16_SET_MONO;
	_DX = enable;
	geninterrupt(SPRITE16);
}

// ZUN bloat: Remove.
inline void sprite16_mono_(bool enable) {
	_DX = enable;
	_AH = SPRITE16_SET_MONO;
	geninterrupt(SPRITE16);
}

#define sprite16_mono_color(col) { \
	_AH = SPRITE16_SET_COLOR; \
	_DX = col; \
	geninterrupt(SPRITE16); \
}
