// Code generated by command: go run sum_asm.go -out ../../matfuncs/sum_amd64.s -stubs ../../matfuncs/sum_amd64_stubs.go -pkg matfuncs. DO NOT EDIT.

//go:build amd64 && gc && !purego

#include "textflag.h"

// func SumAVX32(x []float32) float32
// Requires: AVX, SSE
TEXT ·SumAVX32(SB), NOSPLIT, $0-28
	MOVQ   x_base+0(FP), AX
	MOVQ   x_len+8(FP), CX
	VXORPS Y0, Y0, Y0
	VXORPS Y1, Y1, Y1

unrolledLoop14:
	CMPQ   CX, $0x00000070
	JL     unrolledLoop8
	VADDPS (AX), Y0, Y0
	VADDPS 32(AX), Y1, Y1
	VADDPS 64(AX), Y0, Y0
	VADDPS 96(AX), Y1, Y1
	VADDPS 128(AX), Y0, Y0
	VADDPS 160(AX), Y1, Y1
	VADDPS 192(AX), Y0, Y0
	VADDPS 224(AX), Y1, Y1
	VADDPS 256(AX), Y0, Y0
	VADDPS 288(AX), Y1, Y1
	VADDPS 320(AX), Y0, Y0
	VADDPS 352(AX), Y1, Y1
	VADDPS 384(AX), Y0, Y0
	VADDPS 416(AX), Y1, Y1
	ADDQ   $0x000001c0, AX
	SUBQ   $0x00000070, CX
	JMP    unrolledLoop14

unrolledLoop8:
	CMPQ   CX, $0x00000040
	JL     unrolledLoop4
	VADDPS (AX), Y0, Y0
	VADDPS 32(AX), Y1, Y1
	VADDPS 64(AX), Y0, Y0
	VADDPS 96(AX), Y1, Y1
	VADDPS 128(AX), Y0, Y0
	VADDPS 160(AX), Y1, Y1
	VADDPS 192(AX), Y0, Y0
	VADDPS 224(AX), Y1, Y1
	ADDQ   $0x00000100, AX
	SUBQ   $0x00000040, CX
	JMP    unrolledLoop8

unrolledLoop4:
	CMPQ   CX, $0x00000020
	JL     unrolledLoop1
	VADDPS (AX), Y0, Y0
	VADDPS 32(AX), Y1, Y1
	VADDPS 64(AX), Y0, Y0
	VADDPS 96(AX), Y1, Y1
	ADDQ   $0x00000080, AX
	SUBQ   $0x00000020, CX
	JMP    unrolledLoop4

unrolledLoop1:
	CMPQ   CX, $0x00000008
	JL     tail
	VADDPS (AX), Y0, Y0
	ADDQ   $0x00000020, AX
	SUBQ   $0x00000008, CX
	JMP    unrolledLoop1

tail:
	VXORPS X2, X2, X2

tailLoop:
	CMPQ   CX, $0x00000000
	JE     reduce
	VADDSS (AX), X2, X2
	ADDQ   $0x00000004, AX
	DECQ   CX
	JMP    tailLoop

reduce:
	VADDPS       Y0, Y1, Y0
	VEXTRACTF128 $0x01, Y0, X1
	VADDPS       X0, X1, X0
	VADDPS       X0, X2, X0
	VHADDPS      X0, X0, X0
	VHADDPS      X0, X0, X0
	MOVSS        X0, ret+24(FP)
	RET

// func SumAVX64(x []float64) float64
// Requires: AVX, SSE2
TEXT ·SumAVX64(SB), NOSPLIT, $0-32
	MOVQ   x_base+0(FP), AX
	MOVQ   x_len+8(FP), CX
	VXORPD Y0, Y0, Y0
	VXORPD Y1, Y1, Y1

unrolledLoop14:
	CMPQ   CX, $0x00000038
	JL     unrolledLoop8
	VADDPD (AX), Y0, Y0
	VADDPD 32(AX), Y1, Y1
	VADDPD 64(AX), Y0, Y0
	VADDPD 96(AX), Y1, Y1
	VADDPD 128(AX), Y0, Y0
	VADDPD 160(AX), Y1, Y1
	VADDPD 192(AX), Y0, Y0
	VADDPD 224(AX), Y1, Y1
	VADDPD 256(AX), Y0, Y0
	VADDPD 288(AX), Y1, Y1
	VADDPD 320(AX), Y0, Y0
	VADDPD 352(AX), Y1, Y1
	VADDPD 384(AX), Y0, Y0
	VADDPD 416(AX), Y1, Y1
	ADDQ   $0x000001c0, AX
	SUBQ   $0x00000038, CX
	JMP    unrolledLoop14

unrolledLoop8:
	CMPQ   CX, $0x00000020
	JL     unrolledLoop4
	VADDPD (AX), Y0, Y0
	VADDPD 32(AX), Y1, Y1
	VADDPD 64(AX), Y0, Y0
	VADDPD 96(AX), Y1, Y1
	VADDPD 128(AX), Y0, Y0
	VADDPD 160(AX), Y1, Y1
	VADDPD 192(AX), Y0, Y0
	VADDPD 224(AX), Y1, Y1
	ADDQ   $0x00000100, AX
	SUBQ   $0x00000020, CX
	JMP    unrolledLoop8

unrolledLoop4:
	CMPQ   CX, $0x00000010
	JL     unrolledLoop1
	VADDPD (AX), Y0, Y0
	VADDPD 32(AX), Y1, Y1
	VADDPD 64(AX), Y0, Y0
	VADDPD 96(AX), Y1, Y1
	ADDQ   $0x00000080, AX
	SUBQ   $0x00000010, CX
	JMP    unrolledLoop4

unrolledLoop1:
	CMPQ   CX, $0x00000004
	JL     tail
	VADDPD (AX), Y0, Y0
	ADDQ   $0x00000020, AX
	SUBQ   $0x00000004, CX
	JMP    unrolledLoop1

tail:
	VXORPD X2, X2, X2

tailLoop:
	CMPQ   CX, $0x00000000
	JE     reduce
	VADDSD (AX), X2, X2
	ADDQ   $0x00000008, AX
	DECQ   CX
	JMP    tailLoop

reduce:
	VADDPD       Y0, Y1, Y0
	VEXTRACTF128 $0x01, Y0, X1
	VADDPD       X0, X1, X0
	VADDPD       X0, X2, X0
	VHADDPD      X0, X0, X0
	MOVSD        X0, ret+24(FP)
	RET

// func SumSSE32(x []float32) float32
// Requires: SSE, SSE3
TEXT ·SumSSE32(SB), NOSPLIT, $0-28
	MOVQ  x_base+0(FP), AX
	MOVQ  x_len+8(FP), CX
	XORPS X0, X0
	XORPS X1, X1
	CMPQ  CX, $0x00000000
	JE    reduce
	MOVQ  AX, DX
	ANDQ  $0x0000000f, DX
	JZ    unrolledLoops
	XORQ  $0x0000000f, DX
	INCQ  DX
	SHRQ  $0x02, DX

alignmentLoop:
	MOVSS (AX), X2
	ADDSS X2, X0
	ADDQ  $0x00000004, AX
	DECQ  CX
	JZ    reduce
	DECQ  DX
	JNZ   alignmentLoop

unrolledLoops:
unrolledLoop14:
	CMPQ  CX, $0x00000038
	JL    unrolledLoop8
	ADDPS (AX), X0
	ADDPS 16(AX), X1
	ADDPS 32(AX), X0
	ADDPS 48(AX), X1
	ADDPS 64(AX), X0
	ADDPS 80(AX), X1
	ADDPS 96(AX), X0
	ADDPS 112(AX), X1
	ADDPS 128(AX), X0
	ADDPS 144(AX), X1
	ADDPS 160(AX), X0
	ADDPS 176(AX), X1
	ADDPS 192(AX), X0
	ADDPS 208(AX), X1
	ADDQ  $0x000000e0, AX
	SUBQ  $0x00000038, CX
	JMP   unrolledLoop14

unrolledLoop8:
	CMPQ  CX, $0x00000020
	JL    unrolledLoop4
	ADDPS (AX), X0
	ADDPS 16(AX), X1
	ADDPS 32(AX), X0
	ADDPS 48(AX), X1
	ADDPS 64(AX), X0
	ADDPS 80(AX), X1
	ADDPS 96(AX), X0
	ADDPS 112(AX), X1
	ADDQ  $0x00000080, AX
	SUBQ  $0x00000020, CX
	JMP   unrolledLoop8

unrolledLoop4:
	CMPQ  CX, $0x00000010
	JL    unrolledLoop1
	ADDPS (AX), X0
	ADDPS 16(AX), X1
	ADDPS 32(AX), X0
	ADDPS 48(AX), X1
	ADDQ  $0x00000040, AX
	SUBQ  $0x00000010, CX
	JMP   unrolledLoop4

unrolledLoop1:
	CMPQ  CX, $0x00000004
	JL    tailLoop
	ADDPS (AX), X0
	ADDQ  $0x00000010, AX
	SUBQ  $0x00000004, CX
	JMP   unrolledLoop1

tailLoop:
	CMPQ  CX, $0x00000000
	JE    reduce
	ADDSS (AX), X0
	ADDQ  $0x00000004, AX
	DECQ  CX
	JMP   tailLoop

reduce:
	ADDPS  X1, X0
	HADDPS X0, X0
	HADDPS X0, X0
	MOVSS  X0, ret+24(FP)
	RET

// func SumSSE64(x []float64) float64
// Requires: SSE2, SSE3
TEXT ·SumSSE64(SB), NOSPLIT, $0-32
	MOVQ  x_base+0(FP), AX
	MOVQ  x_len+8(FP), CX
	XORPD X0, X0
	XORPD X1, X1
	CMPQ  CX, $0x00000000
	JE    reduce
	MOVQ  AX, DX
	ANDQ  $0x0000000f, DX
	JZ    unrolledLoops
	MOVSD (AX), X2
	ADDSD X2, X0
	ADDQ  $0x00000008, AX
	DECQ  CX

unrolledLoops:
unrolledLoop14:
	CMPQ  CX, $0x0000001c
	JL    unrolledLoop8
	ADDPD (AX), X0
	ADDPD 16(AX), X1
	ADDPD 32(AX), X0
	ADDPD 48(AX), X1
	ADDPD 64(AX), X0
	ADDPD 80(AX), X1
	ADDPD 96(AX), X0
	ADDPD 112(AX), X1
	ADDPD 128(AX), X0
	ADDPD 144(AX), X1
	ADDPD 160(AX), X0
	ADDPD 176(AX), X1
	ADDPD 192(AX), X0
	ADDPD 208(AX), X1
	ADDQ  $0x000000e0, AX
	SUBQ  $0x0000001c, CX
	JMP   unrolledLoop14

unrolledLoop8:
	CMPQ  CX, $0x00000010
	JL    unrolledLoop4
	ADDPD (AX), X0
	ADDPD 16(AX), X1
	ADDPD 32(AX), X0
	ADDPD 48(AX), X1
	ADDPD 64(AX), X0
	ADDPD 80(AX), X1
	ADDPD 96(AX), X0
	ADDPD 112(AX), X1
	ADDQ  $0x00000080, AX
	SUBQ  $0x00000010, CX
	JMP   unrolledLoop8

unrolledLoop4:
	CMPQ  CX, $0x00000008
	JL    unrolledLoop1
	ADDPD (AX), X0
	ADDPD 16(AX), X1
	ADDPD 32(AX), X0
	ADDPD 48(AX), X1
	ADDQ  $0x00000040, AX
	SUBQ  $0x00000008, CX
	JMP   unrolledLoop4

unrolledLoop1:
	CMPQ  CX, $0x00000002
	JL    tailLoop
	ADDPD (AX), X0
	ADDQ  $0x00000010, AX
	SUBQ  $0x00000002, CX
	JMP   unrolledLoop1

tailLoop:
	CMPQ  CX, $0x00000000
	JE    reduce
	ADDSD (AX), X0
	ADDQ  $0x00000008, AX
	DECQ  CX
	JMP   tailLoop

reduce:
	ADDPD  X1, X0
	HADDPD X0, X0
	MOVSD  X0, ret+24(FP)
	RET
