/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.zaxxer.hikari.util;

import java.io.File;
import java.lang.reflect.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import shaded.com.zaxxer.hikari.proxy.CallableStatementProxy;
import shaded.com.zaxxer.hikari.proxy.ConnectionProxy;
import shaded.com.zaxxer.hikari.proxy.PreparedStatementProxy;
import shaded.com.zaxxer.hikari.proxy.ResultSetProxy;
import shaded.com.zaxxer.hikari.proxy.StatementProxy;

public final class JavassistProxyFactory {
    private static ClassPool classPool;
    private static String outputPrefix;

    public static void main(String ... args) {
        outputPrefix = args[0] + File.separator + "target" + File.separator + "classes";
        classPool = new ClassPool();
        classPool.importPackage("java.sql");
        classPool.appendClassPath((ClassPath)new LoaderClassPath(JavassistProxyFactory.class.getClassLoader()));
        try {
            String methodBody = "{ try { return delegate.method($$); } catch (SQLException e) { throw checkException(e); } }";
            JavassistProxyFactory.generateProxyClass(Connection.class, ConnectionProxy.class.getName(), methodBody);
            JavassistProxyFactory.generateProxyClass(Statement.class, StatementProxy.class.getName(), methodBody);
            JavassistProxyFactory.generateProxyClass(ResultSet.class, ResultSetProxy.class.getName(), methodBody);
            methodBody = "{ try { return ((cast) delegate).method($$); } catch (SQLException e) { throw checkException(e); } }";
            JavassistProxyFactory.generateProxyClass(PreparedStatement.class, PreparedStatementProxy.class.getName(), methodBody);
            JavassistProxyFactory.generateProxyClass(CallableStatement.class, CallableStatementProxy.class.getName(), methodBody);
            JavassistProxyFactory.modifyProxyFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void modifyProxyFactory() throws Exception {
        System.out.println("Generating method bodies for com.zaxxer.hikari.proxy.ProxyFactory");
        String packageName = ConnectionProxy.class.getPackage().getName();
        CtClass proxyCt = classPool.getCtClass("shaded.com.zaxxer.hikari.proxy.ProxyFactory");
        for (CtMethod method : proxyCt.getMethods()) {
            String name = method.getName();
            if ("getProxyConnection".equals(name)) {
                method.setBody("{return new " + packageName + ".HikariConnectionProxy($$);}");
            }
            if ("getProxyStatement".equals(name)) {
                method.setBody("{return new " + packageName + ".HikariStatementProxy($$);}");
            }
            if ("getProxyPreparedStatement".equals(name)) {
                method.setBody("{return new " + packageName + ".HikariPreparedStatementProxy($$);}");
            }
            if ("getProxyCallableStatement".equals(name)) {
                method.setBody("{return new " + packageName + ".HikariCallableStatementProxy($$);}");
            }
            if (!"getProxyResultSet".equals(name)) continue;
            method.setBody("{return new " + packageName + ".HikariResultSetProxy($$);}");
        }
        proxyCt.writeFile(outputPrefix);
    }

    private static <T> void generateProxyClass(Class<T> primaryInterface, String superClassName, String methodBody) throws Exception {
        String newClassName = superClassName.replaceAll("(.+)\\.(\\w+)", "$1.Hikari$2");
        CtClass superCt = classPool.getCtClass(superClassName);
        CtClass targetCt = classPool.makeClass(newClassName, superCt);
        targetCt.setModifiers(16);
        System.out.println("Generating " + newClassName);
        targetCt.setModifiers(1);
        HashSet<String> superSigs = new HashSet<String>();
        for (CtMethod method : superCt.getMethods()) {
            if ((method.getModifiers() & 0x10) != 16) continue;
            superSigs.add(method.getName() + method.getSignature());
        }
        HashSet<String> methods = new HashSet<String>();
        Set<Class<?>> interfaces = JavassistProxyFactory.getAllInterfaces(primaryInterface);
        for (Class<?> intf : interfaces) {
            CtClass intfCt = classPool.getCtClass(intf.getName());
            targetCt.addInterface(intfCt);
            for (CtMethod intfMethod : intfCt.getDeclaredMethods()) {
                String signature = intfMethod.getName() + intfMethod.getSignature();
                if (superSigs.contains(signature) || methods.contains(signature) || JavassistProxyFactory.isDefaultMethod(intf, intfCt, intfMethod)) continue;
                methods.add(signature);
                CtMethod method = CtNewMethod.copy((CtMethod)intfMethod, (CtClass)targetCt, null);
                String modifiedBody = methodBody;
                CtMethod superMethod = superCt.getMethod(intfMethod.getName(), intfMethod.getSignature());
                if ((superMethod.getModifiers() & 0x400) != 1024) {
                    modifiedBody = modifiedBody.replace("((cast) ", "");
                    modifiedBody = modifiedBody.replace("delegate", "super");
                    modifiedBody = modifiedBody.replace("super)", "super");
                }
                modifiedBody = modifiedBody.replace("cast", primaryInterface.getName());
                modifiedBody = JavassistProxyFactory.isThrowsSqlException(intfMethod) ? modifiedBody.replace("method", method.getName()) : "{ return ((cast) delegate).method($$); }".replace("method", method.getName()).replace("cast", primaryInterface.getName());
                if (method.getReturnType() == CtClass.voidType) {
                    modifiedBody = modifiedBody.replace("return", "");
                }
                method.setBody(modifiedBody);
                targetCt.addMethod(method);
            }
        }
        targetCt.writeFile(outputPrefix);
    }

    private static boolean isThrowsSqlException(CtMethod method) {
        try {
            for (CtClass clazz : method.getExceptionTypes()) {
                if (!clazz.getSimpleName().equals("SQLException")) continue;
                return true;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isDefaultMethod(Class<?> intf, CtClass intfCt, CtMethod intfMethod) throws Exception {
        ArrayList paramTypes = new ArrayList();
        for (CtClass pt : intfMethod.getParameterTypes()) {
            paramTypes.add(JavassistProxyFactory.toJavaClass(pt));
        }
        return intf.getDeclaredMethod(intfMethod.getName(), paramTypes.toArray(new Class[paramTypes.size()])).toString().contains("default ");
    }

    private static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        HashSet interfaces = new HashSet();
        for (Class<?> intf : Arrays.asList(clazz.getInterfaces())) {
            if (intf.getInterfaces().length > 0) {
                interfaces.addAll(JavassistProxyFactory.getAllInterfaces(intf));
            }
            interfaces.add(intf);
        }
        if (clazz.getSuperclass() != null) {
            interfaces.addAll(JavassistProxyFactory.getAllInterfaces(clazz.getSuperclass()));
        }
        if (clazz.isInterface()) {
            interfaces.add(clazz);
        }
        return interfaces;
    }

    private static Class<?> toJavaClass(CtClass cls) throws Exception {
        if (cls.getName().endsWith("[]")) {
            return Array.newInstance(JavassistProxyFactory.toJavaClass(cls.getName().replace("[]", "")), 0).getClass();
        }
        return JavassistProxyFactory.toJavaClass(cls.getName());
    }

    private static Class<?> toJavaClass(String cn) throws Exception {
        if ("int".equals(cn)) {
            return Integer.TYPE;
        }
        if ("long".equals(cn)) {
            return Long.TYPE;
        }
        if ("short".equals(cn)) {
            return Short.TYPE;
        }
        if ("byte".equals(cn)) {
            return Byte.TYPE;
        }
        if ("float".equals(cn)) {
            return Float.TYPE;
        }
        if ("double".equals(cn)) {
            return Double.TYPE;
        }
        if ("boolean".equals(cn)) {
            return Boolean.TYPE;
        }
        if ("char".equals(cn)) {
            return Character.TYPE;
        }
        if ("void".equals(cn)) {
            return Void.TYPE;
        }
        return Class.forName(cn);
    }
}

