/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.zaxxer.hikari.proxy;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Wrapper;
import shaded.com.zaxxer.hikari.proxy.ConnectionProxy;

public abstract class ResultSetProxy
implements ResultSet {
    protected final ConnectionProxy connection;
    protected final ResultSet delegate;

    protected ResultSetProxy(ConnectionProxy connection, ResultSet resultSet) {
        this.connection = connection;
        this.delegate = resultSet;
    }

    protected final SQLException checkException(SQLException e) {
        return this.connection.checkException(e);
    }

    @Override
    public void updateRow() throws SQLException {
        this.connection.markCommitStateDirty();
        this.delegate.updateRow();
    }

    @Override
    public void insertRow() throws SQLException {
        this.connection.markCommitStateDirty();
        this.delegate.insertRow();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.connection.markCommitStateDirty();
        this.delegate.deleteRow();
    }

    @Override
    public final <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this.delegate)) {
            return (T)this.delegate;
        }
        if (this.delegate instanceof Wrapper) {
            return this.delegate.unwrap(iface);
        }
        throw new SQLException("Wrapped ResultSet is not an instance of " + iface);
    }
}

